/**
 ** On-Screen-Display for Noatun
 ** Copyright (c) 2001, Flaming Sword Productions
 ** All Rights Reserved under the BSD License
 **/
#ifndef KOSDH
#define KOSDH
#include <sys/types.h>
#include <qqueue.h>
#include <qobject.h>
#include <qtimer.h>
#include <qlabel.h>

// Nifty xosd replacement
class KOSD: public QLabel
{
Q_OBJECT

public:
	enum Status
	{
		Stopped = 0,
		Playing = 1,
		Paused = 2
	};

	enum HorizontalPosition
	{
		Top = 0,
		Center = 1,
		Bottom = 2
	};

	enum VerticalPosition
	{
		Left = 0,
		VerticalCenter = 16,
		Right = 32
	};

	KOSD();
	~KOSD();

public slots:
	void setPosition(int position);
	void setDisplayTime( uint );
	void setTextColor( const QColor& );
	void setTextFont( const QFont& );
	void showText( const QString& );
	void setStatus( KOSD::Status );
	void setVolume( int );

private slots:
	void showLabel();
	void setPosition();
	QString volumeString();
	QString statusString();

protected:
	virtual void updateMask(void);

protected:
	int position;
	Status status;
	QFont font;
	QColor color;
	int displayTime;
	int volume;

	QString lastMessage;

	QTimer *displayTimer;
};

#endif
