dnl -*- Autoconf -*-
dnl Copyright (C) 1993-2003 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Bruno Haible, Marcus Daniels, Sam Steingold.

AC_PREREQ(2.57)

AC_DEFUN([CL_SHM_H],
[AC_BEFORE([$0], [CL_SHM_RMID])dnl
AC_CHECK_HEADERS(sys/shm.h)
if test $ac_cv_header_sys_shm_h = yes; then
AC_CHECK_HEADERS(sys/ipc.h)
fi
])

AC_DEFUN([CL_SHM],
[AC_BEFORE([$0], [CL_SHM_RMID])dnl
if test "$ac_cv_header_sys_shm_h" = yes -a "$ac_cv_header_sys_ipc_h" = yes; then
# This test is from Marcus Daniels
AC_CACHE_CHECK(for working shared memory, cl_cv_sys_shm_works, [
AC_TRY_RUN([#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
]AC_LANG_EXTERN[
#if defined(__STDC__) || defined(__cplusplus)
int shmget (key_t key, $cl_cv_proto_shmget_arg2 size, int shmflg);
#else
int shmget();
#endif
]AC_LANG_EXTERN[
#if defined(__STDC__) || defined(__cplusplus)
$cl_cv_proto_shmat_ret shmat (int shmid, $cl_cv_proto_shmat_arg2 $cl_cv_proto_shmat_ret shmaddr, int shmflg);
#else
$cl_cv_proto_shmat_ret shmat();
#endif
]AC_LANG_EXTERN[
#if defined(__STDC__) || defined(__cplusplus)
int shmdt ($cl_cv_proto_shmdt_arg1 shmaddr);
#else
int shmdt();
#endif
]AC_LANG_EXTERN[
#if defined(__STDC__) || defined(__cplusplus)
int shmctl ($cl_cv_proto_shmctl_args);
#else
int shmctl();
#endif
/* try attaching a single segment to multiple addresses */
#define segsize 0x10000
#define attaches 128
#define base_addr 0x01000000
int main ()
{ int shmid, i; char* addr; char* result;
  if ((shmid = shmget(IPC_PRIVATE,segsize,0400)) < 0) exit(1);
  for (i=0, addr = (char*)0x01000000; i<attaches; i++, addr += segsize)
    if ((result = (char*)shmat(shmid,addr,SHM_RDONLY)) == (char*)(-1)) break;
  for (i=0, addr = (char*)0x01000000; i<attaches; i++, addr += segsize)
    shmdt(addr);
  shmctl(shmid,IPC_RMID,0);
  exit(result == (char*)(-1));
}], cl_cv_sys_shm_works=yes, cl_cv_sys_shm_works=no,
dnl When cross-compiling, don't assume anything.
cl_cv_sys_shm_works="guessing no")
])
fi
case "$cl_cv_sys_shm_works" in
  *yes) have_shm=1
        AC_DEFINE(HAVE_SHM,,[have <sys/shm.h> and <sys/ipc.h> and shared memory works])
        AC_CHECK_HEADERS(sys/sysmacros.h)
        ;;
  *) ;;
esac
])
