#ifndef __KVIEWPART_H
#define __KVIEWPART_H


#include <kparts/part.h>
#include <kparts/browserextension.h>
#include <kparts/factory.h>
#include <kdirwatch.h>


class KAction;
class KSelectAction;
class KToggleAction;
class ScrollBox;
class MarkList;
class KInstance;
class KViewPartExtension;
class KAccel;
class GotoDialog;
class QSize;
class pageSizeDialog;

#include "kviewpart_iface.h"
#include "kmultipage.h"
#include "pageSize.h"
#include "zoom.h"
#include "zoomlimits.h"

class KViewPartFactory : public KParts::Factory
{
  Q_OBJECT

public:

  KViewPartFactory();
  virtual ~KViewPartFactory();

  virtual KParts::Part *createPartObject( QWidget *parentWidget, const char *widgetName, QObject *parent, const char *name, const char *classname, const QStringList &args );

  static KInstance *instance();

private:

  static KInstance *s_instance;

};


class KViewPart : public KViewPart_Iface
{
  Q_OBJECT

public:
  KViewPart(QString partname, QWidget *parentWidget, const char *widgetName, QObject *parent, const char *name);
  virtual ~KViewPart();

  void readSettings();
  void writeSettings();

signals:
  void zoomChanged(const QString &);
  void pageChanged(const QString &);
  void sizeChanged(const QString &);
  void setStatusBarText(const QString &);


public slots:
  virtual bool closeURL();
  virtual QStringList fileFormats();
  void setStatusBarTextFromMultiPage(const QString &);
  /** Calling this slot will cause the kmultipage to reload the file */
  void reload(void);
 
 
protected slots:

  void slotShowMarkList();

  // Sets the orientation (portrait, landscape) of the display. The
  // current orientation is read off the orientation KSelectAction
  // (defined below). The argument is a dummy which remains unused. It
  // exists only to allow for connection with a slot of the
  // KSelectAction.
  void slotOrientation(int);

  void slotMedia (int);

  void prevPage();
  void nextPage();
  void firstPage();
  void lastPage();
  void goToPage();

  void zoomIn();
  void zoomOut();

  void fitToPage();
  void fitSize();
  void fitToHeight();
  void fitToWidth();

  void scrollUp();
  void scrollDown();
  void scrollLeft();
  void scrollRight();

  void scrollUpPage();
  void scrollDownPage();
  void scrollLeftPage();
  void scrollRightPage();

  void readDown();

  void slotPrint();

  void fileChanged(const QString&);

  // Connected to the QLineEdit in the toolbar.
  void setZoomValue(const QString &);

  void updatePreview(bool previewAvailable=false);

  void slotPreview();


protected:

  KToggleAction *showmarklist, *showPreview;
  KSelectAction *orientation, *media, *zoom_action;

  virtual bool openFile();

  int page() { return _currentPage; };
  int pages() { return _numberOfPages; };
  void setPage(int page);

  bool eventFilter(QObject *obj, QEvent *ev);

  void setPaperSize(double w, double h);
  void connectNotify ( const char * );

private slots:

  void numberOfPages(int nr);
  void pageInfo(int numpages, int currentpage);
  void pageSelected(int nr);
  void contentsMoving(int x, int y);
  void scrollBoxChanged(QPoint np);
  void updateScrollBox();
  void scrollTo(int x, int y);
  void slotGotoDialog(const QString &page);
  void slotSizeSelected(const QString &, int);

private:
  KDirWatch *watch;
  QString _partname;
  void checkActions();
  QSize pageSize();
  KAccel *accel;
  KAction *zoomInAct, *zoomOutAct, *backAct, *forwardAct,
    *startAct, *endAct, *endDocAct, *markAct, *gotoAct,
    *fitAct, *fitPageAct, *fitHeightAct, *fitWidthAct,
    *saveAction, *printAction, *readDownAct;
  KToggleAction *watchAct;
  KMultiPage *multiPage;
  ScrollBox *scrollBox;
  MarkList  *markList;
  KViewPartExtension *m_extension;

  int _numberOfPages, _currentPage;
  bool pageChangeIsConnected;

  QWidget *mainWidget;

  class pageSize  _paperSize;
  class zoom      _zoomVal; // stores the current zoom value
  pageSizeDialog *_pageSizeDialog;
  GotoDialog     *_gotoDialog;

  QPoint mousePos;
};


class KViewPartExtension : public KParts::BrowserExtension
{
  Q_OBJECT
  friend class KViewPart;

public:

  KViewPartExtension(KViewPart *parent);
  virtual ~KViewPartExtension() {}

};


#endif
