/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

public abstract class Point2D
implements Cloneable {
    protected Point2D() {
    }

    public abstract double getX();

    public abstract double getY();

    public abstract void setLocation(double var1, double var3);

    public void setLocation(Point2D p) {
        this.setLocation(p.getX(), p.getY());
    }

    public static double distanceSq(double x1, double y1, double x2, double y2) {
        return (x2 -= x1) * x2 + (y2 -= y1) * y2;
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt(Point2D.distanceSq(x1, y1, x2, y2));
    }

    public double distanceSq(double x, double y) {
        return Point2D.distanceSq(this.getX(), x, this.getY(), y);
    }

    public double distanceSq(Point2D p) {
        return Point2D.distanceSq(this.getX(), p.getX(), this.getY(), p.getY());
    }

    public double distance(double x, double y) {
        return Point2D.distance(this.getX(), x, this.getY(), y);
    }

    public double distance(Point2D p) {
        return Point2D.distance(this.getX(), p.getX(), this.getY(), p.getY());
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw (Error)new InternalError().initCause(e);
        }
    }

    public int hashCode() {
        long l = java.lang.Double.doubleToLongBits(this.getY());
        l = l * (long)31 ^ java.lang.Double.doubleToLongBits(this.getX());
        return (int)(l >> 32) ^ (int)l;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Point2D)) {
            return false;
        }
        Point2D p = (Point2D)o;
        return this.getX() == p.getX() && this.getY() == p.getY();
    }

    public static class Float
    extends Point2D {
        public float x;
        public float y;

        public Float() {
        }

        public Float(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public void setLocation(double x, double y) {
            this.x = (float)x;
            this.y = (float)y;
        }

        public void setLocation(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public String toString() {
            return "Point2D.Float[" + this.x + ", " + this.y + ']';
        }
    }

    public static class Double
    extends Point2D {
        public double x;
        public double y;

        public Double() {
        }

        public Double(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public void setLocation(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public String toString() {
            return "Point2D.Double[" + this.x + ", " + this.y + ']';
        }
    }
}

