/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CharacterIterator;
import java.text.CollationElementIterator;
import java.text.CollationKey;
import java.text.Collator;
import java.text.ParseException;
import java.text.RBCElement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class RuleBasedCollator
extends Collator {
    private boolean frenchAccents;
    private String rules;
    private Hashtable map;
    private Hashtable prefixes;

    public Object clone() {
        RuleBasedCollator c = (RuleBasedCollator)super.clone();
        c.map = (Hashtable)this.map.clone();
        c.prefixes = (Hashtable)this.map.clone();
        return c;
    }

    int ceiNext(CollationElementIterator cei) {
        int i;
        if (cei.lookahead_set) {
            cei.lookahead_set = false;
            return cei.lookahead;
        }
        int save = cei.index;
        int max = cei.text.length();
        String s = null;
        boolean found = false;
        for (i = save + 1; i <= max && this.prefixes.get(s = cei.text.substring(save, i)) != null; ++i) {
            found = true;
        }
        Object obj = this.map.get(s);
        while (found && obj == null && s.length() > 1) {
            s = cei.text.substring(save, --i);
            obj = this.map.get(s);
        }
        cei.index = i;
        if (obj == null) {
            cei.lookahead_set = true;
            cei.lookahead = s.charAt(0) << 8;
            return 0x7FFF0000;
        }
        return (Integer)obj;
    }

    static final int next(CollationElementIterator iter, int strength) {
        int c;
        do {
            int os;
            if ((os = iter.next()) == -1) {
                return os;
            }
            c = 0;
            switch (strength) {
                case 0: {
                    c = os & 0xFFFF0000;
                    break;
                }
                case 1: {
                    c = os & 0xFFFFFF00;
                    break;
                }
                case 2: 
                case 3: {
                    c = os;
                }
            }
        } while (c == 0);
        return c;
    }

    public int compare(String source, String target) {
        block2: {
            int ot;
            int os;
            CollationElementIterator cs = new CollationElementIterator(source, this);
            CollationElementIterator ct = new CollationElementIterator(target, this);
            do {
                os = RuleBasedCollator.next(cs, this.strength);
                ot = RuleBasedCollator.next(ct, this.strength);
                if (os == -1 && ot == -1) break block2;
                if (os == -1) {
                    return -1;
                }
                if (ot != -1) continue;
                return 1;
            } while (os == ot);
            return os - ot;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RuleBasedCollator) || !super.equals(obj)) {
            return false;
        }
        RuleBasedCollator rbc = (RuleBasedCollator)obj;
        return this.frenchAccents == rbc.frenchAccents && this.rules.equals(rbc.rules);
    }

    public CollationElementIterator getCollationElementIterator(String source) {
        StringBuffer expand = new StringBuffer(source.length());
        int max = source.length();
        for (int i = 0; i < max; ++i) {
            this.decomposeCharacter(source.charAt(i), expand);
        }
        return new CollationElementIterator(expand.toString(), this);
    }

    public CollationElementIterator getCollationElementIterator(CharacterIterator source) {
        StringBuffer expand = new StringBuffer();
        char c = source.first();
        while (c != '\uffff') {
            this.decomposeCharacter(c, expand);
            c = source.next();
        }
        return new CollationElementIterator(expand.toString(), this);
    }

    public CollationKey getCollationKey(String source) {
        return new CollationKey(this.getCollationElementIterator(source), source, this.strength);
    }

    public String getRules() {
        return this.rules;
    }

    public int hashCode() {
        if (this.frenchAccents) {
            return 1231;
        }
        return 0x4D5 ^ this.rules.hashCode() ^ this.map.hashCode() ^ this.prefixes.hashCode();
    }

    private final boolean is_special(char c) {
        return c > '\b' && c <= '\r' || c > '\u001f' && c <= '/' || c > '9' && c <= '@' || c > 'Z' && c <= '`' || c > 'z' && c <= '~';
    }

    private final int text_argument(String rules, int index, StringBuffer result) {
        result.setLength(0);
        int len = rules.length();
        while (index < len) {
            char c = rules.charAt(index);
            if (c == '\'' && index + 2 < len && rules.charAt(index + 2) == '\'' && this.is_special(rules.charAt(index + 1))) {
                index += 2;
            } else if (this.is_special(c) || Character.isWhitespace(c)) {
                return index;
            }
            result.append(c);
            ++index;
        }
        return index;
    }

    public RuleBasedCollator(String rules) throws ParseException {
        this.rules = rules;
        this.frenchAccents = false;
        int insertion_index = 0;
        Vector vec = new Vector();
        StringBuffer argument = new StringBuffer();
        int len = rules.length();
        for (int index = 0; index < len; ++index) {
            char c = rules.charAt(index);
            if (Character.isWhitespace(c)) continue;
            if (c == '@') {
                this.frenchAccents = true;
                continue;
            }
            if (c != '<' && c != ';' && c != ',' && c != '=' && c != '&') {
                throw new ParseException("invalid character", index);
            }
            ++index;
            while (index < len && Character.isWhitespace(rules.charAt(index))) {
                ++index;
            }
            if (index == len) {
                throw new ParseException("missing argument", index);
            }
            int save = index;
            index = this.text_argument(rules, index, argument);
            if (argument.length() == 0) {
                throw new ParseException("invalid character", save);
            }
            String arg = argument.toString();
            int item_index = vec.indexOf(arg);
            if (c != '&') {
                if (item_index != -1) {
                    vec.removeElementAt(item_index);
                    if (insertion_index >= item_index) {
                        --insertion_index;
                    }
                }
                RBCElement r = new RBCElement(arg, c);
                vec.insertElementAt(r, insertion_index);
                ++insertion_index;
            } else {
                if (item_index == -1) {
                    throw new ParseException("argument to reset not previously seen", save);
                }
                insertion_index = item_index + 1;
            }
            --index;
        }
        int primary = 0;
        int secondary = 0;
        int tertiary = 0;
        this.map = new Hashtable();
        this.prefixes = new Hashtable();
        Enumeration e = vec.elements();
        while (e.hasMoreElements()) {
            RBCElement r = (RBCElement)e.nextElement();
            switch (r.relation) {
                case '<': {
                    ++primary;
                    secondary = 0;
                    tertiary = 0;
                    break;
                }
                case ';': {
                    ++secondary;
                    tertiary = 0;
                    break;
                }
                case ',': {
                    ++tertiary;
                    break;
                }
            }
            this.map.put(r.key, new Integer(primary << 16 | secondary << 8 | tertiary));
            for (int i = r.key.length() - 1; i >= 1; --i) {
                this.prefixes.put(r.key.substring(0, i), Boolean.TRUE);
            }
        }
    }
}

