#!/bin/sh

if [ -z "$1" ]
  then
      echo "usage: $0 <toplevel-source-dir>"
      exit 1
fi

src_top_dir="$1"

VERSION_FILE="${src_top_dir}/version.h"
PREV_MC_VERSION="unknown"
CURR_MC_VERSION="${PREV_MC_VERSION}"

if [ -r "${VERSION_FILE}" ]
  then
    PREV_MC_VERSION=`sed -n 's/^#define MC_CURRENT_VERSION "\(.*\)"$/\1/p' "${VERSION_FILE}"`
    CURR_MC_VERSION="${PREV_MC_VERSION}"
fi

mc_print_version(){

    if [ ! -f "${VERSION_FILE}" \
         -o "${PREV_MC_VERSION}" != "${CURR_MC_VERSION}" ]
      then
        cat >"${VERSION_FILE}" <<EOF
#ifndef MC_CURRENT_VERSION
/* This is an autogenerated file. Don't edit! */
#define MC_CURRENT_VERSION "${CURR_MC_VERSION}"
#endif
EOF
    fi
    exit
}

git_head=$(git --git-dir "${src_top_dir}/.git" rev-parse --verify HEAD 2>/dev/null)
[ -z "${git_head}" ] && mc_print_version

# try to store sha1
CURR_MC_VERSION="${git_head}"

new_version="$(git --git-dir "${src_top_dir}/.git" describe 2>/dev/null)"
[ -z "${new_version}" ] && mc_print_version

# store pretty tagged version
CURR_MC_VERSION="${new_version}"
mc_print_version
