.\" Copyright 1999 Sun Microsystems, Inc.  All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbAddGeomOverlayRow __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbAddGeomOverlayRow \- Add a row to an existing overlay
.SH SYNOPSIS
.HP
.B XkbOverlayRowPtr XkbAddGeomOverlayRow
.BI "(\^XkbOverlayPtr " "overlay" "\^,"
.BI "XkbRowPtr " "row_under" "\^,"
.BI "int " "sz_keys" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- overlay
overlay to be updated
.TP
.I \- row_under
row to be overlayed in the section overlay overlays
.TP
.I \- sz_keys
number of keys to reserve in the row
.SH DESCRIPTION
.LP
Xkb provides functions to add a single new element to the top-level keyboard 
geometry. In each case the 
.I num_ * 
fields of the corresponding structure is incremented by 1. These functions do 
not change 
.I sz_* 
unless there is no more room in the array. Some of these functions fill in the 
values of the element's structure from the arguments. For other functions, you 
must explicitly write code to fill the structure's elements.

The top-level geometry description includes a list of 
.I geometry properties. 
A geometry property associates an arbitrary string with an equally arbitrary 
name. Programs that display images of keyboards can use geometry properties as 
hints, but they are not interpreted by Xkb. No other geometry structures refer 
to geometry properties.

.I XkbAddGeomOverlayRow 
adds one row to the 
.I overlay. 
The new row contains space for 
.I sz_keys 
keys. If 
. I row_under 
specifies a row that doesn't exist on the underlying section,
.I  XkbAddGeomOverlayRow 
returns NULL and doesn't change the overlay. 
.I XkbAddGeomOverlayRow 
returns NULL if any of the parameters is empty or if it was not able to allocate 
space for the overlay.
.SH STRUCTURES
.LP
.nf

    typedef struct _XkbOverlayRow {
        unsigned short      row_under;    /\(** index into the row under this overlay row */
        unsigned short      num_keys;     /\(** number of keys in the keys array */
        unsigned short      sz_keys;      /\(** size of the keys array */
        XkbOverlayKeyPtr    keys;         /\(** array of keys in the overlay row */
    } XkbOverlayRowRec,*XkbOverlayRowPtr;

.fi
