.\"
.\" Copyright 1996 Hewlett-Packard Company
.\" Copyright 1996 International Business Machines Corp.
.\" Copyright 1996, 1999, 2004, Oracle and/or its affiliates. All rights reserved.
.\" Copyright 1996 Novell, Inc.
.\" Copyright 1996 Digital Equipment Corp.
.\" Copyright 1996 Fujitsu Limited
.\" Copyright 1996 Hitachi, Ltd.
.\" Copyright 1996 X Consortium, Inc.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a 
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation 
.\" the rights to use, copy, modify, merge, publish, distribute,
.\" sublicense, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, subject to the following
.\" conditions:
.\" 
.\" The above copyright notice and this permission notice shall be
.\" included in all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
.\" DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
.\" OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR
.\" THE USE OR OTHER DEALINGS IN THE SOFTWARE.
.\" 
.\" Except as contained in this notice, the names of the copyright holders
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" from said copyright holders.
.\"
.TH XpStartDoc 3Xp __xorgversion__ "XPRINT FUNCTIONS"
.SH NAME
XpStartDoc \-  Indicates the beginning of a print document.
.SH SYNOPSIS
.br
      cc [ flag... ] file... -lXp [ library... ]	
.br
      #include <X11/extensions/Print.h>
.LP    
.B void XpStartDoc
(
.I display,
.I type
)
.br
      Display *\fIdisplay\fP\^;
.br
      XPDocumentType \fItype\fP\^;
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I display
Specifies a pointer to the Display structure; returned from XOpenDisplay.
.TP
.I type
Specifies the type of document. It can be either XPDocRaw or XPDocNormal.
.SH DESCRIPTION
.LP
XpStartDoc signals the beginning of a new print document.

If type is XPDocRaw, then the client will provide all the data for the resulting 
document using XpPutDocumentData; the X Print Server will not write any data 
into the resulting document. Calling XpStartPage in a XPDocRaw document will 
generate an XPBadSequence error. For more information, see XpPutDocumentData.

If type is XPDocNormal, then the X Print Server will generate document data, and 
depending on the DDX driver, can incorporate additional data from 
XpPutDocumentData into the output. For more information, see XpPutDocumentData.

   
All changes to the XPDocAttr attribute pool (see XpSetAttributes) must be made 
prior to calling XpStartDoc, after which an XPBadSequence will be generated if 
changes are attempted, until XpEndDoc is called.

The application is not required to call XpStartDoc and XpEndDoc in the process 
of printing. The "document" delineation may not be useful from the application's 
or spooler's perspective, hence is optional. If XpStartPage is called 
immediately after XpStartJob then a synthetic XpStartDoc with XPDocNormal will 
be assumed by the X Print Server prior to XpStartPage (i.e. the XPStartDocNotify 
and XPStartPageNotify events will have the same sequence number). Likewise, if 
XpEndJob is called immediately after XpEndPage then a synthetic XpEndDoc will be 
assumed by the X Print Server prior to XpEndJob (i.e., the XPEndDocNotify and 
XPEndJobNotify events will have the same sequence number).

For clients selecting XPPrintMask (see XpSelectInput), the event XPPrintNotify 
will be generated with its detail field set to XPStartDocNotify.
.SH STRUCTURES
The XPDocumentType values are defined in <X11/extensions/Print.h>:

.nf

    #define   XPDocNormal     1     /\(** Doc data handled by Xserver*/
    #define   XPDocRaw        2     /\(** Doc data passed through Xserver*/
    
.fi 

.SH DIAGNOSTICS
.TP 15
.SM XPBadContext
A valid print context-id has not been set prior to making this call.
.TP 15
.SM XPBadSequence
The function was not called in the proper order with respect to the other X 
Print Service 
Extension calls (example, XpEndDoc prior to XpStartDoc).
.TP 15
.SM BadValue
The value specified for type is not valid.
.SH FILES
.PD 0
.TP 20
.B <X11/extensions/Print.h>
.SH "SEE ALSO"
.BR XpEndDoc (3Xp),
.BR XpEndJob (3Xp),
.BR XpEndPage (3Xp),
.BR XpPutDocumentData (3Xp),
.BR XpSelectInput (3Xp),
.BR XpSetAttributes (3Xp),
.BR XpStartJob (3Xp),
.BR XpStartPage (3Xp)
