var browserTests = [
["foo[]bar",
	[["backcolor","#00FFFF"]],
	"foo[]bar",
	[true],
	{"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<p>[foo</p> <p>bar]</p>",
	[["stylewithcss","true"],["backcolor","#00FFFF"]],
	"<p><span style=\"background-color:rgb(0, 255, 255)\">[foo</span></p> <p><span style=\"background-color:rgb(0, 255, 255)\">bar]</span></p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<p>[foo</p> <p>bar]</p>",
	[["stylewithcss","false"],["backcolor","#00FFFF"]],
	"<p><span style=\"background-color:rgb(0, 255, 255)\">[foo</span></p> <p><span style=\"background-color:rgb(0, 255, 255)\">bar]</span></p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<span>[foo</span> <span>bar]</span>",
	[["stylewithcss","true"],["backcolor","#00FFFF"]],
	"<span style=\"background-color:rgb(0, 255, 255)\"><span>[foo</span> <span>bar]</span></span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<span>[foo</span> <span>bar]</span>",
	[["stylewithcss","false"],["backcolor","#00FFFF"]],
	"<span style=\"background-color:rgb(0, 255, 255)\"><span>[foo</span> <span>bar]</span></span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
	[["stylewithcss","true"],["backcolor","#00FFFF"]],
	"<p><span style=\"background-color:rgb(0, 255, 255)\">[foo</span></p><p> <span style=\"background-color:rgb(0, 255, 255)\"><span>bar</span></span> </p><p><span style=\"background-color:rgb(0, 255, 255)\">baz]</span></p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
	[["stylewithcss","false"],["backcolor","#00FFFF"]],
	"<p><span style=\"background-color:rgb(0, 255, 255)\">[foo</span></p><p> <span style=\"background-color:rgb(0, 255, 255)\"><span>bar</span></span> </p><p><span style=\"background-color:rgb(0, 255, 255)\">baz]</span></p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<p>[foo<p><br><p>bar]",
	[["stylewithcss","true"],["backcolor","#00FFFF"]],
	"<p><span style=\"background-color:rgb(0, 255, 255)\">[foo</span></p><p><span style=\"background-color:rgb(0, 255, 255)\"><br></span></p><p><span style=\"background-color:rgb(0, 255, 255)\">bar]</span></p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<p>[foo<p><br><p>bar]",
	[["stylewithcss","false"],["backcolor","#00FFFF"]],
	"<p><span style=\"background-color:rgb(0, 255, 255)\">[foo</span></p><p><span style=\"background-color:rgb(0, 255, 255)\"><br></span></p><p><span style=\"background-color:rgb(0, 255, 255)\">bar]</span></p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<b>foo[]bar</b>",
	[["backcolor","#00FFFF"]],
	"<b>foo[]bar</b>",
	[true],
	{"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<i>foo[]bar</i>",
	[["backcolor","#00FFFF"]],
	"<i>foo[]bar</i>",
	[true],
	{"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<span>foo</span>{}<span>bar</span>",
	[["backcolor","#00FFFF"]],
	"<span>foo</span>{}<span>bar</span>",
	[true],
	{"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<span>foo[</span><span>]bar</span>",
	[["backcolor","#00FFFF"]],
	"<span>foo[</span><span>]bar</span>",
	[true],
	{"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["backcolor","#00FFFF"]],
	"foo<span style=\"background-color:rgb(0, 255, 255)\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["backcolor","#00FFFF"]],
	"foo<span style=\"background-color:rgb(0, 255, 255)\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["foo[bar<b>baz]qoz</b>quz",
	[["stylewithcss","true"],["backcolor","#00FFFF"]],
	"foo<span style=\"background-color:rgb(0, 255, 255)\">[bar</span><b><span style=\"background-color:rgb(0, 255, 255)\">baz]</span>qoz</b>quz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["foo[bar<b>baz]qoz</b>quz",
	[["stylewithcss","false"],["backcolor","#00FFFF"]],
	"foo<span style=\"background-color:rgb(0, 255, 255)\">[bar</span><b><span style=\"background-color:rgb(0, 255, 255)\">baz]</span>qoz</b>quz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["foo[bar<i>baz]qoz</i>quz",
	[["stylewithcss","true"],["backcolor","#00FFFF"]],
	"foo<span style=\"background-color:rgb(0, 255, 255)\">[bar</span><i><span style=\"background-color:rgb(0, 255, 255)\">baz]</span>qoz</i>quz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["foo[bar<i>baz]qoz</i>quz",
	[["stylewithcss","false"],["backcolor","#00FFFF"]],
	"foo<span style=\"background-color:rgb(0, 255, 255)\">[bar</span><i><span style=\"background-color:rgb(0, 255, 255)\">baz]</span>qoz</i>quz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["{<p><p> <p>foo</p>}",
	[["stylewithcss","true"],["backcolor","#00FFFF"]],
	"{<p></p><p> </p><p><span style=\"background-color:rgb(0, 255, 255)\">foo</span></p>}",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["{<p><p> <p>foo</p>}",
	[["stylewithcss","false"],["backcolor","#00FFFF"]],
	"{<p></p><p> </p><p><span style=\"background-color:rgb(0, 255, 255)\">foo</span></p>}",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
	[["stylewithcss","true"],["backcolor","#00FFFF"]],
	"<table><tbody><tr><td>foo</td><td>b<span style=\"background-color:rgb(0, 255, 255)\">[a]</span>r</td><td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
	[["stylewithcss","false"],["backcolor","#00FFFF"]],
	"<table><tbody><tr><td>foo</td><td>b<span style=\"background-color:rgb(0, 255, 255)\">[a]</span>r</td><td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","true"],["backcolor","#00FFFF"]],
	"<table><tbody><tr><td>foo</td>{<td><span style=\"background-color:rgb(0, 255, 255)\">bar</span></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","false"],["backcolor","#00FFFF"]],
	"<table><tbody><tr><td>foo</td>{<td><span style=\"background-color:rgb(0, 255, 255)\">bar</span></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","true"],["backcolor","#00FFFF"]],
	"<table><tbody><tr>{<td><span style=\"background-color:rgb(0, 255, 255)\">foo</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">bar</span></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","false"],["backcolor","#00FFFF"]],
	"<table><tbody><tr>{<td><span style=\"background-color:rgb(0, 255, 255)\">foo</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">bar</span></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","true"],["backcolor","#00FFFF"]],
	"<table><tbody>{<tr><td><span style=\"background-color:rgb(0, 255, 255)\">foo</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">bar</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">baz</span></td></tr>}</tbody></table>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","false"],["backcolor","#00FFFF"]],
	"<table><tbody>{<tr><td><span style=\"background-color:rgb(0, 255, 255)\">foo</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">bar</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">baz</span></td></tr>}</tbody></table>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","true"],["backcolor","#00FFFF"]],
	"<table>{<tbody><tr><td><span style=\"background-color:rgb(0, 255, 255)\">foo</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">bar</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">baz</span></td></tr></tbody>}</table>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","false"],["backcolor","#00FFFF"]],
	"<table>{<tbody><tr><td><span style=\"background-color:rgb(0, 255, 255)\">foo</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">bar</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">baz</span></td></tr></tbody>}</table>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
	[["stylewithcss","true"],["backcolor","#00FFFF"]],
	"{<table><tbody><tr><td><span style=\"background-color:rgb(0, 255, 255)\">foo</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">bar</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">baz</span></td></tr></tbody></table>}",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
	[["stylewithcss","false"],["backcolor","#00FFFF"]],
	"{<table><tbody><tr><td><span style=\"background-color:rgb(0, 255, 255)\">foo</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">bar</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">baz</span></td></tr></tbody></table>}",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<p style=\"background-color: rgb(0, 255, 255)\">foo[bar]baz</p>",
	[["backcolor","#00FFFF"]],
	"<p style=\"background-color:rgb(0, 255, 255)\">foo[bar]baz</p>",
	[true],
	{"backcolor":[false,false,"rgb(0, 255, 255)",false,false,"rgb(0, 255, 255)"]}],
["<p style=\"background-color: #00ffff\">foo[bar]baz</p>",
	[["backcolor","#00FFFF"]],
	"<p style=\"background-color:rgb(0, 255, 255)\">foo[bar]baz</p>",
	[true],
	{"backcolor":[false,false,"rgb(0, 255, 255)",false,false,"rgb(0, 255, 255)"]}],
["<p style=\"background-color: aqua\">foo[bar]baz</p>",
	[["backcolor","#00FFFF"]],
	"<p style=\"background-color:rgb(0, 255, 255)\">foo[bar]baz</p>",
	[true],
	{"backcolor":[false,false,"rgb(0, 255, 255)",false,false,"rgb(0, 255, 255)"]}],
["{<p style=\"background-color: aqua\">foo</p><p>bar</p>}",
	[["stylewithcss","true"],["backcolor","#00FFFF"]],
	"{<p style=\"background-color:rgb(0, 255, 255)\">foo</p><p><span style=\"background-color:rgb(0, 255, 255)\">bar</span></p>}",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"backcolor":[true,false,"rgb(0, 255, 255)",false,false,"rgb(0, 255, 255)"]}],
["{<p style=\"background-color: aqua\">foo</p><p>bar</p>}",
	[["stylewithcss","false"],["backcolor","#00FFFF"]],
	"{<p style=\"background-color:rgb(0, 255, 255)\">foo</p><p><span style=\"background-color:rgb(0, 255, 255)\">bar</span></p>}",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"backcolor":[true,false,"rgb(0, 255, 255)",false,false,"rgb(0, 255, 255)"]}],
["<span style=\"background-color: aqua\">foo<span style=\"background-color: tan\">[bar]</span>baz</span>",
	[["stylewithcss","true"],["backcolor","#00FFFF"]],
	"<span style=\"background-color:rgb(0, 255, 255)\">foo[bar]baz</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"backcolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=\"background-color: aqua\">foo<span style=\"background-color: tan\">[bar]</span>baz</span>",
	[["stylewithcss","false"],["backcolor","#00FFFF"]],
	"<span style=\"background-color:rgb(0, 255, 255)\">foo[bar]baz</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"backcolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=\"background-color: #00ffff\">foo<span style=\"background-color: tan\">[bar]</span>baz</span>",
	[["stylewithcss","true"],["backcolor","#00FFFF"]],
	"<span style=\"background-color:rgb(0, 255, 255)\">foo[bar]baz</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"backcolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=\"background-color: #00ffff\">foo<span style=\"background-color: tan\">[bar]</span>baz</span>",
	[["stylewithcss","false"],["backcolor","#00FFFF"]],
	"<span style=\"background-color:rgb(0, 255, 255)\">foo[bar]baz</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"backcolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=\"background-color: #0ff\">foo<span style=\"background-color: tan\">[bar]</span>baz</span>",
	[["stylewithcss","true"],["backcolor","#00FFFF"]],
	"<span style=\"background-color:rgb(0, 255, 255)\">foo[bar]baz</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"backcolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=\"background-color: #0ff\">foo<span style=\"background-color: tan\">[bar]</span>baz</span>",
	[["stylewithcss","false"],["backcolor","#00FFFF"]],
	"<span style=\"background-color:rgb(0, 255, 255)\">foo[bar]baz</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"backcolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=\"background-color: rgb(0, 255, 255)\">foo<span style=\"background-color: tan\">[bar]</span>baz</span>",
	[["stylewithcss","true"],["backcolor","#00FFFF"]],
	"<span style=\"background-color:rgb(0, 255, 255)\">foo[bar]baz</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"backcolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=\"background-color: rgb(0, 255, 255)\">foo<span style=\"background-color: tan\">[bar]</span>baz</span>",
	[["stylewithcss","false"],["backcolor","#00FFFF"]],
	"<span style=\"background-color:rgb(0, 255, 255)\">foo[bar]baz</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"backcolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=\"background-color: aqua\">foo<span style=\"background-color: tan\">b[ar]</span>baz</span>",
	[["backcolor","#00FFFF"]],
	"<span style=\"background-color:rgb(0, 255, 255)\">foo<span style=\"background-color:rgb(210, 180, 140)\">b</span>[ar]baz</span>",
	[true],
	{"backcolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<p style=\"background-color: aqua\">foo<span style=\"background-color: tan\">b[ar]</span>baz</p>",
	[["backcolor","#00FFFF"]],
	"<p style=\"background-color:rgb(0, 255, 255)\">foo<span style=\"background-color:rgb(210, 180, 140)\">b</span>[ar]baz</p>",
	[true],
	{"backcolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<div style=\"background-color: aqua\"><p style=\"background-color: tan\">b[ar]</p></div>",
	[["stylewithcss","true"],["backcolor","#00FFFF"]],
	"<div style=\"background-color:rgb(0, 255, 255)\"><p style=\"background-color:rgb(210, 180, 140)\">b<span style=\"background-color:rgb(0, 255, 255)\">[ar]</span></p></div>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"backcolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<div style=\"background-color: aqua\"><p style=\"background-color: tan\">b[ar]</p></div>",
	[["stylewithcss","false"],["backcolor","#00FFFF"]],
	"<div style=\"background-color:rgb(0, 255, 255)\"><p style=\"background-color:rgb(210, 180, 140)\">b<span style=\"background-color:rgb(0, 255, 255)\">[ar]</span></p></div>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"backcolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=\"display: block; background-color: aqua\"><span style=\"display: block; background-color: tan\">b[ar]</span></span>",
	[["stylewithcss","true"],["backcolor","#00FFFF"]],
	"<span style=\"display:block; background-color:rgb(0, 255, 255)\"><span style=\"display:block; background-color:rgb(210, 180, 140)\">b<span style=\"background-color:rgb(0, 255, 255)\">[ar]</span></span></span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"backcolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=\"display: block; background-color: aqua\"><span style=\"display: block; background-color: tan\">b[ar]</span></span>",
	[["stylewithcss","false"],["backcolor","#00FFFF"]],
	"<span style=\"display:block; background-color:rgb(0, 255, 255)\"><span style=\"display:block; background-color:rgb(210, 180, 140)\">b<span style=\"background-color:rgb(0, 255, 255)\">[ar]</span></span></span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"backcolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["fo[o<span style=background-color:tan>b]ar</span>baz",
	[["stylewithcss","true"],["backcolor","#00FFFF"]],
	"fo<span style=\"background-color:rgb(0, 255, 255)\">[o</span><span style=\"background-color:rgb(210, 180, 140)\"><span style=\"background-color:rgb(0, 255, 255)\">b]</span>ar</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"backcolor":[true,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["fo[o<span style=background-color:tan>b]ar</span>baz",
	[["stylewithcss","false"],["backcolor","#00FFFF"]],
	"fo<span style=\"background-color:rgb(0, 255, 255)\">[o</span><span style=\"background-color:rgb(210, 180, 140)\"><span style=\"background-color:rgb(0, 255, 255)\">b]</span>ar</span>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"backcolor":[true,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["foo<span style=background-color:tan>ba[r</span>b]az",
	[["stylewithcss","true"],["backcolor","#00FFFF"]],
	"foo<span style=\"background-color:rgb(210, 180, 140)\">ba<span style=\"background-color:rgb(0, 255, 255)\">[r</span></span><span style=\"background-color:rgb(0, 255, 255)\">b]</span>az",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"backcolor":[true,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["foo<span style=background-color:tan>ba[r</span>b]az",
	[["stylewithcss","false"],["backcolor","#00FFFF"]],
	"foo<span style=\"background-color:rgb(210, 180, 140)\">ba<span style=\"background-color:rgb(0, 255, 255)\">[r</span></span><span style=\"background-color:rgb(0, 255, 255)\">b]</span>az",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"backcolor":[true,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["fo[o<span style=background-color:tan>bar</span>b]az",
	[["backcolor","#00FFFF"]],
	"fo<span style=\"background-color:rgb(0, 255, 255)\">[obarb]</span>az",
	[true],
	{"backcolor":[true,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["foo[<span style=background-color:tan>b]ar</span>baz",
	[["stylewithcss","true"],["backcolor","#00FFFF"]],
	"foo[<span style=\"background-color:rgb(210, 180, 140)\"><span style=\"background-color:rgb(0, 255, 255)\">b]</span>ar</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"backcolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["foo[<span style=background-color:tan>b]ar</span>baz",
	[["stylewithcss","false"],["backcolor","#00FFFF"]],
	"foo[<span style=\"background-color:rgb(210, 180, 140)\"><span style=\"background-color:rgb(0, 255, 255)\">b]</span>ar</span>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"backcolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["foo<span style=background-color:tan>ba[r</span>]baz",
	[["stylewithcss","true"],["backcolor","#00FFFF"]],
	"foo<span style=\"background-color:rgb(210, 180, 140)\">ba<span style=\"background-color:rgb(0, 255, 255)\">[r</span></span>]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"backcolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["foo<span style=background-color:tan>ba[r</span>]baz",
	[["stylewithcss","false"],["backcolor","#00FFFF"]],
	"foo<span style=\"background-color:rgb(210, 180, 140)\">ba<span style=\"background-color:rgb(0, 255, 255)\">[r</span></span>]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"backcolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["foo[<span style=background-color:tan>bar</span>]baz",
	[["backcolor","#00FFFF"]],
	"foo[<span style=\"background-color:rgb(0, 255, 255)\">bar</span>]baz",
	[true],
	{"backcolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["foo<span style=background-color:tan>[bar]</span>baz",
	[["backcolor","#00FFFF"]],
	"foo<span style=\"background-color:rgb(0, 255, 255)\">[bar]</span>baz",
	[true],
	{"backcolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["foo{<span style=background-color:tan>bar</span>}baz",
	[["backcolor","#00FFFF"]],
	"foo{<span style=\"background-color:rgb(0, 255, 255)\">bar}</span>baz",
	[true],
	{"backcolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=background-color:tan>fo[o</span><span style=background-color:yellow>b]ar</span>",
	[["stylewithcss","true"],["backcolor","#00FFFF"]],
	"<span style=\"background-color:rgb(210, 180, 140)\">fo<span style=\"background-color:rgb(0, 255, 255)\">[o</span></span><span style=\"background-color:rgb(255, 255, 0)\"><span style=\"background-color:rgb(0, 255, 255)\">b]</span>ar</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"backcolor":[true,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=background-color:tan>fo[o</span><span style=background-color:yellow>b]ar</span>",
	[["stylewithcss","false"],["backcolor","#00FFFF"]],
	"<span style=\"background-color:rgb(210, 180, 140)\">fo<span style=\"background-color:rgb(0, 255, 255)\">[o</span></span><span style=\"background-color:rgb(255, 255, 0)\"><span style=\"background-color:rgb(0, 255, 255)\">b]</span>ar</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"backcolor":[true,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=background-color:tan>fo[o</span><span style=background-color:tan>b]ar</span>",
	[["stylewithcss","true"],["backcolor","#00FFFF"]],
	"<span style=\"background-color:rgb(210, 180, 140)\">fo<span style=\"background-color:rgb(0, 255, 255)\">[o</span></span><span style=\"background-color:rgb(210, 180, 140)\"><span style=\"background-color:rgb(0, 255, 255)\">b]</span>ar</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"backcolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=background-color:tan>fo[o</span><span style=background-color:tan>b]ar</span>",
	[["stylewithcss","false"],["backcolor","#00FFFF"]],
	"<span style=\"background-color:rgb(210, 180, 140)\">fo<span style=\"background-color:rgb(0, 255, 255)\">[o</span></span><span style=\"background-color:rgb(210, 180, 140)\"><span style=\"background-color:rgb(0, 255, 255)\">b]</span>ar</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"backcolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=background-color:tan>fo[o<span style=background-color:transparent>b]ar</span></span>",
	[["stylewithcss","true"],["backcolor","#00FFFF"]],
	"<span style=\"background-color:rgb(210, 180, 140)\">fo<span style=\"background-color:rgb(0, 255, 255)\">[o</span><span style=\"background-color:rgba(0, 0, 0, 0)\"><span style=\"background-color:rgb(0, 255, 255)\">b]</span>ar</span></span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"backcolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=background-color:tan>fo[o<span style=background-color:transparent>b]ar</span></span>",
	[["stylewithcss","false"],["backcolor","#00FFFF"]],
	"<span style=\"background-color:rgb(210, 180, 140)\">fo<span style=\"background-color:rgb(0, 255, 255)\">[o</span><span style=\"background-color:rgba(0, 0, 0, 0)\"><span style=\"background-color:rgb(0, 255, 255)\">b]</span>ar</span></span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"backcolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["foo[]bar",
	[["bold",""]],
	"foo[]bar",
	[true],
	{"bold":[false,false,"",false,true,""]}],
["<p>[foo</p> <p>bar]</p>",
	[["stylewithcss","true"],["bold",""]],
	"<p><span style=\"font-weight:bold\">[foo</span></p> <p><span style=\"font-weight:bold\">bar]</span></p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<p>[foo</p> <p>bar]</p>",
	[["stylewithcss","false"],["bold",""]],
	"<p><b>[foo</b></p> <p><b>bar]</b></p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<span>[foo</span> <span>bar]</span>",
	[["stylewithcss","true"],["bold",""]],
	"<span style=\"font-weight:bold\"><span>[foo</span> <span>bar]</span></span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<span>[foo</span> <span>bar]</span>",
	[["stylewithcss","false"],["bold",""]],
	"<b><span>[foo</span> <span>bar]</span></b>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
	[["stylewithcss","true"],["bold",""]],
	"<p><span style=\"font-weight:bold\">[foo</span></p><p> <span style=\"font-weight:bold\"><span>bar</span></span> </p><p><span style=\"font-weight:bold\">baz]</span></p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
	[["stylewithcss","false"],["bold",""]],
	"<p><b>[foo</b></p><p> <b><span>bar</span></b> </p><p><b>baz]</b></p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<p>[foo<p><br><p>bar]",
	[["stylewithcss","true"],["bold",""]],
	"<p><span style=\"font-weight:bold\">[foo</span></p><p><span style=\"font-weight:bold\"><br></span></p><p><span style=\"font-weight:bold\">bar]</span></p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<p>[foo<p><br><p>bar]",
	[["stylewithcss","false"],["bold",""]],
	"<p><b>[foo</b></p><p><b><br></b></p><p><b>bar]</b></p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<b>foo[]bar</b>",
	[["bold",""]],
	"<b>foo[]bar</b>",
	[true],
	{"bold":[false,true,"",false,false,""]}],
["<i>foo[]bar</i>",
	[["bold",""]],
	"<i>foo[]bar</i>",
	[true],
	{"bold":[false,false,"",false,true,""]}],
["<span>foo</span>{}<span>bar</span>",
	[["bold",""]],
	"<span>foo</span>{}<span>bar</span>",
	[true],
	{"bold":[false,false,"",false,true,""]}],
["<span>foo[</span><span>]bar</span>",
	[["bold",""]],
	"<span>foo[</span><span>]bar</span>",
	[true],
	{"bold":[false,false,"",false,true,""]}],
["foo[bar]baz",
	[["stylewithcss","true"],["bold",""]],
	"foo<span style=\"font-weight:bold\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["foo[bar]baz",
	[["stylewithcss","false"],["bold",""]],
	"foo<b>[bar]</b>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["foo[bar<b>baz]qoz</b>quz",
	[["bold",""]],
	"foo<b>[barbaz]qoz</b>quz",
	[true],
	{"bold":[true,false,"",false,true,""]}],
["foo[bar<i>baz]qoz</i>quz",
	[["stylewithcss","true"],["bold",""]],
	"foo<span style=\"font-weight:bold\">[bar</span><i><span style=\"font-weight:bold\">baz]</span>qoz</i>quz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["foo[bar<i>baz]qoz</i>quz",
	[["stylewithcss","false"],["bold",""]],
	"foo<b>[bar</b><i><b>baz]</b>qoz</i>quz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["{<p><p> <p>foo</p>}",
	[["stylewithcss","true"],["bold",""]],
	"{<p></p><p> </p><p><span style=\"font-weight:bold\">foo</span></p>}",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["{<p><p> <p>foo</p>}",
	[["stylewithcss","false"],["bold",""]],
	"{<p></p><p> </p><p><b>foo</b></p>}",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["foo<span contenteditable=false>[bar]</span>baz",
	[["bold",""]],
	"foo<span contenteditable=\"false\">[bar]</span>baz",
	[false],
	{"bold":[false,false,"",false,false,""]}],
["fo[o<span contenteditable=false>bar</span>b]az",
	[["stylewithcss","true"],["bold",""]],
	"fo<span style=\"font-weight:bold\">[o</span><span contenteditable=\"false\">bar</span><span style=\"font-weight:bold\">b]</span>az",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["fo[o<span contenteditable=false>bar</span>b]az",
	[["stylewithcss","false"],["bold",""]],
	"fo<b>[o</b><span contenteditable=\"false\">bar</span><b>b]</b>az",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["foo<span contenteditable=false>ba[r</span>b]az",
	[["bold",""]],
	"foo<span contenteditable=\"false\">ba[r</span>b]az",
	[false],
	{"bold":[false,false,"",false,false,""]}],
["fo[o<span contenteditable=false>b]ar</span>baz",
	[["bold",""]],
	"fo[o<span contenteditable=\"false\">b]ar</span>baz",
	[false],
	{"bold":[false,false,"",false,false,""]}],
["fo[<b>o</b><span contenteditable=false>bar</span><b>b</b>]az",
	[["stylewithcss","true"],["bold",""]],
	"fo[o<span contenteditable=\"false\">bar</span>b]az",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["fo[<b>o</b><span contenteditable=false>bar</span><b>b</b>]az",
	[["stylewithcss","false"],["bold",""]],
	"fo[o<span contenteditable=\"false\">bar</span>b]az",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["<span contenteditable=false>foo<span contenteditable=true>[bar]</span>baz</span>",
	[["stylewithcss","true"],["bold",""]],
	"<span contenteditable=\"false\">foo<span contenteditable=\"true\"><span style=\"font-weight:bold\">[bar]</span></span>baz</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<span contenteditable=false>foo<span contenteditable=true>[bar]</span>baz</span>",
	[["stylewithcss","false"],["bold",""]],
	"<span contenteditable=\"false\">foo<span contenteditable=\"true\"><b>[bar]</b></span>baz</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<span contenteditable=false>fo[o<span contenteditable=true>bar</span>b]az</span>",
	[["bold",""]],
	"<span contenteditable=\"false\">fo[o<span contenteditable=\"true\">bar</span>b]az</span>",
	[false],
	{"bold":[false,false,"",false,false,""]}],
["<span contenteditable=false>foo<span contenteditable=true>ba[r</span>b]az</span>",
	[["bold",""]],
	"<span contenteditable=\"false\">foo<span contenteditable=\"true\">ba[r</span>b]az</span>",
	[false],
	{"bold":[false,false,"",false,false,""]}],
["<span contenteditable=false>fo[o<span contenteditable=true>b]ar</span>baz</span>",
	[["bold",""]],
	"<span contenteditable=\"false\">fo[o<span contenteditable=\"true\">b]ar</span>baz</span>",
	[false],
	{"bold":[false,false,"",false,false,""]}],
["<span contenteditable=false>fo[<b>o<span contenteditable=true>bar</span>b</b>]az</span>",
	[["bold",""]],
	"<span contenteditable=\"false\">fo[<b>o<span contenteditable=\"true\">bar</span>b</b>]az</span>",
	[false],
	{"bold":[false,true,"",false,true,""]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
	[["stylewithcss","true"],["bold",""]],
	"<table><tbody><tr><td>foo</td><td>b<span style=\"font-weight:bold\">[a]</span>r</td><td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
	[["stylewithcss","false"],["bold",""]],
	"<table><tbody><tr><td>foo</td><td>b<b>[a]</b>r</td><td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","true"],["bold",""]],
	"<table><tbody><tr><td>foo</td>{<td><span style=\"font-weight:bold\">bar</span></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","false"],["bold",""]],
	"<table><tbody><tr><td>foo</td>{<td><b>bar</b></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","true"],["bold",""]],
	"<table><tbody><tr>{<td><span style=\"font-weight:bold\">foo</span></td><td><span style=\"font-weight:bold\">bar</span></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","false"],["bold",""]],
	"<table><tbody><tr>{<td><b>foo</b></td><td><b>bar</b></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","true"],["bold",""]],
	"<table><tbody>{<tr><td><span style=\"font-weight:bold\">foo</span></td><td><span style=\"font-weight:bold\">bar</span></td><td><span style=\"font-weight:bold\">baz</span></td></tr>}</tbody></table>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","false"],["bold",""]],
	"<table><tbody>{<tr><td><b>foo</b></td><td><b>bar</b></td><td><b>baz</b></td></tr>}</tbody></table>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","true"],["bold",""]],
	"<table>{<tbody><tr><td><span style=\"font-weight:bold\">foo</span></td><td><span style=\"font-weight:bold\">bar</span></td><td><span style=\"font-weight:bold\">baz</span></td></tr></tbody>}</table>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","false"],["bold",""]],
	"<table>{<tbody><tr><td><b>foo</b></td><td><b>bar</b></td><td><b>baz</b></td></tr></tbody>}</table>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
	[["stylewithcss","true"],["bold",""]],
	"{<table><tbody><tr><td><span style=\"font-weight:bold\">foo</span></td><td><span style=\"font-weight:bold\">bar</span></td><td><span style=\"font-weight:bold\">baz</span></td></tr></tbody></table>}",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
	[["stylewithcss","false"],["bold",""]],
	"{<table><tbody><tr><td><b>foo</b></td><td><b>bar</b></td><td><b>baz</b></td></tr></tbody></table>}",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["foo<span style=\"font-weight: bold\">[bar]</span>baz",
	[["stylewithcss","true"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo<span style=\"font-weight: bold\">[bar]</span>baz",
	[["stylewithcss","false"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo<b>[bar]</b>baz",
	[["stylewithcss","true"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo<b>[bar]</b>baz",
	[["stylewithcss","false"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo<b>bar</b>[baz]",
	[["bold",""]],
	"foo<b>bar[baz]</b>",
	[true],
	{"bold":[false,false,"",false,true,""]}],
["[foo]<b>bar</b>baz",
	[["bold",""]],
	"<b>[foo]bar</b>baz",
	[true],
	{"bold":[false,false,"",false,true,""]}],
["<b>foo</b>[bar]<b>baz</b>",
	[["stylewithcss","true"],["bold",""]],
	"<b>foo[bar]baz</b>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<b>foo</b>[bar]<b>baz</b>",
	[["stylewithcss","false"],["bold",""]],
	"<b>foo[bar]baz</b>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["foo<strong>bar</strong>[baz]",
	[["bold",""]],
	"foo<strong>bar[baz]</strong>",
	[true],
	{"bold":[false,false,"",false,true,""]}],
["[foo]<strong>bar</strong>baz",
	[["bold",""]],
	"<strong>[foo]bar</strong>baz",
	[true],
	{"bold":[false,false,"",false,true,""]}],
["<strong>foo</strong>[bar]<strong>baz</strong>",
	[["bold",""]],
	"<strong>foo[bar]baz</strong>",
	[true],
	{"bold":[false,false,"",false,true,""]}],
["<b>foo</b>[bar]<strong>baz</strong>",
	[["bold",""]],
	"<b>foo[bar]baz</b>",
	[true],
	{"bold":[false,false,"",false,true,""]}],
["<strong>foo</strong>[bar]<b>baz</b>",
	[["stylewithcss","true"],["bold",""]],
	"<strong>foo[bar]baz</strong>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<strong>foo</strong>[bar]<b>baz</b>",
	[["stylewithcss","false"],["bold",""]],
	"<strong>foo[bar]baz</strong>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["foo[<b>bar</b>]baz",
	[["stylewithcss","true"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo[<b>bar</b>]baz",
	[["stylewithcss","false"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo[<b>bar]</b>baz",
	[["stylewithcss","true"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo[<b>bar]</b>baz",
	[["stylewithcss","false"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo<b>[bar</b>]baz",
	[["stylewithcss","true"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo<b>[bar</b>]baz",
	[["stylewithcss","false"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo{<b></b>}baz",
	[["bold",""]],
	"foo{<b></b>}baz",
	[true],
	{"bold":[false,false,"",false,true,""]}],
["foo{<i></i>}baz",
	[["bold",""]],
	"foo{<i></i>}baz",
	[true],
	{"bold":[false,false,"",false,true,""]}],
["foo{<b><i></i></b>}baz",
	[["bold",""]],
	"foo{<b><i></i></b>}baz",
	[true],
	{"bold":[false,false,"",false,true,""]}],
["foo{<i><b></b></i>}baz",
	[["bold",""]],
	"foo{<i><b></b></i>}baz",
	[true],
	{"bold":[false,false,"",false,true,""]}],
["foo<strong>[bar]</strong>baz",
	[["bold",""]],
	"foo[bar]baz",
	[true],
	{"bold":[false,true,"",false,false,""]}],
["foo[<strong>bar</strong>]baz",
	[["bold",""]],
	"foo[bar]baz",
	[true],
	{"bold":[false,true,"",false,false,""]}],
["foo[<strong>bar]</strong>baz",
	[["bold",""]],
	"foo[bar]baz",
	[true],
	{"bold":[false,true,"",false,false,""]}],
["foo<strong>[bar</strong>]baz",
	[["bold",""]],
	"foo[bar]baz",
	[true],
	{"bold":[false,true,"",false,false,""]}],
["foo<span style=\"font-weight: bold\">[bar]</span>baz",
	[["stylewithcss","true"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo<span style=\"font-weight: bold\">[bar]</span>baz",
	[["stylewithcss","false"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo[<span style=\"font-weight: bold\">bar</span>]baz",
	[["stylewithcss","true"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo[<span style=\"font-weight: bold\">bar</span>]baz",
	[["stylewithcss","false"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo[<span style=\"font-weight: bold\">bar]</span>baz",
	[["stylewithcss","true"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo[<span style=\"font-weight: bold\">bar]</span>baz",
	[["stylewithcss","false"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo<span style=\"font-weight: bold\">[bar</span>]baz",
	[["stylewithcss","true"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo<span style=\"font-weight: bold\">[bar</span>]baz",
	[["stylewithcss","false"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["<b>{<p>foo</p><p>bar</p>}<p>baz</p></b>",
	[["stylewithcss","true"],["bold",""]],
	"{<p>foo</p><p>bar</p>}<p><span style=\"font-weight:bold\">baz</span></p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["<b>{<p>foo</p><p>bar</p>}<p>baz</p></b>",
	[["stylewithcss","false"],["bold",""]],
	"{<p>foo</p><p>bar</p>}<p><b>baz</b></p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["<b><p>foo[<i>bar</i>}</p><p>baz</p></b>",
	[["stylewithcss","true"],["bold",""]],
	"<p><span style=\"font-weight:bold\">foo[</span><i>bar</i>}</p><p><span style=\"font-weight:bold\">baz</span></p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["<b><p>foo[<i>bar</i>}</p><p>baz</p></b>",
	[["stylewithcss","false"],["bold",""]],
	"<p><b>foo[</b><i>bar</i>}</p><p><b>baz</b></p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo [bar <b>baz] qoz</b> quz sic",
	[["bold",""]],
	"foo <b>[bar baz] qoz</b> quz sic",
	[true],
	{"bold":[true,false,"",false,true,""]}],
["foo bar <b>baz [qoz</b> quz] sic",
	[["bold",""]],
	"foo bar <b>baz [qoz quz]</b> sic",
	[true],
	{"bold":[true,false,"",false,true,""]}],
["<b id=purple>bar [baz] qoz</b>",
	[["stylewithcss","true"],["bold",""]],
	"<span id=\"purple\"><span style=\"font-weight:bold\">bar </span>[baz]<span style=\"font-weight:bold\"> qoz</span></span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["<b id=purple>bar [baz] qoz</b>",
	[["stylewithcss","false"],["bold",""]],
	"<span id=\"purple\"><b>bar </b>[baz]<b> qoz</b></span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo<span style=\"font-weight: 100\">[bar]</span>baz",
	[["stylewithcss","true"],["bold",""]],
	"foo<span style=\"font-weight:bold\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["foo<span style=\"font-weight: 100\">[bar]</span>baz",
	[["stylewithcss","false"],["bold",""]],
	"foo<b>[bar]</b>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["foo<span style=\"font-weight: 200\">[bar]</span>baz",
	[["stylewithcss","true"],["bold",""]],
	"foo<span style=\"font-weight:bold\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["foo<span style=\"font-weight: 200\">[bar]</span>baz",
	[["stylewithcss","false"],["bold",""]],
	"foo<b>[bar]</b>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["foo<span style=\"font-weight: 300\">[bar]</span>baz",
	[["stylewithcss","true"],["bold",""]],
	"foo<span style=\"font-weight:bold\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["foo<span style=\"font-weight: 300\">[bar]</span>baz",
	[["stylewithcss","false"],["bold",""]],
	"foo<b>[bar]</b>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["foo<span style=\"font-weight: 400\">[bar]</span>baz",
	[["stylewithcss","true"],["bold",""]],
	"foo<span style=\"font-weight:bold\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["foo<span style=\"font-weight: 400\">[bar]</span>baz",
	[["stylewithcss","false"],["bold",""]],
	"foo<b>[bar]</b>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["foo<span style=\"font-weight: 500\">[bar]</span>baz",
	[["stylewithcss","true"],["bold",""]],
	"foo<span style=\"font-weight:bold\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["foo<span style=\"font-weight: 500\">[bar]</span>baz",
	[["stylewithcss","false"],["bold",""]],
	"foo<b>[bar]</b>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["foo<span style=\"font-weight: 600\">[bar]</span>baz",
	[["stylewithcss","true"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo<span style=\"font-weight: 600\">[bar]</span>baz",
	[["stylewithcss","false"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo<span style=\"font-weight: 700\">[bar]</span>baz",
	[["stylewithcss","true"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo<span style=\"font-weight: 700\">[bar]</span>baz",
	[["stylewithcss","false"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo<span style=\"font-weight: 800\">[bar]</span>baz",
	[["stylewithcss","true"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo<span style=\"font-weight: 800\">[bar]</span>baz",
	[["stylewithcss","false"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo<span style=\"font-weight: 900\">[bar]</span>baz",
	[["stylewithcss","true"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo<span style=\"font-weight: 900\">[bar]</span>baz",
	[["stylewithcss","false"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo<span style=\"font-weight: 400\">[bar</span>]baz",
	[["stylewithcss","true"],["bold",""]],
	"foo<span style=\"font-weight:bold\">[bar</span>]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["foo<span style=\"font-weight: 400\">[bar</span>]baz",
	[["stylewithcss","false"],["bold",""]],
	"foo<b>[bar</b>]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["foo<span style=\"font-weight: 700\">[bar</span>]baz",
	[["stylewithcss","true"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo<span style=\"font-weight: 700\">[bar</span>]baz",
	[["stylewithcss","false"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo[<span style=\"font-weight: 400\">bar]</span>baz",
	[["stylewithcss","true"],["bold",""]],
	"foo[<span style=\"font-weight:bold\">bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["foo[<span style=\"font-weight: 400\">bar]</span>baz",
	[["stylewithcss","false"],["bold",""]],
	"foo[<b>bar]</b>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["foo[<span style=\"font-weight: 700\">bar]</span>baz",
	[["stylewithcss","true"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo[<span style=\"font-weight: 700\">bar]</span>baz",
	[["stylewithcss","false"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo[<span style=\"font-weight: 400\">bar</span>]baz",
	[["stylewithcss","true"],["bold",""]],
	"foo[<span style=\"font-weight:bold\">bar</span>]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["foo[<span style=\"font-weight: 400\">bar</span>]baz",
	[["stylewithcss","false"],["bold",""]],
	"foo[<b>bar</b>]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["foo[<span style=\"font-weight: 700\">bar</span>]baz",
	[["stylewithcss","true"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo[<span style=\"font-weight: 700\">bar</span>]baz",
	[["stylewithcss","false"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["<span style=\"font-weight: 100\">foo[bar]baz</span>",
	[["stylewithcss","true"],["bold",""]],
	"<span style=\"font-weight:100\">foo<span style=\"font-weight:bold\">[bar]</span>baz</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<span style=\"font-weight: 100\">foo[bar]baz</span>",
	[["stylewithcss","false"],["bold",""]],
	"<span style=\"font-weight:100\">foo<b>[bar]</b>baz</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<span style=\"font-weight: 400\">foo[bar]baz</span>",
	[["stylewithcss","true"],["bold",""]],
	"<span style=\"font-weight:400\">foo<span style=\"font-weight:bold\">[bar]</span>baz</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<span style=\"font-weight: 400\">foo[bar]baz</span>",
	[["stylewithcss","false"],["bold",""]],
	"<span style=\"font-weight:400\">foo<b>[bar]</b>baz</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<span style=\"font-weight: 700\">foo[bar]baz</span>",
	[["stylewithcss","true"],["bold",""]],
	"<span style=\"font-weight:700\">foo</span>[bar]<span style=\"font-weight:700\">baz</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["<span style=\"font-weight: 700\">foo[bar]baz</span>",
	[["stylewithcss","false"],["bold",""]],
	"<b>foo</b>[bar]<b>baz</b>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["<span style=\"font-weight: 900\">foo[bar]baz</span>",
	[["stylewithcss","true"],["bold",""]],
	"<span style=\"font-weight:900\">foo</span>[bar]<span style=\"font-weight:900\">baz</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["<span style=\"font-weight: 900\">foo[bar]baz</span>",
	[["stylewithcss","false"],["bold",""]],
	"<span style=\"font-weight:900\">foo</span>[bar]<span style=\"font-weight:900\">baz</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["{<span style=\"font-weight: 100\">foobar]baz</span>",
	[["stylewithcss","true"],["bold",""]],
	"{<span style=\"font-weight:100\"><span style=\"font-weight:bold\">foobar]</span>baz</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["{<span style=\"font-weight: 100\">foobar]baz</span>",
	[["stylewithcss","false"],["bold",""]],
	"{<span style=\"font-weight:100\"><b>foobar]</b>baz</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["{<span style=\"font-weight: 400\">foobar]baz</span>",
	[["stylewithcss","true"],["bold",""]],
	"{<span style=\"font-weight:400\"><span style=\"font-weight:bold\">foobar]</span>baz</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["{<span style=\"font-weight: 400\">foobar]baz</span>",
	[["stylewithcss","false"],["bold",""]],
	"{<span style=\"font-weight:400\"><b>foobar]</b>baz</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["{<span style=\"font-weight: 700\">foobar]baz</span>",
	[["stylewithcss","true"],["bold",""]],
	"{foobar]<span style=\"font-weight:700\">baz</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["{<span style=\"font-weight: 700\">foobar]baz</span>",
	[["stylewithcss","false"],["bold",""]],
	"{foobar]<b>baz</b>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["{<span style=\"font-weight: 900\">foobar]baz</span>",
	[["bold",""]],
	"{foobar]<span style=\"font-weight:900\">baz</span>",
	[true],
	{"bold":[false,true,"",false,false,""]}],
["<span style=\"font-weight: 100\">foo[barbaz</span>}",
	[["stylewithcss","true"],["bold",""]],
	"<span style=\"font-weight:100\">foo<span style=\"font-weight:bold\">[barbaz</span></span>}",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<span style=\"font-weight: 100\">foo[barbaz</span>}",
	[["stylewithcss","false"],["bold",""]],
	"<span style=\"font-weight:100\">foo<b>[barbaz</b></span>}",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<span style=\"font-weight: 400\">foo[barbaz</span>}",
	[["stylewithcss","true"],["bold",""]],
	"<span style=\"font-weight:400\">foo<span style=\"font-weight:bold\">[barbaz</span></span>}",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<span style=\"font-weight: 400\">foo[barbaz</span>}",
	[["stylewithcss","false"],["bold",""]],
	"<span style=\"font-weight:400\">foo<b>[barbaz</b></span>}",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<span style=\"font-weight: 700\">foo[barbaz</span>}",
	[["stylewithcss","true"],["bold",""]],
	"<span style=\"font-weight:700\">foo</span>[barbaz}",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["<span style=\"font-weight: 700\">foo[barbaz</span>}",
	[["stylewithcss","false"],["bold",""]],
	"<b>foo</b>[barbaz}",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["<span style=\"font-weight: 900\">foo[barbaz</span>}",
	[["bold",""]],
	"<span style=\"font-weight:900\">foo</span>[barbaz}",
	[true],
	{"bold":[false,true,"",false,false,""]}],
["<h3>foo[bar]baz</h3>",
	[["stylewithcss","true"],["bold",""]],
	"<h3>foo<span style=\"font-weight:normal\">[bar]</span>baz</h3>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["<h3>foo[bar]baz</h3>",
	[["stylewithcss","false"],["bold",""]],
	"<h3>foo<span style=\"font-weight:normal\">[bar]</span>baz</h3>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["{<h3>foobar]baz</h3>",
	[["stylewithcss","true"],["bold",""]],
	"{<h3><span style=\"font-weight:normal\">foobar]</span>baz</h3>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["{<h3>foobar]baz</h3>",
	[["stylewithcss","false"],["bold",""]],
	"{<h3><span style=\"font-weight:normal\">foobar]</span>baz</h3>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["<h3>foo[barbaz</h3>}",
	[["stylewithcss","true"],["bold",""]],
	"<h3>foo<span style=\"font-weight:normal\">[barbaz</span></h3>}",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["<h3>foo[barbaz</h3>}",
	[["stylewithcss","false"],["bold",""]],
	"<h3>foo<span style=\"font-weight:normal\">[barbaz</span></h3>}",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["<h3>[foobarbaz]</h3>",
	[["stylewithcss","true"],["bold",""]],
	"<h3><span style=\"font-weight:normal\">[foobarbaz]</span></h3>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["<h3>[foobarbaz]</h3>",
	[["stylewithcss","false"],["bold",""]],
	"<h3><span style=\"font-weight:normal\">[foobarbaz]</span></h3>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["{<h3>foobarbaz]</h3>",
	[["stylewithcss","true"],["bold",""]],
	"{<h3><span style=\"font-weight:normal\">foobarbaz]</span></h3>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["{<h3>foobarbaz]</h3>",
	[["stylewithcss","false"],["bold",""]],
	"{<h3><span style=\"font-weight:normal\">foobarbaz]</span></h3>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["<h3>[foobarbaz</h3>}",
	[["stylewithcss","true"],["bold",""]],
	"<h3><span style=\"font-weight:normal\">[foobarbaz</span></h3>}",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["<h3>[foobarbaz</h3>}",
	[["stylewithcss","false"],["bold",""]],
	"<h3><span style=\"font-weight:normal\">[foobarbaz</span></h3>}",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["{<h3>foobarbaz</h3>}",
	[["stylewithcss","true"],["bold",""]],
	"{<h3><span style=\"font-weight:normal\">foobarbaz</span></h3>}",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["{<h3>foobarbaz</h3>}",
	[["stylewithcss","false"],["bold",""]],
	"{<h3><span style=\"font-weight:normal\">foobarbaz</span></h3>}",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["<b>foo<span style=\"font-weight: normal\">bar<b>[baz]</b>quz</span>qoz</b>",
	[["stylewithcss","true"],["bold",""]],
	"<b>foo<span style=\"font-weight:normal\">bar[baz]quz</span>qoz</b>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["<b>foo<span style=\"font-weight: normal\">bar<b>[baz]</b>quz</span>qoz</b>",
	[["stylewithcss","false"],["bold",""]],
	"<b>foo<span style=\"font-weight:normal\">bar[baz]quz</span>qoz</b>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["<b>foo<span style=\"font-weight: normal\">[bar]</span>baz</b>",
	[["stylewithcss","true"],["bold",""]],
	"<b>foo[bar]baz</b>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<b>foo<span style=\"font-weight: normal\">[bar]</span>baz</b>",
	[["stylewithcss","false"],["bold",""]],
	"<b>foo[bar]baz</b>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["{<b>foo</b> <b>bar</b>}",
	[["stylewithcss","true"],["bold",""]],
	"{<span style=\"font-weight:bold\">foo bar}</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[true,false,"",false,true,""]}],
["{<b>foo</b> <b>bar</b>}",
	[["stylewithcss","false"],["bold",""]],
	"{<b>foo bar}</b>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[true,false,"",false,true,""]}],
["{<h3>foo</h3><b>bar</b>}",
	[["stylewithcss","true"],["bold",""]],
	"{<h3><span style=\"font-weight:normal\">foo</span></h3>bar}",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["{<h3>foo</h3><b>bar</b>}",
	[["stylewithcss","false"],["bold",""]],
	"{<h3><span style=\"font-weight:normal\">foo</span></h3>bar}",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["<i><b>foo</b></i>[bar]<i><b>baz</b></i>",
	[["stylewithcss","true"],["bold",""]],
	"<b><i>foo</i>[bar]<i>baz</i></b>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<i><b>foo</b></i>[bar]<i><b>baz</b></i>",
	[["stylewithcss","false"],["bold",""]],
	"<b><i>foo</i>[bar]<i>baz</i></b>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<i><b>foo</b></i>[bar]<b>baz</b>",
	[["stylewithcss","true"],["bold",""]],
	"<b><i>foo</i>[bar]baz</b>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<i><b>foo</b></i>[bar]<b>baz</b>",
	[["stylewithcss","false"],["bold",""]],
	"<b><i>foo</i>[bar]baz</b>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<b>foo</b>[bar]<i><b>baz</b></i>",
	[["stylewithcss","true"],["bold",""]],
	"<b>foo[bar]<i>baz</i></b>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<b>foo</b>[bar]<i><b>baz</b></i>",
	[["stylewithcss","false"],["bold",""]],
	"<b>foo[bar]<i>baz</i></b>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<font color=blue face=monospace><b>foo</b></font>[bar]",
	[["bold",""]],
	"<b><font color=\"blue\" face=\"monospace\">foo</font>[bar]</b>",
	[true],
	{"bold":[false,false,"",false,true,""]}],
["foo<span style=\"font-weight: normal\"><b>{bar}</b></span>baz",
	[["stylewithcss","true"],["bold",""]],
	"foo{bar}baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo<span style=\"font-weight: normal\"><b>{bar}</b></span>baz",
	[["stylewithcss","false"],["bold",""]],
	"foo{bar}baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["[foo<span class=notbold>bar</span>baz]",
	[["stylewithcss","true"],["bold",""]],
	"<span style=\"font-weight:bold\">[foo<span class=\"notbold\"><span style=\"font-weight:bold\">bar</span></span>baz]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["[foo<span class=notbold>bar</span>baz]",
	[["stylewithcss","false"],["bold",""]],
	"<b>[foo<span class=\"notbold\"><b>bar</b></span>baz]</b>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<b><span class=notbold>[foo]</span></b>",
	[["stylewithcss","true"],["bold",""]],
	"<span class=\"notbold\"><span style=\"font-weight:bold\">[foo]</span></span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<b><span class=notbold>[foo]</span></b>",
	[["stylewithcss","false"],["bold",""]],
	"<span class=\"notbold\"><b>[foo]</b></span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<b><span class=notbold>foo[bar]baz</span></b>",
	[["stylewithcss","true"],["bold",""]],
	"<b><span class=\"notbold\">foo<span style=\"font-weight:bold\">[bar]</span>baz</span></b>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<b><span class=notbold>foo[bar]baz</span></b>",
	[["stylewithcss","false"],["bold",""]],
	"<b><span class=\"notbold\">foo<b>[bar]</b>baz</span></b>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<p style=\"font-weight: bold\">foo[bar]baz</p>",
	[["stylewithcss","true"],["bold",""]],
	"<p><span style=\"font-weight:bold\">foo</span>[bar]<span style=\"font-weight:bold\">baz</span></p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["<p style=\"font-weight: bold\">foo[bar]baz</p>",
	[["stylewithcss","false"],["bold",""]],
	"<p><b>foo</b>[bar]<b>baz</b></p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["fo[o<b>b]ar</b>baz",
	[["bold",""]],
	"fo<b>[ob]ar</b>baz",
	[true],
	{"bold":[true,false,"",false,true,""]}],
["foo<b>ba[r</b>b]az",
	[["bold",""]],
	"foo<b>ba[rb]</b>az",
	[true],
	{"bold":[true,false,"",false,true,""]}],
["fo[o<b>bar</b>b]az",
	[["stylewithcss","true"],["bold",""]],
	"fo<span style=\"font-weight:bold\">[obarb]</span>az",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[true,false,"",false,true,""]}],
["fo[o<b>bar</b>b]az",
	[["stylewithcss","false"],["bold",""]],
	"fo<b>[obarb]</b>az",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[true,false,"",false,true,""]}],
["foo[<b>b]ar</b>baz",
	[["stylewithcss","true"],["bold",""]],
	"foo[b]<span style=\"font-weight:bold\">ar</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo[<b>b]ar</b>baz",
	[["stylewithcss","false"],["bold",""]],
	"foo[b]<b>ar</b>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo<b>ba[r</b>]baz",
	[["stylewithcss","true"],["bold",""]],
	"foo<span style=\"font-weight:bold\">ba</span>[r]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo<b>ba[r</b>]baz",
	[["stylewithcss","false"],["bold",""]],
	"foo<b>ba</b>[r]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo[<b>bar</b>]baz",
	[["stylewithcss","true"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo[<b>bar</b>]baz",
	[["stylewithcss","false"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo<b>[bar]</b>baz",
	[["stylewithcss","true"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo<b>[bar]</b>baz",
	[["stylewithcss","false"],["bold",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["foo{<b>bar</b>}baz",
	[["stylewithcss","true"],["bold",""]],
	"foo{bar}baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["foo{<b>bar</b>}baz",
	[["stylewithcss","false"],["bold",""]],
	"foo{bar}baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["fo[o<span style=font-weight:bold>b]ar</span>baz",
	[["bold",""]],
	"fo<span style=\"font-weight:bold\">[ob]ar</span>baz",
	[true],
	{"bold":[true,false,"",false,true,""]}],
["<span style=font-weight:800>fo[o</span><span style=font-weight:900>b]ar</span>",
	[["bold",""]],
	"<span style=\"font-weight:800\">fo</span>[ob]<span style=\"font-weight:900\">ar</span>",
	[true],
	{"bold":[false,true,"",false,false,""]}],
["<span style=font-weight:700>fo[o</span><span style=font-weight:800>b]ar</span>",
	[["stylewithcss","true"],["bold",""]],
	"<span style=\"font-weight:700\">fo</span>[ob]<span style=\"font-weight:800\">ar</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["<span style=font-weight:700>fo[o</span><span style=font-weight:800>b]ar</span>",
	[["stylewithcss","false"],["bold",""]],
	"<b>fo</b>[ob]<span style=\"font-weight:800\">ar</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["<span style=font-weight:600>fo[o</span><span style=font-weight:700>b]ar</span>",
	[["stylewithcss","true"],["bold",""]],
	"<span style=\"font-weight:600\">fo</span>[ob]<span style=\"font-weight:700\">ar</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,true,"",false,false,""]}],
["<span style=font-weight:600>fo[o</span><span style=font-weight:700>b]ar</span>",
	[["stylewithcss","false"],["bold",""]],
	"<span style=\"font-weight:600\">fo</span>[ob]<b>ar</b>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,true,"",false,false,""]}],
["<span style=font-weight:500>fo[o</span><span style=font-weight:600>b]ar</span>",
	[["stylewithcss","true"],["bold",""]],
	"<span style=\"font-weight:500\">fo<span style=\"font-weight:bold\">[o</span></span><span style=\"font-weight:600\"><span style=\"font-weight:bold\">b]</span>ar</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[true,false,"",false,true,""]}],
["<span style=font-weight:500>fo[o</span><span style=font-weight:600>b]ar</span>",
	[["stylewithcss","false"],["bold",""]],
	"<span style=\"font-weight:500\">fo<b>[o</b></span><span style=\"font-weight:600\"><b>b]</b>ar</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[true,false,"",false,true,""]}],
["<span style=font-weight:400>fo[o</span><span style=font-weight:500>b]ar</span>",
	[["stylewithcss","true"],["bold",""]],
	"<span style=\"font-weight:400\">fo<span style=\"font-weight:bold\">[o</span></span><span style=\"font-weight:500\"><span style=\"font-weight:bold\">b]</span>ar</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<span style=font-weight:400>fo[o</span><span style=font-weight:500>b]ar</span>",
	[["stylewithcss","false"],["bold",""]],
	"<span style=\"font-weight:400\">fo<b>[o</b></span><span style=\"font-weight:500\"><b>b]</b>ar</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<span style=font-weight:300>fo[o</span><span style=font-weight:400>b]ar</span>",
	[["stylewithcss","true"],["bold",""]],
	"<span style=\"font-weight:300\">fo<span style=\"font-weight:bold\">[o</span></span><span style=\"font-weight:400\"><span style=\"font-weight:bold\">b]</span>ar</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<span style=font-weight:300>fo[o</span><span style=font-weight:400>b]ar</span>",
	[["stylewithcss","false"],["bold",""]],
	"<span style=\"font-weight:300\">fo<b>[o</b></span><span style=\"font-weight:400\"><b>b]</b>ar</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<span style=font-weight:200>fo[o</span><span style=font-weight:300>b]ar</span>",
	[["stylewithcss","true"],["bold",""]],
	"<span style=\"font-weight:200\">fo<span style=\"font-weight:bold\">[o</span></span><span style=\"font-weight:300\"><span style=\"font-weight:bold\">b]</span>ar</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<span style=font-weight:200>fo[o</span><span style=font-weight:300>b]ar</span>",
	[["stylewithcss","false"],["bold",""]],
	"<span style=\"font-weight:200\">fo<b>[o</b></span><span style=\"font-weight:300\"><b>b]</b>ar</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["<span style=font-weight:100>fo[o</span><span style=font-weight:200>b]ar</span>",
	[["stylewithcss","true"],["bold",""]],
	"<span style=\"font-weight:100\">fo<span style=\"font-weight:bold\">[o</span></span><span style=\"font-weight:200\"><span style=\"font-weight:bold\">b]</span>ar</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"bold":[false,false,"",false,true,""]}],
["<span style=font-weight:100>fo[o</span><span style=font-weight:200>b]ar</span>",
	[["stylewithcss","false"],["bold",""]],
	"<span style=\"font-weight:100\">fo<b>[o</b></span><span style=\"font-weight:200\"><b>b]</b>ar</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"bold":[false,false,"",false,true,""]}],
["foo[]bar",
	[["createlink","http://www.google.com/"]],
	"foo[]bar",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["<p>[foo</p> <p>bar]</p>",
	[["createlink","http://www.google.com/"]],
	"<p><a href=\"http://www.google.com/\">[foo</a></p> <p><a href=\"http://www.google.com/\">bar]</a></p>",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["<span>[foo</span> <span>bar]</span>",
	[["createlink","http://www.google.com/"]],
	"<a href=\"http://www.google.com/\"><span>[foo</span> <span>bar]</span></a>",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
	[["createlink","http://www.google.com/"]],
	"<p><a href=\"http://www.google.com/\">[foo</a></p><p> <a href=\"http://www.google.com/\"><span>bar</span></a> </p><p><a href=\"http://www.google.com/\">baz]</a></p>",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["<p>[foo<p><br><p>bar]",
	[["createlink","http://www.google.com/"]],
	"<p><a href=\"http://www.google.com/\">[foo</a></p><p><a href=\"http://www.google.com/\"><br></a></p><p><a href=\"http://www.google.com/\">bar]</a></p>",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["<b>foo[]bar</b>",
	[["createlink","http://www.google.com/"]],
	"<b>foo[]bar</b>",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["<i>foo[]bar</i>",
	[["createlink","http://www.google.com/"]],
	"<i>foo[]bar</i>",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["<span>foo</span>{}<span>bar</span>",
	[["createlink","http://www.google.com/"]],
	"<span>foo</span>{}<span>bar</span>",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["<span>foo[</span><span>]bar</span>",
	[["createlink","http://www.google.com/"]],
	"<span>foo[</span><span>]bar</span>",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["foo[bar]baz",
	[["createlink","http://www.google.com/"]],
	"foo<a href=\"http://www.google.com/\">[bar]</a>baz",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["foo[bar<b>baz]qoz</b>quz",
	[["createlink","http://www.google.com/"]],
	"foo<a href=\"http://www.google.com/\">[bar</a><b><a href=\"http://www.google.com/\">baz]</a>qoz</b>quz",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["foo[bar<i>baz]qoz</i>quz",
	[["createlink","http://www.google.com/"]],
	"foo<a href=\"http://www.google.com/\">[bar</a><i><a href=\"http://www.google.com/\">baz]</a>qoz</i>quz",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["{<p><p> <p>foo</p>}",
	[["createlink","http://www.google.com/"]],
	"{<p></p><p> </p><p><a href=\"http://www.google.com/\">foo</a></p>}",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
	[["createlink","http://www.google.com/"]],
	"<table><tbody><tr><td>foo</td><td>b<a href=\"http://www.google.com/\">[a]</a>r</td><td>baz</td></tr></tbody></table>",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
	[["createlink","http://www.google.com/"]],
	"<table><tbody><tr><td>foo</td>{<td><a href=\"http://www.google.com/\">bar</a></td>}<td>baz</td></tr></tbody></table>",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
	[["createlink","http://www.google.com/"]],
	"<table><tbody><tr>{<td><a href=\"http://www.google.com/\">foo</a></td><td><a href=\"http://www.google.com/\">bar</a></td>}<td>baz</td></tr></tbody></table>",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
	[["createlink","http://www.google.com/"]],
	"<table><tbody>{<tr><td><a href=\"http://www.google.com/\">foo</a></td><td><a href=\"http://www.google.com/\">bar</a></td><td><a href=\"http://www.google.com/\">baz</a></td></tr>}</tbody></table>",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
	[["createlink","http://www.google.com/"]],
	"<table>{<tbody><tr><td><a href=\"http://www.google.com/\">foo</a></td><td><a href=\"http://www.google.com/\">bar</a></td><td><a href=\"http://www.google.com/\">baz</a></td></tr></tbody>}</table>",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
	[["createlink","http://www.google.com/"]],
	"{<table><tbody><tr><td><a href=\"http://www.google.com/\">foo</a></td><td><a href=\"http://www.google.com/\">bar</a></td><td><a href=\"http://www.google.com/\">baz</a></td></tr></tbody></table>}",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["<a href=http://www.google.com/>foo[bar]baz</a>",
	[["createlink","http://www.google.com/"]],
	"<a href=\"http://www.google.com/\">foo[bar]baz</a>",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["<a href=http://www.google.com/>foo[barbaz</a>}",
	[["createlink","http://www.google.com/"]],
	"<a href=\"http://www.google.com/\">foo[barbaz</a>}",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["{<a href=http://www.google.com/>foobar]baz</a>",
	[["createlink","http://www.google.com/"]],
	"{<a href=\"http://www.google.com/\">foobar]baz</a>",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["{<a href=http://www.google.com/>foobarbaz</a>}",
	[["createlink","http://www.google.com/"]],
	"{<a href=\"http://www.google.com/\">foobarbaz}</a>",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["<a href=http://www.google.com/>[foobarbaz]</a>",
	[["createlink","http://www.google.com/"]],
	"<a href=\"http://www.google.com/\">[foobarbaz]</a>",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com/>[bar]</a>baz",
	[["createlink","http://www.google.com/"]],
	"foo<a href=\"http://www.google.com/\">[bar]</a>baz",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["[foo]<a href=http://www.google.com/>bar</a>baz",
	[["createlink","http://www.google.com/"]],
	"<a href=\"http://www.google.com/\">[foo]bar</a>baz",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com/>bar</a>[baz]",
	[["createlink","http://www.google.com/"]],
	"foo<a href=\"http://www.google.com/\">bar[baz]</a>",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["foo[<a href=http://www.google.com/>bar</a>]baz",
	[["createlink","http://www.google.com/"]],
	"foo[<a href=\"http://www.google.com/\">bar</a>]baz",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com/>[bar</a>baz]",
	[["createlink","http://www.google.com/"]],
	"foo<a href=\"http://www.google.com/\">[barbaz]</a>",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com/>bar]</a>baz",
	[["createlink","http://www.google.com/"]],
	"<a href=\"http://www.google.com/\">[foobar]</a>baz",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com/>bar</a>baz]",
	[["createlink","http://www.google.com/"]],
	"<a href=\"http://www.google.com/\">[foobarbaz]</a>",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["<a href=otherurl>foo[bar]baz</a>",
	[["createlink","http://www.google.com/"]],
	"<a href=\"http://www.google.com/\">foo[bar]baz</a>",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["<a href=otherurl>foo[barbaz</a>}",
	[["createlink","http://www.google.com/"]],
	"<a href=\"http://www.google.com/\">foo[barbaz</a>}",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["{<a href=otherurl>foobar]baz</a>",
	[["createlink","http://www.google.com/"]],
	"{<a href=\"http://www.google.com/\">foobar]baz</a>",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["{<a href=otherurl>foobarbaz</a>}",
	[["createlink","http://www.google.com/"]],
	"{<a href=\"http://www.google.com/\">foobarbaz}</a>",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["<a href=otherurl>[foobarbaz]</a>",
	[["createlink","http://www.google.com/"]],
	"<a href=\"http://www.google.com/\">[foobarbaz]</a>",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["foo<a href=otherurl>[bar]</a>baz",
	[["createlink","http://www.google.com/"]],
	"foo<a href=\"http://www.google.com/\">[bar]</a>baz",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["foo[<a href=otherurl>bar</a>]baz",
	[["createlink","http://www.google.com/"]],
	"foo[<a href=\"http://www.google.com/\">bar</a>]baz",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["foo<a href=otherurl>[bar</a>baz]",
	[["createlink","http://www.google.com/"]],
	"foo<a href=\"http://www.google.com/\">[barbaz]</a>",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["[foo<a href=otherurl>bar]</a>baz",
	[["createlink","http://www.google.com/"]],
	"<a href=\"http://www.google.com/\">[foobar]</a>baz",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["[foo<a href=otherurl>bar</a>baz]",
	[["createlink","http://www.google.com/"]],
	"<a href=\"http://www.google.com/\">[foobarbaz]</a>",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["<a href=otherurl><b>foo[bar]baz</b></a>",
	[["createlink","http://www.google.com/"]],
	"<a href=\"http://www.google.com/\"><b>foo[bar]baz</b></a>",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["<a href=otherurl><b>foo[barbaz</b></a>}",
	[["createlink","http://www.google.com/"]],
	"<a href=\"http://www.google.com/\"><b>foo[barbaz</b></a>}",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["{<a href=otherurl><b>foobar]baz</b></a>",
	[["createlink","http://www.google.com/"]],
	"{<a href=\"http://www.google.com/\"><b>foobar]baz</b></a>",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["<a href=otherurl><b>[foobarbaz]</b></a>",
	[["createlink","http://www.google.com/"]],
	"<a href=\"http://www.google.com/\"><b>[foobarbaz]</b></a>",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["<a name=abc>foo[bar]baz</a>",
	[["createlink","http://www.google.com/"]],
	"<span name=\"abc\">foo<a href=\"http://www.google.com/\">[bar]</a>baz</span>",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["<a name=abc><b>foo[bar]baz</b></a>",
	[["createlink","http://www.google.com/"]],
	"<span name=\"abc\"><b>foo<a href=\"http://www.google.com/\">[bar]</a>baz</b></span>",
	[true],
	{"createlink":[false,false,"",false,false,""]}],
["foo[bar]baz",
	[["createlink",""]],
	"foo[bar]baz",
	[false],
	{"createlink":[false,false,"",false,false,""]}],
["foo[]bar",
	[["delete",""]],
	"fo[]bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<span>foo</span>{}<span>bar</span>",
	[["delete",""]],
	"<span>fo[]</span><span>bar</span>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<span>foo[</span><span>]bar</span>",
	[["delete",""]],
	"<span>foo[]</span><span>bar</span>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<span style=display:none>bar</span>[]baz",
	[["stylewithcss","true"],["delete",""]],
	"fo[]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["foo<span style=display:none>bar</span>[]baz",
	[["stylewithcss","false"],["delete",""]],
	"fo[]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"delete":[false,false,"",false,false,""]}],
["foo<script>bar</script>[]baz",
	[["delete",""]],
	"fo[]baz",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["fo&ouml;[]bar",
	[["delete",""]],
	"fo[]bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo&#x308;[]bar",
	[["delete",""]],
	"foo[]bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo&#x308;&#x327;[]bar",
	[["delete",""]],
	"foö[]bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["&ouml;[]bar",
	[["delete",""]],
	"{}bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["o&#x308;[]bar",
	[["delete",""]],
	"o[]bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["o&#x308;&#x327;[]bar",
	[["delete",""]],
	"ö[]bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["&#x5e9;&#x5c1;&#x5b8;[]&#x5dc;&#x5d5;&#x5b9;&#x5dd;",
	[["delete",""]],
	"שׁ[]לוֹם",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["&#x5e9;&#x5c1;&#x5b8;&#x5dc;&#x5d5;&#x5b9;[]&#x5dd;",
	[["delete",""]],
	"שָׁלו[]ם",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p>foo</p><p>[]bar</p>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<p>foo{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo</p><p>[]bar</p>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<p>foo{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo</p>[]bar",
	[["delete",""]],
	"<p>foo{}bar</p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<p>[]bar</p>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<p>[]bar</p>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo<br></p><p>[]bar</p>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<p>foo{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo<br></p><p>[]bar</p>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<p>foo{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo<br></p>[]bar",
	[["delete",""]],
	"<p>foo{}bar</p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<br><p>[]bar</p>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<br><p>[]bar</p>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo<br><br></p><p>[]bar</p>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<p>foo<br>{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo<br><br></p><p>[]bar</p>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<p>foo<br>{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo<br><br></p>[]bar",
	[["delete",""]],
	"<p>foo<br>{}bar</p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<br><br><p>[]bar</p>",
	[["delete",""]],
	"foo<br><p>{}bar</p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<div><p>foo</p></div><p>[]bar</p>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<div><p>foo{}bar</p></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<div><p>foo</p></div><p>[]bar</p>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<div><p>foo{}bar</p></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo</p><div><p>[]bar</p></div>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<p>foo{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo</p><div><p>[]bar</p></div>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<p>foo{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<div><p>foo</p></div><div><p>[]bar</p></div>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<div><p>foo{}bar</p></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<div><p>foo</p></div><div><p>[]bar</p></div>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<div><p>foo{}bar</p></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<div><p>foo</p></div>[]bar",
	[["delete",""]],
	"<div><p>foo{}bar</p></div>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<div><p>[]bar</p></div>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<div><p>[]bar</p></div>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<div>foo</div><div>[]bar</div>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<div>foo{}bar</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<div>foo</div><div>[]bar</div>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<div>foo{}bar</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<pre>foo</pre>[]bar",
	[["delete",""]],
	"<pre>foo{}bar</pre>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<br>[]bar",
	[["delete",""]],
	"foo{}bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<br><b>[]bar</b>",
	[["delete",""]],
	"foo{}<b>bar</b>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<hr>[]bar",
	[["delete",""]],
	"foo{}bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p>foo<hr><p>[]bar",
	[["delete",""]],
	"<p>foo</p><p>{}bar</p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p>foo</p><br><p>[]bar</p>",
	[["delete",""]],
	"<p>foo</p><p>{}bar</p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p>foo</p><br><br><p>[]bar</p>",
	[["delete",""]],
	"<p>foo</p><br><p>{}bar</p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p>foo</p><img src=/img/lion.svg><p>[]bar",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<p>foo</p><img src=\"/img/lion.svg\">{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo</p><img src=/img/lion.svg><p>[]bar",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<p>foo</p><img src=\"/img/lion.svg\">{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo<img src=/img/lion.svg>[]bar",
	[["delete",""]],
	"foo{}bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<a>foo</a>[]bar",
	[["delete",""]],
	"foo[]bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<a href=/>foo</a>[]bar",
	[["delete",""]],
	"foo[]bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<a name=abc>foo</a>[]bar",
	[["delete",""]],
	"foo[]bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<a href=/ name=abc>foo</a>[]bar",
	[["delete",""]],
	"foo[]bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<span><a>foo</a></span>[]bar",
	[["delete",""]],
	"<span>foo</span>[]bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<span><a href=/>foo</a></span>[]bar",
	[["delete",""]],
	"<span>foo</span>[]bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<span><a name=abc>foo</a></span>[]bar",
	[["delete",""]],
	"<span>foo</span>[]bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<span><a href=/ name=abc>foo</a></span>[]bar",
	[["delete",""]],
	"<span>foo</span>[]bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<a>[]bar</a>",
	[["delete",""]],
	"fo[]<a>bar</a>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<a href=/>[]bar</a>",
	[["delete",""]],
	"fo[]<a href=\"/\">bar</a>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<a name=abc>[]bar</a>",
	[["delete",""]],
	"fo[]<a name=\"abc\">bar</a>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<a href=/ name=abc>[]bar</a>",
	[["delete",""]],
	"fo[]<a href=\"/\" name=\"abc\">bar</a>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo &nbsp;[]",
	[["delete",""]],
	"foo&nbsp;[]",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["&nbsp;[] foo",
	[["delete",""]],
	"{}&nbsp;foo",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo &nbsp;[]bar",
	[["delete",""]],
	"foo []bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo&nbsp; []bar",
	[["delete",""]],
	"foo []bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo&nbsp;&nbsp;[]bar",
	[["delete",""]],
	"foo []bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo  []bar",
	[["delete",""]],
	"foo[]bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo []&nbsp; bar",
	[["delete",""]],
	"foo[]&nbsp; bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo &nbsp;[] bar",
	[["delete",""]],
	"foo&nbsp;[] bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo &nbsp; []bar",
	[["delete",""]],
	"foo&nbsp; []bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo []<span>&nbsp;</span> bar",
	[["delete",""]],
	"foo[]<span>&nbsp;</span> bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo <span>&nbsp;</span>[] bar",
	[["delete",""]],
	"foo&nbsp;{} bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo <span>&nbsp;</span> []bar",
	[["delete",""]],
	"foo&nbsp;<span> </span>{}bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<b>foo </b>&nbsp;[]bar",
	[["delete",""]],
	"<b>foo </b>{}bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<b>foo&nbsp;</b> []bar",
	[["delete",""]],
	"<b>foo </b>{}bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<b>foo&nbsp;</b>&nbsp;[]bar",
	[["delete",""]],
	"<b>foo </b>{}bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<b>foo </b> []bar",
	[["delete",""]],
	"<b>foo[]</b>bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p>foo </p><p>[] bar</p>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<p>foo{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo </p><p>[] bar</p>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<p>foo{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<pre>foo &nbsp;[]</pre>",
	[["delete",""]],
	"<pre>foo []</pre>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<pre>&nbsp;[] foo</pre>",
	[["delete",""]],
	"<pre>{} foo</pre>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<pre>foo &nbsp;[]bar</pre>",
	[["delete",""]],
	"<pre>foo []bar</pre>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<pre>foo&nbsp; []bar</pre>",
	[["delete",""]],
	"<pre>foo&nbsp;[]bar</pre>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<pre>foo  []bar</pre>",
	[["delete",""]],
	"<pre>foo []bar</pre>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo &nbsp;[]</div>",
	[["delete",""]],
	"<div style=\"white-space:pre\">foo []</div>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre>&nbsp;[] foo</div>",
	[["delete",""]],
	"<div style=\"white-space:pre\">{} foo</div>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo &nbsp;[]bar</div>",
	[["delete",""]],
	"<div style=\"white-space:pre\">foo []bar</div>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo&nbsp; []bar</div>",
	[["delete",""]],
	"<div style=\"white-space:pre\">foo&nbsp;[]bar</div>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo  []bar</div>",
	[["delete",""]],
	"<div style=\"white-space:pre\">foo []bar</div>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo &nbsp;[]</div>",
	[["delete",""]],
	"<div style=\"white-space:pre-wrap\">foo []</div>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>&nbsp;[] foo</div>",
	[["delete",""]],
	"<div style=\"white-space:pre-wrap\">{} foo</div>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo &nbsp;[]bar</div>",
	[["delete",""]],
	"<div style=\"white-space:pre-wrap\">foo []bar</div>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo&nbsp; []bar</div>",
	[["delete",""]],
	"<div style=\"white-space:pre-wrap\">foo&nbsp;[]bar</div>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo  []bar</div>",
	[["delete",""]],
	"<div style=\"white-space:pre-wrap\">foo []bar</div>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo &nbsp;[]</div>",
	[["delete",""]],
	"<div style=\"white-space:pre-line\">foo&nbsp;[]</div>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>&nbsp;[] foo</div>",
	[["delete",""]],
	"<div style=\"white-space:pre-line\">{}&nbsp;foo</div>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo &nbsp;[]bar</div>",
	[["delete",""]],
	"<div style=\"white-space:pre-line\">foo []bar</div>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo&nbsp; []bar</div>",
	[["delete",""]],
	"<div style=\"white-space:pre-line\">foo []bar</div>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo  []bar</div>",
	[["delete",""]],
	"<div style=\"white-space:pre-line\">foo[]bar</div>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo &nbsp;[]</div>",
	[["delete",""]],
	"<div style=\"white-space:nowrap\">foo&nbsp;[]</div>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>&nbsp;[] foo</div>",
	[["delete",""]],
	"<div style=\"white-space:nowrap\">{}&nbsp;foo</div>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo &nbsp;[]bar</div>",
	[["delete",""]],
	"<div style=\"white-space:nowrap\">foo []bar</div>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo&nbsp; []bar</div>",
	[["delete",""]],
	"<div style=\"white-space:nowrap\">foo []bar</div>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo  []bar</div>",
	[["delete",""]],
	"<div style=\"white-space:nowrap\">foo[]bar</div>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<table><tr><td>[]bar</table>baz",
	[["delete",""]],
	"foo<table><tbody><tr><td>[]bar</td></tr></tbody></table>baz",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<table><tr><td>bar</table>[]baz",
	[["delete",""]],
	"foo{<table><tbody><tr><td>bar</td></tr></tbody></table>}baz",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p>foo<table><tr><td>[]bar</table><p>baz",
	[["delete",""]],
	"<p>foo</p><table><tbody><tr><td>[]bar</td></tr></tbody></table><p>baz</p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p>foo<table><tr><td>bar</table><p>[]baz",
	[["delete",""]],
	"<p>foo</p>{<table><tbody><tr><td>bar</td></tr></tbody></table>}<p>baz</p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<table><tr><td>foo<td>[]bar</table>",
	[["delete",""]],
	"<table><tbody><tr><td>foo</td><td>{}bar</td></tr></tbody></table>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<table><tr><td>foo<tr><td>[]bar</table>",
	[["delete",""]],
	"<table><tbody><tr><td>foo</td></tr><tr><td>{}bar</td></tr></tbody></table>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<br><table><tr><td>[]bar</table>baz",
	[["delete",""]],
	"foo<table><tbody><tr><td>[]bar</td></tr></tbody></table>baz",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<table><tr><td>bar<br></table>[]baz",
	[["delete",""]],
	"foo{<table><tbody><tr><td>bar<br></td></tr></tbody></table>}baz",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p>foo<br><table><tr><td>[]bar</table><p>baz",
	[["delete",""]],
	"<p>foo<br></p><table><tbody><tr><td>[]bar</td></tr></tbody></table><p>baz</p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p>foo<table><tr><td>bar<br></table><p>[]baz",
	[["delete",""]],
	"<p>foo</p>{<table><tbody><tr><td>bar<br></td></tr></tbody></table>}<p>baz</p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<table><tr><td>foo<br><td>[]bar</table>",
	[["delete",""]],
	"<table><tbody><tr><td>foo</td><td>{}bar</td></tr></tbody></table>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<table><tr><td>foo<br><tr><td>[]bar</table>",
	[["delete",""]],
	"<table><tbody><tr><td>foo</td></tr><tr><td>{}bar</td></tr></tbody></table>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<br><br><table><tr><td>[]bar</table>baz",
	[["delete",""]],
	"foo<br><br><table><tbody><tr><td>[]bar</td></tr></tbody></table>baz",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<table><tr><td>bar<br><br></table>[]baz",
	[["delete",""]],
	"foo{<table><tbody><tr><td>bar<br><br></td></tr></tbody></table>}baz",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p>foo<br><br><table><tr><td>[]bar</table><p>baz",
	[["delete",""]],
	"<p>foo<br><br></p><table><tbody><tr><td>[]bar</td></tr></tbody></table><p>baz</p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p>foo<table><tr><td>bar<br><br></table><p>[]baz",
	[["delete",""]],
	"<p>foo</p>{<table><tbody><tr><td>bar<br><br></td></tr></tbody></table>}<p>baz</p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<table><tr><td>foo<br><br><td>[]bar</table>",
	[["delete",""]],
	"<table><tbody><tr><td>foo<br><br></td><td>{}bar</td></tr></tbody></table>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<table><tr><td>foo<br><br><tr><td>[]bar</table>",
	[["delete",""]],
	"<table><tbody><tr><td>foo<br><br></td></tr><tr><td>{}bar</td></tr></tbody></table>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<hr><table><tr><td>[]bar</table>baz",
	[["delete",""]],
	"foo<hr><table><tbody><tr><td>[]bar</td></tr></tbody></table>baz",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<table><tr><td>bar<hr></table>[]baz",
	[["delete",""]],
	"foo{<table><tbody><tr><td>bar<hr></td></tr></tbody></table>}baz",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<table><tr><td>foo<hr><td>[]bar</table>",
	[["delete",""]],
	"<table><tbody><tr><td>foo<hr></td><td>{}bar</td></tr></tbody></table>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<table><tr><td>foo<hr><tr><td>[]bar</table>",
	[["delete",""]],
	"<table><tbody><tr><td>foo<hr></td></tr><tr><td>{}bar</td></tr></tbody></table>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<ol><li>[]bar<li>baz</ol>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"foo<div>[]bar</div><ol><li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<ol><li>[]bar<li>baz</ol>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"foo<p>[]bar</p><ol><li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo<br><ol><li>[]bar<li>baz</ol>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"foo<div>[]bar</div><ol><li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<br><ol><li>[]bar<li>baz</ol>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"foo<p>[]bar</p><ol><li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo<br><br><ol><li>[]bar<li>baz</ol>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"foo<br><br><div>[]bar</div><ol><li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<br><br><ol><li>[]bar<li>baz</ol>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"foo<br><br><p>[]bar</p><ol><li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<li>[]bar</ol>",
	[["delete",""]],
	"<ol><li>foo<br>[]bar</li></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<br><li>[]bar</ol>",
	[["delete",""]],
	"<ol><li>foo<br>[]bar</li></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<br><br><li>[]bar</ol>",
	[["delete",""]],
	"<ol><li>foo<br><br>[]bar</li></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<li>[]bar<br>baz</ol>",
	[["delete",""]],
	"<ol><li>foo<br>[]bar<br>baz</li></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<br>bar<li>[]baz</ol>",
	[["delete",""]],
	"<ol><li>foo<br>bar<br>[]baz</li></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ol><li><p>foo</p>{}bar</ol>",
	[["delete",""]],
	"<ol><li><p>foo{}bar</p></li></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ol><li><p>foo<li>[]bar</ol>",
	[["delete",""]],
	"<ol><li><p>foo</p>[]bar</li></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<li><p>[]bar</ol>",
	[["delete",""]],
	"<ol><li>foo<p>[]bar</p></li></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ol><li><p>foo<li><p>[]bar</ol>",
	[["delete",""]],
	"<ol><li><p>foo</p><p>[]bar</p></li></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<ul><li>[]bar</ul></ol>",
	[["delete",""]],
	"<ol><li>foo</li><li>[]bar</li></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<ol><ol><li>[]bar</ol></ol>",
	[["delete",""]],
	"foo<ol><li>[]bar</li></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<div><ol><li>[]bar</ol></div>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"foo<div><div>[]bar</div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<div><ol><li>[]bar</ol></div>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"foo<div><p>[]bar</p></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo<dl><dt>[]bar<dd>baz</dl>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"foo<div>[]bar</div><dl><dd>baz</dd></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<dl><dt>[]bar<dd>baz</dl>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"foo<p>[]bar</p><dl><dd>baz</dd></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo<dl><dd>[]bar</dl>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"foo<div>[]bar</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<dl><dd>[]bar</dl>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"foo<p>[]bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<dl><dt>foo<dd>[]bar</dl>",
	[["delete",""]],
	"<dl><dt>foo<br>[]bar</dt></dl>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<dl><dt>foo<dt>[]bar<dd>baz</dl>",
	[["delete",""]],
	"<dl><dt>foo<br>[]bar</dt><dd>baz</dd></dl>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<dl><dt>foo<dd>bar<dd>[]baz</dl>",
	[["delete",""]],
	"<dl><dt>foo</dt><dd>bar<br>[]baz</dd></dl>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol>[]bar",
	[["delete",""]],
	"<ol><li>foo{}bar</li></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<br></ol>[]bar",
	[["delete",""]],
	"<ol><li>foo{}bar</li></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<br><br></ol>[]bar",
	[["delete",""]],
	"<ol><li>foo<br>{}bar</li></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ol><li><br></ol>[]bar",
	[["delete",""]],
	"<ol><li>{}bar</li></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<li><br></ol>[]bar",
	[["delete",""]],
	"<ol><li>foo</li><li>{}bar</li></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><p>[]bar",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<ol><li>foo{}bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><p>[]bar",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<ol><li>foo{}bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<br></ol><p>[]bar",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<ol><li>foo{}bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<br></ol><p>[]bar",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<ol><li>foo{}bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<br><br></ol><p>[]bar",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<ol><li>foo<br>{}bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<br><br></ol><p>[]bar",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<ol><li>foo<br>{}bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ol><li><br></ol><p>[]bar",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<ol><li>{}bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ol><li><br></ol><p>[]bar",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<ol><li>{}bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<li><br></ol><p>[]bar",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<ol><li>foo</li><li>{}bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<li><br></ol><p>[]bar",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<ol><li>foo</li><li>{}bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol>{}<br>",
	[["delete",""]],
	"<ol><li>foo{}</li></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<br></ol>{}<br>",
	[["delete",""]],
	"<ol><li>foo{}</li></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<br><br></ol>{}<br>",
	[["delete",""]],
	"<ol><li>foo<br>{}<br></li></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ol><li><br></ol>{}<br>",
	[["delete",""]],
	"<ol><li>{}<br></li></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<li><br></ol>{}<br>",
	[["delete",""]],
	"<ol><li>foo</li><li>{}<br></li></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><p>{}<br>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<ol><li>foo{}</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><p>{}<br>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<ol><li>foo{}</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<br></ol><p>{}<br>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<ol><li>foo{}</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<br></ol><p>{}<br>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<ol><li>foo{}</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<br><br></ol><p>{}<br>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<ol><li>foo<br>{}<br></li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<br><br></ol><p>{}<br>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<ol><li>foo<br>{}<br></li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ol><li><br></ol><p>{}<br>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<ol><li>{}<br></li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ol><li><br></ol><p>{}<br>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<ol><li>{}<br></li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<li><br></ol><p>{}<br>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<ol><li>foo</li><li>{}<br></li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo<li><br></ol><p>{}<br>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<ol><li>foo</li><li>{}<br></li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo<blockquote>[]bar</blockquote>",
	[["delete",""]],
	"foo<br>[]bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<blockquote><blockquote>[]bar</blockquote></blockquote>",
	[["delete",""]],
	"foo<blockquote>[]bar</blockquote>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<blockquote><div>[]bar</div></blockquote>",
	[["delete",""]],
	"foo<div>[]bar</div>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<blockquote style=\"color: blue\">[]bar</blockquote>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"foo<div style=\"color:rgb(0, 0, 255)\">[]bar</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<blockquote style=\"color: blue\">[]bar</blockquote>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"foo<div style=\"color:rgb(0, 0, 255)\">[]bar</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo<blockquote><blockquote><p>[]bar<p>baz</blockquote></blockquote>",
	[["delete",""]],
	"foo<blockquote><p>[]bar</p><blockquote><p>baz</p></blockquote></blockquote>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<blockquote><div><p>[]bar<p>baz</div></blockquote>",
	[["delete",""]],
	"foo<div><p>[]bar</p><blockquote><p>baz</p></blockquote></div>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<blockquote style=\"color: blue\"><p>[]bar<p>baz</blockquote>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"foo<div style=\"color:rgb(0, 0, 255)\"><p>[]bar</p><blockquote><p>baz</p></blockquote></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<blockquote style=\"color: blue\"><p>[]bar<p>baz</blockquote>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"foo<div style=\"color:rgb(0, 0, 255)\"><p>[]bar</p><blockquote><p>baz</p></blockquote></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo<blockquote><p><b>[]bar</b><p>baz</blockquote>",
	[["delete",""]],
	"foo<p><b>[]bar</b></p><blockquote><p>baz</p></blockquote>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<blockquote><p><strong>[]bar</strong><p>baz</blockquote>",
	[["delete",""]],
	"foo<p><strong>[]bar</strong></p><blockquote><p>baz</p></blockquote>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<blockquote><p><span>[]bar</span><p>baz</blockquote>",
	[["delete",""]],
	"foo<p><span>[]bar</span></p><blockquote><p>baz</p></blockquote>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<blockquote><ol><li>[]bar</ol></blockquote><p>extra",
	[["defaultparagraphseparator","div"],["delete",""]],
	"foo<blockquote><div>[]bar</div></blockquote><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<blockquote><ol><li>[]bar</ol></blockquote><p>extra",
	[["defaultparagraphseparator","p"],["delete",""]],
	"foo<blockquote><p>[]bar</p></blockquote><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo<blockquote>bar<ol><li>[]baz</ol>quz</blockquote><p>extra",
	[["defaultparagraphseparator","div"],["delete",""]],
	"foo<blockquote>bar<div>[]baz</div>quz</blockquote><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<blockquote>bar<ol><li>[]baz</ol>quz</blockquote><p>extra",
	[["defaultparagraphseparator","p"],["delete",""]],
	"foo<blockquote>bar<p>[]baz</p>quz</blockquote><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo<blockquote><ol><li>bar</li><ol><li>[]baz</ol><li>quz</ol></blockquote><p>extra",
	[["delete",""]],
	"foo<blockquote><ol><li>bar</li><li>[]baz</li><li>quz</li></ol></blockquote><p>extra</p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<span></span>[]bar",
	[["delete",""]],
	"fo[]bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<span><span></span></span>[]bar",
	[["delete",""]],
	"fo[]bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<quasit></quasit>[]bar",
	[["delete",""]],
	"fo[]bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<br><span></span>[]bar",
	[["delete",""]],
	"foo{}bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<span>foo<span></span></span>[]bar",
	[["delete",""]],
	"<span>fo[]</span>bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<span></span><span>[]bar</span>",
	[["delete",""]],
	"fo[]<span>bar</span>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<div><div><p>[]bar</div></div>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<div><div><p>[]bar</div></div>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo<div><div><p><!--abc-->[]bar</div></div>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<div><div><p><!--abc-->[]bar</div></div>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo<div><div><!--abc--><p>[]bar</div></div>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<div><div><!--abc--><p>[]bar</div></div>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo<div><!--abc--><div><p>[]bar</div></div>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<div><!--abc--><div><p>[]bar</div></div>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo<!--abc--><div><div><p>[]bar</div></div>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<!--abc--><div><div><p>[]bar</div></div>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</div></div>[]bar",
	[["delete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</div></div><!--abc-->[]bar",
	[["delete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</div><!--abc--></div>[]bar",
	[["delete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</p><!--abc--></div></div>[]bar",
	[["delete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo<!--abc--></div></div>[]bar",
	[["delete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</p></div></div><div><div><div>[]bar</div></div></div>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</p></div></div><div><div><div>[]bar</div></div></div>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo<!--abc--></p></div></div><div><div><div>[]bar</div></div></div>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo<!--abc--></p></div></div><div><div><div>[]bar</div></div></div>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</p><!--abc--></div></div><div><div><div>[]bar</div></div></div>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</p><!--abc--></div></div><div><div><div>[]bar</div></div></div>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</p></div><!--abc--></div><div><div><div>[]bar</div></div></div>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</p></div><!--abc--></div><div><div><div>[]bar</div></div></div>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</p></div></div><!--abc--><div><div><div>[]bar</div></div></div>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</p></div></div><!--abc--><div><div><div>[]bar</div></div></div>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</p></div></div><div><!--abc--><div><div>[]bar</div></div></div>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</p></div></div><div><!--abc--><div><div>[]bar</div></div></div>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</p></div></div><div><div><!--abc--><div>[]bar</div></div></div>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</p></div></div><div><div><!--abc--><div>[]bar</div></div></div>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</p></div></div><div><div><div><!--abc-->[]bar</div></div></div>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<div><div><p>foo</p></div></div><div><div><div><!--abc-->[]bar</div></div></div>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo<p>[]bar",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["delete",""]],
	"<p><span style=\"color:rgb(0, 0, 255)\">foo{}</span>bar</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo<p>[]bar",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["delete",""]],
	"<p><font color=\"#0000ff\">foo{}</font>bar</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo<p>[]bar",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["delete",""]],
	"<p><span style=\"color:rgb(0, 0, 255)\">foo{}</span>bar</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo<p>[]bar",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["delete",""]],
	"<p><font color=\"#0000ff\">foo{}</font>bar</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo<p style=color:brown>[]bar",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["delete",""]],
	"<p style=\"color:rgb(0, 0, 255)\">foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo<p style=color:brown>[]bar",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["delete",""]],
	"<p style=\"color:rgb(0, 0, 255)\">foo{}<font color=\"#a52a2a\">bar</font></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo<p style=color:brown>[]bar",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["delete",""]],
	"<p style=\"color:rgb(0, 0, 255)\">foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo<p style=color:brown>[]bar",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["delete",""]],
	"<p style=\"color:rgb(0, 0, 255)\">foo{}<font color=\"#a52a2a\">bar</font></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo<p style=color:rgba(0,0,255,1)>[]bar",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["delete",""]],
	"<p style=\"color:rgb(0, 0, 255)\">foo{}bar</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo<p style=color:rgba(0,0,255,1)>[]bar",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["delete",""]],
	"<p style=\"color:rgb(0, 0, 255)\">foo{}bar</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo<p style=color:rgba(0,0,255,1)>[]bar",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["delete",""]],
	"<p style=\"color:rgb(0, 0, 255)\">foo{}bar</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo<p style=color:rgba(0,0,255,1)>[]bar",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["delete",""]],
	"<p style=\"color:rgb(0, 0, 255)\">foo{}bar</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=color:transparent>foo<p style=color:rgba(0,0,0,0)>[]bar",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["delete",""]],
	"<p style=\"color:rgba(0, 0, 0, 0)\">foo{}bar</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p style=color:transparent>foo<p style=color:rgba(0,0,0,0)>[]bar",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["delete",""]],
	"<p style=\"color:rgba(0, 0, 0, 0)\">foo{}bar</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p style=color:transparent>foo<p style=color:rgba(0,0,0,0)>[]bar",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["delete",""]],
	"<p style=\"color:rgba(0, 0, 0, 0)\">foo{}bar</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=color:transparent>foo<p style=color:rgba(0,0,0,0)>[]bar",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["delete",""]],
	"<p style=\"color:rgba(0, 0, 0, 0)\">foo{}bar</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p style=color:brown>[]bar",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["delete",""]],
	"<p>foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p style=color:brown>[]bar",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["delete",""]],
	"<p>foo{}<font color=\"#a52a2a\">bar</font></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p style=color:brown>[]bar",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["delete",""]],
	"<p>foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p style=color:brown>[]bar",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["delete",""]],
	"<p>foo{}<font color=\"#a52a2a\">bar</font></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p><font color=blue>foo</font><p>[]bar",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<p><font color=\"blue\">foo</font>{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p><font color=blue>foo</font><p>[]bar",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<p><font color=\"blue\">foo</font>{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p><font color=blue>foo</font><p><font color=brown>[]bar</font>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<p><font color=\"blue\">foo</font>{}<font color=\"brown\">bar</font></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p><font color=blue>foo</font><p><font color=brown>[]bar</font>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<p><font color=\"blue\">foo</font>{}<font color=\"brown\">bar</font></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p><font color=brown>[]bar</font>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<p>foo{}<font color=\"brown\">bar</font></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p><font color=brown>[]bar</font>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<p>foo{}<font color=\"brown\">bar</font></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p><span style=color:blue>foo</font><p>[]bar",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<p><span style=\"color:rgb(0, 0, 255)\">foo</span>{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p><span style=color:blue>foo</font><p>[]bar",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<p><span style=\"color:rgb(0, 0, 255)\">foo</span>{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p><span style=color:blue>foo</font><p><span style=color:brown>[]bar</font>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<p><span style=\"color:rgb(0, 0, 255)\">foo</span>{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p><span style=color:blue>foo</font><p><span style=color:brown>[]bar</font>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<p><span style=\"color:rgb(0, 0, 255)\">foo</span>{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p><span style=color:brown>[]bar</font>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<p>foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p><span style=color:brown>[]bar</font>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<p>foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=background-color:aqua>foo<p>[]bar",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<p style=\"background-color:rgb(0, 255, 255)\">foo{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p style=background-color:aqua>foo<p>[]bar",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<p style=\"background-color:rgb(0, 255, 255)\">foo{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=background-color:aqua>foo<p style=background-color:tan>[]bar",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["delete",""]],
	"<p style=\"background-color:rgb(0, 255, 255)\">foo{}bar</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p style=background-color:aqua>foo<p style=background-color:tan>[]bar",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["delete",""]],
	"<p style=\"background-color:rgb(0, 255, 255)\">foo{}bar</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p style=background-color:aqua>foo<p style=background-color:tan>[]bar",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["delete",""]],
	"<p style=\"background-color:rgb(0, 255, 255)\">foo{}bar</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=background-color:aqua>foo<p style=background-color:tan>[]bar",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["delete",""]],
	"<p style=\"background-color:rgb(0, 255, 255)\">foo{}bar</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p style=background-color:tan>[]bar",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["delete",""]],
	"<p>foo{}bar</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p style=background-color:tan>[]bar",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["delete",""]],
	"<p>foo{}bar</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p style=background-color:tan>[]bar",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["delete",""]],
	"<p>foo{}bar</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p style=background-color:tan>[]bar",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["delete",""]],
	"<p>foo{}bar</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p><span style=background-color:aqua>foo</font><p>[]bar",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<p><span style=\"background-color:rgb(0, 255, 255)\">foo</span>{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p><span style=background-color:aqua>foo</font><p>[]bar",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<p><span style=\"background-color:rgb(0, 255, 255)\">foo</span>{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p><span style=background-color:aqua>foo</font><p><span style=background-color:tan>[]bar</font>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<p><span style=\"background-color:rgb(0, 255, 255)\">foo</span>{}<span style=\"background-color:rgb(210, 180, 140)\">bar</span></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p><span style=background-color:aqua>foo</font><p><span style=background-color:tan>[]bar</font>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<p><span style=\"background-color:rgb(0, 255, 255)\">foo</span>{}<span style=\"background-color:rgb(210, 180, 140)\">bar</span></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p><span style=background-color:tan>[]bar</font>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<p>foo{}<span style=\"background-color:rgb(210, 180, 140)\">bar</span></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p><span style=background-color:tan>[]bar</font>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<p>foo{}<span style=\"background-color:rgb(210, 180, 140)\">bar</span></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=text-decoration:underline>foo<p>[]bar",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["delete",""]],
	"<p><span style=\"text-decoration:underline\">foo{}</span>bar</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p style=text-decoration:underline>foo<p>[]bar",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["delete",""]],
	"<p><u>foo{}</u>bar</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p style=text-decoration:underline>foo<p>[]bar",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["delete",""]],
	"<p><span style=\"text-decoration:underline\">foo{}</span>bar</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=text-decoration:underline>foo<p>[]bar",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["delete",""]],
	"<p><u>foo{}</u>bar</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=text-decoration:underline>foo<p style=text-decoration:line-through>[]bar",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["delete",""]],
	"<p><span style=\"text-decoration:underline\">foo{}</span><span style=\"text-decoration:line-through\">bar</span></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p style=text-decoration:underline>foo<p style=text-decoration:line-through>[]bar",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["delete",""]],
	"<p><u>foo{}</u><s>bar</s></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p style=text-decoration:underline>foo<p style=text-decoration:line-through>[]bar",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["delete",""]],
	"<p><span style=\"text-decoration:underline\">foo{}</span><span style=\"text-decoration:line-through\">bar</span></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=text-decoration:underline>foo<p style=text-decoration:line-through>[]bar",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["delete",""]],
	"<p><u>foo{}</u><s>bar</s></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p style=text-decoration:line-through>[]bar",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["delete",""]],
	"<p>foo{}<span style=\"text-decoration:line-through\">bar</span></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p style=text-decoration:line-through>[]bar",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["delete",""]],
	"<p>foo{}<s>bar</s></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p style=text-decoration:line-through>[]bar",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["delete",""]],
	"<p>foo{}<span style=\"text-decoration:line-through\">bar</span></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p style=text-decoration:line-through>[]bar",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["delete",""]],
	"<p>foo{}<s>bar</s></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p><u>foo</u><p>[]bar",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<p><u>foo</u>{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p><u>foo</u><p>[]bar",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<p><u>foo</u>{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p><u>foo</u><p><s>[]bar</s>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<p><u>foo</u>{}<s>bar</s></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p><u>foo</u><p><s>[]bar</s>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<p><u>foo</u>{}<s>bar</s></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p><s>[]bar</s>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<p>foo{}<s>bar</s></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo<p><s>[]bar</s>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<p>foo{}<s>bar</s></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo</p>[]bar",
	[["stylewithcss","true"],["delete",""]],
	"<p><span style=\"color:rgb(0, 0, 255)\">foo{}</span>bar</p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo</p>[]bar",
	[["stylewithcss","false"],["delete",""]],
	"<p><font color=\"#0000ff\">foo{}</font>bar</p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"delete":[false,false,"",false,false,""]}],
["foo<p style=color:brown>[]bar",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["delete",""]],
	"foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<p style=color:brown>[]bar",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["delete",""]],
	"foo{}<font color=\"#a52a2a\">bar</font>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<p style=color:brown>[]bar",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["delete",""]],
	"foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo<p style=color:brown>[]bar",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["delete",""]],
	"foo{}<font color=\"#a52a2a\">bar</font>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<div style=color:blue><p style=color:green>foo</div>[]bar",
	[["stylewithcss","true"],["delete",""]],
	"<div><p><span style=\"color:rgb(0, 128, 0)\">foo{}</span>bar</p></div>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["<div style=color:blue><p style=color:green>foo</div>[]bar",
	[["stylewithcss","false"],["delete",""]],
	"<div><p><font color=\"#008000\">foo{}</font>bar</p></div>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"delete":[false,false,"",false,false,""]}],
["<div style=color:blue><p style=color:green>foo</div><p style=color:brown>[]bar",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["delete",""]],
	"<div style=\"color:rgb(0, 0, 255)\"><p style=\"color:rgb(0, 128, 0)\">foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p></div>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<div style=color:blue><p style=color:green>foo</div><p style=color:brown>[]bar",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["delete",""]],
	"<div style=\"color:rgb(0, 0, 255)\"><p style=\"color:rgb(0, 128, 0)\">foo{}<font color=\"#a52a2a\">bar</font></p></div>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<div style=color:blue><p style=color:green>foo</div><p style=color:brown>[]bar",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["delete",""]],
	"<div style=\"color:rgb(0, 0, 255)\"><p style=\"color:rgb(0, 128, 0)\">foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p></div>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<div style=color:blue><p style=color:green>foo</div><p style=color:brown>[]bar",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["delete",""]],
	"<div style=\"color:rgb(0, 0, 255)\"><p style=\"color:rgb(0, 128, 0)\">foo{}<font color=\"#a52a2a\">bar</font></p></div>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo<div style=color:brown><p style=color:green>[]bar",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["delete",""]],
	"<p style=\"color:rgb(0, 0, 255)\">foo{}<span style=\"color:rgb(0, 128, 0)\">bar</span></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo<div style=color:brown><p style=color:green>[]bar",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["delete",""]],
	"<p style=\"color:rgb(0, 0, 255)\">foo{}<font color=\"#008000\">bar</font></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo<div style=color:brown><p style=color:green>[]bar",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["delete",""]],
	"<p style=\"color:rgb(0, 0, 255)\">foo{}<span style=\"color:rgb(0, 128, 0)\">bar</span></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo<div style=color:brown><p style=color:green>[]bar",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["delete",""]],
	"<p style=\"color:rgb(0, 0, 255)\">foo{}<font color=\"#008000\">bar</font></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo[bar]baz",
	[["delete",""]],
	"foo[]baz",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar]</span>baz",
	[["stylewithcss","true"],["delete",""]],
	"<p>foo{}baz</p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar]</span>baz",
	[["stylewithcss","false"],["delete",""]],
	"<p>foo{}baz</p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"delete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar}</span>baz",
	[["stylewithcss","true"],["delete",""]],
	"<p>foo{}baz</p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar}</span>baz",
	[["stylewithcss","false"],["delete",""]],
	"<p>foo{}baz</p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"delete":[false,false,"",false,false,""]}],
["<p>foo{<span style=color:#aBcDeF>bar</span>}baz",
	[["stylewithcss","true"],["delete",""]],
	"<p>foo{}baz</p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["<p>foo{<span style=color:#aBcDeF>bar</span>}baz",
	[["stylewithcss","false"],["delete",""]],
	"<p>foo{}baz</p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"delete":[false,false,"",false,false,""]}],
["<p>[foo<span style=color:#aBcDeF>bar]</span>baz",
	[["stylewithcss","true"],["delete",""]],
	"<p>{}baz</p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["<p>[foo<span style=color:#aBcDeF>bar]</span>baz",
	[["stylewithcss","false"],["delete",""]],
	"<p>{}baz</p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"delete":[false,false,"",false,false,""]}],
["<p>{foo<span style=color:#aBcDeF>bar}</span>baz",
	[["stylewithcss","true"],["delete",""]],
	"<p>{}baz</p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["<p>{foo<span style=color:#aBcDeF>bar}</span>baz",
	[["stylewithcss","false"],["delete",""]],
	"<p>{}baz</p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"delete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span>baz]",
	[["stylewithcss","true"],["delete",""]],
	"<p>foo{}</p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span>baz]",
	[["stylewithcss","false"],["delete",""]],
	"<p>foo{}</p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"delete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar</span>baz}",
	[["stylewithcss","true"],["delete",""]],
	"<p>foo{}</p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar</span>baz}",
	[["stylewithcss","false"],["delete",""]],
	"<p>foo{}</p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"delete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span><span style=color:#fEdCbA>baz]</span>quz",
	[["stylewithcss","true"],["delete",""]],
	"<p>foo{}quz</p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span><span style=color:#fEdCbA>baz]</span>quz",
	[["stylewithcss","false"],["delete",""]],
	"<p>foo{}quz</p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"delete":[false,false,"",false,false,""]}],
["foo<b>[bar]</b>baz",
	[["stylewithcss","true"],["delete",""]],
	"foo{}baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["foo<b>[bar]</b>baz",
	[["stylewithcss","false"],["delete",""]],
	"foo{}baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"delete":[false,false,"",false,false,""]}],
["foo<b>{bar}</b>baz",
	[["stylewithcss","true"],["delete",""]],
	"foo{}baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["foo<b>{bar}</b>baz",
	[["stylewithcss","false"],["delete",""]],
	"foo{}baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"delete":[false,false,"",false,false,""]}],
["foo{<b>bar</b>}baz",
	[["stylewithcss","true"],["delete",""]],
	"foo{}baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["foo{<b>bar</b>}baz",
	[["stylewithcss","false"],["delete",""]],
	"foo{}baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"delete":[false,false,"",false,false,""]}],
["foo<span>[bar]</span>baz",
	[["delete",""]],
	"foo{}baz",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<span>{bar}</span>baz",
	[["delete",""]],
	"foo{}baz",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo{<span>bar</span>}baz",
	[["delete",""]],
	"foo{}baz",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<b>foo[bar</b><i>baz]quz</i>",
	[["delete",""]],
	"<b>foo[]</b><i>quz</i>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p>foo</p><p>[bar]</p><p>baz</p>",
	[["delete",""]],
	"<p>foo</p><p>{}<br></p><p>baz</p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p>foo</p><p>{bar}</p><p>baz</p>",
	[["delete",""]],
	"<p>foo</p><p>{}<br></p><p>baz</p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p>foo</p><p>{bar</p>}<p>baz</p>",
	[["delete",""]],
	"<p>foo</p><p>{}<br></p><p>baz</p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p>foo</p>{<p>bar}</p><p>baz</p>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<p>foo</p>{}<br><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo</p>{<p>bar}</p><p>baz</p>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<p>foo</p>{}<br><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo</p>{<p>bar</p>}<p>baz</p>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<p>foo</p>{}<p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo</p>{<p>bar</p>}<p>baz</p>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<p>foo</p>{}<p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo[bar<p>baz]quz",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<p>foo{}quz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo[bar<p>baz]quz",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<p>foo{}quz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo[bar<div>baz]quz</div>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<p>foo{}quz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo[bar<div>baz]quz</div>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<p>foo{}quz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo[bar<h1>baz]quz</h1>",
	[["delete",""]],
	"<p>foo{}quz</p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<div>foo[bar</div><p>baz]quz",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<div>foo{}quz</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<div>foo[bar</div><p>baz]quz",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<div>foo{}quz</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<blockquote>foo[bar</blockquote><pre>baz]quz</pre>",
	[["delete",""]],
	"<blockquote>foo{}quz</blockquote>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p><b>foo[bar</b><p>baz]quz",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<p><b>foo</b>{}quz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p><b>foo[bar</b><p>baz]quz",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<p><b>foo</b>{}quz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<div><p>foo[bar</div><p>baz]quz",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<div><p>foo{}quz</p></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<div><p>foo[bar</div><p>baz]quz",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<div><p>foo{}quz</p></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo[bar<blockquote><p>baz]quz<p>qoz</blockquote",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<p>foo{}quz</p><blockquote><p>qoz</p></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo[bar<blockquote><p>baz]quz<p>qoz</blockquote",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<p>foo{}quz</p><blockquote><p>qoz</p></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo[bar<p style=color:blue>baz]quz",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["delete",""]],
	"<p>foo{}<span style=\"color:rgb(0, 0, 255)\">quz</span></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo[bar<p style=color:blue>baz]quz",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["delete",""]],
	"<p>foo{}<font color=\"#0000ff\">quz</font></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo[bar<p style=color:blue>baz]quz",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["delete",""]],
	"<p>foo{}<span style=\"color:rgb(0, 0, 255)\">quz</span></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo[bar<p style=color:blue>baz]quz",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["delete",""]],
	"<p>foo{}<font color=\"#0000ff\">quz</font></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo[bar<p><b>baz]quz</b>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<p>foo{}<b>quz</b></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo[bar<p><b>baz]quz</b>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<p>foo{}<b>quz</b></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<div><p>foo<p>[bar<p>baz]</div>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<div><p>foo</p><p>{}<br></p></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<div><p>foo<p>[bar<p>baz]</div>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<div><p>foo</p><p>{}<br></p></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo[<br>]bar",
	[["delete",""]],
	"foo{}bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p>foo[</p><p>]bar</p>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<p>foo{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo[</p><p>]bar</p>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<p>foo{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo[</p><p>]bar<br>baz</p>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<p>foo{}bar<br>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo[</p><p>]bar<br>baz</p>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<p>foo{}bar<br>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo[<p>]bar</p>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo[<p>]bar</p>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo{<p>}bar</p>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo{<p>}bar</p>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo[<p>]bar<br>baz</p>",
	[["delete",""]],
	"foo{}bar<p>baz</p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo[<p>]bar</p>baz",
	[["defaultparagraphseparator","div"],["delete",""]],
	"foo{}bar<br>baz",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo[<p>]bar</p>baz",
	[["defaultparagraphseparator","p"],["delete",""]],
	"foo{}bar<br>baz",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo{<p>bar</p>}baz",
	[["defaultparagraphseparator","div"],["delete",""]],
	"foo{}baz",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo{<p>bar</p>}baz",
	[["defaultparagraphseparator","p"],["delete",""]],
	"foo{}baz",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo<p>{bar</p>}baz",
	[["delete",""]],
	"foo<p>{}baz</p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo{<p>bar}</p>baz",
	[["defaultparagraphseparator","div"],["delete",""]],
	"foo{}<br>baz",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo{<p>bar}</p>baz",
	[["defaultparagraphseparator","p"],["delete",""]],
	"foo{}<br>baz",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo[</p>]bar",
	[["delete",""]],
	"<p>foo{}bar</p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p>foo{</p>}bar",
	[["delete",""]],
	"<p>foo{}bar</p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p>foo[</p>]bar<br>baz",
	[["delete",""]],
	"<p>foo{}bar</p>baz",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p>foo[</p>]bar<p>baz</p>",
	[["delete",""]],
	"<p>foo{}bar</p><p>baz</p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo[<div><p>]bar</div>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo[<div><p>]bar</div>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<div><p>foo[</p></div>]bar",
	[["delete",""]],
	"<div><p>foo{}bar</p></div>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo[<div><p>]bar</p>baz</div>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"foo{}bar<div>baz</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo[<div><p>]bar</p>baz</div>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"foo{}bar<div>baz</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo[<div>]bar<p>baz</p></div>",
	[["delete",""]],
	"foo{}bar<div><p>baz</p></div>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<div><p>foo</p>bar[</div>]baz",
	[["delete",""]],
	"<div><p>foo</p>bar{}baz</div>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<div>foo<p>bar[</p></div>]baz",
	[["delete",""]],
	"<div>foo<p>bar{}baz</p></div>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p>foo<br>{</p>]bar",
	[["delete",""]],
	"<p>foo{}bar</p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p>foo<br><br>{</p>]bar",
	[["delete",""]],
	"<p>foo<br>{}bar</p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<br>{<p>]bar</p>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<br>{<p>]bar</p>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["foo<br><br>{<p>]bar</p>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"foo<br>{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["foo<br><br>{<p>]bar</p>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"foo<br>{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo<br>{</p><p>}bar</p>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<p>foo{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo<br>{</p><p>}bar</p>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<p>foo{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo<br><br>{</p><p>}bar</p>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<p>foo<br>{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo<br><br>{</p><p>}bar</p>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<p>foo<br>{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<table><tbody><tr><th>foo<th>[bar]<th>baz<tr><td>quz<td>qoz<td>qiz</table>",
	[["delete",""]],
	"<table><tbody><tr><th>foo</th><th>{}<br></th><th>baz</th></tr><tr><td>quz</td><td>qoz</td><td>qiz</td></tr></tbody></table>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<table><tbody><tr><th>foo<th>ba[r<th>b]az<tr><td>quz<td>qoz<td>qiz</table>",
	[["delete",""]],
	"<table><tbody><tr><th>foo</th><th>ba[]</th><th>az</th></tr><tr><td>quz</td><td>qoz</td><td>qiz</td></tr></tbody></table>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<table><tbody><tr><th>fo[o<th>bar<th>b]az<tr><td>quz<td>qoz<td>qiz</table>",
	[["delete",""]],
	"<table><tbody><tr><th>fo[]</th><th><br></th><th>az</th></tr><tr><td>quz</td><td>qoz</td><td>qiz</td></tr></tbody></table>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<table><tbody><tr><th>foo<th>bar<th>ba[z<tr><td>q]uz<td>qoz<td>qiz</table>",
	[["delete",""]],
	"<table><tbody><tr><th>foo</th><th>bar</th><th>ba[]</th></tr><tr><td>uz</td><td>qoz</td><td>qiz</td></tr></tbody></table>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<table><tbody><tr><th>[foo<th>bar<th>baz]<tr><td>quz<td>qoz<td>qiz</table>",
	[["delete",""]],
	"<table><tbody><tr><th>{}<br></th><th><br></th><th><br></th></tr><tr><td>quz</td><td>qoz</td><td>qiz</td></tr></tbody></table>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<table><tbody><tr><th>[foo<th>bar<th>baz<tr><td>quz<td>qoz<td>qiz]</table>",
	[["delete",""]],
	"<table><tbody><tr><th>{}<br></th><th><br></th><th><br></th></tr><tr><td><br></td><td><br></td><td><br></td></tr></tbody></table>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["{<table><tbody><tr><th>foo<th>bar<th>baz<tr><td>quz<td>qoz<td>qiz</table>}",
	[["delete",""]],
	"{}<br>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<table><tbody><tr><td>foo<td>ba[r<tr><td>baz<td>quz<tr><td>q]oz<td>qiz</table>",
	[["delete",""]],
	"<table><tbody><tr><td>foo</td><td>ba[]</td></tr><tr><td><br></td><td><br></td></tr><tr><td>oz</td><td>qiz</td></tr></tbody></table>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p>fo[o<table><tr><td>b]ar</table><p>baz",
	[["delete",""]],
	"<p>fo[]</p><table><tbody><tr><td>ar</td></tr></tbody></table><p>baz</p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p>foo<table><tr><td>ba[r</table><p>b]az",
	[["delete",""]],
	"<p>foo</p><table><tbody><tr><td>ba[]</td></tr></tbody></table><p>az</p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p>fo[o<table><tr><td>bar</table><p>b]az",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<p>fo{}az</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>fo[o<table><tr><td>bar</table><p>b]az",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<p>fo{}az</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>foo<ol><li>ba[r<li>b]az</ol><p>quz",
	[["delete",""]],
	"<p>foo</p><ol><li>ba{}az</li></ol><p>quz</p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p>foo<ol><li>bar<li>[baz]</ol><p>quz",
	[["delete",""]],
	"<p>foo</p><ol><li>bar</li><li>{}<br></li></ol><p>quz</p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p>fo[o<ol><li>b]ar<li>baz</ol><p>quz",
	[["delete",""]],
	"<p>fo{}ar</p><ol><li>baz</li></ol><p>quz</p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p>foo<ol><li>bar<li>ba[z</ol><p>q]uz",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<p>foo</p><ol><li>bar</li><li>ba{}uz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>foo<ol><li>bar<li>ba[z</ol><p>q]uz",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<p>foo</p><ol><li>bar</li><li>ba{}uz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p>fo[o<ol><li>bar<li>b]az</ol><p>quz",
	[["delete",""]],
	"<p>fo{}az</p><p>quz</p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p>fo[o<ol><li>bar<li>baz</ol><p>q]uz",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<p>fo{}uz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<p>fo[o<ol><li>bar<li>baz</ol><p>q]uz",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<p>fo{}uz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ol><li>fo[o</ol><ol><li>b]ar</ol>",
	[["delete",""]],
	"<ol><li>fo{}ar</li></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ol><li>fo[o</ol><ul><li>b]ar</ul>",
	[["delete",""]],
	"<ol><li>fo{}ar</li></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo[<ol><li>]bar</ol>",
	[["delete",""]],
	"foo{}bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ol><li>foo[<li>]bar</ol>",
	[["delete",""]],
	"<ol><li>foo{}bar</li></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo[<dl><dt>]bar<dd>baz</dl>",
	[["delete",""]],
	"foo{}bar<dl><dd>baz</dd></dl>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo[<dl><dd>]bar</dl>",
	[["delete",""]],
	"foo{}bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<dl><dt>foo[<dd>]bar</dl>",
	[["delete",""]],
	"<dl><dt>foo{}bar</dt></dl>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<dl><dt>foo[<dt>]bar<dd>baz</dl>",
	[["delete",""]],
	"<dl><dt>foo{}bar</dt><dd>baz</dd></dl>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<dl><dt>foo<dd>bar[<dd>]baz</dl>",
	[["delete",""]],
	"<dl><dt>foo</dt><dd>bar{}baz</dd></dl>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<b>foo [&nbsp;</b>bar]",
	[["delete",""]],
	"<b>foo&nbsp;[]</b>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo<b> [&nbsp;bar]</b>",
	[["delete",""]],
	"foo<b>&nbsp;[]</b>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<b>[foo&nbsp;] </b>bar",
	[["delete",""]],
	"<b>{}&nbsp;</b>bar",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["[foo<b>&nbsp;] bar</b>",
	[["delete",""]],
	"{}<b>&nbsp;bar</b>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p style=display:inline>fo[o<p style=display:inline>b]ar",
	[["delete",""]],
	"<p style=\"display:inline\">fo[]</p><p style=\"display:inline\">ar</p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<span style=display:block>fo[o</span><span style=display:block>b]ar</span>",
	[["stylewithcss","true"],["delete",""]],
	"<span style=\"display:block\">fo{}ar</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["<span style=display:block>fo[o</span><span style=display:block>b]ar</span>",
	[["stylewithcss","false"],["delete",""]],
	"<span style=\"display:block\">fo{}ar</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"delete":[false,false,"",false,false,""]}],
["<span style=display:inline-block>fo[o</span><span style=display:inline-block>b]ar</span>",
	[["delete",""]],
	"<span style=\"display:inline-block\">fo[]</span><span style=\"display:inline-block\">ar</span>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<span style=display:inline-table>fo[o</span><span style=display:inline-table>b]ar</span>",
	[["delete",""]],
	"<span style=\"display:inline-table\">fo[]</span><span style=\"display:inline-table\">ar</span>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<span style=display:none>fo[o</span><span style=display:none>b]ar</span>",
	[["delete",""]],
	"<span style=\"display:none\">fo[]</span><span style=\"display:none\">ar</span>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<quasit style=display:block>fo[o</quasit><quasit style=display:block>b]ar</quasit>",
	[["stylewithcss","true"],["delete",""]],
	"<quasit style=\"display:block\">fo{}ar</quasit>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["<quasit style=display:block>fo[o</quasit><quasit style=display:block>b]ar</quasit>",
	[["stylewithcss","false"],["delete",""]],
	"<quasit style=\"display:block\">fo{}ar</quasit>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol>{}<br><ol><li>bar</ol>",
	[["delete",""]],
	"<ol><li>foo{}</li><li>bar</li></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><p>{}<br></p><ol><li>bar</ol>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<ol><li>foo{}</li><li>bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><p>{}<br></p><ol><li>bar</ol>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<ol><li>foo{}</li><li>bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ol><li><p>foo</ol><p>{}<br></p><ol><li>bar</ol>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<ol><li><p>foo{}</p></li><li>bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ol><li><p>foo</ol><p>{}<br></p><ol><li>bar</ol>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<ol><li><p>foo{}</p></li><li>bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ol id=a><li>foo</ol>{}<br><ol><li>bar</ol>",
	[["delete",""]],
	"<ol id=\"a\"><li>foo{}</li><li>bar</li></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol>{}<br><ol id=b><li>bar</ol>",
	[["delete",""]],
	"<ol><li>foo{}</li><li>bar</li></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ol id=a><li>foo</ol>{}<br><ol id=b><li>bar</ol>",
	[["delete",""]],
	"<ol id=\"a\"><li>foo{}</li><li>bar</li></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ol class=a><li>foo</ol>{}<br><ol class=b><li>bar</ol>",
	[["delete",""]],
	"<ol class=\"a\"><li>foo{}</li><li>bar</li></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ol><ol><li>foo</ol><li>{}<br></li><ol><li>bar</ol></ol>",
	[["delete",""]],
	"<ol><ol><li>foo{}</li><li>bar</li></ol></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ol><li>foo[</ol>bar]<ol><li>baz</ol>",
	[["delete",""]],
	"<ol><li>foo{}</li><li>baz</li></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ol><li>foo[</ol><p>bar]<ol><li>baz</ol>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<ol><li>foo{}</li><li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo[</ol><p>bar]<ol><li>baz</ol>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<ol><li>foo{}</li><li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ol><li><p>foo[</ol><p>bar]<ol><li>baz</ol>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<ol><li><p>foo{}</p></li><li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ol><li><p>foo[</ol><p>bar]<ol><li>baz</ol>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<ol><li><p>foo{}</p></li><li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo[]</ol><ol><li>bar</ol>",
	[["delete",""]],
	"<ol><li>fo[]</li></ol><ol><li>bar</li></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol>[bar<ol><li>]baz</ol>",
	[["delete",""]],
	"<ol><li>foo</li></ol>{}baz",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><p>[bar<ol><li>]baz</ol>",
	[["delete",""]],
	"<ol><li>foo</li></ol><p>{}baz</p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><p>[bar<ol><li><p>]baz</ol>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<ol><li>foo</li></ol><p>{}baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><p>[bar<ol><li><p>]baz</ol>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<ol><li>foo</li></ol><p>{}baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><ol><li>b[]ar</ol>",
	[["delete",""]],
	"<ol><li>foo</li></ol><ol><li>{}ar</li></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ol><ol><li>foo[</ol><li>bar</ol>baz]<ol><li>quz</ol>",
	[["delete",""]],
	"<ol><ol><li>foo{}</li></ol><li>quz</li></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ul><li>foo</ul>{}<br><ul><li>bar</ul>",
	[["delete",""]],
	"<ul><li>foo{}</li><li>bar</li></ul>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ul><li>foo</ul><p>{}<br></p><ul><li>bar</ul>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<ul><li>foo{}</li><li>bar</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ul><li>foo</ul><p>{}<br></p><ul><li>bar</ul>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<ul><li>foo{}</li><li>bar</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo[<li>bar]</ol><ol><li>baz</ol><ol><li>quz</ol>",
	[["delete",""]],
	"<ol><li>foo{}</li><li>baz</li><li>quz</li></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol>{}<br><ul><li>bar</ul>",
	[["delete",""]],
	"<ol><li>foo{}</li></ol><ul><li>bar</li></ul>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><p>{}<br></p><ul><li>bar</ul>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<ol><li>foo{}</li></ol><ul><li>bar</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><p>{}<br></p><ul><li>bar</ul>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<ol><li>foo{}</li></ol><ul><li>bar</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<ul><li>foo</ul>{}<br><ol><li>bar</ol>",
	[["delete",""]],
	"<ul><li>foo{}</li></ul><ol><li>bar</li></ol>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<ul><li>foo</ul><p>{}<br></p><ol><li>bar</ol>",
	[["defaultparagraphseparator","div"],["delete",""]],
	"<ul><li>foo{}</li></ul><ol><li>bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"delete":[false,false,"",false,false,""]}],
["<ul><li>foo</ul><p>{}<br></p><ol><li>bar</ol>",
	[["defaultparagraphseparator","p"],["delete",""]],
	"<ul><li>foo{}</li></ul><ol><li>bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"delete":[false,false,"",false,false,""]}],
["<p><b>[foo]</b>",
	[["delete",""]],
	"<p><b>{}<br></b></p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p><quasit>[foo]</quasit>",
	[["delete",""]],
	"<p><quasit>{}<br></quasit></p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p><b><i>[foo]</i></b>",
	[["delete",""]],
	"<p><b><i>{}<br></i></b></p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p><b>{foo}</b>",
	[["delete",""]],
	"<p><b>{}<br></b></p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p>{<b>foo</b>}",
	[["delete",""]],
	"<p><b>{}<br></b></p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<p><b>f[]</b>",
	[["delete",""]],
	"<p><b>{}<br></b></p>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<b>[foo]</b>",
	[["delete",""]],
	"<b>{}<br></b>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["<div><b>[foo]</b></div>",
	[["delete",""]],
	"<div><b>{}<br></b></div>",
	[true],
	{"delete":[false,false,"",false,false,""]}],
["foo[]bar",
	[["fontname","sans-serif"]],
	"foo[]bar",
	[true],
	{"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<p>[foo</p> <p>bar]</p>",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"<p><span style=\"font-family:sans-serif\">[foo</span></p> <p><span style=\"font-family:sans-serif\">bar]</span></p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<p>[foo</p> <p>bar]</p>",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"<p><font face=\"sans-serif\">[foo</font></p> <p><font face=\"sans-serif\">bar]</font></p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<span>[foo</span> <span>bar]</span>",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"<span style=\"font-family:sans-serif\"><span>[foo</span> <span>bar]</span></span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<span>[foo</span> <span>bar]</span>",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"<font face=\"sans-serif\"><span>[foo</span> <span>bar]</span></font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"<p><span style=\"font-family:sans-serif\">[foo</span></p><p> <span style=\"font-family:sans-serif\"><span>bar</span></span> </p><p><span style=\"font-family:sans-serif\">baz]</span></p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"<p><font face=\"sans-serif\">[foo</font></p><p> <font face=\"sans-serif\"><span>bar</span></font> </p><p><font face=\"sans-serif\">baz]</font></p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<p>[foo<p><br><p>bar]",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"<p><span style=\"font-family:sans-serif\">[foo</span></p><p><span style=\"font-family:sans-serif\"><br></span></p><p><span style=\"font-family:sans-serif\">bar]</span></p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<p>[foo<p><br><p>bar]",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"<p><font face=\"sans-serif\">[foo</font></p><p><font face=\"sans-serif\"><br></font></p><p><font face=\"sans-serif\">bar]</font></p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<b>foo[]bar</b>",
	[["fontname","sans-serif"]],
	"<b>foo[]bar</b>",
	[true],
	{"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<i>foo[]bar</i>",
	[["fontname","sans-serif"]],
	"<i>foo[]bar</i>",
	[true],
	{"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<span>foo</span>{}<span>bar</span>",
	[["fontname","sans-serif"]],
	"<span>foo</span>{}<span>bar</span>",
	[true],
	{"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<span>foo[</span><span>]bar</span>",
	[["fontname","sans-serif"]],
	"<span>foo[</span><span>]bar</span>",
	[true],
	{"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"foo<span style=\"font-family:sans-serif\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"foo<font face=\"sans-serif\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["foo[bar<b>baz]qoz</b>quz",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"foo<span style=\"font-family:sans-serif\">[bar</span><b><span style=\"font-family:sans-serif\">baz]</span>qoz</b>quz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["foo[bar<b>baz]qoz</b>quz",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"foo<font face=\"sans-serif\">[bar</font><b><font face=\"sans-serif\">baz]</font>qoz</b>quz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["foo[bar<i>baz]qoz</i>quz",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"foo<span style=\"font-family:sans-serif\">[bar</span><i><span style=\"font-family:sans-serif\">baz]</span>qoz</i>quz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["foo[bar<i>baz]qoz</i>quz",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"foo<font face=\"sans-serif\">[bar</font><i><font face=\"sans-serif\">baz]</font>qoz</i>quz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["{<p><p> <p>foo</p>}",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"{<p></p><p> </p><p><span style=\"font-family:sans-serif\">foo</span></p>}",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["{<p><p> <p>foo</p>}",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"{<p></p><p> </p><p><font face=\"sans-serif\">foo</font></p>}",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"<table><tbody><tr><td>foo</td><td>b<span style=\"font-family:sans-serif\">[a]</span>r</td><td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"<table><tbody><tr><td>foo</td><td>b<font face=\"sans-serif\">[a]</font>r</td><td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"<table><tbody><tr><td>foo</td>{<td><span style=\"font-family:sans-serif\">bar</span></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"<table><tbody><tr><td>foo</td>{<td><font face=\"sans-serif\">bar</font></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"<table><tbody><tr>{<td><span style=\"font-family:sans-serif\">foo</span></td><td><span style=\"font-family:sans-serif\">bar</span></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"<table><tbody><tr>{<td><font face=\"sans-serif\">foo</font></td><td><font face=\"sans-serif\">bar</font></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"<table><tbody>{<tr><td><span style=\"font-family:sans-serif\">foo</span></td><td><span style=\"font-family:sans-serif\">bar</span></td><td><span style=\"font-family:sans-serif\">baz</span></td></tr>}</tbody></table>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"<table><tbody>{<tr><td><font face=\"sans-serif\">foo</font></td><td><font face=\"sans-serif\">bar</font></td><td><font face=\"sans-serif\">baz</font></td></tr>}</tbody></table>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"<table>{<tbody><tr><td><span style=\"font-family:sans-serif\">foo</span></td><td><span style=\"font-family:sans-serif\">bar</span></td><td><span style=\"font-family:sans-serif\">baz</span></td></tr></tbody>}</table>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"<table>{<tbody><tr><td><font face=\"sans-serif\">foo</font></td><td><font face=\"sans-serif\">bar</font></td><td><font face=\"sans-serif\">baz</font></td></tr></tbody>}</table>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"{<table><tbody><tr><td><span style=\"font-family:sans-serif\">foo</span></td><td><span style=\"font-family:sans-serif\">bar</span></td><td><span style=\"font-family:sans-serif\">baz</span></td></tr></tbody></table>}",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"{<table><tbody><tr><td><font face=\"sans-serif\">foo</font></td><td><font face=\"sans-serif\">bar</font></td><td><font face=\"sans-serif\">baz</font></td></tr></tbody></table>}",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["foo<code>[bar]</code>baz",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"foo<code><span style=\"font-family:sans-serif\">[bar]</span></code>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<code>[bar]</code>baz",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"foo<code><font face=\"sans-serif\">[bar]</font></code>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<kbd>[bar]</kbd>baz",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"foo<kbd><span style=\"font-family:sans-serif\">[bar]</span></kbd>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<kbd>[bar]</kbd>baz",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"foo<kbd><font face=\"sans-serif\">[bar]</font></kbd>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<listing>[bar]</listing>baz",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"foo<listing><span style=\"font-family:sans-serif\">[bar]</span></listing>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<listing>[bar]</listing>baz",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"foo<listing><font face=\"sans-serif\">[bar]</font></listing>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<pre>[bar]</pre>baz",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"foo<pre><span style=\"font-family:sans-serif\">[bar]</span></pre>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<pre>[bar]</pre>baz",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"foo<pre><font face=\"sans-serif\">[bar]</font></pre>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<samp>[bar]</samp>baz",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"foo<samp><span style=\"font-family:sans-serif\">[bar]</span></samp>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<samp>[bar]</samp>baz",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"foo<samp><font face=\"sans-serif\">[bar]</font></samp>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<tt>[bar]</tt>baz",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"foo<tt><span style=\"font-family:sans-serif\">[bar]</span></tt>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<tt>[bar]</tt>baz",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"foo<tt><font face=\"sans-serif\">[bar]</font></tt>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<code>b[a]r</code>baz",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"foo<code>b<span style=\"font-family:sans-serif\">[a]</span>r</code>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<code>b[a]r</code>baz",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"foo<code>b<font face=\"sans-serif\">[a]</font>r</code>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<kbd>b[a]r</kbd>baz",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"foo<kbd>b<span style=\"font-family:sans-serif\">[a]</span>r</kbd>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<kbd>b[a]r</kbd>baz",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"foo<kbd>b<font face=\"sans-serif\">[a]</font>r</kbd>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<listing>b[a]r</listing>baz",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"foo<listing>b<span style=\"font-family:sans-serif\">[a]</span>r</listing>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<listing>b[a]r</listing>baz",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"foo<listing>b<font face=\"sans-serif\">[a]</font>r</listing>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<pre>b[a]r</pre>baz",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"foo<pre>b<span style=\"font-family:sans-serif\">[a]</span>r</pre>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<pre>b[a]r</pre>baz",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"foo<pre>b<font face=\"sans-serif\">[a]</font>r</pre>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<samp>b[a]r</samp>baz",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"foo<samp>b<span style=\"font-family:sans-serif\">[a]</span>r</samp>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<samp>b[a]r</samp>baz",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"foo<samp>b<font face=\"sans-serif\">[a]</font>r</samp>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<tt>b[a]r</tt>baz",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"foo<tt>b<span style=\"font-family:sans-serif\">[a]</span>r</tt>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<tt>b[a]r</tt>baz",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"foo<tt>b<font face=\"sans-serif\">[a]</font>r</tt>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["[foo<code>bar</code>baz]",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"<span style=\"font-family:sans-serif\">[foo<code><span style=\"font-family:sans-serif\">bar</span></code>baz]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<code>bar</code>baz]",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"<font face=\"sans-serif\">[foo<code><font face=\"sans-serif\">bar</font></code>baz]</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<kbd>bar</kbd>baz]",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"<span style=\"font-family:sans-serif\">[foo<kbd><span style=\"font-family:sans-serif\">bar</span></kbd>baz]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<kbd>bar</kbd>baz]",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"<font face=\"sans-serif\">[foo<kbd><font face=\"sans-serif\">bar</font></kbd>baz]</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<listing>bar</listing>baz]",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"<span style=\"font-family:sans-serif\">[foo</span><listing><span style=\"font-family:sans-serif\">bar</span></listing><span style=\"font-family:sans-serif\">baz]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<listing>bar</listing>baz]",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"<font face=\"sans-serif\">[foo</font><listing><font face=\"sans-serif\">bar</font></listing><font face=\"sans-serif\">baz]</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<pre>bar</pre>baz]",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"<span style=\"font-family:sans-serif\">[foo</span><pre><span style=\"font-family:sans-serif\">bar</span></pre><span style=\"font-family:sans-serif\">baz]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<pre>bar</pre>baz]",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"<font face=\"sans-serif\">[foo</font><pre><font face=\"sans-serif\">bar</font></pre><font face=\"sans-serif\">baz]</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<samp>bar</samp>baz]",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"<span style=\"font-family:sans-serif\">[foo<samp><span style=\"font-family:sans-serif\">bar</span></samp>baz]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<samp>bar</samp>baz]",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"<font face=\"sans-serif\">[foo<samp><font face=\"sans-serif\">bar</font></samp>baz]</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<tt>bar</tt>baz]",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"<span style=\"font-family:sans-serif\">[foo<tt><span style=\"font-family:sans-serif\">bar</span></tt>baz]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<tt>bar</tt>baz]",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"<font face=\"sans-serif\">[foo<tt><font face=\"sans-serif\">bar</font></tt>baz]</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<code>ba]r</code>baz",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"<span style=\"font-family:sans-serif\">[foo</span><code><span style=\"font-family:sans-serif\">ba]</span>r</code>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<code>ba]r</code>baz",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"<font face=\"sans-serif\">[foo</font><code><font face=\"sans-serif\">ba]</font>r</code>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<kbd>ba]r</kbd>baz",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"<span style=\"font-family:sans-serif\">[foo</span><kbd><span style=\"font-family:sans-serif\">ba]</span>r</kbd>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<kbd>ba]r</kbd>baz",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"<font face=\"sans-serif\">[foo</font><kbd><font face=\"sans-serif\">ba]</font>r</kbd>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<listing>ba]r</listing>baz",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"<span style=\"font-family:sans-serif\">[foo</span><listing><span style=\"font-family:sans-serif\">ba]</span>r</listing>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<listing>ba]r</listing>baz",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"<font face=\"sans-serif\">[foo</font><listing><font face=\"sans-serif\">ba]</font>r</listing>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<pre>ba]r</pre>baz",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"<span style=\"font-family:sans-serif\">[foo</span><pre><span style=\"font-family:sans-serif\">ba]</span>r</pre>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<pre>ba]r</pre>baz",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"<font face=\"sans-serif\">[foo</font><pre><font face=\"sans-serif\">ba]</font>r</pre>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<samp>ba]r</samp>baz",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"<span style=\"font-family:sans-serif\">[foo</span><samp><span style=\"font-family:sans-serif\">ba]</span>r</samp>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<samp>ba]r</samp>baz",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"<font face=\"sans-serif\">[foo</font><samp><font face=\"sans-serif\">ba]</font>r</samp>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<tt>ba]r</tt>baz",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"<span style=\"font-family:sans-serif\">[foo</span><tt><span style=\"font-family:sans-serif\">ba]</span>r</tt>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<tt>ba]r</tt>baz",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"<font face=\"sans-serif\">[foo</font><tt><font face=\"sans-serif\">ba]</font>r</tt>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["foo<code>b[ar</code>baz]",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"foo<code>b<span style=\"font-family:sans-serif\">[ar</span></code><span style=\"font-family:sans-serif\">baz]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"monospace",false,false,"sans-serif"]}],
["foo<code>b[ar</code>baz]",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"foo<code>b<font face=\"sans-serif\">[ar</font></code><font face=\"sans-serif\">baz]</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"monospace",false,false,"sans-serif"]}],
["foo<kbd>b[ar</kbd>baz]",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"foo<kbd>b<span style=\"font-family:sans-serif\">[ar</span></kbd><span style=\"font-family:sans-serif\">baz]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"monospace",false,false,"sans-serif"]}],
["foo<kbd>b[ar</kbd>baz]",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"foo<kbd>b<font face=\"sans-serif\">[ar</font></kbd><font face=\"sans-serif\">baz]</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"monospace",false,false,"sans-serif"]}],
["foo<listing>b[ar</listing>baz]",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"foo<listing>b<span style=\"font-family:sans-serif\">[ar</span></listing><span style=\"font-family:sans-serif\">baz]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"monospace",false,false,"sans-serif"]}],
["foo<listing>b[ar</listing>baz]",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"foo<listing>b<font face=\"sans-serif\">[ar</font></listing><font face=\"sans-serif\">baz]</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"monospace",false,false,"sans-serif"]}],
["foo<pre>b[ar</pre>baz]",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"foo<pre>b<span style=\"font-family:sans-serif\">[ar</span></pre><span style=\"font-family:sans-serif\">baz]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"monospace",false,false,"sans-serif"]}],
["foo<pre>b[ar</pre>baz]",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"foo<pre>b<font face=\"sans-serif\">[ar</font></pre><font face=\"sans-serif\">baz]</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"monospace",false,false,"sans-serif"]}],
["foo<samp>b[ar</samp>baz]",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"foo<samp>b<span style=\"font-family:sans-serif\">[ar</span></samp><span style=\"font-family:sans-serif\">baz]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"monospace",false,false,"sans-serif"]}],
["foo<samp>b[ar</samp>baz]",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"foo<samp>b<font face=\"sans-serif\">[ar</font></samp><font face=\"sans-serif\">baz]</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"monospace",false,false,"sans-serif"]}],
["foo<tt>b[ar</tt>baz]",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"foo<tt>b<span style=\"font-family:sans-serif\">[ar</span></tt><span style=\"font-family:sans-serif\">baz]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"monospace",false,false,"sans-serif"]}],
["foo<tt>b[ar</tt>baz]",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"foo<tt>b<font face=\"sans-serif\">[ar</font></tt><font face=\"sans-serif\">baz]</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"monospace",false,false,"sans-serif"]}],
["foo<span style=\"font-family: sans-serif\">[bar]</span>baz",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"foo<span style=\"font-family:sans-serif\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"sans-serif",false,false,"sans-serif"]}],
["foo<span style=\"font-family: sans-serif\">[bar]</span>baz",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"foo<font face=\"sans-serif\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"sans-serif",false,false,"sans-serif"]}],
["foo<span style=\"font-family: sans-serif\">b[a]r</span>baz",
	[["fontname","sans-serif"]],
	"foo<span style=\"font-family:sans-serif\">b[a]r</span>baz",
	[true],
	{"fontname":[false,false,"sans-serif",false,false,"sans-serif"]}],
["foo<span style=\"font-family: monospace\">[bar]</span>baz",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"foo<span style=\"font-family:sans-serif\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<span style=\"font-family: monospace\">[bar]</span>baz",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"foo<font face=\"sans-serif\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<span style=\"font-family: monospace\">b[a]r</span>baz",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"foo<span style=\"font-family:monospace\">b<span style=\"font-family:sans-serif\">[a]</span>r</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<span style=\"font-family: monospace\">b[a]r</span>baz",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"foo<span style=\"font-family:monospace\">b<font face=\"sans-serif\">[a]</font>r</span>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<tt contenteditable=false>ba[r</tt>b]az",
	[["fontname","sans-serif"]],
	"foo<tt contenteditable=\"false\">ba[r</tt>b]az",
	[false],
	{"fontname":[false,false,"serif",false,false,"serif"]}],
["fo[o<tt contenteditable=false>b]ar</tt>baz",
	[["fontname","sans-serif"]],
	"fo[o<tt contenteditable=\"false\">b]ar</tt>baz",
	[false],
	{"fontname":[false,false,"serif",false,false,"serif"]}],
["foo<tt>{}<br></tt>bar",
	[["fontname","sans-serif"]],
	"foo<tt>{}<br></tt>bar",
	[true],
	{"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<tt>{<br></tt>}bar",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"foo<tt>{<span style=\"font-family:sans-serif\"><br></span></tt>}bar",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<tt>{<br></tt>}bar",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"foo<tt>{<font face=\"sans-serif\"><br></font></tt>}bar",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<tt>{<br></tt>b]ar",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"foo<tt>{<span style=\"font-family:sans-serif\"><br></span></tt><span style=\"font-family:sans-serif\">b]</span>ar",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"monospace",false,false,"sans-serif"]}],
["foo<tt>{<br></tt>b]ar",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"foo<tt>{<font face=\"sans-serif\"><br></font></tt><font face=\"sans-serif\">b]</font>ar",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"monospace",false,false,"sans-serif"]}],
["fo[o<span style=font-family:monospace>b]ar</span>baz",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"fo<span style=\"font-family:sans-serif\">[o</span><span style=\"font-family:monospace\"><span style=\"font-family:sans-serif\">b]</span>ar</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["fo[o<span style=font-family:monospace>b]ar</span>baz",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"fo<font face=\"sans-serif\">[o</font><span style=\"font-family:monospace\"><font face=\"sans-serif\">b]</font>ar</span>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["foo<span style=font-family:monospace>ba[r</span>b]az",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"foo<span style=\"font-family:monospace\">ba<span style=\"font-family:sans-serif\">[r</span></span><span style=\"font-family:sans-serif\">b]</span>az",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"monospace",false,false,"sans-serif"]}],
["foo<span style=font-family:monospace>ba[r</span>b]az",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"foo<span style=\"font-family:monospace\">ba<font face=\"sans-serif\">[r</font></span><font face=\"sans-serif\">b]</font>az",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"monospace",false,false,"sans-serif"]}],
["fo[o<span style=font-family:monospace>bar</span>b]az",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"fo<span style=\"font-family:sans-serif\">[obarb]</span>az",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["fo[o<span style=font-family:monospace>bar</span>b]az",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"fo<font face=\"sans-serif\">[obarb]</font>az",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["foo[<span style=font-family:monospace>b]ar</span>baz",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"foo[<span style=\"font-family:monospace\"><span style=\"font-family:sans-serif\">b]</span>ar</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo[<span style=font-family:monospace>b]ar</span>baz",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"foo[<span style=\"font-family:monospace\"><font face=\"sans-serif\">b]</font>ar</span>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<span style=font-family:monospace>ba[r</span>]baz",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"foo<span style=\"font-family:monospace\">ba<span style=\"font-family:sans-serif\">[r</span></span>]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<span style=font-family:monospace>ba[r</span>]baz",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"foo<span style=\"font-family:monospace\">ba<font face=\"sans-serif\">[r</font></span>]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo[<span style=font-family:monospace>bar</span>]baz",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"foo[<span style=\"font-family:sans-serif\">bar</span>]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo[<span style=font-family:monospace>bar</span>]baz",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"foo[<font face=\"sans-serif\">bar</font>]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<span style=font-family:monospace>[bar]</span>baz",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"foo<span style=\"font-family:sans-serif\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<span style=font-family:monospace>[bar]</span>baz",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"foo<font face=\"sans-serif\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo{<span style=font-family:monospace>bar</span>}baz",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"foo{<span style=\"font-family:sans-serif\">bar}</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo{<span style=font-family:monospace>bar</span>}baz",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"foo{<font face=\"sans-serif\">bar}</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["fo[o<code>b]ar</code>",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"fo<span style=\"font-family:sans-serif\">[o</span><code><span style=\"font-family:sans-serif\">b]</span>ar</code>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["fo[o<code>b]ar</code>",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"fo<font face=\"sans-serif\">[o</font><code><font face=\"sans-serif\">b]</font>ar</code>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["fo[o<kbd>b]ar</kbd>",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"fo<span style=\"font-family:sans-serif\">[o</span><kbd><span style=\"font-family:sans-serif\">b]</span>ar</kbd>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["fo[o<kbd>b]ar</kbd>",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"fo<font face=\"sans-serif\">[o</font><kbd><font face=\"sans-serif\">b]</font>ar</kbd>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["fo[o<listing>b]ar</listing>",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"fo<span style=\"font-family:sans-serif\">[o</span><listing><span style=\"font-family:sans-serif\">b]</span>ar</listing>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["fo[o<listing>b]ar</listing>",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"fo<font face=\"sans-serif\">[o</font><listing><font face=\"sans-serif\">b]</font>ar</listing>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["fo[o<pre>b]ar</pre>",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"fo<span style=\"font-family:sans-serif\">[o</span><pre><span style=\"font-family:sans-serif\">b]</span>ar</pre>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["fo[o<pre>b]ar</pre>",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"fo<font face=\"sans-serif\">[o</font><pre><font face=\"sans-serif\">b]</font>ar</pre>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["fo[o<samp>b]ar</samp>",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"fo<span style=\"font-family:sans-serif\">[o</span><samp><span style=\"font-family:sans-serif\">b]</span>ar</samp>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["fo[o<samp>b]ar</samp>",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"fo<font face=\"sans-serif\">[o</font><samp><font face=\"sans-serif\">b]</font>ar</samp>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["fo[o<tt>b]ar</tt>",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"fo<span style=\"font-family:sans-serif\">[o</span><tt><span style=\"font-family:sans-serif\">b]</span>ar</tt>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["fo[o<tt>b]ar</tt>",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"fo<font face=\"sans-serif\">[o</font><tt><font face=\"sans-serif\">b]</font>ar</tt>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["<tt>fo[o</tt><code>b]ar</code>",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"<tt>fo<span style=\"font-family:sans-serif\">[o</span></tt><code><span style=\"font-family:sans-serif\">b]</span>ar</code>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["<tt>fo[o</tt><code>b]ar</code>",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"<tt>fo<font face=\"sans-serif\">[o</font></tt><code><font face=\"sans-serif\">b]</font>ar</code>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["<pre>fo[o</pre><samp>b]ar</samp>",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"<pre>fo<span style=\"font-family:sans-serif\">[o</span></pre><samp><span style=\"font-family:sans-serif\">b]</span>ar</samp>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["<pre>fo[o</pre><samp>b]ar</samp>",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"<pre>fo<font face=\"sans-serif\">[o</font></pre><samp><font face=\"sans-serif\">b]</font>ar</samp>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["<span style=font-family:monospace>fo[o</span><kbd>b]ar</kbd>",
	[["stylewithcss","true"],["fontname","sans-serif"]],
	"<span style=\"font-family:monospace\">fo<span style=\"font-family:sans-serif\">[o</span></span><kbd><span style=\"font-family:sans-serif\">b]</span>ar</kbd>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["<span style=font-family:monospace>fo[o</span><kbd>b]ar</kbd>",
	[["stylewithcss","false"],["fontname","sans-serif"]],
	"<span style=\"font-family:monospace\">fo<font face=\"sans-serif\">[o</font></span><kbd><font face=\"sans-serif\">b]</font>ar</kbd>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo[]bar",
	[["fontsize","4"]],
	"foo[]bar",
	[true],
	{"fontsize":[false,false,"3",false,false,"4"]}],
["<p>[foo</p> <p>bar]</p>",
	[["stylewithcss","true"],["fontsize","4"]],
	"<p><span style=\"font-size:large\">[foo</span></p> <p><span style=\"font-size:large\">bar]</span></p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<p>[foo</p> <p>bar]</p>",
	[["stylewithcss","false"],["fontsize","4"]],
	"<p><font size=\"4\">[foo</font></p> <p><font size=\"4\">bar]</font></p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<span>[foo</span> <span>bar]</span>",
	[["stylewithcss","true"],["fontsize","4"]],
	"<span style=\"font-size:large\"><span>[foo</span> <span>bar]</span></span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<span>[foo</span> <span>bar]</span>",
	[["stylewithcss","false"],["fontsize","4"]],
	"<font size=\"4\"><span>[foo</span> <span>bar]</span></font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
	[["stylewithcss","true"],["fontsize","4"]],
	"<p><span style=\"font-size:large\">[foo</span></p><p> <span style=\"font-size:large\"><span>bar</span></span> </p><p><span style=\"font-size:large\">baz]</span></p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
	[["stylewithcss","false"],["fontsize","4"]],
	"<p><font size=\"4\">[foo</font></p><p> <font size=\"4\"><span>bar</span></font> </p><p><font size=\"4\">baz]</font></p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<p>[foo<p><br><p>bar]",
	[["stylewithcss","true"],["fontsize","4"]],
	"<p><span style=\"font-size:large\">[foo</span></p><p><br></p><p><span style=\"font-size:large\">bar]</span></p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",true,false,"4"]}],
["<p>[foo<p><br><p>bar]",
	[["stylewithcss","false"],["fontsize","4"]],
	"<p><font size=\"4\">[foo</font></p><p><br></p><p><font size=\"4\">bar]</font></p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",true,false,"4"]}],
["<b>foo[]bar</b>",
	[["fontsize","4"]],
	"<b>foo[]bar</b>",
	[true],
	{"fontsize":[false,false,"3",false,false,"4"]}],
["<i>foo[]bar</i>",
	[["fontsize","4"]],
	"<i>foo[]bar</i>",
	[true],
	{"fontsize":[false,false,"3",false,false,"4"]}],
["<span>foo</span>{}<span>bar</span>",
	[["fontsize","4"]],
	"<span>foo</span>{}<span>bar</span>",
	[true],
	{"fontsize":[false,false,"3",false,false,"4"]}],
["<span>foo[</span><span>]bar</span>",
	[["fontsize","4"]],
	"<span>foo[</span><span>]bar</span>",
	[true],
	{"fontsize":[false,false,"3",false,false,"4"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["fontsize","4"]],
	"foo<span style=\"font-size:large\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["fontsize","4"]],
	"foo<font size=\"4\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo[bar<b>baz]qoz</b>quz",
	[["stylewithcss","true"],["fontsize","4"]],
	"foo<span style=\"font-size:large\">[bar</span><b><span style=\"font-size:large\">baz]</span>qoz</b>quz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo[bar<b>baz]qoz</b>quz",
	[["stylewithcss","false"],["fontsize","4"]],
	"foo<font size=\"4\">[bar</font><b><font size=\"4\">baz]</font>qoz</b>quz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo[bar<i>baz]qoz</i>quz",
	[["stylewithcss","true"],["fontsize","4"]],
	"foo<span style=\"font-size:large\">[bar</span><i><span style=\"font-size:large\">baz]</span>qoz</i>quz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo[bar<i>baz]qoz</i>quz",
	[["stylewithcss","false"],["fontsize","4"]],
	"foo<font size=\"4\">[bar</font><i><font size=\"4\">baz]</font>qoz</i>quz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["{<p><p> <p>foo</p>}",
	[["stylewithcss","true"],["fontsize","4"]],
	"{<p></p><p> </p><p><span style=\"font-size:large\">foo</span></p>}",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["{<p><p> <p>foo</p>}",
	[["stylewithcss","false"],["fontsize","4"]],
	"{<p></p><p> </p><p><font size=\"4\">foo</font></p>}",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["fontsize","1"]],
	"foo<span style=\"font-size:x-small\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["fontsize","1"]],
	"foo<font size=\"1\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["fontsize","0"]],
	"foo<span style=\"font-size:x-small\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["fontsize","0"]],
	"foo<font size=\"1\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["fontsize","-5"]],
	"foo<span style=\"font-size:x-small\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["fontsize","-5"]],
	"foo<font size=\"1\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["fontsize","6"]],
	"foo<span style=\"font-size:xx-large\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"6"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["fontsize","6"]],
	"foo<font size=\"6\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"6"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["fontsize","7"]],
	"foo<font size=\"7\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"7"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["fontsize","7"]],
	"foo<font size=\"7\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"7"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["fontsize","8"]],
	"foo<font size=\"7\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"7"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["fontsize","8"]],
	"foo<font size=\"7\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"7"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["fontsize","100"]],
	"foo<font size=\"7\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"7"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["fontsize","100"]],
	"foo<font size=\"7\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"7"]}],
["foo[bar]baz",
	[["fontsize","2em"]],
	"foo[bar]baz",
	[false],
	{"fontsize":[false,false,"3",false,false,"3"]}],
["foo[bar]baz",
	[["fontsize","20pt"]],
	"foo[bar]baz",
	[false],
	{"fontsize":[false,false,"3",false,false,"3"]}],
["foo[bar]baz",
	[["fontsize","xx-large"]],
	"foo[bar]baz",
	[false],
	{"fontsize":[false,false,"3",false,false,"3"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["fontsize"," 1 "]],
	"foo<span style=\"font-size:x-small\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["fontsize"," 1 "]],
	"foo<font size=\"1\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
	[["fontsize","1."]],
	"foo[bar]baz",
	[false],
	{"fontsize":[false,false,"3",false,false,"3"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["fontsize","1.0"]],
	"foo<span style=\"font-size:x-small\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["fontsize","1.0"]],
	"foo<font size=\"1\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["fontsize","1.0e2"]],
	"foo<span style=\"font-size:x-small\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["fontsize","1.0e2"]],
	"foo<font size=\"1\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["fontsize","1.1"]],
	"foo<span style=\"font-size:x-small\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["fontsize","1.1"]],
	"foo<font size=\"1\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["fontsize","1.9"]],
	"foo<span style=\"font-size:x-small\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["fontsize","1.9"]],
	"foo<font size=\"1\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
	[["fontsize","+0"]],
	"foo[bar]baz",
	[true],
	{"fontsize":[false,false,"3",false,false,"3"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["fontsize","+1"]],
	"foo<span style=\"font-size:large\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["fontsize","+1"]],
	"foo<font size=\"4\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["fontsize","+9"]],
	"foo<font size=\"7\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"7"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["fontsize","+9"]],
	"foo<font size=\"7\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"7"]}],
["foo[bar]baz",
	[["fontsize","-0"]],
	"foo[bar]baz",
	[true],
	{"fontsize":[false,false,"3",false,false,"3"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["fontsize","-1"]],
	"foo<span style=\"font-size:small\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"2"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["fontsize","-1"]],
	"foo<font size=\"2\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"2"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["fontsize","-9"]],
	"foo<span style=\"font-size:x-small\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["fontsize","-9"]],
	"foo<font size=\"1\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
	[["fontsize",""]],
	"foo[bar]baz",
	[false],
	{"fontsize":[false,false,"3",false,false,"3"]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
	[["stylewithcss","true"],["fontsize","4"]],
	"<table><tbody><tr><td>foo</td><td>b<span style=\"font-size:large\">[a]</span>r</td><td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
	[["stylewithcss","false"],["fontsize","4"]],
	"<table><tbody><tr><td>foo</td><td>b<font size=\"4\">[a]</font>r</td><td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","true"],["fontsize","4"]],
	"<table><tbody><tr><td>foo</td>{<td><span style=\"font-size:large\">bar</span></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","false"],["fontsize","4"]],
	"<table><tbody><tr><td>foo</td>{<td><font size=\"4\">bar</font></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","true"],["fontsize","4"]],
	"<table><tbody><tr>{<td><span style=\"font-size:large\">foo</span></td><td><span style=\"font-size:large\">bar</span></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","false"],["fontsize","4"]],
	"<table><tbody><tr>{<td><font size=\"4\">foo</font></td><td><font size=\"4\">bar</font></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","true"],["fontsize","4"]],
	"<table><tbody>{<tr><td><span style=\"font-size:large\">foo</span></td><td><span style=\"font-size:large\">bar</span></td><td><span style=\"font-size:large\">baz</span></td></tr>}</tbody></table>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","false"],["fontsize","4"]],
	"<table><tbody>{<tr><td><font size=\"4\">foo</font></td><td><font size=\"4\">bar</font></td><td><font size=\"4\">baz</font></td></tr>}</tbody></table>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","true"],["fontsize","4"]],
	"<table>{<tbody><tr><td><span style=\"font-size:large\">foo</span></td><td><span style=\"font-size:large\">bar</span></td><td><span style=\"font-size:large\">baz</span></td></tr></tbody>}</table>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","false"],["fontsize","4"]],
	"<table>{<tbody><tr><td><font size=\"4\">foo</font></td><td><font size=\"4\">bar</font></td><td><font size=\"4\">baz</font></td></tr></tbody>}</table>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
	[["stylewithcss","true"],["fontsize","4"]],
	"{<table><tbody><tr><td><span style=\"font-size:large\">foo</span></td><td><span style=\"font-size:large\">bar</span></td><td><span style=\"font-size:large\">baz</span></td></tr></tbody></table>}",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
	[["stylewithcss","false"],["fontsize","4"]],
	"{<table><tbody><tr><td><font size=\"4\">foo</font></td><td><font size=\"4\">bar</font></td><td><font size=\"4\">baz</font></td></tr></tbody></table>}",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo<font size=1>[bar]</font>baz",
	[["stylewithcss","true"],["fontsize","4"]],
	"foo<span style=\"font-size:large\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"1",false,false,"4"]}],
["foo<font size=1>[bar]</font>baz",
	[["stylewithcss","false"],["fontsize","4"]],
	"foo<font size=\"4\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"1",false,false,"4"]}],
["<font size=1>foo[bar]baz</font>",
	[["stylewithcss","true"],["fontsize","4"]],
	"<font size=\"1\">foo<span style=\"font-size:large\">[bar]</span>baz</font>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"1",false,false,"4"]}],
["<font size=1>foo[bar]baz</font>",
	[["stylewithcss","false"],["fontsize","4"]],
	"<font size=\"1\">foo<font size=\"4\">[bar]</font>baz</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"1",false,false,"4"]}],
["foo<font size=3>[bar]</font>baz",
	[["stylewithcss","true"],["fontsize","4"]],
	"foo<span style=\"font-size:large\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo<font size=3>[bar]</font>baz",
	[["stylewithcss","false"],["fontsize","4"]],
	"foo<font size=\"4\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<font size=3>foo[bar]baz</font>",
	[["stylewithcss","true"],["fontsize","4"]],
	"<font size=\"3\">foo<span style=\"font-size:large\">[bar]</span>baz</font>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<font size=3>foo[bar]baz</font>",
	[["stylewithcss","false"],["fontsize","4"]],
	"<font size=\"3\">foo<font size=\"4\">[bar]</font>baz</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo<font size=4>[bar]</font>baz",
	[["stylewithcss","true"],["fontsize","4"]],
	"foo<span style=\"font-size:large\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"4",false,false,"4"]}],
["foo<font size=4>[bar]</font>baz",
	[["stylewithcss","false"],["fontsize","4"]],
	"foo<font size=\"4\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"4",false,false,"4"]}],
["<font size=4>foo[bar]baz</font>",
	[["fontsize","4"]],
	"<font size=\"4\">foo[bar]baz</font>",
	[true],
	{"fontsize":[false,false,"4",false,false,"4"]}],
["foo<font size=+1>[bar]</font>baz",
	[["stylewithcss","true"],["fontsize","4"]],
	"foo<span style=\"font-size:large\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"4",false,false,"4"]}],
["foo<font size=+1>[bar]</font>baz",
	[["stylewithcss","false"],["fontsize","4"]],
	"foo<font size=\"4\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"4",false,false,"4"]}],
["<font size=+1>foo[bar]baz</font>",
	[["fontsize","4"]],
	"<font size=\"+1\">foo[bar]baz</font>",
	[true],
	{"fontsize":[false,false,"4",false,false,"4"]}],
["<font size=4>foo<font size=1>b[a]r</font>baz</font>",
	[["stylewithcss","true"],["fontsize","4"]],
	"<font size=\"4\">foo<span style=\"font-size:x-small\">b</span>[a]<span style=\"font-size:x-small\">r</span>baz</font>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"1",false,false,"4"]}],
["<font size=4>foo<font size=1>b[a]r</font>baz</font>",
	[["stylewithcss","false"],["fontsize","4"]],
	"<font size=\"4\">foo<font size=\"1\">b</font>[a]<font size=\"1\">r</font>baz</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"1",false,false,"4"]}],
["foo<span style=\"font-size: xx-small\">[bar]</span>baz",
	[["stylewithcss","true"],["fontsize","4"]],
	"foo<span style=\"font-size:large\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"1",false,false,"4"]}],
["foo<span style=\"font-size: xx-small\">[bar]</span>baz",
	[["stylewithcss","false"],["fontsize","4"]],
	"foo<font size=\"4\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"1",false,false,"4"]}],
["<span style=\"font-size: xx-small\">foo[bar]baz</span>",
	[["stylewithcss","true"],["fontsize","4"]],
	"<span style=\"font-size:xx-small\">foo<span style=\"font-size:large\">[bar]</span>baz</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"1",false,false,"4"]}],
["<span style=\"font-size: xx-small\">foo[bar]baz</span>",
	[["stylewithcss","false"],["fontsize","4"]],
	"<span style=\"font-size:xx-small\">foo<font size=\"4\">[bar]</font>baz</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"1",false,false,"4"]}],
["foo<span style=\"font-size: medium\">[bar]</span>baz",
	[["stylewithcss","true"],["fontsize","4"]],
	"foo<span style=\"font-size:large\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo<span style=\"font-size: medium\">[bar]</span>baz",
	[["stylewithcss","false"],["fontsize","4"]],
	"foo<font size=\"4\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<span style=\"font-size: medium\">foo[bar]baz</span>",
	[["stylewithcss","true"],["fontsize","4"]],
	"<span style=\"font-size:medium\">foo<span style=\"font-size:large\">[bar]</span>baz</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<span style=\"font-size: medium\">foo[bar]baz</span>",
	[["stylewithcss","false"],["fontsize","4"]],
	"<span style=\"font-size:medium\">foo<font size=\"4\">[bar]</font>baz</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo<span style=\"font-size: large\">[bar]</span>baz",
	[["stylewithcss","true"],["fontsize","4"]],
	"foo<span style=\"font-size:large\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"4",false,false,"4"]}],
["foo<span style=\"font-size: large\">[bar]</span>baz",
	[["stylewithcss","false"],["fontsize","4"]],
	"foo<font size=\"4\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"4",false,false,"4"]}],
["<span style=\"font-size: large\">foo[bar]baz</span>",
	[["fontsize","4"]],
	"<span style=\"font-size:large\">foo[bar]baz</span>",
	[true],
	{"fontsize":[false,false,"4",false,false,"4"]}],
["<span style=\"font-size: large\">foo<span style=\"font-size: xx-small\">b[a]r</span>baz</span>",
	[["stylewithcss","true"],["fontsize","4"]],
	"<span style=\"font-size:large\">foo<span style=\"font-size:xx-small\">b</span>[a]<span style=\"font-size:xx-small\">r</span>baz</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"1",false,false,"4"]}],
["<span style=\"font-size: large\">foo<span style=\"font-size: xx-small\">b[a]r</span>baz</span>",
	[["stylewithcss","false"],["fontsize","4"]],
	"<span style=\"font-size:large\">foo<span style=\"font-size:xx-small\">b</span>[a]<span style=\"font-size:xx-small\">r</span>baz</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"1",false,false,"4"]}],
["foo<span style=\"font-size: 2em\">[bar]</span>baz",
	[["stylewithcss","true"],["fontsize","4"]],
	"foo<span style=\"font-size:large\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"6",false,false,"4"]}],
["foo<span style=\"font-size: 2em\">[bar]</span>baz",
	[["stylewithcss","false"],["fontsize","4"]],
	"foo<font size=\"4\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"6",false,false,"4"]}],
["<span style=\"font-size: 2em\">foo[bar]baz</span>",
	[["stylewithcss","true"],["fontsize","4"]],
	"<span style=\"font-size:2em\">foo<span style=\"font-size:large\">[bar]</span>baz</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"6",false,false,"4"]}],
["<span style=\"font-size: 2em\">foo[bar]baz</span>",
	[["stylewithcss","false"],["fontsize","4"]],
	"<span style=\"font-size:2em\">foo<font size=\"4\">[bar]</font>baz</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"6",false,false,"4"]}],
["<p style=\"font-size: xx-small\">foo[bar]baz</p>",
	[["stylewithcss","true"],["fontsize","4"]],
	"<p style=\"font-size:xx-small\">foo<span style=\"font-size:large\">[bar]</span>baz</p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"1",false,false,"4"]}],
["<p style=\"font-size: xx-small\">foo[bar]baz</p>",
	[["stylewithcss","false"],["fontsize","4"]],
	"<p style=\"font-size:xx-small\">foo<font size=\"4\">[bar]</font>baz</p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"1",false,false,"4"]}],
["<p style=\"font-size: medium\">foo[bar]baz</p>",
	[["stylewithcss","true"],["fontsize","4"]],
	"<p style=\"font-size:medium\">foo<span style=\"font-size:large\">[bar]</span>baz</p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<p style=\"font-size: medium\">foo[bar]baz</p>",
	[["stylewithcss","false"],["fontsize","4"]],
	"<p style=\"font-size:medium\">foo<font size=\"4\">[bar]</font>baz</p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<p style=\"font-size: large\">foo[bar]baz</p>",
	[["fontsize","4"]],
	"<p style=\"font-size:large\">foo[bar]baz</p>",
	[true],
	{"fontsize":[false,false,"4",false,false,"4"]}],
["<p style=\"font-size: 2em\">foo[bar]baz</p>",
	[["stylewithcss","true"],["fontsize","4"]],
	"<p style=\"font-size:2em\">foo<span style=\"font-size:large\">[bar]</span>baz</p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"6",false,false,"4"]}],
["<p style=\"font-size: 2em\">foo[bar]baz</p>",
	[["stylewithcss","false"],["fontsize","4"]],
	"<p style=\"font-size:2em\">foo<font size=\"4\">[bar]</font>baz</p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"6",false,false,"4"]}],
["<p style=\"font-size: xx-small\">foo[bar]baz</p>",
	[["stylewithcss","true"],["fontsize","3"]],
	"<p><span style=\"font-size:xx-small\">foo</span>[bar]<span style=\"font-size:xx-small\">baz</span></p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"1",false,false,"3"]}],
["<p style=\"font-size: xx-small\">foo[bar]baz</p>",
	[["stylewithcss","false"],["fontsize","3"]],
	"<p><span style=\"font-size:xx-small\">foo</span>[bar]<span style=\"font-size:xx-small\">baz</span></p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"1",false,false,"3"]}],
["<p style=\"font-size: medium\">foo[bar]baz</p>",
	[["fontsize","3"]],
	"<p style=\"font-size:medium\">foo[bar]baz</p>",
	[true],
	{"fontsize":[false,false,"3",false,false,"3"]}],
["<p style=\"font-size: large\">foo[bar]baz</p>",
	[["stylewithcss","true"],["fontsize","3"]],
	"<p><span style=\"font-size:large\">foo</span>[bar]<span style=\"font-size:large\">baz</span></p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"4",false,false,"3"]}],
["<p style=\"font-size: large\">foo[bar]baz</p>",
	[["stylewithcss","false"],["fontsize","3"]],
	"<p><font size=\"4\">foo</font>[bar]<font size=\"4\">baz</font></p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"4",false,false,"3"]}],
["<p style=\"font-size: 2em\">foo[bar]baz</p>",
	[["stylewithcss","true"],["fontsize","3"]],
	"<p><span style=\"font-size:2em\">foo</span>[bar]<span style=\"font-size:2em\">baz</span></p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"6",false,false,"3"]}],
["<p style=\"font-size: 2em\">foo[bar]baz</p>",
	[["stylewithcss","false"],["fontsize","3"]],
	"<p><span style=\"font-size:2em\">foo</span>[bar]<span style=\"font-size:2em\">baz</span></p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"6",false,false,"3"]}],
["<font size=6>foo <span style=\"font-size: 2em\">b[a]r</span> baz</font>",
	[["stylewithcss","true"],["fontsize","3"]],
	"<span style=\"font-size:xx-large\">foo </span><span style=\"font-size:2em\">b</span>[a]<span style=\"font-size:2em\">r</span><span style=\"font-size:xx-large\"> baz</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"7",false,false,"3"]}],
["<font size=6>foo <span style=\"font-size: 2em\">b[a]r</span> baz</font>",
	[["stylewithcss","false"],["fontsize","3"]],
	"<font size=\"6\">foo </font><span style=\"font-size:2em\">b</span>[a]<span style=\"font-size:2em\">r</span><font size=\"6\"> baz</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"7",false,false,"3"]}],
["foo<big>[bar]</big>baz",
	[["stylewithcss","true"],["fontsize","3"]],
	"foo<big><span style=\"font-size:medium\">[bar]</span></big>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"4",false,false,"3"]}],
["foo<big>[bar]</big>baz",
	[["stylewithcss","false"],["fontsize","3"]],
	"foo<big><font size=\"3\">[bar]</font></big>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"4",false,false,"3"]}],
["foo<big>b[a]r</big>baz",
	[["stylewithcss","true"],["fontsize","3"]],
	"foo<big>b<span style=\"font-size:medium\">[a]</span>r</big>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"4",false,false,"3"]}],
["foo<big>b[a]r</big>baz",
	[["stylewithcss","false"],["fontsize","3"]],
	"foo<big>b<font size=\"3\">[a]</font>r</big>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"4",false,false,"3"]}],
["foo<small>[bar]</small>baz",
	[["stylewithcss","true"],["fontsize","3"]],
	"foo<small><span style=\"font-size:medium\">[bar]</span></small>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"2",false,false,"3"]}],
["foo<small>[bar]</small>baz",
	[["stylewithcss","false"],["fontsize","3"]],
	"foo<small><font size=\"3\">[bar]</font></small>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"2",false,false,"3"]}],
["foo<small>b[a]r</small>baz",
	[["stylewithcss","true"],["fontsize","3"]],
	"foo<small>b<span style=\"font-size:medium\">[a]</span>r</small>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"2",false,false,"3"]}],
["foo<small>b[a]r</small>baz",
	[["stylewithcss","false"],["fontsize","3"]],
	"foo<small>b<font size=\"3\">[a]</font>r</small>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"2",false,false,"3"]}],
["fo[o<font size=2>b]ar</font>baz",
	[["stylewithcss","true"],["fontsize","4"]],
	"fo<span style=\"font-size:large\">[o</span><font size=\"2\"><span style=\"font-size:large\">b]</span>ar</font>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[true,false,"3",false,false,"4"]}],
["fo[o<font size=2>b]ar</font>baz",
	[["stylewithcss","false"],["fontsize","4"]],
	"fo<font size=\"4\">[o</font><font size=\"2\"><font size=\"4\">b]</font>ar</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[true,false,"3",false,false,"4"]}],
["foo<font size=2>ba[r</font>b]az",
	[["stylewithcss","true"],["fontsize","4"]],
	"foo<font size=\"2\">ba<span style=\"font-size:large\">[r</span></font><span style=\"font-size:large\">b]</span>az",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[true,false,"2",false,false,"4"]}],
["foo<font size=2>ba[r</font>b]az",
	[["stylewithcss","false"],["fontsize","4"]],
	"foo<font size=\"2\">ba<font size=\"4\">[r</font></font><font size=\"4\">b]</font>az",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[true,false,"2",false,false,"4"]}],
["fo[o<font size=2>bar</font>b]az",
	[["stylewithcss","true"],["fontsize","4"]],
	"fo<span style=\"font-size:large\">[obarb]</span>az",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[true,false,"3",false,false,"4"]}],
["fo[o<font size=2>bar</font>b]az",
	[["stylewithcss","false"],["fontsize","4"]],
	"fo<font size=\"4\">[obarb]</font>az",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[true,false,"3",false,false,"4"]}],
["foo[<font size=2>b]ar</font>baz",
	[["stylewithcss","true"],["fontsize","4"]],
	"foo[<font size=\"2\"><span style=\"font-size:large\">b]</span>ar</font>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"2",false,false,"4"]}],
["foo[<font size=2>b]ar</font>baz",
	[["stylewithcss","false"],["fontsize","4"]],
	"foo[<font size=\"2\"><font size=\"4\">b]</font>ar</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"2",false,false,"4"]}],
["foo<font size=2>ba[r</font>]baz",
	[["stylewithcss","true"],["fontsize","4"]],
	"foo<font size=\"2\">ba<span style=\"font-size:large\">[r</span></font>]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"2",false,false,"4"]}],
["foo<font size=2>ba[r</font>]baz",
	[["stylewithcss","false"],["fontsize","4"]],
	"foo<font size=\"2\">ba<font size=\"4\">[r</font></font>]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"2",false,false,"4"]}],
["foo[<font size=2>bar</font>]baz",
	[["stylewithcss","true"],["fontsize","4"]],
	"foo[<span style=\"font-size:large\">bar</span>]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"2",false,false,"4"]}],
["foo[<font size=2>bar</font>]baz",
	[["stylewithcss","false"],["fontsize","4"]],
	"foo[<font size=\"4\">bar</font>]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"2",false,false,"4"]}],
["foo<font size=2>[bar]</font>baz",
	[["stylewithcss","true"],["fontsize","4"]],
	"foo<span style=\"font-size:large\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"2",false,false,"4"]}],
["foo<font size=2>[bar]</font>baz",
	[["stylewithcss","false"],["fontsize","4"]],
	"foo<font size=\"4\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"2",false,false,"4"]}],
["foo{<font size=2>bar</font>}baz",
	[["stylewithcss","true"],["fontsize","4"]],
	"foo{<span style=\"font-size:large\">bar}</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"2",false,false,"4"]}],
["foo{<font size=2>bar</font>}baz",
	[["stylewithcss","false"],["fontsize","4"]],
	"foo{<font size=\"4\">bar}</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"2",false,false,"4"]}],
["<font size=1>fo[o</font><span style=font-size:xx-small>b]ar</span>",
	[["stylewithcss","true"],["fontsize","4"]],
	"<font size=\"1\">fo<span style=\"font-size:large\">[o</span></font><span style=\"font-size:xx-small\"><span style=\"font-size:large\">b]</span>ar</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[true,false,"1",false,false,"4"]}],
["<font size=1>fo[o</font><span style=font-size:xx-small>b]ar</span>",
	[["stylewithcss","false"],["fontsize","4"]],
	"<font size=\"1\">fo<font size=\"4\">[o</font></font><span style=\"font-size:xx-small\"><font size=\"4\">b]</font>ar</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[true,false,"1",false,false,"4"]}],
["<font size=2>fo[o</font><span style=font-size:small>b]ar</span>",
	[["stylewithcss","true"],["fontsize","4"]],
	"<font size=\"2\">fo<span style=\"font-size:large\">[o</span></font><span style=\"font-size:small\"><span style=\"font-size:large\">b]</span>ar</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"2",false,false,"4"]}],
["<font size=2>fo[o</font><span style=font-size:small>b]ar</span>",
	[["stylewithcss","false"],["fontsize","4"]],
	"<font size=\"2\">fo<font size=\"4\">[o</font></font><span style=\"font-size:small\"><font size=\"4\">b]</font>ar</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"2",false,false,"4"]}],
["<font size=3>fo[o</font><span style=font-size:medium>b]ar</span>",
	[["stylewithcss","true"],["fontsize","4"]],
	"<font size=\"3\">fo<span style=\"font-size:large\">[o</span></font><span style=\"font-size:medium\"><span style=\"font-size:large\">b]</span>ar</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<font size=3>fo[o</font><span style=font-size:medium>b]ar</span>",
	[["stylewithcss","false"],["fontsize","4"]],
	"<font size=\"3\">fo<font size=\"4\">[o</font></font><span style=\"font-size:medium\"><font size=\"4\">b]</font>ar</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<font size=4>fo[o</font><span style=font-size:large>b]ar</span>",
	[["fontsize","4"]],
	"<font size=\"4\">fo[o</font><span style=\"font-size:large\">b]ar</span>",
	[true],
	{"fontsize":[false,false,"4",false,false,"4"]}],
["<font size=5>fo[o</font><span style=font-size:x-large>b]ar</span>",
	[["stylewithcss","true"],["fontsize","4"]],
	"<font size=\"5\">fo<span style=\"font-size:large\">[o</span></font><span style=\"font-size:x-large\"><span style=\"font-size:large\">b]</span>ar</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"5",false,false,"4"]}],
["<font size=5>fo[o</font><span style=font-size:x-large>b]ar</span>",
	[["stylewithcss","false"],["fontsize","4"]],
	"<font size=\"5\">fo<font size=\"4\">[o</font></font><span style=\"font-size:x-large\"><font size=\"4\">b]</font>ar</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"5",false,false,"4"]}],
["<font size=6>fo[o</font><span style=font-size:xx-large>b]ar</span>",
	[["stylewithcss","true"],["fontsize","4"]],
	"<font size=\"6\">fo<span style=\"font-size:large\">[o</span></font><span style=\"font-size:xx-large\"><span style=\"font-size:large\">b]</span>ar</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"6",false,false,"4"]}],
["<font size=6>fo[o</font><span style=font-size:xx-large>b]ar</span>",
	[["stylewithcss","false"],["fontsize","4"]],
	"<font size=\"6\">fo<font size=\"4\">[o</font></font><span style=\"font-size:xx-large\"><font size=\"4\">b]</font>ar</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"6",false,false,"4"]}],
["foo[]bar",
	[["forecolor","#0000FF"]],
	"foo[]bar",
	[true],
	{"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<p>[foo</p> <p>bar]</p>",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"<p><span style=\"color:rgb(0, 0, 255)\">[foo</span></p> <p><span style=\"color:rgb(0, 0, 255)\">bar]</span></p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<p>[foo</p> <p>bar]</p>",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"<p><font color=\"#0000ff\">[foo</font></p> <p><font color=\"#0000ff\">bar]</font></p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<span>[foo</span> <span>bar]</span>",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"<span style=\"color:rgb(0, 0, 255)\"><span>[foo</span> <span>bar]</span></span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<span>[foo</span> <span>bar]</span>",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"<font color=\"#0000ff\"><span>[foo</span> <span>bar]</span></font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"<p><span style=\"color:rgb(0, 0, 255)\">[foo</span></p><p> <span style=\"color:rgb(0, 0, 255)\"><span>bar</span></span> </p><p><span style=\"color:rgb(0, 0, 255)\">baz]</span></p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"<p><font color=\"#0000ff\">[foo</font></p><p> <font color=\"#0000ff\"><span>bar</span></font> </p><p><font color=\"#0000ff\">baz]</font></p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<p>[foo<p><br><p>bar]",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"<p><span style=\"color:rgb(0, 0, 255)\">[foo</span></p><p><span style=\"color:rgb(0, 0, 255)\"><br></span></p><p><span style=\"color:rgb(0, 0, 255)\">bar]</span></p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<p>[foo<p><br><p>bar]",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"<p><font color=\"#0000ff\">[foo</font></p><p><font color=\"#0000ff\"><br></font></p><p><font color=\"#0000ff\">bar]</font></p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<b>foo[]bar</b>",
	[["forecolor","#0000FF"]],
	"<b>foo[]bar</b>",
	[true],
	{"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<i>foo[]bar</i>",
	[["forecolor","#0000FF"]],
	"<i>foo[]bar</i>",
	[true],
	{"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<span>foo</span>{}<span>bar</span>",
	[["forecolor","#0000FF"]],
	"<span>foo</span>{}<span>bar</span>",
	[true],
	{"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<span>foo[</span><span>]bar</span>",
	[["forecolor","#0000FF"]],
	"<span>foo[</span><span>]bar</span>",
	[true],
	{"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"foo<font color=\"#0000ff\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar<b>baz]qoz</b>quz",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"foo<span style=\"color:rgb(0, 0, 255)\">[bar</span><b><span style=\"color:rgb(0, 0, 255)\">baz]</span>qoz</b>quz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar<b>baz]qoz</b>quz",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"foo<font color=\"#0000ff\">[bar</font><b><font color=\"#0000ff\">baz]</font>qoz</b>quz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar<i>baz]qoz</i>quz",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"foo<span style=\"color:rgb(0, 0, 255)\">[bar</span><i><span style=\"color:rgb(0, 0, 255)\">baz]</span>qoz</i>quz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar<i>baz]qoz</i>quz",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"foo<font color=\"#0000ff\">[bar</font><i><font color=\"#0000ff\">baz]</font>qoz</i>quz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["{<p><p> <p>foo</p>}",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"{<p></p><p> </p><p><span style=\"color:rgb(0, 0, 255)\">foo</span></p>}",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["{<p><p> <p>foo</p>}",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"{<p></p><p> </p><p><font color=\"#0000ff\">foo</font></p>}",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["forecolor","blue"]],
	"foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["forecolor","blue"]],
	"foo<font color=\"#0000ff\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
	[["forecolor","f"]],
	"foo[bar]baz",
	[true],
	{"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 0)"]}],
["foo[bar]baz",
	[["forecolor","#f"]],
	"foo[bar]baz",
	[true],
	{"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 0)"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["forecolor","00f"]],
	"foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["forecolor","00f"]],
	"foo<font color=\"#0000ff\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["forecolor","#00f"]],
	"foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["forecolor","#00f"]],
	"foo<font color=\"#0000ff\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["forecolor","0000ff"]],
	"foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["forecolor","0000ff"]],
	"foo<font color=\"#0000ff\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["forecolor","#0000ff"]],
	"foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["forecolor","#0000ff"]],
	"foo<font color=\"#0000ff\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
	[["forecolor","000000fff"]],
	"foo[bar]baz",
	[true],
	{"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 0)"]}],
["foo[bar]baz",
	[["forecolor","#000000fff"]],
	"foo[bar]baz",
	[true],
	{"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 0)"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["forecolor","rgb(0, 0, 255)"]],
	"foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["forecolor","rgb(0, 0, 255)"]],
	"foo<font color=\"#0000ff\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["forecolor","rgb(0%, 0%, 100%)"]],
	"foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["forecolor","rgb(0%, 0%, 100%)"]],
	"foo<font color=\"#0000ff\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["forecolor","rgb( 0 ,0 ,255)"]],
	"foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["forecolor","rgb( 0 ,0 ,255)"]],
	"foo<font color=\"#0000ff\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["forecolor","rgba(0, 0, 255, 0.0)"]],
	"foo<span style=\"color:rgba(0, 0, 0, 0)\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgba(0, 0, 255, 0)"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["forecolor","rgba(0, 0, 255, 0.0)"]],
	"foo<span style=\"color:rgba(0, 0, 0, 0)\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgba(0, 0, 255, 0)"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["forecolor","rgb(15, -10, 375)"]],
	"foo<span style=\"color:rgb(15, 0, 255)\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(15, 0, 255)"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["forecolor","rgb(15, -10, 375)"]],
	"foo<font color=\"#0f00ff\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(15, 0, 255)"]}],
["foo[bar]baz",
	[["forecolor","rgba(0, 0, 0, 1)"]],
	"foo[bar]baz",
	[true],
	{"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 0)"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["forecolor","rgba(255, 255, 255, 1)"]],
	"foo<span style=\"color:rgb(255, 255, 255)\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(255, 255, 255)"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["forecolor","rgba(255, 255, 255, 1)"]],
	"foo<font color=\"#ffffff\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(255, 255, 255)"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["forecolor","rgba(0, 0, 255, 0.5)"]],
	"foo<span style=\"color:rgba(0, 0, 255, 0.5)\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgba(0, 0, 255, 0.5)"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["forecolor","rgba(0, 0, 255, 0.5)"]],
	"foo<span style=\"color:rgba(0, 0, 255, 0.5)\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgba(0, 0, 255, 0.5)"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["forecolor","hsl(240, 100%, 50%)"]],
	"foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["forecolor","hsl(240, 100%, 50%)"]],
	"foo<font color=\"#0000ff\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["forecolor","cornsilk"]],
	"foo<span style=\"color:rgb(255, 248, 220)\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(255, 248, 220)"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["forecolor","cornsilk"]],
	"foo<font color=\"#fff8dc\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(255, 248, 220)"]}],
["foo[bar]baz",
	[["forecolor","potato quiche"]],
	"foo[bar]baz",
	[true],
	{"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 0)"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["forecolor","transparent"]],
	"foo<span style=\"color:rgba(0, 0, 0, 0)\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgba(0, 0, 0, 0)"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["forecolor","transparent"]],
	"foo<span style=\"color:rgba(0, 0, 0, 0)\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgba(0, 0, 0, 0)"]}],
["foo[bar]baz",
	[["forecolor","currentColor"]],
	"foo[bar]baz",
	[false],
	{"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 0)"]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"<table><tbody><tr><td>foo</td><td>b<span style=\"color:rgb(0, 0, 255)\">[a]</span>r</td><td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"<table><tbody><tr><td>foo</td><td>b<font color=\"#0000ff\">[a]</font>r</td><td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"<table><tbody><tr><td>foo</td>{<td><span style=\"color:rgb(0, 0, 255)\">bar</span></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"<table><tbody><tr><td>foo</td>{<td><font color=\"#0000ff\">bar</font></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"<table><tbody><tr>{<td><span style=\"color:rgb(0, 0, 255)\">foo</span></td><td><span style=\"color:rgb(0, 0, 255)\">bar</span></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"<table><tbody><tr>{<td><font color=\"#0000ff\">foo</font></td><td><font color=\"#0000ff\">bar</font></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"<table><tbody>{<tr><td><span style=\"color:rgb(0, 0, 255)\">foo</span></td><td><span style=\"color:rgb(0, 0, 255)\">bar</span></td><td><span style=\"color:rgb(0, 0, 255)\">baz</span></td></tr>}</tbody></table>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"<table><tbody>{<tr><td><font color=\"#0000ff\">foo</font></td><td><font color=\"#0000ff\">bar</font></td><td><font color=\"#0000ff\">baz</font></td></tr>}</tbody></table>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"<table>{<tbody><tr><td><span style=\"color:rgb(0, 0, 255)\">foo</span></td><td><span style=\"color:rgb(0, 0, 255)\">bar</span></td><td><span style=\"color:rgb(0, 0, 255)\">baz</span></td></tr></tbody>}</table>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"<table>{<tbody><tr><td><font color=\"#0000ff\">foo</font></td><td><font color=\"#0000ff\">bar</font></td><td><font color=\"#0000ff\">baz</font></td></tr></tbody>}</table>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"{<table><tbody><tr><td><span style=\"color:rgb(0, 0, 255)\">foo</span></td><td><span style=\"color:rgb(0, 0, 255)\">bar</span></td><td><span style=\"color:rgb(0, 0, 255)\">baz</span></td></tr></tbody></table>}",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"{<table><tbody><tr><td><font color=\"#0000ff\">foo</font></td><td><font color=\"#0000ff\">bar</font></td><td><font color=\"#0000ff\">baz</font></td></tr></tbody></table>}",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo<font color=blue>[bar]</font>baz",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["foo<font color=blue>[bar]</font>baz",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"foo<font color=\"#0000ff\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["foo{<font color=blue>bar</font>}baz",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"foo{<span style=\"color:rgb(0, 0, 255)\">bar}</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["foo{<font color=blue>bar</font>}baz",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"foo{<font color=\"#0000ff\">bar}</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: blue\">foo<span style=\"color: brown\">[bar]</span>baz</span>",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"<span style=\"color:rgb(0, 0, 255)\">foo[bar]baz</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: blue\">foo<span style=\"color: brown\">[bar]</span>baz</span>",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"<span style=\"color:rgb(0, 0, 255)\">foo[bar]baz</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: #00f\">foo<span style=\"color: brown\">[bar]</span>baz</span>",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"<span style=\"color:rgb(0, 0, 255)\">foo[bar]baz</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: #00f\">foo<span style=\"color: brown\">[bar]</span>baz</span>",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"<span style=\"color:rgb(0, 0, 255)\">foo[bar]baz</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: #0000ff\">foo<span style=\"color: brown\">[bar]</span>baz</span>",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"<span style=\"color:rgb(0, 0, 255)\">foo[bar]baz</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: #0000ff\">foo<span style=\"color: brown\">[bar]</span>baz</span>",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"<span style=\"color:rgb(0, 0, 255)\">foo[bar]baz</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb(0, 0, 255)\">foo<span style=\"color: brown\">[bar]</span>baz</span>",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"<span style=\"color:rgb(0, 0, 255)\">foo[bar]baz</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb(0, 0, 255)\">foo<span style=\"color: brown\">[bar]</span>baz</span>",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"<span style=\"color:rgb(0, 0, 255)\">foo[bar]baz</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<font color=blue>foo<font color=brown>[bar]</font>baz</font>",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"<font color=\"blue\">foo[bar]baz</font>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<font color=blue>foo<font color=brown>[bar]</font>baz</font>",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"<font color=\"blue\">foo[bar]baz</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb(0, 0, 255)\">foo<span style=\"color: brown\">b[ar]</span>baz</span>",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"<span style=\"color:rgb(0, 0, 255)\">foo<span style=\"color:rgb(165, 42, 42)\">b</span>[ar]baz</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb(0, 0, 255)\">foo<span style=\"color: brown\">b[ar]</span>baz</span>",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"<span style=\"color:rgb(0, 0, 255)\">foo<font color=\"#a52a2a\">b</font>[ar]baz</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["foo<span id=purple>ba[r</span>ba]z",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"foo<span id=\"purple\">ba<span style=\"color:rgb(0, 0, 255)\">[r</span></span><span style=\"color:rgb(0, 0, 255)\">ba]</span>z",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[true,false,"rgb(128, 0, 128)",false,false,"rgb(0, 0, 255)"]}],
["foo<span id=purple>ba[r</span>ba]z",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"foo<span id=\"purple\">ba<font color=\"#0000ff\">[r</font></span><font color=\"#0000ff\">ba]</font>z",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[true,false,"rgb(128, 0, 128)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb(0, 0, 255)\">foo<span id=purple>b[a]r</span>baz</span>",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"<span style=\"color:rgb(0, 0, 255)\">foo<span id=\"purple\">b<span style=\"color:rgb(0, 0, 255)\">[a]</span>r</span>baz</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(128, 0, 128)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb(0, 0, 255)\">foo<span id=purple>b[a]r</span>baz</span>",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"<span style=\"color:rgb(0, 0, 255)\">foo<span id=\"purple\">b<font color=\"#0000ff\">[a]</font>r</span>baz</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(128, 0, 128)",false,false,"rgb(0, 0, 255)"]}],
["<a href=http://www.google.com>foo[bar]baz</a>",
	[["forecolor","blue"]],
	"<a href=\"http://www.google.com\">foo[bar]baz</a>",
	[true],
	{"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<a href=http://www.google.com>foo[bar]baz</a>",
	[["forecolor","#0000ff"]],
	"<a href=\"http://www.google.com\">foo[bar]baz</a>",
	[true],
	{"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<a href=http://www.google.com>foo[bar]baz</a>",
	[["forecolor","rgb(0,0,255)"]],
	"<a href=\"http://www.google.com\">foo[bar]baz</a>",
	[true],
	{"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<font color=\"blue\">[foo]</font>",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<font color=\"blue\">[foo]</font>",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"<font color=\"#0000ff\">[foo]</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<font color=\"0000ff\">[foo]</font>",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<font color=\"0000ff\">[foo]</font>",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"<font color=\"#0000ff\">[foo]</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<font color=\"#0000ff\">[foo]</font>",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<font color=\"#0000ff\">[foo]</font>",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"<font color=\"#0000ff\">[foo]</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: blue\">[foo]</span>",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: blue\">[foo]</span>",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"<font color=\"#0000ff\">[foo]</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: #0000ff\">[foo]</span>",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: #0000ff\">[foo]</span>",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"<font color=\"#0000ff\">[foo]</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb(0, 0, 255)\">[foo]</span>",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb(0, 0, 255)\">[foo]</span>",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"<font color=\"#0000ff\">[foo]</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb(0%, 0%, 100%)\">[foo]</span>",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb(0%, 0%, 100%)\">[foo]</span>",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"<font color=\"#0000ff\">[foo]</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb( 0 ,0 ,255)\">[foo]</span>",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb( 0 ,0 ,255)\">[foo]</span>",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"<font color=\"#0000ff\">[foo]</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgba(0, 0, 255, 0.0)\">[foo]</span>",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgba(0, 0, 255, 0)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgba(0, 0, 255, 0.0)\">[foo]</span>",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"<font color=\"#0000ff\">[foo]</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgba(0, 0, 255, 0)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb(15, -10, 375)\">[foo]</span>",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(15, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgb(15, -10, 375)\">[foo]</span>",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"<font color=\"#0000ff\">[foo]</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(15, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgba(0, 0, 0, 1)\">[foo]</span>",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgba(0, 0, 0, 1)\">[foo]</span>",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"<font color=\"#0000ff\">[foo]</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgba(255, 255, 255, 1)\">[foo]</span>",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(255, 255, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgba(255, 255, 255, 1)\">[foo]</span>",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"<font color=\"#0000ff\">[foo]</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(255, 255, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgba(0, 0, 255, 0.5)\">[foo]</span>",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgba(0, 0, 255, 0.5)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: rgba(0, 0, 255, 0.5)\">[foo]</span>",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"<font color=\"#0000ff\">[foo]</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgba(0, 0, 255, 0.5)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: hsl(240, 100%, 50%)\">[foo]</span>",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: hsl(240, 100%, 50%)\">[foo]</span>",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"<font color=\"#0000ff\">[foo]</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 255)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: cornsilk\">[foo]</span>",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(255, 248, 220)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: cornsilk\">[foo]</span>",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"<font color=\"#0000ff\">[foo]</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(255, 248, 220)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: transparent\">[foo]</span>",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: transparent\">[foo]</span>",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"<font color=\"#0000ff\">[foo]</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: currentColor\">[foo]</span>",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"<span style=\"color:rgb(0, 0, 255)\">[foo]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["<span style=\"color: currentColor\">[foo]</span>",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"<font color=\"#0000ff\">[foo]</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["fo[o<font color=brown>b]ar</font>baz",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"fo<span style=\"color:rgb(0, 0, 255)\">[o</span><font color=\"brown\"><span style=\"color:rgb(0, 0, 255)\">b]</span>ar</font>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[true,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["fo[o<font color=brown>b]ar</font>baz",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"fo<font color=\"#0000ff\">[o</font><font color=\"brown\"><font color=\"#0000ff\">b]</font>ar</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[true,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo<font color=brown>ba[r</font>b]az",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"foo<font color=\"brown\">ba<span style=\"color:rgb(0, 0, 255)\">[r</span></font><span style=\"color:rgb(0, 0, 255)\">b]</span>az",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[true,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["foo<font color=brown>ba[r</font>b]az",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"foo<font color=\"brown\">ba<font color=\"#0000ff\">[r</font></font><font color=\"#0000ff\">b]</font>az",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[true,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["fo[o<font color=brown>bar</font>b]az",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"fo<span style=\"color:rgb(0, 0, 255)\">[obarb]</span>az",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[true,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["fo[o<font color=brown>bar</font>b]az",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"fo<font color=\"#0000ff\">[obarb]</font>az",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[true,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"]}],
["foo[<font color=brown>b]ar</font>baz",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"foo[<font color=\"brown\"><span style=\"color:rgb(0, 0, 255)\">b]</span>ar</font>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["foo[<font color=brown>b]ar</font>baz",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"foo[<font color=\"brown\"><font color=\"#0000ff\">b]</font>ar</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["foo<font color=brown>ba[r</font>]baz",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"foo<font color=\"brown\">ba<span style=\"color:rgb(0, 0, 255)\">[r</span></font>]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["foo<font color=brown>ba[r</font>]baz",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"foo<font color=\"brown\">ba<font color=\"#0000ff\">[r</font></font>]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["foo[<font color=brown>bar</font>]baz",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"foo[<span style=\"color:rgb(0, 0, 255)\">bar</span>]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["foo[<font color=brown>bar</font>]baz",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"foo[<font color=\"#0000ff\">bar</font>]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["foo<font color=brown>[bar]</font>baz",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"foo<span style=\"color:rgb(0, 0, 255)\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["foo<font color=brown>[bar]</font>baz",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"foo<font color=\"#0000ff\">[bar]</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["foo{<font color=brown>bar</font>}baz",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"foo{<span style=\"color:rgb(0, 0, 255)\">bar}</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["foo{<font color=brown>bar</font>}baz",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"foo{<font color=\"#0000ff\">bar}</font>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<font color=brown>fo[o</font><span style=color:brown>b]ar</span>",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"<font color=\"brown\">fo<span style=\"color:rgb(0, 0, 255)\">[o</span></font><span style=\"color:rgb(165, 42, 42)\"><span style=\"color:rgb(0, 0, 255)\">b]</span>ar</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<font color=brown>fo[o</font><span style=color:brown>b]ar</span>",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"<font color=\"brown\">fo<font color=\"#0000ff\">[o</font></font><span style=\"color:rgb(165, 42, 42)\"><font color=\"#0000ff\">b]</font>ar</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[false,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<span style=color:brown>fo[o</span><span style=color:#0000ff>b]ar</span>",
	[["stylewithcss","true"],["forecolor","#0000FF"]],
	"<span style=\"color:rgb(165, 42, 42)\">fo<span style=\"color:rgb(0, 0, 255)\">[o</span></span><span style=\"color:rgb(0, 0, 255)\">b]ar</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forecolor":[true,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["<span style=color:brown>fo[o</span><span style=color:#0000ff>b]ar</span>",
	[["stylewithcss","false"],["forecolor","#0000FF"]],
	"<span style=\"color:rgb(165, 42, 42)\">fo<font color=\"#0000ff\">[o</font></span><span style=\"color:rgb(0, 0, 255)\">b]ar</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forecolor":[true,false,"rgb(165, 42, 42)",false,false,"rgb(0, 0, 255)"]}],
["foo[]bar<p>extra",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<div>foo[]bar</div><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["foo[]bar<p>extra",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<div>foo[]bar</div><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<span>foo</span>{}<span>bar</span><p>extra",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<div><span>foo</span>{}<span>bar</span></div><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<span>foo</span>{}<span>bar</span><p>extra",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<div><span>foo</span>{}<span>bar</span></div><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<span>foo[</span><span>]bar</span><p>extra",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<div><span>foo[</span><span>]bar</span></div><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<span>foo[</span><span>]bar</span><p>extra",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<div><span>foo[</span><span>]bar</span></div><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["foo[bar]baz<p>extra",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<div>foo[bar]baz</div><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["foo[bar]baz<p>extra",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<div>foo[bar]baz</div><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["foo]bar[baz<p>extra",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<div>foo[bar]baz</div><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["foo]bar[baz<p>extra",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<div>foo[bar]baz</div><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["{<p><p> <p>foo</p>}",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<div>{ foo}</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"div"]}],
["{<p><p> <p>foo</p>}",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<div>{ foo}</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"div"]}],
["foo[bar<i>baz]qoz</i>quz<p>extra",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<div>foo[bar<i>baz]qoz</i>quz</div><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["foo[bar<i>baz]qoz</i>quz<p>extra",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<div>foo[bar<i>baz]qoz</i>quz</div><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<table><tbody><tr><td>foo</td><td><div>b[a]r</div></td><td>baz</td></tr></tbody></table>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<table><tbody><tr><td>foo</td><td><div>b[a]r</div></td><td>baz</td></tr></tbody></table>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<table><tbody><tr><td>foo</td>{<td><div>bar</div></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<table><tbody><tr><td>foo</td>{<td><div>bar</div></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<table><tbody><tr>{<td><div>foo</div></td><td><div>bar</div></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<table><tbody><tr>{<td><div>foo</div></td><td><div>bar</div></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<table><tbody>{<tr><td><div>foo</div></td><td><div>bar</div></td><td><div>baz</div></td></tr>}</tbody></table>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<table><tbody>{<tr><td><div>foo</div></td><td><div>bar</div></td><td><div>baz</div></td></tr>}</tbody></table>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<table>{<tbody><tr><td><div>foo</div></td><td><div>bar</div></td><td><div>baz</div></td></tr></tbody>}</table>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<table>{<tbody><tr><td><div>foo</div></td><td><div>bar</div></td><td><div>baz</div></td></tr></tbody>}</table>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"{<table><tbody><tr><td><div>foo</div></td><td><div>bar</div></td><td><div>baz</div></td></tr></tbody></table>}",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"{<table><tbody><tr><td><div>foo</div></td><td><div>bar</div></td><td><div>baz</div></td></tr></tbody></table>}",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<div>[foobar]</div>",
	[["formatblock","<div>"]],
	"<div>[foobar]</div>",
	[true],
	{"formatblock":[false,false,"div",false,false,"div"]}],
["<p>[foobar]</p>",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<div>[foobar]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"div"]}],
["<p>[foobar]</p>",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<div>[foobar]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"div"]}],
["<blockquote>[foobar]</blockquote>",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<blockquote><div>[foobar]</div></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<blockquote>[foobar]</blockquote>",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<blockquote><div>[foobar]</div></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<h1>[foobar]</h1>",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<div>[foobar]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"h1",false,false,"div"]}],
["<h1>[foobar]</h1>",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<div>[foobar]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"h1",false,false,"div"]}],
["<h2>[foobar]</h2>",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<div>[foobar]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"h2",false,false,"div"]}],
["<h2>[foobar]</h2>",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<div>[foobar]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"h2",false,false,"div"]}],
["<h3>[foobar]</h3>",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<div>[foobar]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"h3",false,false,"div"]}],
["<h3>[foobar]</h3>",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<div>[foobar]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"h3",false,false,"div"]}],
["<h4>[foobar]</h4>",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<div>[foobar]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"h4",false,false,"div"]}],
["<h4>[foobar]</h4>",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<div>[foobar]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"h4",false,false,"div"]}],
["<h5>[foobar]</h5>",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<div>[foobar]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"h5",false,false,"div"]}],
["<h5>[foobar]</h5>",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<div>[foobar]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"h5",false,false,"div"]}],
["<h6>[foobar]</h6>",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<div>[foobar]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"h6",false,false,"div"]}],
["<h6>[foobar]</h6>",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<div>[foobar]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"h6",false,false,"div"]}],
["<dl><dt>[foo]<dd>bar</dl>",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<div>[foo]</div><dl><dd>bar</dd></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"dt",false,false,"div"]}],
["<dl><dt>[foo]<dd>bar</dl>",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<div>[foo]</div><dl><dd>bar</dd></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"dt",false,false,"div"]}],
["<dl><dt>foo<dd>[bar]</dl>",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<dl><dt>foo</dt></dl><div>[bar]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"dd",false,false,"div"]}],
["<dl><dt>foo<dd>[bar]</dl>",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<dl><dt>foo</dt></dl><div>[bar]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"dd",false,false,"div"]}],
["<dl><dt>[foo<dd>bar]</dl>",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<div>[foo</div><div>bar]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[true,false,"dt",false,false,"div"]}],
["<dl><dt>[foo<dd>bar]</dl>",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<div>[foo</div><div>bar]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[true,false,"dt",false,false,"div"]}],
["<ol><li>[foobar]</ol>",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<ol><li><div>[foobar]</div></li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<ol><li>[foobar]</ol>",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<ol><li><div>[foobar]</div></li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<ul><li>[foobar]</ul>",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<ul><li><div>[foobar]</div></li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<ul><li>[foobar]</ul>",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<ul><li><div>[foobar]</div></li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<address>[foobar]</address>",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<div>[foobar]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"address",false,false,"div"]}],
["<address>[foobar]</address>",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<div>[foobar]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"address",false,false,"div"]}],
["<pre>[foobar]</pre>",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<div>[foobar]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"pre",false,false,"div"]}],
["<pre>[foobar]</pre>",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<div>[foobar]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"pre",false,false,"div"]}],
["<article>[foobar]</article>",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<article><div>[foobar]</div></article>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<article>[foobar]</article>",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<article><div>[foobar]</div></article>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<ins>[foobar]</ins>",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<div><ins>[foobar]</ins></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<ins>[foobar]</ins>",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<div><ins>[foobar]</ins></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<del>[foobar]</del>",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<div><del>[foobar]</del></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<del>[foobar]</del>",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<div><del>[foobar]</del></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<quasit>[foobar]</quasit>",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<div><quasit>[foobar]</quasit></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<quasit>[foobar]</quasit>",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<div><quasit>[foobar]</quasit></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<quasit style=\"display: block\">[foobar]</quasit>",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<div><quasit style=\"display:block\">[foobar]</quasit></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<quasit style=\"display: block\">[foobar]</quasit>",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<div><quasit style=\"display:block\">[foobar]</quasit></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["foo[]bar<p>extra",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<p>foo[]bar</p><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["foo[]bar<p>extra",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<p>foo[]bar</p><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<span>foo</span>{}<span>bar</span><p>extra",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<p><span>foo</span>{}<span>bar</span></p><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<span>foo</span>{}<span>bar</span><p>extra",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<p><span>foo</span>{}<span>bar</span></p><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<span>foo[</span><span>]bar</span><p>extra",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<p><span>foo[</span><span>]bar</span></p><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<span>foo[</span><span>]bar</span><p>extra",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<p><span>foo[</span><span>]bar</span></p><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["foo[bar]baz<p>extra",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<p>foo[bar]baz</p><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["foo[bar]baz<p>extra",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<p>foo[bar]baz</p><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["foo]bar[baz<p>extra",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<p>foo[bar]baz</p><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["foo]bar[baz<p>extra",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<p>foo[bar]baz</p><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["{<p><p> <p>foo</p>}",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<p>{ foo}</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"p"]}],
["{<p><p> <p>foo</p>}",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<p>{ foo}</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"p"]}],
["foo[bar<i>baz]qoz</i>quz<p>extra",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<p>foo[bar<i>baz]qoz</i>quz</p><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["foo[bar<i>baz]qoz</i>quz<p>extra",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<p>foo[bar<i>baz]qoz</i>quz</p><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<table><tbody><tr><td>foo</td><td><p>b[a]r</p></td><td>baz</td></tr></tbody></table>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<table><tbody><tr><td>foo</td><td><p>b[a]r</p></td><td>baz</td></tr></tbody></table>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<table><tbody><tr><td>foo</td>{<td><p>bar</p></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<table><tbody><tr><td>foo</td>{<td><p>bar</p></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<table><tbody><tr>{<td><p>foo</p></td><td><p>bar</p></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<table><tbody><tr>{<td><p>foo</p></td><td><p>bar</p></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<table><tbody>{<tr><td><p>foo</p></td><td><p>bar</p></td><td><p>baz</p></td></tr>}</tbody></table>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<table><tbody>{<tr><td><p>foo</p></td><td><p>bar</p></td><td><p>baz</p></td></tr>}</tbody></table>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<table>{<tbody><tr><td><p>foo</p></td><td><p>bar</p></td><td><p>baz</p></td></tr></tbody>}</table>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<table>{<tbody><tr><td><p>foo</p></td><td><p>bar</p></td><td><p>baz</p></td></tr></tbody>}</table>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"{<table><tbody><tr><td><p>foo</p></td><td><p>bar</p></td><td><p>baz</p></td></tr></tbody></table>}",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"{<table><tbody><tr><td><p>foo</p></td><td><p>bar</p></td><td><p>baz</p></td></tr></tbody></table>}",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<div>[foobar]</div>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<p>[foobar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"div",false,false,"p"]}],
["<div>[foobar]</div>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<p>[foobar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"div",false,false,"p"]}],
["<p>[foobar]</p>",
	[["formatblock","<p>"]],
	"<p>[foobar]</p>",
	[true],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<blockquote>[foobar]</blockquote>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<blockquote><p>[foobar]</p></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<blockquote>[foobar]</blockquote>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<blockquote><p>[foobar]</p></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<h1>[foobar]</h1>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<p>[foobar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"h1",false,false,"p"]}],
["<h1>[foobar]</h1>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<p>[foobar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"h1",false,false,"p"]}],
["<h2>[foobar]</h2>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<p>[foobar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"h2",false,false,"p"]}],
["<h2>[foobar]</h2>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<p>[foobar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"h2",false,false,"p"]}],
["<h3>[foobar]</h3>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<p>[foobar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"h3",false,false,"p"]}],
["<h3>[foobar]</h3>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<p>[foobar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"h3",false,false,"p"]}],
["<h4>[foobar]</h4>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<p>[foobar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"h4",false,false,"p"]}],
["<h4>[foobar]</h4>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<p>[foobar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"h4",false,false,"p"]}],
["<h5>[foobar]</h5>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<p>[foobar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"h5",false,false,"p"]}],
["<h5>[foobar]</h5>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<p>[foobar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"h5",false,false,"p"]}],
["<h6>[foobar]</h6>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<p>[foobar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"h6",false,false,"p"]}],
["<h6>[foobar]</h6>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<p>[foobar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"h6",false,false,"p"]}],
["<dl><dt>[foo]<dd>bar</dl>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<p>[foo]</p><dl><dd>bar</dd></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"dt",false,false,"p"]}],
["<dl><dt>[foo]<dd>bar</dl>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<p>[foo]</p><dl><dd>bar</dd></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"dt",false,false,"p"]}],
["<dl><dt>foo<dd>[bar]</dl>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<dl><dt>foo</dt></dl><p>[bar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"dd",false,false,"p"]}],
["<dl><dt>foo<dd>[bar]</dl>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<dl><dt>foo</dt></dl><p>[bar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"dd",false,false,"p"]}],
["<dl><dt>[foo<dd>bar]</dl>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<p>[foo</p><p>bar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[true,false,"dt",false,false,"p"]}],
["<dl><dt>[foo<dd>bar]</dl>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<p>[foo</p><p>bar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[true,false,"dt",false,false,"p"]}],
["<ol><li>[foobar]</ol>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<ol><li><p>[foobar]</p></li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<ol><li>[foobar]</ol>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<ol><li><p>[foobar]</p></li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<ul><li>[foobar]</ul>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<ul><li><p>[foobar]</p></li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<ul><li>[foobar]</ul>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<ul><li><p>[foobar]</p></li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<address>[foobar]</address>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<p>[foobar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"address",false,false,"p"]}],
["<address>[foobar]</address>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<p>[foobar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"address",false,false,"p"]}],
["<pre>[foobar]</pre>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<p>[foobar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"pre",false,false,"p"]}],
["<pre>[foobar]</pre>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<p>[foobar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"pre",false,false,"p"]}],
["<listing>[foobar]</listing>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<p>[foobar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<listing>[foobar]</listing>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<p>[foobar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<xmp>[foobar]</xmp>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<p>[foobar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<xmp>[foobar]</xmp>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<p>[foobar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<article>[foobar]</article>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<article><p>[foobar]</p></article>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<article>[foobar]</article>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<article><p>[foobar]</p></article>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<ins>[foobar]</ins>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<p><ins>[foobar]</ins></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<ins>[foobar]</ins>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<p><ins>[foobar]</ins></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<del>[foobar]</del>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<p><del>[foobar]</del></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<del>[foobar]</del>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<p><del>[foobar]</del></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<quasit>[foobar]</quasit>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<p><quasit>[foobar]</quasit></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<quasit>[foobar]</quasit>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<p><quasit>[foobar]</quasit></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<quasit style=\"display: block\">[foobar]</quasit>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<p><quasit style=\"display:block\">[foobar]</quasit></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<quasit style=\"display: block\">[foobar]</quasit>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<p><quasit style=\"display:block\">[foobar]</quasit></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<blockquote>[foo]</blockquote><p>extra",
	[["formatblock","<blockquote>"]],
	"<blockquote>[foo]</blockquote><p>extra</p>",
	[false],
	{"formatblock":[false,false,"",false,false,""]}],
["<blockquote><p>[foo]<p>bar</blockquote><p>extra",
	[["formatblock","<blockquote>"]],
	"<blockquote><p>[foo]</p><p>bar</p></blockquote><p>extra</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["[foo]<blockquote>bar</blockquote><p>extra",
	[["formatblock","<blockquote>"]],
	"[foo]<blockquote>bar</blockquote><p>extra</p>",
	[false],
	{"formatblock":[false,false,"",false,false,""]}],
["<p>[foo<p>bar]<p>baz",
	[["formatblock","<blockquote>"]],
	"<p>[foo</p><p>bar]</p><p>baz</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<section>[foo]</section>",
	[["formatblock","<blockquote>"]],
	"<section>[foo]</section>",
	[false],
	{"formatblock":[false,false,"",false,false,""]}],
["<section><p>[foo]</section>",
	[["formatblock","<blockquote>"]],
	"<section><p>[foo]</p></section>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<section><hgroup><h1>[foo]</h1><h2>bar</h2></hgroup><p>baz</section>",
	[["formatblock","<blockquote>"]],
	"<section><hgroup><h1>[foo]</h1><h2>bar</h2></hgroup><p>baz</p></section>",
	[false],
	{"formatblock":[false,false,"h1",false,false,"h1"]}],
["<section>[foo]</section>",
	[["formatblock","<article>"]],
	"<section>[foo]</section>",
	[false],
	{"formatblock":[false,false,"",false,false,""]}],
["<div>[foobar]</div>",
	[["defaultparagraphseparator","div"],["formatblock","<address>"]],
	"<address>[foobar]</address>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"div",false,false,"address"]}],
["<div>[foobar]</div>",
	[["defaultparagraphseparator","p"],["formatblock","<address>"]],
	"<address>[foobar]</address>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"div",false,false,"address"]}],
["<div>[foobar]</div>",
	[["formatblock","<article>"]],
	"<div>[foobar]</div>",
	[false],
	{"formatblock":[false,false,"div",false,false,"div"]}],
["<div>[foobar]</div>",
	[["formatblock","<blockquote>"]],
	"<div>[foobar]</div>",
	[false],
	{"formatblock":[false,false,"div",false,false,"div"]}],
["<div>[foobar]</div>",
	[["defaultparagraphseparator","div"],["formatblock","<dd>"]],
	"<dl><dd>[foobar]</dd></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"div",false,false,"dd"]}],
["<div>[foobar]</div>",
	[["defaultparagraphseparator","p"],["formatblock","<dd>"]],
	"<dl><dd>[foobar]</dd></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"div",false,false,"dd"]}],
["<div>[foobar]</div>",
	[["formatblock","<del>"]],
	"<div>[foobar]</div>",
	[false],
	{"formatblock":[false,false,"div",false,false,"div"]}],
["<div>[foobar]</div>",
	[["formatblock","<dl>"]],
	"<div>[foobar]</div>",
	[false],
	{"formatblock":[false,false,"div",false,false,"div"]}],
["<div>[foobar]</div>",
	[["defaultparagraphseparator","div"],["formatblock","<dt>"]],
	"<dl><dt>[foobar]</dt></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"div",false,false,"dt"]}],
["<div>[foobar]</div>",
	[["defaultparagraphseparator","p"],["formatblock","<dt>"]],
	"<dl><dt>[foobar]</dt></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"div",false,false,"dt"]}],
["<div>[foobar]</div>",
	[["defaultparagraphseparator","div"],["formatblock","<h1>"]],
	"<h1>[foobar]</h1>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"div",false,false,"h1"]}],
["<div>[foobar]</div>",
	[["defaultparagraphseparator","p"],["formatblock","<h1>"]],
	"<h1>[foobar]</h1>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"div",false,false,"h1"]}],
["<div>[foobar]</div>",
	[["defaultparagraphseparator","div"],["formatblock","<h2>"]],
	"<h2>[foobar]</h2>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"div",false,false,"h2"]}],
["<div>[foobar]</div>",
	[["defaultparagraphseparator","p"],["formatblock","<h2>"]],
	"<h2>[foobar]</h2>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"div",false,false,"h2"]}],
["<div>[foobar]</div>",
	[["defaultparagraphseparator","div"],["formatblock","<h3>"]],
	"<h3>[foobar]</h3>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"div",false,false,"h3"]}],
["<div>[foobar]</div>",
	[["defaultparagraphseparator","p"],["formatblock","<h3>"]],
	"<h3>[foobar]</h3>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"div",false,false,"h3"]}],
["<div>[foobar]</div>",
	[["defaultparagraphseparator","div"],["formatblock","<h4>"]],
	"<h4>[foobar]</h4>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"div",false,false,"h4"]}],
["<div>[foobar]</div>",
	[["defaultparagraphseparator","p"],["formatblock","<h4>"]],
	"<h4>[foobar]</h4>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"div",false,false,"h4"]}],
["<div>[foobar]</div>",
	[["defaultparagraphseparator","div"],["formatblock","<h5>"]],
	"<h5>[foobar]</h5>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"div",false,false,"h5"]}],
["<div>[foobar]</div>",
	[["defaultparagraphseparator","p"],["formatblock","<h5>"]],
	"<h5>[foobar]</h5>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"div",false,false,"h5"]}],
["<div>[foobar]</div>",
	[["defaultparagraphseparator","div"],["formatblock","<h6>"]],
	"<h6>[foobar]</h6>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"div",false,false,"h6"]}],
["<div>[foobar]</div>",
	[["defaultparagraphseparator","p"],["formatblock","<h6>"]],
	"<h6>[foobar]</h6>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"div",false,false,"h6"]}],
["<div>[foobar]</div>",
	[["formatblock","<ins>"]],
	"<div>[foobar]</div>",
	[false],
	{"formatblock":[false,false,"div",false,false,"div"]}],
["<div>[foobar]</div>",
	[["formatblock","<li>"]],
	"<div>[foobar]</div>",
	[false],
	{"formatblock":[false,false,"div",false,false,"div"]}],
["<div>[foobar]</div>",
	[["formatblock","<ol>"]],
	"<div>[foobar]</div>",
	[false],
	{"formatblock":[false,false,"div",false,false,"div"]}],
["<div>[foobar]</div>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<p>[foobar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"div",false,false,"p"]}],
["<div>[foobar]</div>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<p>[foobar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"div",false,false,"p"]}],
["<div>[foobar]</div>",
	[["defaultparagraphseparator","div"],["formatblock","<pre>"]],
	"<pre>[foobar]</pre>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"div",false,false,"pre"]}],
["<div>[foobar]</div>",
	[["defaultparagraphseparator","p"],["formatblock","<pre>"]],
	"<pre>[foobar]</pre>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"div",false,false,"pre"]}],
["<div>[foobar]</div>",
	[["formatblock","<ul>"]],
	"<div>[foobar]</div>",
	[false],
	{"formatblock":[false,false,"div",false,false,"div"]}],
["<div>[foobar]</div>",
	[["formatblock","<quasit>"]],
	"<div>[foobar]</div>",
	[false],
	{"formatblock":[false,false,"div",false,false,"div"]}],
["<p>[foobar]</p>",
	[["defaultparagraphseparator","div"],["formatblock","<address>"]],
	"<address>[foobar]</address>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"address"]}],
["<p>[foobar]</p>",
	[["defaultparagraphseparator","p"],["formatblock","<address>"]],
	"<address>[foobar]</address>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"address"]}],
["<p>[foobar]</p>",
	[["formatblock","<article>"]],
	"<p>[foobar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
	[["formatblock","<aside>"]],
	"<p>[foobar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
	[["formatblock","<blockquote>"]],
	"<p>[foobar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
	[["formatblock","<body>"]],
	"<p>[foobar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
	[["defaultparagraphseparator","div"],["formatblock","<dd>"]],
	"<dl><dd>[foobar]</dd></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"dd"]}],
["<p>[foobar]</p>",
	[["defaultparagraphseparator","p"],["formatblock","<dd>"]],
	"<dl><dd>[foobar]</dd></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"dd"]}],
["<p>[foobar]</p>",
	[["formatblock","<del>"]],
	"<p>[foobar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
	[["formatblock","<details>"]],
	"<p>[foobar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
	[["formatblock","<dir>"]],
	"<p>[foobar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<div>[foobar]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"div"]}],
["<p>[foobar]</p>",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<div>[foobar]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"div"]}],
["<p>[foobar]</p>",
	[["formatblock","<dl>"]],
	"<p>[foobar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
	[["defaultparagraphseparator","div"],["formatblock","<dt>"]],
	"<dl><dt>[foobar]</dt></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"dt"]}],
["<p>[foobar]</p>",
	[["defaultparagraphseparator","p"],["formatblock","<dt>"]],
	"<dl><dt>[foobar]</dt></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"dt"]}],
["<p>[foobar]</p>",
	[["formatblock","<fieldset>"]],
	"<p>[foobar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
	[["formatblock","<figcaption>"]],
	"<p>[foobar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
	[["formatblock","<figure>"]],
	"<p>[foobar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
	[["formatblock","<footer>"]],
	"<p>[foobar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
	[["formatblock","<form>"]],
	"<p>[foobar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
	[["defaultparagraphseparator","div"],["formatblock","<h1>"]],
	"<h1>[foobar]</h1>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"h1"]}],
["<p>[foobar]</p>",
	[["defaultparagraphseparator","p"],["formatblock","<h1>"]],
	"<h1>[foobar]</h1>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"h1"]}],
["<p>[foobar]</p>",
	[["defaultparagraphseparator","div"],["formatblock","<h2>"]],
	"<h2>[foobar]</h2>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"h2"]}],
["<p>[foobar]</p>",
	[["defaultparagraphseparator","p"],["formatblock","<h2>"]],
	"<h2>[foobar]</h2>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"h2"]}],
["<p>[foobar]</p>",
	[["defaultparagraphseparator","div"],["formatblock","<h3>"]],
	"<h3>[foobar]</h3>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"h3"]}],
["<p>[foobar]</p>",
	[["defaultparagraphseparator","p"],["formatblock","<h3>"]],
	"<h3>[foobar]</h3>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"h3"]}],
["<p>[foobar]</p>",
	[["defaultparagraphseparator","div"],["formatblock","<h4>"]],
	"<h4>[foobar]</h4>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"h4"]}],
["<p>[foobar]</p>",
	[["defaultparagraphseparator","p"],["formatblock","<h4>"]],
	"<h4>[foobar]</h4>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"h4"]}],
["<p>[foobar]</p>",
	[["defaultparagraphseparator","div"],["formatblock","<h5>"]],
	"<h5>[foobar]</h5>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"h5"]}],
["<p>[foobar]</p>",
	[["defaultparagraphseparator","p"],["formatblock","<h5>"]],
	"<h5>[foobar]</h5>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"h5"]}],
["<p>[foobar]</p>",
	[["defaultparagraphseparator","div"],["formatblock","<h6>"]],
	"<h6>[foobar]</h6>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"h6"]}],
["<p>[foobar]</p>",
	[["defaultparagraphseparator","p"],["formatblock","<h6>"]],
	"<h6>[foobar]</h6>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"h6"]}],
["<p>[foobar]</p>",
	[["formatblock","<header>"]],
	"<p>[foobar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
	[["formatblock","<head>"]],
	"<p>[foobar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
	[["formatblock","<hgroup>"]],
	"<p>[foobar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
	[["formatblock","<hr>"]],
	"<p>[foobar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
	[["formatblock","<html>"]],
	"<p>[foobar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
	[["formatblock","<ins>"]],
	"<p>[foobar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
	[["formatblock","<li>"]],
	"<p>[foobar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
	[["formatblock","<listing>"]],
	"<p>[foobar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
	[["formatblock","<menu>"]],
	"<p>[foobar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
	[["formatblock","<nav>"]],
	"<p>[foobar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
	[["formatblock","<ol>"]],
	"<p>[foobar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
	[["formatblock","<p>"]],
	"<p>[foobar]</p>",
	[true],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
	[["formatblock","<plaintext>"]],
	"<p>[foobar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
	[["defaultparagraphseparator","div"],["formatblock","<pre>"]],
	"<pre>[foobar]</pre>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"pre"]}],
["<p>[foobar]</p>",
	[["defaultparagraphseparator","p"],["formatblock","<pre>"]],
	"<pre>[foobar]</pre>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"pre"]}],
["<p>[foobar]</p>",
	[["formatblock","<section>"]],
	"<p>[foobar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
	[["formatblock","<ul>"]],
	"<p>[foobar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
	[["formatblock","<xmp>"]],
	"<p>[foobar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
	[["formatblock","<quasit>"]],
	"<p>[foobar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
	[["defaultparagraphseparator","div"],["formatblock","<address>"]],
	"<address>[foo<br>bar]</address>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"address"]}],
["<p>[foo<p>bar]",
	[["defaultparagraphseparator","p"],["formatblock","<address>"]],
	"<address>[foo<br>bar]</address>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"address"]}],
["<p>[foo<p>bar]",
	[["formatblock","<article>"]],
	"<p>[foo</p><p>bar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
	[["formatblock","<aside>"]],
	"<p>[foo</p><p>bar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
	[["formatblock","<blockquote>"]],
	"<p>[foo</p><p>bar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
	[["formatblock","<body>"]],
	"<p>[foo</p><p>bar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
	[["defaultparagraphseparator","div"],["formatblock","<dd>"]],
	"<dl><dd>[foo</dd><dd>bar]</dd></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"dd"]}],
["<p>[foo<p>bar]",
	[["defaultparagraphseparator","p"],["formatblock","<dd>"]],
	"<dl><dd>[foo</dd><dd>bar]</dd></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"dd"]}],
["<p>[foo<p>bar]",
	[["formatblock","<del>"]],
	"<p>[foo</p><p>bar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
	[["formatblock","<details>"]],
	"<p>[foo</p><p>bar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
	[["formatblock","<dir>"]],
	"<p>[foo</p><p>bar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<div>[foo</div><div>bar]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"div"]}],
["<p>[foo<p>bar]",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<div>[foo</div><div>bar]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"div"]}],
["<p>[foo<p>bar]",
	[["formatblock","<dl>"]],
	"<p>[foo</p><p>bar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
	[["defaultparagraphseparator","div"],["formatblock","<dt>"]],
	"<dl><dt>[foo</dt><dt>bar]</dt></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"dt"]}],
["<p>[foo<p>bar]",
	[["defaultparagraphseparator","p"],["formatblock","<dt>"]],
	"<dl><dt>[foo</dt><dt>bar]</dt></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"dt"]}],
["<p>[foo<p>bar]",
	[["formatblock","<fieldset>"]],
	"<p>[foo</p><p>bar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
	[["formatblock","<figcaption>"]],
	"<p>[foo</p><p>bar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
	[["formatblock","<figure>"]],
	"<p>[foo</p><p>bar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
	[["formatblock","<footer>"]],
	"<p>[foo</p><p>bar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
	[["formatblock","<form>"]],
	"<p>[foo</p><p>bar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
	[["defaultparagraphseparator","div"],["formatblock","<h1>"]],
	"<h1>[foo<br>bar]</h1>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"h1"]}],
["<p>[foo<p>bar]",
	[["defaultparagraphseparator","p"],["formatblock","<h1>"]],
	"<h1>[foo<br>bar]</h1>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"h1"]}],
["<p>[foo<p>bar]",
	[["defaultparagraphseparator","div"],["formatblock","<h2>"]],
	"<h2>[foo<br>bar]</h2>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"h2"]}],
["<p>[foo<p>bar]",
	[["defaultparagraphseparator","p"],["formatblock","<h2>"]],
	"<h2>[foo<br>bar]</h2>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"h2"]}],
["<p>[foo<p>bar]",
	[["defaultparagraphseparator","div"],["formatblock","<h3>"]],
	"<h3>[foo<br>bar]</h3>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"h3"]}],
["<p>[foo<p>bar]",
	[["defaultparagraphseparator","p"],["formatblock","<h3>"]],
	"<h3>[foo<br>bar]</h3>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"h3"]}],
["<p>[foo<p>bar]",
	[["defaultparagraphseparator","div"],["formatblock","<h4>"]],
	"<h4>[foo<br>bar]</h4>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"h4"]}],
["<p>[foo<p>bar]",
	[["defaultparagraphseparator","p"],["formatblock","<h4>"]],
	"<h4>[foo<br>bar]</h4>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"h4"]}],
["<p>[foo<p>bar]",
	[["defaultparagraphseparator","div"],["formatblock","<h5>"]],
	"<h5>[foo<br>bar]</h5>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"h5"]}],
["<p>[foo<p>bar]",
	[["defaultparagraphseparator","p"],["formatblock","<h5>"]],
	"<h5>[foo<br>bar]</h5>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"h5"]}],
["<p>[foo<p>bar]",
	[["defaultparagraphseparator","div"],["formatblock","<h6>"]],
	"<h6>[foo<br>bar]</h6>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"h6"]}],
["<p>[foo<p>bar]",
	[["defaultparagraphseparator","p"],["formatblock","<h6>"]],
	"<h6>[foo<br>bar]</h6>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"h6"]}],
["<p>[foo<p>bar]",
	[["formatblock","<header>"]],
	"<p>[foo</p><p>bar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
	[["formatblock","<head>"]],
	"<p>[foo</p><p>bar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
	[["formatblock","<hgroup>"]],
	"<p>[foo</p><p>bar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
	[["formatblock","<hr>"]],
	"<p>[foo</p><p>bar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
	[["formatblock","<html>"]],
	"<p>[foo</p><p>bar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
	[["formatblock","<ins>"]],
	"<p>[foo</p><p>bar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
	[["formatblock","<li>"]],
	"<p>[foo</p><p>bar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
	[["formatblock","<listing>"]],
	"<p>[foo</p><p>bar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
	[["formatblock","<menu>"]],
	"<p>[foo</p><p>bar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
	[["formatblock","<nav>"]],
	"<p>[foo</p><p>bar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
	[["formatblock","<ol>"]],
	"<p>[foo</p><p>bar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
	[["formatblock","<p>"]],
	"<p>[foo</p><p>bar]</p>",
	[true],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
	[["formatblock","<plaintext>"]],
	"<p>[foo</p><p>bar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
	[["defaultparagraphseparator","div"],["formatblock","<pre>"]],
	"<pre>[foo<br>bar]</pre>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"pre"]}],
["<p>[foo<p>bar]",
	[["defaultparagraphseparator","p"],["formatblock","<pre>"]],
	"<pre>[foo<br>bar]</pre>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"pre"]}],
["<p>[foo<p>bar]",
	[["formatblock","<section>"]],
	"<p>[foo</p><p>bar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
	[["formatblock","<ul>"]],
	"<p>[foo</p><p>bar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
	[["formatblock","<xmp>"]],
	"<p>[foo</p><p>bar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
	[["formatblock","<quasit>"]],
	"<p>[foo</p><p>bar]</p>",
	[false],
	{"formatblock":[false,false,"p",false,false,"p"]}],
["<div>[foobar]</div>",
	[["defaultparagraphseparator","div"],["formatblock","p"]],
	"<p>[foobar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"div",false,false,"p"]}],
["<div>[foobar]</div>",
	[["defaultparagraphseparator","p"],["formatblock","p"]],
	"<p>[foobar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"div",false,false,"p"]}],
["<ol><li>[foo]<li>bar</ol>",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<ol><li><div>[foo]</div></li><li>bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<ol><li>[foo]<li>bar</ol>",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<ol><li><div>[foo]</div></li><li>bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<h1>[foo]<br>bar</h1>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<p>[foo]</p><h1>bar</h1>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"h1",false,false,"p"]}],
["<h1>[foo]<br>bar</h1>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<p>[foo]</p><h1>bar</h1>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"h1",false,false,"p"]}],
["<h1>foo<br>[bar]</h1>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<h1>foo</h1><p>[bar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"h1",false,false,"p"]}],
["<h1>foo<br>[bar]</h1>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<h1>foo</h1><p>[bar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"h1",false,false,"p"]}],
["<h1>[foo<br>bar]</h1>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<p>[foo<br>bar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"h1",false,false,"p"]}],
["<h1>[foo<br>bar]</h1>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<p>[foo<br>bar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"h1",false,false,"p"]}],
["<h1>[foo]<br>bar</h1>",
	[["formatblock","<address>"]],
	"<address>[foo]</address><h1>bar</h1>",
	[true],
	{"formatblock":[false,false,"h1",false,false,"address"]}],
["<h1>foo<br>[bar]</h1>",
	[["formatblock","<address>"]],
	"<h1>foo</h1><address>[bar]</address>",
	[true],
	{"formatblock":[false,false,"h1",false,false,"address"]}],
["<h1>[foo<br>bar]</h1>",
	[["formatblock","<address>"]],
	"<address>[foo<br>bar]</address>",
	[true],
	{"formatblock":[false,false,"h1",false,false,"address"]}],
["<h1>[foo]<br>bar</h1>",
	[["formatblock","<pre>"]],
	"<pre>[foo]</pre><h1>bar</h1>",
	[true],
	{"formatblock":[false,false,"h1",false,false,"pre"]}],
["<h1>foo<br>[bar]</h1>",
	[["formatblock","<pre>"]],
	"<h1>foo</h1><pre>[bar]</pre>",
	[true],
	{"formatblock":[false,false,"h1",false,false,"pre"]}],
["<h1>[foo<br>bar]</h1>",
	[["formatblock","<pre>"]],
	"<pre>[foo<br>bar]</pre>",
	[true],
	{"formatblock":[false,false,"h1",false,false,"pre"]}],
["<h1>[foo]<br>bar</h1>",
	[["formatblock","<h2>"]],
	"<h2>[foo]</h2><h1>bar</h1>",
	[true],
	{"formatblock":[false,false,"h1",false,false,"h2"]}],
["<h1>foo<br>[bar]</h1>",
	[["formatblock","<h2>"]],
	"<h1>foo</h1><h2>[bar]</h2>",
	[true],
	{"formatblock":[false,false,"h1",false,false,"h2"]}],
["<h1>[foo<br>bar]</h1>",
	[["formatblock","<h2>"]],
	"<h2>[foo<br>bar]</h2>",
	[true],
	{"formatblock":[false,false,"h1",false,false,"h2"]}],
["<p>[foo]<br>bar</p>",
	[["formatblock","<h1>"]],
	"<h1>[foo]</h1><p>bar</p>",
	[true],
	{"formatblock":[false,false,"p",false,false,"h1"]}],
["<p>foo<br>[bar]</p>",
	[["formatblock","<h1>"]],
	"<p>foo</p><h1>[bar]</h1>",
	[true],
	{"formatblock":[false,false,"p",false,false,"h1"]}],
["<p>[foo<br>bar]</p>",
	[["defaultparagraphseparator","div"],["formatblock","<h1>"]],
	"<h1>[foo<br>bar]</h1>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"h1"]}],
["<p>[foo<br>bar]</p>",
	[["defaultparagraphseparator","p"],["formatblock","<h1>"]],
	"<h1>[foo<br>bar]</h1>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"h1"]}],
["<p>[foo]<br>bar</p>",
	[["formatblock","<address>"]],
	"<address>[foo]</address><p>bar</p>",
	[true],
	{"formatblock":[false,false,"p",false,false,"address"]}],
["<p>foo<br>[bar]</p>",
	[["formatblock","<address>"]],
	"<p>foo</p><address>[bar]</address>",
	[true],
	{"formatblock":[false,false,"p",false,false,"address"]}],
["<p>[foo<br>bar]</p>",
	[["defaultparagraphseparator","div"],["formatblock","<address>"]],
	"<address>[foo<br>bar]</address>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"address"]}],
["<p>[foo<br>bar]</p>",
	[["defaultparagraphseparator","p"],["formatblock","<address>"]],
	"<address>[foo<br>bar]</address>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"address"]}],
["<p>[foo]<br>bar</p>",
	[["formatblock","<pre>"]],
	"<pre>[foo]</pre><p>bar</p>",
	[true],
	{"formatblock":[false,false,"p",false,false,"pre"]}],
["<p>foo<br>[bar]</p>",
	[["formatblock","<pre>"]],
	"<p>foo</p><pre>[bar]</pre>",
	[true],
	{"formatblock":[false,false,"p",false,false,"pre"]}],
["<p>[foo<br>bar]</p>",
	[["defaultparagraphseparator","div"],["formatblock","<pre>"]],
	"<pre>[foo<br>bar]</pre>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"pre"]}],
["<p>[foo<br>bar]</p>",
	[["defaultparagraphseparator","p"],["formatblock","<pre>"]],
	"<pre>[foo<br>bar]</pre>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"pre"]}],
["<address>[foo]<br>bar</address>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<p>[foo]</p><address>bar</address>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"address",false,false,"p"]}],
["<address>[foo]<br>bar</address>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<p>[foo]</p><address>bar</address>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"address",false,false,"p"]}],
["<address>foo<br>[bar]</address>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<address>foo</address><p>[bar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"address",false,false,"p"]}],
["<address>foo<br>[bar]</address>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<address>foo</address><p>[bar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"address",false,false,"p"]}],
["<address>[foo<br>bar]</address>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<p>[foo<br>bar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"address",false,false,"p"]}],
["<address>[foo<br>bar]</address>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<p>[foo<br>bar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"address",false,false,"p"]}],
["<address>[foo]<br>bar</address>",
	[["formatblock","<pre>"]],
	"<pre>[foo]</pre><address>bar</address>",
	[true],
	{"formatblock":[false,false,"address",false,false,"pre"]}],
["<address>foo<br>[bar]</address>",
	[["formatblock","<pre>"]],
	"<address>foo</address><pre>[bar]</pre>",
	[true],
	{"formatblock":[false,false,"address",false,false,"pre"]}],
["<address>[foo<br>bar]</address>",
	[["formatblock","<pre>"]],
	"<pre>[foo<br>bar]</pre>",
	[true],
	{"formatblock":[false,false,"address",false,false,"pre"]}],
["<address>[foo]<br>bar</address>",
	[["formatblock","<h1>"]],
	"<h1>[foo]</h1><address>bar</address>",
	[true],
	{"formatblock":[false,false,"address",false,false,"h1"]}],
["<address>foo<br>[bar]</address>",
	[["formatblock","<h1>"]],
	"<address>foo</address><h1>[bar]</h1>",
	[true],
	{"formatblock":[false,false,"address",false,false,"h1"]}],
["<address>[foo<br>bar]</address>",
	[["formatblock","<h1>"]],
	"<h1>[foo<br>bar]</h1>",
	[true],
	{"formatblock":[false,false,"address",false,false,"h1"]}],
["<pre>[foo]<br>bar</pre>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<p>[foo]</p><pre>bar</pre>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"pre",false,false,"p"]}],
["<pre>[foo]<br>bar</pre>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<p>[foo]</p><pre>bar</pre>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"pre",false,false,"p"]}],
["<pre>foo<br>[bar]</pre>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<pre>foo</pre><p>[bar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"pre",false,false,"p"]}],
["<pre>foo<br>[bar]</pre>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<pre>foo</pre><p>[bar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"pre",false,false,"p"]}],
["<pre>[foo<br>bar]</pre>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<p>[foo<br>bar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"pre",false,false,"p"]}],
["<pre>[foo<br>bar]</pre>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<p>[foo<br>bar]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"pre",false,false,"p"]}],
["<pre>[foo]<br>bar</pre>",
	[["formatblock","<address>"]],
	"<address>[foo]</address><pre>bar</pre>",
	[true],
	{"formatblock":[false,false,"pre",false,false,"address"]}],
["<pre>foo<br>[bar]</pre>",
	[["formatblock","<address>"]],
	"<pre>foo</pre><address>[bar]</address>",
	[true],
	{"formatblock":[false,false,"pre",false,false,"address"]}],
["<pre>[foo<br>bar]</pre>",
	[["formatblock","<address>"]],
	"<address>[foo<br>bar]</address>",
	[true],
	{"formatblock":[false,false,"pre",false,false,"address"]}],
["<pre>[foo]<br>bar</pre>",
	[["formatblock","<h1>"]],
	"<h1>[foo]</h1><pre>bar</pre>",
	[true],
	{"formatblock":[false,false,"pre",false,false,"h1"]}],
["<pre>foo<br>[bar]</pre>",
	[["formatblock","<h1>"]],
	"<pre>foo</pre><h1>[bar]</h1>",
	[true],
	{"formatblock":[false,false,"pre",false,false,"h1"]}],
["<pre>[foo<br>bar]</pre>",
	[["formatblock","<h1>"]],
	"<h1>[foo<br>bar]</h1>",
	[true],
	{"formatblock":[false,false,"pre",false,false,"h1"]}],
["<p>[foo</p>bar]",
	[["defaultparagraphseparator","div"],["formatblock","<h1>"]],
	"<h1>[foo<br>bar]</h1>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[true,false,"p",false,false,"h1"]}],
["<p>[foo</p>bar]",
	[["defaultparagraphseparator","p"],["formatblock","<h1>"]],
	"<h1>[foo<br>bar]</h1>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[true,false,"p",false,false,"h1"]}],
["[foo<p>bar]</p>",
	[["defaultparagraphseparator","div"],["formatblock","<h1>"]],
	"<h1>[foo<br>bar]</h1>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[true,false,"",false,false,"h1"]}],
["[foo<p>bar]</p>",
	[["defaultparagraphseparator","p"],["formatblock","<h1>"]],
	"<h1>[foo<br>bar]</h1>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[true,false,"",false,false,"h1"]}],
["<div>[foo<p>bar]</p></div>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<div><p>[foo</p><p>bar]</p></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[true,false,"",false,false,"p"]}],
["<div>[foo<p>bar]</p></div>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<div><p>[foo</p><p>bar]</p></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[true,false,"",false,false,"p"]}],
["<xmp>[foo]</xmp>",
	[["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<p>[foo]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<xmp>[foo]</xmp>",
	[["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<p>[foo]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<xmp>[foo]</xmp>",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<div>[foo]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<xmp>[foo]</xmp>",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<div>[foo]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<div><ol><li>[foo]</ol></div>",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<div><ol><li><div>[foo]</div></li></ol></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<div><ol><li>[foo]</ol></div>",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<div><ol><li><div>[foo]</div></li></ol></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<div><table><tr><td>[foo]</table></div>",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<div><table><tbody><tr><td><div>[foo]</div></td></tr></tbody></table></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<div><table><tr><td>[foo]</table></div>",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<div><table><tbody><tr><td><div>[foo]</div></td></tr></tbody></table></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<p>[foo<h1>bar]</h1>",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<div>[foo</div><div>bar]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[true,false,"p",false,false,"div"]}],
["<p>[foo<h1>bar]</h1>",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<div>[foo</div><div>bar]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[true,false,"p",false,false,"div"]}],
["<h1>[foo</h1><h2>bar]</h2>",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<div>[foo</div><div>bar]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[true,false,"h1",false,false,"div"]}],
["<h1>[foo</h1><h2>bar]</h2>",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<div>[foo</div><div>bar]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[true,false,"h1",false,false,"div"]}],
["<div>[foo</div>bar]",
	[["defaultparagraphseparator","div"],["formatblock","<div>"]],
	"<div>[foo</div><div>bar]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[true,false,"div",false,false,"div"]}],
["<div>[foo</div>bar]",
	[["defaultparagraphseparator","p"],["formatblock","<div>"]],
	"<div>[foo</div><div>bar]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[true,false,"div",false,false,"div"]}],
["<div style=color:blue>[foo]</div>",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<p><span style=\"color:rgb(0, 0, 255)\">[foo]</span></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"div",false,false,"p"]}],
["<div style=color:blue>[foo]</div>",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["formatblock","<p>"]],
	"<p><font color=\"#0000ff\">[foo]</font></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"formatblock":[false,false,"div",false,false,"p"]}],
["<div style=color:blue>[foo]</div>",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<p><span style=\"color:rgb(0, 0, 255)\">[foo]</span></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"div",false,false,"p"]}],
["<div style=color:blue>[foo]</div>",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["formatblock","<p>"]],
	"<p><font color=\"#0000ff\">[foo]</font></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"formatblock":[false,false,"div",false,false,"p"]}],
["{<p>foo</p>ba]r",
	[["defaultparagraphseparator","div"],["formatblock","<h1>"]],
	"<h1>{foo<br>ba]r</h1>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[true,false,"p",false,false,"h1"]}],
["{<p>foo</p>ba]r",
	[["defaultparagraphseparator","p"],["formatblock","<h1>"]],
	"<h1>{foo<br>ba]r</h1>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[true,false,"p",false,false,"h1"]}],
["foo[]",
	[["forwarddelete",""]],
	"foo{}",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<span>foo[]</span>",
	[["forwarddelete",""]],
	"<span>foo</span>{}",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]</p>",
	[["forwarddelete",""]],
	"<p>foo{}</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]bar",
	[["forwarddelete",""]],
	"foo[]ar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<span>foo</span>{}<span>bar</span>",
	[["forwarddelete",""]],
	"<span>foo</span><span>{}ar</span>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<span>foo[</span><span>]bar</span>",
	[["forwarddelete",""]],
	"<span>foo[]</span><span>bar</span>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<span style=display:none>bar</span>baz",
	[["stylewithcss","true"],["forwarddelete",""]],
	"foo{}az",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<span style=display:none>bar</span>baz",
	[["stylewithcss","false"],["forwarddelete",""]],
	"foo{}az",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<script>bar</script>baz",
	[["forwarddelete",""]],
	"foo{}az",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["fo[]&ouml;bar",
	[["forwarddelete",""]],
	"fo[]bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["fo[]o&#x308;bar",
	[["forwarddelete",""]],
	"fo[]bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["fo[]o&#x308;&#x327;bar",
	[["forwarddelete",""]],
	"fo[]bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["[]&ouml;bar",
	[["forwarddelete",""]],
	"{}bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["[]o&#x308;bar",
	[["forwarddelete",""]],
	"{}bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["[]o&#x308;&#x327;bar",
	[["forwarddelete",""]],
	"{}bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["[]&#x5e9;&#x5c1;&#x5b8;&#x5dc;&#x5d5;&#x5b9;&#x5dd;",
	[["forwarddelete",""]],
	"{}לוֹם",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["&#x5e9;&#x5c1;&#x5b8;&#x5dc;[]&#x5d5;&#x5b9;&#x5dd;",
	[["forwarddelete",""]],
	"שָׁל[]ם",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]</p><p>bar</p>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p>foo{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]</p><p>bar</p>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p>foo{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]</p>bar",
	[["forwarddelete",""]],
	"<p>foo{}bar</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<p>bar</p>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<p>bar</p>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<br></p><p>bar</p>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p>foo{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<br></p><p>bar</p>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p>foo{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<br></p>bar",
	[["forwarddelete",""]],
	"<p>foo{}bar</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<br><p>bar</p>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<br><p>bar</p>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>{}<br></p>foo",
	[["forwarddelete",""]],
	"<p>{}foo</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<p>{}<span><br></span></p>foo",
	[["forwarddelete",""]],
	"<p>{}foo</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo{}<p><br>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"foo{}",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{}<p><br>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"foo{}",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{}<p><span><br></span>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"foo{}",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{}<p><span><br></span>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"foo{}",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{}<br><p><br>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"foo{}",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{}<br><p><br>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"foo{}",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{}<span><br></span><p><br>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"foo{}",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{}<span><br></span><p><br>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"foo{}",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{}<br><p><span><br></span>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"foo{}",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{}<br><p><span><br></span>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"foo{}",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{}<span><br></span><p><span><br></span>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"foo{}",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{}<span><br></span><p><span><br></span>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"foo{}",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{}<p>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"foo{}",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{}<p>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"foo{}",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<table><tr><td>{}</table>foo",
	[["forwarddelete",""]],
	"<table><tbody><tr><td>{}</td></tr></tbody></table>foo",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<table><tr><td>{}<br></table>foo",
	[["forwarddelete",""]],
	"<table><tbody><tr><td>{}<br></td></tr></tbody></table>foo",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<table><tr><td>{}<span><br></span></table>foo",
	[["forwarddelete",""]],
	"<table><tbody><tr><td>{}<span><br></span></td></tr></tbody></table>foo",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<div><p>foo[]</p></div><p>bar</p>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<div><p>foo{}bar</p></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><p>foo[]</p></div><p>bar</p>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<div><p>foo{}bar</p></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]</p><div><p>bar</p></div>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p>foo{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]</p><div><p>bar</p></div>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p>foo{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><p>foo[]</p></div><div><p>bar</p></div>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<div><p>foo{}bar</p></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><p>foo[]</p></div><div><p>bar</p></div>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<div><p>foo{}bar</p></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><p>foo[]</p></div>bar",
	[["forwarddelete",""]],
	"<div><p>foo{}bar</p></div>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<div><p>bar</p></div>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<div><p>bar</p></div>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<div>foo[]</div><div>bar</div>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<div>foo{}bar</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<div>foo[]</div><div>bar</div>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<div>foo{}bar</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<pre>foo[]</pre>bar",
	[["forwarddelete",""]],
	"<pre>foo{}bar</pre>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<br>bar",
	[["forwarddelete",""]],
	"foo{}bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<b>foo[]</b><br>bar",
	[["forwarddelete",""]],
	"<b>foo</b>{}bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<hr>bar",
	[["forwarddelete",""]],
	"foo{}bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<hr><p>bar",
	[["forwarddelete",""]],
	"<p>foo{}</p><p>bar</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]</p><br><p>bar</p>",
	[["forwarddelete",""]],
	"<p>foo{}</p><p>bar</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]</p><br><br><p>bar</p>",
	[["forwarddelete",""]],
	"<p>foo{}</p><br><p>bar</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]</p><img src=/img/lion.svg><p>bar",
	[["forwarddelete",""]],
	"<p>foo{}<img src=\"/img/lion.svg\"></p><p>bar</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<img src=/img/lion.svg>bar",
	[["forwarddelete",""]],
	"foo{}bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<a>bar</a>",
	[["forwarddelete",""]],
	"foo<a>{}ar</a>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<a href=/>bar</a>",
	[["forwarddelete",""]],
	"foo<a href=\"/\">{}ar</a>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<a name=abc>bar</a>",
	[["forwarddelete",""]],
	"foo<a name=\"abc\">{}ar</a>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<a href=/ name=abc>bar</a>",
	[["forwarddelete",""]],
	"foo<a href=\"/\" name=\"abc\">{}ar</a>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<span><a>bar</a></span>",
	[["forwarddelete",""]],
	"foo<span><a>{}ar</a></span>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<span><a href=/>bar</a></span>",
	[["forwarddelete",""]],
	"foo<span><a href=\"/\">{}ar</a></span>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<span><a name=abc>bar</a></span>",
	[["forwarddelete",""]],
	"foo<span><a name=\"abc\">{}ar</a></span>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<span><a href=/ name=abc>bar</a></span>",
	[["forwarddelete",""]],
	"foo<span><a href=\"/\" name=\"abc\">{}ar</a></span>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<a>foo[]</a>bar",
	[["forwarddelete",""]],
	"<a>foo</a>{}ar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<a href=/>foo[]</a>bar",
	[["forwarddelete",""]],
	"<a href=\"/\">foo</a>{}ar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<a name=abc>foo[]</a>bar",
	[["forwarddelete",""]],
	"<a name=\"abc\">foo</a>{}ar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<a href=/ name=abc>foo[]</a>bar",
	[["forwarddelete",""]],
	"<a href=\"/\" name=\"abc\">foo</a>{}ar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo []&nbsp;",
	[["forwarddelete",""]],
	"foo&nbsp;[]",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["[]&nbsp; foo",
	[["forwarddelete",""]],
	"{}&nbsp;foo",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[] &nbsp;bar",
	[["forwarddelete",""]],
	"foo[] bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]&nbsp; bar",
	[["forwarddelete",""]],
	"foo[] bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]&nbsp;&nbsp;bar",
	[["forwarddelete",""]],
	"foo[] bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]  bar",
	[["forwarddelete",""]],
	"foo[]bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[] &nbsp; bar",
	[["forwarddelete",""]],
	"foo[]&nbsp; bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo []&nbsp; bar",
	[["forwarddelete",""]],
	"foo&nbsp;[] bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo &nbsp;[] bar",
	[["forwarddelete",""]],
	"foo&nbsp; []bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[] <span>&nbsp;</span> bar",
	[["forwarddelete",""]],
	"foo[]<span>&nbsp;</span> bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo []<span>&nbsp;</span> bar",
	[["forwarddelete",""]],
	"foo&nbsp;{} bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo <span>&nbsp;</span>[] bar",
	[["forwarddelete",""]],
	"foo&nbsp;<span> </span>{}bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<b>foo[] </b>&nbsp;bar",
	[["forwarddelete",""]],
	"<b>foo[]</b> bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<b>foo[]&nbsp;</b> bar",
	[["forwarddelete",""]],
	"<b>foo[]</b> bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<b>foo[]&nbsp;</b>&nbsp;bar",
	[["forwarddelete",""]],
	"<b>foo[]</b> bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<b>foo[] </b> bar",
	[["forwarddelete",""]],
	"<b>foo[]</b>bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<pre>foo []&nbsp;</pre>",
	[["forwarddelete",""]],
	"<pre>foo []</pre>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<pre>[]&nbsp; foo</pre>",
	[["forwarddelete",""]],
	"<pre>{} foo</pre>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<pre>foo[] &nbsp;bar</pre>",
	[["forwarddelete",""]],
	"<pre>foo[]&nbsp;bar</pre>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<pre>foo[]&nbsp; bar</pre>",
	[["forwarddelete",""]],
	"<pre>foo[] bar</pre>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<pre>foo[]  bar</pre>",
	[["forwarddelete",""]],
	"<pre>foo[] bar</pre>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo []&nbsp;</div>",
	[["forwarddelete",""]],
	"<div style=\"white-space:pre\">foo []</div>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre>[]&nbsp; foo</div>",
	[["forwarddelete",""]],
	"<div style=\"white-space:pre\">{} foo</div>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo[] &nbsp;bar</div>",
	[["forwarddelete",""]],
	"<div style=\"white-space:pre\">foo[]&nbsp;bar</div>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo[]&nbsp; bar</div>",
	[["forwarddelete",""]],
	"<div style=\"white-space:pre\">foo[] bar</div>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo[]  bar</div>",
	[["forwarddelete",""]],
	"<div style=\"white-space:pre\">foo[] bar</div>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo []&nbsp;</div>",
	[["forwarddelete",""]],
	"<div style=\"white-space:pre-wrap\">foo []</div>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>[]&nbsp; foo</div>",
	[["forwarddelete",""]],
	"<div style=\"white-space:pre-wrap\">{} foo</div>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo[] &nbsp;bar</div>",
	[["forwarddelete",""]],
	"<div style=\"white-space:pre-wrap\">foo[]&nbsp;bar</div>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo[]&nbsp; bar</div>",
	[["forwarddelete",""]],
	"<div style=\"white-space:pre-wrap\">foo[] bar</div>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo[]  bar</div>",
	[["forwarddelete",""]],
	"<div style=\"white-space:pre-wrap\">foo[] bar</div>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo []&nbsp;</div>",
	[["forwarddelete",""]],
	"<div style=\"white-space:pre-line\">foo&nbsp;[]</div>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>[]&nbsp; foo</div>",
	[["forwarddelete",""]],
	"<div style=\"white-space:pre-line\">{}&nbsp;foo</div>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo[] &nbsp;bar</div>",
	[["forwarddelete",""]],
	"<div style=\"white-space:pre-line\">foo[] bar</div>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo[]&nbsp; bar</div>",
	[["forwarddelete",""]],
	"<div style=\"white-space:pre-line\">foo[] bar</div>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo[]  bar</div>",
	[["forwarddelete",""]],
	"<div style=\"white-space:pre-line\">foo[]bar</div>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo []&nbsp;</div>",
	[["forwarddelete",""]],
	"<div style=\"white-space:nowrap\">foo&nbsp;[]</div>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>[]&nbsp; foo</div>",
	[["forwarddelete",""]],
	"<div style=\"white-space:nowrap\">{}&nbsp;foo</div>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo[] &nbsp;bar</div>",
	[["forwarddelete",""]],
	"<div style=\"white-space:nowrap\">foo[] bar</div>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo[]&nbsp; bar</div>",
	[["forwarddelete",""]],
	"<div style=\"white-space:nowrap\">foo[] bar</div>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo[]  bar</div>",
	[["forwarddelete",""]],
	"<div style=\"white-space:nowrap\">foo[]bar</div>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<table><tr><td>bar</table>baz",
	[["forwarddelete",""]],
	"foo{<table><tbody><tr><td>bar</td></tr></tbody></table>}baz",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo<table><tr><td>bar[]</table>baz",
	[["forwarddelete",""]],
	"foo<table><tbody><tr><td>bar[]</td></tr></tbody></table>baz",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<table><tr><td>bar</table><p>baz",
	[["forwarddelete",""]],
	"<p>foo</p>{<table><tbody><tr><td>bar</td></tr></tbody></table>}<p>baz</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<table><tr><td>foo[]<td>bar</table>",
	[["forwarddelete",""]],
	"<table><tbody><tr><td>foo{}</td><td>bar</td></tr></tbody></table>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<table><tr><td>foo[]<tr><td>bar</table>",
	[["forwarddelete",""]],
	"<table><tbody><tr><td>foo{}</td></tr><tr><td>bar</td></tr></tbody></table>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<br><table><tr><td>bar</table>baz",
	[["forwarddelete",""]],
	"foo{<table><tbody><tr><td>bar</td></tr></tbody></table>}baz",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo<table><tr><td>bar[]<br></table>baz",
	[["forwarddelete",""]],
	"foo<table><tbody><tr><td>bar[]</td></tr></tbody></table>baz",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<br><table><tr><td>bar</table><p>baz",
	[["forwarddelete",""]],
	"<p>foo</p>{<table><tbody><tr><td>bar</td></tr></tbody></table>}<p>baz</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<table><tr><td>bar[]<br></table><p>baz",
	[["forwarddelete",""]],
	"<p>foo</p><table><tbody><tr><td>bar[]</td></tr></tbody></table><p>baz</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<table><tr><td>foo[]<br><td>bar</table>",
	[["forwarddelete",""]],
	"<table><tbody><tr><td>foo{}</td><td>bar</td></tr></tbody></table>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<table><tr><td>foo[]<br><tr><td>bar</table>",
	[["forwarddelete",""]],
	"<table><tbody><tr><td>foo{}</td></tr><tr><td>bar</td></tr></tbody></table>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo<table><tr><td>bar[]</table><br>baz",
	[["forwarddelete",""]],
	"foo<table><tbody><tr><td>bar[]</td></tr></tbody></table><br>baz",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<table><tr><td><hr>bar</table>baz",
	[["forwarddelete",""]],
	"foo{<table><tbody><tr><td><hr>bar</td></tr></tbody></table>}baz",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<table><tr><td>foo[]<td><hr>bar</table>",
	[["forwarddelete",""]],
	"<table><tbody><tr><td>foo{}</td><td><hr>bar</td></tr></tbody></table>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<table><tr><td>foo[]<tr><td><hr>bar</table>",
	[["forwarddelete",""]],
	"<table><tbody><tr><td>foo{}</td></tr><tr><td><hr>bar</td></tr></tbody></table>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<ol><li>bar<li>baz</ol>",
	[["forwarddelete",""]],
	"foo{}bar<ol><li>baz</li></ol>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<br><ol><li>bar<li>baz</ol>",
	[["forwarddelete",""]],
	"foo{}bar<ol><li>baz</li></ol>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]<li>bar</ol>",
	[["forwarddelete",""]],
	"<ol><li>foo{}bar</li></ol>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]<br><li>bar</ol>",
	[["forwarddelete",""]],
	"<ol><li>foo{}bar</li></ol>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]<li>bar<br>baz</ol>",
	[["forwarddelete",""]],
	"<ol><li>foo{}bar<br>baz</li></ol>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li><p>foo[]<li>bar</ol>",
	[["forwarddelete",""]],
	"<ol><li><p>foo{}bar</p></li></ol>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]<li><p>bar</ol>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<ol><li>foo{}bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]<li><p>bar</ol>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<ol><li>foo{}bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li><p>foo[]<li><p>bar</ol>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<ol><li><p>foo{}bar</p></li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li><p>foo[]<li><p>bar</ol>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<ol><li><p>foo{}bar</p></li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]<ul><li>bar</ul></ol>",
	[["forwarddelete",""]],
	"<ol><li>foo{}bar</li></ol>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<ol><ol><li>bar</ol></ol>",
	[["forwarddelete",""]],
	"foo{}bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<div><ol><li>bar</ol></div>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<div><ol><li>bar</ol></div>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<dl><dt>bar<dd>baz</dl>",
	[["forwarddelete",""]],
	"foo{}bar<dl><dd>baz</dd></dl>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<dl><dd>bar</dl>",
	[["forwarddelete",""]],
	"foo{}bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<dl><dt>foo[]<dd>bar</dl>",
	[["forwarddelete",""]],
	"<dl><dt>foo{}bar</dt></dl>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<dl><dt>foo[]<dt>bar<dd>baz</dl>",
	[["forwarddelete",""]],
	"<dl><dt>foo{}bar</dt><dd>baz</dd></dl>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<dl><dt>foo<dd>bar[]<dd>baz</dl>",
	[["forwarddelete",""]],
	"<dl><dt>foo</dt><dd>bar{}baz</dd></dl>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]</ol>bar",
	[["forwarddelete",""]],
	"<ol><li>foo{}bar</li></ol>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]<br></ol>bar",
	[["forwarddelete",""]],
	"<ol><li>foo{}bar</li></ol>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>{}<br></ol>bar",
	[["forwarddelete",""]],
	"<ol><li>{}bar</li></ol>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo<li>{}<br></ol>bar",
	[["forwarddelete",""]],
	"<ol><li>foo</li><li>{}bar</li></ol>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]</ol><p>bar",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<ol><li>foo{}bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]</ol><p>bar",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<ol><li>foo{}bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]<br></ol><p>bar",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<ol><li>foo{}bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]<br></ol><p>bar",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<ol><li>foo{}bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>{}<br></ol><p>bar",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<ol><li>{}bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>{}<br></ol><p>bar",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<ol><li>{}bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo<li>{}<br></ol><p>bar",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<ol><li>foo</li><li>{}bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo<li>{}<br></ol><p>bar",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<ol><li>foo</li><li>{}bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]</ol><br>",
	[["forwarddelete",""]],
	"<ol><li>foo{}</li></ol>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]<br></ol><br>",
	[["forwarddelete",""]],
	"<ol><li>foo{}</li></ol>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>{}<br></ol><br>",
	[["forwarddelete",""]],
	"<ol><li>{}<br></li></ol>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo<li>{}<br></ol><br>",
	[["forwarddelete",""]],
	"<ol><li>foo</li><li>{}<br></li></ol>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]</ol><p><br>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<ol><li>foo{}</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]</ol><p><br>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<ol><li>foo{}</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]<br></ol><p><br>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<ol><li>foo{}</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[]<br></ol><p><br>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<ol><li>foo{}</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>{}<br></ol><p><br>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<ol><li>{}<br></li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>{}<br></ol><p><br>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<ol><li>{}<br></li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo<li>{}<br></ol><p><br>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<ol><li>foo</li><li>{}<br></li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo<li>{}<br></ol><p><br>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<ol><li>foo</li><li>{}<br></li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote>bar</blockquote>",
	[["forwarddelete",""]],
	"foo{}bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote><blockquote>bar</blockquote></blockquote>",
	[["forwarddelete",""]],
	"foo{}bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote><div>bar</div></blockquote>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote><div>bar</div></blockquote>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote style=\"color: blue\">bar</blockquote>",
	[["stylewithcss","true"],["forwarddelete",""]],
	"foo{}<span style=\"color:rgb(0, 0, 255)\">bar</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote style=\"color: blue\">bar</blockquote>",
	[["stylewithcss","false"],["forwarddelete",""]],
	"foo{}<font color=\"#0000ff\">bar</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote><blockquote><p>bar<p>baz</blockquote></blockquote>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"foo{}bar<blockquote><blockquote><p>baz</p></blockquote></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote><blockquote><p>bar<p>baz</blockquote></blockquote>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"foo{}bar<blockquote><blockquote><p>baz</p></blockquote></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote><div><p>bar<p>baz</div></blockquote>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"foo{}bar<blockquote><div><p>baz</p></div></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote><div><p>bar<p>baz</div></blockquote>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"foo{}bar<blockquote><div><p>baz</p></div></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote style=\"color: blue\"><p>bar<p>baz</blockquote>",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["forwarddelete",""]],
	"foo{}<span style=\"color:rgb(0, 0, 255)\">bar</span><blockquote style=\"color:rgb(0, 0, 255)\"><p>baz</p></blockquote>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote style=\"color: blue\"><p>bar<p>baz</blockquote>",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["forwarddelete",""]],
	"foo{}<font color=\"#0000ff\">bar</font><blockquote style=\"color:rgb(0, 0, 255)\"><p>baz</p></blockquote>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote style=\"color: blue\"><p>bar<p>baz</blockquote>",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["forwarddelete",""]],
	"foo{}<span style=\"color:rgb(0, 0, 255)\">bar</span><blockquote style=\"color:rgb(0, 0, 255)\"><p>baz</p></blockquote>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote style=\"color: blue\"><p>bar<p>baz</blockquote>",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["forwarddelete",""]],
	"foo{}<font color=\"#0000ff\">bar</font><blockquote style=\"color:rgb(0, 0, 255)\"><p>baz</p></blockquote>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote><p><b>bar</b><p>baz</blockquote>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"foo{}<b>bar</b><blockquote><p>baz</p></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote><p><b>bar</b><p>baz</blockquote>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"foo{}<b>bar</b><blockquote><p>baz</p></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote><p><strong>bar</strong><p>baz</blockquote>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"foo{}<strong>bar</strong><blockquote><p>baz</p></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote><p><strong>bar</strong><p>baz</blockquote>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"foo{}<strong>bar</strong><blockquote><p>baz</p></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote><p><span>bar</span><p>baz</blockquote>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"foo{}<span>bar</span><blockquote><p>baz</p></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote><p><span>bar</span><p>baz</blockquote>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"foo{}<span>bar</span><blockquote><p>baz</p></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote><ol><li>bar</ol></blockquote><p>extra",
	[["forwarddelete",""]],
	"foo{}bar<p>extra</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<blockquote>bar<ol><li>baz</ol>quz</blockquote><p>extra",
	[["forwarddelete",""]],
	"foo{}bar<blockquote><ol><li>baz</li></ol>quz</blockquote><p>extra</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo<blockquote><ol><li>bar[]</li><ol><li>baz</ol><li>quz</ol></blockquote><p>extra",
	[["forwarddelete",""]],
	"foo<blockquote><ol><li>bar{}baz</li><li>quz</li></ol></blockquote><p>extra</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<span></span>bar",
	[["forwarddelete",""]],
	"foo{}ar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<span><span></span></span>bar",
	[["forwarddelete",""]],
	"foo{}ar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<quasit></quasit>bar",
	[["forwarddelete",""]],
	"foo{}ar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<span></span><br>bar",
	[["forwarddelete",""]],
	"foo{}bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<span>foo[]<span></span></span>bar",
	[["forwarddelete",""]],
	"<span>foo</span>{}ar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<span></span><span>bar</span>",
	[["forwarddelete",""]],
	"foo<span>{}ar</span>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<div><div><p>bar</div></div>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<div><div><p>bar</div></div>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<div><div><p><!--abc-->bar</div></div>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<div><div><p><!--abc-->bar</div></div>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<div><div><!--abc--><p>bar</div></div>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<div><div><!--abc--><p>bar</div></div>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<div><!--abc--><div><p>bar</div></div>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<div><!--abc--><div><p>bar</div></div>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<!--abc--><div><div><p>bar</div></div>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<!--abc--><div><div><p>bar</div></div>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</div></div>bar",
	[["forwarddelete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</div></div><!--abc-->bar",
	[["forwarddelete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</div><!--abc--></div>bar",
	[["forwarddelete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</p><!--abc--></div></div>bar",
	[["forwarddelete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]<!--abc--></div></div>bar",
	[["forwarddelete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</p></div></div><div><div><div>bar</div></div></div>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</p></div></div><div><div><div>bar</div></div></div>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]<!--abc--></p></div></div><div><div><div>bar</div></div></div>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]<!--abc--></p></div></div><div><div><div>bar</div></div></div>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</p><!--abc--></div></div><div><div><div>bar</div></div></div>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</p><!--abc--></div></div><div><div><div>bar</div></div></div>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</p></div><!--abc--></div><div><div><div>bar</div></div></div>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</p></div><!--abc--></div><div><div><div>bar</div></div></div>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</p></div></div><!--abc--><div><div><div>bar</div></div></div>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</p></div></div><!--abc--><div><div><div>bar</div></div></div>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</p></div></div><div><!--abc--><div><div>bar</div></div></div>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</p></div></div><div><!--abc--><div><div>bar</div></div></div>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</p></div></div><div><div><!--abc--><div>bar</div></div></div>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</p></div></div><div><div><!--abc--><div>bar</div></div></div>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</p></div></div><div><div><div><!--abc-->bar</div></div></div>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><div><p>foo[]</p></div></div><div><div><div><!--abc-->bar</div></div></div>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<div><div><p>foo{}bar</p></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo[]<p>bar",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p><span style=\"color:rgb(0, 0, 255)\">foo{}</span>bar</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo[]<p>bar",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p><font color=\"#0000ff\">foo{}</font>bar</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo[]<p>bar",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p><span style=\"color:rgb(0, 0, 255)\">foo{}</span>bar</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo[]<p>bar",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p><font color=\"#0000ff\">foo{}</font>bar</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo[]<p style=color:brown>bar",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p style=\"color:rgb(0, 0, 255)\">foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo[]<p style=color:brown>bar",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p style=\"color:rgb(0, 0, 255)\">foo{}<font color=\"#a52a2a\">bar</font></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo[]<p style=color:brown>bar",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p style=\"color:rgb(0, 0, 255)\">foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo[]<p style=color:brown>bar",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p style=\"color:rgb(0, 0, 255)\">foo{}<font color=\"#a52a2a\">bar</font></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p style=color:brown>bar",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p>foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p style=color:brown>bar",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p>foo{}<font color=\"#a52a2a\">bar</font></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p style=color:brown>bar",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p>foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p style=color:brown>bar",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p>foo{}<font color=\"#a52a2a\">bar</font></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p><font color=blue>foo[]</font><p>bar",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p><font color=\"blue\">foo</font>{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p><font color=blue>foo[]</font><p>bar",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p><font color=\"blue\">foo</font>{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p><font color=blue>foo[]</font><p><font color=brown>bar</font>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p><font color=\"blue\">foo</font>{}<font color=\"brown\">bar</font></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p><font color=blue>foo[]</font><p><font color=brown>bar</font>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p><font color=\"blue\">foo</font>{}<font color=\"brown\">bar</font></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p><font color=brown>bar</font>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p>foo{}<font color=\"brown\">bar</font></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p><font color=brown>bar</font>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p>foo{}<font color=\"brown\">bar</font></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p><span style=color:blue>foo[]</font><p>bar",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p><span style=\"color:rgb(0, 0, 255)\">foo</span>{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p><span style=color:blue>foo[]</font><p>bar",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p><span style=\"color:rgb(0, 0, 255)\">foo</span>{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p><span style=color:blue>foo[]</font><p><span style=color:brown>bar</font>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p><span style=\"color:rgb(0, 0, 255)\">foo</span>{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p><span style=color:blue>foo[]</font><p><span style=color:brown>bar</font>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p><span style=\"color:rgb(0, 0, 255)\">foo</span>{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p><span style=color:brown>bar</font>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p>foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p><span style=color:brown>bar</font>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p>foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=background-color:aqua>foo[]<p>bar",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p style=\"background-color:rgb(0, 255, 255)\">foo{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=background-color:aqua>foo[]<p>bar",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p style=\"background-color:rgb(0, 255, 255)\">foo{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=background-color:aqua>foo[]<p style=background-color:tan>bar",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p style=\"background-color:rgb(0, 255, 255)\">foo{}bar</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=background-color:aqua>foo[]<p style=background-color:tan>bar",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p style=\"background-color:rgb(0, 255, 255)\">foo{}bar</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=background-color:aqua>foo[]<p style=background-color:tan>bar",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p style=\"background-color:rgb(0, 255, 255)\">foo{}bar</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=background-color:aqua>foo[]<p style=background-color:tan>bar",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p style=\"background-color:rgb(0, 255, 255)\">foo{}bar</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p style=background-color:tan>bar",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p>foo{}bar</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p style=background-color:tan>bar",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p>foo{}bar</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p style=background-color:tan>bar",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p>foo{}bar</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p style=background-color:tan>bar",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p>foo{}bar</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p><span style=background-color:aqua>foo[]</font><p>bar",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p><span style=\"background-color:rgb(0, 255, 255)\">foo</span>{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p><span style=background-color:aqua>foo[]</font><p>bar",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p><span style=\"background-color:rgb(0, 255, 255)\">foo</span>{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p><span style=background-color:aqua>foo[]</font><p><span style=background-color:tan>bar</font>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p><span style=\"background-color:rgb(0, 255, 255)\">foo</span>{}<span style=\"background-color:rgb(210, 180, 140)\">bar</span></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p><span style=background-color:aqua>foo[]</font><p><span style=background-color:tan>bar</font>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p><span style=\"background-color:rgb(0, 255, 255)\">foo</span>{}<span style=\"background-color:rgb(210, 180, 140)\">bar</span></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p><span style=background-color:tan>bar</font>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p>foo{}<span style=\"background-color:rgb(210, 180, 140)\">bar</span></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p><span style=background-color:tan>bar</font>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p>foo{}<span style=\"background-color:rgb(210, 180, 140)\">bar</span></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=text-decoration:underline>foo[]<p>bar",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p><span style=\"text-decoration:underline\">foo{}</span>bar</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=text-decoration:underline>foo[]<p>bar",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p><u>foo{}</u>bar</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=text-decoration:underline>foo[]<p>bar",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p><span style=\"text-decoration:underline\">foo{}</span>bar</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=text-decoration:underline>foo[]<p>bar",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p><u>foo{}</u>bar</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=text-decoration:underline>foo[]<p style=text-decoration:line-through>bar",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p><span style=\"text-decoration:underline\">foo{}</span><span style=\"text-decoration:line-through\">bar</span></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=text-decoration:underline>foo[]<p style=text-decoration:line-through>bar",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p><u>foo{}</u><s>bar</s></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=text-decoration:underline>foo[]<p style=text-decoration:line-through>bar",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p><span style=\"text-decoration:underline\">foo{}</span><span style=\"text-decoration:line-through\">bar</span></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=text-decoration:underline>foo[]<p style=text-decoration:line-through>bar",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p><u>foo{}</u><s>bar</s></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p style=text-decoration:line-through>bar",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p>foo{}<span style=\"text-decoration:line-through\">bar</span></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p style=text-decoration:line-through>bar",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p>foo{}<s>bar</s></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p style=text-decoration:line-through>bar",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p>foo{}<span style=\"text-decoration:line-through\">bar</span></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p style=text-decoration:line-through>bar",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p>foo{}<s>bar</s></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p><u>foo[]</u><p>bar",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p><u>foo</u>{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p><u>foo[]</u><p>bar",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p><u>foo</u>{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p><u>foo[]</u><p><s>bar</s>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p><u>foo</u>{}<s>bar</s></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p><u>foo[]</u><p><s>bar</s>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p><u>foo</u>{}<s>bar</s></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p><s>bar</s>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p>foo{}<s>bar</s></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[]<p><s>bar</s>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p>foo{}<s>bar</s></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo[]</p>bar",
	[["stylewithcss","true"],["forwarddelete",""]],
	"<p><span style=\"color:rgb(0, 0, 255)\">foo{}</span>bar</p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo[]</p>bar",
	[["stylewithcss","false"],["forwarddelete",""]],
	"<p><font color=\"#0000ff\">foo{}</font>bar</p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<p style=color:brown>bar",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["forwarddelete",""]],
	"foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<p style=color:brown>bar",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["forwarddelete",""]],
	"foo{}<font color=\"#a52a2a\">bar</font>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<p style=color:brown>bar",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["forwarddelete",""]],
	"foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]<p style=color:brown>bar",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["forwarddelete",""]],
	"foo{}<font color=\"#a52a2a\">bar</font>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<div style=color:blue><p style=color:green>foo[]</div>bar",
	[["stylewithcss","true"],["forwarddelete",""]],
	"<div><p><span style=\"color:rgb(0, 128, 0)\">foo{}</span>bar</p></div>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["<div style=color:blue><p style=color:green>foo[]</div>bar",
	[["stylewithcss","false"],["forwarddelete",""]],
	"<div><p><font color=\"#008000\">foo{}</font>bar</p></div>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forwarddelete":[false,false,"",false,false,""]}],
["<div style=color:blue><p style=color:green>foo[]</div><p style=color:brown>bar",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<div style=\"color:rgb(0, 0, 255)\"><p style=\"color:rgb(0, 128, 0)\">foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p></div>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<div style=color:blue><p style=color:green>foo[]</div><p style=color:brown>bar",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<div style=\"color:rgb(0, 0, 255)\"><p style=\"color:rgb(0, 128, 0)\">foo{}<font color=\"#a52a2a\">bar</font></p></div>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<div style=color:blue><p style=color:green>foo[]</div><p style=color:brown>bar",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<div style=\"color:rgb(0, 0, 255)\"><p style=\"color:rgb(0, 128, 0)\">foo{}<span style=\"color:rgb(165, 42, 42)\">bar</span></p></div>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<div style=color:blue><p style=color:green>foo[]</div><p style=color:brown>bar",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<div style=\"color:rgb(0, 0, 255)\"><p style=\"color:rgb(0, 128, 0)\">foo{}<font color=\"#a52a2a\">bar</font></p></div>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo[]<div style=color:brown><p style=color:green>bar",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p style=\"color:rgb(0, 0, 255)\">foo{}<span style=\"color:rgb(0, 128, 0)\">bar</span></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo[]<div style=color:brown><p style=color:green>bar",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p style=\"color:rgb(0, 0, 255)\">foo{}<font color=\"#008000\">bar</font></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo[]<div style=color:brown><p style=color:green>bar",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p style=\"color:rgb(0, 0, 255)\">foo{}<span style=\"color:rgb(0, 128, 0)\">bar</span></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p style=color:blue>foo[]<div style=color:brown><p style=color:green>bar",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p style=\"color:rgb(0, 0, 255)\">foo{}<font color=\"#008000\">bar</font></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[bar]baz",
	[["forwarddelete",""]],
	"foo[]baz",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar]</span>baz",
	[["stylewithcss","true"],["forwarddelete",""]],
	"<p>foo{}baz</p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar]</span>baz",
	[["stylewithcss","false"],["forwarddelete",""]],
	"<p>foo{}baz</p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar}</span>baz",
	[["stylewithcss","true"],["forwarddelete",""]],
	"<p>foo{}baz</p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar}</span>baz",
	[["stylewithcss","false"],["forwarddelete",""]],
	"<p>foo{}baz</p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo{<span style=color:#aBcDeF>bar</span>}baz",
	[["stylewithcss","true"],["forwarddelete",""]],
	"<p>foo{}baz</p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo{<span style=color:#aBcDeF>bar</span>}baz",
	[["stylewithcss","false"],["forwarddelete",""]],
	"<p>foo{}baz</p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forwarddelete":[false,false,"",false,false,""]}],
["<p>[foo<span style=color:#aBcDeF>bar]</span>baz",
	[["stylewithcss","true"],["forwarddelete",""]],
	"<p>{}baz</p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["<p>[foo<span style=color:#aBcDeF>bar]</span>baz",
	[["stylewithcss","false"],["forwarddelete",""]],
	"<p>{}baz</p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forwarddelete":[false,false,"",false,false,""]}],
["<p>{foo<span style=color:#aBcDeF>bar}</span>baz",
	[["stylewithcss","true"],["forwarddelete",""]],
	"<p>{}baz</p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["<p>{foo<span style=color:#aBcDeF>bar}</span>baz",
	[["stylewithcss","false"],["forwarddelete",""]],
	"<p>{}baz</p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span>baz]",
	[["stylewithcss","true"],["forwarddelete",""]],
	"<p>foo{}</p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span>baz]",
	[["stylewithcss","false"],["forwarddelete",""]],
	"<p>foo{}</p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar</span>baz}",
	[["stylewithcss","true"],["forwarddelete",""]],
	"<p>foo{}</p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar</span>baz}",
	[["stylewithcss","false"],["forwarddelete",""]],
	"<p>foo{}</p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span><span style=color:#fEdCbA>baz]</span>quz",
	[["stylewithcss","true"],["forwarddelete",""]],
	"<p>foo{}quz</p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span><span style=color:#fEdCbA>baz]</span>quz",
	[["stylewithcss","false"],["forwarddelete",""]],
	"<p>foo{}quz</p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forwarddelete":[false,false,"",false,false,""]}],
["foo<b>[bar]</b>baz",
	[["stylewithcss","true"],["forwarddelete",""]],
	"foo{}baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["foo<b>[bar]</b>baz",
	[["stylewithcss","false"],["forwarddelete",""]],
	"foo{}baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forwarddelete":[false,false,"",false,false,""]}],
["foo<b>{bar}</b>baz",
	[["stylewithcss","true"],["forwarddelete",""]],
	"foo{}baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["foo<b>{bar}</b>baz",
	[["stylewithcss","false"],["forwarddelete",""]],
	"foo{}baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forwarddelete":[false,false,"",false,false,""]}],
["foo{<b>bar</b>}baz",
	[["stylewithcss","true"],["forwarddelete",""]],
	"foo{}baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["foo{<b>bar</b>}baz",
	[["stylewithcss","false"],["forwarddelete",""]],
	"foo{}baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"forwarddelete":[false,false,"",false,false,""]}],
["foo<span>[bar]</span>baz",
	[["forwarddelete",""]],
	"foo{}baz",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo<span>{bar}</span>baz",
	[["forwarddelete",""]],
	"foo{}baz",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo{<span>bar</span>}baz",
	[["forwarddelete",""]],
	"foo{}baz",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<b>foo[bar</b><i>baz]quz</i>",
	[["forwarddelete",""]],
	"<b>foo[]</b><i>quz</i>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo</p><p>[bar]</p><p>baz</p>",
	[["forwarddelete",""]],
	"<p>foo</p><p>{}<br></p><p>baz</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo</p><p>{bar}</p><p>baz</p>",
	[["forwarddelete",""]],
	"<p>foo</p><p>{}<br></p><p>baz</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo</p><p>{bar</p>}<p>baz</p>",
	[["forwarddelete",""]],
	"<p>foo</p><p>{}<br></p><p>baz</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo</p>{<p>bar}</p><p>baz</p>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p>foo</p>{}<br><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo</p>{<p>bar}</p><p>baz</p>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p>foo</p>{}<br><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo</p>{<p>bar</p>}<p>baz</p>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p>foo</p>{}<p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo</p>{<p>bar</p>}<p>baz</p>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p>foo</p>{}<p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[bar<p>baz]quz",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p>foo{}quz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[bar<p>baz]quz",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p>foo{}quz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[bar<div>baz]quz</div>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p>foo{}quz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[bar<div>baz]quz</div>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p>foo{}quz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[bar<h1>baz]quz</h1>",
	[["forwarddelete",""]],
	"<p>foo{}quz</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<div>foo[bar</div><p>baz]quz",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<div>foo{}quz</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<div>foo[bar</div><p>baz]quz",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<div>foo{}quz</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<blockquote>foo[bar</blockquote><pre>baz]quz</pre>",
	[["forwarddelete",""]],
	"<blockquote>foo{}quz</blockquote>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<p><b>foo[bar</b><p>baz]quz",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p><b>foo</b>{}quz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p><b>foo[bar</b><p>baz]quz",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p><b>foo</b>{}quz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><p>foo[bar</div><p>baz]quz",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<div><p>foo{}quz</p></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><p>foo[bar</div><p>baz]quz",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<div><p>foo{}quz</p></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[bar<blockquote><p>baz]quz<p>qoz</blockquote",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p>foo{}quz</p><blockquote><p>qoz</p></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[bar<blockquote><p>baz]quz<p>qoz</blockquote",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p>foo{}quz</p><blockquote><p>qoz</p></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[bar<p style=color:blue>baz]quz",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p>foo{}<span style=\"color:rgb(0, 0, 255)\">quz</span></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[bar<p style=color:blue>baz]quz",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p>foo{}<font color=\"#0000ff\">quz</font></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[bar<p style=color:blue>baz]quz",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p>foo{}<span style=\"color:rgb(0, 0, 255)\">quz</span></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[bar<p style=color:blue>baz]quz",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p>foo{}<font color=\"#0000ff\">quz</font></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[bar<p><b>baz]quz</b>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p>foo{}<b>quz</b></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[bar<p><b>baz]quz</b>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p>foo{}<b>quz</b></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><p>foo<p>[bar<p>baz]</div>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<div><p>foo</p><p>{}<br></p></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><p>foo<p>[bar<p>baz]</div>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<div><p>foo</p><p>{}<br></p></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[<br>]bar",
	[["forwarddelete",""]],
	"foo{}bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[</p><p>]bar</p>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p>foo{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[</p><p>]bar</p>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p>foo{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[</p><p>]bar<br>baz</p>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p>foo{}bar<br>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[</p><p>]bar<br>baz</p>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p>foo{}bar<br>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[<p>]bar</p>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[<p>]bar</p>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{<p>}bar</p>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{<p>}bar</p>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[<p>]bar<br>baz</p>",
	[["forwarddelete",""]],
	"foo{}bar<p>baz</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[<p>]bar</p>baz",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"foo{}bar<br>baz",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[<p>]bar</p>baz",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"foo{}bar<br>baz",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{<p>bar</p>}baz",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"foo{}baz",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{<p>bar</p>}baz",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"foo{}baz",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo<p>{bar</p>}baz",
	[["forwarddelete",""]],
	"foo<p>{}baz</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo{<p>bar}</p>baz",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"foo{}<br>baz",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo{<p>bar}</p>baz",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"foo{}<br>baz",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[</p>]bar",
	[["forwarddelete",""]],
	"<p>foo{}bar</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo{</p>}bar",
	[["forwarddelete",""]],
	"<p>foo{}bar</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[</p>]bar<br>baz",
	[["forwarddelete",""]],
	"<p>foo{}bar</p>baz",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo[</p>]bar<p>baz</p>",
	[["forwarddelete",""]],
	"<p>foo{}bar</p><p>baz</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[<div><p>]bar</div>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[<div><p>]bar</div>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<div><p>foo[</p></div>]bar",
	[["forwarddelete",""]],
	"<div><p>foo{}bar</p></div>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[<div><p>]bar</p>baz</div>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"foo{}bar<div>baz</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[<div><p>]bar</p>baz</div>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"foo{}bar<div>baz</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[<div>]bar<p>baz</p></div>",
	[["forwarddelete",""]],
	"foo{}bar<div><p>baz</p></div>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<div><p>foo</p>bar[</div>]baz",
	[["forwarddelete",""]],
	"<div><p>foo</p>bar{}baz</div>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<div>foo<p>bar[</p></div>]baz",
	[["forwarddelete",""]],
	"<div>foo<p>bar{}baz</p></div>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<br>{</p>]bar",
	[["forwarddelete",""]],
	"<p>foo{}bar</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<br><br>{</p>]bar",
	[["forwarddelete",""]],
	"<p>foo<br>{}bar</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo<br>{<p>]bar</p>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo<br>{<p>]bar</p>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"foo{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["foo<br><br>{<p>]bar</p>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"foo<br>{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["foo<br><br>{<p>]bar</p>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"foo<br>{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<br>{</p><p>}bar</p>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p>foo{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<br>{</p><p>}bar</p>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p>foo{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<br><br>{</p><p>}bar</p>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p>foo<br>{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<br><br>{</p><p>}bar</p>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p>foo<br>{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<table><tbody><tr><th>foo<th>[bar]<th>baz<tr><td>quz<td>qoz<td>qiz</table>",
	[["forwarddelete",""]],
	"<table><tbody><tr><th>foo</th><th>{}<br></th><th>baz</th></tr><tr><td>quz</td><td>qoz</td><td>qiz</td></tr></tbody></table>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<table><tbody><tr><th>foo<th>ba[r<th>b]az<tr><td>quz<td>qoz<td>qiz</table>",
	[["forwarddelete",""]],
	"<table><tbody><tr><th>foo</th><th>ba[]</th><th>az</th></tr><tr><td>quz</td><td>qoz</td><td>qiz</td></tr></tbody></table>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<table><tbody><tr><th>fo[o<th>bar<th>b]az<tr><td>quz<td>qoz<td>qiz</table>",
	[["forwarddelete",""]],
	"<table><tbody><tr><th>fo[]</th><th><br></th><th>az</th></tr><tr><td>quz</td><td>qoz</td><td>qiz</td></tr></tbody></table>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<table><tbody><tr><th>foo<th>bar<th>ba[z<tr><td>q]uz<td>qoz<td>qiz</table>",
	[["forwarddelete",""]],
	"<table><tbody><tr><th>foo</th><th>bar</th><th>ba[]</th></tr><tr><td>uz</td><td>qoz</td><td>qiz</td></tr></tbody></table>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<table><tbody><tr><th>[foo<th>bar<th>baz]<tr><td>quz<td>qoz<td>qiz</table>",
	[["forwarddelete",""]],
	"<table><tbody><tr><th>{}<br></th><th><br></th><th><br></th></tr><tr><td>quz</td><td>qoz</td><td>qiz</td></tr></tbody></table>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<table><tbody><tr><th>[foo<th>bar<th>baz<tr><td>quz<td>qoz<td>qiz]</table>",
	[["forwarddelete",""]],
	"<table><tbody><tr><th>{}<br></th><th><br></th><th><br></th></tr><tr><td><br></td><td><br></td><td><br></td></tr></tbody></table>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["{<table><tbody><tr><th>foo<th>bar<th>baz<tr><td>quz<td>qoz<td>qiz</table>}",
	[["forwarddelete",""]],
	"{}<br>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<table><tbody><tr><td>foo<td>ba[r<tr><td>baz<td>quz<tr><td>q]oz<td>qiz</table>",
	[["forwarddelete",""]],
	"<table><tbody><tr><td>foo</td><td>ba[]</td></tr><tr><td><br></td><td><br></td></tr><tr><td>oz</td><td>qiz</td></tr></tbody></table>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<p>fo[o<table><tr><td>b]ar</table><p>baz",
	[["forwarddelete",""]],
	"<p>fo[]</p><table><tbody><tr><td>ar</td></tr></tbody></table><p>baz</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<table><tr><td>ba[r</table><p>b]az",
	[["forwarddelete",""]],
	"<p>foo</p><table><tbody><tr><td>ba[]</td></tr></tbody></table><p>az</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<p>fo[o<table><tr><td>bar</table><p>b]az",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p>fo{}az</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>fo[o<table><tr><td>bar</table><p>b]az",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p>fo{}az</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<ol><li>ba[r<li>b]az</ol><p>quz",
	[["forwarddelete",""]],
	"<p>foo</p><ol><li>ba{}az</li></ol><p>quz</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<ol><li>bar<li>[baz]</ol><p>quz",
	[["forwarddelete",""]],
	"<p>foo</p><ol><li>bar</li><li>{}<br></li></ol><p>quz</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<p>fo[o<ol><li>b]ar<li>baz</ol><p>quz",
	[["forwarddelete",""]],
	"<p>fo{}ar</p><ol><li>baz</li></ol><p>quz</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<ol><li>bar<li>ba[z</ol><p>q]uz",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p>foo</p><ol><li>bar</li><li>ba{}uz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>foo<ol><li>bar<li>ba[z</ol><p>q]uz",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p>foo</p><ol><li>bar</li><li>ba{}uz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>fo[o<ol><li>bar<li>b]az</ol><p>quz",
	[["forwarddelete",""]],
	"<p>fo{}az</p><p>quz</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<p>fo[o<ol><li>bar<li>baz</ol><p>q]uz",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<p>fo{}uz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<p>fo[o<ol><li>bar<li>baz</ol><p>q]uz",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<p>fo{}uz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>fo[o</ol><ol><li>b]ar</ol>",
	[["forwarddelete",""]],
	"<ol><li>fo{}ar</li></ol>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>fo[o</ol><ul><li>b]ar</ul>",
	[["forwarddelete",""]],
	"<ol><li>fo{}ar</li></ol>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[<ol><li>]bar</ol>",
	[["forwarddelete",""]],
	"foo{}bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[<li>]bar</ol>",
	[["forwarddelete",""]],
	"<ol><li>foo{}bar</li></ol>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[<dl><dt>]bar<dd>baz</dl>",
	[["forwarddelete",""]],
	"foo{}bar<dl><dd>baz</dd></dl>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[<dl><dd>]bar</dl>",
	[["forwarddelete",""]],
	"foo{}bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<dl><dt>foo[<dd>]bar</dl>",
	[["forwarddelete",""]],
	"<dl><dt>foo{}bar</dt></dl>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<dl><dt>foo[<dt>]bar<dd>baz</dl>",
	[["forwarddelete",""]],
	"<dl><dt>foo{}bar</dt><dd>baz</dd></dl>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<dl><dt>foo<dd>bar[<dd>]baz</dl>",
	[["forwarddelete",""]],
	"<dl><dt>foo</dt><dd>bar{}baz</dd></dl>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol>{}<br><ol><li>bar</ol>",
	[["forwarddelete",""]],
	"<ol><li>foo</li></ol>{}bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><p>{}<br></p><ol><li>bar</ol>",
	[["forwarddelete",""]],
	"<ol><li>foo</li></ol><p>{}bar</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li><p>foo</ol><p>{}<br></p><ol><li>bar</ol>",
	[["forwarddelete",""]],
	"<ol><li><p>foo</p></li></ol><p>{}bar</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ol id=a><li>foo</ol>{}<br><ol><li>bar</ol>",
	[["forwarddelete",""]],
	"<ol id=\"a\"><li>foo</li></ol>{}bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol>{}<br><ol id=b><li>bar</ol>",
	[["forwarddelete",""]],
	"<ol><li>foo</li></ol>{}bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ol id=a><li>foo</ol>{}<br><ol id=b><li>bar</ol>",
	[["forwarddelete",""]],
	"<ol id=\"a\"><li>foo</li></ol>{}bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ol class=a><li>foo</ol>{}<br><ol class=b><li>bar</ol>",
	[["forwarddelete",""]],
	"<ol class=\"a\"><li>foo</li></ol>{}bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ol><ol><li>foo</ol><li>{}<br><ol><li>bar</ol></ol>",
	[["forwarddelete",""]],
	"<ol><ol><li>foo</li></ol><li>{}bar</li></ol>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ol><ol><li>foo</ol><li>{}<br></li><ol><li>bar</ol></ol>",
	[["forwarddelete",""]],
	"<ol><ol><li>foo</li></ol><li>{}bar</li></ol>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[</ol>bar]<ol><li>baz</ol>",
	[["forwarddelete",""]],
	"<ol><li>foo{}</li><li>baz</li></ol>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[</ol><p>bar]<ol><li>baz</ol>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<ol><li>foo{}</li><li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[</ol><p>bar]<ol><li>baz</ol>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<ol><li>foo{}</li><li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li><p>foo[</ol><p>bar]<ol><li>baz</ol>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<ol><li><p>foo{}</p></li><li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li><p>foo[</ol><p>bar]<ol><li>baz</ol>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<ol><li><p>foo{}</p></li><li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>fo[]o</ol><ol><li>bar</ol>",
	[["forwarddelete",""]],
	"<ol><li>fo[]</li></ol><ol><li>bar</li></ol>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol>[bar<ol><li>]baz</ol>",
	[["forwarddelete",""]],
	"<ol><li>foo</li></ol>{}baz",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><p>[bar<ol><li>]baz</ol>",
	[["forwarddelete",""]],
	"<ol><li>foo</li></ol><p>{}baz</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><p>[bar<ol><li><p>]baz</ol>",
	[["defaultparagraphseparator","div"],["forwarddelete",""]],
	"<ol><li>foo</li></ol><p>{}baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><p>[bar<ol><li><p>]baz</ol>",
	[["defaultparagraphseparator","p"],["forwarddelete",""]],
	"<ol><li>foo</li></ol><p>{}baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><ol><li>[]bar</ol>",
	[["forwarddelete",""]],
	"<ol><li>foo</li></ol><ol><li>{}ar</li></ol>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ol><ol><li>foo[</ol><li>bar</ol>baz]<ol><li>quz</ol>",
	[["forwarddelete",""]],
	"<ol><ol><li>foo{}</li></ol><li>quz</li></ol>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ul><li>foo</ul>{}<br><ul><li>bar</ul>",
	[["forwarddelete",""]],
	"<ul><li>foo</li></ul>{}bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ul><li>foo</ul><p>{}<br></p><ul><li>bar</ul>",
	[["forwarddelete",""]],
	"<ul><li>foo</li></ul><p>{}bar</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo[<li>bar]</ol><ol><li>baz</ol><ol><li>quz</ol>",
	[["forwarddelete",""]],
	"<ol><li>foo{}</li><li>baz</li><li>quz</li></ol>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol>{}<br><ul><li>bar</ul>",
	[["forwarddelete",""]],
	"<ol><li>foo</li></ol>{}bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ol><li>foo</ol><p>{}<br></p><ul><li>bar</ul>",
	[["forwarddelete",""]],
	"<ol><li>foo</li></ol><p>{}bar</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ul><li>foo</ul>{}<br><ol><li>bar</ol>",
	[["forwarddelete",""]],
	"<ul><li>foo</li></ul>{}bar",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<ul><li>foo</ul><p>{}<br></p><ol><li>bar</ol>",
	[["forwarddelete",""]],
	"<ul><li>foo</li></ul><p>{}bar</p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<p><b>[foo]</b>",
	[["forwarddelete",""]],
	"<p><b>{}<br></b></p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<p><quasit>[foo]</quasit>",
	[["forwarddelete",""]],
	"<p><quasit>{}<br></quasit></p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<p><b><i>[foo]</i></b>",
	[["forwarddelete",""]],
	"<p><b><i>{}<br></i></b></p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<p><b>{foo}</b>",
	[["forwarddelete",""]],
	"<p><b>{}<br></b></p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<p>{<b>foo</b>}",
	[["forwarddelete",""]],
	"<p><b>{}<br></b></p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<p><b>[]f</b>",
	[["forwarddelete",""]],
	"<p><b>{}<br></b></p>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<b>[foo]</b>",
	[["forwarddelete",""]],
	"<b>{}<br></b>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["<div><b>[foo]</b></div>",
	[["forwarddelete",""]],
	"<div><b>{}<br></b></div>",
	[true],
	{"forwarddelete":[false,false,"",false,false,""]}],
["foo[]bar",
	[["hilitecolor","#00FFFF"]],
	"foo[]bar",
	[true],
	{"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<p>[foo</p> <p>bar]</p>",
	[["stylewithcss","true"],["hilitecolor","#00FFFF"]],
	"<p><span style=\"background-color:rgb(0, 255, 255)\">[foo</span></p> <p><span style=\"background-color:rgb(0, 255, 255)\">bar]</span></p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<p>[foo</p> <p>bar]</p>",
	[["stylewithcss","false"],["hilitecolor","#00FFFF"]],
	"<p><span style=\"background-color:rgb(0, 255, 255)\">[foo</span></p> <p><span style=\"background-color:rgb(0, 255, 255)\">bar]</span></p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<span>[foo</span> <span>bar]</span>",
	[["stylewithcss","true"],["hilitecolor","#00FFFF"]],
	"<span style=\"background-color:rgb(0, 255, 255)\"><span>[foo</span> <span>bar]</span></span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<span>[foo</span> <span>bar]</span>",
	[["stylewithcss","false"],["hilitecolor","#00FFFF"]],
	"<span style=\"background-color:rgb(0, 255, 255)\"><span>[foo</span> <span>bar]</span></span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
	[["stylewithcss","true"],["hilitecolor","#00FFFF"]],
	"<p><span style=\"background-color:rgb(0, 255, 255)\">[foo</span></p><p> <span style=\"background-color:rgb(0, 255, 255)\"><span>bar</span></span> </p><p><span style=\"background-color:rgb(0, 255, 255)\">baz]</span></p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
	[["stylewithcss","false"],["hilitecolor","#00FFFF"]],
	"<p><span style=\"background-color:rgb(0, 255, 255)\">[foo</span></p><p> <span style=\"background-color:rgb(0, 255, 255)\"><span>bar</span></span> </p><p><span style=\"background-color:rgb(0, 255, 255)\">baz]</span></p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<p>[foo<p><br><p>bar]",
	[["stylewithcss","true"],["hilitecolor","#00FFFF"]],
	"<p><span style=\"background-color:rgb(0, 255, 255)\">[foo</span></p><p><span style=\"background-color:rgb(0, 255, 255)\"><br></span></p><p><span style=\"background-color:rgb(0, 255, 255)\">bar]</span></p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<p>[foo<p><br><p>bar]",
	[["stylewithcss","false"],["hilitecolor","#00FFFF"]],
	"<p><span style=\"background-color:rgb(0, 255, 255)\">[foo</span></p><p><span style=\"background-color:rgb(0, 255, 255)\"><br></span></p><p><span style=\"background-color:rgb(0, 255, 255)\">bar]</span></p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<b>foo[]bar</b>",
	[["hilitecolor","#00FFFF"]],
	"<b>foo[]bar</b>",
	[true],
	{"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<i>foo[]bar</i>",
	[["hilitecolor","#00FFFF"]],
	"<i>foo[]bar</i>",
	[true],
	{"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<span>foo</span>{}<span>bar</span>",
	[["hilitecolor","#00FFFF"]],
	"<span>foo</span>{}<span>bar</span>",
	[true],
	{"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<span>foo[</span><span>]bar</span>",
	[["hilitecolor","#00FFFF"]],
	"<span>foo[</span><span>]bar</span>",
	[true],
	{"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["foo[bar]baz",
	[["stylewithcss","true"],["hilitecolor","#00FFFF"]],
	"foo<span style=\"background-color:rgb(0, 255, 255)\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["foo[bar]baz",
	[["stylewithcss","false"],["hilitecolor","#00FFFF"]],
	"foo<span style=\"background-color:rgb(0, 255, 255)\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["foo[bar<b>baz]qoz</b>quz",
	[["stylewithcss","true"],["hilitecolor","#00FFFF"]],
	"foo<span style=\"background-color:rgb(0, 255, 255)\">[bar</span><b><span style=\"background-color:rgb(0, 255, 255)\">baz]</span>qoz</b>quz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["foo[bar<b>baz]qoz</b>quz",
	[["stylewithcss","false"],["hilitecolor","#00FFFF"]],
	"foo<span style=\"background-color:rgb(0, 255, 255)\">[bar</span><b><span style=\"background-color:rgb(0, 255, 255)\">baz]</span>qoz</b>quz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["foo[bar<i>baz]qoz</i>quz",
	[["stylewithcss","true"],["hilitecolor","#00FFFF"]],
	"foo<span style=\"background-color:rgb(0, 255, 255)\">[bar</span><i><span style=\"background-color:rgb(0, 255, 255)\">baz]</span>qoz</i>quz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["foo[bar<i>baz]qoz</i>quz",
	[["stylewithcss","false"],["hilitecolor","#00FFFF"]],
	"foo<span style=\"background-color:rgb(0, 255, 255)\">[bar</span><i><span style=\"background-color:rgb(0, 255, 255)\">baz]</span>qoz</i>quz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["{<p><p> <p>foo</p>}",
	[["stylewithcss","true"],["hilitecolor","#00FFFF"]],
	"{<p></p><p> </p><p><span style=\"background-color:rgb(0, 255, 255)\">foo</span></p>}",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["{<p><p> <p>foo</p>}",
	[["stylewithcss","false"],["hilitecolor","#00FFFF"]],
	"{<p></p><p> </p><p><span style=\"background-color:rgb(0, 255, 255)\">foo</span></p>}",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
	[["stylewithcss","true"],["hilitecolor","#00FFFF"]],
	"<table><tbody><tr><td>foo</td><td>b<span style=\"background-color:rgb(0, 255, 255)\">[a]</span>r</td><td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
	[["stylewithcss","false"],["hilitecolor","#00FFFF"]],
	"<table><tbody><tr><td>foo</td><td>b<span style=\"background-color:rgb(0, 255, 255)\">[a]</span>r</td><td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","true"],["hilitecolor","#00FFFF"]],
	"<table><tbody><tr><td>foo</td>{<td><span style=\"background-color:rgb(0, 255, 255)\">bar</span></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","false"],["hilitecolor","#00FFFF"]],
	"<table><tbody><tr><td>foo</td>{<td><span style=\"background-color:rgb(0, 255, 255)\">bar</span></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","true"],["hilitecolor","#00FFFF"]],
	"<table><tbody><tr>{<td><span style=\"background-color:rgb(0, 255, 255)\">foo</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">bar</span></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","false"],["hilitecolor","#00FFFF"]],
	"<table><tbody><tr>{<td><span style=\"background-color:rgb(0, 255, 255)\">foo</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">bar</span></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","true"],["hilitecolor","#00FFFF"]],
	"<table><tbody>{<tr><td><span style=\"background-color:rgb(0, 255, 255)\">foo</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">bar</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">baz</span></td></tr>}</tbody></table>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","false"],["hilitecolor","#00FFFF"]],
	"<table><tbody>{<tr><td><span style=\"background-color:rgb(0, 255, 255)\">foo</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">bar</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">baz</span></td></tr>}</tbody></table>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","true"],["hilitecolor","#00FFFF"]],
	"<table>{<tbody><tr><td><span style=\"background-color:rgb(0, 255, 255)\">foo</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">bar</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">baz</span></td></tr></tbody>}</table>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","false"],["hilitecolor","#00FFFF"]],
	"<table>{<tbody><tr><td><span style=\"background-color:rgb(0, 255, 255)\">foo</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">bar</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">baz</span></td></tr></tbody>}</table>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
	[["stylewithcss","true"],["hilitecolor","#00FFFF"]],
	"{<table><tbody><tr><td><span style=\"background-color:rgb(0, 255, 255)\">foo</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">bar</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">baz</span></td></tr></tbody></table>}",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
	[["stylewithcss","false"],["hilitecolor","#00FFFF"]],
	"{<table><tbody><tr><td><span style=\"background-color:rgb(0, 255, 255)\">foo</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">bar</span></td><td><span style=\"background-color:rgb(0, 255, 255)\">baz</span></td></tr></tbody></table>}",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<p style=\"background-color: rgb(0, 255, 255)\">foo[bar]baz</p>",
	[["hilitecolor","#00FFFF"]],
	"<p style=\"background-color:rgb(0, 255, 255)\">foo[bar]baz</p>",
	[true],
	{"hilitecolor":[false,false,"rgb(0, 255, 255)",false,false,"rgb(0, 255, 255)"]}],
["<p style=\"background-color: #00ffff\">foo[bar]baz</p>",
	[["hilitecolor","#00FFFF"]],
	"<p style=\"background-color:rgb(0, 255, 255)\">foo[bar]baz</p>",
	[true],
	{"hilitecolor":[false,false,"rgb(0, 255, 255)",false,false,"rgb(0, 255, 255)"]}],
["<p style=\"background-color: aqua\">foo[bar]baz</p>",
	[["hilitecolor","#00FFFF"]],
	"<p style=\"background-color:rgb(0, 255, 255)\">foo[bar]baz</p>",
	[true],
	{"hilitecolor":[false,false,"rgb(0, 255, 255)",false,false,"rgb(0, 255, 255)"]}],
["{<p style=\"background-color: aqua\">foo</p><p>bar</p>}",
	[["stylewithcss","true"],["hilitecolor","#00FFFF"]],
	"{<p style=\"background-color:rgb(0, 255, 255)\">foo</p><p><span style=\"background-color:rgb(0, 255, 255)\">bar</span></p>}",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[true,false,"rgb(0, 255, 255)",false,false,"rgb(0, 255, 255)"]}],
["{<p style=\"background-color: aqua\">foo</p><p>bar</p>}",
	[["stylewithcss","false"],["hilitecolor","#00FFFF"]],
	"{<p style=\"background-color:rgb(0, 255, 255)\">foo</p><p><span style=\"background-color:rgb(0, 255, 255)\">bar</span></p>}",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[true,false,"rgb(0, 255, 255)",false,false,"rgb(0, 255, 255)"]}],
["<span style=\"background-color: aqua\">foo<span style=\"background-color: tan\">[bar]</span>baz</span>",
	[["stylewithcss","true"],["hilitecolor","#00FFFF"]],
	"<span style=\"background-color:rgb(0, 255, 255)\">foo[bar]baz</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=\"background-color: aqua\">foo<span style=\"background-color: tan\">[bar]</span>baz</span>",
	[["stylewithcss","false"],["hilitecolor","#00FFFF"]],
	"<span style=\"background-color:rgb(0, 255, 255)\">foo[bar]baz</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=\"background-color: #00ffff\">foo<span style=\"background-color: tan\">[bar]</span>baz</span>",
	[["stylewithcss","true"],["hilitecolor","#00FFFF"]],
	"<span style=\"background-color:rgb(0, 255, 255)\">foo[bar]baz</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=\"background-color: #00ffff\">foo<span style=\"background-color: tan\">[bar]</span>baz</span>",
	[["stylewithcss","false"],["hilitecolor","#00FFFF"]],
	"<span style=\"background-color:rgb(0, 255, 255)\">foo[bar]baz</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=\"background-color: #0ff\">foo<span style=\"background-color: tan\">[bar]</span>baz</span>",
	[["stylewithcss","true"],["hilitecolor","#00FFFF"]],
	"<span style=\"background-color:rgb(0, 255, 255)\">foo[bar]baz</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=\"background-color: #0ff\">foo<span style=\"background-color: tan\">[bar]</span>baz</span>",
	[["stylewithcss","false"],["hilitecolor","#00FFFF"]],
	"<span style=\"background-color:rgb(0, 255, 255)\">foo[bar]baz</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=\"background-color: rgb(0, 255, 255)\">foo<span style=\"background-color: tan\">[bar]</span>baz</span>",
	[["stylewithcss","true"],["hilitecolor","#00FFFF"]],
	"<span style=\"background-color:rgb(0, 255, 255)\">foo[bar]baz</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=\"background-color: rgb(0, 255, 255)\">foo<span style=\"background-color: tan\">[bar]</span>baz</span>",
	[["stylewithcss","false"],["hilitecolor","#00FFFF"]],
	"<span style=\"background-color:rgb(0, 255, 255)\">foo[bar]baz</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=\"background-color: aqua\">foo<span style=\"background-color: tan\">b[ar]</span>baz</span>",
	[["hilitecolor","#00FFFF"]],
	"<span style=\"background-color:rgb(0, 255, 255)\">foo<span style=\"background-color:rgb(210, 180, 140)\">b</span>[ar]baz</span>",
	[true],
	{"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<p style=\"background-color: aqua\">foo<span style=\"background-color: tan\">b[ar]</span>baz</p>",
	[["hilitecolor","#00FFFF"]],
	"<p style=\"background-color:rgb(0, 255, 255)\">foo<span style=\"background-color:rgb(210, 180, 140)\">b</span>[ar]baz</p>",
	[true],
	{"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<div style=\"background-color: aqua\"><p style=\"background-color: tan\">b[ar]</p></div>",
	[["stylewithcss","true"],["hilitecolor","#00FFFF"]],
	"<div style=\"background-color:rgb(0, 255, 255)\"><p style=\"background-color:rgb(210, 180, 140)\">b<span style=\"background-color:rgb(0, 255, 255)\">[ar]</span></p></div>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<div style=\"background-color: aqua\"><p style=\"background-color: tan\">b[ar]</p></div>",
	[["stylewithcss","false"],["hilitecolor","#00FFFF"]],
	"<div style=\"background-color:rgb(0, 255, 255)\"><p style=\"background-color:rgb(210, 180, 140)\">b<span style=\"background-color:rgb(0, 255, 255)\">[ar]</span></p></div>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=\"display: block; background-color: aqua\"><span style=\"display: block; background-color: tan\">b[ar]</span></span>",
	[["stylewithcss","true"],["hilitecolor","#00FFFF"]],
	"<span style=\"display:block; background-color:rgb(0, 255, 255)\"><span style=\"display:block; background-color:rgb(210, 180, 140)\">b<span style=\"background-color:rgb(0, 255, 255)\">[ar]</span></span></span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=\"display: block; background-color: aqua\"><span style=\"display: block; background-color: tan\">b[ar]</span></span>",
	[["stylewithcss","false"],["hilitecolor","#00FFFF"]],
	"<span style=\"display:block; background-color:rgb(0, 255, 255)\"><span style=\"display:block; background-color:rgb(210, 180, 140)\">b<span style=\"background-color:rgb(0, 255, 255)\">[ar]</span></span></span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["fo[o<span style=background-color:tan>b]ar</span>baz",
	[["stylewithcss","true"],["hilitecolor","#00FFFF"]],
	"fo<span style=\"background-color:rgb(0, 255, 255)\">[o</span><span style=\"background-color:rgb(210, 180, 140)\"><span style=\"background-color:rgb(0, 255, 255)\">b]</span>ar</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[true,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["fo[o<span style=background-color:tan>b]ar</span>baz",
	[["stylewithcss","false"],["hilitecolor","#00FFFF"]],
	"fo<span style=\"background-color:rgb(0, 255, 255)\">[o</span><span style=\"background-color:rgb(210, 180, 140)\"><span style=\"background-color:rgb(0, 255, 255)\">b]</span>ar</span>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[true,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["foo<span style=background-color:tan>ba[r</span>b]az",
	[["stylewithcss","true"],["hilitecolor","#00FFFF"]],
	"foo<span style=\"background-color:rgb(210, 180, 140)\">ba<span style=\"background-color:rgb(0, 255, 255)\">[r</span></span><span style=\"background-color:rgb(0, 255, 255)\">b]</span>az",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[true,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["foo<span style=background-color:tan>ba[r</span>b]az",
	[["stylewithcss","false"],["hilitecolor","#00FFFF"]],
	"foo<span style=\"background-color:rgb(210, 180, 140)\">ba<span style=\"background-color:rgb(0, 255, 255)\">[r</span></span><span style=\"background-color:rgb(0, 255, 255)\">b]</span>az",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[true,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["fo[o<span style=background-color:tan>bar</span>b]az",
	[["hilitecolor","#00FFFF"]],
	"fo<span style=\"background-color:rgb(0, 255, 255)\">[obarb]</span>az",
	[true],
	{"hilitecolor":[true,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["foo[<span style=background-color:tan>b]ar</span>baz",
	[["stylewithcss","true"],["hilitecolor","#00FFFF"]],
	"foo[<span style=\"background-color:rgb(210, 180, 140)\"><span style=\"background-color:rgb(0, 255, 255)\">b]</span>ar</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["foo[<span style=background-color:tan>b]ar</span>baz",
	[["stylewithcss","false"],["hilitecolor","#00FFFF"]],
	"foo[<span style=\"background-color:rgb(210, 180, 140)\"><span style=\"background-color:rgb(0, 255, 255)\">b]</span>ar</span>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["foo<span style=background-color:tan>ba[r</span>]baz",
	[["stylewithcss","true"],["hilitecolor","#00FFFF"]],
	"foo<span style=\"background-color:rgb(210, 180, 140)\">ba<span style=\"background-color:rgb(0, 255, 255)\">[r</span></span>]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["foo<span style=background-color:tan>ba[r</span>]baz",
	[["stylewithcss","false"],["hilitecolor","#00FFFF"]],
	"foo<span style=\"background-color:rgb(210, 180, 140)\">ba<span style=\"background-color:rgb(0, 255, 255)\">[r</span></span>]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["foo[<span style=background-color:tan>bar</span>]baz",
	[["hilitecolor","#00FFFF"]],
	"foo[<span style=\"background-color:rgb(0, 255, 255)\">bar</span>]baz",
	[true],
	{"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["foo<span style=background-color:tan>[bar]</span>baz",
	[["hilitecolor","#00FFFF"]],
	"foo<span style=\"background-color:rgb(0, 255, 255)\">[bar]</span>baz",
	[true],
	{"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["foo{<span style=background-color:tan>bar</span>}baz",
	[["hilitecolor","#00FFFF"]],
	"foo{<span style=\"background-color:rgb(0, 255, 255)\">bar}</span>baz",
	[true],
	{"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=background-color:tan>fo[o</span><span style=background-color:yellow>b]ar</span>",
	[["stylewithcss","true"],["hilitecolor","#00FFFF"]],
	"<span style=\"background-color:rgb(210, 180, 140)\">fo<span style=\"background-color:rgb(0, 255, 255)\">[o</span></span><span style=\"background-color:rgb(255, 255, 0)\"><span style=\"background-color:rgb(0, 255, 255)\">b]</span>ar</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[true,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=background-color:tan>fo[o</span><span style=background-color:yellow>b]ar</span>",
	[["stylewithcss","false"],["hilitecolor","#00FFFF"]],
	"<span style=\"background-color:rgb(210, 180, 140)\">fo<span style=\"background-color:rgb(0, 255, 255)\">[o</span></span><span style=\"background-color:rgb(255, 255, 0)\"><span style=\"background-color:rgb(0, 255, 255)\">b]</span>ar</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[true,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=background-color:tan>fo[o</span><span style=background-color:tan>b]ar</span>",
	[["stylewithcss","true"],["hilitecolor","#00FFFF"]],
	"<span style=\"background-color:rgb(210, 180, 140)\">fo<span style=\"background-color:rgb(0, 255, 255)\">[o</span></span><span style=\"background-color:rgb(210, 180, 140)\"><span style=\"background-color:rgb(0, 255, 255)\">b]</span>ar</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=background-color:tan>fo[o</span><span style=background-color:tan>b]ar</span>",
	[["stylewithcss","false"],["hilitecolor","#00FFFF"]],
	"<span style=\"background-color:rgb(210, 180, 140)\">fo<span style=\"background-color:rgb(0, 255, 255)\">[o</span></span><span style=\"background-color:rgb(210, 180, 140)\"><span style=\"background-color:rgb(0, 255, 255)\">b]</span>ar</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=background-color:tan>fo[o<span style=background-color:transparent>b]ar</span></span>",
	[["stylewithcss","true"],["hilitecolor","#00FFFF"]],
	"<span style=\"background-color:rgb(210, 180, 140)\">fo<span style=\"background-color:rgb(0, 255, 255)\">[o</span><span style=\"background-color:rgba(0, 0, 0, 0)\"><span style=\"background-color:rgb(0, 255, 255)\">b]</span>ar</span></span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<span style=background-color:tan>fo[o<span style=background-color:transparent>b]ar</span></span>",
	[["stylewithcss","false"],["hilitecolor","#00FFFF"]],
	"<span style=\"background-color:rgb(210, 180, 140)\">fo<span style=\"background-color:rgb(0, 255, 255)\">[o</span><span style=\"background-color:rgba(0, 0, 0, 0)\"><span style=\"background-color:rgb(0, 255, 255)\">b]</span>ar</span></span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgb(210, 180, 140)",false,false,"rgb(0, 255, 255)"]}],
["<font size=6>[foo]</font>",
	[["stylewithcss","true"],["hilitecolor","#00FFFF"]],
	"<span style=\"background-color:rgb(0, 255, 255)\"><font size=\"6\">[foo]</font></span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<font size=6>[foo]</font>",
	[["stylewithcss","false"],["hilitecolor","#00FFFF"]],
	"<span style=\"background-color:rgb(0, 255, 255)\"><font size=\"6\">[foo]</font></span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<span style=font-size:xx-large>[foo]</span>",
	[["stylewithcss","true"],["hilitecolor","#00FFFF"]],
	"<span style=\"background-color:rgb(0, 255, 255)\"><span style=\"font-size:xx-large\">[foo]</span></span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<span style=font-size:xx-large>[foo]</span>",
	[["stylewithcss","false"],["hilitecolor","#00FFFF"]],
	"<span style=\"background-color:rgb(0, 255, 255)\"><span style=\"font-size:xx-large\">[foo]</span></span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<font size=6>foo[bar]baz</font>",
	[["stylewithcss","true"],["hilitecolor","#00FFFF"]],
	"<font size=\"6\">foo<span style=\"background-color:rgb(0, 255, 255)\">[bar]</span>baz</font>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<font size=6>foo[bar]baz</font>",
	[["stylewithcss","false"],["hilitecolor","#00FFFF"]],
	"<font size=\"6\">foo<span style=\"background-color:rgb(0, 255, 255)\">[bar]</span>baz</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<span style=font-size:xx-large>foo[bar]baz</span>",
	[["stylewithcss","true"],["hilitecolor","#00FFFF"]],
	"<span style=\"font-size:xx-large\">foo<span style=\"background-color:rgb(0, 255, 255)\">[bar]</span>baz</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["<span style=font-size:xx-large>foo[bar]baz</span>",
	[["stylewithcss","false"],["hilitecolor","#00FFFF"]],
	"<span style=\"font-size:xx-large\">foo<span style=\"background-color:rgb(0, 255, 255)\">[bar]</span>baz</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["[foo<font size=6>bar</font>baz]",
	[["stylewithcss","true"],["hilitecolor","#00FFFF"]],
	"<span style=\"background-color:rgb(0, 255, 255)\">[foo<font size=\"6\">bar</font>baz]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["[foo<font size=6>bar</font>baz]",
	[["stylewithcss","false"],["hilitecolor","#00FFFF"]],
	"<span style=\"background-color:rgb(0, 255, 255)\">[foo<font size=\"6\">bar</font>baz]</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["[foo<span style=font-size:xx-large>bar</span>baz]",
	[["stylewithcss","true"],["hilitecolor","#00FFFF"]],
	"<span style=\"background-color:rgb(0, 255, 255)\">[foo<span style=\"font-size:xx-large\">bar</span>baz]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["[foo<span style=font-size:xx-large>bar</span>baz]",
	[["stylewithcss","false"],["hilitecolor","#00FFFF"]],
	"<span style=\"background-color:rgb(0, 255, 255)\">[foo<span style=\"font-size:xx-large\">bar</span>baz]</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"]}],
["foo[]bar<p>extra",
	[["indent",""]],
	"<blockquote>foo[]bar</blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<span>foo</span>{}<span>bar</span><p>extra",
	[["indent",""]],
	"<blockquote><span>foo</span>{}<span>bar</span></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<span>foo[</span><span>]bar</span><p>extra",
	[["indent",""]],
	"<blockquote><span>foo[</span><span>]bar</span></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["foo[bar]baz<p>extra",
	[["indent",""]],
	"<blockquote>foo[bar]baz</blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p dir=rtl>פו[בר]בז<p dir=rtl>נוםף",
	[["indent",""]],
	"<blockquote><p dir=\"rtl\">פו[בר]בז</p></blockquote><p dir=\"rtl\">נוםף</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p dir=rtl>פו[ברבז<p>Foobar]baz<p>Extra",
	[["indent",""]],
	"<blockquote><p dir=\"rtl\">פו[ברבז</p><p>Foobar]baz</p></blockquote><p>Extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p>Foo[barbaz<p dir=rtl>פובר]בז<p>Extra",
	[["indent",""]],
	"<blockquote><p>Foo[barbaz</p><p dir=\"rtl\">פובר]בז</p></blockquote><p>Extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<div><p>Foo[barbaz<p dir=rtl>פובר]בז</div><p>Extra",
	[["indent",""]],
	"<blockquote><div><p>Foo[barbaz</p><p dir=\"rtl\">פובר]בז</p></div></blockquote><p>Extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["foo]bar[baz<p>extra",
	[["indent",""]],
	"<blockquote>foo[bar]baz</blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["{<p><p> <p>foo</p>}<p>extra",
	[["indent",""]],
	"<blockquote>{<p></p><p> </p><p>foo</p>}</blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["foo[bar<i>baz]qoz</i>quz<p>extra",
	[["indent",""]],
	"<blockquote>foo[bar<i>baz]qoz</i>quz</blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["[]foo<p>extra",
	[["indent",""]],
	"<blockquote>[]foo</blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["foo[]<p>extra",
	[["indent",""]],
	"<blockquote>foo[]</blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p>[]foo<p>extra",
	[["indent",""]],
	"<blockquote><p>[]foo</p></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p>foo[]<p>extra",
	[["indent",""]],
	"<blockquote><p>foo[]</p></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p>{}<br>foo</p><p>extra",
	[["indent",""]],
	"<blockquote>{}<br></blockquote><p>foo</p><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p>foo<br>{}</p><p>extra",
	[["indent",""]],
	"<blockquote><p>foo{}</p></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<span>{}<br>foo</span>bar<p>extra",
	[["indent",""]],
	"<blockquote>{}<br></blockquote><span>foo</span>bar<p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<span>foo<br>{}</span>bar<p>extra",
	[["indent",""]],
	"<span>foo{}</span><blockquote>bar</blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p>foo</p>{}<p>bar</p>",
	[["indent",""]],
	"<p>foo</p>{}<p>bar</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table><p>extra",
	[["indent",""]],
	"<table><tbody><tr><td>foo</td><td><blockquote>b[a]r</blockquote></td><td>baz</td></tr></tbody></table><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table><p>extra",
	[["indent",""]],
	"<table><tbody><tr><td>foo</td>{<td><blockquote>bar</blockquote></td>}<td>baz</td></tr></tbody></table><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table><p>extra",
	[["indent",""]],
	"<table><tbody><tr>{<td><blockquote>foo</blockquote></td><td><blockquote>bar</blockquote></td>}<td>baz</td></tr></tbody></table><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table><p>extra",
	[["indent",""]],
	"<blockquote><table><tbody>{<tr><td>foo</td><td>bar</td><td>baz</td></tr>}</tbody></table></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table><p>extra",
	[["indent",""]],
	"<blockquote><table>{<tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody>}</table></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}<p>extra",
	[["indent",""]],
	"<blockquote>{<table><tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody></table>}</blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p>foo[bar]</p><p>baz</p><p>extra",
	[["indent",""]],
	"<blockquote><p>foo[bar]</p></blockquote><p>baz</p><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p>[foobar</p><p>ba]z</p><p>extra",
	[["indent",""]],
	"<blockquote><p>[foobar</p><p>ba]z</p></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["foo[bar]<br>baz<p>extra",
	[["indent",""]],
	"<blockquote>foo[bar]</blockquote>baz<p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["foo[bar]<br><br><br><br>baz<p>extra",
	[["indent",""]],
	"<blockquote>foo[bar]</blockquote><br><br><br>baz<p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["foobar<br>[ba]z<p>extra",
	[["indent",""]],
	"foobar<blockquote>[ba]z</blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["foobar<br><br><br><br>[ba]z<p>extra",
	[["indent",""]],
	"foobar<br><br><br><br><blockquote>[ba]z</blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["foo[bar<br>ba]z<p>extra",
	[["indent",""]],
	"<blockquote>foo[bar<br>ba]z</blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<div>foo<p>[bar]</p>baz</div><p>extra",
	[["indent",""]],
	"<div>foo<blockquote><p>[bar]</p></blockquote>baz</div><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<blockquote><p>foo[bar]</p><p>baz</p></blockquote><p>extra",
	[["indent",""]],
	"<blockquote><blockquote><p>foo[bar]</p></blockquote><p>baz</p></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<blockquote><p>foo[bar</p><p>b]az</p></blockquote><p>extra",
	[["indent",""]],
	"<blockquote><blockquote><p>foo[bar</p><p>b]az</p></blockquote></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<blockquote><p>foo[bar]</p></blockquote><p>baz</p><p>extra",
	[["indent",""]],
	"<blockquote><blockquote><p>foo[bar]</p></blockquote></blockquote><p>baz</p><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<blockquote><p>foo[bar</p></blockquote><p>b]az</p><p>extra",
	[["indent",""]],
	"<blockquote><blockquote><p>foo[bar</p></blockquote><p>b]az</p></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p>[foo]<blockquote><p>bar</blockquote><p>extra",
	[["indent",""]],
	"<blockquote><p>[foo]</p><p>bar</p></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p>[foo<blockquote><p>b]ar</blockquote><p>extra",
	[["indent",""]],
	"<blockquote><p>[foo</p><blockquote><p>b]ar</p></blockquote></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p>foo<blockquote><p>bar</blockquote><p>[baz]<p>extra",
	[["indent",""]],
	"<p>foo</p><blockquote><p>bar</p><p>[baz]</p></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p>foo<blockquote><p>[bar</blockquote><p>baz]<p>extra",
	[["indent",""]],
	"<p>foo</p><blockquote><blockquote><p>[bar</p></blockquote><p>baz]</p></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p>[foo<blockquote><p>bar</blockquote><p>baz]<p>extra",
	[["indent",""]],
	"<blockquote><p>[foo</p><blockquote><p>bar</p></blockquote><p>baz]</p></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<blockquote><p>foo</blockquote><p>[bar]<blockquote><p>baz</blockquote><p>extra",
	[["indent",""]],
	"<blockquote><p>foo</p><p>[bar]</p><p>baz</p></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<blockquote>foo[bar]<br>baz</blockquote><p>extra",
	[["indent",""]],
	"<blockquote><blockquote>foo[bar]</blockquote>baz</blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<blockquote>foo[bar<br>b]az</blockquote><p>extra",
	[["indent",""]],
	"<blockquote><blockquote>foo[bar<br>b]az</blockquote></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<blockquote>foo[bar]</blockquote>baz<p>extra",
	[["indent",""]],
	"<blockquote><blockquote>foo[bar]</blockquote></blockquote>baz<p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<blockquote>foo[bar</blockquote>b]az<p>extra",
	[["indent",""]],
	"<blockquote><blockquote>foo[bar</blockquote>b]az</blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["[foo]<blockquote>bar</blockquote><p>extra",
	[["indent",""]],
	"<blockquote>[foo]<br>bar</blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["[foo<blockquote>b]ar</blockquote><p>extra",
	[["indent",""]],
	"<blockquote>[foo<blockquote>b]ar</blockquote></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["foo<blockquote>bar</blockquote>[baz]<p>extra",
	[["indent",""]],
	"foo<blockquote>bar<br>[baz]</blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["[foo<blockquote>bar</blockquote>baz]<p>extra",
	[["indent",""]],
	"<blockquote>[foo<blockquote>bar</blockquote>baz]</blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<blockquote>foo</blockquote>[bar]<blockquote>baz</blockquote><p>extra",
	[["indent",""]],
	"<blockquote>foo<br>[bar]<br>baz</blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<blockquote style=\"margin-right: 0\" dir=\"ltr\"><p>foo[bar]</p><p>baz</p></blockquote><p>extra",
	[["indent",""]],
	"<blockquote style=\"margin-right:0\" dir=\"ltr\"><blockquote><p>foo[bar]</p></blockquote><p>baz</p></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<blockquote style=\"margin-right: 0\" dir=\"ltr\"><p>foo[bar</p><p>b]az</p></blockquote><p>extra",
	[["indent",""]],
	"<blockquote><blockquote style=\"margin-right:0\" dir=\"ltr\"><p>foo[bar</p><p>b]az</p></blockquote></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<blockquote style=\"margin-right: 0\" dir=\"ltr\"><p>foo[bar]</p></blockquote><p>baz</p><p>extra",
	[["indent",""]],
	"<blockquote><blockquote style=\"margin-right:0\" dir=\"ltr\"><p>foo[bar]</p></blockquote></blockquote><p>baz</p><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<blockquote style=\"margin-right: 0\" dir=\"ltr\"><p>foo[bar</p></blockquote><p>b]az</p><p>extra",
	[["indent",""]],
	"<blockquote><blockquote style=\"margin-right:0\" dir=\"ltr\"><p>foo[bar</p></blockquote><p>b]az</p></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p>[foo]<blockquote style=\"margin-right: 0\" dir=\"ltr\"><p>bar</blockquote><p>extra",
	[["indent",""]],
	"<blockquote style=\"margin-right:0\" dir=\"ltr\"><p>[foo]</p><p>bar</p></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p>[foo<blockquote style=\"margin-right: 0\" dir=\"ltr\"><p>b]ar</blockquote><p>extra",
	[["indent",""]],
	"<blockquote><p>[foo</p><blockquote style=\"margin-right:0\" dir=\"ltr\"><p>b]ar</p></blockquote></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p>foo<blockquote style=\"margin-right: 0\" dir=\"ltr\"><p>bar</blockquote><p>[baz]<p>extra",
	[["indent",""]],
	"<p>foo</p><blockquote style=\"margin-right:0\" dir=\"ltr\"><p>bar</p><p>[baz]</p></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p>foo<blockquote style=\"margin-right: 0\" dir=\"ltr\"><p>[bar</blockquote><p>baz]<p>extra",
	[["indent",""]],
	"<p>foo</p><blockquote><blockquote style=\"margin-right:0\" dir=\"ltr\"><p>[bar</p></blockquote><p>baz]</p></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p>[foo<blockquote style=\"margin-right: 0\" dir=\"ltr\"><p>bar</blockquote><p>baz]<p>extra",
	[["indent",""]],
	"<blockquote><p>[foo</p><blockquote style=\"margin-right:0\" dir=\"ltr\"><p>bar</p></blockquote><p>baz]</p></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<blockquote style=\"margin-right: 0\" dir=\"ltr\"><p>foo</blockquote><p>[bar]<blockquote style=\"margin-right: 0\" dir=\"ltr\"><p>baz</blockquote><p>extra",
	[["stylewithcss","true"],["indent",""]],
	"<blockquote style=\"margin-right:0\" dir=\"ltr\"><p>foo</p><p>[bar]</p><p>baz</p></blockquote><p>extra</p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"indent":[false,false,"",false,false,""]}],
["<blockquote style=\"margin-right: 0\" dir=\"ltr\"><p>foo</blockquote><p>[bar]<blockquote style=\"margin-right: 0\" dir=\"ltr\"><p>baz</blockquote><p>extra",
	[["stylewithcss","false"],["indent",""]],
	"<blockquote style=\"margin-right:0\" dir=\"ltr\"><p>foo</p><p>[bar]</p><p>baz</p></blockquote><p>extra</p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"indent":[false,false,"",false,false,""]}],
["<p style=\"margin-left: 40px\">foo[bar]</p><p style=\"margin-left: 40px\">baz</p><p>extra",
	[["indent",""]],
	"<blockquote><p style=\"margin-left:40px\">foo[bar]</p></blockquote><p style=\"margin-left:40px\">baz</p><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p style=\"margin-left: 40px\">foo[bar</p><p style=\"margin-left: 40px\">b]az</p><p>extra",
	[["indent",""]],
	"<blockquote><p style=\"margin-left:40px\">foo[bar</p><p style=\"margin-left:40px\">b]az</p></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p style=\"margin-left: 40px\">foo[bar]</p><p>baz</p><p>extra",
	[["indent",""]],
	"<blockquote><p style=\"margin-left:40px\">foo[bar]</p></blockquote><p>baz</p><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p style=\"margin-left: 40px\">foo[bar</p><p>b]az</p><p>extra",
	[["indent",""]],
	"<blockquote><p style=\"margin-left:40px\">foo[bar</p><p>b]az</p></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p>[foo]<p style=\"margin-left: 40px\">bar<p>extra",
	[["indent",""]],
	"<blockquote><p>[foo]</p></blockquote><p style=\"margin-left:40px\">bar</p><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p>[foo<p style=\"margin-left: 40px\">b]ar<p>extra",
	[["indent",""]],
	"<blockquote><p>[foo</p><p style=\"margin-left:40px\">b]ar</p></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p>foo<p style=\"margin-left: 40px\">bar<p>[baz]<p>extra",
	[["indent",""]],
	"<p>foo</p><p style=\"margin-left:40px\">bar</p><blockquote><p>[baz]</p></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p>foo<p style=\"margin-left: 40px\">[bar<p>baz]<p>extra",
	[["indent",""]],
	"<p>foo</p><blockquote><p style=\"margin-left:40px\">[bar</p><p>baz]</p></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p>[foo<p style=\"margin-left: 40px\">bar<p>baz]<p>extra",
	[["indent",""]],
	"<blockquote><p>[foo</p><p style=\"margin-left:40px\">bar</p><p>baz]</p></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p style=\"margin-left: 40px\">foo<p>[bar]<p style=\"margin-left: 40px\">baz<p>extra",
	[["indent",""]],
	"<p style=\"margin-left:40px\">foo</p><blockquote><p>[bar]</p></blockquote><p style=\"margin-left:40px\">baz</p><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px\"><p>foo[bar]</p><p>baz</p></blockquote><p>extra",
	[["indent",""]],
	"<blockquote class=\"webkit-indent-blockquote\" style=\"margin:0 0 0 40px; border:none; padding:0px\"><blockquote><p>foo[bar]</p></blockquote><p>baz</p></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px\"><p>foo[bar</p><p>b]az</p></blockquote><p>extra",
	[["indent",""]],
	"<blockquote><blockquote class=\"webkit-indent-blockquote\" style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>foo[bar</p><p>b]az</p></blockquote></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px\"><p>foo[bar]</p></blockquote><p>baz</p><p>extra",
	[["indent",""]],
	"<blockquote><blockquote class=\"webkit-indent-blockquote\" style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>foo[bar]</p></blockquote></blockquote><p>baz</p><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px\"><p>foo[bar</p></blockquote><p>b]az</p><p>extra",
	[["indent",""]],
	"<blockquote><blockquote class=\"webkit-indent-blockquote\" style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>foo[bar</p></blockquote><p>b]az</p></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p>[foo]<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px\"><p>bar</blockquote><p>extra",
	[["indent",""]],
	"<blockquote><p>[foo]</p></blockquote><blockquote class=\"webkit-indent-blockquote\" style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>bar</p></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p>[foo<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px\"><p>b]ar</blockquote><p>extra",
	[["indent",""]],
	"<blockquote><p>[foo</p><blockquote class=\"webkit-indent-blockquote\" style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>b]ar</p></blockquote></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p>foo<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px\"><p>bar</blockquote><p>[baz]<p>extra",
	[["indent",""]],
	"<p>foo</p><blockquote class=\"webkit-indent-blockquote\" style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>bar</p></blockquote><blockquote><p>[baz]</p></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p>foo<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px\"><p>[bar</blockquote><p>baz]<p>extra",
	[["indent",""]],
	"<p>foo</p><blockquote><blockquote class=\"webkit-indent-blockquote\" style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>[bar</p></blockquote><p>baz]</p></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p>[foo<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px\"><p>bar</blockquote><p>baz]<p>extra",
	[["indent",""]],
	"<blockquote><p>[foo</p><blockquote class=\"webkit-indent-blockquote\" style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>bar</p></blockquote><p>baz]</p></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px\"><p>foo</blockquote><p>[bar]<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px\"><p>baz</blockquote><p>extra",
	[["indent",""]],
	"<blockquote class=\"webkit-indent-blockquote\" style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>foo</p></blockquote><blockquote><p>[bar]</p></blockquote><blockquote class=\"webkit-indent-blockquote\" style=\"margin:0 0 0 40px; border:none; padding:0px\"><p>baz</p></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<blockquote>f[oo<blockquote>b]ar</blockquote></blockquote><p>extra",
	[["indent",""]],
	"<blockquote><blockquote>f[oo<blockquote>b]ar</blockquote></blockquote></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<li>[bar]<li>baz</ol>",
	[["indent",""]],
	"<ol><li>foo</li><ol><li>[bar]</li></ol><li>baz</li></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol data-start=1 data-end=2><li>foo<li>bar<li>baz</ol>",
	[["indent",""]],
	"<ol><li>foo</li><ol>{<li>bar</li>}</ol><li>baz</li></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>foo</ol>[bar]",
	[["indent",""]],
	"<ol><li>foo</li></ol><blockquote>[bar]</blockquote>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>[foo]<br>bar<li>baz</ol>",
	[["indent",""]],
	"<ol><ol><li>[foo]<br>bar</li></ol><li>baz</li></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<br>[bar]<li>baz</ol>",
	[["indent",""]],
	"<ol><ol><li>foo<br>[bar]</li></ol><li>baz</li></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li><div>[foo]</div>bar<li>baz</ol>",
	[["indent",""]],
	"<ol><ol><li><div>[foo]</div>bar</li></ol><li>baz</li></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<ol><li>[bar]<li>baz</ol><li>quz</ol>",
	[["indent",""]],
	"<ol><li>foo</li><ol><ol><li>[bar]</li></ol><li>baz</li></ol><li>quz</li></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<ol><li>bar<li>[baz]</ol><li>quz</ol>",
	[["indent",""]],
	"<ol><li>foo</li><ol><li>bar</li><ol><li>[baz]</li></ol></ol><li>quz</li></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol><li>[bar]<li>baz</ol><li>quz</ol>",
	[["indent",""]],
	"<ol><li>foo</li><ol><ol><li>[bar]</li></ol><li>baz</li></ol><li>quz</li></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol data-start=0 data-end=1><li>bar<li>baz</ol><li>quz</ol>",
	[["indent",""]],
	"<ol><li>foo</li><ol><ol>{<li>bar</li>}</ol><li>baz</li></ol><li>quz</li></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol><li>bar<li>[baz]</ol><li>quz</ol>",
	[["indent",""]],
	"<ol><li>foo</li><ol><li>bar</li><ol><li>[baz]</li></ol></ol><li>quz</li></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol data-start=1 data-end=2><li>bar<li>baz</ol><li>quz</ol>",
	[["indent",""]],
	"<ol><li>foo</li><ol><li>bar</li><ol>{<li>baz</li>}</ol></ol><li>quz</li></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<ol><li>b[a]r</ol><li>baz</ol>",
	[["indent",""]],
	"<ol><li>foo</li><ol><ol><li>b[a]r</li></ol></ol><li>baz</li></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol><li>b[a]r</ol><li>baz</ol>",
	[["indent",""]],
	"<ol><li>foo</li><ol><ol><li>b[a]r</li></ol></ol><li>baz</li></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>foo{<ol><li>bar</ol>}<li>baz</ol>",
	[["indent",""]],
	"<ol><li>foo</li><ol>{<ol><li>bar</li></ol>}</ol><li>baz</li></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>foo</li>{<ol><li>bar</ol>}<li>baz</ol>",
	[["indent",""]],
	"<ol><li>foo</li><ol>{<ol><li>bar</li></ol>}</ol><li>baz</li></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>[foo]<ol><li>bar</ol><li>baz</ol>",
	[["indent",""]],
	"<ol><ol><li>[foo]</li><li>bar</li></ol><li>baz</li></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>[foo]</li><ol><li>bar</ol><li>baz</ol>",
	[["indent",""]],
	"<ol><ol><li>[foo]</li><li>bar</li></ol><li>baz</li></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<li>[bar]<ol><li>baz</ol><li>quz</ol>",
	[["indent",""]],
	"<ol><li>foo</li><ol><li>[bar]</li><li>baz</li></ol><li>quz</li></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<li>[bar]</li><ol><li>baz</ol><li>quz</ol>",
	[["indent",""]],
	"<ol><li>foo</li><ol><li>[bar]</li><li>baz</li></ol><li>quz</li></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<ol><li>bar<li>baz</ol><li>[quz]</ol>",
	[["indent",""]],
	"<ol><li>foo</li><ol><li>bar</li><li>baz</li><li>[quz]</li></ol></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol><li>bar<li>baz</ol><li>[quz]</ol>",
	[["indent",""]],
	"<ol><li>foo</li><ol><li>bar</li><li>baz</li><li>[quz]</li></ol></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><ol id=u1><li id=i1>foo</ol><li id=i2>[bar]</li><ol id=u3><li id=i3>baz</ol></ol>",
	[["indent",""]],
	"<ol><ol id=\"u1\"><li id=\"i1\">foo</li><li id=\"i2\">[bar]</li><li id=\"i3\">baz</li></ol></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><ol><li id=i1>foo</ol><li id=i2>[bar]</li><ol id=u3><li id=i3>baz</ol></ol>",
	[["indent",""]],
	"<ol><ol><li id=\"i1\">foo</li><li id=\"i2\">[bar]</li><li id=\"i3\">baz</li></ol></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><ol id=u1><li id=i1>foo</ol><li id=i2>[bar]</li><ol><li id=i3>baz</ol></ol>",
	[["indent",""]],
	"<ol><ol id=\"u1\"><li id=\"i1\">foo</li><li id=\"i2\">[bar]</li><li id=\"i3\">baz</li></ol></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li id=i2>[bar]</li><ol id=u3><li id=i3>baz</ol></ol>",
	[["indent",""]],
	"<ol><ol id=\"u3\"><li id=\"i2\">[bar]</li><li id=\"i3\">baz</li></ol></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><ol id=u1><li id=i1>foo</ol><li id=i2>[bar]</ol>",
	[["indent",""]],
	"<ol><ol id=\"u1\"><li id=\"i1\">foo</li><li id=\"i2\">[bar]</li></ol></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<li>b[ar<li>baz]</ol>",
	[["indent",""]],
	"<ol><li>foo</li><ol><li>b[ar</li><li>baz]</li></ol></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>[foo<ol><li>bar]</ol><li>baz</ol>",
	[["indent",""]],
	"<ol><ol><li>[foo</li><ol><li>bar]</li></ol></ol><li>baz</li></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>[foo</li><ol><li>bar]</ol><li>baz</ol>",
	[["indent",""]],
	"<ol><ol><li>[foo</li><ol><li>bar]</li></ol></ol><li>baz</li></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<ol><li>b[ar</ol><li>b]az</ol>",
	[["indent",""]],
	"<ol><li>foo</li><ol><ol><li>b[ar</li></ol><li>b]az</li></ol></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol><li>b[ar</ol><li>b]az</ol>",
	[["indent",""]],
	"<ol><li>foo</li><ol><ol><li>b[ar</li></ol><li>b]az</li></ol></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>[foo<ol><li>bar</ol><li>baz]</ol><p>extra",
	[["indent",""]],
	"<blockquote><ol><li>[foo</li><ol><li>bar</li></ol><li>baz]</li></ol></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>[foo</li><ol><li>bar</ol><li>baz]</ol><p>extra",
	[["indent",""]],
	"<blockquote><ol><li>[foo</li><ol><li>bar</li></ol><li>baz]</li></ol></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>[foo]<ol><li>bar</ol>baz</ol>",
	[["indent",""]],
	"<ol><ol><li>[foo]</li><li>bar</li></ol><li>baz</li></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<ol><li>[bar]</ol>baz</ol>",
	[["indent",""]],
	"<ol><li>foo</li><ol><ol><li>[bar]</li></ol></ol><li>baz</li></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<ol><li>bar</ol>[baz]</ol>",
	[["indent",""]],
	"<ol><li>foo</li><ol><li>bar</li><li>[baz]</li></ol></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>[foo<ol><li>bar]</ol>baz</ol>",
	[["indent",""]],
	"<ol><ol><li>[foo</li><ol><li>bar]</li></ol></ol><li>baz</li></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["foo<!--bar-->[baz]<p>extra",
	[["indent",""]],
	"<blockquote>foo<!--bar-->[baz]</blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["[foo]<!--bar-->baz<p>extra",
	[["indent",""]],
	"<blockquote>[foo]<!--bar-->baz</blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p>foo<!--bar-->{}<p>extra",
	[["indent",""]],
	"<blockquote><p>foo<!--bar-->{}</p></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p>{}<!--foo-->bar<p>extra",
	[["indent",""]],
	"<blockquote><p>{}<!--foo-->bar</p></blockquote><p>extra</p>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<blockquote><p>foo</blockquote> <p>[bar]",
	[["indent",""]],
	"<blockquote><p>foo</p> <p>[bar]</p></blockquote>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<p>[foo]</p> <blockquote><p>bar</blockquote>",
	[["indent",""]],
	"<blockquote><p>[foo]</p> <p>bar</p></blockquote>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<blockquote><p>foo</blockquote> <p>[bar]</p> <blockquote><p>baz</blockquote>",
	[["indent",""]],
	"<blockquote><p>foo</p> <p>[bar]</p> <p>baz</p></blockquote>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol><li>bar</li> </ol><li>[baz]</ol>",
	[["indent",""]],
	"<ol><li>foo</li><ol><li>bar</li> <li>[baz]</li></ol></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol><li>bar</li></ol> <li>[baz]</ol>",
	[["indent",""]],
	"<ol><li>foo</li><ol><li>bar</li> <li>[baz]</li></ol></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol><li>bar</li> </ol> <li>[baz]</ol>",
	[["indent",""]],
	"<ol><li>foo</li><ol><li>bar</li>  <li>[baz]</li></ol></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<ol><li>bar</li> </ol></li><li>[baz]</ol>",
	[["indent",""]],
	"<ol><li>foo</li><ol><li>bar</li> <li>[baz]</li></ol></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<ol><li>bar</li></ol></li> <li>[baz]</ol>",
	[["indent",""]],
	"<ol><li>foo</li><ol><li>bar</li> <li>[baz]</li></ol></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<ol><li>bar</li> </ol></li> <li>[baz]</ol>",
	[["indent",""]],
	"<ol><li>foo</li><ol><li>bar</li>  <li>[baz]</li></ol></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<li>[bar]</li> <ol><li>baz</ol></ol>",
	[["indent",""]],
	"<ol><li>foo</li><ol><li>[bar]</li> <li>baz</li></ol></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<li>[bar]</li><ol> <li>baz</ol></ol>",
	[["indent",""]],
	"<ol><li>foo</li><ol><li>[bar]</li> <li>baz</li></ol></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<li>[bar]</li> <ol> <li>baz</ol></ol>",
	[["indent",""]],
	"<ol><li>foo</li><ol><li>[bar]</li>  <li>baz</li></ol></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<li>[bar] <ol><li>baz</ol></ol>",
	[["indent",""]],
	"<ol><li>foo</li><ol><li>[bar] </li><li>baz</li></ol></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<li>[bar]<ol> <li>baz</ol></ol>",
	[["indent",""]],
	"<ol><li>foo</li><ol><li>[bar]</li> <li>baz</li></ol></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ol><li>foo<li>[bar] <ol> <li>baz</ol></ol>",
	[["indent",""]],
	"<ol><li>foo</li><ol><li>[bar] </li> <li>baz</li></ol></ol>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["<ul><li>a<br>{<br>}</li><li>b</li></ul>",
	[["indent",""]],
	"<ul><ul><li>a<br>{<br>}</li></ul><li>b</li></ul>",
	[true],
	{"indent":[false,false,"",false,false,""]}],
["foo[]bar",
	[["inserthorizontalrule",""]],
	"foo<hr>{}bar",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<span>foo</span>{}<span>bar</span>",
	[["inserthorizontalrule",""]],
	"<span>foo</span><hr>{}<span>bar</span>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<span>foo[</span><span>]bar</span>",
	[["inserthorizontalrule",""]],
	"<span>foo</span><hr>{}<span>bar</span>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<p>foo[bar<p>baz]quz",
	[["inserthorizontalrule",""]],
	"<p>foo</p><hr>{}<p>quz</p>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<div><b>foo</b>{}<b>bar</b></div>",
	[["inserthorizontalrule",""]],
	"<div><b>foo</b><hr>{}<b>bar</b></div>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<div><b>foo[</b><b>]bar</b></div>",
	[["inserthorizontalrule",""]],
	"<div><b>foo</b><hr>{}<b>bar</b></div>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<div><b>foo</b>{<b>bar</b>}<b>baz</b></div>",
	[["stylewithcss","true"],["inserthorizontalrule",""]],
	"<div><b>foo</b><hr>{}<b>baz</b></div>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<div><b>foo</b>{<b>bar</b>}<b>baz</b></div>",
	[["stylewithcss","false"],["inserthorizontalrule",""]],
	"<div><b>foo</b><hr>{}<b>baz</b></div>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<b>foo[]bar</b>",
	[["stylewithcss","true"],["inserthorizontalrule",""]],
	"<b>foo</b><hr>{}<b>bar</b>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<b>foo[]bar</b>",
	[["stylewithcss","false"],["inserthorizontalrule",""]],
	"<b>foo</b><hr>{}<b>bar</b>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<b id=abc>foo[]bar</b>",
	[["stylewithcss","true"],["inserthorizontalrule",""]],
	"<b id=\"abc\">foo</b><hr>{}<b>bar</b>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<b id=abc>foo[]bar</b>",
	[["stylewithcss","false"],["inserthorizontalrule",""]],
	"<b id=\"abc\">foo</b><hr>{}<b>bar</b>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserthorizontalrule":[false,false,"",false,false,""]}],
["foo[bar]baz",
	[["inserthorizontalrule","abc"]],
	"foo<hr>{}baz",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["foo[bar]baz",
	[["inserthorizontalrule",""]],
	"foo<hr>{}baz",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["foo<b>[bar]</b>baz",
	[["stylewithcss","true"],["inserthorizontalrule",""]],
	"foo<hr>{}baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserthorizontalrule":[false,false,"",false,false,""]}],
["foo<b>[bar]</b>baz",
	[["stylewithcss","false"],["inserthorizontalrule",""]],
	"foo<hr>{}baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserthorizontalrule":[false,false,"",false,false,""]}],
["foo<b>{bar}</b>baz",
	[["stylewithcss","true"],["inserthorizontalrule",""]],
	"foo<hr>{}baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserthorizontalrule":[false,false,"",false,false,""]}],
["foo<b>{bar}</b>baz",
	[["stylewithcss","false"],["inserthorizontalrule",""]],
	"foo<hr>{}baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserthorizontalrule":[false,false,"",false,false,""]}],
["foo{<b>bar</b>}baz",
	[["stylewithcss","true"],["inserthorizontalrule",""]],
	"foo<hr>{}baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserthorizontalrule":[false,false,"",false,false,""]}],
["foo{<b>bar</b>}baz",
	[["stylewithcss","false"],["inserthorizontalrule",""]],
	"foo<hr>{}baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<p>foo<p>[bar]<p>baz",
	[["defaultparagraphseparator","div"],["inserthorizontalrule",""]],
	"<p>foo</p><hr>{}<p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<p>foo<p>[bar]<p>baz",
	[["defaultparagraphseparator","p"],["inserthorizontalrule",""]],
	"<p>foo</p><hr>{}<p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<p>foo<p>{bar}<p>baz",
	[["defaultparagraphseparator","div"],["inserthorizontalrule",""]],
	"<p>foo</p><hr>{}<p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<p>foo<p>{bar}<p>baz",
	[["defaultparagraphseparator","p"],["inserthorizontalrule",""]],
	"<p>foo</p><hr>{}<p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<p>foo{<p>bar</p>}<p>baz",
	[["defaultparagraphseparator","div"],["inserthorizontalrule",""]],
	"<p>foo</p><hr>{}<p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<p>foo{<p>bar</p>}<p>baz",
	[["defaultparagraphseparator","p"],["inserthorizontalrule",""]],
	"<p>foo</p><hr>{}<p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<p>foo[bar]baz</p>",
	[["defaultparagraphseparator","div"],["inserthorizontalrule",""]],
	"<p>foo</p><hr>{}<p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<p>foo[bar]baz</p>",
	[["defaultparagraphseparator","p"],["inserthorizontalrule",""]],
	"<p>foo</p><hr>{}<p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<p id=abc>foo[bar]baz</p>",
	[["defaultparagraphseparator","div"],["inserthorizontalrule",""]],
	"<p id=\"abc\">foo</p><hr>{}<p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<p id=abc>foo[bar]baz</p>",
	[["defaultparagraphseparator","p"],["inserthorizontalrule",""]],
	"<p id=\"abc\">foo</p><hr>{}<p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<h1>foo[bar]baz</h1>",
	[["inserthorizontalrule",""]],
	"<h1>foo</h1><hr>{}<h1>baz</h1>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<p>foo<b>b[a]r</b>baz</p>",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["inserthorizontalrule",""]],
	"<p>foo<b>b</b></p><hr>{}<p><b>r</b>baz</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<p>foo<b>b[a]r</b>baz</p>",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["inserthorizontalrule",""]],
	"<p>foo<b>b</b></p><hr>{}<p><b>r</b>baz</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<p>foo<b>b[a]r</b>baz</p>",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["inserthorizontalrule",""]],
	"<p>foo<b>b</b></p><hr>{}<p><b>r</b>baz</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<p>foo<b>b[a]r</b>baz</p>",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["inserthorizontalrule",""]],
	"<p>foo<b>b</b></p><hr>{}<p><b>r</b>baz</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<a>foo[bar]baz</a>",
	[["inserthorizontalrule",""]],
	"<a>foo</a><hr>{}<a>baz</a>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<a href=/>foo[bar]baz</a>",
	[["inserthorizontalrule",""]],
	"<a href=\"/\">foo</a><hr>{}<a href=\"/\">baz</a>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<abbr>foo[bar]baz</abbr>",
	[["inserthorizontalrule",""]],
	"<abbr>foo</abbr><hr>{}<abbr>baz</abbr>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<address>foo[bar]baz</address>",
	[["inserthorizontalrule",""]],
	"<address>foo<hr>{}baz</address>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<article>foo[bar]baz</article>",
	[["inserthorizontalrule",""]],
	"<article>foo<hr>{}baz</article>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<aside>foo[bar]baz</aside>",
	[["inserthorizontalrule",""]],
	"<aside>foo<hr>{}baz</aside>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<b>foo[bar]baz</b>",
	[["stylewithcss","true"],["inserthorizontalrule",""]],
	"<b>foo</b><hr>{}<b>baz</b>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<b>foo[bar]baz</b>",
	[["stylewithcss","false"],["inserthorizontalrule",""]],
	"<b>foo</b><hr>{}<b>baz</b>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<bdi>foo[bar]baz</bdi>",
	[["inserthorizontalrule",""]],
	"<bdi>foo</bdi><hr>{}<bdi>baz</bdi>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<bdo dir=rtl>foo[bar]baz</bdo>",
	[["inserthorizontalrule",""]],
	"<bdo dir=\"rtl\">foo</bdo><hr>{}<bdo dir=\"rtl\">baz</bdo>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<blockquote>foo[bar]baz</blockquote>",
	[["inserthorizontalrule",""]],
	"<blockquote>foo<hr>{}baz</blockquote>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<table><caption>foo[bar]baz</caption><tr><td>quz</table>",
	[["inserthorizontalrule",""]],
	"<table><caption>foo<hr>{}baz</caption><tbody><tr><td>quz</td></tr></tbody></table>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<cite>foo[bar]baz</cite>",
	[["inserthorizontalrule",""]],
	"<cite>foo</cite><hr>{}<cite>baz</cite>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<code>foo[bar]baz</code>",
	[["inserthorizontalrule",""]],
	"<code>foo</code><hr>{}<code>baz</code>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<dl><dd>foo[bar]baz</dd></dl>",
	[["inserthorizontalrule",""]],
	"<dl><dd>foo<hr>{}baz</dd></dl>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<del>foo[bar]baz</del>",
	[["inserthorizontalrule",""]],
	"<del>foo<hr>{}baz</del>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<details>foo[bar]baz</details>",
	[["inserthorizontalrule",""]],
	"<details>foo<hr>{}baz</details>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<dfn>foo[bar]baz</dfn>",
	[["inserthorizontalrule",""]],
	"<dfn>foo</dfn><hr>{}<dfn>baz</dfn>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<div>foo[bar]baz</div>",
	[["inserthorizontalrule",""]],
	"<div>foo<hr>{}baz</div>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<dl><dt>foo[bar]baz</dt></dl>",
	[["inserthorizontalrule",""]],
	"<dl><dt>foo<hr>{}baz</dt></dl>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<em>foo[bar]baz</em>",
	[["inserthorizontalrule",""]],
	"<em>foo</em><hr>{}<em>baz</em>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<figure><figcaption>foo[bar]baz</figcaption>quz</figure>",
	[["inserthorizontalrule",""]],
	"<figure><figcaption>foo<hr>{}baz</figcaption>quz</figure>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<figure>foo[bar]baz</figure>",
	[["inserthorizontalrule",""]],
	"<figure>foo<hr>{}baz</figure>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<footer>foo[bar]baz</footer>",
	[["inserthorizontalrule",""]],
	"<footer>foo<hr>{}baz</footer>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<h1>foo[bar]baz</h1>",
	[["inserthorizontalrule",""]],
	"<h1>foo</h1><hr>{}<h1>baz</h1>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<h2>foo[bar]baz</h2>",
	[["inserthorizontalrule",""]],
	"<h2>foo</h2><hr>{}<h2>baz</h2>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<h3>foo[bar]baz</h3>",
	[["inserthorizontalrule",""]],
	"<h3>foo</h3><hr>{}<h3>baz</h3>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<h4>foo[bar]baz</h4>",
	[["inserthorizontalrule",""]],
	"<h4>foo</h4><hr>{}<h4>baz</h4>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<h5>foo[bar]baz</h5>",
	[["inserthorizontalrule",""]],
	"<h5>foo</h5><hr>{}<h5>baz</h5>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<h6>foo[bar]baz</h6>",
	[["inserthorizontalrule",""]],
	"<h6>foo</h6><hr>{}<h6>baz</h6>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<header>foo[bar]baz</header>",
	[["inserthorizontalrule",""]],
	"<header>foo<hr>{}baz</header>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<hgroup>foo[bar]baz</hgroup>",
	[["inserthorizontalrule",""]],
	"<hgroup>foo</hgroup><hr>{}<hgroup>baz</hgroup>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<hgroup><h1>foo[bar]baz</h1></hgroup>",
	[["inserthorizontalrule",""]],
	"<hgroup><h1>foo</h1></hgroup><hr>{}<hgroup><h1>baz</h1></hgroup>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<i>foo[bar]baz</i>",
	[["stylewithcss","true"],["inserthorizontalrule",""]],
	"<i>foo</i><hr>{}<i>baz</i>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<i>foo[bar]baz</i>",
	[["stylewithcss","false"],["inserthorizontalrule",""]],
	"<i>foo</i><hr>{}<i>baz</i>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<ins>foo[bar]baz</ins>",
	[["inserthorizontalrule",""]],
	"<ins>foo<hr>{}baz</ins>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<kbd>foo[bar]baz</kbd>",
	[["inserthorizontalrule",""]],
	"<kbd>foo</kbd><hr>{}<kbd>baz</kbd>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<mark>foo[bar]baz</mark>",
	[["inserthorizontalrule",""]],
	"<mark>foo</mark><hr>{}<mark>baz</mark>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<nav>foo[bar]baz</nav>",
	[["inserthorizontalrule",""]],
	"<nav>foo<hr>{}baz</nav>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<ol><li>foo[bar]baz</li></ol>",
	[["inserthorizontalrule",""]],
	"<ol><li>foo<hr>{}baz</li></ol>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<p>foo[bar]baz</p>",
	[["defaultparagraphseparator","div"],["inserthorizontalrule",""]],
	"<p>foo</p><hr>{}<p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<p>foo[bar]baz</p>",
	[["defaultparagraphseparator","p"],["inserthorizontalrule",""]],
	"<p>foo</p><hr>{}<p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<pre>foo[bar]baz</pre>",
	[["inserthorizontalrule",""]],
	"<pre>foo</pre><hr>{}<pre>baz</pre>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<q>foo[bar]baz</q>",
	[["inserthorizontalrule",""]],
	"<q>foo</q><hr>{}<q>baz</q>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<ruby>foo[bar]baz<rt>quz</rt></ruby>",
	[["inserthorizontalrule",""]],
	"<ruby>foo</ruby><hr>{}<ruby>baz<rt>quz</rt></ruby>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<ruby>foo<rt>bar[baz]quz</rt></ruby>",
	[["inserthorizontalrule",""]],
	"<ruby>foo<rt>bar</rt></ruby><hr>{}<ruby><rt>quz</rt></ruby>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<ruby>foo<rp>bar[baz]quz</rp><rt>qoz</rt><rp>qiz</rp></ruby>",
	[["inserthorizontalrule",""]],
	"<ruby>foo<rp>bar</rp></ruby><hr>{}<ruby><rp>quz</rp><rt>qoz</rt><rp>qiz</rp></ruby>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<s>foo[bar]baz</s>",
	[["stylewithcss","true"],["inserthorizontalrule",""]],
	"<s>foo</s><hr>{}<s>baz</s>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<s>foo[bar]baz</s>",
	[["stylewithcss","false"],["inserthorizontalrule",""]],
	"<s>foo</s><hr>{}<s>baz</s>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<samp>foo[bar]baz</samp>",
	[["inserthorizontalrule",""]],
	"<samp>foo</samp><hr>{}<samp>baz</samp>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<section>foo[bar]baz</section>",
	[["inserthorizontalrule",""]],
	"<section>foo<hr>{}baz</section>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<small>foo[bar]baz</small>",
	[["inserthorizontalrule",""]],
	"<small>foo</small><hr>{}<small>baz</small>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<span>foo[bar]baz</span>",
	[["inserthorizontalrule",""]],
	"<span>foo</span><hr>{}<span>baz</span>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<strong>foo[bar]baz</strong>",
	[["inserthorizontalrule",""]],
	"<strong>foo</strong><hr>{}<strong>baz</strong>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<sub>foo[bar]baz</sub>",
	[["stylewithcss","true"],["inserthorizontalrule",""]],
	"<sub>foo</sub><hr>{}<sub>baz</sub>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<sub>foo[bar]baz</sub>",
	[["stylewithcss","false"],["inserthorizontalrule",""]],
	"<sub>foo</sub><hr>{}<sub>baz</sub>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<sup>foo[bar]baz</sup>",
	[["stylewithcss","true"],["inserthorizontalrule",""]],
	"<sup>foo</sup><hr>{}<sup>baz</sup>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<sup>foo[bar]baz</sup>",
	[["stylewithcss","false"],["inserthorizontalrule",""]],
	"<sup>foo</sup><hr>{}<sup>baz</sup>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<table><tr><td>foo[bar]baz</td></table>",
	[["inserthorizontalrule",""]],
	"<table><tbody><tr><td>foo<hr>{}baz</td></tr></tbody></table>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<table><tr><th>foo[bar]baz</th></table>",
	[["inserthorizontalrule",""]],
	"<table><tbody><tr><th>foo<hr>{}baz</th></tr></tbody></table>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<u>foo[bar]baz</u>",
	[["stylewithcss","true"],["inserthorizontalrule",""]],
	"<u>foo</u><hr>{}<u>baz</u>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<u>foo[bar]baz</u>",
	[["stylewithcss","false"],["inserthorizontalrule",""]],
	"<u>foo</u><hr>{}<u>baz</u>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<ul><li>foo[bar]baz</li></ul>",
	[["inserthorizontalrule",""]],
	"<ul><li>foo<hr>{}baz</li></ul>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<var>foo[bar]baz</var>",
	[["inserthorizontalrule",""]],
	"<var>foo</var><hr>{}<var>baz</var>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<acronym>foo[bar]baz</acronym>",
	[["inserthorizontalrule",""]],
	"<acronym>foo</acronym><hr>{}<acronym>baz</acronym>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<big>foo[bar]baz</big>",
	[["inserthorizontalrule",""]],
	"<big>foo</big><hr>{}<big>baz</big>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<blink>foo[bar]baz</blink>",
	[["inserthorizontalrule",""]],
	"<blink>foo</blink><hr>{}<blink>baz</blink>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<center>foo[bar]baz</center>",
	[["inserthorizontalrule",""]],
	"<center>foo<hr>{}baz</center>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<dir>foo[bar]baz</dir>",
	[["inserthorizontalrule",""]],
	"<dir>foo</dir><hr>{}<dir>baz</dir>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<dir><li>foo[bar]baz</li></dir>",
	[["inserthorizontalrule",""]],
	"<dir><li>foo<hr>{}baz</li></dir>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<font>foo[bar]baz</font>",
	[["stylewithcss","true"],["inserthorizontalrule",""]],
	"<font>foo</font><hr>{}<font>baz</font>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<font>foo[bar]baz</font>",
	[["stylewithcss","false"],["inserthorizontalrule",""]],
	"<font>foo</font><hr>{}<font>baz</font>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<listing>foo[bar]baz</listing>",
	[["inserthorizontalrule",""]],
	"<listing>foo</listing><hr>{}<listing>baz</listing>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<marquee>foo[bar]baz</marquee>",
	[["inserthorizontalrule",""]],
	"<marquee>foo</marquee><hr>{}<marquee>baz</marquee>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<nobr>foo[bar]baz</nobr>",
	[["inserthorizontalrule",""]],
	"<nobr>foo</nobr><hr>{}<nobr>baz</nobr>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<strike>foo[bar]baz</strike>",
	[["stylewithcss","true"],["inserthorizontalrule",""]],
	"<strike>foo</strike><hr>{}<strike>baz</strike>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<strike>foo[bar]baz</strike>",
	[["stylewithcss","false"],["inserthorizontalrule",""]],
	"<strike>foo</strike><hr>{}<strike>baz</strike>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserthorizontalrule":[false,false,"",false,false,""]}],
["<tt>foo[bar]baz</tt>",
	[["inserthorizontalrule",""]],
	"<tt>foo</tt><hr>{}<tt>baz</tt>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<xmp>foo[bar]baz</xmp>",
	[["inserthorizontalrule",""]],
	"<xmp>foo</xmp><hr>{}<xmp>baz</xmp>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<quasit>foo[bar]baz</quasit>",
	[["inserthorizontalrule",""]],
	"<quasit>foo<hr>{}baz</quasit>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["<table><tr><td>fo[o<td>b]ar</table>",
	[["inserthorizontalrule",""]],
	"<table><tbody><tr><td>fo<hr>{}</td><td>ar</td></tr></tbody></table>",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["fo[o<span contenteditable=false>bar</span>b]az",
	[["inserthorizontalrule",""]],
	"fo<hr>{}<span contenteditable=\"false\">bar</span>az",
	[true],
	{"inserthorizontalrule":[false,false,"",false,false,""]}],
["foo[]bar",
	[["stylewithcss","true"],["inserthtml","ab<b>c</b>d"]],
	"fooab<b>c</b>d{}bar",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserthtml":[false,false,"",false,false,""]}],
["foo[]bar",
	[["stylewithcss","false"],["inserthtml","ab<b>c</b>d"]],
	"fooab<b>c</b>d{}bar",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserthtml":[false,false,"",false,false,""]}],
["foo[bar]baz",
	[["stylewithcss","true"],["inserthtml","ab<b>c</b>d"]],
	"fooab<b>c</b>d{}baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserthtml":[false,false,"",false,false,""]}],
["foo[bar]baz",
	[["stylewithcss","false"],["inserthtml","ab<b>c</b>d"]],
	"fooab<b>c</b>d{}baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserthtml":[false,false,"",false,false,""]}],
["foo<span style=color:#aBcDeF>[bar]</span>baz",
	[["stylewithcss","true"],["inserthtml","ab<b>c</b>d"]],
	"fooab<b>c</b>d{}baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserthtml":[false,false,"",false,false,""]}],
["foo<span style=color:#aBcDeF>[bar]</span>baz",
	[["stylewithcss","false"],["inserthtml","ab<b>c</b>d"]],
	"fooab<b>c</b>d{}baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserthtml":[false,false,"",false,false,""]}],
["foo<span style=color:#aBcDeF>{bar}</span>baz",
	[["stylewithcss","true"],["inserthtml","ab<b>c</b>d"]],
	"fooab<b>c</b>d{}baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserthtml":[false,false,"",false,false,""]}],
["foo<span style=color:#aBcDeF>{bar}</span>baz",
	[["stylewithcss","false"],["inserthtml","ab<b>c</b>d"]],
	"fooab<b>c</b>d{}baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserthtml":[false,false,"",false,false,""]}],
["foo{<span style=color:#aBcDeF>bar</span>}baz",
	[["stylewithcss","true"],["inserthtml","ab<b>c</b>d"]],
	"fooab<b>c</b>d{}baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserthtml":[false,false,"",false,false,""]}],
["foo{<span style=color:#aBcDeF>bar</span>}baz",
	[["stylewithcss","false"],["inserthtml","ab<b>c</b>d"]],
	"fooab<b>c</b>d{}baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserthtml":[false,false,"",false,false,""]}],
["[foo<span style=color:#aBcDeF>bar]</span>baz",
	[["stylewithcss","true"],["inserthtml","ab<b>c</b>d"]],
	"ab<b>c</b>d{}baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserthtml":[false,false,"",false,false,""]}],
["[foo<span style=color:#aBcDeF>bar]</span>baz",
	[["stylewithcss","false"],["inserthtml","ab<b>c</b>d"]],
	"ab<b>c</b>d{}baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserthtml":[false,false,"",false,false,""]}],
["{foo<span style=color:#aBcDeF>bar}</span>baz",
	[["stylewithcss","true"],["inserthtml","ab<b>c</b>d"]],
	"ab<b>c</b>d{}baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserthtml":[false,false,"",false,false,""]}],
["{foo<span style=color:#aBcDeF>bar}</span>baz",
	[["stylewithcss","false"],["inserthtml","ab<b>c</b>d"]],
	"ab<b>c</b>d{}baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserthtml":[false,false,"",false,false,""]}],
["foo<span style=color:#aBcDeF>[bar</span>baz]",
	[["stylewithcss","true"],["inserthtml","ab<b>c</b>d"]],
	"fooab<b>c</b>d{}",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserthtml":[false,false,"",false,false,""]}],
["foo<span style=color:#aBcDeF>[bar</span>baz]",
	[["stylewithcss","false"],["inserthtml","ab<b>c</b>d"]],
	"fooab<b>c</b>d{}",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserthtml":[false,false,"",false,false,""]}],
["foo<span style=color:#aBcDeF>{bar</span>baz}",
	[["stylewithcss","true"],["inserthtml","ab<b>c</b>d"]],
	"fooab<b>c</b>d{}",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserthtml":[false,false,"",false,false,""]}],
["foo<span style=color:#aBcDeF>{bar</span>baz}",
	[["stylewithcss","false"],["inserthtml","ab<b>c</b>d"]],
	"fooab<b>c</b>d{}",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserthtml":[false,false,"",false,false,""]}],
["foo<span style=color:#aBcDeF>[bar</span><span style=color:#fEdCbA>baz]</span>quz",
	[["stylewithcss","true"],["inserthtml","ab<b>c</b>d"]],
	"fooab<b>c</b>d{}quz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserthtml":[false,false,"",false,false,""]}],
["foo<span style=color:#aBcDeF>[bar</span><span style=color:#fEdCbA>baz]</span>quz",
	[["stylewithcss","false"],["inserthtml","ab<b>c</b>d"]],
	"fooab<b>c</b>d{}quz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserthtml":[false,false,"",false,false,""]}],
["foo[bar]baz",
	[["inserthtml",""]],
	"foo[]baz",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["foo[bar]baz",
	[["inserthtml","\u0000"]],
	"foo[]baz",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["foo[bar]baz",
	[["inserthtml","\u0007"]],
	"foo\u0007{}baz",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["foo[bar]baz",
	[["stylewithcss","true"],["inserthtml","<b>"]],
	"foo<b></b>{}baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserthtml":[false,false,"",false,false,""]}],
["foo[bar]baz",
	[["stylewithcss","false"],["inserthtml","<b>"]],
	"foo<b></b>{}baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserthtml":[false,false,"",false,false,""]}],
["foo[bar]baz",
	[["stylewithcss","true"],["inserthtml","<b>abc"]],
	"foo<b>abc</b>{}baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserthtml":[false,false,"",false,false,""]}],
["foo[bar]baz",
	[["stylewithcss","false"],["inserthtml","<b>abc"]],
	"foo<b>abc</b>{}baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserthtml":[false,false,"",false,false,""]}],
["<p>foo[bar]baz",
	[["defaultparagraphseparator","div"],["inserthtml","<p>abc"]],
	"<p>foo</p><p>abc</p>{}<p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"inserthtml":[false,false,"",false,false,""]}],
["<p>foo[bar]baz",
	[["defaultparagraphseparator","p"],["inserthtml","<p>abc"]],
	"<p>foo</p><p>abc</p>{}<p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"inserthtml":[false,false,"",false,false,""]}],
["<p>foo[bar]baz",
	[["defaultparagraphseparator","div"],["inserthtml","<li>abc"]],
	"<p>foo</p><div>abc</div>{}<p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"inserthtml":[false,false,"",false,false,""]}],
["<p>foo[bar]baz",
	[["defaultparagraphseparator","p"],["inserthtml","<li>abc"]],
	"<p>foo</p><p>abc</p>{}<p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"inserthtml":[false,false,"",false,false,""]}],
["<ol>{<li>foo</li>}<li>bar</ol>",
	[["defaultparagraphseparator","div"],["inserthtml","<p>abc"]],
	"<p>abc</p>{}<ol><li>bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"inserthtml":[false,false,"",false,false,""]}],
["<ol>{<li>foo</li>}<li>bar</ol>",
	[["defaultparagraphseparator","p"],["inserthtml","<p>abc"]],
	"<p>abc</p>{}<ol><li>bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"inserthtml":[false,false,"",false,false,""]}],
["<ol><li>foo</li>{<li>bar</li>}<li>baz</ol>",
	[["defaultparagraphseparator","div"],["inserthtml","<p>abc"]],
	"<ol><li>foo</li></ol><p>abc</p>{}<ol><li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"inserthtml":[false,false,"",false,false,""]}],
["<ol><li>foo</li>{<li>bar</li>}<li>baz</ol>",
	[["defaultparagraphseparator","p"],["inserthtml","<p>abc"]],
	"<ol><li>foo</li></ol><p>abc</p>{}<ol><li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"inserthtml":[false,false,"",false,false,""]}],
["<ol><li>[foo]</li><li>bar</ol>",
	[["defaultparagraphseparator","div"],["inserthtml","<p>abc"]],
	"<ol><li><p>abc</p>{}</li><li>bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"inserthtml":[false,false,"",false,false,""]}],
["<ol><li>[foo]</li><li>bar</ol>",
	[["defaultparagraphseparator","p"],["inserthtml","<p>abc"]],
	"<ol><li><p>abc</p>{}</li><li>bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"inserthtml":[false,false,"",false,false,""]}],
["<xmp>f[o]o</xmp>",
	[["inserthtml","abc"]],
	"<xmp>fabc{}o</xmp>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<xmp>f[o]o</xmp>",
	[["stylewithcss","true"],["inserthtml","<b>abc</b>"]],
	"<xmp>f<b>abc</b>{}o</xmp>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserthtml":[false,false,"",false,false,""]}],
["<xmp>f[o]o</xmp>",
	[["stylewithcss","false"],["inserthtml","<b>abc</b>"]],
	"<xmp>f<b>abc</b>{}o</xmp>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserthtml":[false,false,"",false,false,""]}],
["<script>f[o]o</script>bar",
	[["inserthtml","abc"]],
	"<script>fabc{}o</script>bar",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<script>f[o]o</script>bar",
	[["stylewithcss","true"],["inserthtml","<b>abc</b>"]],
	"<script>f<b>abc</b>{}o</script>bar",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserthtml":[false,false,"",false,false,""]}],
["<script>f[o]o</script>bar",
	[["stylewithcss","false"],["inserthtml","<b>abc</b>"]],
	"<script>f<b>abc</b>{}o</script>bar",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserthtml":[false,false,"",false,false,""]}],
["<a>f[o]o</a>",
	[["inserthtml","<a>abc</a>"]],
	"<a>f</a><a>abc</a>{}<a>o</a>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<a href=.>f[o]o</a>",
	[["inserthtml","<a href=/>abc</a>"]],
	"<a href=\".\">f</a><a href=\"/\">abc</a>{}<a href=\".\">o</a>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<p>f[o]o",
	[["defaultparagraphseparator","div"],["inserthtml","<hr>"]],
	"<p>f</p><hr>{}<p>o</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"inserthtml":[false,false,"",false,false,""]}],
["<p>f[o]o",
	[["defaultparagraphseparator","p"],["inserthtml","<hr>"]],
	"<p>f</p><hr>{}<p>o</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"inserthtml":[false,false,"",false,false,""]}],
["<b>f[o]o</b>",
	[["stylewithcss","true"],["inserthtml","<hr>"]],
	"<b>f</b><hr>{}<b>o</b>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserthtml":[false,false,"",false,false,""]}],
["<b>f[o]o</b>",
	[["stylewithcss","false"],["inserthtml","<hr>"]],
	"<b>f</b><hr>{}<b>o</b>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserthtml":[false,false,"",false,false,""]}],
["<h1>f[o]o</h1>",
	[["inserthtml","<h2>abc</h2>"]],
	"<h1>f</h1><h2>abc</h2>{}<h1>o</h1>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<table><tr><td>f[o]o</table>",
	[["inserthtml","<td>abc</td>"]],
	"<table><tbody><tr><td>fabc{}o</td></tr></tbody></table>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["f[o]o",
	[["inserthtml","<td>abc</td>"]],
	"fabc{}o",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<dl><dt>f[o]o<dd>bar</dl>",
	[["inserthtml","<dt>abc</dt>"]],
	"<dl><dt>f</dt><dt>abc</dt>{}<dt>o</dt><dd>bar</dd></dl>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<dl><dt>foo<dd>b[a]r</dl>",
	[["inserthtml","<dt>abc</dt>"]],
	"<dl><dt>foo</dt><dd>b</dd><dt>abc</dt>{}<dd>r</dd></dl>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<dl><dt>f[o]o<dd>bar</dl>",
	[["inserthtml","<dd>abc</dd>"]],
	"<dl><dt>f</dt><dd>abc</dd>{}<dt>o</dt><dd>bar</dd></dl>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<dl><dt>foo<dd>b[a]r</dl>",
	[["inserthtml","<dd>abc</dd>"]],
	"<dl><dt>foo</dt><dd>b</dd><dd>abc</dd>{}<dd>r</dd></dl>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["f[o]o",
	[["inserthtml","<dt>abc</dt>"]],
	"f<dl><dt>abc</dt>{}</dl>o",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<ol><li>f[o]o</ol>",
	[["inserthtml","<dt>abc</dt>"]],
	"<ol><li>f<dl><dt>abc</dt>{}</dl>o</li></ol>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["f[o]o",
	[["inserthtml","<dd>abc</dd>"]],
	"f<dl><dd>abc</dd>{}</dl>o",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<ol><li>f[o]o</ol>",
	[["inserthtml","<dd>abc</dd>"]],
	"<ol><li>f<dl><dd>abc</dd>{}</dl>o</li></ol>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<dir><li>f[o]o</dir>",
	[["inserthtml","<li>abc</li>"]],
	"<dir><li>f</li><li>abc</li>{}<li>o</li></dir>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<ol><li>f[o]o</ol>",
	[["inserthtml","<li>abc</li>"]],
	"<ol><li>f</li><li>abc</li>{}<li>o</li></ol>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<ul><li>f[o]o</ul>",
	[["inserthtml","<li>abc</li>"]],
	"<ul><li>f</li><li>abc</li>{}<li>o</li></ul>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<dir><li>f[o]o</dir>",
	[["inserthtml","<dir><li>abc</dir>"]],
	"<dir><li>f<dir><li>abc</li></dir>{}o</li></dir>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<ol><li>f[o]o</ol>",
	[["inserthtml","<dir><li>abc</dir>"]],
	"<ol><li>f<dir><li>abc</li></dir>{}o</li></ol>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<ul><li>f[o]o</ul>",
	[["inserthtml","<dir><li>abc</dir>"]],
	"<ul><li>f<dir><li>abc</li></dir>{}o</li></ul>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<dir><li>f[o]o</dir>",
	[["inserthtml","<ol><li>abc</ol>"]],
	"<dir><li>f<ol><li>abc</li></ol>{}o</li></dir>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<ol><li>f[o]o</ol>",
	[["inserthtml","<ol><li>abc</ol>"]],
	"<ol><li>f<ol><li>abc</li></ol>{}o</li></ol>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<ul><li>f[o]o</ul>",
	[["inserthtml","<ol><li>abc</ol>"]],
	"<ul><li>f<ol><li>abc</li></ol>{}o</li></ul>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<dir><li>f[o]o</dir>",
	[["inserthtml","<ul><li>abc</ul>"]],
	"<dir><li>f<ul><li>abc</li></ul>{}o</li></dir>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<ol><li>f[o]o</ol>",
	[["inserthtml","<ul><li>abc</ul>"]],
	"<ol><li>f<ul><li>abc</li></ul>{}o</li></ol>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<ul><li>f[o]o</ul>",
	[["inserthtml","<ul><li>abc</ul>"]],
	"<ul><li>f<ul><li>abc</li></ul>{}o</li></ul>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["f[o]o",
	[["defaultparagraphseparator","div"],["inserthtml","<li>abc</li>"]],
	"f<div>abc</div>{}o",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"inserthtml":[false,false,"",false,false,""]}],
["f[o]o",
	[["defaultparagraphseparator","p"],["inserthtml","<li>abc</li>"]],
	"f<p>abc</p>{}o",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"inserthtml":[false,false,"",false,false,""]}],
["<nobr>f[o]o</nobr>",
	[["inserthtml","<nobr>abc</nobr>"]],
	"<nobr>f</nobr><nobr>abc</nobr>{}<nobr>o</nobr>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["f[o]o",
	[["inserthtml","<nobr>abc</nobr>"]],
	"f<nobr>abc</nobr>{}o",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<font color=blue>foo[]bar</font>",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["inserthtml","<p>abc"]],
	"<font color=\"blue\">foo</font><p><span style=\"color:rgb(0, 0, 255)\">abc</span></p>{}<font color=\"blue\">bar</font>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"inserthtml":[false,false,"",false,false,""]}],
["<font color=blue>foo[]bar</font>",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["inserthtml","<p>abc"]],
	"<font color=\"blue\">foo</font><p><font color=\"#0000ff\">abc</font></p>{}<font color=\"blue\">bar</font>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"inserthtml":[false,false,"",false,false,""]}],
["<font color=blue>foo[]bar</font>",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["inserthtml","<p>abc"]],
	"<font color=\"blue\">foo</font><p><span style=\"color:rgb(0, 0, 255)\">abc</span></p>{}<font color=\"blue\">bar</font>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"inserthtml":[false,false,"",false,false,""]}],
["<font color=blue>foo[]bar</font>",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["inserthtml","<p>abc"]],
	"<font color=\"blue\">foo</font><p><font color=\"#0000ff\">abc</font></p>{}<font color=\"blue\">bar</font>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"inserthtml":[false,false,"",false,false,""]}],
["<span style=color:blue>foo[]bar</span>",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["inserthtml","<p>abc"]],
	"<span style=\"color:rgb(0, 0, 255)\">foo</span><p><span style=\"color:rgb(0, 0, 255)\">abc</span></p>{}<span style=\"color:rgb(0, 0, 255)\">bar</span>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"inserthtml":[false,false,"",false,false,""]}],
["<span style=color:blue>foo[]bar</span>",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["inserthtml","<p>abc"]],
	"<span style=\"color:rgb(0, 0, 255)\">foo</span><p><font color=\"#0000ff\">abc</font></p>{}<span style=\"color:rgb(0, 0, 255)\">bar</span>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"inserthtml":[false,false,"",false,false,""]}],
["<span style=color:blue>foo[]bar</span>",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["inserthtml","<p>abc"]],
	"<span style=\"color:rgb(0, 0, 255)\">foo</span><p><span style=\"color:rgb(0, 0, 255)\">abc</span></p>{}<span style=\"color:rgb(0, 0, 255)\">bar</span>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"inserthtml":[false,false,"",false,false,""]}],
["<span style=color:blue>foo[]bar</span>",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["inserthtml","<p>abc"]],
	"<span style=\"color:rgb(0, 0, 255)\">foo</span><p><font color=\"#0000ff\">abc</font></p>{}<span style=\"color:rgb(0, 0, 255)\">bar</span>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"inserthtml":[false,false,"",false,false,""]}],
["<span style=font-variant:small-caps>foo[]bar</span>",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["inserthtml","<p>abc"]],
	"<span style=\"font-variant:small-caps\">foo</span><p>abc</p>{}<span style=\"font-variant:small-caps\">bar</span>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"inserthtml":[false,false,"",false,false,""]}],
["<span style=font-variant:small-caps>foo[]bar</span>",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["inserthtml","<p>abc"]],
	"<span style=\"font-variant:small-caps\">foo</span><p>abc</p>{}<span style=\"font-variant:small-caps\">bar</span>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"inserthtml":[false,false,"",false,false,""]}],
["<span style=font-variant:small-caps>foo[]bar</span>",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["inserthtml","<p>abc"]],
	"<span style=\"font-variant:small-caps\">foo</span><p>abc</p>{}<span style=\"font-variant:small-caps\">bar</span>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"inserthtml":[false,false,"",false,false,""]}],
["<span style=font-variant:small-caps>foo[]bar</span>",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["inserthtml","<p>abc"]],
	"<span style=\"font-variant:small-caps\">foo</span><p>abc</p>{}<span style=\"font-variant:small-caps\">bar</span>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"inserthtml":[false,false,"",false,false,""]}],
["<p>[foo]</p>",
	[["inserthtml"," "]],
	"<p> {}<br></p>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<p>[foo]</p>",
	[["stylewithcss","true"],["inserthtml","<span style=display:none></span>"]],
	"<p><span style=\"display:none\"></span>{}<br></p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserthtml":[false,false,"",false,false,""]}],
["<p>[foo]</p>",
	[["stylewithcss","false"],["inserthtml","<span style=display:none></span>"]],
	"<p><span style=\"display:none\"></span>{}<br></p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserthtml":[false,false,"",false,false,""]}],
["<p>[foo]</p>",
	[["inserthtml","<!--abc-->"]],
	"<p><!--abc-->{}<br></p>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<p>{}<br></p>",
	[["inserthtml","abc"]],
	"<p>abc{}</p>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<p>{}<br></p>",
	[["inserthtml","<!--abc-->"]],
	"<p><!--abc-->{}<br></p>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<p><!--foo-->{}<span><br></span><!--bar--></p>",
	[["inserthtml","abc"]],
	"<p><!--foo-->abc{}<!--bar--></p>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<p><!--foo-->{}<span><br></span><!--bar--></p>",
	[["inserthtml","<!--abc-->"]],
	"<p><!--foo--><!--abc-->{}<!--bar--><br></p>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<p>{}<span><!--foo--><br><!--bar--></span></p>",
	[["inserthtml","abc"]],
	"<p>abc{}</p>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<p>{}<span><!--foo--><br><!--bar--></span></p>",
	[["inserthtml","<!--abc-->"]],
	"<p><!--abc-->{}<br></p>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<p><br>{}</p>",
	[["inserthtml","abc"]],
	"<p><br>abc{}</p>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<p><br>{}</p>",
	[["inserthtml","<!--abc-->"]],
	"<p><br><!--abc-->{}</p>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<p><!--foo--><span><br></span>{}<!--bar--></p>",
	[["inserthtml","abc"]],
	"<p><!--foo--><span><br></span>abc{}<!--bar--></p>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<p><!--foo--><span><br></span>{}<!--bar--></p>",
	[["inserthtml","<!--abc-->"]],
	"<p><!--foo--><span><br></span><!--abc-->{}<!--bar--></p>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<p><span><!--foo--><br><!--bar--></span>{}</p>",
	[["inserthtml","abc"]],
	"<p><span><!--foo--><br><!--bar--></span>abc{}</p>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["<p><span><!--foo--><br><!--bar--></span>{}</p>",
	[["inserthtml","<!--abc-->"]],
	"<p><span><!--foo--><br><!--bar--></span><!--abc-->{}</p>",
	[true],
	{"inserthtml":[false,false,"",false,false,""]}],
["foo[]bar",
	[["insertimage","/img/lion.svg"]],
	"foo<img src=\"/img/lion.svg\">{}bar",
	[true],
	{"insertimage":[false,false,"",false,false,""]}],
["<span>foo</span>{}<span>bar</span>",
	[["insertimage","/img/lion.svg"]],
	"<span>foo</span><img src=\"/img/lion.svg\">{}<span>bar</span>",
	[true],
	{"insertimage":[false,false,"",false,false,""]}],
["<span>foo[</span><span>]bar</span>",
	[["insertimage","/img/lion.svg"]],
	"<span>foo<img src=\"/img/lion.svg\">{}</span><span>bar</span>",
	[true],
	{"insertimage":[false,false,"",false,false,""]}],
["foo[bar]baz",
	[["insertimage",""]],
	"foo[bar]baz",
	[false],
	{"insertimage":[false,false,"",false,false,""]}],
["foo[bar]baz",
	[["insertimage","/img/lion.svg"]],
	"foo<img src=\"/img/lion.svg\">{}baz",
	[true],
	{"insertimage":[false,false,"",false,false,""]}],
["foo<span style=color:#aBcDeF>[bar]</span>baz",
	[["insertimage","/img/lion.svg"]],
	"foo<span style=\"color:rgb(171, 205, 239)\"><img src=\"/img/lion.svg\">{}</span>baz",
	[true],
	{"insertimage":[false,false,"",false,false,""]}],
["foo<span style=color:#aBcDeF>{bar}</span>baz",
	[["insertimage","/img/lion.svg"]],
	"foo<span style=\"color:rgb(171, 205, 239)\"><img src=\"/img/lion.svg\">{}</span>baz",
	[true],
	{"insertimage":[false,false,"",false,false,""]}],
["foo{<span style=color:#aBcDeF>bar</span>}baz",
	[["insertimage","/img/lion.svg"]],
	"foo<span style=\"color:rgb(171, 205, 239)\"><img src=\"/img/lion.svg\">{}</span>baz",
	[true],
	{"insertimage":[false,false,"",false,false,""]}],
["[foo<span style=color:#aBcDeF>bar]</span>baz",
	[["stylewithcss","true"],["insertimage","/img/lion.svg"]],
	"<img src=\"/img/lion.svg\">{}baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"insertimage":[false,false,"",false,false,""]}],
["[foo<span style=color:#aBcDeF>bar]</span>baz",
	[["stylewithcss","false"],["insertimage","/img/lion.svg"]],
	"<img src=\"/img/lion.svg\">{}baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"insertimage":[false,false,"",false,false,""]}],
["{foo<span style=color:#aBcDeF>bar}</span>baz",
	[["stylewithcss","true"],["insertimage","/img/lion.svg"]],
	"<img src=\"/img/lion.svg\">{}baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"insertimage":[false,false,"",false,false,""]}],
["{foo<span style=color:#aBcDeF>bar}</span>baz",
	[["stylewithcss","false"],["insertimage","/img/lion.svg"]],
	"<img src=\"/img/lion.svg\">{}baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"insertimage":[false,false,"",false,false,""]}],
["foo<span style=color:#aBcDeF>[bar</span>baz]",
	[["insertimage","/img/lion.svg"]],
	"foo<span style=\"color:rgb(171, 205, 239)\"><img src=\"/img/lion.svg\">{}</span>",
	[true],
	{"insertimage":[false,false,"",false,false,""]}],
["foo<span style=color:#aBcDeF>{bar</span>baz}",
	[["insertimage","/img/lion.svg"]],
	"foo<span style=\"color:rgb(171, 205, 239)\"><img src=\"/img/lion.svg\">{}</span>",
	[true],
	{"insertimage":[false,false,"",false,false,""]}],
["foo<span style=color:#aBcDeF>[bar</span><span style=color:#fEdCbA>baz]</span>quz",
	[["stylewithcss","true"],["insertimage","/img/lion.svg"]],
	"foo<span style=\"color:rgb(171, 205, 239)\"><img src=\"/img/lion.svg\">{}</span>quz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"insertimage":[false,false,"",false,false,""]}],
["foo<span style=color:#aBcDeF>[bar</span><span style=color:#fEdCbA>baz]</span>quz",
	[["stylewithcss","false"],["insertimage","/img/lion.svg"]],
	"foo<span style=\"color:rgb(171, 205, 239)\"><img src=\"/img/lion.svg\">{}</span>quz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"insertimage":[false,false,"",false,false,""]}],
["foo<b>[bar]</b>baz",
	[["insertimage","/img/lion.svg"]],
	"foo<b><img src=\"/img/lion.svg\">{}</b>baz",
	[true],
	{"insertimage":[false,false,"",false,false,""]}],
["foo<b>{bar}</b>baz",
	[["insertimage","/img/lion.svg"]],
	"foo<b><img src=\"/img/lion.svg\">{}</b>baz",
	[true],
	{"insertimage":[false,false,"",false,false,""]}],
["foo{<b>bar</b>}baz",
	[["insertimage","/img/lion.svg"]],
	"foo<b><img src=\"/img/lion.svg\">{}</b>baz",
	[true],
	{"insertimage":[false,false,"",false,false,""]}],
["foo<span>[bar]</span>baz",
	[["insertimage","/img/lion.svg"]],
	"foo<span><img src=\"/img/lion.svg\">{}</span>baz",
	[true],
	{"insertimage":[false,false,"",false,false,""]}],
["foo<span>{bar}</span>baz",
	[["insertimage","/img/lion.svg"]],
	"foo<span><img src=\"/img/lion.svg\">{}</span>baz",
	[true],
	{"insertimage":[false,false,"",false,false,""]}],
["foo{<span>bar</span>}baz",
	[["insertimage","/img/lion.svg"]],
	"foo<span><img src=\"/img/lion.svg\">{}</span>baz",
	[true],
	{"insertimage":[false,false,"",false,false,""]}],
["<b>foo[bar</b><i>baz]quz</i>",
	[["insertimage","/img/lion.svg"]],
	"<b>foo<img src=\"/img/lion.svg\">{}</b><i>quz</i>",
	[true],
	{"insertimage":[false,false,"",false,false,""]}],
["<p>foo</p><p>[bar]</p><p>baz</p>",
	[["insertimage","/img/lion.svg"]],
	"<p>foo</p><p><img src=\"/img/lion.svg\">{}</p><p>baz</p>",
	[true],
	{"insertimage":[false,false,"",false,false,""]}],
["<p>foo</p><p>{bar}</p><p>baz</p>",
	[["insertimage","/img/lion.svg"]],
	"<p>foo</p><p><img src=\"/img/lion.svg\">{}</p><p>baz</p>",
	[true],
	{"insertimage":[false,false,"",false,false,""]}],
["<p>foo</p>{<p>bar</p>}<p>baz</p>",
	[["defaultparagraphseparator","div"],["insertimage","/img/lion.svg"]],
	"<p>foo</p><img src=\"/img/lion.svg\">{}<p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo</p>{<p>bar</p>}<p>baz</p>",
	[["defaultparagraphseparator","p"],["insertimage","/img/lion.svg"]],
	"<p>foo</p><img src=\"/img/lion.svg\">{}<p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo[bar<p>baz]quz",
	[["defaultparagraphseparator","div"],["insertimage","/img/lion.svg"]],
	"<p>foo<img src=\"/img/lion.svg\">{}quz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo[bar<p>baz]quz",
	[["defaultparagraphseparator","p"],["insertimage","/img/lion.svg"]],
	"<p>foo<img src=\"/img/lion.svg\">{}quz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo[bar<div>baz]quz</div>",
	[["defaultparagraphseparator","div"],["insertimage","/img/lion.svg"]],
	"<p>foo<img src=\"/img/lion.svg\">{}quz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo[bar<div>baz]quz</div>",
	[["defaultparagraphseparator","p"],["insertimage","/img/lion.svg"]],
	"<p>foo<img src=\"/img/lion.svg\">{}quz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo[bar<h1>baz]quz</h1>",
	[["insertimage","/img/lion.svg"]],
	"<p>foo<img src=\"/img/lion.svg\">{}quz</p>",
	[true],
	{"insertimage":[false,false,"",false,false,""]}],
["<div>foo[bar</div><p>baz]quz",
	[["defaultparagraphseparator","div"],["insertimage","/img/lion.svg"]],
	"<div>foo<img src=\"/img/lion.svg\">{}quz</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertimage":[false,false,"",false,false,""]}],
["<div>foo[bar</div><p>baz]quz",
	[["defaultparagraphseparator","p"],["insertimage","/img/lion.svg"]],
	"<div>foo<img src=\"/img/lion.svg\">{}quz</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertimage":[false,false,"",false,false,""]}],
["<blockquote>foo[bar</blockquote><pre>baz]quz</pre>",
	[["insertimage","/img/lion.svg"]],
	"<blockquote>foo<img src=\"/img/lion.svg\">{}quz</blockquote>",
	[true],
	{"insertimage":[false,false,"",false,false,""]}],
["<p><b>foo[bar</b><p>baz]quz",
	[["defaultparagraphseparator","div"],["insertimage","/img/lion.svg"]],
	"<p><b>foo</b><img src=\"/img/lion.svg\">{}quz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertimage":[false,false,"",false,false,""]}],
["<p><b>foo[bar</b><p>baz]quz",
	[["defaultparagraphseparator","p"],["insertimage","/img/lion.svg"]],
	"<p><b>foo</b><img src=\"/img/lion.svg\">{}quz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertimage":[false,false,"",false,false,""]}],
["<div><p>foo[bar</div><p>baz]quz",
	[["defaultparagraphseparator","div"],["insertimage","/img/lion.svg"]],
	"<div><p>foo<img src=\"/img/lion.svg\">{}quz</p></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertimage":[false,false,"",false,false,""]}],
["<div><p>foo[bar</div><p>baz]quz",
	[["defaultparagraphseparator","p"],["insertimage","/img/lion.svg"]],
	"<div><p>foo<img src=\"/img/lion.svg\">{}quz</p></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo[bar<blockquote><p>baz]quz<p>qoz</blockquote",
	[["defaultparagraphseparator","div"],["insertimage","/img/lion.svg"]],
	"<p>foo<img src=\"/img/lion.svg\">{}quz</p><blockquote><p>qoz</p></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo[bar<blockquote><p>baz]quz<p>qoz</blockquote",
	[["defaultparagraphseparator","p"],["insertimage","/img/lion.svg"]],
	"<p>foo<img src=\"/img/lion.svg\">{}quz</p><blockquote><p>qoz</p></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo[bar<p style=color:blue>baz]quz",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["insertimage","/img/lion.svg"]],
	"<p>foo<img src=\"/img/lion.svg\">{}<span style=\"color:rgb(0, 0, 255)\">quz</span></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo[bar<p style=color:blue>baz]quz",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["insertimage","/img/lion.svg"]],
	"<p>foo<img src=\"/img/lion.svg\">{}<font color=\"#0000ff\">quz</font></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo[bar<p style=color:blue>baz]quz",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["insertimage","/img/lion.svg"]],
	"<p>foo<img src=\"/img/lion.svg\">{}<span style=\"color:rgb(0, 0, 255)\">quz</span></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo[bar<p style=color:blue>baz]quz",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["insertimage","/img/lion.svg"]],
	"<p>foo<img src=\"/img/lion.svg\">{}<font color=\"#0000ff\">quz</font></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo[bar<p><b>baz]quz</b>",
	[["defaultparagraphseparator","div"],["insertimage","/img/lion.svg"]],
	"<p>foo<img src=\"/img/lion.svg\">{}<b>quz</b></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo[bar<p><b>baz]quz</b>",
	[["defaultparagraphseparator","p"],["insertimage","/img/lion.svg"]],
	"<p>foo<img src=\"/img/lion.svg\">{}<b>quz</b></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertimage":[false,false,"",false,false,""]}],
["<div><p>foo<p>[bar<p>baz]</div>",
	[["defaultparagraphseparator","div"],["insertimage","/img/lion.svg"]],
	"<div><p>foo</p><p><img src=\"/img/lion.svg\">{}</p></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertimage":[false,false,"",false,false,""]}],
["<div><p>foo<p>[bar<p>baz]</div>",
	[["defaultparagraphseparator","p"],["insertimage","/img/lion.svg"]],
	"<div><p>foo</p><p><img src=\"/img/lion.svg\">{}</p></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertimage":[false,false,"",false,false,""]}],
["foo[<br>]bar",
	[["insertimage","/img/lion.svg"]],
	"foo<img src=\"/img/lion.svg\">{}bar",
	[true],
	{"insertimage":[false,false,"",false,false,""]}],
["<p>foo[</p><p>]bar</p>",
	[["defaultparagraphseparator","div"],["insertimage","/img/lion.svg"]],
	"<p>foo<img src=\"/img/lion.svg\">{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo[</p><p>]bar</p>",
	[["defaultparagraphseparator","p"],["insertimage","/img/lion.svg"]],
	"<p>foo<img src=\"/img/lion.svg\">{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo[</p><p>]bar<br>baz</p>",
	[["defaultparagraphseparator","div"],["insertimage","/img/lion.svg"]],
	"<p>foo<img src=\"/img/lion.svg\">{}bar<br>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo[</p><p>]bar<br>baz</p>",
	[["defaultparagraphseparator","p"],["insertimage","/img/lion.svg"]],
	"<p>foo<img src=\"/img/lion.svg\">{}bar<br>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertimage":[false,false,"",false,false,""]}],
["foo[<p>]bar</p>",
	[["defaultparagraphseparator","div"],["insertimage","/img/lion.svg"]],
	"foo<img src=\"/img/lion.svg\">{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertimage":[false,false,"",false,false,""]}],
["foo[<p>]bar</p>",
	[["defaultparagraphseparator","p"],["insertimage","/img/lion.svg"]],
	"foo<img src=\"/img/lion.svg\">{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertimage":[false,false,"",false,false,""]}],
["foo[<p>]bar<br>baz</p>",
	[["insertimage","/img/lion.svg"]],
	"foo<img src=\"/img/lion.svg\">{}bar<p>baz</p>",
	[true],
	{"insertimage":[false,false,"",false,false,""]}],
["foo[<p>]bar</p>baz",
	[["defaultparagraphseparator","div"],["insertimage","/img/lion.svg"]],
	"foo<img src=\"/img/lion.svg\">{}bar<br>baz",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertimage":[false,false,"",false,false,""]}],
["foo[<p>]bar</p>baz",
	[["defaultparagraphseparator","p"],["insertimage","/img/lion.svg"]],
	"foo<img src=\"/img/lion.svg\">{}bar<br>baz",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo[</p>]bar",
	[["insertimage","/img/lion.svg"]],
	"<p>foo<img src=\"/img/lion.svg\">{}bar</p>",
	[true],
	{"insertimage":[false,false,"",false,false,""]}],
["<p>foo[</p>]bar<br>baz",
	[["insertimage","/img/lion.svg"]],
	"<p>foo<img src=\"/img/lion.svg\">{}bar</p>baz",
	[true],
	{"insertimage":[false,false,"",false,false,""]}],
["<p>foo[</p>]bar<p>baz</p>",
	[["insertimage","/img/lion.svg"]],
	"<p>foo<img src=\"/img/lion.svg\">{}bar</p><p>baz</p>",
	[true],
	{"insertimage":[false,false,"",false,false,""]}],
["foo[<div><p>]bar</div>",
	[["defaultparagraphseparator","div"],["insertimage","/img/lion.svg"]],
	"foo<img src=\"/img/lion.svg\">{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertimage":[false,false,"",false,false,""]}],
["foo[<div><p>]bar</div>",
	[["defaultparagraphseparator","p"],["insertimage","/img/lion.svg"]],
	"foo<img src=\"/img/lion.svg\">{}bar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertimage":[false,false,"",false,false,""]}],
["<div><p>foo[</p></div>]bar",
	[["insertimage","/img/lion.svg"]],
	"<div><p>foo<img src=\"/img/lion.svg\">{}bar</p></div>",
	[true],
	{"insertimage":[false,false,"",false,false,""]}],
["foo[<div><p>]bar</p>baz</div>",
	[["defaultparagraphseparator","div"],["insertimage","/img/lion.svg"]],
	"foo<img src=\"/img/lion.svg\">{}bar<div>baz</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertimage":[false,false,"",false,false,""]}],
["foo[<div><p>]bar</p>baz</div>",
	[["defaultparagraphseparator","p"],["insertimage","/img/lion.svg"]],
	"foo<img src=\"/img/lion.svg\">{}bar<div>baz</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertimage":[false,false,"",false,false,""]}],
["foo[<div>]bar<p>baz</p></div>",
	[["insertimage","/img/lion.svg"]],
	"foo<img src=\"/img/lion.svg\">{}bar<div><p>baz</p></div>",
	[true],
	{"insertimage":[false,false,"",false,false,""]}],
["<div><p>foo</p>bar[</div>]baz",
	[["insertimage","/img/lion.svg"]],
	"<div><p>foo</p>bar<img src=\"/img/lion.svg\">{}baz</div>",
	[true],
	{"insertimage":[false,false,"",false,false,""]}],
["<div>foo<p>bar[</p></div>]baz",
	[["insertimage","/img/lion.svg"]],
	"<div>foo<p>bar<img src=\"/img/lion.svg\">{}baz</p></div>",
	[true],
	{"insertimage":[false,false,"",false,false,""]}],
["foo[bar]baz",
	[["insertlinebreak",""]],
	"foo<br>{}baz",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["fo[o<table><tr><td>b]ar</table>",
	[["insertlinebreak",""]],
	"fo<br>{}<br><table><tbody><tr><td>ar</td></tr></tbody></table>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<table><tr><td>[foo<td>bar]<tr><td>baz<td>quz</table>",
	[["insertlinebreak",""]],
	"<table><tbody><tr><td><br>{}<br></td><td><br></td></tr><tr><td>baz</td><td>quz</td></tr></tbody></table>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<tr><td>baz<td>quz</table>",
	[["insertlinebreak",""]],
	"<table><tbody>{}<tr><td><br></td><td><br></td></tr><tr><td>baz</td><td>quz</td></tr></tbody></table>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<table><tr><td>fo[o</table>b]ar",
	[["insertlinebreak",""]],
	"<table><tbody><tr><td>fo<br>{}<br></td></tr></tbody></table>ar",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<table><tr><td>fo[o<td>b]ar<td>baz</table>",
	[["insertlinebreak",""]],
	"<table><tbody><tr><td>fo<br>{}<br></td><td>ar</td><td>baz</td></tr></tbody></table>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["{<table><tr><td>foo</table>}",
	[["insertlinebreak",""]],
	"<br>{}<br>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<table><tr><td>[foo]</table>",
	[["insertlinebreak",""]],
	"<table><tbody><tr><td><br>{}<br></td></tr></tbody></table>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<ol><li>[foo]<li>bar</ol>",
	[["insertlinebreak",""]],
	"<ol><li><br>{}<br></li><li>bar</li></ol>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<ol><li>f[o]o<li>bar</ol>",
	[["insertlinebreak",""]],
	"<ol><li>f<br>{}o</li><li>bar</li></ol>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["[]foo",
	[["insertlinebreak",""]],
	"<br>{}foo",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["foo[]",
	[["insertlinebreak",""]],
	"foo<br>{}<br>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<span>foo[]</span>",
	[["insertlinebreak",""]],
	"<span>foo<br>{}<br></span>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["foo[]<br>",
	[["insertlinebreak",""]],
	"foo<br>{}<br>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["foo[]bar",
	[["insertlinebreak",""]],
	"foo<br>{}bar",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<address>[]foo</address>",
	[["insertlinebreak",""]],
	"<address><br>{}foo</address>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<address>foo[]</address>",
	[["insertlinebreak",""]],
	"<address>foo<br>{}<br></address>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<address>foo[]<br></address>",
	[["insertlinebreak",""]],
	"<address>foo<br>{}<br></address>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<address>foo[]bar</address>",
	[["insertlinebreak",""]],
	"<address>foo<br>{}bar</address>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<div>[]foo</div>",
	[["insertlinebreak",""]],
	"<div><br>{}foo</div>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<div>foo[]</div>",
	[["insertlinebreak",""]],
	"<div>foo<br>{}<br></div>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<div>foo[]<br></div>",
	[["insertlinebreak",""]],
	"<div>foo<br>{}<br></div>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<div>foo[]bar</div>",
	[["insertlinebreak",""]],
	"<div>foo<br>{}bar</div>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<dl><dt>[]foo<dd>bar</dl>",
	[["insertlinebreak",""]],
	"<dl><dt><br>{}foo</dt><dd>bar</dd></dl>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<dl><dt>foo[]<dd>bar</dl>",
	[["insertlinebreak",""]],
	"<dl><dt>foo<br>{}<br></dt><dd>bar</dd></dl>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<dl><dt>foo[]<br><dd>bar</dl>",
	[["insertlinebreak",""]],
	"<dl><dt>foo<br>{}<br></dt><dd>bar</dd></dl>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<dl><dt>foo[]bar<dd>baz</dl>",
	[["insertlinebreak",""]],
	"<dl><dt>foo<br>{}bar</dt><dd>baz</dd></dl>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<dl><dt>foo<dd>[]bar</dl>",
	[["insertlinebreak",""]],
	"<dl><dt>foo</dt><dd><br>{}bar</dd></dl>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<dl><dt>foo<dd>bar[]</dl>",
	[["insertlinebreak",""]],
	"<dl><dt>foo</dt><dd>bar<br>{}<br></dd></dl>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<dl><dt>foo<dd>bar[]<br></dl>",
	[["insertlinebreak",""]],
	"<dl><dt>foo</dt><dd>bar<br>{}<br></dd></dl>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<dl><dt>foo<dd>bar[]baz</dl>",
	[["insertlinebreak",""]],
	"<dl><dt>foo</dt><dd>bar<br>{}baz</dd></dl>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<h1>[]foo</h1>",
	[["insertlinebreak",""]],
	"<h1><br>{}foo</h1>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<h1>foo[]</h1>",
	[["insertlinebreak",""]],
	"<h1>foo<br>{}<br></h1>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<h1>foo[]<br></h1>",
	[["insertlinebreak",""]],
	"<h1>foo<br>{}<br></h1>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<h1>foo[]bar</h1>",
	[["insertlinebreak",""]],
	"<h1>foo<br>{}bar</h1>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<ol><li>[]foo</ol>",
	[["insertlinebreak",""]],
	"<ol><li><br>{}foo</li></ol>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<ol><li>foo[]</ol>",
	[["insertlinebreak",""]],
	"<ol><li>foo<br>{}<br></li></ol>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<ol><li>foo[]<br></ol>",
	[["insertlinebreak",""]],
	"<ol><li>foo<br>{}<br></li></ol>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<ol><li>foo[]bar</ol>",
	[["insertlinebreak",""]],
	"<ol><li>foo<br>{}bar</li></ol>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<p>[]foo</p>",
	[["insertlinebreak",""]],
	"<p><br>{}foo</p>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<p>foo[]</p>",
	[["insertlinebreak",""]],
	"<p>foo<br>{}<br></p>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<p>foo[]<br></p>",
	[["insertlinebreak",""]],
	"<p>foo<br>{}<br></p>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<p>foo[]bar</p>",
	[["insertlinebreak",""]],
	"<p>foo<br>{}bar</p>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<pre>[]foo</pre>",
	[["insertlinebreak",""]],
	"<pre><br>{}foo</pre>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<pre>foo[]</pre>",
	[["insertlinebreak",""]],
	"<pre>foo<br>{}<br></pre>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<pre>foo[]<br></pre>",
	[["insertlinebreak",""]],
	"<pre>foo<br>{}<br></pre>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<pre>foo[]bar</pre>",
	[["insertlinebreak",""]],
	"<pre>foo<br>{}bar</pre>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<pre>foo[]<br><br></pre>",
	[["insertlinebreak",""]],
	"<pre>foo<br>{}<br><br></pre>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<pre>foo<br>{}<br></pre>",
	[["insertlinebreak",""]],
	"<pre>foo<br><br>{}<br></pre>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<pre>foo&#10;[]</pre>",
	[["insertlinebreak",""]],
	"<pre>foo\n<br>{}<br></pre>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<pre>foo[]&#10;</pre>",
	[["insertlinebreak",""]],
	"<pre>foo<br>{}\n</pre>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<pre>foo&#10;[]&#10;</pre>",
	[["insertlinebreak",""]],
	"<pre>foo\n<br>{}\n</pre>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<xmp>foo[]bar</xmp>",
	[["insertlinebreak",""]],
	"<xmp>foo[]bar</xmp>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<script>foo[]bar</script>baz",
	[["insertlinebreak",""]],
	"<script>foo[]bar</script>baz",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<listing>foo[]bar</listing>",
	[["insertlinebreak",""]],
	"<listing>foo<br>{}bar</listing>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<ol><li>{}<br></li></ol>",
	[["insertlinebreak",""]],
	"<ol><li><br>{}<br></li></ol>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["foo<ol><li>{}<br></li></ol>",
	[["insertlinebreak",""]],
	"foo<ol><li><br>{}<br></li></ol>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<ol><li>{}<br></li></ol>foo",
	[["insertlinebreak",""]],
	"<ol><li><br>{}<br></li></ol>foo",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<ol><li>foo<li>{}<br></ol>",
	[["insertlinebreak",""]],
	"<ol><li>foo</li><li><br>{}<br></li></ol>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<ol><li>{}<br><li>bar</ol>",
	[["insertlinebreak",""]],
	"<ol><li><br>{}<br></li><li>bar</li></ol>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ul><li>{}<br></ul></ol>",
	[["insertlinebreak",""]],
	"<ol><li>foo</li><ul><li><br>{}<br></li></ul></ol>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<dl><dt>{}<br></dt></dl>",
	[["insertlinebreak",""]],
	"<dl><dt><br>{}<br></dt></dl>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<dl><dt>foo<dd>{}<br></dl>",
	[["insertlinebreak",""]],
	"<dl><dt>foo</dt><dd><br>{}<br></dd></dl>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<dl><dt>{}<br><dd>bar</dl>",
	[["insertlinebreak",""]],
	"<dl><dt><br>{}<br></dt><dd>bar</dd></dl>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<dl><dt>foo<dd>bar<dl><dt>{}<br><dd>baz</dl></dl>",
	[["insertlinebreak",""]],
	"<dl><dt>foo</dt><dd>bar<dl><dt><br>{}<br></dt><dd>baz</dd></dl></dd></dl>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<dl><dt>foo<dd>bar<dl><dt>baz<dd>{}<br></dl></dl>",
	[["insertlinebreak",""]],
	"<dl><dt>foo</dt><dd>bar<dl><dt>baz</dt><dd><br>{}<br></dd></dl></dd></dl>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<h1>foo[bar</h1><p>baz]quz</p>",
	[["defaultparagraphseparator","div"],["insertlinebreak",""]],
	"<h1>foo<br>{}quz</h1>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertlinebreak":[false,false,"",false,false,""]}],
["<h1>foo[bar</h1><p>baz]quz</p>",
	[["defaultparagraphseparator","p"],["insertlinebreak",""]],
	"<h1>foo<br>{}quz</h1>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertlinebreak":[false,false,"",false,false,""]}],
["<p>foo[bar</p><h1>baz]quz</h1>",
	[["insertlinebreak",""]],
	"<p>foo<br>{}quz</p>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<p>foo</p>{}<br>",
	[["insertlinebreak",""]],
	"<p>foo</p><br>{}<br>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["{}<br><p>foo</p>",
	[["insertlinebreak",""]],
	"<br>{}<br><p>foo</p>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<p>foo</p>{}<br><h1>bar</h1>",
	[["insertlinebreak",""]],
	"<p>foo</p><br>{}<br><h1>bar</h1>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<h1>foo</h1>{}<br><p>bar</p>",
	[["insertlinebreak",""]],
	"<h1>foo</h1><br>{}<br><p>bar</p>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<h1>foo</h1>{}<br><h2>bar</h2>",
	[["insertlinebreak",""]],
	"<h1>foo</h1><br>{}<br><h2>bar</h2>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<p>foo</p><h1>[bar]</h1><p>baz</p>",
	[["insertlinebreak",""]],
	"<p>foo</p><h1><br>{}<br></h1><p>baz</p>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<p>foo</p>{<h1>bar</h1>}<p>baz</p>",
	[["insertlinebreak",""]],
	"<p>foo</p><br>{}<br><p>baz</p>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<table><tr><td>foo[]bar</table>",
	[["insertlinebreak",""]],
	"<table><tbody><tr><td>foo<br>{}bar</td></tr></tbody></table>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<table><tr><td><p>foo[]bar</table>",
	[["insertlinebreak",""]],
	"<table><tbody><tr><td><p>foo<br>{}bar</p></td></tr></tbody></table>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<blockquote>[]foo</blockquote>",
	[["insertlinebreak",""]],
	"<blockquote><br>{}foo</blockquote>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<blockquote>foo[]</blockquote>",
	[["insertlinebreak",""]],
	"<blockquote>foo<br>{}<br></blockquote>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<blockquote>foo[]<br></blockquote>",
	[["insertlinebreak",""]],
	"<blockquote>foo<br>{}<br></blockquote>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<blockquote>foo[]bar</blockquote>",
	[["insertlinebreak",""]],
	"<blockquote>foo<br>{}bar</blockquote>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<blockquote><p>[]foo</blockquote>",
	[["insertlinebreak",""]],
	"<blockquote><p><br>{}foo</p></blockquote>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<blockquote><p>foo[]</blockquote>",
	[["insertlinebreak",""]],
	"<blockquote><p>foo<br>{}<br></p></blockquote>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<blockquote><p>foo[]bar</blockquote>",
	[["insertlinebreak",""]],
	"<blockquote><p>foo<br>{}bar</p></blockquote>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<blockquote><p>foo[]<p>bar</blockquote>",
	[["insertlinebreak",""]],
	"<blockquote><p>foo<br>{}<br></p><p>bar</p></blockquote>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<blockquote><p>foo[]bar<p>baz</blockquote>",
	[["insertlinebreak",""]],
	"<blockquote><p>foo<br>{}bar</p><p>baz</p></blockquote>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<span>foo[]bar</span>",
	[["insertlinebreak",""]],
	"<span>foo<br>{}bar</span>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<span>foo[]bar</span>baz",
	[["insertlinebreak",""]],
	"<span>foo<br>{}bar</span>baz",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<b>foo[]bar</b>",
	[["insertlinebreak",""]],
	"<b>foo<br>{}bar</b>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<b>foo[]bar</b>baz",
	[["insertlinebreak",""]],
	"<b>foo<br>{}bar</b>baz",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<b>foo[]</b>bar",
	[["insertlinebreak",""]],
	"<b>foo<br>{}</b>bar",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["foo<b>[]bar</b>",
	[["insertlinebreak",""]],
	"foo<b><br>{}bar</b>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<b>foo[]</b><i>bar</i>",
	[["insertlinebreak",""]],
	"<b>foo<br>{}</b><i>bar</i>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<b id=x class=y>foo[]bar</b>",
	[["insertlinebreak",""]],
	"<b id=\"x\" class=\"y\">foo<br>{}bar</b>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<i><b>foo[]bar</b>baz</i>",
	[["insertlinebreak",""]],
	"<i><b>foo<br>{}bar</b>baz</i>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<p><b>foo[]bar</b></p>",
	[["insertlinebreak",""]],
	"<p><b>foo<br>{}bar</b></p>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<p><b>[]foo</b></p>",
	[["insertlinebreak",""]],
	"<p><b><br>{}foo</b></p>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<p><b id=x class=y>foo[]bar</b></p>",
	[["insertlinebreak",""]],
	"<p><b id=\"x\" class=\"y\">foo<br>{}bar</b></p>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<div><b>foo[]bar</b></div>",
	[["insertlinebreak",""]],
	"<div><b>foo<br>{}bar</b></div>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<a href=foo>foo[]bar</a>",
	[["insertlinebreak",""]],
	"<a href=\"foo\">foo<br>{}bar</a>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<a href=foo>foo[]bar</a>baz",
	[["insertlinebreak",""]],
	"<a href=\"foo\">foo<br>{}bar</a>baz",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<a href=foo>foo[]</a>bar",
	[["insertlinebreak",""]],
	"<a href=\"foo\">foo<br>{}</a>bar",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["foo<a href=foo>[]bar</a>",
	[["insertlinebreak",""]],
	"foo<a href=\"foo\"><br>{}bar</a>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<p>foo[]<!--bar-->",
	[["insertlinebreak",""]],
	"<p>foo<br>{}<br><!--bar--></p>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<p><!--foo-->[]bar",
	[["insertlinebreak",""]],
	"<p><!--foo--><br>{}bar</p>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar]</span>baz",
	[["insertlinebreak",""]],
	"<p>foo<span style=\"color:rgb(171, 205, 239)\"><br>{}</span>baz</p>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar}</span>baz",
	[["insertlinebreak",""]],
	"<p>foo<span style=\"color:rgb(171, 205, 239)\"><br>{}</span>baz</p>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<p>foo{<span style=color:#aBcDeF>bar</span>}baz",
	[["insertlinebreak",""]],
	"<p>foo<span style=\"color:rgb(171, 205, 239)\"><br>{}</span>baz</p>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<p>[foo<span style=color:#aBcDeF>bar]</span>baz",
	[["stylewithcss","true"],["insertlinebreak",""]],
	"<p><br>{}baz</p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"insertlinebreak":[false,false,"",false,false,""]}],
["<p>[foo<span style=color:#aBcDeF>bar]</span>baz",
	[["stylewithcss","false"],["insertlinebreak",""]],
	"<p><br>{}baz</p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"insertlinebreak":[false,false,"",false,false,""]}],
["<p>{foo<span style=color:#aBcDeF>bar}</span>baz",
	[["stylewithcss","true"],["insertlinebreak",""]],
	"<p><br>{}baz</p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"insertlinebreak":[false,false,"",false,false,""]}],
["<p>{foo<span style=color:#aBcDeF>bar}</span>baz",
	[["stylewithcss","false"],["insertlinebreak",""]],
	"<p><br>{}baz</p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"insertlinebreak":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span>baz]",
	[["insertlinebreak",""]],
	"<p>foo<span style=\"color:rgb(171, 205, 239)\"><br>{}<br></span></p>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar</span>baz}",
	[["insertlinebreak",""]],
	"<p>foo<span style=\"color:rgb(171, 205, 239)\"><br>{}<br></span></p>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span><span style=color:#fEdCbA>baz]</span>quz",
	[["stylewithcss","true"],["insertlinebreak",""]],
	"<p>foo<span style=\"color:rgb(171, 205, 239)\"><br>{}</span>quz</p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"insertlinebreak":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span><span style=color:#fEdCbA>baz]</span>quz",
	[["stylewithcss","false"],["insertlinebreak",""]],
	"<p>foo<span style=\"color:rgb(171, 205, 239)\"><br>{}</span>quz</p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"insertlinebreak":[false,false,"",false,false,""]}],
["<ul contenteditable><li>{}<br></ul>",
	[["insertlinebreak",""]],
	"<ul contenteditable=\"\"><li><br>{}<br></li></ul>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<ul contenteditable><li>foo[]</ul>",
	[["insertlinebreak",""]],
	"<ul contenteditable=\"\"><li>foo<br>{}<br></li></ul>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<div contenteditable=false><ul contenteditable><li>{}<br></ul></div>",
	[["insertlinebreak",""]],
	"<div contenteditable=\"false\"><ul contenteditable=\"\"><li><br>{}<br></li></ul></div>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<div contenteditable=false><ul contenteditable><li>foo[]</ul></div>",
	[["insertlinebreak",""]],
	"<div contenteditable=\"false\"><ul contenteditable=\"\"><li>foo<br>{}<br></li></ul></div>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<address><p>foo[]</address>",
	[["insertlinebreak",""]],
	"<address><p>foo<br>{}<br></p></address>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<dl><dt><p>foo[]</dl>",
	[["insertlinebreak",""]],
	"<dl><dt><p>foo<br>{}<br></p></dt></dl>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<dl><dd><p>foo[]</dl>",
	[["insertlinebreak",""]],
	"<dl><dd><p>foo<br>{}<br></p></dd></dl>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<ol><li><p>foo[]</ol>",
	[["insertlinebreak",""]],
	"<ol><li><p>foo<br>{}<br></p></li></ol>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<ul><li><p>foo[]</ul>",
	[["insertlinebreak",""]],
	"<ul><li><p>foo<br>{}<br></p></li></ul>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<address><div>foo[]</address>",
	[["insertlinebreak",""]],
	"<address><div>foo<br>{}<br></div></address>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<dl><dt><div>foo[]</dl>",
	[["insertlinebreak",""]],
	"<dl><dt><div>foo<br>{}<br></div></dt></dl>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<dl><dd><div>foo[]</dl>",
	[["insertlinebreak",""]],
	"<dl><dd><div>foo<br>{}<br></div></dd></dl>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<ol><li><div>foo[]</ol>",
	[["insertlinebreak",""]],
	"<ol><li><div>foo<br>{}<br></div></li></ol>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<ul><li><div>foo[]</ul>",
	[["insertlinebreak",""]],
	"<ul><li><div>foo<br>{}<br></div></li></ul>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<div><p>foo[]</div>",
	[["insertlinebreak",""]],
	"<div><p>foo<br>{}<br></p></div>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<div><div>foo[]</div>",
	[["insertlinebreak",""]],
	"<div><div>foo<br>{}<br></div></div>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<address><p>[]foo</address>",
	[["insertlinebreak",""]],
	"<address><p><br>{}foo</p></address>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<dl><dt><p>[]foo</dl>",
	[["insertlinebreak",""]],
	"<dl><dt><p><br>{}foo</p></dt></dl>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<dl><dd><p>[]foo</dl>",
	[["insertlinebreak",""]],
	"<dl><dd><p><br>{}foo</p></dd></dl>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<ol><li><p>[]foo</ol>",
	[["insertlinebreak",""]],
	"<ol><li><p><br>{}foo</p></li></ol>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<ul><li><p>[]foo</ul>",
	[["insertlinebreak",""]],
	"<ul><li><p><br>{}foo</p></li></ul>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<address><div>[]foo</address>",
	[["insertlinebreak",""]],
	"<address><div><br>{}foo</div></address>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<dl><dt><div>[]foo</dl>",
	[["insertlinebreak",""]],
	"<dl><dt><div><br>{}foo</div></dt></dl>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<dl><dd><div>[]foo</dl>",
	[["insertlinebreak",""]],
	"<dl><dd><div><br>{}foo</div></dd></dl>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<ol><li><div>[]foo</ol>",
	[["insertlinebreak",""]],
	"<ol><li><div><br>{}foo</div></li></ol>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<ul><li><div>[]foo</ul>",
	[["insertlinebreak",""]],
	"<ul><li><div><br>{}foo</div></li></ul>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<div><p>[]foo</div>",
	[["insertlinebreak",""]],
	"<div><p><br>{}foo</p></div>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<div><div>[]foo</div>",
	[["insertlinebreak",""]],
	"<div><div><br>{}foo</div></div>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<address><p>foo[]bar</address>",
	[["insertlinebreak",""]],
	"<address><p>foo<br>{}bar</p></address>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<dl><dt><p>foo[]bar</dl>",
	[["insertlinebreak",""]],
	"<dl><dt><p>foo<br>{}bar</p></dt></dl>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<dl><dd><p>foo[]bar</dl>",
	[["insertlinebreak",""]],
	"<dl><dd><p>foo<br>{}bar</p></dd></dl>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<ol><li><p>foo[]bar</ol>",
	[["insertlinebreak",""]],
	"<ol><li><p>foo<br>{}bar</p></li></ol>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<ul><li><p>foo[]bar</ul>",
	[["insertlinebreak",""]],
	"<ul><li><p>foo<br>{}bar</p></li></ul>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<address><div>foo[]bar</address>",
	[["insertlinebreak",""]],
	"<address><div>foo<br>{}bar</div></address>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<dl><dt><div>foo[]bar</dl>",
	[["insertlinebreak",""]],
	"<dl><dt><div>foo<br>{}bar</div></dt></dl>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<dl><dd><div>foo[]bar</dl>",
	[["insertlinebreak",""]],
	"<dl><dd><div>foo<br>{}bar</div></dd></dl>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<ol><li><div>foo[]bar</ol>",
	[["insertlinebreak",""]],
	"<ol><li><div>foo<br>{}bar</div></li></ol>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<ul><li><div>foo[]bar</ul>",
	[["insertlinebreak",""]],
	"<ul><li><div>foo<br>{}bar</div></li></ul>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<div><p>foo[]bar</div>",
	[["insertlinebreak",""]],
	"<div><p>foo<br>{}bar</p></div>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<div><div>foo[]bar</div>",
	[["insertlinebreak",""]],
	"<div><div>foo<br>{}bar</div></div>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<ol><li class=a id=x><p class=b id=y>foo[]</ol>",
	[["insertlinebreak",""]],
	"<ol><li class=\"a\" id=\"x\"><p class=\"b\" id=\"y\">foo<br>{}<br></p></li></ol>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<div class=a id=x><div class=b id=y>foo[]</div></div>",
	[["insertlinebreak",""]],
	"<div class=\"a\" id=\"x\"><div class=\"b\" id=\"y\">foo<br>{}<br></div></div>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<div class=a id=x><p class=b id=y>foo[]</div>",
	[["insertlinebreak",""]],
	"<div class=\"a\" id=\"x\"><p class=\"b\" id=\"y\">foo<br>{}<br></p></div>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<ol><li class=a id=x><p class=b id=y>[]foo</ol>",
	[["insertlinebreak",""]],
	"<ol><li class=\"a\" id=\"x\"><p class=\"b\" id=\"y\"><br>{}foo</p></li></ol>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<div class=a id=x><div class=b id=y>[]foo</div></div>",
	[["insertlinebreak",""]],
	"<div class=\"a\" id=\"x\"><div class=\"b\" id=\"y\"><br>{}foo</div></div>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<div class=a id=x><p class=b id=y>[]foo</div>",
	[["insertlinebreak",""]],
	"<div class=\"a\" id=\"x\"><p class=\"b\" id=\"y\"><br>{}foo</p></div>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<ol><li class=a id=x><p class=b id=y>foo[]bar</ol>",
	[["insertlinebreak",""]],
	"<ol><li class=\"a\" id=\"x\"><p class=\"b\" id=\"y\">foo<br>{}bar</p></li></ol>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<div class=a id=x><div class=b id=y>foo[]bar</div></div>",
	[["insertlinebreak",""]],
	"<div class=\"a\" id=\"x\"><div class=\"b\" id=\"y\">foo<br>{}bar</div></div>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["<div class=a id=x><p class=b id=y>foo[]bar</div>",
	[["insertlinebreak",""]],
	"<div class=\"a\" id=\"x\"><p class=\"b\" id=\"y\">foo<br>{}bar</p></div>",
	[true],
	{"insertlinebreak":[false,false,"",false,false,""]}],
["foo[]bar",
	[["insertorderedlist",""]],
	"<ol><li>foo[]bar</li></ol>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["foo[bar]baz",
	[["insertorderedlist",""]],
	"<ol><li>foo[bar]baz</li></ol>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["foo<br>[bar]",
	[["insertorderedlist",""]],
	"foo<ol><li>[bar]</li></ol>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["f[oo<br>b]ar<br>baz",
	[["insertorderedlist",""]],
	"<ol><li>f[oo</li><li>b]ar</li></ol>baz",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<p>[foo]<br>bar</p>",
	[["insertorderedlist",""]],
	"<ol><li>[foo]</li></ol><p>bar</p>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["[foo<ol><li>bar]</ol>baz",
	[["insertorderedlist",""]],
	"<ol><li>[foo</li><li>bar]</li></ol>baz",
	[true],
	{"insertorderedlist":[true,false,"",false,true,""]}],
["foo<ol><li>[bar</ol>baz]",
	[["insertorderedlist",""]],
	"foo<ol><li>[bar</li><li>baz]</li></ol>",
	[true],
	{"insertorderedlist":[true,false,"",false,true,""]}],
["[foo<ul><li>bar]</ul>baz",
	[["insertorderedlist",""]],
	"<ol><li>[foo</li><li>bar]</li></ol>baz",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["foo<ul><li>[bar</ul>baz]",
	[["insertorderedlist",""]],
	"foo<ol><li>[bar</li><li>baz]</li></ol>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["foo<ul><li>[bar</ul><ol><li>baz]</ol>quz",
	[["insertorderedlist",""]],
	"foo<ol><li>[bar</li><li>baz]</li></ol>quz",
	[true],
	{"insertorderedlist":[true,false,"",false,true,""]}],
["foo<ol><li>[bar</ol><ul><li>baz]</ul>quz",
	[["insertorderedlist",""]],
	"foo<ol><li>[bar</li><li>baz]</li></ol>quz",
	[true],
	{"insertorderedlist":[true,false,"",false,true,""]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
	[["insertorderedlist",""]],
	"<table><tbody><tr><td>foo</td><td><ol><li>b[a]r</li></ol></td><td>baz</td></tr></tbody></table>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<table><tbody><tr><td>fo[o<td>b]ar<td>baz</table>",
	[["insertorderedlist",""]],
	"<table><tbody><tr><td><ol><li>fo[o</li></ol></td><td><ol><li>b]ar</li></ol></td><td>baz</td></tr></tbody></table>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
	[["insertorderedlist",""]],
	"<ol><li>{<table><tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody></table>}</li></ol>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<p>foo<p>[bar]<p>baz",
	[["defaultparagraphseparator","div"],["insertorderedlist",""]],
	"<p>foo</p><ol><li>[bar]</li></ol><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,false,"",false,true,""]}],
["<p>foo<p>[bar]<p>baz",
	[["defaultparagraphseparator","p"],["insertorderedlist",""]],
	"<p>foo</p><ol><li>[bar]</li></ol><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,false,"",false,true,""]}],
["<p>foo<blockquote>[bar]</blockquote><p>baz",
	[["insertorderedlist",""]],
	"<p>foo</p><blockquote><ol><li>[bar]</li></ol></blockquote><p>baz</p>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<dl><dt>foo<dd>[bar]<dt>baz<dd>quz</dl>",
	[["insertorderedlist",""]],
	"<dl><dt>foo</dt><dd><ol><li>[bar]</li></ol></dd><dt>baz</dt><dd>quz</dd></dl>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<dl><dt>foo<dd>bar<dt>[baz]<dd>quz</dl>",
	[["insertorderedlist",""]],
	"<dl><dt>foo</dt><dd>bar</dd><dt><ol><li>[baz]</li></ol></dt><dd>quz</dd></dl>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<p>[foo<p>bar]<p>baz",
	[["defaultparagraphseparator","div"],["insertorderedlist",""]],
	"<ol><li>[foo</li><li>bar]</li></ol><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,false,"",false,true,""]}],
["<p>[foo<p>bar]<p>baz",
	[["defaultparagraphseparator","p"],["insertorderedlist",""]],
	"<ol><li>[foo</li><li>bar]</li></ol><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,false,"",false,true,""]}],
["<p>[foo<blockquote>bar]</blockquote><p>baz",
	[["defaultparagraphseparator","div"],["insertorderedlist",""]],
	"<ol><li>[foo</li><ol><li>bar]</li></ol></ol><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,false,"",false,true,""]}],
["<p>[foo<blockquote>bar]</blockquote><p>baz",
	[["defaultparagraphseparator","p"],["insertorderedlist",""]],
	"<ol><li>[foo</li><ol><li>bar]</li></ol></ol><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,false,"",false,true,""]}],
["<dl><dt>[foo<dd>bar]<dt>baz<dd>quz</dl>",
	[["insertorderedlist",""]],
	"<dl><dt><ol><li>[foo</li></ol></dt><dd><ol><li>bar]</li></ol></dd><dt>baz</dt><dd>quz</dd></dl>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<dl><dt>foo<dd>[bar<dt>baz]<dd>quz</dl>",
	[["insertorderedlist",""]],
	"<dl><dt>foo</dt><dd><ol><li>[bar</li></ol></dd><dt><ol><li>baz]</li></ol></dt><dd>quz</dd></dl>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<p>[foo<blockquote><p>bar]<p>baz</blockquote>",
	[["defaultparagraphseparator","div"],["insertorderedlist",""]],
	"<ol><li>[foo</li><ol><li>bar]</li></ol></ol><blockquote><p>baz</p></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,false,"",false,true,""]}],
["<p>[foo<blockquote><p>bar]<p>baz</blockquote>",
	[["defaultparagraphseparator","p"],["insertorderedlist",""]],
	"<ol><li>[foo</li><ol><li>bar]</li></ol></ol><blockquote><p>baz</p></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo<li>[bar]<li>baz</ol>",
	[["defaultparagraphseparator","div"],["insertorderedlist",""]],
	"<ol><li>foo</li></ol><div>[bar]</div><ol><li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>foo<li>[bar]<li>baz</ol>",
	[["defaultparagraphseparator","p"],["insertorderedlist",""]],
	"<ol><li>foo</li></ol><p>[bar]</p><ol><li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>foo</ol>[bar]",
	[["insertorderedlist",""]],
	"<ol><li>foo</li><li>[bar]</li></ol>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["[foo]<ol><li>bar</ol>",
	[["insertorderedlist",""]],
	"<ol><li>[foo]</li><li>bar</li></ol>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</ol>[bar]<ol><li>baz</ol>",
	[["insertorderedlist",""]],
	"<ol><li>foo</li><li>[bar]</li><li>baz</li></ol>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<ol><ol><li>[foo]</ol></ol>",
	[["insertorderedlist",""]],
	"<ol><li>[foo]</li></ol>",
	[true],
	{"insertorderedlist":[false,true,"",false,true,""]}],
["<ol><li>[foo]<br>bar<li>baz</ol>",
	[["defaultparagraphseparator","div"],["insertorderedlist",""]],
	"<div>[foo]<br>bar</div><ol><li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>[foo]<br>bar<li>baz</ol>",
	[["defaultparagraphseparator","p"],["insertorderedlist",""]],
	"<p>[foo]<br>bar</p><ol><li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>foo<br>[bar]<li>baz</ol>",
	[["defaultparagraphseparator","div"],["insertorderedlist",""]],
	"<div>foo<br>[bar]</div><ol><li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>foo<br>[bar]<li>baz</ol>",
	[["defaultparagraphseparator","p"],["insertorderedlist",""]],
	"<p>foo<br>[bar]</p><ol><li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li><div>[foo]</div>bar<li>baz</ol>",
	[["defaultparagraphseparator","div"],["insertorderedlist",""]],
	"<div>[foo]</div><div>bar</div><ol><li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li><div>[foo]</div>bar<li>baz</ol>",
	[["defaultparagraphseparator","p"],["insertorderedlist",""]],
	"<div>[foo]</div><p>bar</p><ol><li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>foo<ol><li>[bar]<li>baz</ol><li>quz</ol>",
	[["insertorderedlist",""]],
	"<ol><li>foo</li><li>[bar]</li><ol><li>baz</li></ol><li>quz</li></ol>",
	[true],
	{"insertorderedlist":[false,true,"",false,true,""]}],
["<ol><li>foo<ol><li>bar<li>[baz]</ol><li>quz</ol>",
	[["insertorderedlist",""]],
	"<ol><li>foo</li><ol><li>bar</li></ol><li>[baz]</li><li>quz</li></ol>",
	[true],
	{"insertorderedlist":[false,true,"",false,true,""]}],
["<ol><li>foo</li><ol><li>[bar]<li>baz</ol><li>quz</ol>",
	[["insertorderedlist",""]],
	"<ol><li>foo</li><li>[bar]</li><ol><li>baz</li></ol><li>quz</li></ol>",
	[true],
	{"insertorderedlist":[false,true,"",false,true,""]}],
["<ol><li>foo</li><ol><li>bar<li>[baz]</ol><li>quz</ol>",
	[["insertorderedlist",""]],
	"<ol><li>foo</li><ol><li>bar</li></ol><li>[baz]</li><li>quz</li></ol>",
	[true],
	{"insertorderedlist":[false,true,"",false,true,""]}],
["<ol><li>[foo]<ol><li>bar</ol><li>baz</ol>",
	[["defaultparagraphseparator","div"],["insertorderedlist",""]],
	"<div>[foo]</div><ol><ol><li>bar</li></ol><li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>[foo]<ol><li>bar</ol><li>baz</ol>",
	[["defaultparagraphseparator","p"],["insertorderedlist",""]],
	"<p>[foo]</p><ol><ol><li>bar</li></ol><li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>[foo]</li><ol><li>bar</ol><li>baz</ol>",
	[["defaultparagraphseparator","div"],["insertorderedlist",""]],
	"<div>[foo]</div><ol><ol><li>bar</li></ol><li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>[foo]</li><ol><li>bar</ol><li>baz</ol>",
	[["defaultparagraphseparator","p"],["insertorderedlist",""]],
	"<p>[foo]</p><ol><ol><li>bar</li></ol><li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>foo<li>[bar]<ol><li>baz</ol><li>quz</ol>",
	[["defaultparagraphseparator","div"],["insertorderedlist",""]],
	"<ol><li>foo</li></ol><div>[bar]</div><ol><ol><li>baz</li></ol><li>quz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>foo<li>[bar]<ol><li>baz</ol><li>quz</ol>",
	[["defaultparagraphseparator","p"],["insertorderedlist",""]],
	"<ol><li>foo</li></ol><p>[bar]</p><ol><ol><li>baz</li></ol><li>quz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>foo<li>[bar]</li><ol><li>baz</ol><li>quz</ol>",
	[["defaultparagraphseparator","div"],["insertorderedlist",""]],
	"<ol><li>foo</li></ol><div>[bar]</div><ol><ol><li>baz</li></ol><li>quz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>foo<li>[bar]</li><ol><li>baz</ol><li>quz</ol>",
	[["defaultparagraphseparator","p"],["insertorderedlist",""]],
	"<ol><li>foo</li></ol><p>[bar]</p><ol><ol><li>baz</li></ol><li>quz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>foo<ol><li>bar<li>baz</ol><li>[quz]</ol>",
	[["defaultparagraphseparator","div"],["insertorderedlist",""]],
	"<ol><li>foo<ol><li>bar</li><li>baz</li></ol></li></ol><div>[quz]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>foo<ol><li>bar<li>baz</ol><li>[quz]</ol>",
	[["defaultparagraphseparator","p"],["insertorderedlist",""]],
	"<ol><li>foo<ol><li>bar</li><li>baz</li></ol></li></ol><p>[quz]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>foo</li><ol><li>bar<li>baz</ol><li>[quz]</ol>",
	[["defaultparagraphseparator","div"],["insertorderedlist",""]],
	"<ol><li>foo</li><ol><li>bar</li><li>baz</li></ol></ol><div>[quz]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>foo</li><ol><li>bar<li>baz</ol><li>[quz]</ol>",
	[["defaultparagraphseparator","p"],["insertorderedlist",""]],
	"<ol><li>foo</li><ol><li>bar</li><li>baz</li></ol></ol><p>[quz]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>foo<li>[bar<li>baz]</ol>",
	[["defaultparagraphseparator","div"],["insertorderedlist",""]],
	"<ol><li>foo</li></ol><div>[bar</div><div>baz]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>foo<li>[bar<li>baz]</ol>",
	[["defaultparagraphseparator","p"],["insertorderedlist",""]],
	"<ol><li>foo</li></ol><p>[bar</p><p>baz]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>[foo<ol><li>bar]</ol><li>baz</ol>",
	[["defaultparagraphseparator","div"],["insertorderedlist",""]],
	"<div>[foo</div><ol><li>bar]</li><li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,true,"",true,false,""]}],
["<ol><li>[foo<ol><li>bar]</ol><li>baz</ol>",
	[["defaultparagraphseparator","p"],["insertorderedlist",""]],
	"<p>[foo</p><ol><li>bar]</li><li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,true,"",true,false,""]}],
["<ol><li>foo<ol><li>b[ar</ol><li>b]az</ol>",
	[["defaultparagraphseparator","div"],["insertorderedlist",""]],
	"<ol><li>foo</li><li>b[ar</li></ol><div>b]az</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,true,"",true,false,""]}],
["<ol><li>foo<ol><li>b[ar</ol><li>b]az</ol>",
	[["defaultparagraphseparator","p"],["insertorderedlist",""]],
	"<ol><li>foo</li><li>b[ar</li></ol><p>b]az</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,true,"",true,false,""]}],
["<ol><li>[foo<ol><li>bar</ol><li>baz]</ol><p>extra",
	[["defaultparagraphseparator","div"],["insertorderedlist",""]],
	"<div>[foo</div><ol><li>bar</li></ol><div>baz]</div><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,true,"",true,false,""]}],
["<ol><li>[foo<ol><li>bar</ol><li>baz]</ol><p>extra",
	[["defaultparagraphseparator","p"],["insertorderedlist",""]],
	"<p>[foo</p><ol><li>bar</li></ol><p>baz]</p><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,true,"",true,false,""]}],
["<ol><li>[foo]<ol><li>bar</ol>baz</ol>",
	[["defaultparagraphseparator","div"],["insertorderedlist",""]],
	"<div>[foo]</div><ol><ol><li>bar</li></ol><li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>[foo]<ol><li>bar</ol>baz</ol>",
	[["defaultparagraphseparator","p"],["insertorderedlist",""]],
	"<p>[foo]</p><ol><ol><li>bar</li></ol><li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>foo<ol><li>[bar]</ol>baz</ol>",
	[["insertorderedlist",""]],
	"<ol><li>foo</li><li>[bar]</li><li>baz</li></ol>",
	[true],
	{"insertorderedlist":[false,true,"",false,true,""]}],
["<ol><li>foo<ol><li>bar</ol>[baz]</ol>",
	[["defaultparagraphseparator","div"],["insertorderedlist",""]],
	"<ol><li>foo</li><ol><li>bar</li></ol></ol><div>[baz]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>foo<ol><li>bar</ol>[baz]</ol>",
	[["defaultparagraphseparator","p"],["insertorderedlist",""]],
	"<ol><li>foo</li><ol><li>bar</li></ol></ol><p>[baz]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>[foo<ol><li>bar]</ol>baz</ol>",
	[["defaultparagraphseparator","div"],["insertorderedlist",""]],
	"<div>[foo</div><ol><li>bar]</li><li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,true,"",true,false,""]}],
["<ol><li>[foo<ol><li>bar]</ol>baz</ol>",
	[["defaultparagraphseparator","p"],["insertorderedlist",""]],
	"<p>[foo</p><ol><li>bar]</li><li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,true,"",true,false,""]}],
["<ul><li>foo<li>[bar]<li>baz</ul>",
	[["insertorderedlist",""]],
	"<ul><li>foo</li></ul><ol><li>[bar]</li></ol><ul><li>baz</li></ul>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo</ul>[bar]",
	[["insertorderedlist",""]],
	"<ul><li>foo</li></ul><ol><li>[bar]</li></ol>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["[foo]<ul><li>bar</ul>",
	[["insertorderedlist",""]],
	"<ol><li>[foo]</li></ol><ul><li>bar</li></ul>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo</ul>[bar]<ul><li>baz</ul>",
	[["insertorderedlist",""]],
	"<ul><li>foo</li></ul><ol><li>[bar]</li></ol><ul><li>baz</li></ul>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><ul><li>[foo]</ul></ul>",
	[["insertorderedlist",""]],
	"<ol><ol><li>[foo]</li></ol></ol>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>[foo]<br>bar<li>baz</ul>",
	[["insertorderedlist",""]],
	"<ol><li>[foo]<br>bar</li></ol><ul><li>baz</li></ul>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo<br>[bar]<li>baz</ul>",
	[["insertorderedlist",""]],
	"<ol><li>foo<br>[bar]</li></ol><ul><li>baz</li></ul>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li><div>[foo]</div>bar<li>baz</ul>",
	[["insertorderedlist",""]],
	"<ol><li><div>[foo]</div>bar</li></ol><ul><li>baz</li></ul>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo<ul><li>[bar]<li>baz</ul><li>quz</ul>",
	[["insertorderedlist",""]],
	"<ul><li>foo</li><ol><li>[bar]</li></ol><ul><li>baz</li></ul><li>quz</li></ul>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo<ul><li>bar<li>[baz]</ul><li>quz</ul>",
	[["insertorderedlist",""]],
	"<ul><li>foo</li><ul><li>bar</li></ul><ol><li>[baz]</li></ol><li>quz</li></ul>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo</li><ul><li>[bar]<li>baz</ul><li>quz</ul>",
	[["insertorderedlist",""]],
	"<ul><li>foo</li><ol><li>[bar]</li></ol><ul><li>baz</li></ul><li>quz</li></ul>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo</li><ul><li>bar<li>[baz]</ul><li>quz</ul>",
	[["insertorderedlist",""]],
	"<ul><li>foo</li><ul><li>bar</li></ul><ol><li>[baz]</li></ol><li>quz</li></ul>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>[foo]<ul><li>bar</ul><li>baz</ul>",
	[["insertorderedlist",""]],
	"<ol><li>[foo]</li></ol><ul><ul><li>bar</li></ul><li>baz</li></ul>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>[foo]</li><ul><li>bar</ul><li>baz</ul>",
	[["insertorderedlist",""]],
	"<ol><li>[foo]</li></ol><ul><ul><li>bar</li></ul><li>baz</li></ul>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo<li>[bar]<ul><li>baz</ul><li>quz</ul>",
	[["insertorderedlist",""]],
	"<ul><li>foo</li></ul><ol><li>[bar]</li></ol><ul><ul><li>baz</li></ul><li>quz</li></ul>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo<li>[bar]</li><ul><li>baz</ul><li>quz</ul>",
	[["insertorderedlist",""]],
	"<ul><li>foo</li></ul><ol><li>[bar]</li></ol><ul><ul><li>baz</li></ul><li>quz</li></ul>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo<ul><li>bar<li>baz</ul><li>[quz]</ul>",
	[["insertorderedlist",""]],
	"<ul><li>foo<ul><li>bar</li><li>baz</li></ul></li></ul><ol><li>[quz]</li></ol>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo</li><ul><li>bar<li>baz</ul><li>[quz]</ul>",
	[["insertorderedlist",""]],
	"<ul><li>foo</li><ul><li>bar</li><li>baz</li></ul></ul><ol><li>[quz]</li></ol>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo<li>[bar<li>baz]</ul>",
	[["insertorderedlist",""]],
	"<ul><li>foo</li></ul><ol><li>[bar</li><li>baz]</li></ol>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>[foo<ul><li>bar]</ul><li>baz</ul>",
	[["insertorderedlist",""]],
	"<ol><li>[foo</li><ol><li>bar]</li></ol></ol><ul><li>baz</li></ul>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo<ul><li>b[ar</ul><li>b]az</ul>",
	[["insertorderedlist",""]],
	"<ul><li>foo</li></ul><ol><ol><li>b[ar</li></ol><li>b]az</li></ol>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>[foo<ul><li>bar</ul><li>baz]</ul><p>extra",
	[["insertorderedlist",""]],
	"<ol><li>[foo</li><ol><li>bar</li></ol><li>baz]</li></ol><p>extra</p>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>[foo]<ul><li>bar</ul>baz</ul>",
	[["insertorderedlist",""]],
	"<ol><li>[foo]</li></ol><ul><ul><li>bar</li></ul><li>baz</li></ul>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo<ul><li>[bar]</ul>baz</ul>",
	[["insertorderedlist",""]],
	"<ul><li>foo</li><ol><li>[bar]</li></ol><li>baz</li></ul>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo<ul><li>bar</ul>[baz]</ul>",
	[["insertorderedlist",""]],
	"<ul><li>foo</li><ul><li>bar</li></ul></ul><ol><li>[baz]</li></ol>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>[foo<ul><li>bar]</ul>baz</ul>",
	[["insertorderedlist",""]],
	"<ol><li>[foo</li><ol><li>bar]</li></ol></ol><ul><li>baz</li></ul>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["foo<ol><li>bar</ol><ul><li>[baz]</ul>quz",
	[["insertorderedlist",""]],
	"foo<ol><li>bar</li><li>[baz]</li></ol>quz",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["foo<ol><li>bar</ol><ul><li>[baz</ul>quz]",
	[["insertorderedlist",""]],
	"foo<ol><li>bar</li><li>[baz</li><li>quz]</li></ol>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["foo<ul><li>[bar]</ul><ol><li>baz</ol>quz",
	[["insertorderedlist",""]],
	"foo<ol><li>[bar]</li><li>baz</li></ol>quz",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["[foo<ul><li>bar]</ul><ol><li>baz</ol>quz",
	[["insertorderedlist",""]],
	"<ol><li>[foo</li><li>bar]</li><li>baz</li></ol>quz",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["[foo]<blockquote>bar</blockquote>baz",
	[["insertorderedlist",""]],
	"<ol><li>[foo]</li></ol><blockquote>bar</blockquote>baz",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["foo<blockquote>[bar]</blockquote>baz",
	[["insertorderedlist",""]],
	"foo<blockquote><ol><li>[bar]</li></ol></blockquote>baz",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["[foo<blockquote>bar]</blockquote>baz",
	[["insertorderedlist",""]],
	"<ol><li>[foo</li><ol><li>bar]</li></ol></ol>baz",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</ol><blockquote>[bar]</blockquote>baz",
	[["insertorderedlist",""]],
	"<ol><li>foo</li><ol><li>[bar]</li></ol></ol>baz",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["[foo]<blockquote><ol><li>bar</ol></blockquote>baz",
	[["insertorderedlist",""]],
	"<ol><li>[foo]</li></ol><blockquote><ol><li>bar</li></ol></blockquote>baz",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["foo<blockquote>[bar]<br>baz</blockquote>",
	[["insertorderedlist",""]],
	"foo<blockquote><ol><li>[bar]</li></ol>baz</blockquote>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["[foo<blockquote>bar]<br>baz</blockquote>",
	[["insertorderedlist",""]],
	"<ol><li>[foo</li><ol><li>bar]</li></ol></ol><blockquote>baz</blockquote>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</ol><blockquote>[bar]<br>baz</blockquote>",
	[["insertorderedlist",""]],
	"<ol><li>foo</li><ol><li>[bar]</li></ol></ol><blockquote>baz</blockquote>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<p>[foo]<blockquote><p>bar</blockquote><p>baz",
	[["defaultparagraphseparator","div"],["insertorderedlist",""]],
	"<ol><li>[foo]</li></ol><blockquote><p>bar</p></blockquote><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,false,"",false,true,""]}],
["<p>[foo]<blockquote><p>bar</blockquote><p>baz",
	[["defaultparagraphseparator","p"],["insertorderedlist",""]],
	"<ol><li>[foo]</li></ol><blockquote><p>bar</p></blockquote><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,false,"",false,true,""]}],
["<p>foo<blockquote><p>[bar]</blockquote><p>baz",
	[["defaultparagraphseparator","div"],["insertorderedlist",""]],
	"<p>foo</p><blockquote><ol><li>[bar]</li></ol></blockquote><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,false,"",false,true,""]}],
["<p>foo<blockquote><p>[bar]</blockquote><p>baz",
	[["defaultparagraphseparator","p"],["insertorderedlist",""]],
	"<p>foo</p><blockquote><ol><li>[bar]</li></ol></blockquote><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,false,"",false,true,""]}],
["<p>[foo<blockquote><p>bar]</blockquote><p>baz",
	[["defaultparagraphseparator","div"],["insertorderedlist",""]],
	"<ol><li>[foo</li><ol><li>bar]</li></ol></ol><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,false,"",false,true,""]}],
["<p>[foo<blockquote><p>bar]</blockquote><p>baz",
	[["defaultparagraphseparator","p"],["insertorderedlist",""]],
	"<ol><li>[foo</li><ol><li>bar]</li></ol></ol><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</ol><blockquote><p>[bar]</blockquote><p>baz",
	[["defaultparagraphseparator","div"],["insertorderedlist",""]],
	"<ol><li>foo</li><ol><li>[bar]</li></ol></ol><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</ol><blockquote><p>[bar]</blockquote><p>baz",
	[["defaultparagraphseparator","p"],["insertorderedlist",""]],
	"<ol><li>foo</li><ol><li>[bar]</li></ol></ol><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,false,"",false,true,""]}],
["<ul id=abc><li>foo<li>[bar]<li>baz</ul>",
	[["insertorderedlist",""]],
	"<ul id=\"abc\"><li>foo</li></ul><ol><li>[bar]</li></ol><ul><li>baz</li></ul>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<ul style=color:blue><li>foo<li>[bar]<li>baz</ul>",
	[["stylewithcss","true"],["insertorderedlist",""]],
	"<ul style=\"color:rgb(0, 0, 255)\"><li>foo</li></ul><ol><li><span style=\"color:rgb(0, 0, 255)\">[bar]</span></li></ol><ul style=\"color:rgb(0, 0, 255)\"><li>baz</li></ul>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"insertorderedlist":[false,false,"",false,true,""]}],
["<ul style=color:blue><li>foo<li>[bar]<li>baz</ul>",
	[["stylewithcss","false"],["insertorderedlist",""]],
	"<ul style=\"color:rgb(0, 0, 255)\"><li>foo</li></ul><ol><li><font color=\"#0000ff\">[bar]</font></li></ol><ul style=\"color:rgb(0, 0, 255)\"><li>baz</li></ul>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"insertorderedlist":[false,false,"",false,true,""]}],
["<ul style=text-indent:1em><li>foo<li>[bar]<li>baz</ul>",
	[["stylewithcss","true"],["insertorderedlist",""]],
	"<ul style=\"text-indent:1em\"><li>foo</li></ul><ol><li>[bar]</li></ol><ul style=\"text-indent:1em\"><li>baz</li></ul>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"insertorderedlist":[false,false,"",false,true,""]}],
["<ul style=text-indent:1em><li>foo<li>[bar]<li>baz</ul>",
	[["stylewithcss","false"],["insertorderedlist",""]],
	"<ul style=\"text-indent:1em\"><li>foo</li></ul><ol><li>[bar]</li></ol><ul style=\"text-indent:1em\"><li>baz</li></ul>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"insertorderedlist":[false,false,"",false,true,""]}],
["<ul id=abc><li>[foo]<li>bar<li>baz</ul>",
	[["insertorderedlist",""]],
	"<ol><li>[foo]</li></ol><ul id=\"abc\"><li>bar</li><li>baz</li></ul>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<ul style=color:blue><li>[foo]<li>bar<li>baz</ul>",
	[["stylewithcss","true"],["insertorderedlist",""]],
	"<ol><li><span style=\"color:rgb(0, 0, 255)\">[foo]</span></li></ol><ul style=\"color:rgb(0, 0, 255)\"><li>bar</li><li>baz</li></ul>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"insertorderedlist":[false,false,"",false,true,""]}],
["<ul style=color:blue><li>[foo]<li>bar<li>baz</ul>",
	[["stylewithcss","false"],["insertorderedlist",""]],
	"<ol><li><font color=\"#0000ff\">[foo]</font></li></ol><ul style=\"color:rgb(0, 0, 255)\"><li>bar</li><li>baz</li></ul>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"insertorderedlist":[false,false,"",false,true,""]}],
["<ul style=text-indent:1em><li>[foo]<li>bar<li>baz</ul>",
	[["insertorderedlist",""]],
	"<ol><li>[foo]</li></ol><ul style=\"text-indent:1em\"><li>bar</li><li>baz</li></ul>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<ul id=abc><li>foo<li>bar<li>[baz]</ul>",
	[["insertorderedlist",""]],
	"<ul id=\"abc\"><li>foo</li><li>bar</li></ul><ol><li>[baz]</li></ol>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<ul style=color:blue><li>foo<li>bar<li>[baz]</ul>",
	[["stylewithcss","true"],["insertorderedlist",""]],
	"<ul style=\"color:rgb(0, 0, 255)\"><li>foo</li><li>bar</li></ul><ol><li><span style=\"color:rgb(0, 0, 255)\">[baz]</span></li></ol>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"insertorderedlist":[false,false,"",false,true,""]}],
["<ul style=color:blue><li>foo<li>bar<li>[baz]</ul>",
	[["stylewithcss","false"],["insertorderedlist",""]],
	"<ul style=\"color:rgb(0, 0, 255)\"><li>foo</li><li>bar</li></ul><ol><li><font color=\"#0000ff\">[baz]</font></li></ol>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"insertorderedlist":[false,false,"",false,true,""]}],
["<ul style=text-indent:1em><li>foo<li>bar<li>[baz]</ul>",
	[["insertorderedlist",""]],
	"<ul style=\"text-indent:1em\"><li>foo</li><li>bar</li></ul><ol><li>[baz]</li></ol>",
	[true],
	{"insertorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</ol> <p>[bar]",
	[["defaultparagraphseparator","div"],["insertorderedlist",""]],
	"<ol><li>foo</li> <li>[bar]</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</ol> <p>[bar]",
	[["defaultparagraphseparator","p"],["insertorderedlist",""]],
	"<ol><li>foo</li> <li>[bar]</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,false,"",false,true,""]}],
["<p>[foo]</p> <ol><li>bar</ol>",
	[["defaultparagraphseparator","div"],["insertorderedlist",""]],
	"<ol><li>[foo]</li> <li>bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,false,"",false,true,""]}],
["<p>[foo]</p> <ol><li>bar</ol>",
	[["defaultparagraphseparator","p"],["insertorderedlist",""]],
	"<ol><li>[foo]</li> <li>bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</ol> <p>[bar]</p> <ol><li>baz</ol>",
	[["defaultparagraphseparator","div"],["insertorderedlist",""]],
	"<ol><li>foo</li> <li>[bar]</li> <li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</ol> <p>[bar]</p> <ol><li>baz</ol>",
	[["defaultparagraphseparator","p"],["insertorderedlist",""]],
	"<ol><li>foo</li> <li>[bar]</li> <li>baz</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,false,"",false,true,""]}],
["foo[bar]baz",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div>foo</div><div>{}baz</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["foo[bar]baz",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p>foo</p><p>{}baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["fo[o<table><tr><td>b]ar</table>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div>fo</div><div>{}<br></div><table><tbody><tr><td>ar</td></tr></tbody></table>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["fo[o<table><tr><td>b]ar</table>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p>fo</p><p>{}<br></p><table><tbody><tr><td>ar</td></tr></tbody></table>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<table><tr><td>[foo<td>bar]<tr><td>baz<td>quz</table>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<table><tbody><tr><td><div><br></div><div>{}<br></div></td><td><br></td></tr><tr><td>baz</td><td>quz</td></tr></tbody></table>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<table><tr><td>[foo<td>bar]<tr><td>baz<td>quz</table>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<table><tbody><tr><td><p><br></p><p>{}<br></p></td><td><br></td></tr><tr><td>baz</td><td>quz</td></tr></tbody></table>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<tr><td>baz<td>quz</table>",
	[["insertparagraph",""]],
	"<table><tbody>{}<tr><td><br></td><td><br></td></tr><tr><td>baz</td><td>quz</td></tr></tbody></table>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<table><tr><td>fo[o</table>b]ar",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<table><tbody><tr><td><div>fo</div><div>{}<br></div></td></tr></tbody></table>ar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<table><tr><td>fo[o</table>b]ar",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<table><tbody><tr><td><p>fo</p><p>{}<br></p></td></tr></tbody></table>ar",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<table><tr><td>fo[o<td>b]ar<td>baz</table>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<table><tbody><tr><td><div>fo</div><div>{}<br></div></td><td>ar</td><td>baz</td></tr></tbody></table>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<table><tr><td>fo[o<td>b]ar<td>baz</table>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<table><tbody><tr><td><p>fo</p><p>{}<br></p></td><td>ar</td><td>baz</td></tr></tbody></table>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["{<table><tr><td>foo</table>}",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div><br></div><div>{}<br></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["{<table><tr><td>foo</table>}",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p><br></p><p>{}<br></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<table><tr><td>[foo]</table>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<table><tbody><tr><td><div><br></div><div>{}<br></div></td></tr></tbody></table>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<table><tr><td>[foo]</table>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<table><tbody><tr><td><p><br></p><p>{}<br></p></td></tr></tbody></table>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>[foo]<li>bar</ol>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div>{}<br></div><ol><li>bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>[foo]<li>bar</ol>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p>{}<br></p><ol><li>bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>f[o]o<li>bar</ol>",
	[["insertparagraph",""]],
	"<ol><li>f</li><li>{}o</li><li>bar</li></ol>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["[]foo",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div><br></div><div>{}foo</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["[]foo",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p><br></p><p>{}foo</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["foo[]",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div>foo</div><div>{}<br></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["foo[]",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p>foo</p><p>{}<br></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<span>foo[]</span>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div><span>foo</span></div><div>{}<br></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<span>foo[]</span>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p><span>foo</span></p><p>{}<br></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["foo[]<br>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div>foo</div><div>{}<br></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["foo[]<br>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p>foo</p><p>{}<br></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["foo[]bar",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div>foo</div><div>{}bar</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["foo[]bar",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p>foo</p><p>{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<address>[]foo</address>",
	[["insertparagraph",""]],
	"<address><br>{}foo</address>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<address>foo[]</address>",
	[["insertparagraph",""]],
	"<address>foo<br>{}<br></address>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<address>foo[]<br></address>",
	[["insertparagraph",""]],
	"<address>foo<br>{}<br></address>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<address>foo[]bar</address>",
	[["insertparagraph",""]],
	"<address>foo<br>{}bar</address>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<div>[]foo</div>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div><br></div><div>{}foo</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div>[]foo</div>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<div><br></div><div>{}foo</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div>foo[]</div>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div>foo</div><div>{}<br></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div>foo[]</div>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<div>foo</div><div>{}<br></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div>foo[]<br></div>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div>foo</div><div>{}<br></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div>foo[]<br></div>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<div>foo</div><div>{}<br></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div>foo[]bar</div>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div>foo</div><div>{}bar</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div>foo[]bar</div>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<div>foo</div><div>{}bar</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt>[]foo<dd>bar</dl>",
	[["insertparagraph",""]],
	"<dl><dt><br></dt><dt>{}foo</dt><dd>bar</dd></dl>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt>foo[]<dd>bar</dl>",
	[["insertparagraph",""]],
	"<dl><dt>foo</dt><dd>{}<br></dd><dd>bar</dd></dl>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt>foo[]<br><dd>bar</dl>",
	[["insertparagraph",""]],
	"<dl><dt>foo</dt><dd>{}<br></dd><dd>bar</dd></dl>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt>foo[]bar<dd>baz</dl>",
	[["insertparagraph",""]],
	"<dl><dt>foo</dt><dt>{}bar</dt><dd>baz</dd></dl>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt>foo<dd>[]bar</dl>",
	[["insertparagraph",""]],
	"<dl><dt>foo</dt><dd><br></dd><dd>{}bar</dd></dl>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt>foo<dd>bar[]</dl>",
	[["insertparagraph",""]],
	"<dl><dt>foo</dt><dd>bar</dd><dt>{}<br></dt></dl>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt>foo<dd>bar[]<br></dl>",
	[["insertparagraph",""]],
	"<dl><dt>foo</dt><dd>bar</dd><dt>{}<br></dt></dl>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt>foo<dd>bar[]baz</dl>",
	[["insertparagraph",""]],
	"<dl><dt>foo</dt><dd>bar</dd><dd>{}baz</dd></dl>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<h1>[]foo</h1>",
	[["insertparagraph",""]],
	"<h1><br></h1><h1>{}foo</h1>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<h1>foo[]</h1>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<h1>foo</h1><div>{}<br></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<h1>foo[]</h1>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<h1>foo</h1><p>{}<br></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<h1>foo[]<br></h1>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<h1>foo</h1><div>{}<br></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<h1>foo[]<br></h1>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<h1>foo</h1><p>{}<br></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<h1>foo[]bar</h1>",
	[["insertparagraph",""]],
	"<h1>foo</h1><h1>{}bar</h1>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>[]foo</ol>",
	[["insertparagraph",""]],
	"<ol><li><br></li><li>{}foo</li></ol>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>foo[]</ol>",
	[["insertparagraph",""]],
	"<ol><li>foo</li><li>{}<br></li></ol>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>foo[]<br></ol>",
	[["insertparagraph",""]],
	"<ol><li>foo</li><li>{}<br></li></ol>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>foo[]bar</ol>",
	[["insertparagraph",""]],
	"<ol><li>foo</li><li>{}bar</li></ol>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<p>[]foo</p>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<p><br></p><p>{}foo</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>[]foo</p>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p><br></p><p>{}foo</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo[]</p>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<p>foo</p><p>{}<br></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo[]</p>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p>foo</p><p>{}<br></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo[]<br></p>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<p>foo</p><p>{}<br></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo[]<br></p>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p>foo</p><p>{}<br></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo[]bar</p>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<p>foo</p><p>{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo[]bar</p>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p>foo</p><p>{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<pre>[]foo</pre>",
	[["insertparagraph",""]],
	"<pre><br>{}foo</pre>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<pre>foo[]</pre>",
	[["insertparagraph",""]],
	"<pre>foo<br>{}<br></pre>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<pre>foo[]<br></pre>",
	[["insertparagraph",""]],
	"<pre>foo<br>{}<br></pre>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<pre>foo[]bar</pre>",
	[["insertparagraph",""]],
	"<pre>foo<br>{}bar</pre>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<pre>foo[]<br><br></pre>",
	[["insertparagraph",""]],
	"<pre>foo<br>{}<br><br></pre>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<pre>foo<br>{}<br></pre>",
	[["insertparagraph",""]],
	"<pre>foo<br><br>{}<br></pre>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<pre>foo&#10;[]</pre>",
	[["insertparagraph",""]],
	"<pre>foo\n<br>{}<br></pre>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<pre>foo[]&#10;</pre>",
	[["insertparagraph",""]],
	"<pre>foo<br>{}\n</pre>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<pre>foo&#10;[]&#10;</pre>",
	[["insertparagraph",""]],
	"<pre>foo\n<br>{}\n</pre>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<xmp>foo[]bar</xmp>",
	[["insertparagraph",""]],
	"<xmp>foo</xmp><xmp>{}bar</xmp>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<script>foo[]bar</script>baz",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div><script>foo</script><br></div><div>{}<script>bar</script>baz</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<script>foo[]bar</script>baz",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p><script>foo</script><br></p><p>{}<script>bar</script>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div style=display:none>foo[]bar</div>baz",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div style=\"display:none\">foo<br></div><div style=\"display:none\">{}bar<br></div>baz",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div style=display:none>foo[]bar</div>baz",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div style=\"display:none\">foo<br></div><div style=\"display:none\">{}bar<br></div>baz",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div style=display:none>foo[]bar</div>baz",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<div style=\"display:none\">foo<br></div><div style=\"display:none\">{}bar<br></div>baz",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div style=display:none>foo[]bar</div>baz",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<div style=\"display:none\">foo<br></div><div style=\"display:none\">{}bar<br></div>baz",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<listing>foo[]bar</listing>",
	[["insertparagraph",""]],
	"<listing>foo<br>{}bar</listing>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>{}<br></li></ol>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div>{}<br></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>{}<br></li></ol>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p>{}<br></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["foo<ol><li>{}<br></li></ol>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"foo<div>{}<br></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["foo<ol><li>{}<br></li></ol>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"foo<p>{}<br></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>{}<br></li></ol>foo",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div>{}<br></div>foo",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>{}<br></li></ol>foo",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p>{}<br></p>foo",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>foo<li>{}<br></ol>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<ol><li>foo</li></ol><div>{}<br></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>foo<li>{}<br></ol>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<ol><li>foo</li></ol><p>{}<br></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>{}<br><li>bar</ol>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div>{}<br></div><ol><li>bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>{}<br><li>bar</ol>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p>{}<br></p><ol><li>bar</li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ul><li>{}<br></ul></ol>",
	[["insertparagraph",""]],
	"<ol><li>foo</li><li>{}<br></li></ol>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt>{}<br></dt></dl>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div>{}<br></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt>{}<br></dt></dl>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p>{}<br></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt>foo<dd>{}<br></dl>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<dl><dt>foo</dt></dl><div>{}<br></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt>foo<dd>{}<br></dl>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<dl><dt>foo</dt></dl><p>{}<br></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt>{}<br><dd>bar</dl>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div>{}<br></div><dl><dd>bar</dd></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt>{}<br><dd>bar</dl>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p>{}<br></p><dl><dd>bar</dd></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt>foo<dd>bar<dl><dt>{}<br><dd>baz</dl></dl>",
	[["insertparagraph",""]],
	"<dl><dt>foo</dt><dd>bar</dd><dt>{}<br></dt><dd><dl><dd>baz</dd></dl></dd></dl>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt>foo<dd>bar<dl><dt>baz<dd>{}<br></dl></dl>",
	[["insertparagraph",""]],
	"<dl><dt>foo</dt><dd>bar<dl><dt>baz</dt></dl></dd><dd>{}<br></dd></dl>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<h1>foo[bar</h1><p>baz]quz</p>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<h1>foo</h1><h1>{}quz</h1>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<h1>foo[bar</h1><p>baz]quz</p>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<h1>foo</h1><h1>{}quz</h1>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo[bar</p><h1>baz]quz</h1>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<p>foo</p><p>{}quz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo[bar</p><h1>baz]quz</h1>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p>foo</p><p>{}quz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo</p>{}<br>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<p>foo</p><div><br></div><div>{}<br></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo</p>{}<br>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p>foo</p><p><br></p><p>{}<br></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["{}<br><p>foo</p>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div><br></div><div>{}<br></div><p>foo</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["{}<br><p>foo</p>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p><br></p><p>{}<br></p><p>foo</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo</p>{}<br><h1>bar</h1>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<p>foo</p><div><br></div><div>{}<br></div><h1>bar</h1>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo</p>{}<br><h1>bar</h1>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p>foo</p><p><br></p><p>{}<br></p><h1>bar</h1>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<h1>foo</h1>{}<br><p>bar</p>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<h1>foo</h1><div><br></div><div>{}<br></div><p>bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<h1>foo</h1>{}<br><p>bar</p>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<h1>foo</h1><p><br></p><p>{}<br></p><p>bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<h1>foo</h1>{}<br><h2>bar</h2>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<h1>foo</h1><div><br></div><div>{}<br></div><h2>bar</h2>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<h1>foo</h1>{}<br><h2>bar</h2>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<h1>foo</h1><p><br></p><p>{}<br></p><h2>bar</h2>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo</p><h1>[bar]</h1><p>baz</p>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<p>foo</p><h1><br></h1><div>{}<br></div><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo</p><h1>[bar]</h1><p>baz</p>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p>foo</p><h1><br></h1><p>{}<br></p><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo</p>{<h1>bar</h1>}<p>baz</p>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<p>foo</p><div>{}<br></div><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo</p>{<h1>bar</h1>}<p>baz</p>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p>foo</p><p>{}<br></p><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<table><tr><td>foo[]bar</table>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<table><tbody><tr><td><div>foo</div><div>{}bar</div></td></tr></tbody></table>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<table><tr><td>foo[]bar</table>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<table><tbody><tr><td><p>foo</p><p>{}bar</p></td></tr></tbody></table>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<table><tr><td><p>foo[]bar</table>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<table><tbody><tr><td><p>foo</p><p>{}bar</p></td></tr></tbody></table>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<table><tr><td><p>foo[]bar</table>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<table><tbody><tr><td><p>foo</p><p>{}bar</p></td></tr></tbody></table>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote>[]foo</blockquote>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<blockquote><div><br></div><div>{}foo</div></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote>[]foo</blockquote>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<blockquote><p><br></p><p>{}foo</p></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote>foo[]</blockquote>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<blockquote><div>foo</div><div>{}<br></div></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote>foo[]</blockquote>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<blockquote><p>foo</p><p>{}<br></p></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote>foo[]<br></blockquote>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<blockquote><div>foo</div><div>{}<br></div></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote>foo[]<br></blockquote>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<blockquote><p>foo</p><p>{}<br></p></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote>foo[]bar</blockquote>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<blockquote><div>foo</div><div>{}bar</div></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote>foo[]bar</blockquote>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<blockquote><p>foo</p><p>{}bar</p></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote><p>[]foo</blockquote>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<blockquote><p><br></p><p>{}foo</p></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote><p>[]foo</blockquote>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<blockquote><p><br></p><p>{}foo</p></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote><p>foo[]</blockquote>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<blockquote><p>foo</p><p>{}<br></p></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote><p>foo[]</blockquote>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<blockquote><p>foo</p><p>{}<br></p></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote><p>foo[]bar</blockquote>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<blockquote><p>foo</p><p>{}bar</p></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote><p>foo[]bar</blockquote>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<blockquote><p>foo</p><p>{}bar</p></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote><p>foo[]<p>bar</blockquote>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<blockquote><p>foo</p><p>{}<br></p><p>bar</p></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote><p>foo[]<p>bar</blockquote>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<blockquote><p>foo</p><p>{}<br></p><p>bar</p></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote><p>foo[]bar<p>baz</blockquote>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<blockquote><p>foo</p><p>{}bar</p><p>baz</p></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<blockquote><p>foo[]bar<p>baz</blockquote>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<blockquote><p>foo</p><p>{}bar</p><p>baz</p></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<span>foo[]bar</span>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div><span>foo</span></div><div>{}<span>bar</span></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<span>foo[]bar</span>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p><span>foo</span></p><p>{}<span>bar</span></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<span>foo[]bar</span>baz",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div><span>foo</span></div><div>{}<span>bar</span>baz</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<span>foo[]bar</span>baz",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p><span>foo</span></p><p>{}<span>bar</span>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<b>foo[]bar</b>",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div><b>foo</b></div><div>{}<b>bar</b></div>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<b>foo[]bar</b>",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div><b>foo</b></div><div>{}<b>bar</b></div>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<b>foo[]bar</b>",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p><b>foo</b></p><p>{}<b>bar</b></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<b>foo[]bar</b>",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p><b>foo</b></p><p>{}<b>bar</b></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<b>foo[]bar</b>baz",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div><b>foo</b></div><div>{}<b>bar</b>baz</div>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<b>foo[]bar</b>baz",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div><b>foo</b></div><div>{}<b>bar</b>baz</div>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<b>foo[]bar</b>baz",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p><b>foo</b></p><p>{}<b>bar</b>baz</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<b>foo[]bar</b>baz",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p><b>foo</b></p><p>{}<b>bar</b>baz</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<b>foo[]</b>bar",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div><b>foo</b></div><div>{}bar</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<b>foo[]</b>bar",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p><b>foo</b></p><p>{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["foo<b>[]bar</b>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div>foo</div><div>{}<b>bar</b></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["foo<b>[]bar</b>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p>foo</p><p>{}<b>bar</b></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<b>foo[]</b><i>bar</i>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div><b>foo</b></div><div>{}<i>bar</i></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<b>foo[]</b><i>bar</i>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p><b>foo</b></p><p>{}<i>bar</i></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<b id=x class=y>foo[]bar</b>",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div><b id=\"x\" class=\"y\">foo</b></div><div>{}<b class=\"y\">bar</b></div>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<b id=x class=y>foo[]bar</b>",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div><b id=\"x\" class=\"y\">foo</b></div><div>{}<b class=\"y\">bar</b></div>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<b id=x class=y>foo[]bar</b>",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p><b id=\"x\" class=\"y\">foo</b></p><p>{}<b class=\"y\">bar</b></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<b id=x class=y>foo[]bar</b>",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p><b id=\"x\" class=\"y\">foo</b></p><p>{}<b class=\"y\">bar</b></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<i><b>foo[]bar</b>baz</i>",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div><i><b>foo</b></i></div><div>{}<i><b>bar</b>baz</i></div>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<i><b>foo[]bar</b>baz</i>",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div><i><b>foo</b></i></div><div>{}<i><b>bar</b>baz</i></div>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<i><b>foo[]bar</b>baz</i>",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p><i><b>foo</b></i></p><p>{}<i><b>bar</b>baz</i></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<i><b>foo[]bar</b>baz</i>",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p><i><b>foo</b></i></p><p>{}<i><b>bar</b>baz</i></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><b>foo[]bar</b></p>",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<p><b>foo</b></p><p>{}<b>bar</b></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><b>foo[]bar</b></p>",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<p><b>foo</b></p><p>{}<b>bar</b></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><b>foo[]bar</b></p>",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p><b>foo</b></p><p>{}<b>bar</b></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><b>foo[]bar</b></p>",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p><b>foo</b></p><p>{}<b>bar</b></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><b>[]foo</b></p>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<p><br></p><p>{}<b>foo</b></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><b>[]foo</b></p>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p><br></p><p>{}<b>foo</b></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><b id=x class=y>foo[]bar</b></p>",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<p><b id=\"x\" class=\"y\">foo</b></p><p>{}<b class=\"y\">bar</b></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><b id=x class=y>foo[]bar</b></p>",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<p><b id=\"x\" class=\"y\">foo</b></p><p>{}<b class=\"y\">bar</b></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><b id=x class=y>foo[]bar</b></p>",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p><b id=\"x\" class=\"y\">foo</b></p><p>{}<b class=\"y\">bar</b></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><b id=x class=y>foo[]bar</b></p>",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p><b id=\"x\" class=\"y\">foo</b></p><p>{}<b class=\"y\">bar</b></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><b>foo[]bar</b></div>",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div><b>foo</b></div><div>{}<b>bar</b></div>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><b>foo[]bar</b></div>",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div><b>foo</b></div><div>{}<b>bar</b></div>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><b>foo[]bar</b></div>",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<div><b>foo</b></div><div>{}<b>bar</b></div>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><b>foo[]bar</b></div>",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<div><b>foo</b></div><div>{}<b>bar</b></div>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<a href=foo>foo[]bar</a>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div><a href=\"foo\">foo</a></div><div>{}<a href=\"foo\">bar</a></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<a href=foo>foo[]bar</a>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p><a href=\"foo\">foo</a></p><p>{}<a href=\"foo\">bar</a></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<a href=foo>foo[]bar</a>baz",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div><a href=\"foo\">foo</a></div><div>{}<a href=\"foo\">bar</a>baz</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<a href=foo>foo[]bar</a>baz",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p><a href=\"foo\">foo</a></p><p>{}<a href=\"foo\">bar</a>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<a href=foo>foo[]</a>bar",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div><a href=\"foo\">foo</a></div><div>{}bar</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<a href=foo>foo[]</a>bar",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p><a href=\"foo\">foo</a></p><p>{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["foo<a href=foo>[]bar</a>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div>foo</div><div>{}<a href=\"foo\">bar</a></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["foo<a href=foo>[]bar</a>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p>foo</p><p>{}<a href=\"foo\">bar</a></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo[]<!--bar-->",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<p>foo</p><p>{}<!--bar--><br></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo[]<!--bar-->",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p>foo</p><p>{}<!--bar--><br></p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><!--foo-->[]bar",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<p><!--foo--><br></p><p>{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p><!--foo-->[]bar",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p><!--foo--><br></p><p>{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar]</span>baz",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<p>foo</p><p>{}baz</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar]</span>baz",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<p>foo</p><p>{}baz</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar]</span>baz",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p>foo</p><p>{}baz</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar]</span>baz",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p>foo</p><p>{}baz</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar}</span>baz",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<p>foo</p><p>{}baz</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar}</span>baz",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<p>foo</p><p>{}baz</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar}</span>baz",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p>foo</p><p>{}baz</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar}</span>baz",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p>foo</p><p>{}baz</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo{<span style=color:#aBcDeF>bar</span>}baz",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<p>foo</p><p>{}baz</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo{<span style=color:#aBcDeF>bar</span>}baz",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<p>foo</p><p>{}baz</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo{<span style=color:#aBcDeF>bar</span>}baz",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p>foo</p><p>{}baz</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo{<span style=color:#aBcDeF>bar</span>}baz",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p>foo</p><p>{}baz</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>[foo<span style=color:#aBcDeF>bar]</span>baz",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<p><br></p><p>{}baz</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>[foo<span style=color:#aBcDeF>bar]</span>baz",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<p><br></p><p>{}baz</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>[foo<span style=color:#aBcDeF>bar]</span>baz",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p><br></p><p>{}baz</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>[foo<span style=color:#aBcDeF>bar]</span>baz",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p><br></p><p>{}baz</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>{foo<span style=color:#aBcDeF>bar}</span>baz",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<p><br></p><p>{}baz</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>{foo<span style=color:#aBcDeF>bar}</span>baz",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<p><br></p><p>{}baz</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>{foo<span style=color:#aBcDeF>bar}</span>baz",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p><br></p><p>{}baz</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>{foo<span style=color:#aBcDeF>bar}</span>baz",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p><br></p><p>{}baz</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span>baz]",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<p>foo</p><p>{}<br></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span>baz]",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<p>foo</p><p>{}<br></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span>baz]",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p>foo</p><p>{}<br></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span>baz]",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p>foo</p><p>{}<br></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar</span>baz}",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<p>foo</p><p>{}<br></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar</span>baz}",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<p>foo</p><p>{}<br></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar</span>baz}",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p>foo</p><p>{}<br></p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar</span>baz}",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p>foo</p><p>{}<br></p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span><span style=color:#fEdCbA>baz]</span>quz",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<p>foo</p><p>{}quz</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span><span style=color:#fEdCbA>baz]</span>quz",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<p>foo</p><p>{}quz</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span><span style=color:#fEdCbA>baz]</span>quz",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p>foo</p><p>{}quz</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span><span style=color:#fEdCbA>baz]</span>quz",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<p>foo</p><p>{}quz</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ul contenteditable><li>{}<br></ul>",
	[["insertparagraph",""]],
	"<ul contenteditable=\"\"><li>{}<br></li></ul>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<ul contenteditable><li>foo[]</ul>",
	[["insertparagraph",""]],
	"<ul contenteditable=\"\"><li>foo</li><li>{}<br></li></ul>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<div contenteditable=false><ul contenteditable><li>{}<br></ul></div>",
	[["insertparagraph",""]],
	"<div contenteditable=\"false\"><ul contenteditable=\"\"><li>{}<br></li></ul></div>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<div contenteditable=false><ul contenteditable><li>foo[]</ul></div>",
	[["insertparagraph",""]],
	"<div contenteditable=\"false\"><ul contenteditable=\"\"><li>foo</li><li>{}<br></li></ul></div>",
	[true],
	{"insertparagraph":[false,false,"",false,false,""]}],
["<address><p>foo[]</address>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<address><p>foo</p><p>{}<br></p></address>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<address><p>foo[]</address>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<address><p>foo</p><p>{}<br></p></address>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt><p>foo[]</dl>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<dl><dt><p>foo</p></dt><dd><p>{}<br></p></dd></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt><p>foo[]</dl>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<dl><dt><p>foo</p></dt><dd><p>{}<br></p></dd></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dd><p>foo[]</dl>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<dl><dd><p>foo</p></dd><dt><p>{}<br></p></dt></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dd><p>foo[]</dl>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<dl><dd><p>foo</p></dd><dt><p>{}<br></p></dt></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li><p>foo[]</ol>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<ol><li><p>foo</p></li><li><p>{}<br></p></li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li><p>foo[]</ol>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<ol><li><p>foo</p></li><li><p>{}<br></p></li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ul><li><p>foo[]</ul>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<ul><li><p>foo</p></li><li><p>{}<br></p></li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ul><li><p>foo[]</ul>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<ul><li><p>foo</p></li><li><p>{}<br></p></li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<address><div>foo[]</address>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<address><div>foo</div><div>{}<br></div></address>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<address><div>foo[]</address>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<address><div>foo</div><div>{}<br></div></address>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt><div>foo[]</dl>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<dl><dt><div>foo</div></dt><dd><div>{}<br></div></dd></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt><div>foo[]</dl>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<dl><dt><div>foo</div></dt><dd><div>{}<br></div></dd></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dd><div>foo[]</dl>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<dl><dd><div>foo</div></dd><dt><div>{}<br></div></dt></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dd><div>foo[]</dl>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<dl><dd><div>foo</div></dd><dt><div>{}<br></div></dt></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li><div>foo[]</ol>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<ol><li><div>foo</div></li><li><div>{}<br></div></li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li><div>foo[]</ol>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<ol><li><div>foo</div></li><li><div>{}<br></div></li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ul><li><div>foo[]</ul>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<ul><li><div>foo</div></li><li><div>{}<br></div></li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ul><li><div>foo[]</ul>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<ul><li><div>foo</div></li><li><div>{}<br></div></li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><p>foo[]</div>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div><p>foo</p><p>{}<br></p></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><p>foo[]</div>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<div><p>foo</p><p>{}<br></p></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><div>foo[]</div>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div><div>foo</div><div>{}<br></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><div>foo[]</div>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<div><div>foo</div><div>{}<br></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<address><p>[]foo</address>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<address><p><br></p><p>{}foo</p></address>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<address><p>[]foo</address>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<address><p><br></p><p>{}foo</p></address>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt><p>[]foo</dl>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<dl><dt><p><br></p></dt><dt><p>{}foo</p></dt></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt><p>[]foo</dl>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<dl><dt><p><br></p></dt><dt><p>{}foo</p></dt></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dd><p>[]foo</dl>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<dl><dd><p><br></p></dd><dd><p>{}foo</p></dd></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dd><p>[]foo</dl>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<dl><dd><p><br></p></dd><dd><p>{}foo</p></dd></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li><p>[]foo</ol>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<ol><li><p><br></p></li><li><p>{}foo</p></li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li><p>[]foo</ol>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<ol><li><p><br></p></li><li><p>{}foo</p></li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ul><li><p>[]foo</ul>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<ul><li><p><br></p></li><li><p>{}foo</p></li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ul><li><p>[]foo</ul>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<ul><li><p><br></p></li><li><p>{}foo</p></li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<address><div>[]foo</address>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<address><div><br></div><div>{}foo</div></address>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<address><div>[]foo</address>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<address><div><br></div><div>{}foo</div></address>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt><div>[]foo</dl>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<dl><dt><div><br></div></dt><dt><div>{}foo</div></dt></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt><div>[]foo</dl>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<dl><dt><div><br></div></dt><dt><div>{}foo</div></dt></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dd><div>[]foo</dl>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<dl><dd><div><br></div></dd><dd><div>{}foo</div></dd></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dd><div>[]foo</dl>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<dl><dd><div><br></div></dd><dd><div>{}foo</div></dd></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li><div>[]foo</ol>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<ol><li><div><br></div></li><li><div>{}foo</div></li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li><div>[]foo</ol>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<ol><li><div><br></div></li><li><div>{}foo</div></li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ul><li><div>[]foo</ul>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<ul><li><div><br></div></li><li><div>{}foo</div></li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ul><li><div>[]foo</ul>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<ul><li><div><br></div></li><li><div>{}foo</div></li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><p>[]foo</div>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div><p><br></p><p>{}foo</p></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><p>[]foo</div>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<div><p><br></p><p>{}foo</p></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><div>[]foo</div>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div><div><br></div><div>{}foo</div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><div>[]foo</div>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<div><div><br></div><div>{}foo</div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<address><p>foo[]bar</address>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<address><p>foo</p><p>{}bar</p></address>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<address><p>foo[]bar</address>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<address><p>foo</p><p>{}bar</p></address>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt><p>foo[]bar</dl>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<dl><dt><p>foo</p></dt><dt><p>{}bar</p></dt></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt><p>foo[]bar</dl>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<dl><dt><p>foo</p></dt><dt><p>{}bar</p></dt></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dd><p>foo[]bar</dl>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<dl><dd><p>foo</p></dd><dd><p>{}bar</p></dd></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dd><p>foo[]bar</dl>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<dl><dd><p>foo</p></dd><dd><p>{}bar</p></dd></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li><p>foo[]bar</ol>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<ol><li><p>foo</p></li><li><p>{}bar</p></li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li><p>foo[]bar</ol>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<ol><li><p>foo</p></li><li><p>{}bar</p></li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ul><li><p>foo[]bar</ul>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<ul><li><p>foo</p></li><li><p>{}bar</p></li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ul><li><p>foo[]bar</ul>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<ul><li><p>foo</p></li><li><p>{}bar</p></li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<address><div>foo[]bar</address>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<address><div>foo</div><div>{}bar</div></address>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<address><div>foo[]bar</address>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<address><div>foo</div><div>{}bar</div></address>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt><div>foo[]bar</dl>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<dl><dt><div>foo</div></dt><dt><div>{}bar</div></dt></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dt><div>foo[]bar</dl>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<dl><dt><div>foo</div></dt><dt><div>{}bar</div></dt></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dd><div>foo[]bar</dl>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<dl><dd><div>foo</div></dd><dd><div>{}bar</div></dd></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<dl><dd><div>foo[]bar</dl>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<dl><dd><div>foo</div></dd><dd><div>{}bar</div></dd></dl>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li><div>foo[]bar</ol>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<ol><li><div>foo</div></li><li><div>{}bar</div></li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li><div>foo[]bar</ol>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<ol><li><div>foo</div></li><li><div>{}bar</div></li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ul><li><div>foo[]bar</ul>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<ul><li><div>foo</div></li><li><div>{}bar</div></li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ul><li><div>foo[]bar</ul>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<ul><li><div>foo</div></li><li><div>{}bar</div></li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><p>foo[]bar</div>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div><p>foo</p><p>{}bar</p></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><p>foo[]bar</div>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<div><p>foo</p><p>{}bar</p></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><div>foo[]bar</div>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div><div>foo</div><div>{}bar</div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div><div>foo[]bar</div>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<div><div>foo</div><div>{}bar</div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li class=a id=x><p class=b id=y>foo[]</ol>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<ol><li class=\"a\" id=\"x\"><p class=\"b\" id=\"y\">foo</p></li><li class=\"a\"><p class=\"b\">{}<br></p></li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li class=a id=x><p class=b id=y>foo[]</ol>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<ol><li class=\"a\" id=\"x\"><p class=\"b\" id=\"y\">foo</p></li><li class=\"a\"><p class=\"b\">{}<br></p></li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div class=a id=x><div class=b id=y>foo[]</div></div>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div class=\"a\" id=\"x\"><div class=\"b\" id=\"y\">foo</div><div class=\"b\">{}<br></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div class=a id=x><div class=b id=y>foo[]</div></div>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<div class=\"a\" id=\"x\"><div class=\"b\" id=\"y\">foo</div><div class=\"b\">{}<br></div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div class=a id=x><p class=b id=y>foo[]</div>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div class=\"a\" id=\"x\"><p class=\"b\" id=\"y\">foo</p><p class=\"b\">{}<br></p></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div class=a id=x><p class=b id=y>foo[]</div>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<div class=\"a\" id=\"x\"><p class=\"b\" id=\"y\">foo</p><p class=\"b\">{}<br></p></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li class=a id=x><p class=b id=y>[]foo</ol>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<ol><li class=\"a\" id=\"x\"><p class=\"b\" id=\"y\"><br></p></li><li class=\"a\"><p class=\"b\">{}foo</p></li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li class=a id=x><p class=b id=y>[]foo</ol>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<ol><li class=\"a\" id=\"x\"><p class=\"b\" id=\"y\"><br></p></li><li class=\"a\"><p class=\"b\">{}foo</p></li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div class=a id=x><div class=b id=y>[]foo</div></div>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div class=\"a\" id=\"x\"><div class=\"b\" id=\"y\"><br></div><div class=\"b\">{}foo</div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div class=a id=x><div class=b id=y>[]foo</div></div>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<div class=\"a\" id=\"x\"><div class=\"b\" id=\"y\"><br></div><div class=\"b\">{}foo</div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div class=a id=x><p class=b id=y>[]foo</div>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div class=\"a\" id=\"x\"><p class=\"b\" id=\"y\"><br></p><p class=\"b\">{}foo</p></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div class=a id=x><p class=b id=y>[]foo</div>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<div class=\"a\" id=\"x\"><p class=\"b\" id=\"y\"><br></p><p class=\"b\">{}foo</p></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li class=a id=x><p class=b id=y>foo[]bar</ol>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<ol><li class=\"a\" id=\"x\"><p class=\"b\" id=\"y\">foo</p></li><li class=\"a\"><p class=\"b\">{}bar</p></li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<ol><li class=a id=x><p class=b id=y>foo[]bar</ol>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<ol><li class=\"a\" id=\"x\"><p class=\"b\" id=\"y\">foo</p></li><li class=\"a\"><p class=\"b\">{}bar</p></li></ol>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div class=a id=x><div class=b id=y>foo[]bar</div></div>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div class=\"a\" id=\"x\"><div class=\"b\" id=\"y\">foo</div><div class=\"b\">{}bar</div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div class=a id=x><div class=b id=y>foo[]bar</div></div>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<div class=\"a\" id=\"x\"><div class=\"b\" id=\"y\">foo</div><div class=\"b\">{}bar</div></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["<div class=a id=x><p class=b id=y>foo[]bar</div>",
	[["defaultparagraphseparator","div"],["insertparagraph",""]],
	"<div class=\"a\" id=\"x\"><p class=\"b\" id=\"y\">foo</p><p class=\"b\">{}bar</p></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertparagraph":[false,false,"",false,false,""]}],
["<div class=a id=x><p class=b id=y>foo[]bar</div>",
	[["defaultparagraphseparator","p"],["insertparagraph",""]],
	"<div class=\"a\" id=\"x\"><p class=\"b\" id=\"y\">foo</p><p class=\"b\">{}bar</p></div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertparagraph":[false,false,"",false,false,""]}],
["foo[bar]baz",
	[["inserttext","a"]],
	"fooa[]baz",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo[bar]baz",
	[["inserttext",""]],
	"foo[]baz",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
	[["inserttext","\t"]],
	"foo\t[]bar",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
	[["inserttext","&"]],
	"foo&amp;[]bar",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
	[["defaultparagraphseparator","div"],["inserttext","\n"]],
	"<div>foo</div><div>{}bar</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
	[["defaultparagraphseparator","p"],["inserttext","\n"]],
	"<p>foo</p><p>{}bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
	[["defaultparagraphseparator","div"],["inserttext","abc\ndef"]],
	"<div>fooabc</div><div>def[]bar</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
	[["defaultparagraphseparator","p"],["inserttext","abc\ndef"]],
	"<p>fooabc</p><p>def[]bar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
	[["inserttext","\u0007"]],
	"foo\u0007[]bar",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
	[["inserttext","<b>hi</b>"]],
	"foo&lt;b&gt;hi&lt;/b&gt;[]bar",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
	[["inserttext","<"]],
	"foo&lt;[]bar",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
	[["inserttext","&amp;"]],
	"foo&amp;amp;[]bar",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
	[["inserttext"," "]],
	"foo []bar",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo []bar",
	[["inserttext"," "]],
	"foo&nbsp; []bar",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo[] bar",
	[["inserttext"," "]],
	"foo&nbsp;[] bar",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo &nbsp;[]bar",
	[["inserttext"," "]],
	"foo &nbsp; []bar",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo []&nbsp;bar",
	[["inserttext"," "]],
	"foo &nbsp;[] bar",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo[] &nbsp;bar",
	[["inserttext"," "]],
	"foo []&nbsp; bar",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo&nbsp; []bar",
	[["inserttext"," "]],
	"foo &nbsp; []bar",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo&nbsp;[] bar",
	[["inserttext"," "]],
	"foo &nbsp;[] bar",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo[]&nbsp; bar",
	[["inserttext"," "]],
	"foo []&nbsp; bar",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo&nbsp;&nbsp;[]bar",
	[["inserttext"," "]],
	"foo &nbsp; []bar",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo&nbsp;[]&nbsp;bar",
	[["inserttext"," "]],
	"foo &nbsp;[] bar",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo[]&nbsp;&nbsp;bar",
	[["inserttext"," "]],
	"foo []&nbsp; bar",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo []&nbsp;        bar",
	[["inserttext"," "]],
	"foo &nbsp;[]&nbsp; bar",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo  []bar",
	[["inserttext"," "]],
	"foo&nbsp; []bar",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo []&nbsp;&nbsp; &nbsp; bar",
	[["inserttext"," "]],
	"foo &nbsp;[] &nbsp; &nbsp; bar",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["[]foo",
	[["inserttext"," "]],
	"&nbsp;[]foo",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["{}foo",
	[["inserttext"," "]],
	"&nbsp;[]foo",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo[]",
	[["inserttext"," "]],
	"foo&nbsp;[]",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo{}",
	[["inserttext"," "]],
	"foo&nbsp;[]",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo&nbsp;[]",
	[["inserttext"," "]],
	"foo &nbsp;[]",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo&nbsp;{}",
	[["inserttext"," "]],
	"foo &nbsp;[]",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo&nbsp;&nbsp;[]",
	[["inserttext"," "]],
	"foo &nbsp;&nbsp;[]",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo&nbsp;&nbsp;{}",
	[["inserttext"," "]],
	"foo &nbsp;&nbsp;[]",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<b>foo[]</b>bar",
	[["inserttext"," "]],
	"<b>foo []</b>bar",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo[]<b>bar</b>",
	[["inserttext"," "]],
	"foo []<b>bar</b>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo[] ",
	[["inserttext"," "]],
	"foo&nbsp;[]",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
[" foo   []   ",
	[["inserttext"," "]],
	" foo&nbsp;[]",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo[]<span> </span>",
	[["inserttext"," "]],
	"foo&nbsp;[]<span> </span>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo[]<span> </span> ",
	[["inserttext"," "]],
	"foo&nbsp;[]<span> </span> ",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
[" []foo",
	[["inserttext"," "]],
	"&nbsp;[]foo",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["   []   foo ",
	[["inserttext"," "]],
	"&nbsp;[]foo ",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<span> </span>[]foo",
	[["inserttext"," "]],
	"<span> </span>&nbsp;[]foo",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
[" <span> </span>[]foo",
	[["inserttext"," "]],
	" <span> </span>&nbsp;[]foo",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["{}<br>",
	[["inserttext"," "]],
	"&nbsp;[]",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<p>{}<br>",
	[["inserttext"," "]],
	"<p>&nbsp;[]</p>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<p>foo[]<p>bar",
	[["inserttext"," "]],
	"<p>foo&nbsp;[]</p><p>bar</p>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<p>foo&nbsp;[]<p>bar",
	[["inserttext"," "]],
	"<p>foo &nbsp;[]</p><p>bar</p>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<p>foo[]<p>&nbsp;bar",
	[["inserttext"," "]],
	"<p>foo&nbsp;[]</p><p>&nbsp;bar</p>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<pre>foo[]bar</pre>",
	[["inserttext"," "]],
	"<pre>foo []bar</pre>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<pre>foo []bar</pre>",
	[["inserttext"," "]],
	"<pre>foo  []bar</pre>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<pre>foo[] bar</pre>",
	[["inserttext"," "]],
	"<pre>foo [] bar</pre>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<pre>foo &nbsp;[]bar</pre>",
	[["inserttext"," "]],
	"<pre>foo &nbsp; []bar</pre>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<pre>[]foo</pre>",
	[["inserttext"," "]],
	"<pre> []foo</pre>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<pre>foo[]</pre>",
	[["inserttext"," "]],
	"<pre>foo []</pre>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<pre>foo&nbsp;[]</pre>",
	[["inserttext"," "]],
	"<pre>foo&nbsp; []</pre>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<pre> foo   []   </pre>",
	[["inserttext"," "]],
	"<pre> foo    []   </pre>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo[]bar</div>",
	[["inserttext"," "]],
	"<div style=\"white-space:pre\">foo []bar</div>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo []bar</div>",
	[["inserttext"," "]],
	"<div style=\"white-space:pre\">foo  []bar</div>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo[] bar</div>",
	[["inserttext"," "]],
	"<div style=\"white-space:pre\">foo [] bar</div>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo &nbsp;[]bar</div>",
	[["inserttext"," "]],
	"<div style=\"white-space:pre\">foo &nbsp; []bar</div>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre>[]foo</div>",
	[["inserttext"," "]],
	"<div style=\"white-space:pre\"> []foo</div>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo[]</div>",
	[["inserttext"," "]],
	"<div style=\"white-space:pre\">foo []</div>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre>foo&nbsp;[]</div>",
	[["inserttext"," "]],
	"<div style=\"white-space:pre\">foo&nbsp; []</div>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre> foo   []   </div>",
	[["inserttext"," "]],
	"<div style=\"white-space:pre\"> foo    []   </div>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo[]bar</div>",
	[["inserttext"," "]],
	"<div style=\"white-space:pre-wrap\">foo []bar</div>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo []bar</div>",
	[["inserttext"," "]],
	"<div style=\"white-space:pre-wrap\">foo  []bar</div>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo[] bar</div>",
	[["inserttext"," "]],
	"<div style=\"white-space:pre-wrap\">foo [] bar</div>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo &nbsp;[]bar</div>",
	[["inserttext"," "]],
	"<div style=\"white-space:pre-wrap\">foo &nbsp; []bar</div>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>[]foo</div>",
	[["inserttext"," "]],
	"<div style=\"white-space:pre-wrap\"> []foo</div>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo[]</div>",
	[["inserttext"," "]],
	"<div style=\"white-space:pre-wrap\">foo []</div>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap>foo&nbsp;[]</div>",
	[["inserttext"," "]],
	"<div style=\"white-space:pre-wrap\">foo&nbsp; []</div>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-wrap> foo   []   </div>",
	[["inserttext"," "]],
	"<div style=\"white-space:pre-wrap\"> foo    []   </div>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo[]bar</div>",
	[["inserttext"," "]],
	"<div style=\"white-space:pre-line\">foo []bar</div>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo []bar</div>",
	[["inserttext"," "]],
	"<div style=\"white-space:pre-line\">foo&nbsp; []bar</div>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo[] bar</div>",
	[["inserttext"," "]],
	"<div style=\"white-space:pre-line\">foo&nbsp;[] bar</div>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo &nbsp;[]bar</div>",
	[["inserttext"," "]],
	"<div style=\"white-space:pre-line\">foo &nbsp; []bar</div>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>[]foo</div>",
	[["inserttext"," "]],
	"<div style=\"white-space:pre-line\">&nbsp;[]foo</div>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo[]</div>",
	[["inserttext"," "]],
	"<div style=\"white-space:pre-line\">foo&nbsp;[]</div>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line>foo&nbsp;[]</div>",
	[["inserttext"," "]],
	"<div style=\"white-space:pre-line\">foo &nbsp;[]</div>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:pre-line> foo   []   </div>",
	[["inserttext"," "]],
	"<div style=\"white-space:pre-line\"> foo&nbsp;[]</div>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo[]bar</div>",
	[["inserttext"," "]],
	"<div style=\"white-space:nowrap\">foo []bar</div>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo []bar</div>",
	[["inserttext"," "]],
	"<div style=\"white-space:nowrap\">foo&nbsp; []bar</div>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo[] bar</div>",
	[["inserttext"," "]],
	"<div style=\"white-space:nowrap\">foo&nbsp;[] bar</div>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo &nbsp;[]bar</div>",
	[["inserttext"," "]],
	"<div style=\"white-space:nowrap\">foo &nbsp; []bar</div>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>[]foo</div>",
	[["inserttext"," "]],
	"<div style=\"white-space:nowrap\">&nbsp;[]foo</div>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo[]</div>",
	[["inserttext"," "]],
	"<div style=\"white-space:nowrap\">foo&nbsp;[]</div>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap>foo&nbsp;[]</div>",
	[["inserttext"," "]],
	"<div style=\"white-space:nowrap\">foo &nbsp;[]</div>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<div style=white-space:nowrap> foo   []   </div>",
	[["inserttext"," "]],
	"<div style=\"white-space:nowrap\"> foo&nbsp;[]</div>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["http://a[]",
	[["inserttext"," "]],
	"<a href=\"http://a\">http://a</a>&nbsp;[]",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["ftp://a[]",
	[["inserttext"," "]],
	"<a href=\"ftp://a\">ftp://a</a>&nbsp;[]",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["quasit://a[]",
	[["inserttext"," "]],
	"<a href=\"quasit://a\">quasit://a</a>&nbsp;[]",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
[".x-++-.://a[]",
	[["inserttext"," "]],
	".<a href=\"x-++-.://a\">x-++-.://a</a>&nbsp;[]",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["(http://a)[]",
	[["inserttext"," "]],
	"(<a href=\"http://a\">http://a</a>)&nbsp;[]",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["&lt;http://a>[]",
	[["inserttext"," "]],
	"&lt;<a href=\"http://a\">http://a</a>&gt;&nbsp;[]",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["http://a![]",
	[["inserttext"," "]],
	"<a href=\"http://a\">http://a</a>!&nbsp;[]",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["!\"#$%&amp;'()*+,-./:;&lt;=>?^_`|~http://a!\"#$%&amp;'()*+,-./:;&lt;=>?^_`|~[]",
	[["inserttext"," "]],
	"!\"#$%&amp;'()*+,-./:;&lt;=&gt;?^_`|~<a href=\"http://a!&quot;#$%&amp;'()*+,-./:;&lt;=&gt;?^_`|~\">http://a!\"#$%&amp;'()*+,-./:;&lt;=&gt;?^_`|~</a>&nbsp;[]",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["http://a!\"'(),-.:;&lt;>`[]",
	[["inserttext"," "]],
	"<a href=\"http://a\">http://a</a>!\"'(),-.:;&lt;&gt;`&nbsp;[]",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["http://a#$%&amp;*+/=?^_|~[]",
	[["inserttext"," "]],
	"<a href=\"http://a#$%&amp;*+/=?^_|~\">http://a#$%&amp;*+/=?^_|~</a>&nbsp;[]",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["mailto:a[]",
	[["inserttext"," "]],
	"<a href=\"mailto:a\">mailto:a</a>&nbsp;[]",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["a@b[]",
	[["inserttext"," "]],
	"<a href=\"mailto:a@b\">a@b</a>&nbsp;[]",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["a@[]",
	[["inserttext"," "]],
	"a@&nbsp;[]",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["@b[]",
	[["inserttext"," "]],
	"@b&nbsp;[]",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["#@x[]",
	[["inserttext"," "]],
	"<a href=\"mailto:#@x\">#@x</a>&nbsp;[]",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["a@.[]",
	[["inserttext"," "]],
	"a@.&nbsp;[]",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["!\"#$%&amp;'()*+,-./:;&lt;=>?^_`|~a@b!\"#$%&amp;'()*+,-./:;&lt;=>?^_`|~[]",
	[["inserttext"," "]],
	"!\"#$%&amp;'()*+,-./:;&lt;=&gt;<a href=\"mailto:?^_`|~a@b\">?^_`|~a@b</a>!\"#$%&amp;'()*+,-./:;&lt;=&gt;?^_`|~&nbsp;[]",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<b>a@b</b>{}",
	[["inserttext"," "]],
	"<a href=\"mailto:a@b\"><b>a@b</b></a> []",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<b>a</b><i>@</i><u>b</u>{}",
	[["inserttext"," "]],
	"<b>a</b><i>@</i><u>b</u> []",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["a@b<b>[]c</b>",
	[["inserttext"," "]],
	"<a href=\"mailto:a@b\">a@b</a><b> []c</b>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<p>a@b</p><p>[]c</p>",
	[["inserttext"," "]],
	"<p>a@b</p><p>&nbsp;[]c</p>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["http://a[]",
	[["inserttext","a"]],
	"http://aa[]",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["http://a[]",
	[["inserttext","\t"]],
	"<a href=\"http://a\">http://a</a>\t[]",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["http://a[]",
	[["inserttext","\f"]],
	"<a href=\"http://a\">http://a</a>\f[]",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["http://a[]",
	[["inserttext"," "]],
	"http://a&nbsp;[]",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo[]",
	[["inserttext","   "]],
	"foo &nbsp;&nbsp;[]",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
	[["inserttext","a"]],
	"fooa[]bar",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo&nbsp;[]",
	[["inserttext","a"]],
	"foo a[]",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo []",
	[["inserttext","a"]],
	"foo a[]",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<p>foo[]",
	[["inserttext","a"]],
	"<p>fooa[]</p>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<p>foo</p>{}",
	[["inserttext","a"]],
	"<p>foo</p>a[]",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<p>[]foo",
	[["inserttext","a"]],
	"<p>a[]foo</p>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<p>{}foo",
	[["inserttext","a"]],
	"<p>a[]foo</p>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["{}<p>foo",
	[["inserttext","a"]],
	"a[]<p>foo</p>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<p>foo</p>{}<p>bar</p>",
	[["inserttext","a"]],
	"<p>foo</p>a[]<p>bar</p>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<b>foo[]</b>bar",
	[["inserttext","a"]],
	"<b>fooa[]</b>bar",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<b>foo</b>[]bar",
	[["inserttext","a"]],
	"<b>foo</b>a[]bar",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<b>{}</b>bar",
	[["inserttext","a"]],
	"foo<b>a[]</b>bar",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<a>foo[]</a>bar",
	[["inserttext","a"]],
	"<a>fooa[]</a>bar",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<a>foo</a>[]bar",
	[["inserttext","a"]],
	"<a>foo</a>a[]bar",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<a href=/>foo[]</a>bar",
	[["inserttext","a"]],
	"<a href=\"/\">fooa[]</a>bar",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<a href=/>foo</a>[]bar",
	[["inserttext","a"]],
	"<a href=\"/\">foo</a>a[]bar",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<p>fo[o<p>b]ar",
	[["defaultparagraphseparator","div"],["inserttext","a"]],
	"<p>foa[]ar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"inserttext":[false,false,"",false,false,""]}],
["<p>fo[o<p>b]ar",
	[["defaultparagraphseparator","p"],["inserttext","a"]],
	"<p>foa[]ar</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"inserttext":[false,false,"",false,false,""]}],
["<p>fo[o<p>bar<p>b]az",
	[["defaultparagraphseparator","div"],["inserttext","a"]],
	"<p>foa[]az</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"inserttext":[false,false,"",false,false,""]}],
["<p>fo[o<p>bar<p>b]az",
	[["defaultparagraphseparator","p"],["inserttext","a"]],
	"<p>foa[]az</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"inserttext":[false,false,"",false,false,""]}],
["{}<br>",
	[["inserttext","a"]],
	"a[]",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<p>{}<br>",
	[["inserttext","a"]],
	"<p>a[]</p>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<p><span>{}<br></span>",
	[["inserttext","a"]],
	"<p><span>a[]</span></p>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar]</span>baz",
	[["inserttext","a"]],
	"<p>foo<span style=\"color:rgb(171, 205, 239)\">a[]</span>baz</p>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar}</span>baz",
	[["inserttext","a"]],
	"<p>foo<span style=\"color:rgb(171, 205, 239)\">a[]</span>baz</p>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<p>foo{<span style=color:#aBcDeF>bar</span>}baz",
	[["inserttext","a"]],
	"<p>foo<span style=\"color:rgb(171, 205, 239)\">a[]</span>baz</p>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<p>[foo<span style=color:#aBcDeF>bar]</span>baz",
	[["stylewithcss","true"],["inserttext","a"]],
	"<p>a[]baz</p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["<p>[foo<span style=color:#aBcDeF>bar]</span>baz",
	[["stylewithcss","false"],["inserttext","a"]],
	"<p>a[]baz</p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["<p>{foo<span style=color:#aBcDeF>bar}</span>baz",
	[["stylewithcss","true"],["inserttext","a"]],
	"<p>a[]baz</p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["<p>{foo<span style=color:#aBcDeF>bar}</span>baz",
	[["stylewithcss","false"],["inserttext","a"]],
	"<p>a[]baz</p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span>baz]",
	[["inserttext","a"]],
	"<p>foo<span style=\"color:rgb(171, 205, 239)\">a[]</span></p>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>{bar</span>baz}",
	[["inserttext","a"]],
	"<p>foo<span style=\"color:rgb(171, 205, 239)\">a[]</span></p>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span><span style=color:#fEdCbA>baz]</span>quz",
	[["stylewithcss","true"],["inserttext","a"]],
	"<p>foo<span style=\"color:rgb(171, 205, 239)\">a[]</span>quz</p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["<p>foo<span style=color:#aBcDeF>[bar</span><span style=color:#fEdCbA>baz]</span>quz",
	[["stylewithcss","false"],["inserttext","a"]],
	"<p>foo<span style=\"color:rgb(171, 205, 239)\">a[]</span>quz</p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<b>[bar]</b>baz",
	[["inserttext","a"]],
	"foo<b>a[]</b>baz",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<i>[bar]</i>baz",
	[["inserttext","a"]],
	"foo<i>a[]</i>baz",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<s>[bar]</s>baz",
	[["inserttext","a"]],
	"foo<s>a[]</s>baz",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<sub>[bar]</sub>baz",
	[["inserttext","a"]],
	"foo<sub>a[]</sub>baz",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<sup>[bar]</sup>baz",
	[["inserttext","a"]],
	"foo<sup>a[]</sup>baz",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<u>[bar]</u>baz",
	[["inserttext","a"]],
	"foo<u>a[]</u>baz",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com>[bar]</a>baz",
	[["inserttext","a"]],
	"foo<a href=\"http://www.google.com\">a[]</a>baz",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<font face=sans-serif>[bar]</font>baz",
	[["inserttext","a"]],
	"foo<font face=\"sans-serif\">a[]</font>baz",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<font size=4>[bar]</font>baz",
	[["inserttext","a"]],
	"foo<font size=\"4\">a[]</font>baz",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<font color=#0000FF>[bar]</font>baz",
	[["inserttext","a"]],
	"foo<font color=\"#0000FF\">a[]</font>baz",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<span style=background-color:#00FFFF>[bar]</span>baz",
	[["inserttext","a"]],
	"foo<span style=\"background-color:rgb(0, 255, 255)\">a[]</span>baz",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com><font color=blue>[bar]</font></a>baz",
	[["inserttext","a"]],
	"foo<a href=\"http://www.google.com\"><font color=\"blue\">a[]</font></a>baz",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<font color=blue><a href=http://www.google.com>[bar]</a></font>baz",
	[["inserttext","a"]],
	"foo<font color=\"blue\"><a href=\"http://www.google.com\">a[]</a></font>baz",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com><font color=brown>[bar]</font></a>baz",
	[["inserttext","a"]],
	"foo<a href=\"http://www.google.com\"><font color=\"brown\">a[]</font></a>baz",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<font color=brown><a href=http://www.google.com>[bar]</a></font>baz",
	[["inserttext","a"]],
	"foo<font color=\"brown\"><a href=\"http://www.google.com\">a[]</a></font>baz",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com><font color=black>[bar]</font></a>baz",
	[["inserttext","a"]],
	"foo<a href=\"http://www.google.com\"><font color=\"black\">a[]</font></a>baz",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com><u>[bar]</u></a>baz",
	[["inserttext","a"]],
	"foo<a href=\"http://www.google.com\"><u>a[]</u></a>baz",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<u><a href=http://www.google.com>[bar]</a></u>baz",
	[["inserttext","a"]],
	"foo<u><a href=\"http://www.google.com\">a[]</a></u>baz",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<sub><font size=2>[bar]</font></sub>baz",
	[["inserttext","a"]],
	"foo<sub><font size=\"2\">a[]</font></sub>baz",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<font size=2><sub>[bar]</sub></font>baz",
	[["inserttext","a"]],
	"foo<font size=\"2\"><sub>a[]</sub></font>baz",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<sub><font size=3>[bar]</font></sub>baz",
	[["inserttext","a"]],
	"foo<sub><font size=\"3\">a[]</font></sub>baz",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<font size=3><sub>[bar]</sub></font>baz",
	[["inserttext","a"]],
	"foo<font size=\"3\"><sub>a[]</sub></font>baz",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["[foo<b>bar]</b>baz",
	[["stylewithcss","true"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<b>bar]</b>baz",
	[["stylewithcss","false"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<i>bar]</i>baz",
	[["stylewithcss","true"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<i>bar]</i>baz",
	[["stylewithcss","false"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<s>bar]</s>baz",
	[["stylewithcss","true"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<s>bar]</s>baz",
	[["stylewithcss","false"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<sub>bar]</sub>baz",
	[["stylewithcss","true"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<sub>bar]</sub>baz",
	[["stylewithcss","false"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<sup>bar]</sup>baz",
	[["stylewithcss","true"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<sup>bar]</sup>baz",
	[["stylewithcss","false"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<u>bar]</u>baz",
	[["stylewithcss","true"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<u>bar]</u>baz",
	[["stylewithcss","false"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com>bar]</a>baz",
	[["inserttext","a"]],
	"a[]baz",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["[foo<font face=sans-serif>bar]</font>baz",
	[["stylewithcss","true"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font face=sans-serif>bar]</font>baz",
	[["stylewithcss","false"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font size=4>bar]</font>baz",
	[["stylewithcss","true"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font size=4>bar]</font>baz",
	[["stylewithcss","false"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font color=#0000FF>bar]</font>baz",
	[["stylewithcss","true"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font color=#0000FF>bar]</font>baz",
	[["stylewithcss","false"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<span style=background-color:#00FFFF>bar]</span>baz",
	[["stylewithcss","true"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<span style=background-color:#00FFFF>bar]</span>baz",
	[["stylewithcss","false"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com><font color=blue>bar]</font></a>baz",
	[["stylewithcss","true"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com><font color=blue>bar]</font></a>baz",
	[["stylewithcss","false"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font color=blue><a href=http://www.google.com>bar]</a></font>baz",
	[["stylewithcss","true"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font color=blue><a href=http://www.google.com>bar]</a></font>baz",
	[["stylewithcss","false"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com><font color=brown>bar]</font></a>baz",
	[["stylewithcss","true"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com><font color=brown>bar]</font></a>baz",
	[["stylewithcss","false"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font color=brown><a href=http://www.google.com>bar]</a></font>baz",
	[["stylewithcss","true"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font color=brown><a href=http://www.google.com>bar]</a></font>baz",
	[["stylewithcss","false"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com><font color=black>bar]</font></a>baz",
	[["stylewithcss","true"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com><font color=black>bar]</font></a>baz",
	[["stylewithcss","false"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com><u>bar]</u></a>baz",
	[["stylewithcss","true"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com><u>bar]</u></a>baz",
	[["stylewithcss","false"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<u><a href=http://www.google.com>bar]</a></u>baz",
	[["stylewithcss","true"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<u><a href=http://www.google.com>bar]</a></u>baz",
	[["stylewithcss","false"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<sub><font size=2>bar]</font></sub>baz",
	[["stylewithcss","true"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<sub><font size=2>bar]</font></sub>baz",
	[["stylewithcss","false"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font size=2><sub>bar]</sub></font>baz",
	[["stylewithcss","true"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font size=2><sub>bar]</sub></font>baz",
	[["stylewithcss","false"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<sub><font size=3>bar]</font></sub>baz",
	[["stylewithcss","true"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<sub><font size=3>bar]</font></sub>baz",
	[["stylewithcss","false"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font size=3><sub>bar]</sub></font>baz",
	[["stylewithcss","true"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font size=3><sub>bar]</sub></font>baz",
	[["stylewithcss","false"],["inserttext","a"]],
	"a[]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<b>[bar</b>baz]",
	[["inserttext","a"]],
	"foo<b>a[]</b>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<i>[bar</i>baz]",
	[["inserttext","a"]],
	"foo<i>a[]</i>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<s>[bar</s>baz]",
	[["inserttext","a"]],
	"foo<s>a[]</s>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<sub>[bar</sub>baz]",
	[["inserttext","a"]],
	"foo<sub>a[]</sub>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<sup>[bar</sup>baz]",
	[["inserttext","a"]],
	"foo<sup>a[]</sup>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<u>[bar</u>baz]",
	[["inserttext","a"]],
	"foo<u>a[]</u>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com>[bar</a>baz]",
	[["inserttext","a"]],
	"foo<a href=\"http://www.google.com\">a[]</a>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<font face=sans-serif>[bar</font>baz]",
	[["inserttext","a"]],
	"foo<font face=\"sans-serif\">a[]</font>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<font size=4>[bar</font>baz]",
	[["inserttext","a"]],
	"foo<font size=\"4\">a[]</font>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<font color=#0000FF>[bar</font>baz]",
	[["inserttext","a"]],
	"foo<font color=\"#0000FF\">a[]</font>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<span style=background-color:#00FFFF>[bar</span>baz]",
	[["inserttext","a"]],
	"foo<span style=\"background-color:rgb(0, 255, 255)\">a[]</span>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com><font color=blue>[bar</font></a>baz]",
	[["inserttext","a"]],
	"foo<a href=\"http://www.google.com\"><font color=\"blue\">a[]</font></a>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<font color=blue><a href=http://www.google.com>[bar</a></font>baz]",
	[["inserttext","a"]],
	"foo<font color=\"blue\"><a href=\"http://www.google.com\">a[]</a></font>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com><font color=brown>[bar</font></a>baz]",
	[["inserttext","a"]],
	"foo<a href=\"http://www.google.com\"><font color=\"brown\">a[]</font></a>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<font color=brown><a href=http://www.google.com>[bar</a></font>baz]",
	[["inserttext","a"]],
	"foo<font color=\"brown\"><a href=\"http://www.google.com\">a[]</a></font>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com><font color=black>[bar</font></a>baz]",
	[["inserttext","a"]],
	"foo<a href=\"http://www.google.com\"><font color=\"black\">a[]</font></a>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com><u>[bar</u></a>baz]",
	[["inserttext","a"]],
	"foo<a href=\"http://www.google.com\"><u>a[]</u></a>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<u><a href=http://www.google.com>[bar</a></u>baz]",
	[["inserttext","a"]],
	"foo<u><a href=\"http://www.google.com\">a[]</a></u>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<sub><font size=2>[bar</font></sub>baz]",
	[["inserttext","a"]],
	"foo<sub><font size=\"2\">a[]</font></sub>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<font size=2><sub>[bar</sub></font>baz]",
	[["inserttext","a"]],
	"foo<font size=\"2\"><sub>a[]</sub></font>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<sub><font size=3>[bar</font></sub>baz]",
	[["inserttext","a"]],
	"foo<sub><font size=\"3\">a[]</font></sub>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo<font size=3><sub>[bar</sub></font>baz]",
	[["inserttext","a"]],
	"foo<font size=\"3\"><sub>a[]</sub></font>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["<blockquote><font color=blue>[foo]</font></blockquote>",
	[["inserttext","a"]],
	"<blockquote><font color=\"blue\">a[]</font></blockquote>",
	[true],
	{"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
	[["insertunorderedlist",""]],
	"<ul><li>foo[]bar</li></ul>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["foo[bar]baz",
	[["insertunorderedlist",""]],
	"<ul><li>foo[bar]baz</li></ul>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["foo<br>[bar]",
	[["insertunorderedlist",""]],
	"foo<ul><li>[bar]</li></ul>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["f[oo<br>b]ar<br>baz",
	[["insertunorderedlist",""]],
	"<ul><li>f[oo</li><li>b]ar</li></ul>baz",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>[foo]<br>bar</p>",
	[["insertunorderedlist",""]],
	"<ul><li>[foo]</li></ul><p>bar</p>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["[foo<ol><li>bar]</ol>baz",
	[["insertunorderedlist",""]],
	"<ul><li>[foo</li><li>bar]</li></ul>baz",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["foo<ol><li>[bar</ol>baz]",
	[["insertunorderedlist",""]],
	"foo<ul><li>[bar</li><li>baz]</li></ul>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["[foo<ul><li>bar]</ul>baz",
	[["insertunorderedlist",""]],
	"<ul><li>[foo</li><li>bar]</li></ul>baz",
	[true],
	{"insertunorderedlist":[true,false,"",false,true,""]}],
["foo<ul><li>[bar</ul>baz]",
	[["insertunorderedlist",""]],
	"foo<ul><li>[bar</li><li>baz]</li></ul>",
	[true],
	{"insertunorderedlist":[true,false,"",false,true,""]}],
["foo<ul><li>[bar</ul><ol><li>baz]</ol>quz",
	[["insertunorderedlist",""]],
	"foo<ul><li>[bar</li><li>baz]</li></ul>quz",
	[true],
	{"insertunorderedlist":[true,false,"",false,true,""]}],
["foo<ol><li>[bar</ol><ul><li>baz]</ul>quz",
	[["insertunorderedlist",""]],
	"foo<ul><li>[bar</li><li>baz]</li></ul>quz",
	[true],
	{"insertunorderedlist":[true,false,"",false,true,""]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
	[["insertunorderedlist",""]],
	"<table><tbody><tr><td>foo</td><td><ul><li>b[a]r</li></ul></td><td>baz</td></tr></tbody></table>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<table><tbody><tr><td>fo[o<td>b]ar<td>baz</table>",
	[["insertunorderedlist",""]],
	"<table><tbody><tr><td><ul><li>fo[o</li></ul></td><td><ul><li>b]ar</li></ul></td><td>baz</td></tr></tbody></table>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
	[["insertunorderedlist",""]],
	"<ul><li>{<table><tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody></table>}</li></ul>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>foo<p>[bar]<p>baz",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<p>foo</p><ul><li>[bar]</li></ul><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>foo<p>[bar]<p>baz",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<p>foo</p><ul><li>[bar]</li></ul><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>foo<blockquote>[bar]</blockquote><p>baz",
	[["insertunorderedlist",""]],
	"<p>foo</p><blockquote><ul><li>[bar]</li></ul></blockquote><p>baz</p>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<dl><dt>foo<dd>[bar]<dt>baz<dd>quz</dl>",
	[["insertunorderedlist",""]],
	"<dl><dt>foo</dt><dd><ul><li>[bar]</li></ul></dd><dt>baz</dt><dd>quz</dd></dl>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<dl><dt>foo<dd>bar<dt>[baz]<dd>quz</dl>",
	[["insertunorderedlist",""]],
	"<dl><dt>foo</dt><dd>bar</dd><dt><ul><li>[baz]</li></ul></dt><dd>quz</dd></dl>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>[foo<p>bar]<p>baz",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<ul><li>[foo</li><li>bar]</li></ul><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>[foo<p>bar]<p>baz",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<ul><li>[foo</li><li>bar]</li></ul><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>[foo<blockquote>bar]</blockquote><p>baz",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<ul><li>[foo</li><ul><li>bar]</li></ul></ul><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>[foo<blockquote>bar]</blockquote><p>baz",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<ul><li>[foo</li><ul><li>bar]</li></ul></ul><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<dl><dt>[foo<dd>bar]<dt>baz<dd>quz</dl>",
	[["insertunorderedlist",""]],
	"<dl><dt><ul><li>[foo</li></ul></dt><dd><ul><li>bar]</li></ul></dd><dt>baz</dt><dd>quz</dd></dl>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<dl><dt>foo<dd>[bar<dt>baz]<dd>quz</dl>",
	[["insertunorderedlist",""]],
	"<dl><dt>foo</dt><dd><ul><li>[bar</li></ul></dd><dt><ul><li>baz]</li></ul></dt><dd>quz</dd></dl>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>[foo<blockquote><p>bar]<p>baz</blockquote>",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<ul><li>[foo</li><ul><li>bar]</li></ul></ul><blockquote><p>baz</p></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>[foo<blockquote><p>bar]<p>baz</blockquote>",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<ul><li>[foo</li><ul><li>bar]</li></ul></ul><blockquote><p>baz</p></blockquote>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo<li>[bar]<li>baz</ol>",
	[["insertunorderedlist",""]],
	"<ol><li>foo</li></ol><ul><li>[bar]</li></ul><ol><li>baz</li></ol>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</ol>[bar]",
	[["insertunorderedlist",""]],
	"<ol><li>foo</li></ol><ul><li>[bar]</li></ul>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["[foo]<ol><li>bar</ol>",
	[["insertunorderedlist",""]],
	"<ul><li>[foo]</li></ul><ol><li>bar</li></ol>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</ol>[bar]<ol><li>baz</ol>",
	[["insertunorderedlist",""]],
	"<ol><li>foo</li></ol><ul><li>[bar]</li></ul><ol><li>baz</li></ol>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><ol><li>[foo]</ol></ol>",
	[["insertunorderedlist",""]],
	"<ul><ul><li>[foo]</li></ul></ul>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>[foo]<br>bar<li>baz</ol>",
	[["insertunorderedlist",""]],
	"<ul><li>[foo]<br>bar</li></ul><ol><li>baz</li></ol>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo<br>[bar]<li>baz</ol>",
	[["insertunorderedlist",""]],
	"<ul><li>foo<br>[bar]</li></ul><ol><li>baz</li></ol>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li><div>[foo]</div>bar<li>baz</ol>",
	[["insertunorderedlist",""]],
	"<ul><li><div>[foo]</div>bar</li></ul><ol><li>baz</li></ol>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo<ol><li>[bar]<li>baz</ol><li>quz</ol>",
	[["insertunorderedlist",""]],
	"<ol><li>foo</li><ul><li>[bar]</li></ul><ol><li>baz</li></ol><li>quz</li></ol>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo<ol><li>bar<li>[baz]</ol><li>quz</ol>",
	[["insertunorderedlist",""]],
	"<ol><li>foo</li><ol><li>bar</li></ol><ul><li>[baz]</li></ul><li>quz</li></ol>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</li><ol><li>[bar]<li>baz</ol><li>quz</ol>",
	[["insertunorderedlist",""]],
	"<ol><li>foo</li><ul><li>[bar]</li></ul><ol><li>baz</li></ol><li>quz</li></ol>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</li><ol><li>bar<li>[baz]</ol><li>quz</ol>",
	[["insertunorderedlist",""]],
	"<ol><li>foo</li><ol><li>bar</li></ol><ul><li>[baz]</li></ul><li>quz</li></ol>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>[foo]<ol><li>bar</ol><li>baz</ol>",
	[["insertunorderedlist",""]],
	"<ul><li>[foo]</li></ul><ol><ol><li>bar</li></ol><li>baz</li></ol>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>[foo]</li><ol><li>bar</ol><li>baz</ol>",
	[["insertunorderedlist",""]],
	"<ul><li>[foo]</li></ul><ol><ol><li>bar</li></ol><li>baz</li></ol>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo<li>[bar]<ol><li>baz</ol><li>quz</ol>",
	[["insertunorderedlist",""]],
	"<ol><li>foo</li></ol><ul><li>[bar]</li></ul><ol><ol><li>baz</li></ol><li>quz</li></ol>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo<li>[bar]</li><ol><li>baz</ol><li>quz</ol>",
	[["insertunorderedlist",""]],
	"<ol><li>foo</li></ol><ul><li>[bar]</li></ul><ol><ol><li>baz</li></ol><li>quz</li></ol>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo<ol><li>bar<li>baz</ol><li>[quz]</ol>",
	[["insertunorderedlist",""]],
	"<ol><li>foo<ol><li>bar</li><li>baz</li></ol></li></ol><ul><li>[quz]</li></ul>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</li><ol><li>bar<li>baz</ol><li>[quz]</ol>",
	[["insertunorderedlist",""]],
	"<ol><li>foo</li><ol><li>bar</li><li>baz</li></ol></ol><ul><li>[quz]</li></ul>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo<li>[bar<li>baz]</ol>",
	[["insertunorderedlist",""]],
	"<ol><li>foo</li></ol><ul><li>[bar</li><li>baz]</li></ul>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>[foo<ol><li>bar]</ol><li>baz</ol>",
	[["insertunorderedlist",""]],
	"<ul><li>[foo</li><ul><li>bar]</li></ul></ul><ol><li>baz</li></ol>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo<ol><li>b[ar</ol><li>b]az</ol>",
	[["insertunorderedlist",""]],
	"<ol><li>foo</li></ol><ul><ul><li>b[ar</li></ul><li>b]az</li></ul>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>[foo<ol><li>bar</ol><li>baz]</ol><p>extra",
	[["insertunorderedlist",""]],
	"<ul><li>[foo</li><ul><li>bar</li></ul><li>baz]</li></ul><p>extra</p>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>[foo]<ol><li>bar</ol>baz</ol>",
	[["insertunorderedlist",""]],
	"<ul><li>[foo]</li></ul><ol><ol><li>bar</li></ol><li>baz</li></ol>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo<ol><li>[bar]</ol>baz</ol>",
	[["insertunorderedlist",""]],
	"<ol><li>foo</li><ul><li>[bar]</li></ul><li>baz</li></ol>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo<ol><li>bar</ol>[baz]</ol>",
	[["insertunorderedlist",""]],
	"<ol><li>foo</li><ol><li>bar</li></ol></ol><ul><li>[baz]</li></ul>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>[foo<ol><li>bar]</ol>baz</ol>",
	[["insertunorderedlist",""]],
	"<ul><li>[foo</li><ul><li>bar]</li></ul></ul><ol><li>baz</li></ol>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo<li>[bar]<li>baz</ul>",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<ul><li>foo</li></ul><div>[bar]</div><ul><li>baz</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo<li>[bar]<li>baz</ul>",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<ul><li>foo</li></ul><p>[bar]</p><ul><li>baz</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo</ul>[bar]",
	[["insertunorderedlist",""]],
	"<ul><li>foo</li><li>[bar]</li></ul>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["[foo]<ul><li>bar</ul>",
	[["insertunorderedlist",""]],
	"<ul><li>[foo]</li><li>bar</li></ul>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo</ul>[bar]<ul><li>baz</ul>",
	[["insertunorderedlist",""]],
	"<ul><li>foo</li><li>[bar]</li><li>baz</li></ul>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<ul><ul><li>[foo]</ul></ul>",
	[["insertunorderedlist",""]],
	"<ul><li>[foo]</li></ul>",
	[true],
	{"insertunorderedlist":[false,true,"",false,true,""]}],
["<ul><li>[foo]<br>bar<li>baz</ul>",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<div>[foo]<br>bar</div><ul><li>baz</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>[foo]<br>bar<li>baz</ul>",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<p>[foo]<br>bar</p><ul><li>baz</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo<br>[bar]<li>baz</ul>",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<div>foo<br>[bar]</div><ul><li>baz</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo<br>[bar]<li>baz</ul>",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<p>foo<br>[bar]</p><ul><li>baz</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li><div>[foo]</div>bar<li>baz</ul>",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<div>[foo]</div><div>bar</div><ul><li>baz</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li><div>[foo]</div>bar<li>baz</ul>",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<div>[foo]</div><p>bar</p><ul><li>baz</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo<ul><li>[bar]<li>baz</ul><li>quz</ul>",
	[["insertunorderedlist",""]],
	"<ul><li>foo</li><li>[bar]</li><ul><li>baz</li></ul><li>quz</li></ul>",
	[true],
	{"insertunorderedlist":[false,true,"",false,true,""]}],
["<ul><li>foo<ul><li>bar<li>[baz]</ul><li>quz</ul>",
	[["insertunorderedlist",""]],
	"<ul><li>foo</li><ul><li>bar</li></ul><li>[baz]</li><li>quz</li></ul>",
	[true],
	{"insertunorderedlist":[false,true,"",false,true,""]}],
["<ul><li>foo</li><ul><li>[bar]<li>baz</ul><li>quz</ul>",
	[["insertunorderedlist",""]],
	"<ul><li>foo</li><li>[bar]</li><ul><li>baz</li></ul><li>quz</li></ul>",
	[true],
	{"insertunorderedlist":[false,true,"",false,true,""]}],
["<ul><li>foo</li><ul><li>bar<li>[baz]</ul><li>quz</ul>",
	[["insertunorderedlist",""]],
	"<ul><li>foo</li><ul><li>bar</li></ul><li>[baz]</li><li>quz</li></ul>",
	[true],
	{"insertunorderedlist":[false,true,"",false,true,""]}],
["<ul><li>[foo]<ul><li>bar</ul><li>baz</ul>",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<div>[foo]</div><ul><ul><li>bar</li></ul><li>baz</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>[foo]<ul><li>bar</ul><li>baz</ul>",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<p>[foo]</p><ul><ul><li>bar</li></ul><li>baz</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>[foo]</li><ul><li>bar</ul><li>baz</ul>",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<div>[foo]</div><ul><ul><li>bar</li></ul><li>baz</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>[foo]</li><ul><li>bar</ul><li>baz</ul>",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<p>[foo]</p><ul><ul><li>bar</li></ul><li>baz</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo<li>[bar]<ul><li>baz</ul><li>quz</ul>",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<ul><li>foo</li></ul><div>[bar]</div><ul><ul><li>baz</li></ul><li>quz</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo<li>[bar]<ul><li>baz</ul><li>quz</ul>",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<ul><li>foo</li></ul><p>[bar]</p><ul><ul><li>baz</li></ul><li>quz</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo<li>[bar]</li><ul><li>baz</ul><li>quz</ul>",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<ul><li>foo</li></ul><div>[bar]</div><ul><ul><li>baz</li></ul><li>quz</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo<li>[bar]</li><ul><li>baz</ul><li>quz</ul>",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<ul><li>foo</li></ul><p>[bar]</p><ul><ul><li>baz</li></ul><li>quz</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo<ul><li>bar<li>baz</ul><li>[quz]</ul>",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<ul><li>foo<ul><li>bar</li><li>baz</li></ul></li></ul><div>[quz]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo<ul><li>bar<li>baz</ul><li>[quz]</ul>",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<ul><li>foo<ul><li>bar</li><li>baz</li></ul></li></ul><p>[quz]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo</li><ul><li>bar<li>baz</ul><li>[quz]</ul>",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<ul><li>foo</li><ul><li>bar</li><li>baz</li></ul></ul><div>[quz]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo</li><ul><li>bar<li>baz</ul><li>[quz]</ul>",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<ul><li>foo</li><ul><li>bar</li><li>baz</li></ul></ul><p>[quz]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo<li>[bar<li>baz]</ul>",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<ul><li>foo</li></ul><div>[bar</div><div>baz]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo<li>[bar<li>baz]</ul>",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<ul><li>foo</li></ul><p>[bar</p><p>baz]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>[foo<ul><li>bar]</ul><li>baz</ul>",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<div>[foo</div><ul><li>bar]</li><li>baz</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",true,false,""]}],
["<ul><li>[foo<ul><li>bar]</ul><li>baz</ul>",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<p>[foo</p><ul><li>bar]</li><li>baz</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",true,false,""]}],
["<ul><li>foo<ul><li>b[ar</ul><li>b]az</ul>",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<ul><li>foo</li><li>b[ar</li></ul><div>b]az</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",true,false,""]}],
["<ul><li>foo<ul><li>b[ar</ul><li>b]az</ul>",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<ul><li>foo</li><li>b[ar</li></ul><p>b]az</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",true,false,""]}],
["<ul><li>[foo<ul><li>bar</ul><li>baz]</ul><p>extra",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<div>[foo</div><ul><li>bar</li></ul><div>baz]</div><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",true,false,""]}],
["<ul><li>[foo<ul><li>bar</ul><li>baz]</ul><p>extra",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<p>[foo</p><ul><li>bar</li></ul><p>baz]</p><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",true,false,""]}],
["<ul><li>[foo]<ul><li>bar</ul>baz</ul>",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<div>[foo]</div><ul><ul><li>bar</li></ul><li>baz</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>[foo]<ul><li>bar</ul>baz</ul>",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<p>[foo]</p><ul><ul><li>bar</li></ul><li>baz</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo<ul><li>[bar]</ul>baz</ul>",
	[["insertunorderedlist",""]],
	"<ul><li>foo</li><li>[bar]</li><li>baz</li></ul>",
	[true],
	{"insertunorderedlist":[false,true,"",false,true,""]}],
["<ul><li>foo<ul><li>bar</ul>[baz]</ul>",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<ul><li>foo</li><ul><li>bar</li></ul></ul><div>[baz]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo<ul><li>bar</ul>[baz]</ul>",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<ul><li>foo</li><ul><li>bar</li></ul></ul><p>[baz]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>[foo<ul><li>bar]</ul>baz</ul>",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<div>[foo</div><ul><li>bar]</li><li>baz</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",true,false,""]}],
["<ul><li>[foo<ul><li>bar]</ul>baz</ul>",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<p>[foo</p><ul><li>bar]</li><li>baz</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",true,false,""]}],
["foo<ol><li>bar</ol><ul><li>[baz]</ul>quz",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"foo<ol><li>bar</li></ol><div>[baz]</div>quz",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["foo<ol><li>bar</ol><ul><li>[baz]</ul>quz",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"foo<ol><li>bar</li></ol><p>[baz]</p>quz",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["foo<ol><li>bar</ol><ul><li>[baz</ul>quz]",
	[["insertunorderedlist",""]],
	"foo<ol><li>bar</li></ol><ul><li>[baz</li><li>quz]</li></ul>",
	[true],
	{"insertunorderedlist":[true,false,"",false,true,""]}],
["foo<ul><li>[bar]</ul><ol><li>baz</ol>quz",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"foo<div>[bar]</div><ol><li>baz</li></ol>quz",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["foo<ul><li>[bar]</ul><ol><li>baz</ol>quz",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"foo<p>[bar]</p><ol><li>baz</li></ol>quz",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["[foo<ul><li>bar]</ul><ol><li>baz</ol>quz",
	[["insertunorderedlist",""]],
	"<ul><li>[foo</li><li>bar]</li></ul><ol><li>baz</li></ol>quz",
	[true],
	{"insertunorderedlist":[true,false,"",false,true,""]}],
["[foo]<blockquote>bar</blockquote>baz",
	[["insertunorderedlist",""]],
	"<ul><li>[foo]</li></ul><blockquote>bar</blockquote>baz",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["foo<blockquote>[bar]</blockquote>baz",
	[["insertunorderedlist",""]],
	"foo<blockquote><ul><li>[bar]</li></ul></blockquote>baz",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["[foo<blockquote>bar]</blockquote>baz",
	[["insertunorderedlist",""]],
	"<ul><li>[foo</li><ul><li>bar]</li></ul></ul>baz",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</ol><blockquote>[bar]</blockquote>baz",
	[["insertunorderedlist",""]],
	"<ol><li>foo</li></ol><blockquote><ul><li>[bar]</li></ul></blockquote>baz",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["[foo]<blockquote><ol><li>bar</ol></blockquote>baz",
	[["insertunorderedlist",""]],
	"<ul><li>[foo]</li></ul><blockquote><ol><li>bar</li></ol></blockquote>baz",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["foo<blockquote>[bar]<br>baz</blockquote>",
	[["insertunorderedlist",""]],
	"foo<blockquote><ul><li>[bar]</li></ul>baz</blockquote>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["[foo<blockquote>bar]<br>baz</blockquote>",
	[["insertunorderedlist",""]],
	"<ul><li>[foo</li><ul><li>bar]</li></ul></ul><blockquote>baz</blockquote>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</ol><blockquote>[bar]<br>baz</blockquote>",
	[["insertunorderedlist",""]],
	"<ol><li>foo</li></ol><blockquote><ul><li>[bar]</li></ul>baz</blockquote>",
	[true],
	{"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>[foo]<blockquote><p>bar</blockquote><p>baz",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<ul><li>[foo]</li></ul><blockquote><p>bar</p></blockquote><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>[foo]<blockquote><p>bar</blockquote><p>baz",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<ul><li>[foo]</li></ul><blockquote><p>bar</p></blockquote><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>foo<blockquote><p>[bar]</blockquote><p>baz",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<p>foo</p><blockquote><ul><li>[bar]</li></ul></blockquote><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>foo<blockquote><p>[bar]</blockquote><p>baz",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<p>foo</p><blockquote><ul><li>[bar]</li></ul></blockquote><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>[foo<blockquote><p>bar]</blockquote><p>baz",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<ul><li>[foo</li><ul><li>bar]</li></ul></ul><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>[foo<blockquote><p>bar]</blockquote><p>baz",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<ul><li>[foo</li><ul><li>bar]</li></ul></ul><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</ol><blockquote><p>[bar]</blockquote><p>baz",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<ol><li>foo</li></ol><blockquote><ul><li>[bar]</li></ul></blockquote><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</ol><blockquote><p>[bar]</blockquote><p>baz",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<ol><li>foo</li></ol><blockquote><ul><li>[bar]</li></ul></blockquote><p>baz</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<ul id=abc><li>foo<li>[bar]<li>baz</ul>",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<ul id=\"abc\"><li>foo</li></ul><div>[bar]</div><ul><li>baz</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul id=abc><li>foo<li>[bar]<li>baz</ul>",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<ul id=\"abc\"><li>foo</li></ul><p>[bar]</p><ul><li>baz</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul style=color:blue><li>foo<li>[bar]<li>baz</ul>",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<ul style=\"color:rgb(0, 0, 255)\"><li>foo</li></ul><div>[bar]</div><ul style=\"color:rgb(0, 0, 255)\"><li>baz</li></ul>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul style=color:blue><li>foo<li>[bar]<li>baz</ul>",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<ul style=\"color:rgb(0, 0, 255)\"><li>foo</li></ul><div>[bar]</div><ul style=\"color:rgb(0, 0, 255)\"><li>baz</li></ul>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul style=color:blue><li>foo<li>[bar]<li>baz</ul>",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<ul style=\"color:rgb(0, 0, 255)\"><li>foo</li></ul><p>[bar]</p><ul style=\"color:rgb(0, 0, 255)\"><li>baz</li></ul>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul style=color:blue><li>foo<li>[bar]<li>baz</ul>",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<ul style=\"color:rgb(0, 0, 255)\"><li>foo</li></ul><p>[bar]</p><ul style=\"color:rgb(0, 0, 255)\"><li>baz</li></ul>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul style=text-indent:1em><li>foo<li>[bar]<li>baz</ul>",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<ul style=\"text-indent:1em\"><li>foo</li></ul><div>[bar]</div><ul style=\"text-indent:1em\"><li>baz</li></ul>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul style=text-indent:1em><li>foo<li>[bar]<li>baz</ul>",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<ul style=\"text-indent:1em\"><li>foo</li></ul><div>[bar]</div><ul style=\"text-indent:1em\"><li>baz</li></ul>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul style=text-indent:1em><li>foo<li>[bar]<li>baz</ul>",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<ul style=\"text-indent:1em\"><li>foo</li></ul><p>[bar]</p><ul style=\"text-indent:1em\"><li>baz</li></ul>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul style=text-indent:1em><li>foo<li>[bar]<li>baz</ul>",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<ul style=\"text-indent:1em\"><li>foo</li></ul><p>[bar]</p><ul style=\"text-indent:1em\"><li>baz</li></ul>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul id=abc><li>[foo]<li>bar<li>baz</ul>",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<div>[foo]</div><ul id=\"abc\"><li>bar</li><li>baz</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul id=abc><li>[foo]<li>bar<li>baz</ul>",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<p>[foo]</p><ul id=\"abc\"><li>bar</li><li>baz</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul style=color:blue><li>[foo]<li>bar<li>baz</ul>",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<div>[foo]</div><ul style=\"color:rgb(0, 0, 255)\"><li>bar</li><li>baz</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul style=color:blue><li>[foo]<li>bar<li>baz</ul>",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<p>[foo]</p><ul style=\"color:rgb(0, 0, 255)\"><li>bar</li><li>baz</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul style=text-indent:1em><li>[foo]<li>bar<li>baz</ul>",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<div>[foo]</div><ul style=\"text-indent:1em\"><li>bar</li><li>baz</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul style=text-indent:1em><li>[foo]<li>bar<li>baz</ul>",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<p>[foo]</p><ul style=\"text-indent:1em\"><li>bar</li><li>baz</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul id=abc><li>foo<li>bar<li>[baz]</ul>",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<ul id=\"abc\"><li>foo</li><li>bar</li></ul><div>[baz]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul id=abc><li>foo<li>bar<li>[baz]</ul>",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<ul id=\"abc\"><li>foo</li><li>bar</li></ul><p>[baz]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul style=color:blue><li>foo<li>bar<li>[baz]</ul>",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<ul style=\"color:rgb(0, 0, 255)\"><li>foo</li><li>bar</li></ul><div>[baz]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul style=color:blue><li>foo<li>bar<li>[baz]</ul>",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<ul style=\"color:rgb(0, 0, 255)\"><li>foo</li><li>bar</li></ul><p>[baz]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul style=text-indent:1em><li>foo<li>bar<li>[baz]</ul>",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<ul style=\"text-indent:1em\"><li>foo</li><li>bar</li></ul><div>[baz]</div>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul style=text-indent:1em><li>foo<li>bar<li>[baz]</ul>",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<ul style=\"text-indent:1em\"><li>foo</li><li>bar</li></ul><p>[baz]</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo</ul> <p>[bar]",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<ul><li>foo</li> <li>[bar]</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo</ul> <p>[bar]",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<ul><li>foo</li> <li>[bar]</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>[foo]</p> <ul><li>bar</ul>",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<ul><li>[foo]</li> <li>bar</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>[foo]</p> <ul><li>bar</ul>",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<ul><li>[foo]</li> <li>bar</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo</ul> <p>[bar]</p> <ul><li>baz</ul>",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<ul><li>foo</li> <li>[bar]</li> <li>baz</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo</ul> <p>[bar]</p> <ul><li>baz</ul>",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<ul><li>foo</li> <li>[bar]</li> <li>baz</li></ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,false,"",false,true,""]}],
["{<div style=\"font-size: 1.3em\">1</div><div style=\"font-size: 1.1em\">2</div>}",
	[["defaultparagraphseparator","div"],["insertunorderedlist",""]],
	"<ul>{<li style=\"font-size:1.3em\">1</li><li style=\"font-size:1.1em\">2</li>}</ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,false,"",false,true,""]}],
["{<div style=\"font-size: 1.3em\">1</div><div style=\"font-size: 1.1em\">2</div>}",
	[["defaultparagraphseparator","p"],["insertunorderedlist",""]],
	"<ul>{<li style=\"font-size:1.3em\">1</li><li style=\"font-size:1.1em\">2</li>}</ul>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,false,"",false,true,""]}],
["foo[]bar",
	[["italic",""]],
	"foo[]bar",
	[true],
	{"italic":[false,false,"",false,true,""]}],
["<p>[foo</p> <p>bar]</p>",
	[["stylewithcss","true"],["italic",""]],
	"<p><span style=\"font-style:italic\">[foo</span></p> <p><span style=\"font-style:italic\">bar]</span></p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,false,"",false,true,""]}],
["<p>[foo</p> <p>bar]</p>",
	[["stylewithcss","false"],["italic",""]],
	"<p><i>[foo</i></p> <p><i>bar]</i></p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,false,"",false,true,""]}],
["<span>[foo</span> <span>bar]</span>",
	[["stylewithcss","true"],["italic",""]],
	"<span style=\"font-style:italic\"><span>[foo</span> <span>bar]</span></span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,false,"",false,true,""]}],
["<span>[foo</span> <span>bar]</span>",
	[["stylewithcss","false"],["italic",""]],
	"<i><span>[foo</span> <span>bar]</span></i>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,false,"",false,true,""]}],
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
	[["stylewithcss","true"],["italic",""]],
	"<p><span style=\"font-style:italic\">[foo</span></p><p> <span style=\"font-style:italic\"><span>bar</span></span> </p><p><span style=\"font-style:italic\">baz]</span></p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,false,"",false,true,""]}],
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
	[["stylewithcss","false"],["italic",""]],
	"<p><i>[foo</i></p><p> <i><span>bar</span></i> </p><p><i>baz]</i></p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,false,"",false,true,""]}],
["<p>[foo<p><br><p>bar]",
	[["stylewithcss","true"],["italic",""]],
	"<p><span style=\"font-style:italic\">[foo</span></p><p><span style=\"font-style:italic\"><br></span></p><p><span style=\"font-style:italic\">bar]</span></p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,false,"",false,true,""]}],
["<p>[foo<p><br><p>bar]",
	[["stylewithcss","false"],["italic",""]],
	"<p><i>[foo</i></p><p><i><br></i></p><p><i>bar]</i></p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,false,"",false,true,""]}],
["<b>foo[]bar</b>",
	[["italic",""]],
	"<b>foo[]bar</b>",
	[true],
	{"italic":[false,false,"",false,true,""]}],
["<i>foo[]bar</i>",
	[["italic",""]],
	"<i>foo[]bar</i>",
	[true],
	{"italic":[false,true,"",false,false,""]}],
["<span>foo</span>{}<span>bar</span>",
	[["italic",""]],
	"<span>foo</span>{}<span>bar</span>",
	[true],
	{"italic":[false,false,"",false,true,""]}],
["<span>foo[</span><span>]bar</span>",
	[["italic",""]],
	"<span>foo[</span><span>]bar</span>",
	[true],
	{"italic":[false,false,"",false,true,""]}],
["foo[bar]baz",
	[["stylewithcss","true"],["italic",""]],
	"foo<span style=\"font-style:italic\">[bar]</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,false,"",false,true,""]}],
["foo[bar]baz",
	[["stylewithcss","false"],["italic",""]],
	"foo<i>[bar]</i>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,false,"",false,true,""]}],
["foo[bar<b>baz]qoz</b>quz",
	[["stylewithcss","true"],["italic",""]],
	"foo<span style=\"font-style:italic\">[bar</span><b><span style=\"font-style:italic\">baz]</span>qoz</b>quz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,false,"",false,true,""]}],
["foo[bar<b>baz]qoz</b>quz",
	[["stylewithcss","false"],["italic",""]],
	"foo<i>[bar</i><b><i>baz]</i>qoz</b>quz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,false,"",false,true,""]}],
["foo[bar<i>baz]qoz</i>quz",
	[["italic",""]],
	"foo<i>[barbaz]qoz</i>quz",
	[true],
	{"italic":[true,false,"",false,true,""]}],
["{<p><p> <p>foo</p>}",
	[["stylewithcss","true"],["italic",""]],
	"{<p></p><p> </p><p><span style=\"font-style:italic\">foo</span></p>}",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,false,"",false,true,""]}],
["{<p><p> <p>foo</p>}",
	[["stylewithcss","false"],["italic",""]],
	"{<p></p><p> </p><p><i>foo</i></p>}",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,false,"",false,true,""]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
	[["stylewithcss","true"],["italic",""]],
	"<table><tbody><tr><td>foo</td><td>b<span style=\"font-style:italic\">[a]</span>r</td><td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,false,"",false,true,""]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
	[["stylewithcss","false"],["italic",""]],
	"<table><tbody><tr><td>foo</td><td>b<i>[a]</i>r</td><td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,false,"",false,true,""]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","true"],["italic",""]],
	"<table><tbody><tr><td>foo</td>{<td><span style=\"font-style:italic\">bar</span></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,false,"",false,true,""]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","false"],["italic",""]],
	"<table><tbody><tr><td>foo</td>{<td><i>bar</i></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,false,"",false,true,""]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","true"],["italic",""]],
	"<table><tbody><tr>{<td><span style=\"font-style:italic\">foo</span></td><td><span style=\"font-style:italic\">bar</span></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,false,"",false,true,""]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","false"],["italic",""]],
	"<table><tbody><tr>{<td><i>foo</i></td><td><i>bar</i></td>}<td>baz</td></tr></tbody></table>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,false,"",false,true,""]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","true"],["italic",""]],
	"<table><tbody>{<tr><td><span style=\"font-style:italic\">foo</span></td><td><span style=\"font-style:italic\">bar</span></td><td><span style=\"font-style:italic\">baz</span></td></tr>}</tbody></table>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,false,"",false,true,""]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","false"],["italic",""]],
	"<table><tbody>{<tr><td><i>foo</i></td><td><i>bar</i></td><td><i>baz</i></td></tr>}</tbody></table>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,false,"",false,true,""]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","true"],["italic",""]],
	"<table>{<tbody><tr><td><span style=\"font-style:italic\">foo</span></td><td><span style=\"font-style:italic\">bar</span></td><td><span style=\"font-style:italic\">baz</span></td></tr></tbody>}</table>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,false,"",false,true,""]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
	[["stylewithcss","false"],["italic",""]],
	"<table>{<tbody><tr><td><i>foo</i></td><td><i>bar</i></td><td><i>baz</i></td></tr></tbody>}</table>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,false,"",false,true,""]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
	[["stylewithcss","true"],["italic",""]],
	"{<table><tbody><tr><td><span style=\"font-style:italic\">foo</span></td><td><span style=\"font-style:italic\">bar</span></td><td><span style=\"font-style:italic\">baz</span></td></tr></tbody></table>}",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,false,"",false,true,""]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
	[["stylewithcss","false"],["italic",""]],
	"{<table><tbody><tr><td><i>foo</i></td><td><i>bar</i></td><td><i>baz</i></td></tr></tbody></table>}",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,false,"",false,true,""]}],
["foo<span style=\"font-style: italic\">[bar]</span>baz",
	[["stylewithcss","true"],["italic",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,true,"",false,false,""]}],
["foo<span style=\"font-style: italic\">[bar]</span>baz",
	[["stylewithcss","false"],["italic",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,true,"",false,false,""]}],
["foo<address>[bar]</address>baz",
	[["stylewithcss","true"],["italic",""]],
	"foo<address><span style=\"font-style:normal\">[bar]</span></address>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,true,"",false,false,""]}],
["foo<address>[bar]</address>baz",
	[["stylewithcss","false"],["italic",""]],
	"foo<address><span style=\"font-style:normal\">[bar]</span></address>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,true,"",false,false,""]}],
["foo<cite>[bar]</cite>baz",
	[["stylewithcss","true"],["italic",""]],
	"foo<cite><span style=\"font-style:normal\">[bar]</span></cite>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,true,"",false,false,""]}],
["foo<cite>[bar]</cite>baz",
	[["stylewithcss","false"],["italic",""]],
	"foo<cite><span style=\"font-style:normal\">[bar]</span></cite>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,true,"",false,false,""]}],
["foo<dfn>[bar]</dfn>baz",
	[["stylewithcss","true"],["italic",""]],
	"foo<dfn><span style=\"font-style:normal\">[bar]</span></dfn>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,true,"",false,false,""]}],
["foo<dfn>[bar]</dfn>baz",
	[["stylewithcss","false"],["italic",""]],
	"foo<dfn><span style=\"font-style:normal\">[bar]</span></dfn>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,true,"",false,false,""]}],
["foo<em>[bar]</em>baz",
	[["italic",""]],
	"foo[bar]baz",
	[true],
	{"italic":[false,true,"",false,false,""]}],
["foo<i>[bar]</i>baz",
	[["stylewithcss","true"],["italic",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,true,"",false,false,""]}],
["foo<i>[bar]</i>baz",
	[["stylewithcss","false"],["italic",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,true,"",false,false,""]}],
["foo<var>[bar]</var>baz",
	[["stylewithcss","true"],["italic",""]],
	"foo<var><span style=\"font-style:normal\">[bar]</span></var>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,true,"",false,false,""]}],
["foo<var>[bar]</var>baz",
	[["stylewithcss","false"],["italic",""]],
	"foo<var><span style=\"font-style:normal\">[bar]</span></var>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,true,"",false,false,""]}],
["foo{<address>bar</address>}baz",
	[["stylewithcss","true"],["italic",""]],
	"foo{<address><span style=\"font-style:normal\">bar</span></address>}baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,true,"",false,false,""]}],
["foo{<address>bar</address>}baz",
	[["stylewithcss","false"],["italic",""]],
	"foo{<address><span style=\"font-style:normal\">bar</span></address>}baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,true,"",false,false,""]}],
["foo{<cite>bar</cite>}baz",
	[["stylewithcss","true"],["italic",""]],
	"foo{<cite><span style=\"font-style:normal\">bar</span></cite>}baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,true,"",false,false,""]}],
["foo{<cite>bar</cite>}baz",
	[["stylewithcss","false"],["italic",""]],
	"foo{<cite><span style=\"font-style:normal\">bar</span></cite>}baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,true,"",false,false,""]}],
["foo{<dfn>bar</dfn>}baz",
	[["stylewithcss","true"],["italic",""]],
	"foo{<dfn><span style=\"font-style:normal\">bar</span></dfn>}baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,true,"",false,false,""]}],
["foo{<dfn>bar</dfn>}baz",
	[["stylewithcss","false"],["italic",""]],
	"foo{<dfn><span style=\"font-style:normal\">bar</span></dfn>}baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,true,"",false,false,""]}],
["foo{<em>bar</em>}baz",
	[["italic",""]],
	"foo{bar}baz",
	[true],
	{"italic":[false,true,"",false,false,""]}],
["foo{<i>bar</i>}baz",
	[["stylewithcss","true"],["italic",""]],
	"foo{bar}baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,true,"",false,false,""]}],
["foo{<i>bar</i>}baz",
	[["stylewithcss","false"],["italic",""]],
	"foo{bar}baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,true,"",false,false,""]}],
["foo{<var>bar</var>}baz",
	[["stylewithcss","true"],["italic",""]],
	"foo{<var><span style=\"font-style:normal\">bar</span></var>}baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,true,"",false,false,""]}],
["foo{<var>bar</var>}baz",
	[["stylewithcss","false"],["italic",""]],
	"foo{<var><span style=\"font-style:normal\">bar</span></var>}baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,true,"",false,false,""]}],
["foo<address>b[a]r</address>baz",
	[["stylewithcss","true"],["italic",""]],
	"foo<address>b<span style=\"font-style:normal\">[a]</span>r</address>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,true,"",false,false,""]}],
["foo<address>b[a]r</address>baz",
	[["stylewithcss","false"],["italic",""]],
	"foo<address>b<span style=\"font-style:normal\">[a]</span>r</address>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,true,"",false,false,""]}],
["foo<cite>b[a]r</cite>baz",
	[["stylewithcss","true"],["italic",""]],
	"foo<cite>b<span style=\"font-style:normal\">[a]</span>r</cite>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,true,"",false,false,""]}],
["foo<cite>b[a]r</cite>baz",
	[["stylewithcss","false"],["italic",""]],
	"foo<cite>b<span style=\"font-style:normal\">[a]</span>r</cite>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,true,"",false,false,""]}],
["foo<dfn>b[a]r</dfn>baz",
	[["stylewithcss","true"],["italic",""]],
	"foo<dfn>b<span style=\"font-style:normal\">[a]</span>r</dfn>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,true,"",false,false,""]}],
["foo<dfn>b[a]r</dfn>baz",
	[["stylewithcss","false"],["italic",""]],
	"foo<dfn>b<span style=\"font-style:normal\">[a]</span>r</dfn>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,true,"",false,false,""]}],
["foo<em>b[a]r</em>baz",
	[["stylewithcss","true"],["italic",""]],
	"foo<span style=\"font-style:italic\">b</span>[a]<span style=\"font-style:italic\">r</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,true,"",false,false,""]}],
["foo<em>b[a]r</em>baz",
	[["stylewithcss","false"],["italic",""]],
	"foo<i>b</i>[a]<i>r</i>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,true,"",false,false,""]}],
["foo<i>b[a]r</i>baz",
	[["stylewithcss","true"],["italic",""]],
	"foo<span style=\"font-style:italic\">b</span>[a]<span style=\"font-style:italic\">r</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,true,"",false,false,""]}],
["foo<i>b[a]r</i>baz",
	[["stylewithcss","false"],["italic",""]],
	"foo<i>b</i>[a]<i>r</i>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,true,"",false,false,""]}],
["foo<var>b[a]r</var>baz",
	[["stylewithcss","true"],["italic",""]],
	"foo<var>b<span style=\"font-style:normal\">[a]</span>r</var>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,true,"",false,false,""]}],
["foo<var>b[a]r</var>baz",
	[["stylewithcss","false"],["italic",""]],
	"foo<var>b<span style=\"font-style:normal\">[a]</span>r</var>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,true,"",false,false,""]}],
["fo[o<address>bar</address>b]az",
	[["stylewithcss","true"],["italic",""]],
	"fo<span style=\"font-style:italic\">[o</span><address>bar</address><span style=\"font-style:italic\">b]</span>az",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[true,false,"",false,true,""]}],
["fo[o<address>bar</address>b]az",
	[["stylewithcss","false"],["italic",""]],
	"fo<i>[o</i><address>bar</address><i>b]</i>az",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[true,false,"",false,true,""]}],
["fo[o<cite>bar</cite>b]az",
	[["stylewithcss","true"],["italic",""]],
	"fo<span style=\"font-style:italic\">[o<cite>bar</cite>b]</span>az",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[true,false,"",false,true,""]}],
["fo[o<cite>bar</cite>b]az",
	[["stylewithcss","false"],["italic",""]],
	"fo<i>[o<cite>bar</cite>b]</i>az",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[true,false,"",false,true,""]}],
["fo[o<dfn>bar</dfn>b]az",
	[["stylewithcss","true"],["italic",""]],
	"fo<span style=\"font-style:italic\">[o<dfn>bar</dfn>b]</span>az",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[true,false,"",false,true,""]}],
["fo[o<dfn>bar</dfn>b]az",
	[["stylewithcss","false"],["italic",""]],
	"fo<i>[o<dfn>bar</dfn>b]</i>az",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[true,false,"",false,true,""]}],
["fo[o<em>bar</em>b]az",
	[["stylewithcss","true"],["italic",""]],
	"fo<span style=\"font-style:italic\">[obarb]</span>az",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[true,false,"",false,true,""]}],
["fo[o<em>bar</em>b]az",
	[["stylewithcss","false"],["italic",""]],
	"fo<i>[obarb]</i>az",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[true,false,"",false,true,""]}],
["fo[o<i>bar</i>b]az",
	[["stylewithcss","true"],["italic",""]],
	"fo<span style=\"font-style:italic\">[obarb]</span>az",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[true,false,"",false,true,""]}],
["fo[o<i>bar</i>b]az",
	[["stylewithcss","false"],["italic",""]],
	"fo<i>[obarb]</i>az",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[true,false,"",false,true,""]}],
["fo[o<var>bar</var>b]az",
	[["stylewithcss","true"],["italic",""]],
	"fo<span style=\"font-style:italic\">[o<var>bar</var>b]</span>az",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[true,false,"",false,true,""]}],
["fo[o<var>bar</var>b]az",
	[["stylewithcss","false"],["italic",""]],
	"fo<i>[o<var>bar</var>b]</i>az",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[true,false,"",false,true,""]}],
["foo[<address>bar</address>baz]",
	[["stylewithcss","true"],["italic",""]],
	"foo[<address>bar</address><span style=\"font-style:italic\">baz]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[true,false,"",false,true,""]}],
["foo[<address>bar</address>baz]",
	[["stylewithcss","false"],["italic",""]],
	"foo[<address>bar</address><i>baz]</i>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[true,false,"",false,true,""]}],
["foo[<cite>bar</cite>baz]",
	[["stylewithcss","true"],["italic",""]],
	"foo[<cite>bar</cite><span style=\"font-style:italic\">baz]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[true,false,"",false,true,""]}],
["foo[<cite>bar</cite>baz]",
	[["stylewithcss","false"],["italic",""]],
	"foo[<cite>bar</cite><i>baz]</i>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[true,false,"",false,true,""]}],
["foo[<dfn>bar</dfn>baz]",
	[["stylewithcss","true"],["italic",""]],
	"foo[<dfn>bar</dfn><span style=\"font-style:italic\">baz]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[true,false,"",false,true,""]}],
["foo[<dfn>bar</dfn>baz]",
	[["stylewithcss","false"],["italic",""]],
	"foo[<dfn>bar</dfn><i>baz]</i>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[true,false,"",false,true,""]}],
["foo[<em>bar</em>baz]",
	[["stylewithcss","true"],["italic",""]],
	"foo[<span style=\"font-style:italic\">barbaz]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[true,false,"",false,true,""]}],
["foo[<em>bar</em>baz]",
	[["stylewithcss","false"],["italic",""]],
	"foo[<i>barbaz]</i>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[true,false,"",false,true,""]}],
["foo[<i>bar</i>baz]",
	[["stylewithcss","true"],["italic",""]],
	"foo[<span style=\"font-style:italic\">barbaz]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[true,false,"",false,true,""]}],
["foo[<i>bar</i>baz]",
	[["stylewithcss","false"],["italic",""]],
	"foo[<i>barbaz]</i>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[true,false,"",false,true,""]}],
["foo[<var>bar</var>baz]",
	[["stylewithcss","true"],["italic",""]],
	"foo[<var>bar</var><span style=\"font-style:italic\">baz]</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[true,false,"",false,true,""]}],
["foo[<var>bar</var>baz]",
	[["stylewithcss","false"],["italic",""]],
	"foo[<var>bar</var><i>baz]</i>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[true,false,"",false,true,""]}],
["[foo<address>bar</address>]baz",
	[["stylewithcss","true"],["italic",""]],
	"<span style=\"font-style:italic\">[foo</span><address>bar</address>]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[true,false,"",false,true,""]}],
["[foo<address>bar</address>]baz",
	[["stylewithcss","false"],["italic",""]],
	"<i>[foo</i><address>bar</address>]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[true,false,"",false,true,""]}],
["[foo<cite>bar</cite>]baz",
	[["stylewithcss","true"],["italic",""]],
	"<span style=\"font-style:italic\">[foo<cite>bar</cite></span>]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[true,false,"",false,true,""]}],
["[foo<cite>bar</cite>]baz",
	[["stylewithcss","false"],["italic",""]],
	"<i>[foo<cite>bar</cite></i>]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[true,false,"",false,true,""]}],
["[foo<dfn>bar</dfn>]baz",
	[["stylewithcss","true"],["italic",""]],
	"<span style=\"font-style:italic\">[foo<dfn>bar</dfn></span>]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[true,false,"",false,true,""]}],
["[foo<dfn>bar</dfn>]baz",
	[["stylewithcss","false"],["italic",""]],
	"<i>[foo<dfn>bar</dfn></i>]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[true,false,"",false,true,""]}],
["[foo<em>bar</em>]baz",
	[["stylewithcss","true"],["italic",""]],
	"<span style=\"font-style:italic\">[foobar</span>]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[true,false,"",false,true,""]}],
["[foo<em>bar</em>]baz",
	[["stylewithcss","false"],["italic",""]],
	"<i>[foobar</i>]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[true,false,"",false,true,""]}],
["[foo<i>bar</i>]baz",
	[["stylewithcss","true"],["italic",""]],
	"<span style=\"font-style:italic\">[foobar</span>]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[true,false,"",false,true,""]}],
["[foo<i>bar</i>]baz",
	[["stylewithcss","false"],["italic",""]],
	"<i>[foobar</i>]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[true,false,"",false,true,""]}],
["[foo<var>bar</var>]baz",
	[["stylewithcss","true"],["italic",""]],
	"<span style=\"font-style:italic\">[foo<var>bar</var></span>]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[true,false,"",false,true,""]}],
["[foo<var>bar</var>]baz",
	[["stylewithcss","false"],["italic",""]],
	"<i>[foo<var>bar</var></i>]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[true,false,"",false,true,""]}],
["foo<span style=\"font-style: italic\">[bar]</span>baz",
	[["stylewithcss","true"],["italic",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,true,"",false,false,""]}],
["foo<span style=\"font-style: italic\">[bar]</span>baz",
	[["stylewithcss","false"],["italic",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,true,"",false,false,""]}],
["foo<span style=\"font-style: oblique\">[bar]</span>baz",
	[["stylewithcss","true"],["italic",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,true,"",false,false,""]}],
["foo<span style=\"font-style: oblique\">[bar]</span>baz",
	[["stylewithcss","false"],["italic",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,true,"",false,false,""]}],
["foo<span style=\"font-style: oblique\">b[a]r</span>baz",
	[["stylewithcss","true"],["italic",""]],
	"foo<span style=\"font-style:oblique\">b</span>[a]<span style=\"font-style:oblique\">r</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,true,"",false,false,""]}],
["foo<span style=\"font-style: oblique\">b[a]r</span>baz",
	[["stylewithcss","false"],["italic",""]],
	"foo<span style=\"font-style:oblique\">b</span>[a]<span style=\"font-style:oblique\">r</span>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,true,"",false,false,""]}],
["<i>{<p>foo</p><p>bar</p>}<p>baz</p></i>",
	[["stylewithcss","true"],["italic",""]],
	"{<p>foo</p><p>bar</p>}<p><span style=\"font-style:italic\">baz</span></p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,true,"",false,false,""]}],
["<i>{<p>foo</p><p>bar</p>}<p>baz</p></i>",
	[["stylewithcss","false"],["italic",""]],
	"{<p>foo</p><p>bar</p>}<p><i>baz</i></p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,true,"",false,false,""]}],
["<i><p>foo[<b>bar</b>}</p><p>baz</p></i>",
	[["stylewithcss","true"],["italic",""]],
	"<p><span style=\"font-style:italic\">foo[</span><b>bar</b>}</p><p><span style=\"font-style:italic\">baz</span></p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,true,"",false,false,""]}],
["<i><p>foo[<b>bar</b>}</p><p>baz</p></i>",
	[["stylewithcss","false"],["italic",""]],
	"<p><i>foo[</i><b>bar</b>}</p><p><i>baz</i></p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,true,"",false,false,""]}],
["foo [bar <b>baz] qoz</b> quz sic",
	[["stylewithcss","true"],["italic",""]],
	"foo <span style=\"font-style:italic\">[bar </span><b><span style=\"font-style:italic\">baz]</span> qoz</b> quz sic",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,false,"",false,true,""]}],
["foo [bar <b>baz] qoz</b> quz sic",
	[["stylewithcss","false"],["italic",""]],
	"foo <i>[bar </i><b><i>baz]</i> qoz</b> quz sic",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,false,"",false,true,""]}],
["foo bar <b>baz [qoz</b> quz] sic",
	[["stylewithcss","true"],["italic",""]],
	"foo bar <b>baz <span style=\"font-style:italic\">[qoz</span></b><span style=\"font-style:italic\"> quz]</span> sic",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,false,"",false,true,""]}],
["foo bar <b>baz [qoz</b> quz] sic",
	[["stylewithcss","false"],["italic",""]],
	"foo bar <b>baz <i>[qoz</i></b><i> quz]</i> sic",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,false,"",false,true,""]}],
["foo [bar <i>baz] qoz</i> quz sic",
	[["italic",""]],
	"foo <i>[bar baz] qoz</i> quz sic",
	[true],
	{"italic":[true,false,"",false,true,""]}],
["foo bar <i>baz [qoz</i> quz] sic",
	[["italic",""]],
	"foo bar <i>baz [qoz quz]</i> sic",
	[true],
	{"italic":[true,false,"",false,true,""]}],
["fo[o<i>b]ar</i>baz",
	[["italic",""]],
	"fo<i>[ob]ar</i>baz",
	[true],
	{"italic":[true,false,"",false,true,""]}],
["foo<i>ba[r</i>b]az",
	[["italic",""]],
	"foo<i>ba[rb]</i>az",
	[true],
	{"italic":[true,false,"",false,true,""]}],
["fo[o<i>bar</i>b]az",
	[["stylewithcss","true"],["italic",""]],
	"fo<span style=\"font-style:italic\">[obarb]</span>az",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[true,false,"",false,true,""]}],
["fo[o<i>bar</i>b]az",
	[["stylewithcss","false"],["italic",""]],
	"fo<i>[obarb]</i>az",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[true,false,"",false,true,""]}],
["foo[<i>b]ar</i>baz",
	[["stylewithcss","true"],["italic",""]],
	"foo[b]<span style=\"font-style:italic\">ar</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,true,"",false,false,""]}],
["foo[<i>b]ar</i>baz",
	[["stylewithcss","false"],["italic",""]],
	"foo[b]<i>ar</i>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,true,"",false,false,""]}],
["foo<i>ba[r</i>]baz",
	[["stylewithcss","true"],["italic",""]],
	"foo<span style=\"font-style:italic\">ba</span>[r]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,true,"",false,false,""]}],
["foo<i>ba[r</i>]baz",
	[["stylewithcss","false"],["italic",""]],
	"foo<i>ba</i>[r]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,true,"",false,false,""]}],
["foo[<i>bar</i>]baz",
	[["stylewithcss","true"],["italic",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,true,"",false,false,""]}],
["foo[<i>bar</i>]baz",
	[["stylewithcss","false"],["italic",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,true,"",false,false,""]}],
["foo<i>[bar]</i>baz",
	[["stylewithcss","true"],["italic",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,true,"",false,false,""]}],
["foo<i>[bar]</i>baz",
	[["stylewithcss","false"],["italic",""]],
	"foo[bar]baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,true,"",false,false,""]}],
["foo{<i>bar</i>}baz",
	[["stylewithcss","true"],["italic",""]],
	"foo{bar}baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,true,"",false,false,""]}],
["foo{<i>bar</i>}baz",
	[["stylewithcss","false"],["italic",""]],
	"foo{bar}baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,true,"",false,false,""]}],
["fo[o<span style=font-style:italic>b]ar</span>baz",
	[["italic",""]],
	"fo<span style=\"font-style:italic\">[ob]ar</span>baz",
	[true],
	{"italic":[true,false,"",false,true,""]}],
["fo[o<span style=font-style:oblique>b]ar</span>baz",
	[["stylewithcss","true"],["italic",""]],
	"fo<span style=\"font-style:italic\">[o</span><span style=\"font-style:oblique\"><span style=\"font-style:italic\">b]</span>ar</span>baz",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[true,false,"",false,true,""]}],
["fo[o<span style=font-style:oblique>b]ar</span>baz",
	[["stylewithcss","false"],["italic",""]],
	"fo<i>[o</i><span style=\"font-style:oblique\"><i>b]</i>ar</span>baz",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[true,false,"",false,true,""]}],
["<span style=font-style:italic>fo[o</span><span style=font-style:oblique>b]ar</span>",
	[["stylewithcss","true"],["italic",""]],
	"<span style=\"font-style:italic\">fo</span>[ob]<span style=\"font-style:oblique\">ar</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,true,"",false,false,""]}],
["<span style=font-style:italic>fo[o</span><span style=font-style:oblique>b]ar</span>",
	[["stylewithcss","false"],["italic",""]],
	"<i>fo</i>[ob]<span style=\"font-style:oblique\">ar</span>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,true,"",false,false,""]}],
["<span style=font-style:oblique>fo[o</span><span style=font-style:italic>b]ar</span>",
	[["stylewithcss","true"],["italic",""]],
	"<span style=\"font-style:oblique\">fo</span>[ob]<span style=\"font-style:italic\">ar</span>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,true,"",false,false,""]}],
["<span style=font-style:oblique>fo[o</span><span style=font-style:italic>b]ar</span>",
	[["stylewithcss","false"],["italic",""]],
	"<span style=\"font-style:oblique\">fo</span>[ob]<i>ar</i>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,true,"",false,false,""]}],
["<i>fo[o</i><address>b]ar</address>",
	[["stylewithcss","true"],["italic",""]],
	"<span style=\"font-style:italic\">fo</span>[o<address><span style=\"font-style:normal\">b]</span>ar</address>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"italic":[false,true,"",false,false,""]}],
["<i>fo[o</i><address>b]ar</address>",
	[["stylewithcss","false"],["italic",""]],
	"<i>fo</i>[o<address><span style=\"font-style:normal\">b]</span>ar</address>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"italic":[false,true,"",false,false,""]}],
["foo[]bar<p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\">foo[]bar</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["foo[]bar<p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\">foo[]bar</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["foo[]bar<p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\">foo[]bar</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["foo[]bar<p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\">foo[]bar</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<span>foo</span>{}<span>bar</span><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><span>foo</span>{}<span>bar</span></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<span>foo</span>{}<span>bar</span><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><span>foo</span>{}<span>bar</span></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<span>foo</span>{}<span>bar</span><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><span>foo</span>{}<span>bar</span></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<span>foo</span>{}<span>bar</span><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><span>foo</span>{}<span>bar</span></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<span>foo[</span><span>]bar</span><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><span>foo[</span><span>]bar</span></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<span>foo[</span><span>]bar</span><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><span>foo[</span><span>]bar</span></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<span>foo[</span><span>]bar</span><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><span>foo[</span><span>]bar</span></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<span>foo[</span><span>]bar</span><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><span>foo[</span><span>]bar</span></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["foo[bar]baz<p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\">foo[bar]baz</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["foo[bar]baz<p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\">foo[bar]baz</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["foo[bar]baz<p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\">foo[bar]baz</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["foo[bar]baz<p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\">foo[bar]baz</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["foo[bar<b>baz]qoz</b>quz<p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\">foo[bar<b>baz]qoz</b>quz</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["foo[bar<b>baz]qoz</b>quz<p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\">foo[bar<b>baz]qoz</b>quz</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["foo[bar<b>baz]qoz</b>quz<p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\">foo[bar<b>baz]qoz</b>quz</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["foo[bar<b>baz]qoz</b>quz<p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\">foo[bar<b>baz]qoz</b>quz</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<p>foo[]bar<p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><p>foo[]bar</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<p>foo[]bar<p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><p>foo[]bar</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<p>foo[]bar<p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><p>foo[]bar</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<p>foo[]bar<p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><p>foo[]bar</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<p>foo[bar]baz<p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><p>foo[bar]baz</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<p>foo[bar]baz<p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><p>foo[bar]baz</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<p>foo[bar]baz<p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><p>foo[bar]baz</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<p>foo[bar]baz<p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><p>foo[bar]baz</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<h1>foo[bar]baz</h1><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><h1>foo[bar]baz</h1></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<h1>foo[bar]baz</h1><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><h1>foo[bar]baz</h1></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<h1>foo[bar]baz</h1><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><h1>foo[bar]baz</h1></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<h1>foo[bar]baz</h1><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><h1>foo[bar]baz</h1></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<pre>foo[bar]baz</pre><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><pre>foo[bar]baz</pre></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<pre>foo[bar]baz</pre><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><pre>foo[bar]baz</pre></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<pre>foo[bar]baz</pre><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><pre>foo[bar]baz</pre></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<pre>foo[bar]baz</pre><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><pre>foo[bar]baz</pre></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<xmp>foo[bar]baz</xmp><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><xmp>foo[bar]baz</xmp></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<xmp>foo[bar]baz</xmp><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><xmp>foo[bar]baz</xmp></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<xmp>foo[bar]baz</xmp><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><xmp>foo[bar]baz</xmp></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<xmp>foo[bar]baz</xmp><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><xmp>foo[bar]baz</xmp></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<center><p>[foo]<p>bar</center><p>extra",
	[["justifycenter",""]],
	"<center><p>[foo]</p><p>bar</p></center><p>extra</p>",
	[true],
	{"justifycenter":[false,true,"center",false,true,"center"]}],
["<center><p>[foo<p>bar]</center><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><p>[foo</p><p>bar]</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,true,"center",false,true,"center"]}],
["<center><p>[foo<p>bar]</center><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><p>[foo</p><p>bar]</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,true,"center",false,true,"center"]}],
["<center><p>[foo<p>bar]</center><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><p>[foo</p><p>bar]</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,true,"center",false,true,"center"]}],
["<center><p>[foo<p>bar]</center><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><p>[foo</p><p>bar]</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,true,"center",false,true,"center"]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<table><tbody><tr><td>foo</td><td><div style=\"text-align:center\">b[a]r</div></td><td>baz</td></tr></tbody></table><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<table><tbody><tr><td>foo</td><td><div style=\"text-align:center\">b[a]r</div></td><td>baz</td></tr></tbody></table><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<table><tbody><tr><td>foo</td><td><div style=\"text-align:center\">b[a]r</div></td><td>baz</td></tr></tbody></table><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<table><tbody><tr><td>foo</td><td><div style=\"text-align:center\">b[a]r</div></td><td>baz</td></tr></tbody></table><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<table><tbody><tr><td>foo</td>{<td><div style=\"text-align:center\">bar</div></td>}<td>baz</td></tr></tbody></table><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<table><tbody><tr><td>foo</td>{<td><div style=\"text-align:center\">bar</div></td>}<td>baz</td></tr></tbody></table><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<table><tbody><tr><td>foo</td>{<td><div style=\"text-align:center\">bar</div></td>}<td>baz</td></tr></tbody></table><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<table><tbody><tr><td>foo</td>{<td><div style=\"text-align:center\">bar</div></td>}<td>baz</td></tr></tbody></table><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<table><tbody><tr>{<td><div style=\"text-align:center\">foo</div></td><td><div style=\"text-align:center\">bar</div></td>}<td>baz</td></tr></tbody></table><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<table><tbody><tr>{<td><div style=\"text-align:center\">foo</div></td><td><div style=\"text-align:center\">bar</div></td>}<td>baz</td></tr></tbody></table><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<table><tbody><tr>{<td><div style=\"text-align:center\">foo</div></td><td><div style=\"text-align:center\">bar</div></td>}<td>baz</td></tr></tbody></table><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<table><tbody><tr>{<td><div style=\"text-align:center\">foo</div></td><td><div style=\"text-align:center\">bar</div></td>}<td>baz</td></tr></tbody></table><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><table><tbody>{<tr><td>foo</td><td>bar</td><td>baz</td></tr>}</tbody></table></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><table><tbody>{<tr><td>foo</td><td>bar</td><td>baz</td></tr>}</tbody></table></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><table><tbody>{<tr><td>foo</td><td>bar</td><td>baz</td></tr>}</tbody></table></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><table><tbody>{<tr><td>foo</td><td>bar</td><td>baz</td></tr>}</tbody></table></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><table>{<tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody>}</table></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><table>{<tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody>}</table></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><table>{<tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody>}</table></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><table>{<tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody>}</table></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}<p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\">{<table><tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody></table>}</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}<p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\">{<table><tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody></table>}</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}<p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\">{<table><tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody></table>}</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}<p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\">{<table><tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody></table>}</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table align=center><tbody><tr><td>foo<td>b[a]r<td>baz</table><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<table align=\"center\"><tbody><tr><td>foo</td><td><div style=\"text-align:center\">b[a]r</div></td><td>baz</td></tr></tbody></table><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table align=center><tbody><tr><td>foo<td>b[a]r<td>baz</table><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<table align=\"center\"><tbody><tr><td>foo</td><td><div style=\"text-align:center\">b[a]r</div></td><td>baz</td></tr></tbody></table><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table align=center><tbody><tr><td>foo<td>b[a]r<td>baz</table><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<table align=\"center\"><tbody><tr><td>foo</td><td><div style=\"text-align:center\">b[a]r</div></td><td>baz</td></tr></tbody></table><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table align=center><tbody><tr><td>foo<td>b[a]r<td>baz</table><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<table align=\"center\"><tbody><tr><td>foo</td><td><div style=\"text-align:center\">b[a]r</div></td><td>baz</td></tr></tbody></table><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table align=center><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<table align=\"center\"><tbody><tr><td>foo</td>{<td><div style=\"text-align:center\">bar</div></td>}<td>baz</td></tr></tbody></table><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table align=center><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<table align=\"center\"><tbody><tr><td>foo</td>{<td><div style=\"text-align:center\">bar</div></td>}<td>baz</td></tr></tbody></table><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table align=center><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<table align=\"center\"><tbody><tr><td>foo</td>{<td><div style=\"text-align:center\">bar</div></td>}<td>baz</td></tr></tbody></table><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table align=center><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<table align=\"center\"><tbody><tr><td>foo</td>{<td><div style=\"text-align:center\">bar</div></td>}<td>baz</td></tr></tbody></table><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table align=center><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<table align=\"center\"><tbody><tr>{<td><div style=\"text-align:center\">foo</div></td><td><div style=\"text-align:center\">bar</div></td>}<td>baz</td></tr></tbody></table><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table align=center><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<table align=\"center\"><tbody><tr>{<td><div style=\"text-align:center\">foo</div></td><td><div style=\"text-align:center\">bar</div></td>}<td>baz</td></tr></tbody></table><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table align=center><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<table align=\"center\"><tbody><tr>{<td><div style=\"text-align:center\">foo</div></td><td><div style=\"text-align:center\">bar</div></td>}<td>baz</td></tr></tbody></table><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table align=center><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<table align=\"center\"><tbody><tr>{<td><div style=\"text-align:center\">foo</div></td><td><div style=\"text-align:center\">bar</div></td>}<td>baz</td></tr></tbody></table><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table align=center><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><table><tbody>{<tr><td>foo</td><td>bar</td><td>baz</td></tr>}</tbody></table></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table align=center><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><table><tbody>{<tr><td>foo</td><td>bar</td><td>baz</td></tr>}</tbody></table></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table align=center><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><table><tbody>{<tr><td>foo</td><td>bar</td><td>baz</td></tr>}</tbody></table></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table align=center><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><table><tbody>{<tr><td>foo</td><td>bar</td><td>baz</td></tr>}</tbody></table></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table align=center data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><table>{<tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody>}</table></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table align=center data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><table>{<tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody>}</table></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table align=center data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><table>{<tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody>}</table></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table align=center data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><table>{<tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody>}</table></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["{<table align=center><tr><td>foo<td>bar<td>baz</table>}<p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\">{<table><tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody></table>}</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["{<table align=center><tr><td>foo<td>bar<td>baz</table>}<p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\">{<table><tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody></table>}</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["{<table align=center><tr><td>foo<td>bar<td>baz</table>}<p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\">{<table><tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody></table>}</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["{<table align=center><tr><td>foo<td>bar<td>baz</table>}<p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\">{<table><tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody></table>}</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<table><tbody align=center><tr><td>foo<td>b[a]r<td>baz</table><p>extra",
	[["justifycenter",""]],
	"<table><tbody align=\"center\"><tr><td>foo</td><td>b[a]r</td><td>baz</td></tr></tbody></table><p>extra</p>",
	[true],
	{"justifycenter":[false,true,"center",false,true,"center"]}],
["<table><tbody align=center><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table><p>extra",
	[["justifycenter",""]],
	"<table><tbody align=\"center\"><tr><td>foo</td>{<td>bar</td>}<td>baz</td></tr></tbody></table><p>extra</p>",
	[true],
	{"justifycenter":[false,true,"center",false,true,"center"]}],
["<table><tbody align=center><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table><p>extra",
	[["justifycenter",""]],
	"<table><tbody align=\"center\"><tr>{<td>foo</td><td>bar</td>}<td>baz</td></tr></tbody></table><p>extra</p>",
	[true],
	{"justifycenter":[false,true,"center",false,true,"center"]}],
["<table><tbody align=center data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><table><tbody>{<tr><td>foo</td><td>bar</td><td>baz</td></tr>}</tbody></table></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,true,"center",false,true,"center"]}],
["<table><tbody align=center data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><table><tbody>{<tr><td>foo</td><td>bar</td><td>baz</td></tr>}</tbody></table></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,true,"center",false,true,"center"]}],
["<table><tbody align=center data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><table><tbody>{<tr><td>foo</td><td>bar</td><td>baz</td></tr>}</tbody></table></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,true,"center",false,true,"center"]}],
["<table><tbody align=center data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><table><tbody>{<tr><td>foo</td><td>bar</td><td>baz</td></tr>}</tbody></table></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,true,"center",false,true,"center"]}],
["<table data-start=0 data-end=1><tbody align=center><tr><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><table>{<tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody>}</table></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,true,"center",false,true,"center"]}],
["<table data-start=0 data-end=1><tbody align=center><tr><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><table>{<tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody>}</table></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,true,"center",false,true,"center"]}],
["<table data-start=0 data-end=1><tbody align=center><tr><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><table>{<tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody>}</table></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,true,"center",false,true,"center"]}],
["<table data-start=0 data-end=1><tbody align=center><tr><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><table>{<tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody>}</table></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,true,"center",false,true,"center"]}],
["{<table><tbody align=center><tr><td>foo<td>bar<td>baz</table>}<p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\">{<table><tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody></table>}</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,true,"center",false,true,"center"]}],
["{<table><tbody align=center><tr><td>foo<td>bar<td>baz</table>}<p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\">{<table><tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody></table>}</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,true,"center",false,true,"center"]}],
["{<table><tbody align=center><tr><td>foo<td>bar<td>baz</table>}<p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\">{<table><tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody></table>}</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,true,"center",false,true,"center"]}],
["{<table><tbody align=center><tr><td>foo<td>bar<td>baz</table>}<p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\">{<table><tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody></table>}</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,true,"center",false,true,"center"]}],
["<table><tbody><tr align=center><td>foo<td>b[a]r<td>baz</table><p>extra",
	[["justifycenter",""]],
	"<table><tbody><tr align=\"center\"><td>foo</td><td>b[a]r</td><td>baz</td></tr></tbody></table><p>extra</p>",
	[true],
	{"justifycenter":[false,true,"center",false,true,"center"]}],
["<table><tbody><tr align=center data-start=1 data-end=2><td>foo<td>bar<td>baz</table><p>extra",
	[["justifycenter",""]],
	"<table><tbody><tr align=\"center\"><td>foo</td>{<td>bar</td>}<td>baz</td></tr></tbody></table><p>extra</p>",
	[true],
	{"justifycenter":[false,true,"center",false,true,"center"]}],
["<table><tbody><tr align=center data-start=0 data-end=2><td>foo<td>bar<td>baz</table><p>extra",
	[["justifycenter",""]],
	"<table><tbody><tr align=\"center\">{<td>foo</td><td>bar</td>}<td>baz</td></tr></tbody></table><p>extra</p>",
	[true],
	{"justifycenter":[false,true,"center",false,true,"center"]}],
["<table><tbody data-start=0 data-end=1><tr align=center><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><table><tbody>{<tr><td>foo</td><td>bar</td><td>baz</td></tr>}</tbody></table></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,true,"center",false,true,"center"]}],
["<table><tbody data-start=0 data-end=1><tr align=center><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><table><tbody>{<tr><td>foo</td><td>bar</td><td>baz</td></tr>}</tbody></table></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,true,"center",false,true,"center"]}],
["<table><tbody data-start=0 data-end=1><tr align=center><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><table><tbody>{<tr><td>foo</td><td>bar</td><td>baz</td></tr>}</tbody></table></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,true,"center",false,true,"center"]}],
["<table><tbody data-start=0 data-end=1><tr align=center><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><table><tbody>{<tr><td>foo</td><td>bar</td><td>baz</td></tr>}</tbody></table></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,true,"center",false,true,"center"]}],
["<table data-start=0 data-end=1><tbody><tr align=center><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><table>{<tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody>}</table></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,true,"center",false,true,"center"]}],
["<table data-start=0 data-end=1><tbody><tr align=center><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><table>{<tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody>}</table></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,true,"center",false,true,"center"]}],
["<table data-start=0 data-end=1><tbody><tr align=center><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><table>{<tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody>}</table></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,true,"center",false,true,"center"]}],
["<table data-start=0 data-end=1><tbody><tr align=center><td>foo<td>bar<td>baz</table><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><table>{<tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody>}</table></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,true,"center",false,true,"center"]}],
["{<table><tr align=center><td>foo<td>bar<td>baz</table>}<p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\">{<table><tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody></table>}</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,true,"center",false,true,"center"]}],
["{<table><tr align=center><td>foo<td>bar<td>baz</table>}<p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\">{<table><tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody></table>}</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,true,"center",false,true,"center"]}],
["{<table><tr align=center><td>foo<td>bar<td>baz</table>}<p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\">{<table><tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody></table>}</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,true,"center",false,true,"center"]}],
["{<table><tr align=center><td>foo<td>bar<td>baz</table>}<p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\">{<table><tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody></table>}</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,true,"center",false,true,"center"]}],
["<div align=center><p>[foo]<p>bar</div><p>extra",
	[["justifycenter",""]],
	"<div align=\"center\"><p>[foo]</p><p>bar</p></div><p>extra</p>",
	[true],
	{"justifycenter":[false,true,"center",false,true,"center"]}],
["<div align=center><p>[foo<p>bar}</div><p>extra",
	[["stylewithcss","true"],["justifycenter",""]],
	"<div style=\"text-align:center\"><p>[foo</p><p>bar}</p></div><p>extra</p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"justifycenter":[false,true,"center",false,true,"center"]}],
["<div align=center><p>[foo<p>bar}</div><p>extra",
	[["stylewithcss","false"],["justifycenter",""]],
	"<div style=\"text-align:center\"><p>[foo</p><p>bar}</p></div><p>extra</p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"justifycenter":[false,true,"center",false,true,"center"]}],
["<div style=text-align:center><p>[foo]<p>bar</div><p>extra",
	[["justifycenter",""]],
	"<div style=\"text-align:center\"><p>[foo]</p><p>bar</p></div><p>extra</p>",
	[true],
	{"justifycenter":[false,true,"center",false,true,"center"]}],
["<div style=text-align:center><p>[foo<p>bar]</div><p>extra",
	[["justifycenter",""]],
	"<div style=\"text-align:center\"><p>[foo</p><p>bar]</p></div><p>extra</p>",
	[true],
	{"justifycenter":[false,true,"center",false,true,"center"]}],
["<div align=justify><p>[foo]<p>bar</div><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div align=\"justify\"><div style=\"text-align:center\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"justify",false,true,"center"]}],
["<div align=justify><p>[foo]<p>bar</div><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div align=\"justify\"><div style=\"text-align:center\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,false,"justify",false,true,"center"]}],
["<div align=justify><p>[foo]<p>bar</div><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div align=\"justify\"><div style=\"text-align:center\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"justify",false,true,"center"]}],
["<div align=justify><p>[foo]<p>bar</div><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div align=\"justify\"><div style=\"text-align:center\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,false,"justify",false,true,"center"]}],
["<div align=justify><p>[foo<p>bar}</div><p>extra",
	[["stylewithcss","true"],["justifycenter",""]],
	"<div style=\"text-align:center\"><p>[foo</p><p>bar}</p></div><p>extra</p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"justifycenter":[false,false,"justify",false,true,"center"]}],
["<div align=justify><p>[foo<p>bar}</div><p>extra",
	[["stylewithcss","false"],["justifycenter",""]],
	"<div style=\"text-align:center\"><p>[foo</p><p>bar}</p></div><p>extra</p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"justifycenter":[false,false,"justify",false,true,"center"]}],
["<div style=text-align:justify><p>[foo]<p>bar</div><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:justify\"><div style=\"text-align:center\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"justify",false,true,"center"]}],
["<div style=text-align:justify><p>[foo]<p>bar</div><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:justify\"><div style=\"text-align:center\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,false,"justify",false,true,"center"]}],
["<div style=text-align:justify><p>[foo]<p>bar</div><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:justify\"><div style=\"text-align:center\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"justify",false,true,"center"]}],
["<div style=text-align:justify><p>[foo]<p>bar</div><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:justify\"><div style=\"text-align:center\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,false,"justify",false,true,"center"]}],
["<div style=text-align:justify><p>[foo<p>bar]</div><p>extra",
	[["justifycenter",""]],
	"<div style=\"text-align:center\"><p>[foo</p><p>bar]</p></div><p>extra</p>",
	[true],
	{"justifycenter":[false,false,"justify",false,true,"center"]}],
["<div align=left><p>[foo]<p>bar</div><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div align=\"left\"><div style=\"text-align:center\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<div align=left><p>[foo]<p>bar</div><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div align=\"left\"><div style=\"text-align:center\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<div align=left><p>[foo]<p>bar</div><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div align=\"left\"><div style=\"text-align:center\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<div align=left><p>[foo]<p>bar</div><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div align=\"left\"><div style=\"text-align:center\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<div align=left><p>[foo<p>bar}</div><p>extra",
	[["stylewithcss","true"],["justifycenter",""]],
	"<div style=\"text-align:center\"><p>[foo</p><p>bar}</p></div><p>extra</p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"justifycenter":[false,false,"left",false,true,"center"]}],
["<div align=left><p>[foo<p>bar}</div><p>extra",
	[["stylewithcss","false"],["justifycenter",""]],
	"<div style=\"text-align:center\"><p>[foo</p><p>bar}</p></div><p>extra</p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"justifycenter":[false,false,"left",false,true,"center"]}],
["<div style=text-align:left><p>[foo]<p>bar</div><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:left\"><div style=\"text-align:center\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<div style=text-align:left><p>[foo]<p>bar</div><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:left\"><div style=\"text-align:center\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<div style=text-align:left><p>[foo]<p>bar</div><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:left\"><div style=\"text-align:center\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<div style=text-align:left><p>[foo]<p>bar</div><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:left\"><div style=\"text-align:center\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<div style=text-align:left><p>[foo<p>bar]</div><p>extra",
	[["justifycenter",""]],
	"<div style=\"text-align:center\"><p>[foo</p><p>bar]</p></div><p>extra</p>",
	[true],
	{"justifycenter":[false,false,"left",false,true,"center"]}],
["<div align=right><p>[foo]<p>bar</div><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div align=\"right\"><div style=\"text-align:center\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"right",false,true,"center"]}],
["<div align=right><p>[foo]<p>bar</div><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div align=\"right\"><div style=\"text-align:center\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,false,"right",false,true,"center"]}],
["<div align=right><p>[foo]<p>bar</div><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div align=\"right\"><div style=\"text-align:center\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"right",false,true,"center"]}],
["<div align=right><p>[foo]<p>bar</div><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div align=\"right\"><div style=\"text-align:center\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,false,"right",false,true,"center"]}],
["<div align=right><p>[foo<p>bar}</div><p>extra",
	[["stylewithcss","true"],["justifycenter",""]],
	"<div style=\"text-align:center\"><p>[foo</p><p>bar}</p></div><p>extra</p>",
	[true,true],
	{"stylewithcss":[false,false,"",false,true,""],"justifycenter":[false,false,"right",false,true,"center"]}],
["<div align=right><p>[foo<p>bar}</div><p>extra",
	[["stylewithcss","false"],["justifycenter",""]],
	"<div style=\"text-align:center\"><p>[foo</p><p>bar}</p></div><p>extra</p>",
	[true,true],
	{"stylewithcss":[false,true,"",false,false,""],"justifycenter":[false,false,"right",false,true,"center"]}],
["<div style=text-align:right><p>[foo]<p>bar</div><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:right\"><div style=\"text-align:center\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"right",false,true,"center"]}],
["<div style=text-align:right><p>[foo]<p>bar</div><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:right\"><div style=\"text-align:center\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,false,"right",false,true,"center"]}],
["<div style=text-align:right><p>[foo]<p>bar</div><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:right\"><div style=\"text-align:center\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"right",false,true,"center"]}],
["<div style=text-align:right><p>[foo]<p>bar</div><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:right\"><div style=\"text-align:center\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,false,"right",false,true,"center"]}],
["<div style=text-align:right><p>[foo<p>bar]</div><p>extra",
	[["justifycenter",""]],
	"<div style=\"text-align:center\"><p>[foo</p><p>bar]</p></div><p>extra</p>",
	[true],
	{"justifycenter":[false,false,"right",false,true,"center"]}],
["<center>foo</center>[bar]<p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<center>foo</center><div style=\"text-align:center\">[bar]</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<center>foo</center>[bar]<p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<center>foo</center><div style=\"text-align:center\">[bar]</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<center>foo</center>[bar]<p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<center>foo</center><div style=\"text-align:center\">[bar]</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<center>foo</center>[bar]<p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<center>foo</center><div style=\"text-align:center\">[bar]</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["[foo]<center>bar</center><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\">[foo]</div><center>bar</center><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["[foo]<center>bar</center><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\">[foo]</div><center>bar</center><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["[foo]<center>bar</center><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\">[foo]</div><center>bar</center><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["[foo]<center>bar</center><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\">[foo]</div><center>bar</center><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<center>foo</center>[bar]<center>baz</center><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<center>foo</center><div style=\"text-align:center\">[bar]</div><center>baz</center><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<center>foo</center>[bar]<center>baz</center><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<center>foo</center><div style=\"text-align:center\">[bar]</div><center>baz</center><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<center>foo</center>[bar]<center>baz</center><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<center>foo</center><div style=\"text-align:center\">[bar]</div><center>baz</center><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<center>foo</center>[bar]<center>baz</center><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<center>foo</center><div style=\"text-align:center\">[bar]</div><center>baz</center><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<div align=center>foo</div>[bar]<p>extra",
	[["justifycenter",""]],
	"<div align=\"center\">foo<br>[bar]</div><p>extra</p>",
	[true],
	{"justifycenter":[false,false,"left",false,true,"center"]}],
["[foo]<div align=center>bar</div><p>extra",
	[["justifycenter",""]],
	"<div align=\"center\">[foo]<br>bar</div><p>extra</p>",
	[true],
	{"justifycenter":[false,false,"left",false,true,"center"]}],
["<div align=center>foo</div>[bar]<div align=center>baz</div><p>extra",
	[["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div align=\"center\">foo<br>[bar]<br>baz</div><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<div align=center>foo</div>[bar]<div align=center>baz</div><p>extra",
	[["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div align=\"center\">foo<br>[bar]<br>baz</div><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<div align=center><p>foo</div><p>[bar]<p>extra",
	[["justifycenter",""]],
	"<div align=\"center\"><p>foo</p><p>[bar]</p></div><p>extra</p>",
	[true],
	{"justifycenter":[false,false,"left",false,true,"center"]}],
["<p>[foo]<div align=center><p>bar</div><p>extra",
	[["justifycenter",""]],
	"<div align=\"center\"><p>[foo]</p><p>bar</p></div><p>extra</p>",
	[true],
	{"justifycenter":[false,false,"left",false,true,"center"]}],
["<div align=center><p>foo</div><p>[bar]<div align=center><p>baz</div><p>extra",
	[["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div align=\"center\"><p>foo</p><p>[bar]</p><p>baz</p></div><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<div align=center><p>foo</div><p>[bar]<div align=center><p>baz</div><p>extra",
	[["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div align=\"center\"><p>foo</p><p>[bar]</p><p>baz</p></div><p>extra</p>",
	[true,true],
	{"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<div style=text-align:center>foo</div>[bar]<p>extra",
	[["justifycenter",""]],
	"<div style=\"text-align:center\">foo<br>[bar]</div><p>extra</p>",
	[true],
	{"justifycenter":[false,false,"left",false,true,"center"]}],
["[foo]<div style=text-align:center>bar</div><p>extra",
	[["justifycenter",""]],
	"<div style=\"text-align:center\">[foo]<br>bar</div><p>extra</p>",
	[true],
	{"justifycenter":[false,false,"left",false,true,"center"]}],
["<div style=text-align:center>foo</div>[bar]<div style=text-align:center>baz</div><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\">foo<br>[bar]<br>baz</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<div style=text-align:center>foo</div>[bar]<div style=text-align:center>baz</div><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\">foo<br>[bar]<br>baz</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<div style=text-align:center>foo</div>[bar]<div style=text-align:center>baz</div><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\">foo<br>[bar]<br>baz</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<div style=text-align:center>foo</div>[bar]<div style=text-align:center>baz</div><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\">foo<br>[bar]<br>baz</div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<div style=text-align:center><p>foo</div><p>[bar]<p>extra",
	[["justifycenter",""]],
	"<div style=\"text-align:center\"><p>foo</p><p>[bar]</p></div><p>extra</p>",
	[true],
	{"justifycenter":[false,false,"left",false,true,"center"]}],
["<p>[foo]<div style=text-align:center><p>bar</div><p>extra",
	[["justifycenter",""]],
	"<div style=\"text-align:center\"><p>[foo]</p><p>bar</p></div><p>extra</p>",
	[true],
	{"justifycenter":[false,false,"left",false,true,"center"]}],
["<div style=text-align:center><p>foo</div><p>[bar]<div style=text-align:center><p>baz</div><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><p>foo</p><p>[bar]</p><p>baz</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<div style=text-align:center><p>foo</div><p>[bar]<div style=text-align:center><p>baz</div><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><p>foo</p><p>[bar]</p><p>baz</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<div style=text-align:center><p>foo</div><p>[bar]<div style=text-align:center><p>baz</div><p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><p>foo</p><p>[bar]</p><p>baz</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<div style=text-align:center><p>foo</div><p>[bar]<div style=text-align:center><p>baz</div><p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><p>foo</p><p>[bar]</p><p>baz</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<p align=center>foo<p>[bar]<p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<p align=\"center\">foo</p><div style=\"text-align:center\"><p>[bar]</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<p align=center>foo<p>[bar]<p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<p align=\"center\">foo</p><div style=\"text-align:center\"><p>[bar]</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<p align=center>foo<p>[bar]<p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<p align=\"center\">foo</p><div style=\"text-align:center\"><p>[bar]</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<p align=center>foo<p>[bar]<p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<p align=\"center\">foo</p><div style=\"text-align:center\"><p>[bar]</p></div><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<p>[foo]<p align=center>bar<p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><p>[foo]</p></div><p align=\"center\">bar</p><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<p>[foo]<p align=center>bar<p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<div style=\"text-align:center\"><p>[foo]</p></div><p align=\"center\">bar</p><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<p>[foo]<p align=center>bar<p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><p>[foo]</p></div><p align=\"center\">bar</p><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<p>[foo]<p align=center>bar<p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","p"],["justifycenter",""]],
	"<div style=\"text-align:center\"><p>[foo]</p></div><p align=\"center\">bar</p><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<p align=center>foo<p>[bar]<p align=center>baz<p>extra",
	[["stylewithcss","true"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<p align=\"center\">foo</p><div style=\"text-align:center\"><p>[bar]</p></div><p align=\"center\">baz</p><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifycenter":[false,false,"left",false,true,"center"]}],
["<p align=center>foo<p>[bar]<p align=center>baz<p>extra",
	[["stylewithcss","false"],["defaultparagraphseparator","div"],["justifycenter",""]],
	"<p align=\"center\">foo</p><div style=\"text-align:center\"><p>[bar]</p></div><p align=\"center\">baz</p><p>extra</p>",
	[true,true,true],
	{"stylewithcss":[false,tru