; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr8 < %s | FileCheck %s
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr7 < %s | FileCheck %s
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-aix \
; RUN:   -mcpu=pwr7 < %s | FileCheck %s --check-prefix=CHECK-AIX64

declare i64 @llvm.ppc.mfspr.i64(i32 immarg)
declare void @llvm.ppc.mtspr.i64(i32 immarg, i64)

@ula = external local_unnamed_addr global i64, align 8

define dso_local i64 @test_mfxer() {
; CHECK-LABEL: test_mfxer:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mfxer 3
; CHECK-NEXT:    blr
;
; CHECK-AIX64-LABEL: test_mfxer:
; CHECK-AIX64:       # %bb.0: # %entry
; CHECK-AIX64-NEXT:    mfxer 3
; CHECK-AIX64-NEXT:    blr
entry:
  %0 = call i64 @llvm.ppc.mfspr.i64(i32 1)
  ret i64 %0
}

define dso_local i64 @test_mflr() {
; CHECK-LABEL: test_mflr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mflr 3
; CHECK-NEXT:    blr
;
; CHECK-AIX64-LABEL: test_mflr:
; CHECK-AIX64:       # %bb.0: # %entry
; CHECK-AIX64-NEXT:    mfspr 3, 8
; CHECK-AIX64-NEXT:    blr
entry:
  %0 = call i64 @llvm.ppc.mfspr.i64(i32 8)
  ret i64 %0
}

define dso_local i64 @test_mfctr() {
; CHECK-LABEL: test_mfctr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mfctr 3
; CHECK-NEXT:    blr
;
; CHECK-AIX64-LABEL: test_mfctr:
; CHECK-AIX64:       # %bb.0: # %entry
; CHECK-AIX64-NEXT:    mfspr 3, 9
; CHECK-AIX64-NEXT:    blr
entry:
  %0 = call i64 @llvm.ppc.mfspr.i64(i32 9)
  ret i64 %0
}

define dso_local i64 @test_mfppr() {
; CHECK-LABEL: test_mfppr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mfspr 3, 896
; CHECK-NEXT:    blr
;
; CHECK-AIX64-LABEL: test_mfppr:
; CHECK-AIX64:       # %bb.0: # %entry
; CHECK-AIX64-NEXT:    mfspr 3, 896
; CHECK-AIX64-NEXT:    blr
entry:
  %0 = call i64 @llvm.ppc.mfspr.i64(i32 896)
  ret i64 %0
}

define dso_local i64 @test_mfppr32() {
; CHECK-LABEL: test_mfppr32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mfspr 3, 898
; CHECK-NEXT:    blr
;
; CHECK-AIX64-LABEL: test_mfppr32:
; CHECK-AIX64:       # %bb.0: # %entry
; CHECK-AIX64-NEXT:    mfspr 3, 898
; CHECK-AIX64-NEXT:    blr
entry:
  %0 = call i64 @llvm.ppc.mfspr.i64(i32 898)
  ret i64 %0
}

define dso_local void @test_mtxer() {
; CHECK-LABEL: test_mtxer:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis 3, 2, .LC0@toc@ha
; CHECK-NEXT:    ld 3, .LC0@toc@l(3)
; CHECK-NEXT:    ld 3, 0(3)
; CHECK-NEXT:    mtxer 3
; CHECK-NEXT:    blr
;
; CHECK-AIX64-LABEL: test_mtxer:
; CHECK-AIX64:       # %bb.0: # %entry
; CHECK-AIX64-NEXT:    ld 3, L..C0(2) # @ula
; CHECK-AIX64-NEXT:    ld 3, 0(3)
; CHECK-AIX64-NEXT:    mtxer 3
; CHECK-AIX64-NEXT:    blr
entry:
  %0 = load i64, i64* @ula, align 8
  tail call void @llvm.ppc.mtspr.i64(i32 1, i64 %0)
  ret void
}

define dso_local void @test_mtlr() {
; CHECK-LABEL: test_mtlr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis 3, 2, .LC0@toc@ha
; CHECK-NEXT:    ld 3, .LC0@toc@l(3)
; CHECK-NEXT:    ld 3, 0(3)
; CHECK-NEXT:    mtlr 3
; CHECK-NEXT:    blr
;
; CHECK-AIX64-LABEL: test_mtlr:
; CHECK-AIX64:       # %bb.0: # %entry
; CHECK-AIX64-NEXT:    ld 3, L..C0(2) # @ula
; CHECK-AIX64-NEXT:    ld 3, 0(3)
; CHECK-AIX64-NEXT:    mtspr 8, 3
; CHECK-AIX64-NEXT:    blr
entry:
  %0 = load i64, i64* @ula, align 8
  tail call void @llvm.ppc.mtspr.i64(i32 8, i64 %0)
  ret void
}

define dso_local void @test_mtctr() {
; CHECK-LABEL: test_mtctr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis 3, 2, .LC0@toc@ha
; CHECK-NEXT:    ld 3, .LC0@toc@l(3)
; CHECK-NEXT:    ld 3, 0(3)
; CHECK-NEXT:    mtctr 3
; CHECK-NEXT:    blr
;
; CHECK-AIX64-LABEL: test_mtctr:
; CHECK-AIX64:       # %bb.0: # %entry
; CHECK-AIX64-NEXT:    ld 3, L..C0(2) # @ula
; CHECK-AIX64-NEXT:    ld 3, 0(3)
; CHECK-AIX64-NEXT:    mtspr 9, 3
; CHECK-AIX64-NEXT:    blr
entry:
  %0 = load i64, i64* @ula, align 8
  tail call void @llvm.ppc.mtspr.i64(i32 9, i64 %0)
  ret void
}

define dso_local void @test_mtppr() {
; CHECK-LABEL: test_mtppr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis 3, 2, .LC0@toc@ha
; CHECK-NEXT:    ld 3, .LC0@toc@l(3)
; CHECK-NEXT:    ld 3, 0(3)
; CHECK-NEXT:    mtspr 896, 3
; CHECK-NEXT:    blr
;
; CHECK-AIX64-LABEL: test_mtppr:
; CHECK-AIX64:       # %bb.0: # %entry
; CHECK-AIX64-NEXT:    ld 3, L..C0(2) # @ula
; CHECK-AIX64-NEXT:    ld 3, 0(3)
; CHECK-AIX64-NEXT:    mtspr 896, 3
; CHECK-AIX64-NEXT:    blr
entry:
  %0 = load i64, i64* @ula, align 8
  tail call void @llvm.ppc.mtspr.i64(i32 896, i64 %0)
  ret void
}

define dso_local void @test_mtppr32() {
; CHECK-LABEL: test_mtppr32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis 3, 2, .LC0@toc@ha
; CHECK-NEXT:    ld 3, .LC0@toc@l(3)
; CHECK-NEXT:    ld 3, 0(3)
; CHECK-NEXT:    mtspr 898, 3
; CHECK-NEXT:    blr
;
; CHECK-AIX64-LABEL: test_mtppr32:
; CHECK-AIX64:       # %bb.0: # %entry
; CHECK-AIX64-NEXT:    ld 3, L..C0(2) # @ula
; CHECK-AIX64-NEXT:    ld 3, 0(3)
; CHECK-AIX64-NEXT:    mtspr 898, 3
; CHECK-AIX64-NEXT:    blr
entry:
  %0 = load i64, i64* @ula, align 8
  tail call void @llvm.ppc.mtspr.i64(i32 898, i64 %0)
  ret void
}
