.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XSetInputFocus __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XSetInputFocus, XGetInputFocus \- control input focus
.SH SYNTAX
.HP
int XSetInputFocus\^(\^Display *\fIdisplay\fP\^, Window \fIfocus\fP\^, int
\fIrevert_to\fP\^, Time \fItime\fP\^);
.HP
int XGetInputFocus\^(\^Display *\fIdisplay\fP\^, Window *\fIfocus_return\fP\^,
int *\fIrevert_to_return\fP\^);
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIfocus\fP 1i
Specifies the window,
.BR PointerRoot ,
or
.BR None .
.IP \fIfocus_return\fP 1i
Returns the focus window,
.BR PointerRoot ,
or
.BR None .
.IP \fIrevert_to\fP 1i
Specifies where the input focus reverts to if the window becomes not
viewable.
You can pass
.BR RevertToParent ,
.BR RevertToPointerRoot ,
or
.BR RevertToNone .
.IP \fIrevert_to_return\fP 1i
Returns the current focus state
.RB ( RevertToParent ,
.BR RevertToPointerRoot ,
or
.BR RevertToNone ).
.IP \fItime\fP 1i
Specifies the time.
You can pass either a timestamp or
.BR CurrentTime .
.SH DESCRIPTION
The
.B XSetInputFocus
function changes the input focus and the last-focus-change time.
It has no effect if the specified time is earlier than the current
last-focus-change time or is later than the current X server time.
Otherwise, the last-focus-change time is set to the specified time
.RB ( CurrentTime
is replaced by the current X server time).
.B XSetInputFocus
causes the X server to generate
.B FocusIn
and
.B FocusOut
events.
.LP
Depending on the focus argument,
the following occurs:
.IP \(bu 5
If focus is
.BR None ,
all keyboard events are discarded until a new focus window is set,
and the revert_to argument is ignored.
.IP \(bu 5
If focus is a window,
it becomes the keyboard's focus window.
If a generated keyboard event would normally be reported to this window
or one of its inferiors, the event is reported as usual.
Otherwise, the event is reported relative to the focus window.
.IP \(bu 5
If focus is
.BR PointerRoot ,
the focus window is dynamically taken to be the root window of whatever screen
the pointer is on at each keyboard event.
In this case, the revert_to argument is ignored.
.LP
The specified focus window must be viewable at the time
.B XSetInputFocus
is called,
or a
.B BadMatch
error results.
If the focus window later becomes not viewable,
the X server
evaluates the revert_to argument to determine the new focus window as follows:
.IP \(bu 5
If revert_to is
.BR RevertToParent ,
the focus reverts to the parent (or the closest viewable ancestor),
and the new revert_to value is taken to be
.BR RevertToNone .
.IP \(bu 5
If revert_to is
.B RevertToPointerRoot
or
.BR RevertToNone ,
the focus reverts to
.B PointerRoot
or
.BR None ,
respectively.
When the focus reverts,
the X server generates
.B FocusIn
and
.B FocusOut
events, but the last-focus-change time is not affected.
.LP
.B XSetInputFocus
can generate
.BR BadMatch ,
.BR BadValue ,
and
.B BadWindow
errors.
.LP
The
.B XGetInputFocus
function returns the focus window and the current focus state.
.SH DIAGNOSTICS
.TP 1i
.B BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.
Any argument defined as a set of
alternatives can generate this error.
.TP 1i
.B BadWindow
A value for a Window argument does not name a defined Window.
.SH "SEE ALSO"
.BR XWarpPointer (__libmansuffix__)
.br
\fI\*(xL\fP
