/*
 *  typemap.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <string.h>
#include "yachead.h"
#include "typemap.h"
#include "intfc.h"
#include "yacintfc.h"
#include "cgidbg.h"
#include "user.h"

/*
 * enum DecType{ DecFloat, DecInt, DecName, DecString, DecComplex,
 *	DecMachWord, DecCxMachWord, DecAccMachWord, DecCxAccMachWord,
 *	DecProcedure, DecDspPP, DecParam, DecEnt}; 
 *
 * const char * DecTypeToString(DecType) ;
 *
 * enum DeclClass {DeclNot, DeclEntity, DeclBasic, DeclProcedure, DeclMember,
 *	DoDeclEntity, DoDeclBasic, DoDeclProcedure} ;
 *
 */

struct DeclaredTypes {
	DecType Type;
	const char * TypeName ;
};

DeclaredTypes TheDeclaredTypes[] = {
	{DecFloat,"double"},
	{DecFloat,"float"},
	{DecInt,"int"},
	{DecInt,"int16"},
	{DecInt,"int32"},
	{DecString,"char*"},
	{DecComplex,"complex"},
	{DecMachWord,"MachWord"},
	{DecCxMachWord,"CxMachWord"},
	{DecAccMachWord,"AccMachWord"},
	{DecCxAccMachWord,"CxAccMachWord"},
	{(DecType)0,0}
};

const char * get_dec_type_name(DecType tp)
{
	for (DeclaredTypes * typ = TheDeclaredTypes; typ->TypeName; typ++)
		if (typ->Type == tp) return typ->TypeName;
	return 0 ;
}
	
DecType GetDecType(const char * Type)
{
	for (DeclaredTypes * TheTypes = TheDeclaredTypes; TheTypes->TypeName;
		TheTypes++) if (!strobjcmp(Type,TheTypes->TypeName))
		return TheTypes->Type;
	return DecInvalid;
}


ValueType * MakeReturnValue(ValueType * Object, const char * Type)
{
	if (!Type) return 0;
	// LogOut << "MakeReturnValue: Type = " << Type << "\n" ;
	if (!strcmp(Type,"void")) return 0;
	DecType WantType = GetDecType(Type);
	if (WantType != DecInvalid) {
		if (!ReturnCheckConvert(Object,WantType)) {
			State.Error("illegal return value");
			return 0;
		} 
 		// Make a complete ValueType suitable for downstream processing
		Object->Class = DeclBasic ;
		Object->Declared.Basic = 0 ;
		return Object ;
	} 
	if(Object->Type !=DecEnt) {
		State.Error("bad return type");
		return 0 ;
	}

	// LogOut << "Past initial Check\n" ;
	UserEntity * ThisEntity = Object->Value.ValEnt ;
	if (!ThisEntity) DbgError("MakeReturnValue","bad entity");
	const char * ObjectName = ThisEntity->GetName() ;

	InteractiveEntity * ThisType =
		AllEntityLists->GetInteractiveEntityFromObj(ObjectName);
	if (!ThisType) {
		State.Error("unknown return type");
		return 0;
	}
	InteractiveEntity * IntEnt = GetBaseType(ThisType,Type);
	if (!IntEnt) {
		State.Error("cannot make a ",Type," from a ",
			ThisType->GetClassName());
		return 0;
	}
	// LogOut << "Past all Check\n" ;
	Object->Class = DoDeclEntity ;
	Object->Declared.EntityClass = ThisType ;
/*
 *	LogOut << "Object->Class = " << Object->Class << "\n" ;
 *	LogOut << "Object->Declared.EntityClass = " <<
 *		hex((long) Object->Declared.EntityClass) << "\n" ;
 *	LogOut << "About to return\n" ;
 */
	return Object ;
}

/*
 * UserEntity * MakeDeclaredEntity(UserEntity * Ent, InteractiveEntity *Declar)
 * {
 *	ValueType * Temp = new ValueType (DecEnt,Ent,DoDeclEntity,Declar);
 *	Temp->ValueDefined=1;
 *	Ent->SetClass(Temp);
 *	delete Temp ;
 *	return Ent ;
 * }
 */


