/*
 *  outword.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <stream.h>
#include <fcntl.h>
#include "ObjProComGui/cgidbg.h"
#include "ObjProDSP/sysconst.h"
#include "ObjProDSP/sysintfc.h"
#include "ObjProGui/yacintfc.h"
#include "ObjProDSPcom/binfile.h"
#include "ObjProNet/dfnode.h"

#include "ObjProUsr/outword.h"
#include "ObjProGen/outtok.h"
#include "ObjProGui/intfc.h"
#include "ObjProGui/remmen.h"
#include "ObjProGui/user.h"
#include "ObjProGui/dynmnu.h"
#include "ObjProArith/typout.h"
#include "ObjProGui/array.h"
#include "ObjProGui/interinit.h"
#include "ObjProGen/stattyp.h"
static EntityList * OutputWordNodeList = 0 ;
static InteractiveEntity * IntEntOutputWord ;
void OutputWordNodesInit();
OutputWord::OutputWord (const char * Name, const char * FileName, int16 FormatOut):
	DisplayNodeStr(Name, 1, 1, 
	 new StreamStr(SizeVariable , SizeVariable , ArithType::ArithCapabilityAny), TimingTypeLinear)
,
	FileName_1(FileName),
	FormatOut_2(FormatOut)
{
	if (!OutputWordNodeList) OutputWordNodesInit() ;
	OutputWordNodeList->Append(MakeDeclaredEntity(this, IntEntOutputWord)) ;
	InitArithType(TheArithType);
	NewMenuItem("OutputWord",GetName());
#line 59 "../outword.usr"
 
	ctor();
#line 46 "../outword.C"
} // end constructor

ErrCode OutputWord::EmitStaticCtorParameters(OutTokens& Out)
{
	ostream& Outs = *(Out.GetStream());
	Outs << ",\n\tOutputWordStaticInitinteger_read_flag_" << GetName() << "";
	return OK;
}

ErrCode OutputWord::EmitStaticInit(OutTokens& Out)
{
	ostream& Outs = *(Out.GetStream());
	Outs << "static int OutputWordStaticInitinteger_read_flag_" << GetName() << " = ";	
	OutStringStaticValue(Outs,"int", &(integer_read_flag)) ;

	Outs << ";\n";
	return OK;
}

OutputWord::~OutputWord()
{
	TheMenuServer->DeleteMenuItem("OutputWord",GetName());
	OutputWordNodeList->Delete(GetName()) ;
#line 63 "../outword.usr"
 
	dtor();
#line 73 "../outword.C"
} // end destructor

int OutputWord::CheckSafeDelete()
{
	int Safe_Check_Return = DfNode::CheckSafeDelete();
	if (!Safe_Check_Return) return 0;
	return 1;
} // end check safe delete

double OutputWord::TimeFirst( DfNodeInLink * , DfNodeOutLink * )
{
#line 90 "../outword.usr"
    return 0.0;
    // timing is irrelevant for a node with no output channels
#line 88 "../outword.C"
} // end timing code

OutputWord * OutputWordDef;

ErrCode OutputWord::DoNode(int32 k)
{
#line 94 "../outword.usr"
 
	return kernel(k);
#line 98 "../outword.C"
} // end kernel code

static UserEntity * MakeOutputWord(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith = (ArithType::ArithCapabilities) TheArithType) ;
int OutputWord::CppList(OutTokens& Out, CppListCmds Cmd)
{
	return IntEntOutputWord->CppList(Out,Cmd,this);
}

void OutputWord::Describe(OutTokens& Out, ListEntity Option)
{
	switch(Option) {
case ListSingleEntity:
		Out.NewLine();
		MakeOutputWord(Out,EntityReqDescribeFull,*IntEntOutputWord,TheArithType);
		Out.NewLine();
		Out.NextQuoteOut("FileName");
		Out.NextQuoteOut(GetFileName());
		Out.NextFillOut("is the file");
		Out.NextFillOut("to be created. If no default(0) is given");
		Out.NextFillOut("the node name will be used.");
		Out.NextQuoteOut("FormatOut");
		Out.NextFillOut("(");
		Out.NextFillOut(TypeToString(GetFormatOut()));
		Out.NextFillOut(")");
		Out.NextFillOut("is the binary output format.");
		Out.NextFillOut("The options are:");
		Out.NextFillOut("`MachWord'");
		Out.NextFillOutConcat("(0),");
		Out.NextFillOut("`int8'");
		Out.NextFillOutConcat("(1),");
		Out.NextFillOut("`int16'");
		Out.NextFillOutConcat("(2),");
		Out.NextFillOut("`int32'");
		Out.NextFillOutConcat("(3),");
		Out.NextFillOut("`float'");
		Out.NextFillOutConcat("(4),");
		Out.NextFillOut("`double'");
		Out.NextFillOutConcat("(5). Integer words are written in two's compliment");
		Out.NextFillOut("format. Integer input values (");
		Out.NextFillOutConcat("`IntegerMachWord'");
		Out.NextFillOutConcat(") are treated as signed.");
		Out.NextFillOut("If overflow occurs the data is hard limited and a warning");
		Out.NextFillOut("is given. The input stream can have any value for sample size,");
		Out.NextFillOut("(");
		Out.NextFillOutConcat("`ElementSize'");
		Out.NextFillOutConcat(")");
		Out.NewLine();
		break;
case ListEntityMembers:
		Out.NextOut(GetName());
		break;
case ListGlobalClasses:
case ListEntityClasses:
		break ;
case ListSetParameterValues:
		IntEntOutputWord->GetOneParameter("FileName")->
			StringP->CurrentValue = FileName_1;
		IntEntOutputWord->GetOneParameter("FormatOut")->
			IntP->CurrentValue = FormatOut_2;
		break;
	}
} // end  list entity switch

void OutputWordNodesInit()
{
	if (OutputWordNodeList)  return ;

	static StringParam OutputWordNameParam =
		{"OutputWord", MakeNewEntityName, 0, LegalEntityName};
	static StringParam OutputWordFileNameParam = {
		 0, 0, 0};
	static IntParam OutputWordFormatOutParam = {
		 0, 0,  0,  0,  0,  5};

	static OneParameter OutputWordParArray[] = {
		{"Name", 0, "node name", 0, 0, &OutputWordNameParam},
		{"FileName", 0, 
			"file to create",
			0, 0, &OutputWordFileNameParam},
		{"FormatOut", 0, 
			"format: `MachWord'(0), `int8'(1), `int16'(2), `int32'(3), `float'(4), `double'(5)",
			&OutputWordFormatOutParam},
		{0}
	};

	OutputWordNodeList = new EntityList;
	IntEntOutputWord = new InteractiveEntity("OutputWord", OutputWordNodeList,
		MakeOutputWord, InteractiveNode, "outword.h",
		0, "DisplayNodeStr");
	IntEntOutputWord->SetParameters(new UserParameters(OutputWordParArray));
	TheNodes->Append(IntEntOutputWord);
} // end initalization

static UserEntity * MakeOutputWord(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith)
{
	switch(Request) {
case EntityReqDescribe:

case EntityReqDescribeFull:
		Out.NextQuoteOut("OutputWord");
		Out.NextFillOut("writes words to a binary file. It is intended");
		Out.NextFillOut("for exporting data to other processes.");
		Out.NextFillOut("`OutputNode'");
		Out.NextFillOut("is better");
		Out.NextFillOut("for preserving data for later use in ObjectProDSP because");
		Out.NextFillOut("`Outputnode'");
		Out.NextFillOut("retains sample rate, timing, block size and sample size information.");
		Out.NextFillOut("Each input word is written in a format determined by");
		Out.NextQuoteOut("FormatOut");
		Out.NextFillOutConcat(".");
		Out.NextFillOut("The options are:");
		Out.NextFillOut("`MachWord'");
		Out.NextFillOutConcat("(0),");
		Out.NextFillOut("`int8'");
		Out.NextFillOutConcat("(1),");
		Out.NextFillOut("`int16'");
		Out.NextFillOutConcat("(2),");
		Out.NextFillOut("`int32'");
		Out.NextFillOutConcat("(3),");
		Out.NextFillOut("`float'");
		Out.NextFillOutConcat("(4),");
		Out.NextFillOut("`double'");
		Out.NextFillOutConcat("(5). Integer words are written in two's compliment");
		Out.NextFillOut("format. Integer input values (");
		Out.NextFillOutConcat("`IntegerMachWord'");
		Out.NextFillOutConcat(") are treated as signed.");
		Out.NextFillOut("If overflow occurs the data is hard limited and a warning");
		Out.NextFillOut("is given. The input stream can have any value for sample size,");
		Out.NextFillOut("(");
		Out.NextFillOutConcat("`ElementSize'");
		Out.NextFillOutConcat(") or");
		Out.NextFillOut("`BlockSize'");
		Out.NextFillOut("but these are not preserved in");
		Out.NextFillOut("the output file as they are with");
		Out.NextFillOut("`OutputNode'");
		Out.NextFillOutConcat(".");
		Out.NewLine();
		break;

case EntityReqCreate:
	{
		const char * Name = IntNode.GetStringParameterValue("Name");
		const char * FileName =
			IntNode.GetStringParameterValue("FileName");
		int16 FormatOut =
			IntNode.GetIntParameterValue("FormatOut");
		return new OutputWord(Name, FileName, FormatOut);

	}
	}
	return 0;
}

static InitObj LocalInit(OutputWordNodesInit, "OutputWord", "DisplayNodeStr");

