/*
 *  plotdatd.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "hrdarth.h"
#include "portable.h"
#include "shared.h"
#include "remcom.h"
#include "slist.h"
#include "plotdatd.h"

#include "plotnd.h"


PlotController ThePlotController ;

AxisScalingX SingleChannelXDefaultAxis(PlotScaleAuto,0.0,0.0,
	LabelingLinear) ;
	
AxisScalingY SingleChannelYDefaultAxis(PlotScaleAuto,0.0,0.0,
	LabelingLinear) ;
	

// This is the only member of PlotDataHeader not defined in the
// common file plotdat.h - it needs to be different for Dsp and Gui
// because we have a devrived class in Gui that contains additional
// information for PlotChannel

/*
 * PlotChannel ** DataPlotHeader::InitPlotChannels()
 * {
 *		ThePlotChannels = new PlotChannel * [GetNumberOfChannels()] ;
 *		LogForm("InitPlotChannels channels = %d",GetNumberOfChannels());
 *		for (int i = 0; i < GetNumberOfChannels() ; i ++) {
 *			ThePlotChannels[i] = new PlotChannel ;
 *		((PlotChannelPointer *) ThePlotChannels[i])->SetIndex(i);
 *		((PlotChannelPointer *)
 *			ThePlotChannels[i])->SetPlot((DataPlot *) this);
 *		LogForm("Inited(%d) 0x%x to Plot 0x%x", i,
 *			(long) ThePlotChannels[i], (long) this);
 *		}
 *		return ThePlotChannels ; 
 * }
 */


class PlotNodeList: public SingleList {
public:
	ErrCode Insert(PlotNode *nt) {return SingleList::Insert(nt);}
	ErrCode Append(PlotNode *nt) {return SingleList::Append(nt);}
	ErrCode RemoveEntry(PlotNode *nt) {return SingleList::RemoveEntry(nt);}
	PlotNode * Get()   {return (PlotNode *) SingleList::Get();}
	PlotNode * Pop() {return (PlotNode *) SingleList::Pop();}
	PlotNode * GetNFromTop(int N) ;
	PlotNode * GetNthEntry(int N) ;
	PlotNodeList(){;}
	int Size(){return SingleList::Size();}
} ;

class PlotNodeListIterator: public SingleListIterator {
public:
	PlotNodeListIterator(PlotNodeList& df):
		SingleListIterator((SingleList&) df){}
	PlotNode * operator()()
		{return (PlotNode *) Next();}
};

PlotController::PlotController()
{
	WaitingPlotId = new PlotNodeList ;
	WaitingHeaderComplete = new PlotNodeList ;
}

PlotController::~PlotController()
{
	delete WaitingPlotId ;
	delete WaitingHeaderComplete ;
}

void PlotController::GetPlotId(class PlotNode * Requestor)
{
	// Send remote message to get plot Id
	PacketHeader Header = PlotPacketHeader(PacketWindowPlotControl,
		PlotGlobalCommand,PlotControlGetId);
	WriteSeg->WritePacket(Header) ;
	WaitingPlotId->Append(Requestor) ;
	WaitingHeaderComplete->Append(Requestor);
}

void PlotController::SetPlotId(int Id)
{
	PlotNode * ToSet = WaitingPlotId->Get();
	if (!ToSet) DbgError("PlotController", "no node");
	ToSet->SetPlotId(Id);
	// LogOut << "PlotId set to " << Id << "\n" ;
}

void PlotController::SendComplete(int Id)
{
	PlotNodeListIterator Next(*WaitingHeaderComplete);
	PlotNode * PltNd ;
	while (PltNd =Next()) {
		// LogForm("Checking Entry Id = %d",PltNd->GetPlotId());
		if (PltNd->GetPlotId() == Id) {
			PltNd->SendComplete();
			WaitingHeaderComplete->RemoveEntry(PltNd);
			return ;
		}
	}
	TheLog << "PlotController::SendComplete ","*****************No such plot\n";
}

void PlotController::PlotServer(PacketHeader& Head, const char * Data)
{
	int PlotId = Head.GetPlotId();
	int PlotChannel = Head.GetPlotChannel();
/*
 *	LogOut << "PlotController::PlotServer Id = " << PlotId <<
 *		", Channel = " << PlotChannel << "\n" ;
 */
	if (PlotId == PlotGlobalCommand && PlotChannel == PlotControlSendId)
	{
		if (Head.DataSize != sizeof(int16)) DbgError(
			"PlotController::PlotServer","bad size");
		int Temp = * (int16 *) Data ;
		// LogForm("Got PlotId = %d",Temp);
		SetPlotId(Temp);
	}  else if (PlotChannel == PlotControlComplete) {
		SendComplete(PlotId);
	} else DbgError("PlotController::PlotServer","bad control packet");
}

 

