/*
 *  stimer.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
/* $Header: /europe/fams/glenl/src/iv/ivdemo/RCS/stimer.c,v 1.1 92/06/30 10:40:07 glenl Exp $ */
/*
 * ShortTimer --- a short interval timer
 *
 * $Log:        stimer.c,v $
 * Revision 1.1  92/06/30  10:40:07  glenl
 * Initial revision
 * 
 */
#include <Dispatch/dispatcher.h>
#include <InterViews/action.h>

#include "stimer.h"

ShortTimer::ShortTimer(long u_seconds, Action *action) : IOHandler()
{
    useconds_ = u_seconds;
    action_ = action;
    Resource::ref(action_);
    state_ = STOPPED;
}

ShortTimer::~ShortTimer() {
    if (state_ == RUNNING) {
        stop();
    }
    Resource::unref(action_);
}

void ShortTimer::start() {
    if (state_ != RUNNING) {
        state_ = RUNNING;
        Dispatcher::instance().startTimer(long(useconds_ / 1000),
                                          long(useconds_ % 1000),
                                          this);
    }
}

void ShortTimer::stop() {
    if (state_ != STOPPED) {
        state_ = STOPPING;
        Dispatcher::instance().stopTimer(this);
        state_ = STOPPED;
    }
}

void ShortTimer::timerExpired(long sec, long usec)
{
    // save parameters (for no good reason other than to use them...)
    last_sec_ = sec; last_usec_ = usec;

    if (action_ != nil)
        action_->execute();

    if (state_ == RUNNING) {
        Dispatcher::instance().startTimer(long(useconds_ / 1000),
                                          long(useconds_ % 1000),
                                          this);
    }
}
