/*
 *  procstr.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef PROCSTR_DOT_H
#define PROCSTR_DOT_H

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProUsr/node.h"

class ProcessNodeStr: public Node {
	int16  in_1;
	int16  out_2;
	StreamStr* StreamIn_3;
	StreamStr* StreamOut_4;
	int32  NodeDelay_5;
	int32  DeltaIn_6;
	int32  DeltaOut_7;
	int32  Overlap_8;
	int32  DelayIn_9;
	TimingType  TheTimingType_10;
public:
	ProcessNodeStr (const char * Name, int16 in, int16 out, StreamStr*StreamIn, 
		StreamStr*StreamOut, int32 NodeDelay, int32 DeltaIn, 
		int32 DeltaOut, int32 Overlap, int32 DelayIn, 
		TimingType TheTimingType);
	virtual ~ProcessNodeStr();
	int16 Getin() const {return in_1;}
	int16 Getout() const {return out_2;}
	StreamStr*GetStreamIn() const {return StreamIn_3;}
	StreamStr*GetStreamOut() const {return StreamOut_4;}
	int32 GetNodeDelay() const {return NodeDelay_5;}
	int32 GetDeltaIn() const {return DeltaIn_6;}
	int32 GetDeltaOut() const {return DeltaOut_7;}
	int32 GetOverlap() const {return Overlap_8;}
	int32 GetDelayIn() const {return DelayIn_9;}
	TimingType GetTheTimingType() const {return TheTimingType_10;}
	virtual int CheckSafeDelete() ;
	void Raise ();
	void SetSampleRate (double Rate, int16 Channel);
	void DisplayInputTiming (int16 Channel);
	void DisplayOutputTiming (int16 Channel);
	void Edit ();
	void Unlink ();
	Node& LinkIn (int16 Channel);
	void NextFreeInput ();
	void NextFreeOutput ();
};


#endif /* #ifdef PROCSTR_DOT_H */
