/* signal.c */

#include "header.h"			

#define BIT(a) (1<<((a)-1))
extern char savefilename[],wizard,predostuff,nosignal;

#ifdef __MSDOS__
# define VOID void
#else
# ifdef LINUX
#  define VOID void *
# else
#  define VOID
# endif
#endif

s2choose()	/* text to be displayed if ^C during intro screen */
{
	cursor(1,24); 
	lprcat("Press "); 
	if (boldon) setbold(); 
	lprcat("return"); 
	if (boldon) resetbold();
	lprcat(" to continue: ");
	lflush(); 
}

VOID cntlc()	/* what to do for a ^C */
{
	if (nosignal) 
	  return;	/* don't do anything if inhibited */
	signal(SIGINT,SIG_IGN);
	quit(); 
	if (predostuff==1) 
	  s2choose(); 
	else 
	  showplayer();
	lflush();
#ifndef __MSDOS__
	signal(SIGQUIT,cntlc);	
#endif
	signal(SIGINT,cntlc);
}

/*
 *	subroutine to save the game if a hangup signal
 */
sgam()
{
	savegame(savefilename);  
	wizard=1;  
	died(-257); /* hangup signal */
}

#ifdef SIGTSTP
tstop() 
{
 	if (nosignal)  
	  return;  /* nothing if inhibited */
	lcreat((char*)0);  
	clearvt100();	
	lflush();	  
	signal(SIGTSTP,SIG_DFL);
#ifdef SIGVTALRM
/* looks like BSD4.2 or higher - must clr mask for signal to take effect*/
	sigsetmask(sigblock(0)& ~BIT(SIGTSTP));
#endif
	kill(getpid(),SIGTSTP);

	setupvt100();  
	signal(SIGTSTP,tstop);
	if (predostuff==1) 
	  s2choose(); 
	else 
	  drawscreen();
	showplayer();	
	lflush();
}
#endif /* SIGTSTP */

/*
 *	subroutine to issue the needed signal traps  called from main()
 */
VOID sigill()  { sigpanic(SIGILL); }	 
VOID sigfpe()  { sigpanic(SIGFPE); }   
VOID sigsegv() { sigpanic(SIGSEGV); }  
VOID sigterm() { sigpanic(SIGTERM); }

#ifndef __MSDOS__
sigtrap() { sigpanic(SIGTRAP); }
sigiot()  { sigpanic(SIGIOT); }   
# ifndef LINUX
sigemt()  { sigpanic(SIGEMT); }
sigbus()  { sigpanic(SIGBUS); }
sigsys()  { sigpanic(SIGSYS); }
# endif
sigpipe() { sigpanic(SIGPIPE); }  
#endif

sigsetup()
{
	signal(SIGINT,  cntlc); 
	signal(SIGILL,  sigill);		
	signal(SIGFPE,  sigfpe);		
	signal(SIGSEGV, sigsegv);		
	signal(SIGTERM, sigterm);

#ifndef __MSDOS__
	signal(SIGQUIT, cntlc); 		
	signal(SIGKILL, SIG_IGN);		
	signal(SIGHUP,  sgam);
	signal(SIGTRAP, sigtrap);
	signal(SIGIOT,  sigiot);		
# ifndef LINUX
	signal(SIGEMT,  sigemt);
	signal(SIGBUS,  sigbus);
	signal(SIGSYS,  sigsys);
# endif
	signal(SIGPIPE, sigpipe);		
#ifdef SIGTSTP
	signal(SIGTSTP,tstop);		
	signal(SIGSTOP,tstop);
#endif /* SIGTSTP */
#endif /* __MSDOS__ */
}

#ifdef BSD	/* for BSD UNIX? */

static char *signame[NSIG] = { 
	"",
	"SIGHUP",  /*	1	 hangup */
	"SIGINT",  /*	2	 interrupt */
	"SIGQUIT", /*	3	 quit */
	"SIGILL",  /*	4	 illegal instruction (not reset when caught) */
	"SIGTRAP", /*	5	 trace trap (not reset when caught) */
	"SIGIOT",  /*	6	 IOT instruction */
	"SIGEMT",  /*	7	 EMT instruction */
	"SIGFPE",  /*	8	 floating point exception */
	"SIGKILL", /*	9	 kill (cannot be caught or ignored) */
	"SIGBUS",  /*	10	 bus error */
	"SIGSEGV", /*	11	 segmentation violation */
	"SIGSYS",  /*	12	 bad argument to system call */
	"SIGPIPE", /*	13	 write on a pipe with no one to read it */
	"SIGALRM", /*	14	 alarm clock */
	"SIGTERM", /*	15	 software termination signal from kill */
	"SIGURG",  /*	16	 urgent condition on IO channel */
	"SIGSTOP", /*	17	 sendable stop signal not from tty */
	"SIGTSTP", /*	18	 stop signal from tty */
	"SIGCONT", /*	19	 continue a stopped process */
	"SIGCHLD", /*	20	 to parent on child stop or exit */
	"SIGTTIN", /*	21	 to readers pgrp upon background tty read */
	"SIGTTOU", /*	22	 like TTIN for output if (tp->t_local&LTOSTOP)*/
	"SIGIO",   /*	23	 input/output possible signal */
	"SIGXCPU", /*	24	 exceeded CPU time limit */
	"SIGXFSZ", /*	25	 exceeded file size limit */
	"SIGVTALRM",/*  26	 virtual time alarm */
	"SIGPROF", /*	27	 profiling time alarm */
	"","","","" };

#else  /* SYSV */
# ifndef __MSDOS__
static char *signame[NSIG] = { 
	"",
	"SIGHUP",  /*	1	 hangup */
	"SIGINT",  /*	2	 interrupt */
	"SIGQUIT", /*	3	 quit */
	"SIGILL",  /*	4	 illegal instruction (not reset when caught) */
	"SIGTRAP", /*	5	 trace trap (not reset when caught) */
	"SIGIOT",  /*	6	 IOT instruction */
	"SIGEMT",  /*	7	 EMT instruction */
	"SIGFPE",  /*	8	 floating point exception */
	"SIGKILL", /*	9	 kill (cannot be caught or ignored) */
	"SIGBUS",  /*	10	 bus error */
	"SIGSEGV", /*	11	 segmentation violation */
	"SIGSYS",  /*	12	 bad argument to system call */
	"SIGPIPE", /*	13	 write on a pipe with no one to read it */
	"SIGALRM", /*	14	 alarm clock */
	"SIGTERM", /*	15	 software termination signal from kill */
	"SIGUSR1",  /*	16	 user defines signal 1 */
	"SIGUSR2", /*	17	 user defines signal 2 */
	"SIGCLD",  /*	18	 child death */
	"SIGPWR"   /*	19	 power fail */
};
# else /* __MSDOS__ */
static char *signame[] = {
  "",         /*  0 */
  "",         /*  1 */
  "SIGINT",   /*  2 */
  "",         /*  3 */
  "SIGILL",   /*  4 */
  "",         /*  5 */
  "",         /*  6 */
  "",         /*  7 */
  "SIGFPE",   /*  8 */
  "",         /*  9 */
  "",         /* 10 */
  "SIGSEGV",  /* 11 */
  "",         /* 12 */
  "",         /* 13 */
  "",         /* 14 */
  "SIGTERM",  /* 15 */
  "SIGUSR1",  /* 16 */
  "SIGUSR2",  /* 17 */
  "",         /* 18 */
  "",         /* 19 */
  "SIGUSR3",  /* 20 */
  "SIGBREAK", /* 21 */
  "SIGABRT",  /* 22 */
};
# endif /* __MSDOS__ */

#endif /* BSD */

/*
 *	routine to process a fatal error signal
 */
sigpanic(sig)
int sig;
{
	signal(sig,SIG_DFL);
	fprintf(stderr,"\nUlarn - Signal %d !!! [%s]\n",sig,signame[sig]);
	fflush(stderr);
	nap(2200);
	sncbr();
	savegame(savefilename); 
#ifdef __MSDOS__
        exit(10);
#else
	kill(getpid(),sig); /* this will terminate us */
#endif
}
