#include <stdio.h>
#include <fcntl.h>
#include "options.h"
#include "misc.h"
#include "var.h"
#include "nuke.h"

struct nukstr all[MAX_NUKES];

main()
{
    FILE    *fp, *fopen();
    int     nukf, x, numnukes;
    struct nukstr *np;
    char    buf[80], *sprintf();

    if ((fp=fopen("nuke.ascii", "w")) == (FILE *)0){
        fprintf(stderr,"Cannot write nuke.ascii!\n");
        exit(-1);
    }

    nukf = open(sprintf(buf,"%s/nuke",DATADIR), O_RDONLY, 0);

    if (nukf == -1){
        fprintf(stderr,"Cannot read %s/nuke\n",DATADIR);
        exit(-1);
    }

    numnukes = (read(nukf, all, sizeof(all)))/sizeof(struct nukstr);
    close(nukf);

    fprintf(fp,"%d\n",numnukes);

    np = all;
    for(x=0;x<numnukes;x++,np++)
        write_nuk(np, fp);

    fclose(fp);
}

write_nuk(np, fp)
struct nukstr *np;
FILE *fp;
{
    int x, y;

    fprintf(fp,"%d ",np->nuk_x);
    fprintf(fp,"%d ",np->nuk_y);
    fprintf(fp,"%d ",np->nuk_own);
    fprintf(fp,"%d ",np->nuk_n);
    fprintf(fp,"%d ",np->nuk_uid);
    fprintf(fp,"%d ",np->nuk_ship);
    fprintf(fp,"%d ",np->nuk_trade);

    for(x=0;x<N_MAXNUKE;x++)
        fprintf(fp,"%d ",np->nuk_types[x]);

    fprintf(fp,"\n");
}
