/*
**  wt -- a 3d game engine
**
**  Copyright (C) 1994 by Chris Laurel
**  email:  claurel@mr.net
**  snail mail:  Chris Laurel, 5700 W Lake St #208,  St. Louis Park, MN  55416
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <vga.h>
#include "wt.h"
#include "error.h"
#include "wtmem.h"
#include "framebuf.h"
#include "graphics.h"


static void load_palette(void);

static int graphics_initialized = 0;
static unsigned char *video_mem;
static Pixel *fb_mem;


void init_graphics(void)
{
     vga_setmode(G320x200x256);
     video_mem = vga_getgraphmem();
     load_palette();
     fb_mem = wtmalloc(SCREEN_HEIGHT * SCREEN_WIDTH);
     graphics_initialized = 1;
}


void load_palette(void)
{
     FILE *fp;
     int r, g, b;
     int i;

     fp = fopen(DEFAULT_PALETTE_FILE, "rb");
     if (fp == NULL)
	  fatal_error("unable to open palette file");
     for (i = 0; i < PALETTE_ENTRIES; i++) {
	  r = getc(fp);
	  g = getc(fp);
	  b = getc(fp);
	  if (b == EOF)
	       fatal_error("error reading palette file");
	  vga_setpalette(i, r, g, b);
     }

     fclose(fp);
}


void end_graphics(void)
{
     if (graphics_initialized) {
	  vga_setmode(TEXT);
	  graphics_initialized = 0;
     }
}


void update_screen(Framebuffer *fb)
{
     memcpy(video_mem, fb->pixels, fb->fb_height * fb->fb_width);
}


Pixel *get_framebuffer_memory(int width, int height)
{
     return fb_mem;
}
