/*
   ** Copyright 1996 Thorsten Kukuk <kukuk@uni-paderborn.de>
   **
   ** This program is free software; you can redistribute it and/or modify
   ** it under the terms of the GNU General Public License as published by
   ** the Free Software Foundation; either version 2 of the License, or
   ** (at your option) any later version.
   **
   ** This program is distributed in the hope that it will be useful,
   ** but WITHOUT ANY WARRANTY; without even the implied warranty of
   ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   ** GNU General Public License for more details.
   **
   ** You should have received a copy of the GNU General Public License
   ** along with this program; if not, write to the Free Software
   ** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <netdb.h>
#include <time.h>
#include <sys/types.h>
#include <pwd.h>
#include <errno.h>
#include <unistd.h>
#include <limits.h>
#include <rpc/rpc.h>
#include <rpcsvc/yp.h>
#include <rpcsvc/ypclnt.h>
/*
   ** Some distributions have a "/usr/include/rpcsvc/yppasswd.h" from
   ** Olaf Kirch, DON'T use that !
 */
#include "yppasswd.h"

#include "pwdutils.h"

char *
get_master_server (void)
{
  char *domainname, *master;
  int port, err;

  if ((err = yp_get_default_domain (&domainname)) != 0)
    {
      fprintf (stderr, "ERROR: can't get local NIS domainname: %s\n",
	       yperr_string (err));
      return NULL;
    }

  if ((err = yp_master (domainname, "passwd.byname", &master)) != 0)
    {
      fprintf (stderr, "ERROR: can't find the master NIS server: %s\n",
	       yperr_string (err));
      return NULL;
    }

  port = getrpcport (master, YPPASSWDPROG, YPPASSWDPROC_UPDATE, IPPROTO_UDP);
  if (port >= IPPORT_RESERVED)
    {
      fprintf (stderr, "ERROR: yppasswd daemon running on illegal port %d.\n",
	       port);
      return NULL;
    }
  if (port == 0)
    {
      fprintf (stderr, "ERROR: yppasswdd not running on NIS master \"%s\"\n", master);
      return NULL;
    }

  return master;
}

int 
yp_writeback (struct passwd *pwd, char *oldpassword, char *master)
{
  struct timeval timeout;
  struct yppasswd yppasswd;
  CLIENT *clnt;
  int err, status;

  /* 
     ** Initialize password information 
     ** We couldn't use memcpy, since the newpw struct != passwd struct 
   */
  yppasswd.newpw.pw_name = pwd->pw_name;
  yppasswd.newpw.pw_passwd = pwd->pw_passwd;
  yppasswd.newpw.pw_uid = pwd->pw_uid;
  yppasswd.newpw.pw_gid = pwd->pw_gid;
  yppasswd.newpw.pw_gecos = pwd->pw_gecos;
  yppasswd.newpw.pw_dir = pwd->pw_dir;
  yppasswd.newpw.pw_shell = pwd->pw_shell;
  yppasswd.oldpass = oldpassword;

#ifdef DEBUG
  printf ("name.....: [%s]\n", yppasswd.newpw.pw_name);
  printf ("password.: [%s]\n", yppasswd.newpw.pw_passwd);
  printf ("user id..: [%d]\n", yppasswd.newpw.pw_uid);
  printf ("group id.: [%d]\n", yppasswd.newpw.pw_gid);
  printf ("gecos....: [%s]\n", yppasswd.newpw.pw_gecos);
  printf ("directory: [%s]\n", yppasswd.newpw.pw_dir);
  printf ("shell....: [%s]\n", yppasswd.newpw.pw_shell);
#endif

  clnt = clnt_create (master, YPPASSWDPROG, YPPASSWDVERS, "udp");
  clnt->cl_auth = authunix_create_default ();
  memset ((char *) &status, 0, sizeof (status));
  timeout.tv_sec = 25;
  timeout.tv_usec = 0;
  err = clnt_call (clnt, YPPASSWDPROC_UPDATE,
		   (xdrproc_t) xdr_yppasswd, (char *) &yppasswd,
		   (xdrproc_t) xdr_int, (char *) &status,
		   timeout);

  if (err)
    {
      clnt_perrno (err);
      fprintf (stderr, "\n");
    }

  auth_destroy (clnt->cl_auth);
  clnt_destroy (clnt);
  return ((err || status) != 0);
}

/*
   ** The following is generated by rpcgen and edit a little by me (TK)
 */
bool_t 
xdr_x_passwd (XDR * xdrs, x_passwd * objp)
{
  if (!xdr_string (xdrs, &objp->pw_name, ~0))
    return (FALSE);

  if (!xdr_string (xdrs, &objp->pw_passwd, ~0))
    return (FALSE);

  if (!xdr_int (xdrs, &objp->pw_uid))
    return (FALSE);

  if (!xdr_int (xdrs, &objp->pw_gid))
    return (FALSE);

  if (!xdr_string (xdrs, &objp->pw_gecos, ~0))
    return (FALSE);

  if (!xdr_string (xdrs, &objp->pw_dir, ~0))
    return (FALSE);

  if (!xdr_string (xdrs, &objp->pw_shell, ~0))
    return (FALSE);

  return (TRUE);
}

bool_t 
xdr_yppasswd (XDR * xdrs, yppasswd * objp)
{
  if (!xdr_string (xdrs, &objp->oldpass, ~0))
    return (FALSE);

  if (!xdr_x_passwd (xdrs, &objp->newpw))
    return (FALSE);

  return (TRUE);
}
