/******************************************************************************
*									      *
*	(C) 1993 by K. Ballueder					      *
*									      *
*	See README and COPYING for details.				      *
*									      *
*	Please feel free to contact me:					      *
*		kballued@charon.physik.uni-osnabrueck.de		      *
*		kballued@jupiter.rz.uni-osnabrueck.de			      *
*									      *
******************************************************************************/

/*************************************************************************

gr_interface.h: header file for system dependent graphic-interfaces

***********************************************************end-of-header*/

#ifndef GR_INTERFACE_H
#define GR_INTERFACE_H

#ifdef OS_DOS
#	include "dos_bgi.h"
#endif
#ifdef OS_LINUX
#	include "linux_gl.h"
#endif

#ifndef CC_TURBOC
	typedef unsigned  char DacPalette256[256][3];
#endif

extern int dx, dy;

extern int gr_maxx, gr_maxy;

/* initialization graphics mode: */
extern void initgraphics(void);
extern void update_graphics(void);

/* terminate graphics mode: */
extern void leavegraphics(void);

/* set palette: */
extern void setpalette(DacPalette256 *palette);

/* write string with upper left corner at (x,y): */
extern void write_text(int x, int y, char *string);

/* scrolling: */
extern void _scroll_up(void);
extern void _scroll_left(void);
extern void _scroll_right(void);
extern void _scroll_down(void);

extern void display_image(int x, int y, void *data);
extern void gr_line(int a, int b, int c, int d, int color);
extern void gr_fillbox(int a, int b, int w, int h, int color);
#endif
