#ifndef lint
static char *RCSid = "$Header: trad.c,v 1.13 90/03/19 11:14:20 mr-frog Exp $";
#endif /* not lint */

/*
 * trad.c
 *
 * buy units from other nations.
 *
 * Dave Pare, 1986
 */

#include <ctype.h>
#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "news.h"
#include "item.h"
#include "ship.h"
#include "nuke.h"
#include "plane.h"
#include "trade.h"
#include "deity.h"
#include "xy.h"
#include "nsc.h"
#include "file.h"

/*
 * format: trade
 */
trad()
{
	extern	char *argp[];
	struct	sctstr sect;
	struct	natstr *natp;
	int	lotno;
	float	price;
	coord	sx, sy;
	int	n;
	char	*p;
	int	saveid;
	struct	nstr_item ni;
	struct	trdstr trade;
	union	trdgenstr tg;
	int	plflags;
	extern	double tradetax;

	pr("\n     Empire Trade Report\n  ");
	prdate();
	if (commread() < 0) {
		pr("Unable to read commodity file; get help!\n");
		return RET_SYS;
	}
	n = 0;
	pr(" lot# cnum    country   price              desc\n");
	snxtitem_all(&ni, EF_TRADE);
	while (nxtitem(&ni, (char *)&trade)) {
		if (trade.trd_unitid < 0)
			continue;
		if (!trade_getitem(&trade, &tg)) {
			continue;
		};
		/* fix up database if things get weird */
		if (trade.trd_owner != tg.gen.trg_own) {
			trade.trd_unitid = -1;
			(void) puttrade(ni.cur, &trade);
			continue;
		}
		pr(fmt(" %3d ", ni.cur));
		(void) trade_desc(&trade, &tg);		/* XXX */
		if (trade.trd_owner == cnum && !god)
			pr(" (your own lot)\n");
		else
			pr("\n");
		n++;
	}
	if (n == 0) {
		pr("Nothing to buy at the moment...\n");
		return RET_OK;
	}
	if ((p = getstring("Which lot to buy : ")) == 0 || *p == 0)
		return RET_OK;
	if (isdigit(*p) == 0)
		return RET_OK;
	lotno = atoi(p);
	if (lotno < 0 || lotno >= ni.cur) {
		pr("Bad lot number\n");
		return RET_OK;
	}
	if (!ef_lock(EF_TRADE)) {
		logerror("Can't lock trade file\n");
		return RET_SYS;
	}
	if (!gettrade(lotno, &trade)) {
		pr("No such lot number\n");
		(void) ef_unlock(EF_TRADE);
		return RET_OK;
	}
	if (!trade_getitem(&trade, &tg)) {
		pr(fmt("Can't find trade #%d!\n", trade.trd_unitid));
		trade.trd_unitid = -1;
		if (!puttrade(lotno, &trade)) {
			pr("Couldn't save after getitem failed; get help!\n");
			(void) ef_unlock(EF_TRADE);
			return RET_SYS;
		}
		(void) ef_unlock(EF_TRADE);
		return RET_OK;
	}
	switch (trade.trd_type) {
	case EF_NUKE:
		if (!getsect(tg.gen.trg_x, tg.gen.trg_y, &sect)) {
			(void) ef_unlock(EF_TRADE);
			return RET_FAIL;
		}
		trade.trd_owner = sect.sct_own;
		break;
	case EF_PLANE:
	case EF_SHIP:
		break;
	default:
		(void) ef_unlock(EF_TRADE);
		pr(fmt("Bad unit type on lot number %d\n", lotno));
		return RET_FAIL;
	}
	if (trade.trd_owner == cnum) {
		(void) ef_unlock(EF_TRADE);
		pr("You can't buy from yourself!\n");
		return RET_OK;
	}
	price = multread(trade.trd_owner, cnum) * trade.trd_price;
	natp = getnatp(cnum);
	if (natp->nat_money < price) {
		(void) ef_unlock(EF_TRADE);
		pr(fmt("You don't have %.2f to spend!\n", price));
		return RET_OK;
	}

	/*
	 * Find the destination sector for the plane before the trade
	 * is actually made. Must be owned (except for satellites) and
	 * must be a 60% airfield (except for VTOL planes).
	 */
	if (((trade.trd_type == EF_PLANE) || (trade.trd_type == EF_NUKE))
	    && ((trade.trd_type == EF_NUKE) ||
				!(tg.pln.pln_flags & PLN_LAUNCHED))) {
		plflags = plchr[tg.pln.pln_type].pl_flags;
		while (1) {
			p = getstring("Destination sector: ");
			if (p == 0) {
				(void) ef_unlock(EF_TRADE);
				return RET_FAIL;
			}
			if (!sarg_xy(p, &sx, &sy) ||
					!getsect(sx, sy, &sect)) {
				pr("Bad sector designation; try again!\n");
				continue;
			}
			if (!owner && !(plflags & P_O)) {
				pr("You don't own that sector; try again!\n");
				continue;
			}
			if (!(plflags & (P_V | P_O))) {
				if (!god && (sect.sct_type != SCT_AIRPT)) {
					pr(
				    "Destination sector is not an airfield!\n");
					continue;
				}
				if (!god && (sect.sct_effic < 60))  {
					pr(
				    "That airport still under construction!\n");
					continue;
				}
			}
			break;
		}
	}
	saveid = trade.trd_unitid;
	trade.trd_unitid = -1;
	if (!puttrade(lotno, &trade)) {
		pr("Couldn't save trade after purchase; get help!\n");
		(void) ef_unlock(EF_TRADE);
		return RET_SYS;
	}
	(void) ef_unlock(EF_TRADE);


	pr(fmt("Bought %s %d for %.2f\n", trade_nameof(&trade, &tg),
		saveid, price));
	switch (trade.trd_type) {
	case EF_NUKE:
		while (1) {
			p = getstring("Destination sector: ");
			if (p == 0) {
				return RET_FAIL;
			}
			if (!sarg_xy(p, &sx, &sy)) {
				pr("Bad sector designation; try again!\n");
				continue;
			}
			break;
		}
		tg.nuk.nuk_x =  sx;
		tg.nuk.nuk_y =  sy;
		tg.nuk.nuk_own = cnum;
		break;
	case EF_PLANE:
		if ((tg.pln.pln_flags & PLN_LAUNCHED) == 0) {
			tg.pln.pln_x = sx;
			tg.pln.pln_y = sy;
			if (tg.pln.pln_effic > 75)
				tg.pln.pln_effic = 75;
		}
#ifdef PLIMIT
#if defined (XLIGHT) || defined (SHIPCHOPPERS)
		if (tg.pln.pln_ship >= 0){
			struct shpstr ship;
			getship(tg.pln.pln_ship, &ship);
			take_plane_off_ship(&tg.pln,&ship);
		}
#else
		if (tg.pln.pln_ship >= 0){
			struct shpstr ship;
			getship(tg.pln.pln_ship, &ship);
			ship.shp_nplane--;
			tg.pln.pln_ship = 0;
		}
#endif
#endif /* PLIMIT */
		tg.pln.pln_own = cnum;
		tg.pln.pln_wing = ' ';
		/* no cheap version of fly */
		tg.pln.pln_mobil = 0;
		tg.pln.pln_ship = -1;
		break;
	case EF_SHIP:
		takeover_ship(&tg.shp, cnum, 0);
		break;
	default:
		pr(fmt("Bad trade type %d in trade\n", trade.trd_type));
		break;
	}
	if (!ef_nbwrite(trade.trd_type, saveid, (char *)&tg)) {
		pr("Couldn't write unit to disk; seek help.\n");
		return RET_SYS;
	}
	NAT_DELTA(nat_money, trade.trd_owner, (int)(price * tradetax));
	nreport(trade.trd_owner, N_MAKE_SALE, cnum, 1);
	wu(0, trade.trd_owner, fmt("%s bought a %s #%d from you for $%.2f\n",
		cname(cnum), trade_nameof(&trade, &tg), saveid, price *
		tradetax));
	dolcost += price;
	return RET_OK;
}
