/*********************************************************************/
/* file: echo.c - funtions to turn keyboard echo on/off              */
/*                             TINTIN III                            */
/*          (T)he K(I)cki(N) (T)ickin D(I)kumud Clie(N)t             */
/*                     coded by peter unold 1992                     */
/*********************************************************************/
/* This might not work on some exotic unix versions. Nothin I can do */
/* about it, coz most of this was lifted from other programs...      */
/*********************************************************************/
#include "tintin.h"

#if IRIX
  #include <stdlib.h>
  #include <unistd.h>
  #include <sys/ioctl.h>
#endif

#if defined(sgi) || defined(aix) || defined(hpux) || defined(_SEQUENT_) || defined(DO_TERMIO)
  #include <sys/termio.h>
#else
#ifdef GOTLINUX /* Added by nxc@cs.bham.ac.uk */
 #include <bsd/sgtty.h>
#else
 #include <sgtty.h>
#endif /* GOTLINUX */
#if DIRTY_REDEFINE
#undef TIOCGETP
#undef TIOCSETP
#define TIOCGETP 0x40067408
#define TIOCSETP 0x80067409
#endif
#endif

#if defined(hpux) || defined(aix) || defined(_SEQUENT_) || defined(sgi)
struct termio oldtio;

/********************************/
/* turn echo on - HP-UX version */
/********************************/
void term_echo()
{
  struct  termio io;

  if(ioctl(0, TCSETA, &oldtio)<0)
    syserr("ioctl");
}

/*********************************/
/* turn echo off - HP-UX version */
/*********************************/
void term_noecho()
{
  struct  termio io;

  if(ioctl(0, TCGETA, &io)<0)
    syserr("ioctl");
  oldtio=io;
  io.c_lflag &= ~ECHO; 
  io.c_lflag &= ~ICANON;
  io.c_cc[VMIN]=1;
  io.c_cc[VTIME]=0;
  if(ioctl(0, TCSETA, &io)<0)
    syserr("ioctl");
}

#else
/********************************/
/* turn echo on - SunOS version */
/********************************/
void term_echo()
{
  struct  sgttyb sgbuf;
  if(ioctl(0, TIOCGETP, &sgbuf)<0)
    syserr("ioctl");
  sgbuf.sg_flags &= ~CBREAK;
  sgbuf.sg_flags |= ECHO;
  if(ioctl(0, TIOCSETP, &sgbuf)<0)
    syserr("ioctl");
}

/**********************************/
/* turn echo off  - SunOS version */
/**********************************/
void term_noecho()
{
  struct  sgttyb sgbuf;
  struct tchars tco;
  if(ioctl(0, TIOCGETP, &sgbuf)<0)
    syserr("ioctl");
  sgbuf.sg_flags &= ~ECHO;
  sgbuf.sg_flags |= CBREAK;
  if(ioctl(0, TIOCSETP, &sgbuf)<0)
    syserr("opctl");
}
#endif

