.TH LPCANAL 1Csound "7 Feb 1991"
.SH NAME
lpcanal - Paul Lansky's software for linear predictive analysis and pitch tracking, adapted for Csound.
.SH SYNTAX
.B lpcanal 
[-p<n> -i<n> -s<t> -d<t> -o<file> -C<str> -P<frq> -Q<frq>] soundfile
.SH DESCRIPTION
.PP
.I lpcanal
is the new experimental combination of the old
.I anallpc 
and 
.I ptrack. 
It performs linear predictive analysis and pitch tracking on monaural 16bit 
fixed point soundfiles.  Its arguments are explained below:-
.TP 16
-p<npoles>
Number of poles for analysis.  Default is 34 poles, which is also 
the maximum allowed.
.TP 16
-i<frameoffset> 
Offset in samples between analysis frames.  Default 200 samples, maximum 
is 250 samples.  The actual analysis framesize will be twice this number.
.TP 16
-s<skiptime>
Initial seconds of sound to skip over.  Default 0.0.
.TP 16
-d<duration>
Duration in seconds to analyze.  Default is to end of file.
.TP 16
-o<outputfile>
Name for the analysis output file.  If not specified analysis data is 
written to the stdout stream.  Should be of the form lp.n for Csound 
compatibility.
.TP 16
-C<string>
Text for the comment field of the lpfile header.  In the default case 
this is left empty.
.TP 16
-P<minpitch>
Lower limit frequency for pitch tracking.  -P0 inhibits pitch tracking 
altogether.
.TP 16
-Q<maxpitch>
Upper limit frequency for pitch tracking.  The narrower the
search range, the more accurate the pitch estimate.
.TP 16
soundfile         
Input mono shortsam soundfile.  The value of the environment variable 
SFDIR is searched if the soundfile name doesn't begin with '.' or '/'.
.PP
Note that options must follow their respective flags without any
intervening space, and that 
.B soundfile
must occur last on the command line ( see
.I crack(carl)
).
.SH DIAGNOSTICS
.PP
Unrecognized commandline options to 
.I lpcanal
will produce a helpful usage message.
.SH AUTHORS
Paul Lansky at Princeton, modified for MIT Csound by dwf, bv, and dll.
Compact version by dpwe.
.SH BUGS
Currently reads only Ircam-format soundfiles.


