/*	$NetBSD: intel_lvds.h,v 1.3 2021/12/19 11:38:03 riastradh Exp $	*/

/* SPDX-License-Identifier: MIT */
/*
 * Copyright © 2019 Intel Corporation
 */

#ifndef __INTEL_LVDS_H__
#define __INTEL_LVDS_H__

#include <linux/types.h>

#include "i915_reg.h"

#include <sys/file.h>
#define	pipe	pipe_drmhack	/* see intel_display.h */

enum pipe;
struct drm_i915_private;

bool intel_lvds_port_enabled(struct drm_i915_private *dev_priv,
			     i915_reg_t lvds_reg, enum pipe *pipe);
void intel_lvds_init(struct drm_i915_private *dev_priv);
struct intel_encoder *intel_get_lvds_encoder(struct drm_i915_private *dev_priv);
bool intel_is_dual_link_lvds(struct drm_i915_private *dev_priv);

#endif /* __INTEL_LVDS_H__ */
