/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.file;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.tools.ant.DirectoryScanner;
import org.gradle.BuildAdapter;
import org.gradle.api.initialization.Settings;
import org.gradle.initialization.RootBuildLifecycleListener;
import org.gradle.internal.event.AnonymousListenerBroadcast;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.file.FileSystemDefaultExcludesProvider;
import org.gradle.internal.file.excludes.FileSystemDefaultExcludesListener;

public class DefaultFileSystemDefaultExcludesProvider
implements FileSystemDefaultExcludesProvider {
    private ImmutableList<String> currentDefaultExcludes = ImmutableList.copyOf((Object[])DirectoryScanner.getDefaultExcludes());
    private final AnonymousListenerBroadcast<FileSystemDefaultExcludesListener> broadcast;

    public DefaultFileSystemDefaultExcludesProvider(ListenerManager listenerManager) {
        this.broadcast = listenerManager.createAnonymousBroadcaster(FileSystemDefaultExcludesListener.class);
        listenerManager.addListener((Object)new RootBuildLifecycleListener(){

            @Override
            public void afterStart() {
                DirectoryScanner.resetDefaultExcludes();
                DefaultFileSystemDefaultExcludesProvider.this.currentDefaultExcludes = ImmutableList.copyOf((Object[])DirectoryScanner.getDefaultExcludes());
                ((FileSystemDefaultExcludesListener)DefaultFileSystemDefaultExcludesProvider.this.broadcast.getSource()).onDefaultExcludesChanged((List)DefaultFileSystemDefaultExcludesProvider.this.currentDefaultExcludes);
            }

            @Override
            public void beforeComplete() {
            }
        });
        listenerManager.addListener((Object)new BuildAdapter(){

            public void settingsEvaluated(Settings settings) {
                DefaultFileSystemDefaultExcludesProvider.this.currentDefaultExcludes = ImmutableList.copyOf((Object[])DirectoryScanner.getDefaultExcludes());
                ((FileSystemDefaultExcludesListener)DefaultFileSystemDefaultExcludesProvider.this.broadcast.getSource()).onDefaultExcludesChanged((List)DefaultFileSystemDefaultExcludesProvider.this.currentDefaultExcludes);
            }
        });
    }

    @Override
    public List<String> getCurrentDefaultExcludes() {
        return this.currentDefaultExcludes;
    }

    @Override
    public void updateCurrentDefaultExcludes(List<String> excludes) {
        DirectoryScanner.resetDefaultExcludes();
        for (String exclude : excludes) {
            DirectoryScanner.addDefaultExclude((String)exclude);
        }
        this.currentDefaultExcludes = ImmutableList.copyOf(excludes);
        ((FileSystemDefaultExcludesListener)this.broadcast.getSource()).onDefaultExcludesChanged(this.currentDefaultExcludes);
    }
}

