/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.Platform;
import com.sun.media.sound.PortMixer;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.spi.MixerProvider;

public final class PortMixerProvider
extends MixerProvider {
    private static PortMixerInfo[] infos;
    private static PortMixer[] devices;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortMixerProvider() {
        Class<PortMixerProvider> clazz = PortMixerProvider.class;
        synchronized (PortMixerProvider.class) {
            if (Platform.isPortsEnabled()) {
                PortMixerProvider.init();
            } else {
                infos = new PortMixerInfo[0];
                devices = new PortMixer[0];
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void init() {
        int n = PortMixerProvider.nGetNumDevices();
        if (infos == null || infos.length != n) {
            infos = new PortMixerInfo[n];
            devices = new PortMixer[n];
            for (int i = 0; i < infos.length; ++i) {
                PortMixerProvider.infos[i] = PortMixerProvider.nNewPortMixerInfo(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mixer.Info[] getMixerInfo() {
        Class<PortMixerProvider> clazz = PortMixerProvider.class;
        synchronized (PortMixerProvider.class) {
            Mixer.Info[] infoArray = new Mixer.Info[infos.length];
            System.arraycopy(infos, 0, infoArray, 0, infos.length);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return infoArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mixer getMixer(Mixer.Info info) {
        Class<PortMixerProvider> clazz = PortMixerProvider.class;
        synchronized (PortMixerProvider.class) {
            for (int i = 0; i < infos.length; ++i) {
                if (!infos[i].equals(info)) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return PortMixerProvider.getDevice(infos[i]);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            throw new IllegalArgumentException("Mixer " + info.toString() + " not supported by this provider.");
        }
    }

    private static Mixer getDevice(PortMixerInfo portMixerInfo) {
        int n = portMixerInfo.getIndex();
        if (devices[n] == null) {
            PortMixerProvider.devices[n] = new PortMixer(portMixerInfo);
        }
        return devices[n];
    }

    private static native int nGetNumDevices();

    private static native PortMixerInfo nNewPortMixerInfo(int var0);

    static {
        Platform.initialize();
    }

    static final class PortMixerInfo
    extends Mixer.Info {
        private final int index;

        private PortMixerInfo(int n, String string, String string2, String string3, String string4) {
            super("Port " + string, string2, string3, string4);
            this.index = n;
        }

        int getIndex() {
            return this.index;
        }
    }
}

