/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.util.Collection;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.IntFieldSource;
import org.apache.lucene.queries.function.valuesource.MultiValuedIntFieldSource;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.solr.schema.IntValueFieldType;
import org.apache.solr.schema.NumberType;
import org.apache.solr.schema.PointField;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.uninverting.UninvertingReader;

public class IntPointField
extends PointField
implements IntValueFieldType {
    public IntPointField() {
        this.type = NumberType.INTEGER;
    }

    @Override
    public Object toNativeType(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        try {
            if (val instanceof CharSequence) {
                return Integer.parseInt(val.toString());
            }
        }
        catch (NumberFormatException e) {
            Float v = Float.valueOf(Float.parseFloat(val.toString()));
            return v.intValue();
        }
        return super.toNativeType(val);
    }

    @Override
    public Query getPointRangeQuery(QParser parser, SchemaField field, String min, String max, boolean minInclusive, boolean maxInclusive) {
        int actualMax;
        int actualMin;
        if (min == null) {
            actualMin = Integer.MIN_VALUE;
        } else {
            actualMin = IntPointField.parseIntFromUser(field.getName(), min);
            if (!minInclusive) {
                if (actualMin == Integer.MAX_VALUE) {
                    return new MatchNoDocsQuery();
                }
                ++actualMin;
            }
        }
        if (max == null) {
            actualMax = Integer.MAX_VALUE;
        } else {
            actualMax = IntPointField.parseIntFromUser(field.getName(), max);
            if (!maxInclusive) {
                if (actualMax == Integer.MIN_VALUE) {
                    return new MatchNoDocsQuery();
                }
                --actualMax;
            }
        }
        return IntPoint.newRangeQuery((String)field.getName(), (int)actualMin, (int)actualMax);
    }

    @Override
    public Object toObject(SchemaField sf, BytesRef term) {
        return IntPoint.decodeDimension((byte[])term.bytes, (int)term.offset);
    }

    @Override
    public Object toObject(IndexableField f) {
        Number val = f.numericValue();
        if (val != null) {
            return val.intValue();
        }
        throw new AssertionError((Object)("Unexpected state. Field: '" + f + "'"));
    }

    @Override
    protected Query getExactQuery(SchemaField field, String externalVal) {
        return IntPoint.newExactQuery((String)field.getName(), (int)IntPointField.parseIntFromUser(field.getName(), externalVal));
    }

    @Override
    public Query getSetQuery(QParser parser, SchemaField field, Collection<String> externalVal) {
        assert (externalVal.size() > 0);
        if (!field.indexed()) {
            return super.getSetQuery(parser, field, externalVal);
        }
        int[] values = new int[externalVal.size()];
        int i = 0;
        for (String val : externalVal) {
            values[i] = IntPointField.parseIntFromUser(field.getName(), val);
            ++i;
        }
        if (field.hasDocValues()) {
            return IntField.newSetQuery((String)field.getName(), (int[])values);
        }
        return IntPoint.newSetQuery((String)field.getName(), (int[])values);
    }

    @Override
    protected String indexedToReadable(BytesRef indexedForm) {
        return Integer.toString(IntPoint.decodeDimension((byte[])indexedForm.bytes, (int)indexedForm.offset));
    }

    @Override
    public void readableToIndexed(CharSequence val, BytesRefBuilder result) {
        result.grow(4);
        result.setLength(4);
        IntPoint.encodeDimension((int)IntPointField.parseIntFromUser(null, val.toString()), (byte[])result.bytes(), (int)0);
    }

    @Override
    public UninvertingReader.Type getUninversionType(SchemaField sf) {
        if (sf.multiValued()) {
            return null;
        }
        return UninvertingReader.Type.INTEGER_POINT;
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser qparser) {
        field.checkFieldCacheSource();
        return new IntFieldSource(field.getName());
    }

    @Override
    public IndexableField createField(SchemaField field, Object value) {
        int intValue = value instanceof Number ? ((Number)value).intValue() : Integer.parseInt(value.toString());
        return new IntPoint(field.getName(), new int[]{intValue});
    }

    @Override
    protected StoredField getStoredField(SchemaField sf, Object value) {
        return new StoredField(sf.getName(), ((Integer)this.toNativeType(value)).intValue());
    }

    @Override
    protected ValueSource getSingleValueSource(SortedNumericSelector.Type choice, SchemaField f) {
        return new MultiValuedIntFieldSource(f.getName(), choice);
    }
}

