/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.custompages;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.custompages.CustomPage;
import org.zaproxy.zap.extension.custompages.CustomPageMatcherLocation;
import org.zaproxy.zap.extension.custompages.DefaultCustomPage;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.AbstractFormDialog;
import org.zaproxy.zap.view.LayoutHelper;

class DialogAddCustomPage
extends AbstractFormDialog {
    private static final long serialVersionUID = -7210879426146833234L;
    protected static final Logger LOGGER = LogManager.getLogger(DialogAddCustomPage.class);
    private static final String DIALOG_TITLE = Constant.messages.getString("custompages.dialog.add.title");
    private static final String CONFIRM_BUTTON_LABEL = Constant.messages.getString("custompages.dialog.add.button.confirm");
    private JPanel fieldsPanel;
    private JCheckBox enabledCheckBox;
    private JComboBox<CustomPage.Type> customPageTypesCombo;
    private JCheckBox regexCheckBox;
    private ZapTextField pageMatcherTextField;
    private JComboBox<CustomPageMatcherLocation> customPagePageMatcherLocationsCombo;
    protected Context workingContext;
    protected CustomPage customPage;

    public DialogAddCustomPage() {
        super((Dialog)View.getSingleton().getSessionDialog(), DIALOG_TITLE);
    }

    public DialogAddCustomPage(Window owner) {
        super(owner, DIALOG_TITLE);
    }

    protected DialogAddCustomPage(Dialog owner, String title) {
        super(owner, title);
    }

    public void setWorkingContext(Context context) {
        this.workingContext = context;
    }

    @Override
    protected void init() {
        if (this.workingContext == null) {
            throw new IllegalStateException("A working Context should be set before setting the 'Add Dialog' visible.");
        }
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogAddCustomPage.this.setVisible(false);
                DialogAddCustomPage.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.setConfirmButtonEnabled(true);
        this.pack();
    }

    public void clear() {
        this.customPage = null;
        this.workingContext = null;
    }

    @Override
    protected boolean validateFields() {
        String contentMatchString = this.getPageMatcherTextField().getText();
        if (StringUtils.isBlank(contentMatchString) || contentMatchString.trim().equals(".*") && this.getRegexCheckBox().isSelected()) {
            View.getSingleton().showWarningDialog(Constant.messages.getString("custompages.dialog.add.field.content.empty.warn"));
            return false;
        }
        return true;
    }

    @Override
    protected void performAction() {
        this.customPage = new DefaultCustomPage(this.workingContext.getId(), this.getPageMatcherTextField().getText(), (CustomPageMatcherLocation)((Object)this.getCustomPagePageMatcherLocationsCombo().getSelectedItem()), this.getRegexCheckBox().isSelected(), (CustomPage.Type)((Object)this.getCustomPageTypesCombo().getSelectedItem()), this.getEnabledCheckBox().isSelected());
    }

    @Override
    protected void clearFields() {
        this.pageMatcherTextField.setText("");
        this.pageMatcherTextField.discardAllEdits();
        this.customPagePageMatcherLocationsCombo.setSelectedIndex(0);
        this.enabledCheckBox.setSelected(true);
        this.regexCheckBox.setSelected(false);
        this.customPageTypesCombo.setSelectedIndex(0);
        this.setConfirmButtonEnabled(true);
    }

    public CustomPage getCustomPage() {
        return this.customPage;
    }

    @Override
    protected JPanel getFieldsPanel() {
        if (this.fieldsPanel == null) {
            this.fieldsPanel = new JPanel();
            this.fieldsPanel.setLayout(new GridBagLayout());
            this.fieldsPanel.setName("DialogAddCustomPage");
            Insets insets = new Insets(4, 8, 2, 4);
            JLabel paramLabel = new JLabel(Constant.messages.getString("custompages.dialog.add.field.label.content"));
            paramLabel.setLabelFor(this.getPageMatcherTextField());
            this.fieldsPanel.add((Component)paramLabel, LayoutHelper.getGBC(0, 1, 1, 0.5, insets));
            this.fieldsPanel.add((Component)this.getPageMatcherTextField(), LayoutHelper.getGBC(1, 1, 1, 0.5, insets));
            JLabel customPagePageMatcherLocationLabel = new JLabel(Constant.messages.getString("custompages.dialog.add.field.label.contentlocation"));
            customPagePageMatcherLocationLabel.setLabelFor(this.getCustomPagePageMatcherLocationsCombo());
            this.fieldsPanel.add((Component)customPagePageMatcherLocationLabel, LayoutHelper.getGBC(0, 2, 1, 0.5, insets));
            this.fieldsPanel.add(this.getCustomPagePageMatcherLocationsCombo(), LayoutHelper.getGBC(1, 2, 1, 0.5, insets));
            JLabel regexLabel = new JLabel(Constant.messages.getString("custompages.dialog.add.field.label.regex"));
            regexLabel.setLabelFor(this.getRegexCheckBox());
            this.fieldsPanel.add((Component)regexLabel, LayoutHelper.getGBC(0, 3, 1, 0.5, insets));
            this.fieldsPanel.add((Component)this.getRegexCheckBox(), LayoutHelper.getGBC(1, 3, 1, 0.5, insets));
            JLabel enabledLabel = new JLabel(Constant.messages.getString("custompages.dialog.add.field.label.enabled"));
            enabledLabel.setLabelFor(this.getEnabledCheckBox());
            this.fieldsPanel.add((Component)enabledLabel, LayoutHelper.getGBC(0, 4, 1, 0.5, insets));
            this.fieldsPanel.add((Component)this.getEnabledCheckBox(), LayoutHelper.getGBC(1, 4, 1, 0.5, insets));
            JLabel customPageTypeLabel = new JLabel(Constant.messages.getString("custompages.dialog.add.field.label.type"));
            customPageTypeLabel.setLabelFor(this.getCustomPageTypesCombo());
            this.fieldsPanel.add((Component)customPageTypeLabel, LayoutHelper.getGBC(0, 5, 1, 0.5, insets));
            this.fieldsPanel.add(this.getCustomPageTypesCombo(), LayoutHelper.getGBC(1, 5, 1, 0.5, insets));
            this.fieldsPanel.add((Component)new JLabel(), LayoutHelper.getGBC(0, 10, 2, 1.0));
        }
        return this.fieldsPanel;
    }

    protected JCheckBox getEnabledCheckBox() {
        if (this.enabledCheckBox == null) {
            this.enabledCheckBox = new JCheckBox();
            this.enabledCheckBox.setSelected(true);
        }
        return this.enabledCheckBox;
    }

    protected JCheckBox getRegexCheckBox() {
        if (this.regexCheckBox == null) {
            this.regexCheckBox = new JCheckBox();
        }
        return this.regexCheckBox;
    }

    protected ZapTextField getPageMatcherTextField() {
        if (this.pageMatcherTextField == null) {
            this.pageMatcherTextField = new ZapTextField();
        }
        this.pageMatcherTextField.setPreferredSize(new Dimension(280, 30));
        return this.pageMatcherTextField;
    }

    protected JComboBox<CustomPage.Type> getCustomPageTypesCombo() {
        if (this.customPageTypesCombo == null) {
            this.customPageTypesCombo = new JComboBox<CustomPage.Type>(CustomPage.Type.values());
        }
        return this.customPageTypesCombo;
    }

    protected JComboBox<CustomPageMatcherLocation> getCustomPagePageMatcherLocationsCombo() {
        if (this.customPagePageMatcherLocationsCombo == null) {
            this.customPagePageMatcherLocationsCombo = new JComboBox<CustomPageMatcherLocation>(CustomPageMatcherLocation.values());
        }
        return this.customPagePageMatcherLocationsCombo;
    }

    @Override
    protected String getConfirmButtonLabel() {
        return CONFIRM_BUTTON_LABEL;
    }
}

