/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.NewSessionTicketMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.HandshakeMessageParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NewSessionTicketParser
extends HandshakeMessageParser<NewSessionTicketMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public NewSessionTicketParser(int pointer, byte[] array, ProtocolVersion version, Config config) {
        super(pointer, array, HandshakeMessageType.NEW_SESSION_TICKET, version, config);
    }

    @Override
    protected void parseHandshakeMessageContent(NewSessionTicketMessage msg) {
        LOGGER.debug("Parsing NewSessionTicket");
        if (this.getVersion().isTLS13()) {
            this.parseLifetime(msg);
            this.parseAgeAdd(msg);
            this.parseNonceLenght(msg);
            this.parseNonce(msg);
            this.parseIdentityLength(msg);
            this.parseIdentity(msg);
            if (this.hasExtensionLengthField(msg)) {
                this.parseExtensionLength(msg);
                if (this.hasExtensions(msg)) {
                    this.parseExtensionBytes(msg);
                }
            }
        } else {
            this.parseLifetime(msg);
            this.parseIdentityLength(msg);
            this.parseIdentity(msg);
        }
    }

    @Override
    protected NewSessionTicketMessage createHandshakeMessage() {
        return new NewSessionTicketMessage(!this.getVersion().isTLS13());
    }

    private void parseLifetime(NewSessionTicketMessage msg) {
        msg.setTicketLifetimeHint(this.parseIntField(4));
        LOGGER.debug("TicketLifetimeHint:" + msg.getTicketLifetimeHint().getValue());
    }

    private void parseAgeAdd(NewSessionTicketMessage msg) {
        msg.getTicket().setTicketAgeAdd(this.parseByteArrayField(4));
        LOGGER.debug("TicketAgeAdd:" + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getTicket().getTicketAgeAdd().getValue())));
    }

    private void parseNonceLenght(NewSessionTicketMessage msg) {
        msg.getTicket().setTicketNonceLength(this.parseIntField(1));
        LOGGER.debug("TicketNonceLength: " + msg.getTicket().getTicketNonceLength().getValue());
    }

    private void parseNonce(NewSessionTicketMessage msg) {
        msg.getTicket().setTicketNonce(this.parseByteArrayField((Integer)msg.getTicket().getTicketNonceLength().getValue()));
        LOGGER.debug("TicketNonce:" + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getTicket().getTicketNonce().getValue())));
    }

    private void parseIdentityLength(NewSessionTicketMessage msg) {
        msg.getTicket().setIdentityLength(this.parseIntField(2));
        LOGGER.debug("IdentityLength: " + msg.getTicket().getIdentityLength().getValue());
    }

    private void parseIdentity(NewSessionTicketMessage msg) {
        msg.getTicket().setIdentity(this.parseByteArrayField((Integer)msg.getTicket().getIdentityLength().getValue()));
        LOGGER.debug("Identity:" + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getTicket().getIdentity().getValue())));
    }
}

