/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.ClientCertificateType;
import de.rub.nds.tlsattacker.core.constants.SignatureAndHashAlgorithm;
import de.rub.nds.tlsattacker.core.exceptions.PreparationException;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateRequestMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.HandshakeMessagePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertificateRequestPreparator
extends HandshakeMessagePreparator<CertificateRequestMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private byte[] certTypes;
    private byte[] sigHashAlgos;
    private final CertificateRequestMessage msg;

    public CertificateRequestPreparator(Chooser chooser, CertificateRequestMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        LOGGER.debug("Preparing CertificateRequestMessage");
        if (this.chooser.getSelectedProtocolVersion().isTLS13()) {
            this.prepareCertificateRequestContext(this.msg);
            this.prepareCertificateRequestContextLength(this.msg);
            this.prepareExtensions();
            this.prepareExtensionLength();
        } else {
            this.certTypes = this.convertClientCertificateTypes(this.chooser.getConfig().getClientCertificateTypes());
            this.prepareClientCertificateTypes(this.certTypes, this.msg);
            this.prepareClientCertificateTypesCount(this.msg);
            this.prepareDistinguishedNames(this.msg);
            this.prepareDistinguishedNamesLength(this.msg);
            this.sigHashAlgos = this.convertSigAndHashAlgos(this.chooser.getServerSupportedSignatureAndHashAlgorithms());
            this.prepareSignatureHashAlgorithms(this.msg);
            this.prepareSignatureHashAlgorithmsLength(this.msg);
        }
    }

    private byte[] convertClientCertificateTypes(List<ClientCertificateType> typeList) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        for (ClientCertificateType type : typeList) {
            try {
                stream.write(type.getArrayValue());
            }
            catch (IOException ex) {
                throw new PreparationException("Could not prepare CertificateRequestMessage. Failed to write ClientCertificateType into message", ex);
            }
        }
        return stream.toByteArray();
    }

    private byte[] convertSigAndHashAlgos(List<SignatureAndHashAlgorithm> algoList) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        for (SignatureAndHashAlgorithm algo : algoList) {
            try {
                stream.write(algo.getByteValue());
            }
            catch (IOException ex) {
                throw new PreparationException("Could not prepare CertificateRequestMessage. Failed to write SignatureAndHash Algorithm into message", ex);
            }
        }
        return stream.toByteArray();
    }

    private void prepareClientCertificateTypes(byte[] certTypes, CertificateRequestMessage msg) {
        msg.setClientCertificateTypes(certTypes);
        LOGGER.debug("ClientCertificateTypes: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getClientCertificateTypes().getValue())));
    }

    private void prepareClientCertificateTypesCount(CertificateRequestMessage msg) {
        msg.setClientCertificateTypesCount(((byte[])msg.getClientCertificateTypes().getValue()).length);
        LOGGER.debug("ClientCertificateTypesCount: " + msg.getClientCertificateTypesCount().getValue());
    }

    private void prepareDistinguishedNames(CertificateRequestMessage msg) {
        msg.setDistinguishedNames(this.chooser.getConfig().getDistinguishedNames());
        LOGGER.debug("DistinguishedNames: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getDistinguishedNames().getValue())));
    }

    private void prepareDistinguishedNamesLength(CertificateRequestMessage msg) {
        msg.setDistinguishedNamesLength(((byte[])msg.getDistinguishedNames().getValue()).length);
        LOGGER.debug("DistinguishedNamesLength: " + msg.getDistinguishedNamesLength().getValue());
    }

    private void prepareSignatureHashAlgorithms(CertificateRequestMessage msg) {
        msg.setSignatureHashAlgorithms(this.sigHashAlgos);
        LOGGER.debug("SignatureHashAlgorithms: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getSignatureHashAlgorithms().getValue())));
    }

    private void prepareSignatureHashAlgorithmsLength(CertificateRequestMessage msg) {
        msg.setSignatureHashAlgorithmsLength(((byte[])msg.getSignatureHashAlgorithms().getValue()).length);
        LOGGER.debug("SignatureHashAlgorithmsLength: " + msg.getSignatureHashAlgorithmsLength().getValue());
    }

    private void prepareCertificateRequestContext(CertificateRequestMessage msg) {
        msg.setCertificateRequestContext(this.chooser.getConfig().getDefaultCertificateRequestContext());
        LOGGER.debug("CertificateRequestContext: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getCertificateRequestContext().getValue())));
    }

    private void prepareCertificateRequestContextLength(CertificateRequestMessage msg) {
        msg.setCertificateRequestContextLength(((byte[])msg.getCertificateRequestContext().getValue()).length);
        LOGGER.debug("CertificateRquestContextLength: " + msg.getCertificateRequestContextLength().getValue());
    }
}

