/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.asn1.translator;

import de.rub.nds.asn1.translator.Context;
import java.util.HashMap;
import java.util.Map;

public class ContextRegister {
    private static ContextRegister instance = null;
    private final Map<String, Class<? extends Context>> contextClasses = new HashMap<String, Class<? extends Context>>();

    private ContextRegister() {
    }

    public static ContextRegister getInstance() {
        if (instance == null) {
            instance = new ContextRegister();
        }
        return instance;
    }

    public void registerContext(String contextName, Class<? extends Context> contextClass) {
        String maskedInput = this.maskName(contextName);
        if (this.contextClasses.containsKey(maskedInput)) {
            throw new RuntimeException("Cannot register context " + contextName + " more than once!");
        }
        this.contextClasses.put(maskedInput, contextClass);
    }

    public Context createContext(String contextName) {
        try {
            String maskedInput = this.maskName(contextName);
            Class<? extends Context> contextClass = this.contextClasses.get(maskedInput);
            return contextClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private String maskName(String input) {
        return input.trim().toLowerCase();
    }
}

