/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.www.SocketRepositoryEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketRepository {
    private static LogWriter log = LogWriter.getInstance();
    private Map<Integer, SocketRepositoryEntry> socketMap = new HashMap<Integer, SocketRepositoryEntry>();

    public synchronized ServerSocket openServerSocket(int port, String user) throws IOException {
        SocketRepositoryEntry entry = this.socketMap.get(port);
        if (entry == null) {
            ServerSocket serverSocket = new ServerSocket();
            serverSocket.setPerformancePreferences(1, 2, 3);
            serverSocket.setReuseAddress(true);
            try {
                serverSocket.bind(new InetSocketAddress(port));
            }
            catch (BindException e) {
                long totalWait = 0L;
                long startTime = System.currentTimeMillis();
                IOException ioException = null;
                log.logDetailed("Carte socket repository", "Starting a retry loop to bind the server socket on port " + port + ".  We retry for 5 minutes until the socket clears in your operating system.", new Object[0]);
                while (!serverSocket.isBound() && totalWait < 300000L) {
                    try {
                        totalWait = System.currentTimeMillis() - startTime;
                        log.logDetailed("Carte socket repository", "Retry binding the server socket on port " + port + " after a " + totalWait / 1000L + " seconds wait...", new Object[0]);
                        Thread.sleep(10000L);
                        serverSocket.bind(new InetSocketAddress(port), 100);
                    }
                    catch (IOException ioe) {
                        ioException = ioe;
                    }
                    catch (Exception ex) {
                        throw new IOException(ex.getMessage());
                    }
                    totalWait = System.currentTimeMillis() - startTime;
                }
                if (!serverSocket.isBound()) {
                    throw ioException;
                }
                log.logDetailed("Carte socket repository", "Succesfully bound the server socket on port " + port + " after " + totalWait / 1000L + " seconds.", new Object[0]);
            }
            entry = new SocketRepositoryEntry(port, serverSocket, true, user);
            this.socketMap.put(port, entry);
        } else {
            if (entry.isInUse()) {
                throw new IOException("Server socket on port " + port + " is already in use by [" + entry.getUser() + "]");
            }
            entry.setInUse(true);
        }
        return entry.getServerSocket();
    }

    public synchronized void releaseSocket(int port) throws IOException {
        SocketRepositoryEntry entry = this.socketMap.get(port);
        if (entry == null) {
            throw new IOException("Port to close was not found in the Carte socket repository!");
        }
        entry.setInUse(false);
    }

    public Map<Integer, SocketRepositoryEntry> getSocketMap() {
        return this.socketMap;
    }

    public void setSocketMap(Map<Integer, SocketRepositoryEntry> socketMap) {
        this.socketMap = socketMap;
    }

    public synchronized void closeAll() throws IOException {
        for (SocketRepositoryEntry entry : this.socketMap.values()) {
            ServerSocket serverSocket = entry.getServerSocket();
            serverSocket.close();
        }
    }
}

