package com.dickimawbooks.jmakepdfx;

import java.io.*;

public class FetchICCProcessListener implements ProcessListener
{
   public FetchICCProcessListener(Jmakepdfx application)
   {
      this.app = application;
      this.file = null;
      this.errors = null;
   }

   public void setProcess(Process process)
   {
      this.process = process;
   }

   public void processLine(int lineNum, String line)
   {
      if (file == null)
      {
         file = new File(line);
      }
   }

   public void processErrorLine(int lineNum, String line)
   {
      if (errors == null)
      {
         errors = line;
      }
      else
      {
         errors += "\n"+line;
      }
   }

   public void error(Exception e)
   {
      app.error(e);
   }

   public File getFile()
   {
      return file;
   }

   public String getErrors()
   {
      return errors;
   }

   public void terminateProcess()
   {
      if (thread != null)
      {
         Jmakepdfx.debug("Interrupting "+thread);
         thread.interrupt();
      }

      if (process != null)
      {
         Jmakepdfx.debug("Destroying "+process);
         process.destroy();
      }
   }

   public void setThread(Thread thread)
   {
      this.thread = thread;
   }

   public void setInterruptor(InterruptTimerTask interruptor)
   {
      this.interruptor = interruptor;
   }

   public InterruptTimerTask getInterruptor()
   {
      return interruptor;
   }

   private InterruptTimerTask interruptor;
   private Jmakepdfx app;
   private File file;
   private String errors;
   private Process process;
   private Thread thread;
}
