/* 
 *	FIG : Facility for Interactive Generation of figures
 *
 *	Copyright (c) 1988 by Supoj Sutanthavibul (supoj@sally.UTEXAS.EDU)
 *	March 1988.
 *
 *	%W%	%G%
*/
#include <suntool/tool_hs.h>
#include <suntool/expand_name.h>
#include <stdio.h>
#include <errno.h>
#include "func.h"
#include "object.h"

extern char		*getwd();

#define			PROMPT		1
#define			NO_PROMPT	0

extern F_compound	objects, saved_objects, object_tails;
extern Pixwin		*canvas_pixwin;
extern struct cursor	wait_cursor;
extern int		figure_modified;
extern char		current_file[];
extern char		directory[];
extern int		num_object;


char *
do_name_expansion(name)
char *name;
{
	struct namelist	*nl;
	static char	buf[128];

	nl = expand_name(name);
	if (nl == NULL) {
	    put_msg("Error in name expansion");
	    return NULL;
	    }
	if (nl->count == 1) {
	    strcpy(buf, nl->names[0]);
	    free_namelist(nl);
	    return buf;
	    }
	if (nl->count == 0)
	    put_msg("No match");
	else
	    put_msg("Name ambiguous");
	free_namelist(nl);
	return NULL;
	}

edit_file(file)
char	*file;
{
	int		s;
	F_compound	c;

	if (*file == 0) {
	    put_msg("Empty name");
	    return;
	    }
	file = do_name_expansion(file);
	if (file == NULL)
	    return;

	c.arcs = NULL;
	c.compounds = NULL;
	c.ellipses = NULL;
	c.lines = NULL;
	c.splines = NULL;
	c.texts = NULL;
	c.next = NULL;
	set_temp_cursor(&wait_cursor);
	s = read_fig(file, &c);
	if (s == 0) {		/* Successful read */
	    clean_up();
	    (void)strcpy(current_file, file);
	    saved_objects = objects;
	    objects = c;
	    redisplay_canvas();
	    put_msg("Edit \"%s\" %d objects", file, num_object);
	    set_action(F_EDIT);
	    }
	else if (s == ENOENT) {
	    clean_up();
	    saved_objects = objects;
	    objects = c;
	    redisplay_canvas();
	    put_msg("\"%s\" new file", file);
	    (void)strcpy(current_file, file);
	    set_action(F_EDIT);
	    }
	else if (s > 0)
	    read_fail_message(file, s);
	reset_cursor();
	set_frame_label();
	}

read_file(file)
char	*file;
{
	int		s;
	F_compound	c;

	if (*file == 0) {
	    put_msg("Empty name");
	    return;
	    }
	file = do_name_expansion(file);
	if (file == NULL)
	    return;

	c.arcs = NULL;
	c.compounds = NULL;
	c.ellipses = NULL;
	c.lines = NULL;
	c.splines = NULL;
	c.texts = NULL;
	c.next = NULL;
	set_temp_cursor(&wait_cursor);
	s = read_fig(file, &c);
	if (s == 0) {		/* Successful read */
	    clean_up();
	    saved_objects = c;
	    tail(&objects, &object_tails);
	    append_objects(&objects, &saved_objects, &object_tails);
	    pw_batch_on(canvas_pixwin);
	    redisplay_canvas();
	    pw_batch_off(canvas_pixwin);
	    put_msg("File \"%s\" %d objects", file, num_object);
	    set_action_object(F_CREATE, O_ALL_OBJECT);
	    }
	else if (s > 0)
	    read_fail_message(file, s);
	reset_cursor();
	}

save_and_exit(file)
char	*file;
{
	file = do_name_expansion(file);
	if (file == NULL)
	    return 1;
	if (0 == write_file(file, PROMPT, &objects))
	    quit();
	return 1;
	}

save_current_file()
{
	return(write_file(current_file, NO_PROMPT, &objects));
	}

save_file(file)
char	*file;
{
	int		rc;

	file = do_name_expansion(file);
	if (file == NULL)
	    return 1;
	rc = write_file(file, PROMPT, &objects);
	return rc;
	}

status()
{
	if (*directory == NULL) {
	    if (NULL == getwd(directory)) {
		put_msg("%s", directory);	/* err msg is in directory */
		*directory = '\0';
		return;
		}
	    }

	if (*current_file == '\0')
	    put_msg("No file; directory \"%s\"", directory);
	else
	    put_msg("file \"%s\" %s; directory \"%s\"", current_file,
			(figure_modified ? "[modified]" : ""), directory);
	}
