/* 
 *	FIG : Facility for Interactive Generation of figures
 *
 *	Copyright (c) 1985 by Supoj Sutanthavibul (supoj@sally.UTEXAS.EDU)
 *	January 1985.
 *	1st revision : Aug 1985.
 *
 *	%W%	%G%
*/
#include <stdio.h>
#include <suntool/tool_hs.h>
#include "const.h"
#include "func.h"

extern	double		ceil(), floor();

#define			INV_PAINT_OP	PIX_SRC ^ PIX_DST

extern struct pixwin	*canvas_pixwin;
extern int		zoom_factor;

static struct pixrect	*h_grid_pr,
			*v_grid1_pr, *v_grid2_pr, *v_grid3_pr, *v_grid4_pr;
static int		cur_grid = -1;

init_grid()
{
	int	x, y;

	h_grid_pr =  mem_create(CANVS_WIDTH+5, 1, 1);
	v_grid1_pr = mem_create(1, CANVS_HEIGHT+5*32, 1);
	v_grid2_pr = mem_create(1, CANVS_HEIGHT+5*32, 1);
	v_grid3_pr = mem_create(1, CANVS_HEIGHT+5*32, 1);
	v_grid4_pr = mem_create(1, CANVS_HEIGHT+5*32, 1);
	for (x = 0; x < CANVS_WIDTH+5; x +=5)
	    pr_put(h_grid_pr, x, 0, 1);
	for (x = 1, y = 4; y <= CANVS_HEIGHT+5*32; x++, y +=5) {
	    if (x % 4)
		pr_put(v_grid1_pr, 0, y, 1);
	    if (x % 8)
		pr_put(v_grid2_pr, 0, y, 1);
	    if (x % 16)
		pr_put(v_grid3_pr, 0, y, 1);
	    if (x % 32)
		pr_put(v_grid4_pr, 0, y, 1);
	    }
	}

setup_grid(grid)
int	grid;
{
	if (cur_grid == grid) {
	    cur_grid = -1;
	    }
	else {
	    if (grid == F_GRID1)
		put_msg("Quarter inch GRID");
	    else
		put_msg("Half inch GRID");
	    if (cur_grid != -1) {
		draw_grid(cur_grid);
		}
	    cur_grid = grid;
	    }
	draw_grid(grid);
	}


draw_grid(grid)
int	grid;
{
	int 		i, j, x, y, resolution;
	struct pixrect	*v_grid_pr;

	if (grid == F_GRID1) {
	    if (zoom_factor == 1)
		v_grid_pr = v_grid1_pr;
	    else if (zoom_factor == 2)
		v_grid_pr = v_grid2_pr;
	    else
		v_grid_pr = v_grid3_pr;
	    resolution = PIX_PER_INCH / 4;
	    }
	else {
	    if (zoom_factor == 1)
		v_grid_pr = v_grid2_pr;
	    else if (zoom_factor == 2)
		v_grid_pr = v_grid3_pr;
	    else
		v_grid_pr = v_grid4_pr;
	    resolution = PIX_PER_INCH / 2;
	    }

	/*  vertical grid  */
	i = (int) ceil((double)unzoomed_x(0) / (double)resolution);
	x = zoomed_x(resolution*i-1);
	j = (int) floor((double)unzoomed_y(0) / (double)resolution);
	y = zoomed_y(resolution*j-1);
	while (x < CANVS_WIDTH) {
	    pw_write(canvas_pixwin, x, y+1, 1, CANVS_HEIGHT-(y+1), INV_PAINT_OP, 
			v_grid_pr, 0, 0);
	    i++;
	    x = zoomed_x(resolution*i-1);
	    }

	/*  horizontal grid  */
	i = (int) ceil((double)unzoomed_x(0) / 5.0);
	x = zoomed_x(5*i-1) % 5;
	j = (int) ceil((double)unzoomed_y(0) / (double)resolution);
	y = zoomed_y(resolution*j-1);
	while (y < CANVS_HEIGHT) {
	    pw_write(canvas_pixwin, x, y, CANVS_WIDTH-x, 1, INV_PAINT_OP, 
			h_grid_pr, 0, 0);
	    j++;
	    y = zoomed_y(resolution*j-1);
	    }
	}

redisplay_grid()
{
	if (cur_grid == -1) return;
	draw_grid(cur_grid);
	}
