
import three;
import x11colors;

settings.render=0;
settings.prc=false; 

import Header;
unitsize(x=1.00cm);

//triple cam=(1000,-200,250);
//currentprojection=perspective(cam); //Far away!

triple vp = unit((1.0, 0.3, 0.5));
vp = unit((2.0, 0.3, 0.95));
currentprojection=orthographic(vp.x, vp.y, vp.z);

thinpen;
currentpen += roundcap;
currentpen += roundjoin;

pen col1 = white;
pen col2 = paleblue;

real r  = 5.0;
real rc = 0.75*r;

transform3 Rr1 =  rotate(40, Z);
transform3 Rr2 =  rotate(20, Rr1*X)*Rr1;
transform3 Rr3 =  rotate(20, Rr2*Z)*Rr2;

triple X1 = Rr1*X, Y1 = Rr1*Y, Z1 = Rr1*Z;
triple X2 = Rr2*X, Y2 = Rr2*Y, Z2 = Rr2*Z;
triple X3 = Rr3*X, Y3 = Rr3*Y, Z3 = Rr3*Z;

path3 C1  =  circle(O, rc, Z);
path3 C2a =  arc(O, -rc*X1,  rc*X1, Z2);
path3 C2b =  arc(O,  rc*X1, -rc*X1, Z2);

draw(surface(C2a--cycle), surfacepen=col1, light=nolight);
draw(C2a,thinpen);

draw(surface(C1), surfacepen=col2, light=nolight);
draw(C1--cycle,thinpen);

real ra = 1.0*r;
real dr = 0.03*r;
real Dr = 0.20*r;

draw(Label("$s_1$",1,W), O--ra*X,  thinpen);
draw(Label("$s_2$",1),   O--ra*Y,  thinpen);
draw(Label("$\xi_2$",1), O--ra*Y1, thinpen);

draw(surface(C2b--cycle), surfacepen=col1, light=nolight);
draw(C2b,thinpen);

draw(Label("$\eta_2$",1), O--ra*Y2, thinpen);
draw(Label("$r_1$",1),    O--ra*X3, thinpen);
draw(Label("$r_2$",1),    O--ra*Y3, thinpen);


draw(O--ra*X1, thinpen);
label("$\xi_1$",  ra*X1, rotate(-90, vp)*X1);
label("$\eta_1$",ra*X1, rotate( 90, vp)*X1);

draw(Label("$\dot{\theta}\,\bS{e}^\xi_{1}$",1), (ra+dr)*X1--(ra+dr+Dr)*X1, uvecpen, Arrow3(HookHead3, size=Asize));

ra = 0.8*r;

draw(O--ra*Z, thinpen);
label("$s_3$",  ra*Z, rotate( 90, vp)*Z);
label("$\xi_3$",ra*Z, rotate(-90, vp)*Z);

draw(Label("$\dot{\phi}\,\bS{e}^s_{3}$",1), (ra+dr)*Z--(ra+dr+Dr)*Z, uvecpen, Arrow3(HookHead3, size=Asize));

draw(O--ra*Z3, thinpen);
label("$\eta_3$",ra*Z3, rotate( 90, vp)*Z3);
label("$r_3$",    ra*Z3, rotate(-90, vp)*Z3);

draw(Label("$\dot{\psi}\,\bS{e}^\eta_{3}$",1), (ra+dr)*Z3--(ra+dr+Dr)*Z3, uvecpen, Arrow3(HookHead3, size=Asize));

real ro = 1.25*rc;
real ri = 0.80*rc;

draw(Label("$\phi$", align=O,Fill(1, col2)), arc(O, ri*X,  ri*X1), thinpen, Arrow3(HookHead3, size=Asize));
draw(Label("$\phi$", align=O,UnFill(1)), arc(O, ro*Y,  ro*Y1), thinpen, Arrow3(HookHead3, size=Asize));

draw(Label("$\theta$",  align=O,UnFill(1)), arc(O, ro*Y1, ro*Y2), thinpen, Arrow3(HookHead3, size=Asize));
draw(Label("$\theta$",  align=O,UnFill(1)), arc(O, ri*Z1, ri*Z2), thinpen, Arrow3(HookHead3, size=Asize));

draw(Label("$\psi$",    align=O,Fill(1,col1)), arc(O, ri*X2, ri*X3), thinpen, Arrow3(HookHead3, size=Asize));
draw(Label("$\psi$",    align=O,UnFill(1)),      arc(O, ro*Y2, ro*Y3), thinpen, Arrow3(HookHead3, size=Asize));

