/*
	rtfdiag - read rtf input, write diagnostic stuff.  Useful for
		testing reader to see if it's finding and classifying
		tokens properly, reading destinations, reprocessing
		styles, etc.

	Options:

	-e	echo tokens as they are read

	03 Feb 91	Paul DuBois	dubois@primate.wisc.edu

	03 Feb 91 V1.0. Created.
	27 Feb 91 V1.01. Updated for distribution 1.05.
*/

# include	<stdio.h>
# include	"rtf.h"


static void	Diag ();
static void	TokenEcho ();
static void	PrintTables ();


static int	echo = 0;
static char	*usage = "rtfdiag [-e] [file]";


int main (argc, argv)
int	argc;
char	**argv;
{
int	i;

	--argc;
	++argv;

	while (argc > 0 && **argv == '-')
	{
		while (*++*argv != '\0')
		{
			switch (**argv)
			{
			case 'e':
				echo = 1;
				break;
			default:
				fprintf (stderr, "Unknown option: -%c\n",
							**argv);
				fprintf (stderr, "%s\n", usage);
				exit (1);
			}
		}
		--argc;
		++argv;
	}

	if (argc == 0)
		Diag ();
	else for (i = 0; i < argc; i++)
	{
		if (freopen (argv[i], "r", stdin) == NULL)
		{
			fprintf (stderr, "Can't open \"%s\"\n",
							argv[i]);
			continue;
		}
		if (argc > 1)
		{
		int	j, len = strlen (argv[i]);

			for (j = 0; j < len; j++)
				putchar (':');
			putchar ('\n');
			printf ("%s\n", argv[i]);
			for (j = 0; j < len; j++)
				putchar (':');
			putchar ('\n');
		}
		Diag ();
	}

	exit (0);
}


static void Diag ()
{
	RTFInit ();
	if (echo)
		RTFSetReadHook (TokenEcho);
	RTFRead ();
	PrintTables ();
}


static void TokenEcho ()
{
	printf ("%d\t%d\t%d\t%d\t\"%s\"\n",
			rtfClass, rtfMajor, rtfMinor, rtfParam, rtfTextBuf);
}


static void PrintTables ()
{
RTFColor	*cp;
RTFFont		*fp;
RTFStyle	*sp;
RTFStyleElt	*sep;
int	count;

	printf ("Font table:\n");
	count = 0;
	for (fp = RTFGetFont (-1); fp != NULL; fp = fp->rtfNextFont)
	{
		++count;
		printf ("%2d:\t%s\t%d\n", fp->rtfFNum, fp->rtfFName,
			fp->rtfFFamily);
	}
	printf ("Font table entries:\t%d\n\n", count);

	printf ("Color table:\n\tred\tgreen\tblue\n");
	count = 0;
	for (cp = RTFGetColor (-1); cp != NULL; cp = cp->rtfNextColor)
	{
		++count;
		printf ("%2d:\t%d\t%d\t%d\n", cp->rtfCNum, cp->rtfCRed,
			cp->rtfCGreen, cp->rtfCBlue);
	}
	printf ("Color table entries:\t%d\n\n", count);

	printf ("Stylesheet:\n");
	count = 0;
	for (sp = RTFGetStyle (-1); sp != NULL; sp = sp->rtfNextStyle)
	{
		++count;
		printf ("%2d:\t%s\t%d\t%d\n", sp->rtfSNum, sp->rtfSName,
				sp->rtfSBasedOn, sp->rtfSNextPar);
		for (sep = sp->rtfSSEList; sep != NULL; sep = sep->rtfNextSE)
			printf ("\t%s\n", sep->rtfSEText);
	}
	printf ("Style table entries:\t%d\n\n", count);
}
