---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, équations, 
              disposition d'équations, système d'équations, délimiteurs
---

# Comment mettre en page un système d'équations ?

## Avec des commandes de base

Pour cela, vous pouvez utiliser les commandes `\left` et `\right` 
qui permettent d'obtenir des 
[délimiteurs extensibles](/4_domaines_specialises/mathematiques/structures/delimiteurs/ajuster_la_taille_des_delimiteurs) 
et de les positionner autour d'un tableau, comme ici :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\[  
  \left \{
  \begin{array}{c @{=} c}
    x & \sin a \cos b \\
    y & \sin a \sin b
  \end{array}
  \right.
\]
\end{document}
```


## Avec l'extension <ctanpkg:mathtools>

L'extension <ctanpkg:mathtools>  (ou <ctanpkg:amsmath>) permet de placer 
des choix conditionnels, comme pour cet exemple :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

\begin{document}
\begin{equation*}
  \|x\|=
     \begin{cases}
        -x & \text{si } x < 0 \\
        x  & \text{si } x \geq 0
     \end{cases}
\end{equation*}
\end{document}
```


## Avec l’extension <ctanpkg:systeme>

L’extension <ctanpkg:systeme> permet de mettre en forme des systèmes 
d’équations ou d’inéquations où les termes et les signes sont alignés 
verticalement, tout en permettant une saisie quasi naturelle. 

Cette extension fonctionne avec Plain TeX et LaTeX. 

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{systeme}

\begin{document}
Résoudre \systeme{2a-3b+4c=2,
  a+8b+5c=8,
  -a+2b+c=-5}
\end{document}
```

Cette extension propose de nombreux outils, en particulier, la possibilité 
de rajouter une colonne, permettant par exemple de commenter les opérations
réalisées. 

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{systeme}

\begin{document}
\systeme{x+y-z=3@L_{*}\quad,
  2x+y+z=4,
  x-y+2z=0}
\systeme{x+y-z=3@L'_{*},
  3x+2y=7@=L_1+L_2,
  3x+y=6@=2L_1+L_3}
\end{document}
```


## Avec l'extension <ctanpkg:delarray>

L'extension <ctanpkg:delarray> peut également être utilisée dans ce but 
car elle permet d'indiquer les délimiteurs entourant un tableau 
directement au niveau de la déclaration du format des colonnes. 
Dans l'exemple, ces délimiteurs sont respectivement "`\{`" (accolade ouvrante)
et "`.`" (absence de délimiteur), à l'image de ce qu'il aurait fallu passer
comme argument aux commandes `\left` et `\right` (pour avoir des 
[délimiteurs extensibles](/4_domaines_specialises/mathematiques/structures/delimiteurs/ajuster_la_taille_des_delimiteurs)).

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{delarray}

\begin{document}
\[  
  \|x\| =
  \begin{array}\{ {cc}.
   -x & \textrm{si } x < 0 \\
    x & \textrm{si } x \geq 0
  \end{array}
\]
\end{document}
```


## Avec l'extension <ctanpkg:envmath>

L'extension <ctanpkg:envmath> permet de numéroter le système ou chaque équation
du système, le compteur pouvant alors être personnalisé. 
L'aspect esthétique n'est toutefois pas très bon dans certains cas.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{envmath}

\begin{document}
% Numérotation du système
\begin{System}
  2x + y = 6 \\
  3x + y = 7
\end{System}

% Numérotation de chaque équation du système
\begin{EqSystem}
  2x + y = 6 \\
  3x + y = 7
\end{EqSystem}
\end{document}
```


## Avec l'extension <ctanpkg:cases>

L'extension <ctanpkg:cases> gère les systèmes d'équations. Voici un exemple :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{cases}

\begin{document}
\begin{numcases}{\|x\|=}
  -x, & si $x < 0$ \\
   x, & si $x \geq 0$
\end{numcases}
\end{document}
```

Le fichier `xtdeqnra.sty`, disponible [ici](/_static/old_extensions/xtdeqnra.sty), 
est une adaptation de cette extension par Jérôme Laurens.