/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.cos;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.ICOSVisitor;
import org.apache.pdfbox.exceptions.COSVisitorException;

public class COSInteger
extends COSNumber {
    private static int LOW = -100;
    private static int HIGH = 256;
    private static final COSInteger[] STATIC = new COSInteger[HIGH - LOW + 1];
    public static final COSInteger ZERO = COSInteger.get(0L);
    public static final COSInteger ONE = COSInteger.get(1L);
    public static final COSInteger TWO = COSInteger.get(2L);
    public static final COSInteger THREE = COSInteger.get(3L);
    private long value;

    public static COSInteger get(long val) {
        if ((long)LOW <= val && val <= (long)HIGH) {
            int index = (int)val - LOW;
            if (STATIC[index] == null) {
                COSInteger.STATIC[index] = new COSInteger(val);
            }
            return STATIC[index];
        }
        return new COSInteger(val);
    }

    public COSInteger(long val) {
        this.value = val;
    }

    public COSInteger(int val) {
        this((long)val);
    }

    public COSInteger(String val) throws IOException {
        try {
            this.value = Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            throw new IOException("Error: value is not an integer type actual='" + val + "'");
        }
    }

    public boolean equals(Object o) {
        return o instanceof COSInteger && ((COSInteger)o).intValue() == this.intValue();
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >> 32);
    }

    public String toString() {
        return "COSInt{" + this.value + "}";
    }

    public void setValue(long newValue) {
        this.value = newValue;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public Object accept(ICOSVisitor visitor) throws COSVisitorException {
        return visitor.visitFromInt(this);
    }

    public void writePDF(OutputStream output) throws IOException {
        output.write(String.valueOf(this.value).getBytes("ISO-8859-1"));
    }
}

