---
myst:
  html_meta:
    keywords: LaTeX,extensions obsolètes,packages obsolètes,LaTeX tabou,quoi ne pas faire en LaTeX,packages historiques,LaTeX en 2023"
---
# Quelles extensions sont considérées comme obsolètes ? Par quoi les remplacer ?

Le tableau ci-dessous recense les extensions qui ont été fréquemment utilisées à une époque, mais ne sont plus recommandées.

Lorsque vous lisez une documentation, regardez bien sa date de mise à jour : le monde LaTeX évolue et les conseils d'il y a 20 ou 30 ans ne sont plus forcément pertinents.

## Contrôle de votre code

L'extension <ctanpkg:nag> passe votre code en revue et détecte l'utilisation de
commandes LaTeX obsolètes, sur la base des recommandations de <ctanpkg:l2tabu>
([traduction en français également disponible](ctanpkg:l2tabu-french), la
version de référence étant la version allemande).

## Liste des extensions considérées comme obsolètes

```{tabularcolumns} >{\RaggedRight}\X{227}{885}>{\RaggedRight}\X{220}{885}\X{438}{885}
```


| Extensions obsolètes                                | Extensions recommandées                                 | Commentaires                                                                                                                       |
|:----------------------------------------------------|:--------------------------------------------------------|:-----------------------------------------------------------------------------------------------------------------------------------|
| <ctanpkg:a4>, <ctanpkg:a4wide>, <ctanpkg:anysize>   | <ctanpkg:geometry>, <ctanpkg:typearea>                  |                                                                                                                                    |
| atxy                                                | <ctanpkg:textpos>                                       | Voir détails ci-dessous.                                                                                                           |
| <ctanpkg:backrefx>                                  | <ctanpkg:backref>                                       |                                                                                                                                    |
| <ctanpkg:bitfield>                                  | <ctanpkg:bytefield>                                     |                                                                                                                                    |
| <ctanpkg:catmac>{sup}`lien obsolète`                | <ctanpkg:amscd>                                         | Voir détails ci-dessous.                                                                                                           |
| <ctanpkg:caption2>                                  | <ctanpkg:caption>                                       |                                                                                                                                    |
| <ctanpkg:cd>                                        | <ctanpkg:amscd>                                         | Voir détails ci-dessous.                                                                                                           |
| <ctanpkg:chngpage>                                  | <ctanpkg:changepage>                                    |                                                                                                                                    |
| <ctanpkg:cprog>                                     | <ctanpkg:listings>, <ctanpkg:lgrind>                    |                                                                                                                                    |
| <ctanpkg:csvtools>                                  | <ctanpkg:datatool>                                      |                                                                                                                                    |
| <ctanpkg:datetime>                                  | <ctanpkg:datetime2>                                     |                                                                                                                                    |
| <ctanpkg:dinat>                                     | <ctanpkg:natdin>{sup}`lien obsolète`                    |                                                                                                                                    |
| <ctanpkg:doublespace>                               | <ctanpkg:setspace>                                      |                                                                                                                                    |
| <ctanpkg:dropcaps>                                  | <ctanpkg:lettrine>                                      |                                                                                                                                    |
| <ctanpkg:dropping>                                  | <ctanpkg:lettrine>                                      |                                                                                                                                    |
| <ctanpkg:dvipsk>                                    | <ctanpkg:dvips>                                         |                                                                                                                                    |
| <ctanpkg:eclbkbox>{sup}`lien obsolète`              | <ctanpkg:boites>                                        | Voir détails ci-dessous.                                                                                                           |
| <ctanpkg:eledmac>                                   | <ctanpkg:reledmac>                                      |                                                                                                                                    |
| <ctanpkg:eledpar>                                   | <ctanpkg:reledpar>                                      |                                                                                                                                    |
| <ctanpkg:epsfig>                                    | <ctanpkg:graphicx>                                      |                                                                                                                                    |
| <ctanpkg:euler>                                     | <ctanpkg:eulervm>                                       |                                                                                                                                    |
| <ctanpkg:eurotex>                                   | <ctanpkg:inputenx>                                      |                                                                                                                                    |
| <ctanpkg:everysel>                                  | <ctanpkg:l3kernel>                                      | La [documentation du package](texdoc:everysel) explique pourquoi il est considéré comme obsolète par son auteur.                   |
| <ctanpkg:exsheets>                                  | <ctanpkg:xsim>                                          | Même auteur, qui indique [dans la documentation de xsim](texdoc:xsim) que `exsheets` ne recevra plus de nouvelles fonctionnalités. |
| <ctanpkg:fancyheadings>                             | <ctanpkg:fancyhdr>                                      |                                                                                                                                    |
| <ctanpkg:FiNK>                                      | <ctanpkg:currfile>                                      |                                                                                                                                    |
| <ctanpkg:fixltx2e>                                  |                                                         | Fonctionnalités désormais intégrées au noyau.                                                                                      |
| <ctanpkg:floatfig>                                  | <ctanpkg:floatflt>                                      | Voir détails ci-dessous.                                                                                                           |
| <ctanpkg:german>                                    | <ctanpkg:babel>                                         |                                                                                                                                    |
| <ctanpkg:glossary>                                  | <ctanpkg:glossaries>                                    |                                                                                                                                    |
| <ctanpkg:graphics>                                  | <ctanpkg:graphicx>                                      |                                                                                                                                    |
| <ctanpkg:ha-prosper>                                | <ctanpkg:powerdot>, <ctanpkg:beamer>                    |                                                                                                                                    |
| <ctanpkg:here>                                      | <ctanpkg:float>                                         |                                                                                                                                    |
| <ctanpkg:includex>                                  | <ctanpkg:newclude>                                      |                                                                                                                                    |
| <ctanpkg:isolatin1>                                 | <ctanpkg:inputenc>                                      |                                                                                                                                    |
| <ctanpkg:ledmac>                                    | <ctanpkg:reledmac>                                      |                                                                                                                                    |
| <ctanpkg:ledpar>                                    | <ctanpkg:reledpar>                                      |                                                                                                                                    |
| <ctanpkg:mathpple>                                  | <ctanpkg:mathpazo>                                      |                                                                                                                                    |
| <ctanpkg:mathptm>                                   | <ctanpkg:mathptmx>                                      |                                                                                                                                    |
| <ctanpkg:movie15>                                   | <ctanpkg:media9>                                        |                                                                                                                                    |
| <ctanpkg:mtex> (ou MuTeX)                           | <ctanpkg:MusiXTeX>                                      |                                                                                                                                    |
| <ctanpkg:MusicTeX>                                  | <ctanpkg:MusiXTeX>                                      | <ctanpkg:MusicTeX> semble cependant permettre la conversion de fichier midi.                                                       |
| <ctanpkg:multind>                                   | <ctanpkg:imakeidx>                                      |                                                                                                                                    |
| <ctanpkg:ngerman>                                   | <ctanpkg:babel>                                         |                                                                                                                                    |
| <ctanpkg:newthm>                                    | <ctanpkg:ntheorem>                                      |                                                                                                                                    |
| <ctanpkg:nicefrac>                                  | <ctanpkg:xfrac>                                         |                                                                                                                                    |
| <ctanpkg:numline>                                   | <ctanpkg:lineno>                                        |                                                                                                                                    |
| <ctanpkg:ocg-p>, <ctanpkg:ocgx> & <ctanpkg:fixocgx> | <ctanpkg:ocgx2>                                         |                                                                                                                                    |
| <ctanpkg:palatino>{sup}`lien obsolète`              | <ctanpkg:mathpazo>                                      |                                                                                                                                    |
| <ctanpkg:picinpar>                                  | <ctanpkg:floatflt>, <ctanpkg:picins>, <ctanpkg:wrapfig> |                                                                                                                                    |
| <ctanpkg:prosper>                                   | <ctanpkg:powerdot>, <ctanpkg:beamer>                    |                                                                                                                                    |
| <ctanpkg:ps4pdf>                                    | <ctanpkg:pst-pdf>                                       |                                                                                                                                    |
| <ctanpkg:raggedr>                                   | <ctanpkg:ragged2e>                                      |                                                                                                                                    |
| <ctanpkg:remreset>                                  |                                                         | Fonctionnalités désormais intégrées au noyau.                                                                                      |
| <ctanpkg:scrlettr>{sup}`lien obsolète`              | <ctanpkg:scrlttr2>                                      |                                                                                                                                    |
| <ctanpkg:scrpage>{sup}`lien obsolète`               | <ctanpkg:scrpage2>                                      |                                                                                                                                    |
| <ctanpkg:seminar>                                   | <ctanpkg:powerdot>, <ctanpkg:beamer>                    |                                                                                                                                    |
| <ctanpkg:SIunits>, <ctanpkg:si>                     | <ctanpkg:siunitx>                                       |                                                                                                                                    |
| <ctanpkg:slashbox>                                  | <ctanpkg:diagbox>                                       |                                                                                                                                    |
| <ctanpkg:stix>                                      | <ctanpkg:stix2-otf>, <ctanpkg:stix2-type1>              | Depuis avril 2018.                                                                                                                 |
| <ctanpkg:subfigure>                                 | <ctanpkg:subfig>, <ctanpkg:subcaption>                  |                                                                                                                                    |
| <ctanpkg:tetex>                                     | TeX Live                                                | teTeX, qui est une [distribution](/1_generalites/glossaire/distribution), est obsolète depuis 2007.                                |
| <ctanpkg:textcomp>                                  |                                                         | Fonctionnalités désormais intégrées au noyau.                                                                                      |
| <ctanpkg:t1enc>                                     | <ctanpkg:fontenc>                                       |                                                                                                                                    |
| <ctanpkg:times>                                     | <ctanpkg:mathptmx>                                      |                                                                                                                                    |
| <ctanpkg:tgrind>                                    | <ctanpkg:lgrind>                                        |                                                                                                                                    |
| <ctanpkg:theorem>                                   | <ctanpkg:amsthm>, <ctanpkg:ntheorem>                    |                                                                                                                                    |
| <ctanpkg:thmmarks>{sup}`lien obsolète`              | <ctanpkg:ntheorem>                                      |                                                                                                                                    |
| <ctanpkg:utopia>                                    | <ctanpkg:fourier>                                       |                                                                                                                                    |
| vgrind                                              | <ctanpkg:lgrind>                                        |                                                                                                                                    |
| <ctanpkg:vmargin>                                   | <ctanpkg:geometry>, <ctanpkg:typearea>                  |                                                                                                                                    |

:::{todo}
Cette page a des liens obsolètes.
:::

