---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, équations, 
              structures, indices, écrire sous une flèche, 
              indice sous une flèche, indice sous une relation, 
              écrire sous un symbole
---

# Comment écrire au-dessous d'un symbole ou d'une flèche ?

## Avec l'extension <ctanpkg:mathtools>

L'extension <ctanpkg:mathtools> (ou <ctanpkg:amsmath>) dispose de la commande 
`\underset` permettant de placer des "indices centrés".

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

\begin{document}
\[  \underset{a}{X} = \sum_{k=a}^{\infty} X^k  \]
\end{document}
```

Ce principe se généralise avec la commande `\overunderset` qui permet de placer
un exposant au-dessus du symbole et un indice au-dessous le symbole.

L'extension fournit également avec des commandes dédiées un moyen de placer
des éléments au-dessous d'une flèche extensible. Ce sujet est évoqué 
à la question 
"[](/4_domaines_specialises/mathematiques/symboles/fleches/ajuster_la_longueur_d_une_fleche_par_rapport_a_un_texte)".


:::{sources}
- [Indices et exposants en folie](https://www.elzevir.fr/imj/latex/tips.html#indices), 
  par Manuel Pégourié-Gonnard
:::