---
myst:
  html_meta:
    keywords: LaTeX, éditeur de texte, éditeur de code LaTeX, éditeurs spécialisés pour LaTeX, 
              éditeur avec prévisualisation
---
# Quels sont les éditeurs utilisables sous Linux ?

## Éditeurs généralistes

### (X)Emacs

[GNU emacs](http://www.gnu.org/software/emacs/emacs.html) et 
[XEmacs](http://www.xemacs.org/) sont des éditeurs sous Unix/Linux qui offrent 
en standard un mode d'édition, un peu fruste mais néanmoins pratique, 
facilitant la composition de documents LaTeX. Une extension à `Emacs`, 
[AUCTeX](ctanpkg:auctex) (utilisez plutôt le gestionnaire d'extension d'Emacs 
que le CTAN pour l'installer), fournit de nombreuses facilités supplémentaires 
(indentation automatique, messages d'erreur en anglais compréhensible, 
gestion des documents multifichiers... et même un mode de prévisualisation)

`Emacs` reconnaît automatiquement certaines extensions de noms de fichiers 
(TEX, STY) et active le mode en question automatiquement. 
Si votre fichier n'est pas reconnu comme un document LaTeX, vous pouvez spécifier
sur la première ligne de votre fichier :

```{noedit}
% -*-latex-*-
```

L'extension (standard) `imenu` donne accès à un menu listant les en-têtes 
de section du document, et permet de retrouver celles-ci facilement 
dans un grand document. Une extension à ce mécanisme permet de mieux visualiser 
la structure du document, en indentant les sous-sections.


### Jed

`LaTeX4Jed` offre une prise en charge améliorée de LaTeX pour l'éditeur 
[jed](http://www.jedsoft.org/jed/). `LaTeX4Jed` est similaire à 
[AUCTeX](ctanpkg:auctex) : menus, raccourcis, modèles, coloration syntaxique, 
plan de document, débogage intégré, complétion de symboles, intégration complète 
avec des programmes externes, etc. Il a été conçu à la fois pour les utilisateurs 
débutants et avancés de LaTeX.


### NEdit

[NEdit](https://sourceforge.net/projects/nedit/) (*The Nirvana Text Editor*) 
et son *fork* [NEdit-NG](https://github.com/eteran/nedit-ng) sont des éditeurs 
entièrement conçus pour [X Window](wpfr:X_Window_System) dès le début. Notez que 
leurs sites web ne proposent pas de binaires à jour, mais qu'ils encouragent 
les mainteneurs de distributions Linux à fournir des extensions à partir 
des sources (dernière mise à jour de 2017 pour NEdit et 2021 pour NEdit-NG).

Il offre un aspect semblable aux éditeurs que l'on trouve sur Windows et macOS, 
par exemple, les raccourcis standards sont Ctrl+X pour couper, Ctrl+C pour copier, 
Ctrl+V pour coller. Ainsi, les nouveaux utilisateurs venant des autres 
systèmes d'exploitation n'auront aucun mal à s'adapter à `NEdit`. C'est un éditeur 
très configurable, notamment la police de caractères, les couleurs (enfin, 
parfois il faut être un peu bidouilleur aussi). C'est un éditeur à usage général. 
Il n'est pas seulement utile pour LaTeX.

Si ses fonctionnalités de bases ne vous suffisent pas pour LaTeX, il existe 
[une extension pour NEdit sur le CTAN](ctanpkg:NEdit-LaTeX-Extensions).


### ViM

[ViM](https://www.vim.org/), développé par Bram Moolenaar et disponible également 
pour Windows et macOS, dispose de la coloration syntaxique, à l'instar d'Emacs ; 
c'est un éditeur très peu gourmand en ressources. Il dispose d'un mode spécial 
LaTeX qui facilite la saisie des textes : <https://vim-latex.sourceforge.net/>.


### Xcoral

[Xcoral](http://xcoral.free.fr/), sous Unix, offre des fonctionnalités 
de même type que Emacs mais non interactives. Il est toujours maintenu en 2020.

`Xcoral` est un éditeur multifenêtres pour X Window, offrant un certain nombre 
de facilités notamment pour écrire des programmes `perl`, `ada`, `fortran`, `C`, 
`C++`, `java` ainsi que des documents LaTeX ou `HTML`.

Cet éditeur comprend un interpréteur `Ansi C` intégré qui permet aux utilisateurs 
d'étendre ses fonctionnalités facilement. Un manuel d'aide complet indexé 
est disponible en ligne.


### VSCode (Visual Studio Code)

[VSCode](https://code.visualstudio.com) est un éditeur de code extensible 
développé par Microsoft pour Windows, Linux et macOS. Il est généraliste, moderne, 
prends en charge le débogage, la coloration syntaxique, la complétion intelligente 
du code, les snippets, et Git. 
Le code source de Visual Studio Code provient du projet logiciel libre 
et open source VS Code de Microsoft publié sous la licence MIT permissive, 
mais les binaires compilés constituent un freeware, c'est-à-dire un logiciel gratuit 
pour toute utilisation mais propriétaire.

Pour l’utiliser pour LaTeX, il faudra installer l’extension 
[LaTeX Workshop](https://marketplace.visualstudio.com/items?itemName=James-Yu.latex-workshop). 


## Éditeurs spécialisés pour LaTeX

### Gummi

[Gummi](https://gummi.app/) est un éditeur *open-source* simple, 
et développé spécialement pour LaTeX. 
Parmi ses [nombreuses fonctionnalités](wpfr:Gummi_(logiciel)), il permet de prévisualiser 
le document en cours de rédaction. Il est encore développé en 2020.


### Kile

[Kile](https://kile.sourceforge.io/) est fourni avec le gestionnaire de fenêtres 
de KDE. Des informations (et des fichiers téléchargeables) sont disponibles 
sur la [page SourceForge](https://kile.sourceforge.io/) du projet.


### Texmaker

[Texmaker](https://www.xm1math.net/texmaker/) (multiplateforme).


### TeXstudio

[TeXstudio](https://texstudio.sourceforge.net/)


### TeXworks

Le [TUG](/1_generalites/documentation/listes_de_discussion/groupes_d_utilisateurs)
parraine le développement d'un éditeur et d'un shell multiplateformes, 
inspirés de l'excellent TeXshop pour Macintosh. Le résultat, 
[TeXworks](https://tug.org/texworks/), est recommandé si vous cherchez
un environnement de développement LaTeX. Il est distribué avec `TeX Live` et `MiKTeX`.


## Traitements de texte WYSIWYG

[LyX](https://www.lyx.org/) est un véritable traitement de texte sous X11 
qui offre une sortie LaTeX. Il est presque [WYSIWYG](/1_generalites/bases/wysiwyg). 
Parmi ses fonctionnalités, on trouve :

- éditeur d'équations ;
- éditeur de tables ;
- inclusion d'images au format `EPS` ;
- correction orthographique...

En revanche, il est peu apprécié des utilisateurs avancés de LaTeX, 
car il s'occupe lui-même de générer le code LaTeX, alors que vous saisissez 
votre document dans une interface de type traitement de texte. Le code est ensuite
difficile à retravailler à la main.

Si vous avez besoin d'aide avec `LyX`, regardez plutôt du côté 
des [listes de discussion spécifiques](https://www.lyx.org/MailingLists) 
plutôt que des listes orientées LaTeX.


## Quelques éditeurs obsolètes

On trouve sur le web la trace de nombreuses initiatives pour développer 
l'éditeur idéal : le plus léger, le plus configurable, le plus complet, 
le plus ergonomique...

Voici quelques noms de projets :

- `Funtek`, de V. Vidal, sous X Window et Motif ;
- `TeXShell` pour X Window (Tcl/Tk) ;
- `STEAD` (*Sympathetic Tk-based Editor for Average Dummies*), de Maurice Diamantini,
  est un éditeur de texte convivial pour Unix (ressemblant à `Alpha` sur macOS), 
  entièrement interprété, écrit en [Tcl/Tk](wpfr:Tool_Command_Language). 
  Il a conservé une [page d'accueil](https://perso.ensta-paris.fr/~diam/stead/).


:::{sources}
- [9 best LaTeX editors for Linux](https://itsfoss.com/latex-editors-linux/).
- [TeX-friendly editors and shells](faquk:FAQ-editors)
:::
