# class Array
    # def flags
        # self.join(' ')
    # end
# end

$machine = ENV['MACHINE'] || ENV['USERDOMAIN'] || 'pragma-pod'

case $machine
    when /laptop-3/i then
        $resourcepath = "i:/data/resources"
        $workpath     = "i:/data/work"
        $textree      = "c:/data/develop/tex"
        $job.extend_path("c:/data/system/ruby/bin")
        $job.extend_path("c:/data/system/perl/bin")
        $job.extend_path("c:/data/system/gs/gs8.52/bin")
        $job.extend_path("c:/data/develop/tex/texmf-local/scripts/context/ruby")
        $job.extend_path("c:/data/develop/tex/texmf-local/scripts/context/perl")
        $job.extend_path("c:/data/develop/tex/texmf-mswin/bin")
        $job.extend_path("c:/data/system/bin")
        $job.export_variable('PERLLIB','c:/data/system/perl/lib;c:/data/system/perl/site')
        $job.export_variable('GS_LIB','c:/data/system/gs/gs8.52/lib;c:/data/system/gs/fonts')
    when /pragma-pod/i then
        $dataroot     = "/data/websites/www.pragma-pod.com"
        $workpath     = "#{$dataroot}/work"
        $resourcepath = "#{$dataroot}/resources"
        $textree      = "#{$dataroot}/tex"
        $job.extend_path("#{$dataroot}/tex/texmf-linux/bin")
        $job.extend_path("/usr/bin")
        $job.extend_path("/usr/local/bin")
    else
        $job.error("unknown machinery: #{$machine}")
end

$job.export_variable('TXRESOURCES',$resourcepath)

$job.use_tree($textree)

$texexecflags = [
    '--modefile=examodes',
    '--pdf',
    '--global',
    '--silent',
    # '--batch',
    '--interfcae=en',
    '--result=result',
].join(' ')

$job.pipe_command('texmfstart exatools --texify request.exa')

def run_texexec_job(used_module)
    $job.pipe_command("texmfstart texexec #{$texexecflags} --use=#{used_module} request.exa")
    $job.rename_file('result.log','result.keep')
    $job.pipe_command('texmfstart ctxtools --purge --all')
end

def run_whatever_job(whatever)
    $job.pipe_command("texmfstart #{whatever} request.exa")
    # todo: either reply or result file
end

