/*
**	mod_msql.h	-  Lite / W3-mSQL module for mSQL Access
**
**
** Copyright (c) 1995  Hughes Technologies Pty Ltd.
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
**
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
**
** This software is provided "as is" without any expressed or implied warranty.
**
*/


/*
** External function prototypes
*/

void doMsqlConnect();
void doMsqlClose();
void doMsqlSelectDB();
void doMsqlQuery();
void doMsqlStoreResult();
void doMsqlFreeResult();
void doMsqlFetchField();
void doMsqlFetchRow();
void doMsqlFieldSeek();
void doMsqlDataSeek();
void doMsqlListDBs();
void doMsqlListTables();
void doMsqlInitFieldList();
void doMsqlListField();
void doMsqlNumRows();
void doMsqlEncode();

void initModMsql();



/*
** mSQL external function definitions
**
** This table maps from internal Lite function names to the C code.
** The format is :-
**
**	{FunctName, CFunction, NumArgs, { Arg1Type, Arg2Type....., 0}}
**
**	Setting NumArgs to -1 indicates varargs
*/


efunct_t msql_efuncts[] = {
	{ "msqlConnect", doMsqlConnect, -1, {0}},
	{ "msqlClose", doMsqlClose, 1, {P_INT,0}},
	{ "msqlSelectDB", doMsqlSelectDB, 2, {P_INT,P_TEXT, 0}},
	{ "msqlQuery", doMsqlQuery, 2, {P_INT,P_TEXT, 0}},
	{ "msqlStoreResult", doMsqlStoreResult, 0, {0}},
	{ "msqlFreeResult", doMsqlFreeResult, 1, {P_INT,0}},
	{ "msqlFetchRow", doMsqlFetchRow, 1, {P_INT,0}},
	{ "msqlFetchField", doMsqlFetchField, 1, {P_INT,0}},
	{ "msqlFieldSeek", doMsqlFieldSeek, 2, {P_INT,P_INT,0}},
	{ "msqlDataSeek", doMsqlDataSeek, 2, {P_INT,P_INT,0}},
	{ "msqlListDBs", doMsqlListDBs, 1, {P_INT,0}},
	{ "msqlListTables", doMsqlListTables, 1, {P_INT,0}},
	{ "msqlInitFieldList", doMsqlInitFieldList, 2, {P_INT,P_TEXT,0}},
	{ "msqlListField", doMsqlListField, 0, {0}},
	{ "msqlNumRows", doMsqlNumRows, 1, {P_INT}},
	{ "msqlEncode", doMsqlEncode, 1, {P_TEXT}},

	{ NULL, 0 }
};
