/*
**	Julian date calculations.
**
**	This work is derived from GNU software, so you should read
**	the GNU license agreement if you are plannning to use
**	them in commercial software.
*/
#include <stdio.h>
#include <common/portability.h>

#include "timelib.h"
#include "absolute.h"
#include "julian.h"

JULIAN_DAY
gregorian_to_julian (day, month, year)
	int 	day, 
		month, 
		year;
{
	return ((JULIAN_DAY) gregorian_to_absolute (day, month, year) + 
		JULIAN_OFFSET);
}

JULIAN_DAY
unix_to_julian (time)
	time_t	time;
{
	struct tm *tmp;
	
	tmp = localtime (&time);

	return gregorian_to_julian (tmp->tm_mday, 
				    tmp->tm_mon + 1, 
				    tmp->tm_year + 1900);
}

JULIAN_DAY
current_julian_date ()
{
	return (current_absolute_date() + JULIAN_OFFSET);
}

/*
**	julian_to_gregorian_day(), julian_to_gregorian_month(), 
**	julian_to_gregorian_year() extract the required 
**	component from a date.
*/
int
julian_to_gregorian_day (date)
	JULIAN_DAY	date;
{
	return absolute_to_gregorian_day (date - JULIAN_OFFSET);
}

int
julian_to_gregorian_month (date)
	JULIAN_DAY	date;
{
	return absolute_to_gregorian_month (date - JULIAN_OFFSET);
}

int
julian_to_gregorian_year (date)
	JULIAN_DAY	date;
{
	return absolute_to_gregorian_year (date - JULIAN_OFFSET);
}


WEEKDAY 
julian_to_weekday (date)
	JULIAN_DAY	date;
{
	return absolute_to_weekday (date - JULIAN_OFFSET);
}



