/*-
 * reginfo.c --
 *	Find out who's registered.
 *
 * Copyright (c) 1988, 1989 by the Regents of the University of California
 * Copyright (c) 1988, 1989 by Adam de Boor
 * Copyright (c) 1989 by Berkeley Softworks
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any non-commercial purpose
 * and without fee is hereby granted, provided that the above copyright
 * notice appears in all copies.  The University of California,
 * Berkeley Softworks and Adam de Boor make no representations about
 * the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 *
 */
#ifndef lint
static char *rcsid =
"$Id: reginfo.c,v 1.13 1992/09/04 07:36:16 stolcke Exp $ ICSI (Berkeley)";
#endif lint

#include    "customs.h"
#include    <stdio.h>
#include    <strings.h>
#include    <netdb.h>
#include    <sys/time.h>

#include    "xmalloc.h"

typedef struct {
    char    	  *name;
    long    	  avail;
    long    	  rating;
    long    	  arch;
    long    	  numClients;
    long    	  *clients;
} Host;

static Host   	*allHosts;

static int
host_compare(h1, h2)
    int *h1, *h2;
{
    return strcmp(allHosts[*h1].name, allHosts[*h2].name);
}

/*ARGSUSED*/
main(argc, argv)
    int	    argc;
    char    **argv;
{
    char    	  	infoBuf[MAX_INFO_SIZE];
    int	    	  	i, j;
    int	    	  	numHosts;
    char    	  	*cp;
    struct sockaddr_in	sin;
    int			*sortHosts;
    int			k, availHosts = 0, downHosts = 0;
    int			lastAlloc;

    if (argc > 3) {
	fprintf (stderr, "Usage: %s [<host> [<port>]]\n", argv[0]);
	exit (2);
    }

    if (argc > 1) {
	struct sockaddr_in sin2;
	struct hostent *he;
	struct servent *se;
	char *service = CUSTOMS_SERVICE_NAME;

	sin2.sin_family = AF_INET;
	sin2.sin_port = 0;
	sin2.sin_addr.s_addr = inet_addr(argv[1]);
	if (sin2.sin_addr.s_addr == -1) {
	    he = gethostbyname(argv[1]);
	    if (he == (struct hostent *)NULL) {
		fprintf (stderr, "%s: unkown host\n", argv[1]);
		exit(1);
	    }
	    bcopy (he->h_addr, &sin2.sin_addr, he->h_length);
	}

	if (argc > 2) {
	    sin2.sin_port = htons(atoi(argv[2]));
	    service = argv[2];
	}

	if (! sin2.sin_port) {
	    se = getservbyname(service, "udp");
	    if (se == (struct servent *)NULL) {
		fprintf (stderr, "%s: unknown service\n", service);
		exit(1);
	    }
	    sin2.sin_port = se->s_port;
	}

	if (Customs_MasterForHost(&sin2, &sin) != RPC_SUCCESS) {
	    fprintf(stderr, "Couldn't find master for ");
	    Customs_PError(argv[1]);
	    exit(1);
	}
    } else {
	if (Customs_Master(&sin) != RPC_SUCCESS) {
	    Customs_PError("Couldn't find master");
	    exit(1);
	}
    }

    if (Customs_Info(&sin, infoBuf) != RPC_SUCCESS) {
	Customs_PError("Couldn't read registration info");
	exit(1);
    }
    cp = infoBuf;
    numHosts = *(int *)cp;
    cp += sizeof(int);
    allHosts = (Host *)malloc(numHosts * sizeof(Host));
    sortHosts = (int *)malloc(numHosts * sizeof(int));
    for (i = 0; i < numHosts; i++) {
	allHosts[i].name = cp;
	cp += strlen(cp) + 1;
	cp = Customs_Align(cp, char *);
	allHosts[i].avail = *(long *)cp;
	cp += sizeof(long);
	allHosts[i].rating = *(long *)cp;
	cp += sizeof(long);
	allHosts[i].arch = *(long *)cp;
	cp += sizeof(long);
	allHosts[i].numClients = *(long *)cp;
	cp += sizeof(long);
	allHosts[i].clients = (long *)cp;
	cp += allHosts[i].numClients * sizeof(long);
	sortHosts[i] = i;
    }
    
    /* sort by hostname */
    qsort(sortHosts, numHosts, sizeof(int), host_compare);

    lastAlloc = *(long *)cp;

    printf ("HOST          ARCH   STATUS                INDEX   CLIENTS\n");
    for (k = 0; k < numHosts; k++) {
	char *status;
	int index = -1;
	i = sortHosts[k];
	printf ("%-12s %5d %c ", allHosts[i].name, allHosts[i].arch,
		(i == 0 ? 'M' : (i == lastAlloc ? 'L' : ' ')));
	if (allHosts[i].avail & AVAIL_DOWN) {
	    status = "host down";
	    downHosts++;
	} else if (allHosts[i].avail & AVAIL_IDLE) {
	    status = "not idle";
	} else if (allHosts[i].avail & AVAIL_SWAP) {
	    status = "not enough swap space";
	} else if (allHosts[i].avail & AVAIL_LOAD) {
	    status = "load average too high";
	} else if (allHosts[i].avail & AVAIL_IMPORTS) {
	    status = "too many imported jobs";
	} else if (allHosts[i].avail & AVAIL_PROC) {
	    status = "too many processes";
	} else {
	    status = "available";
	    index = allHosts[i].rating;
	    availHosts++;
	}
	if (index < 0) {
	    printf ("%-27s   ", status);
	} else {
	    printf ("%-22s%5d   ", status, index);
	}
	if (allHosts[i].numClients != 0) {
	    for (j = 0; j < allHosts[i].numClients; j++) {
		printf ("%s ", allHosts[allHosts[i].clients[j]].name);
	    }
	    putchar('\n');
	} else {
	    printf ("ALL\n");
	}
    }
    printf ("\t%d host(s) total, %d available, %d down\n",
		numHosts, availHosts, downHosts );
    exit(0);
}
