/* SCCS @(#)pixeledit.callback.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                            pixeledit.callback.c                      */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   pixeledit.callback.c                                */
/*                                                                      */
/* DESCRIPTION  :   LaboImage (Pixel editing Tool)                      */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "libwidgets/widgetstructure.h"
#include "pixeledit.layout.h"
#include "win4.h"
#include <Xm/Text.h>
#include <math.h>
#include "../IOplans.layout.h"
extern Display 	*gDisplay;
extern GC 	default_gc, gc_xor;   

extern Pixmap flechepixmap_pixeledit;
extern Widget Magnify_drawing;

int PixelEditTool_Open_Flag = FALSE;

static int Correctselected = 0;
static int Displayselected = 0;
static int InverseVideoselected = 0;
static int lastColormap = -1;

static Colormap Colormap_pixeledit = NULL;

static Pixmap Magnify_pixmap = NULL;
static Pixmap Image_pixmap_copy = NULL;
static XImage *XImage_copy = NULL;



static void
Rectangle(data_display, xor, ColorSelected, X1, Y1, X2, Y2)
xs_struc_display_menu * data_display;
int xor, ColorSelected, X1, Y1, X2, Y2;
{
  int x, y;

  if (xor)
  {
    XSetForeground(gDisplay, gc_xor, 128);
    XDrawLine(gDisplay, data_display->ret->pixmap, gc_xor,
	      X1,Y1,X2,Y1);
    XDrawLine(gDisplay, data_display->ret->pixmap, gc_xor,
	      X2,Y1,X2,Y2);
    XDrawLine(gDisplay, data_display->ret->pixmap, gc_xor,
	      X2,Y2,X1,Y2);
    XDrawLine(gDisplay, data_display->ret->pixmap, gc_xor,
	      X1,Y2,X1,Y1);
    XCopyArea(gDisplay, data_display->ret->pixmap, 
	      XtWindow(data_display->Drawing_Area), gc_xor, X1, Y1,
	      X2-X1, Y2-Y1, X1, Y1);
  }
  else 
  {    
    XSetForeground(gDisplay, default_gc, ColorSelected);
    XFillRectangle(gDisplay, data_display->ret->pixmap, default_gc,
		   X1,Y1,X2-X1+1,Y2-Y1+1);
    XCopyArea(gDisplay, data_display->ret->pixmap, 
	      XtWindow(data_display->Drawing_Area), default_gc, 0, 0,
	      data_display->im_desc->ncolonne, 
	      data_display->im_desc->nligne,
	      0, 0);

    if (XImage_copy == NULL)
    {
      XImage_copy = XGetImage(gDisplay, data_display->ret->pixmap,
			      0, 0, data_display->im_desc->ncolonne, 
			      data_display->im_desc->nligne, AllPlanes, 
			      ZPixmap);
    }
    for (x = X1; x <= X2; x++)
      for (y = Y1; y <= Y2; y++)
	XPutPixel(XImage_copy, x, y,(unsigned long)ColorSelected);
  }
}


static void
draw_fleche(drawing, x) 
Widget drawing;
int	x ;
{
    XCopyArea(gDisplay, flechepixmap_pixeledit, 
	      XtWindow(drawing),  default_gc, 0, 0, 
	      512, 10, 0, 0);
    XSetForeground(gDisplay, default_gc, 250);
    XDrawLine (gDisplay, XtWindow(drawing), default_gc, x,4,x,8);
    XDrawLine (gDisplay, XtWindow(drawing), default_gc, x+1,4,x+1,8);
    XDrawLine (gDisplay, XtWindow(drawing), default_gc, x,8,x-5,3);
    XDrawLine (gDisplay, XtWindow(drawing), default_gc, x+1,8,x-4,3);
    XDrawLine (gDisplay, XtWindow(drawing), default_gc, x,8,x+5,3);
    XDrawLine (gDisplay, XtWindow(drawing), default_gc, x+1,8,x+6,3);

}



void 
update_fleche_color(Correct_color_text, DrawingAreafleche, callData)
    Widget Correct_color_text;
    Widget DrawingAreafleche;
    caddr_t callData;
{
  int value, xpos;

  value = atoi(XmTextGetString(Correct_color_text));
    
  xpos = value * 2;
  draw_fleche(DrawingAreafleche, xpos);
}



void 
change_color_value(Correct_color_text, Color_pixeledit, callData)
    Widget Correct_color_text;
    Widget Color_pixeledit;
    caddr_t callData;
{
  int value, xpos;

  value = atoi(XmTextGetString(Correct_color_text));
	       
  XSetForeground(gDisplay, default_gc, value);
  XFillRectangle (gDisplay, XtWindow(Color_pixeledit), default_gc, 0,0,35,35);

}


static void 
Magnify_proc(data_display, X,Y)
    xs_struc_display_menu *data_display;
    int X,Y;
{
  Arg args[MAX_ARGS];
  int i, xpos, ypos, n;

  /* Create the pixmap for the magnify glass if it doesnt exist */
  if (!Magnify_pixmap)
  {
    Magnify_pixmap = XCreatePixmap(gDisplay,
				   XDefaultRootWindow(gDisplay),
				   240, 240, 8);
    n = 0;
    XtSetArg(args[n],XmNbackgroundPixmap, Magnify_pixmap); n++;
    XtSetArg(args[n],XmNwidth, 240); n++;
    XtSetArg(args[n],XmNheight, 240); n++;
    XtSetValues(Magnify_drawing, args, n);
  }

/*  
  if (X >= 30) xpos = X - 30;
  else xpos = 0;
  if (xpos >= data_display->im_desc->ncolonne - 60) 
      xpos = data_display->im_desc->ncolonne - 60;
  if (Y >= 30) ypos = Y - 30;
  else ypos = 0;
  if (ypos >= data_display->im_desc->nligne - 60) 
      ypos = data_display->im_desc->nligne - 60;
  
*/
  xpos = X - 30;
  ypos = Y - 30;

  /* Chaque colonne de l'image est copiee 4 fois 
     sur le Magnify_pixmap. A region of 60x60 is magnified*/
  for(i = 0; i < 240; i++)
    XCopyArea(gDisplay, data_display->ret->pixmap, 
	      Magnify_pixmap, default_gc,
	      xpos + (int) (i / 4), ypos,
	      1, (int) (240 / 4), i, 0);

  /* Les parties de la loupe en dehors de l'image sont noires */
  if (xpos < 0) 
  {
    XSetForeground(gDisplay, default_gc, 0);
    XFillRectangle (gDisplay, Magnify_pixmap, default_gc,
		    0, 0, abs(xpos) * 4, (int) (240 / 4));
  }
  else if (xpos + 60 > data_display->im_desc->ncolonne)
  {
    XSetForeground(gDisplay, default_gc, 0);
    XFillRectangle (gDisplay, Magnify_pixmap, default_gc,
		    (data_display->im_desc->ncolonne - xpos) * 4, 0, 
		    (240 - (data_display->im_desc->ncolonne - xpos)) * 4, 
		    (int) (240 / 4));
  }
  if (ypos < 0) 
  {
    XSetForeground(gDisplay, default_gc, 0);
    XFillRectangle (gDisplay, Magnify_pixmap, default_gc,
		    0, 0, 240, abs(ypos));
  }
  else if (ypos + 60 > data_display->im_desc->nligne)
  {
    XSetForeground(gDisplay, default_gc, 0);
    XFillRectangle (gDisplay, Magnify_pixmap, default_gc,
		    0, data_display->im_desc->nligne - ypos, 240, 
		    (240 - (data_display->im_desc->nligne - ypos)));
  }

  /* Chaque ligne du Magnify_pixmap est recopie 4 fois 
     sur le Magnify_drawing */
  for(i = 0; i < 240; i++)
      XCopyArea(gDisplay, Magnify_pixmap, 
		XtWindow(Magnify_drawing), default_gc,
		0, (int) (i / 4),
		240, 1, 0, i);

  XCopyArea(gDisplay, XtWindow(Magnify_drawing), 
	    Magnify_pixmap, default_gc, 0, 0,
	    240, 240, 0, 0);
  XDrawLine(gDisplay, XtWindow(Magnify_drawing), gc_xor,
	    70, 120, 170, 120);
  XDrawLine(gDisplay, XtWindow(Magnify_drawing), gc_xor,
	    70, 124, 170, 124);
  XDrawLine(gDisplay, XtWindow(Magnify_drawing), gc_xor,
	    120, 70, 120, 170);  
  XDrawLine(gDisplay, XtWindow(Magnify_drawing), gc_xor,
	    124, 70, 124, 170);  
}




void
PIXEL_Couleur_Corr_Notify_Proc(w, data_display, event)
    Widget          w;
    xs_struc_display_menu *data_display;
    XEvent         *event;
{
  Arg args[MAX_ARGS];
  int X, Y, ColorSelected, n;
  static int defregion_flag = 0;
  static int XZ1, YZ1, XZ2, YZ2;

  X = event->xmotion.x;    /* positions de la souris sur le display! */
  Y = event->xmotion.y;

  ColorSelected = atoi(XmTextGetString(data_display->Couleur_correct));

  if (Image_pixmap_copy == NULL)
  {
    Image_pixmap_copy = XCreatePixmap(gDisplay, DefaultRootWindow(gDisplay),
				      data_display->im_desc->ncolonne, 
				      data_display->im_desc->nligne, 8);
    XCopyArea(gDisplay, data_display->ret->pixmap, 
	      Image_pixmap_copy, default_gc, 0, 0,
	      data_display->im_desc->ncolonne, 
	      data_display->im_desc->nligne,
	      0, 0);
  }
  if (XImage_copy == NULL)
  {
    XImage_copy = XGetImage(gDisplay, data_display->ret->pixmap,
			    0, 0, data_display->im_desc->ncolonne, 
			    data_display->im_desc->nligne, AllPlanes, 
			    ZPixmap);
  }
  switch (event->type){
    case ButtonPress:
    {
      XZ1 = X; 
      XZ2 = X;
      YZ1 = Y; 
      YZ2 = Y;
      Rectangle(data_display, 1, ColorSelected,
		XZ1, YZ1, XZ2, YZ2);
      if (Correctselected) defregion_flag = 1;
    }
    break;
    
    case MotionNotify:
    {
      if (defregion_flag)
      {
	Rectangle(data_display, 1, ColorSelected,
		  XZ1, YZ1, XZ2, YZ2);
	XZ2 = X;
	YZ2 = Y;
	Rectangle(data_display, 1, ColorSelected,
		  XZ1, YZ1, XZ2, YZ2);
      }
    }
    break;

    case ButtonRelease:
    {
      if (defregion_flag)
      {
	XZ2 = X;
	YZ2 = Y;
      }
      
      Rectangle(data_display, 1, ColorSelected,
		XZ1, YZ1, XZ2, YZ2);
      Rectangle(data_display, 0, ColorSelected, 
		XZ1, YZ1, XZ2, YZ2);
      Magnify_proc(data_display, XZ2, YZ2);
      defregion_flag = 0;
    }
    break;
    default:
    break;
    
  }
}



Colormap
Set_Color_Map(data_display, Affichage)
xs_struc_display_menu *data_display;
int Affichage;
{
    Colormap my_colormap; 

    switch (Affichage)
    {
      case G_LIN + DIRECT:
        my_colormap = init_color_lin ();
	break;
      case G_LIN + INVERSE:
	my_colormap = init_color_lin_I ();
	break;
      case G_LOG + DIRECT:
	my_colormap = init_color_log ();
	break;
      case G_LOG + INVERSE:
	my_colormap = init_color_log_I ();
	break;
    }
    return(my_colormap);
}



/***************************************************************/


void
uninstall_pixeledit(win, data_display, event)
    Widget      win;
    xs_struc_display_menu *data_display;
    XEvent      *event;
{
    if (Colormap_pixeledit) 
    {	
      XUninstallColormap(gDisplay, Colormap_pixeledit);
      XFreeColormap(gDisplay, Colormap_pixeledit);
      Colormap_pixeledit = NULL;
    }
    lastColormap = -1;
}



void track_mouse_pixeledit(w, data_display, event)
    Widget          w;
    xs_struc_display_menu *data_display;
    XEvent         *event;
{
  char message[25];
  Arg args[MAX_ARGS];
  int X, Y, n;
  static one_from_two = 0;
  int Affichage;

  X = event->xmotion.x;    /* positions de la souris sur le display! */
  Y = event->xmotion.y;

  /* Set the selected colormap : */

  Affichage = Displayselected + InverseVideoselected;
    
  if (Affichage != lastColormap) 
  {
    Colormap_pixeledit = Set_Color_Map(data_display, Affichage);
    XInstallColormap(gDisplay, Colormap_pixeledit);
    lastColormap = Affichage;
  }
  
  sprintf (message, "X:%d", X);
  n = 0;
  XtSetArg(args[n],XmNlabelString,
	   XmStringLtoRCreate(message,XmSTRING_DEFAULT_CHARSET)); n++;
  XtSetValues(data_display->label_pixeledit[0], args, n);

  sprintf (message, "Y:%d", Y);
  n = 0;
  XtSetArg(args[n],XmNlabelString,
	   XmStringLtoRCreate(message,XmSTRING_DEFAULT_CHARSET)); n++;
  XtSetValues(data_display->label_pixeledit[1], args, n);

  if (XImage_copy == NULL)
  {
    XImage_copy = XGetImage(gDisplay, data_display->ret->pixmap,
			    0, 0, data_display->im_desc->ncolonne, 
			    data_display->im_desc->nligne, AllPlanes, 
			    ZPixmap);
  }
  sprintf (message, "Color: %d", XGetPixel(XImage_copy,X,Y));
  n = 0;
  XtSetArg(args[n],XmNlabelString,
	   XmStringLtoRCreate(message,XmSTRING_DEFAULT_CHARSET)); n++;
  XtSetValues(data_display->label_pixeledit[2], args, n);

  /* Dessine une fois sur deux la loupe */
  if (one_from_two)
  {
    Magnify_proc(data_display,X,Y);
    one_from_two = 0;
  }
  else one_from_two = 1;

}



void Color_selected(w, Correct_color_text, event)
    Widget      w;
    Widget	Correct_color_text;
    XEvent      *event;
{
  char buftemp[4];
  int xpos, X;

  xpos = event->xmotion.x;
  X = (int) rint((double)xpos/2)  ;
  sprintf(buftemp,"%d", X) ;
  XmTextSetString (Correct_color_text, buftemp);
  draw_fleche(w, xpos);
}

/******************************************************
/   activateCallback for Widget Correction_zone
/*****************************************************/

void
Choose_Correction_zone(typewidget, Correct, callData)
	Widget typewidget;
        int Correct;
	caddr_t callData;
{
  Correctselected = Correct;
}


/******************************************************
/   activateCallback for Widget Display
/*****************************************************/

void
Choose_Display_Lin_log(typewidget, Display, callData)
	Widget typewidget;
        int Display;
	caddr_t callData;
{
  Displayselected = Display;
}


/******************************************************
/   activateCallback for Widget InverseVideo
/*****************************************************/

void
Choose_InverseVideo(typewidget, InverseVideo, callData)
	Widget typewidget;
        int InverseVideo;
	caddr_t callData;
{
  InverseVideoselected = InverseVideo;
}



/******************************************************
/   activateCallback for Widget REFRESH
/*****************************************************/

void
pixeledit_REFRESH_callb(REFRESH, data_display, callData)
	Widget REFRESH;
        xs_struc_display_menu *data_display;
	caddr_t callData;
{
  if (Image_pixmap_copy)
  {
    XCopyArea(gDisplay, Image_pixmap_copy, 
	      data_display->ret->pixmap, default_gc, 0, 0,
	      data_display->im_desc->ncolonne, 
	      data_display->im_desc->nligne,
	      0, 0);

    if (XImage_copy != NULL)
    {
      XDestroyImage(XImage_copy);
      XImage_copy = NULL;
    }

    XImage_copy = XGetImage(gDisplay, data_display->ret->pixmap,
			    0, 0, data_display->im_desc->ncolonne, 
			    data_display->im_desc->nligne, AllPlanes, 
			    ZPixmap);
    XCopyArea(gDisplay,data_display->ret->pixmap, 
	      XtWindow(data_display->Drawing_Area), default_gc, 0, 0,
	      data_display->im_desc->ncolonne, 
	      data_display->im_desc->nligne,
	      0, 0);
  }
}



/******************************************************
/   activateCallback for Widget SAVE
/*****************************************************/

void
pixeledit_SAVE_callb(SAVE, data_display, callData)
	Widget SAVE;
        xs_struc_display_menu *data_display;
	caddr_t callData;
{
Widget planSortie;
planSortie = build_IOplans_widget(SAVE, 81, "", data_display);
XtManageChild(planSortie);
}



/******************************************************
/   activateCallback for Widget QUIT
/*****************************************************/

void
pixeledit_QUIT_callb(QUIT, data_display, callData)
	Widget QUIT;
        xs_struc_display_menu *data_display;
	caddr_t callData;
{
  if (Image_pixmap_copy)
  {
    XCopyArea(gDisplay, Image_pixmap_copy, 
	      data_display->ret->pixmap, default_gc, 0, 0,
	      data_display->im_desc->ncolonne, 
	      data_display->im_desc->nligne,
	      0, 0);
    XCopyArea(gDisplay, data_display->ret->pixmap, 
	      XtWindow(data_display->Drawing_Area), default_gc, 0, 0,
	      data_display->im_desc->ncolonne, 
	      data_display->im_desc->nligne,
	      0, 0);

    XFreePixmap(gDisplay, Image_pixmap_copy);
    Image_pixmap_copy = NULL;
  }

  if (XImage_copy != NULL)
  {
    XDestroyImage(XImage_copy);
    XImage_copy = NULL;
  }
  if  (Magnify_pixmap)
  {
    XFreePixmap(gDisplay, Magnify_pixmap);
    Magnify_pixmap = NULL;
  }
  if  (flechepixmap_pixeledit)
  {
    XFreePixmap(gDisplay, flechepixmap_pixeledit);
    flechepixmap_pixeledit = NULL;
  }
  if (Colormap_pixeledit) 
  {	
    XUninstallColormap(gDisplay, Colormap_pixeledit);
    XFreeColormap(gDisplay, Colormap_pixeledit);
    Colormap_pixeledit = NULL;
  }
  XUndefineCursor(gDisplay, XtWindow(data_display->Drawing_Area));
  XtRemoveEventHandler(data_display->Drawing_Area, 
		       PointerMotionMask, 
		       FALSE,track_mouse_pixeledit, data_display);

  XtRemoveEventHandler(data_display->Drawing_Area, 
		       LeaveWindowMask, 
		       FALSE, uninstall_pixeledit, data_display);
	  
  XtRemoveEventHandler(data_display->Drawing_Area, 
		       ButtonPressMask | ButtonReleaseMask | ButtonMotionMask, 
		       FALSE, PIXEL_Couleur_Corr_Notify_Proc, data_display);

  XtUnmanageChild(XtParent(XtParent(QUIT)));
  XtDestroyWidget(XtParent(XtParent(QUIT)));
  PixelEditTool_Open_Flag = FALSE;
}
