/* SCCS @(#)LaboImage.util.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                            LaboImage.util.c                          */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   LaboImage.util.c                                    */
/*                                                                      */
/* DESCRIPTION  :   Utility function for LaboImage Interface            */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/


#include <stdio.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include "LaboImage.util.h"

/* Bitmap Conversion Utility */

Pixmap
BitmapFileToPixmap(w, fileName, fg, bg)
	Widget w;
	char * fileName;
	char *fg;
	char *bg;
{
	Pixmap theIcon;
	Screen * screen = XtScreen(w);
	theIcon = XmGetPixmap(screen,fileName,
		ColorNameToPixel(w,fg),
		ColorNameToPixel(w,bg));
	return(theIcon);
}

/* FontList Conversion Utility */

XmFontList
FontNameToFontList(w, name)
	Widget w;
	char * name;
{
	XFontStruct *fStruct;

	fStruct = XLoadQueryFont(XtDisplay(w),name);
	if (!fStruct)
		fStruct = XLoadQueryFont(XtDisplay(w),"fixed");
	return(XmFontListCreate(fStruct,XmSTRING_DEFAULT_CHARSET));
}

/* Color Conversion Utility */

Pixel
ColorNameToPixel(w, name)
	Widget w;
	char * name;
{
	Colormap colormap;
	XColor color, hdwcolor;
	Display *display;

	display = XtDisplay(w);
	colormap = XDefaultColormap(display,DefaultScreen(display));
	XLookupColor(display,colormap,name,&color,&hdwcolor);
	XAllocColor(display,colormap,&hdwcolor);
	return(hdwcolor.pixel);
}

/* MainWindow MenuBar creation function */

Widget
CreateMenuRegion(par, name, args, n)
	Widget par;
	char * name;
	ArgList args;
	Cardinal n;
{
	Arg newArg[4];
	int i;
	Widget temp = XmCreateMenuBar (par, name, args, n);
	i = 0;
	XtSetArg (newArg[i], XmNmenuBar, temp); i++;
	XtSetValues (par, newArg, i); 
	return (temp);
}

/* MainWindow Command Region creation function */

Widget
CreateCommandRegion(par, name, args, n)
	Widget par;
	char * name;
	ArgList args;
	Cardinal n;
{
	Arg newArg[4];
	int i;
	Widget temp = XmCreateFrame (par, name, args, n);
	i = 0;
	XtSetArg (newArg[i], XmNcommandWindow, temp); i++;
	XtSetValues (par, newArg, i); 
	return (temp);
}

/* Work Region creation function */

Widget
CreateWorkRegion(par, name, args, n)
	Widget par;
	char * name;
	ArgList args;
	Cardinal n;
{
	Arg newArg[4];
	int i;
	Widget temp = XmCreateForm (par, name, args, n);
	i = 0;
	XtSetArg (newArg[i], XmNworkWindow, temp); i++;
	XtSetValues (par, newArg, i); 
	return (temp);
}

/* horizontal ScrollBar creation function */

Widget
CreateHorizScroll(par, name, args, n)
	Widget par;
	char * name;
	ArgList args;
	Cardinal n;
{
	Arg newArg[4];
	int i;
	Widget temp = XmCreateScrollBar (par, name, args, n);
	i = 0;
	XtSetArg (newArg[i], XmNhorizontalScrollBar, temp); i++;
	XtSetValues (par, newArg, i); 
	return (temp);
}

/* vertical ScrollBar creation function */

Widget
CreateVertScroll(par, name, args, n)
	Widget par;
	char * name;
	ArgList args;
	Cardinal n;
{
	Arg newArg[4];
	int i;
	Widget temp = XmCreateScrollBar (par, name, args, n);
	i = 0;
	XtSetArg (newArg[i], XmNverticalScrollBar, temp); i++;
	XtSetValues (par, newArg, i); 
	return (temp);
}

/* Option Menu creation function */

Widget
CreateOptionMenu(par, name, args, n)
	Widget par;
	char * name;
	ArgList args;
	Cardinal n;
{
	Arg newArg[1];
	ArgList newArgs;
	char * tempName;
	Widget pd;

	tempName = (char * ) malloc(strlen(name) + strlen("PD "));	
	sprintf(tempName,"%sPD",name);
	pd = XmCreatePulldownMenu(par, tempName, NULL, 0);
	free(tempName);
	XtSetArg(newArg[0],XmNsubMenuId,pd);
	newArgs = XtMergeArgLists(args,n,newArg,1);
	return( XmCreateOptionMenu(par,name,newArgs,n+1) );
}

/* Option Pulldown menu creation function */

Widget
CreateOptionPulldown(par, name, args, n)
	Widget par;
	char * name;
	ArgList args;
	Cardinal n;
{
	Arg newArg[1];
	Widget pd;

	XtSetArg(newArg[0],XmNsubMenuId,NULL);
	XtGetValues(par,newArg,1);
	pd = (Widget ) newArg[0].value;
	return(pd);
}

/* Pulldown menu creation function */

Widget
CreatePulldownMenu(par, name, args, n)
	Widget par;
	char * name;
	ArgList args;
	Cardinal n;
{
	Arg newArgs[1];
	Widget temp;

	temp = XmCreatePulldownMenu(XtParent(par), name,args,n);
	XtSetArg(newArgs[0],XmNsubMenuId,temp);
	XtSetValues(par,newArgs,1);
	return(temp);
}
