/* SCCS @(#)gel1D_proc4.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                            gel1D_proc4.c                             */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   gel1D_proc4.c                                       */
/*                                                                      */
/* DESCRIPTION  :   LaboImage (Gel1D Tool)                              */
/*                                                                      */
/* AUTHORS      :   Thierry PUN, Krassimir TODOROV, Marianne Logean     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include <memory.h>
#include <malloc.h>
#include <math.h>
#include <stdio.h>

#include "define.h"
#include "global.h"
#include "structure.h"
#include "type.h"

#include "gel1D.h"

#define NO_RAM 1

#define MY_DEBUG

#ifdef MY_DEBUG
static void
Stop()
{
    int             I = 0;
}
#define Test_Error(error)				    \
{if (error) {fprintf(stderr,"%cERROR (error) at line %d in %s!\n",  \
		    7,__LINE__,__FILE__); Stop();}}
#else
#define Test_Error(error)
#endif

#define Adresse(x,y) (y * PrXMax + x)

#define max(x,y) (((x) > (y)) ? (x) : (y))
#define min(x,y) (((x) < (y)) ? (x) : (y))

#define free_if(x) if ((x) != NULL)		\
			{			\
			    free((char *)x);	\
			    x = NULL;		\
			}

extern int PrXMax, PrYMax, Prplan, regime_corr;
extern float *PrHistogr, *PrHist_Aff, *Largeurs;
extern int Ideal_espace, Ideal_largeur, Profil_Aff_1;
extern int Pro_Height, Pro_Offset, Nearest, X_Move, N_Points;
extern char *Courbe_Affichee;

extern unsigned short *Frontieres_Preest;
extern float *Coefficients;

extern Gel_Pic_type *Gel_Pics_List, **Dir_Pics;
extern Gel_Global_type Gel_Global;

static char Str_x[256];
static float Sigma_Moy, *Adr_L, *Adr_R;
static int N_Sigma, YYOld, YY1, YY2, DDY;
static Gel_Pic_type *Pic_Courant;
static Gel_Pic_type *PPic_p, *PPic_c;

int varconfirm;

extern char *paneltabs[];
extern char *mastertabs[];
extern char *menutabs[];

extern void Affiche_Profil_1();


/*****************************************************************************/

/*static Panel_setting
get_from_panel_2_floats(item, event)
Panel_item item;
Event *event;
{
    static struct cte_cmplx Param2f;
    if (event_id(event) == CTRLC)
    {
	flag_break = TRUE;
	window_return(NULL);
	window_destroy(frame_in);
	return ((Panel_setting) 0);
    }
    if (event_id(event) == '\t')
	return(PANEL_NEXT);
    Param2f.reel = atof((char *)panel_get(cmplx_panel_reel_i,PANEL_VALUE));
    Param2f.im = atof((char *)panel_get(cmplx_panel_imag_i,PANEL_VALUE));
    window_return(&Param2f);
    window_destroy(frame_in);
    return ((Panel_setting) 0);
}*/

/*****************************************************************************/

struct cte_cmplx *
get_2_floats(titre,str1,str2,f1,f2)
char *titre, *str1, *str2;
float *f1, *f2;
{
    struct cte_cmplx *Param2f;
/*    Panel panel_in;
    char rep[21];
    frame_in = window_create(frame, FRAME,
				WIN_WIDTH, 1, WIN_HEIGHT, 1,
				FRAME_NO_CONFIRM, TRUE, 0);
    panel_in = window_create(frame_in, PANEL, PANEL_LABEL_BOLD, TRUE, 0);
    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
	Param2f = (struct cte_cmplx *)(macro_cour->param);
    else
	Param2f = NULL;
    panel_create_item(panel_in, PANEL_MESSAGE,
			      PANEL_SHOW_ITEM, TRUE,
			      PANEL_LABEL_X, ATTR_COL(0),
			      PANEL_LABEL_Y, ATTR_ROW(0),
			      PANEL_LABEL_STRING, titre,
			      0);
    if ((flag_exec == MANUEL || flag_exec == FROMTO_AUTO))
	sprintf(rep, "%f", Param2f->reel);
    else
	if (f1 == NULL)
	    rep[0] = 0;
	else
	    sprintf(rep,"%f",*f1);
    cmplx_panel_reel_i = 
	panel_create_item(panel_in, PANEL_TEXT,
			     PANEL_SHOW_ITEM, TRUE,
			     PANEL_LABEL_X, ATTR_COL(1),
			     PANEL_LABEL_Y, ATTR_ROW(2),
			     PANEL_VALUE_DISPLAY_LENGTH, 20,
			     PANEL_VALUE_STORED_LENGTH, 20,
			     PANEL_LABEL_STRING,  str1,
			     PANEL_VALUE, rep,
			     PANEL_NOTIFY_STRING, "\r\n\t\03",
			     PANEL_NOTIFY_PROC, get_from_panel_2_floats,
			     0);
    if ((flag_exec == MANUEL || flag_exec == FROMTO_AUTO))
	sprintf(rep, "%f", Param2f->im);
    else
	if (f2 == NULL)
	    rep[0] = 0;
	else
	    sprintf(rep,"%f",*f2);
    cmplx_panel_imag_i = 
	panel_create_item(panel_in, PANEL_TEXT,
			     PANEL_SHOW_ITEM, TRUE,
			     PANEL_LABEL_X, ATTR_COL(1),
			     PANEL_LABEL_Y, ATTR_ROW(3),
			     PANEL_VALUE_DISPLAY_LENGTH, 20,
			     PANEL_VALUE_STORED_LENGTH, 20,
			     PANEL_LABEL_STRING,  str2,
			     PANEL_VALUE, rep,
			     PANEL_NOTIFY_STRING, "\r\n\t\03",
			     PANEL_NOTIFY_PROC, get_from_panel_2_floats,
			     0);
    window_fit(panel_in);
    window_fit(frame_in);
    Centrer_Frame(frame_in);
    Param2f = (struct cte_cmplx *) window_loop(frame_in);
*/
    return (Param2f);
}

/*****************************************************************************/

int
Confirm(str)
char *str;
{
/*    Panel panel_in;
    Panel_item pi, pi1, pi2;


    frame_in = window_create(frame, FRAME,
				WIN_WIDTH, 1, WIN_HEIGHT, 1,
				FRAME_NO_CONFIRM, TRUE, 0);
    panel_in = window_create(frame_in, PANEL, 
                             PANEL_LABEL_BOLD, TRUE,
                             PANEL_LAYOUT, PANEL_HORIZONTAL,
			     0);

    panel_create_item(panel_in, PANEL_MESSAGE,
			      PANEL_SHOW_ITEM, TRUE,
			      PANEL_LABEL_X, ATTR_COL(0),
			      PANEL_LABEL_Y, ATTR_ROW(0),
			      PANEL_LABEL_STRING, paneltabs[179],
			      0);
    panel_create_item(panel_in, PANEL_MESSAGE,
			      PANEL_SHOW_ITEM, TRUE,
			      PANEL_LABEL_X, ATTR_COL(2),
			      PANEL_LABEL_Y, ATTR_ROW(1),
			      PANEL_LABEL_STRING, str,
			      0);

    pi1 = panel_create_item(panel_in, PANEL_BUTTON,
			      PANEL_LABEL_X, ATTR_COL(0),
			      PANEL_LABEL_Y, ATTR_ROW(2),
                              PANEL_LABEL_IMAGE,panel_button_image(panel_in, "ok",10,0),
                              PANEL_NOTIFY_PROC, proc_ok,
                             0);

    pi2 = panel_create_item(panel_in, PANEL_BUTTON,
			      PANEL_LABEL_X, ATTR_COL(15),
			      PANEL_LABEL_Y, ATTR_ROW(2),
                              PANEL_LABEL_IMAGE,panel_button_image(panel_in, "no",10,0),
                              PANEL_NOTIFY_PROC, proc_annuler,
                             0);
    window_set(frame_in, WIN_MOUSE_XY, 495, 495, 0);
    window_fit(panel_in);
    window_fit(frame_in);
    Centrer_Frame(frame_in);
    window_loop(frame_in);
    return(varconfirm);
*/
}

/*****************************************************************************/

/*static          Panel_setting
get_from_panel_1_int(item, event)
    Panel_item      item;
    Event          *event;

{
    static int N;
    if (event_id(event) == CTRLC)
    {
	flag_break = TRUE;
	window_return(NULL);
	window_destroy(frame_in);
	return ((Panel_setting) 0);
    }
    if (event_id(event) == '\t')
	return (PANEL_NEXT);
    if (panel_get(cmplx_panel_reel_i, PANEL_VALUE) != NULL)
	N = atoi((char *) panel_get(cmplx_panel_reel_i, PANEL_VALUE));
    window_return(&N);
    window_destroy(frame_in);
    return ((Panel_setting) 0);
}
*/
/*****************************************************************************/

void
get_int(titre, str, fff, Adr)
char *titre, *str;
int*fff, *Adr;
{
    char            rep[21];
/*    Panel panel_in;*/
    int N;
    rep[0] = 0;
/*    frame_in = window_create(frame, FRAME,
				WIN_WIDTH, 1, WIN_HEIGHT, 1,
				FRAME_NO_CONFIRM, TRUE, 0);
    panel_in = window_create(frame_in, PANEL, PANEL_LABEL_BOLD,
				TRUE, 0);

    panel_create_item(panel_in, PANEL_MESSAGE,
			      PANEL_SHOW_ITEM, TRUE,
			      PANEL_LABEL_X, ATTR_COL(0),
			      PANEL_LABEL_Y, ATTR_ROW(0),
			      PANEL_LABEL_STRING, titre,
			      0);
    if ((flag_exec == MANUEL || flag_exec == FROMTO_AUTO))
	sprintf(rep, "%d", *((int *)(macro_cour->param)));
    else
	if (fff == NULL)
	    rep[0] = 0;
	else
	    sprintf(rep, "%d", *fff);
    cmplx_panel_reel_i = panel_create_item(panel_in, PANEL_TEXT,
			     PANEL_SHOW_ITEM, TRUE,
			     PANEL_LABEL_X, ATTR_COL(1),
			     PANEL_LABEL_Y, ATTR_ROW(2),
			     PANEL_VALUE_DISPLAY_LENGTH, 20,
			     PANEL_VALUE_STORED_LENGTH, 20,
			     PANEL_LABEL_STRING,  str,
			     PANEL_VALUE, rep,
			     PANEL_NOTIFY_STRING, "\r\n\t\03",
			     PANEL_NOTIFY_PROC, get_from_panel_1_int,
			     0);
    window_fit(panel_in);
    window_fit(frame_in);
    Centrer_Frame(frame_in);
    N = *((int *) window_loop(frame_in));
    if (!flag_break)
	*Adr = N;
*/
}

/*****************************************************************************/

/*static          Panel_setting
get_from_panel_1_float(item, event)
    Panel_item      item;
    Event          *event;

{
    static float N;
    if (event_id(event) == CTRLC)
    {
	flag_break = TRUE;
	window_return(NULL);
	window_destroy(frame_in);
	return ((Panel_setting) 0);
    }
    if (event_id(event) == '\t')
	return (PANEL_NEXT);
    if (panel_get(cmplx_panel_reel_i, PANEL_VALUE) != NULL)
	N = atof((char *) panel_get(cmplx_panel_reel_i, PANEL_VALUE));
    window_return(&N);
    window_destroy(frame_in);
    return ((Panel_setting) 0);
}*/

/*****************************************************************************/

void
get_float(titre, str, fff, Adr)
char *titre, *str;
float *fff, *Adr;
{
    char            rep[21];
/*    Panel panel_in;
    float N;
    rep[0] = 0;
    frame_in = window_create(frame, FRAME,
				WIN_WIDTH, 1, WIN_HEIGHT, 1,
				FRAME_NO_CONFIRM, TRUE, 0);
    panel_in = window_create(frame_in, PANEL, PANEL_LABEL_BOLD,
				TRUE, 0);

    panel_create_item(panel_in, PANEL_MESSAGE,
			      PANEL_SHOW_ITEM, TRUE,
			      PANEL_LABEL_X, ATTR_COL(0),
			      PANEL_LABEL_Y, ATTR_ROW(0),
			      PANEL_LABEL_STRING, titre,
			      0);
    if ((flag_exec == MANUEL || flag_exec == FROMTO_AUTO))
	N = *((float *)(macro_cour->param));
    else
	if (fff == NULL)
	    N = 0.0;
	else
	    N = *fff;
    sprintf(rep, "%f", N);
    cmplx_panel_reel_i = panel_create_item(panel_in, PANEL_TEXT,
			     PANEL_SHOW_ITEM, TRUE,
			     PANEL_LABEL_X, ATTR_COL(1),
			     PANEL_LABEL_Y, ATTR_ROW(2),
			     PANEL_VALUE_DISPLAY_LENGTH, 20,
			     PANEL_VALUE_STORED_LENGTH, 20,
			     PANEL_LABEL_STRING,  str,
			     PANEL_VALUE, rep,
			     PANEL_NOTIFY_STRING, "\r\n\t\03",
			     PANEL_NOTIFY_PROC, get_from_panel_1_float,
			     0);
    window_fit(panel_in);
    window_fit(frame_in);
    Centrer_Frame(frame_in);
    N = *((float *) window_loop(frame_in));
    if (!flag_break)
	*Adr = N;
*/
}


/*****************************************************************************/

struct mati_s *
get_N_floats(str1, str2)
char *str1, *str2;
{
    struct mati_s *mat;
/*    int N;
    char rep[21];
    frame_in = window_create(frame, FRAME, FRAME_NO_CONFIRM, TRUE, 0);
    N_Floats_panel = window_create(frame_in, PANEL, PANEL_LABEL_BOLD, TRUE, 0);
    if ((flag_exec == MANUEL)||(flag_exec == FROMTO_AUTO))
	mat = (struct mati_s *)(macro_cour->param);
    else
	mat = NULL;

    panel_create_item(N_Floats_panel, PANEL_MESSAGE,
			PANEL_LABEL_X, ATTR_COL(3),
			PANEL_LABEL_Y, ATTR_ROW(0),
			PANEL_LABEL_STRING, str1,
			0);
    for (N = 0 ; N < Gel_Global.N_Bandes ; N++)
    {
	if ((flag_exec == MANUEL)||(flag_exec == FROMTO_AUTO))
	    sprintf(rep,"%f",mat->Mat[N]);
	else
	    rep[0] = 0;
	sprintf(Str_x,str2,N+1);
	panel_create_item(N_Floats_panel, PANEL_TEXT,
			    PANEL_LABEL_X, ATTR_COL(0),
			    PANEL_LABEL_Y, ATTR_COL(N+1),
			    PANEL_VALUE_DISPLAY_LENGTH, 20,
			    PANEL_VALUE_STORED_LENGTH, 20,
			    PANEL_LABEL_STRING, Str_x,
			    PANEL_VALUE, rep,
			    PANEL_NOTIFY_STRING, "\r\t\n\03",
			    PANEL_NOTIFY_PROC, lire_N_floats,
			    0);
    }
    window_fit(N_Floats_panel);
    window_fit(frame_in);
    Centrer_Frame(frame_in);
    mat = (struct mati_s *)window_loop(frame_in);
*/
    return(mat);
}
/*****************************************************************************/

void
Read_Pics(F)
FILE *F;
{
    Gel_Pic_type *pic_p, *pic_c;
    int NP, B = -1;
    pic_p = NULL;
    Dir_Pics = (Gel_Pic_type **)malloc(Gel_Global.N_Bandes*sizeof(char *));
    if (Dir_Pics == NULL)
    {
	write_erreur(900);
	return;
    }
    memset(Dir_Pics,0,Gel_Global.N_Bandes*sizeof(char *));
    for (NP = 0 ; NP < Gel_Global.Total_Pics ; NP++)
    {
	pic_c = (Gel_Pic_type *)malloc(sizeof(Gel_Pic_type));
	if (pic_c == NULL)
	{
	    write_erreur(900);
	    return;
	}
	if (fread(&(pic_c->V),sizeof(Values_Gel_Pic_type),1,F) != 1)
	{
	    write_erreur(952);
	    return;
	}
	pic_c->Next = NULL;
	if (pic_p == NULL)
	    Gel_Pics_List = pic_c;
	else
	    pic_p->Next = (struct Gel_Pic_type *)pic_c;
	if (pic_c->V.Bande != B)
	{
	    B = pic_c->V.Bande;
	    *(Dir_Pics+B) = pic_c;
	}
	pic_p = pic_c;
    }
}

/*****************************************************************************/

void
Write_Pics(F)
FILE *F;
{
    Gel_Pic_type *pic;
    for (pic = Gel_Pics_List; pic != NULL ; pic = (Gel_Pic_type *)pic->Next)
	if (fwrite(&(pic->V),sizeof(Values_Gel_Pic_type),1,F) != 1)
	{
	    write_erreur(952);
	    return;
	}
}

/*****************************************************************************/

void
Update_Menu_Active()
{
/*    Menu_item item;
    Menu sub_menu;
    int bbool;
    if (flag_creer)
    {
	item = menu_get(mgel1dtool, MENU_NTH_ITEM, 2);	/* Afficher gel	    */
/*	menu_set(item, MENU_INACTIVE, FALSE, 0);
	item = menu_get(mgel1dtool, MENU_NTH_ITEM, 3);	/* Front. preest.   */
/*	menu_set(item, MENU_INACTIVE, FALSE, 0);
	item = menu_get(mgel1dtool, MENU_NTH_ITEM, 4);	/* Front. precises  */
/*	menu_set(item, MENU_INACTIVE, FALSE, 0);
	item = menu_get(mgel1dtool, MENU_NTH_ITEM, 5);	/* Profils	    */
/*	menu_set(item, MENU_INACTIVE, FALSE, 0);
	item = menu_get(mgel1dtool, MENU_NTH_ITEM, 6);	/* Lisser	    */
/*	menu_set(item, MENU_INACTIVE, FALSE, 0);
	item = menu_get(mgel1dtool, MENU_NTH_ITEM, 7);	/* Traiter pics	    */
/*	menu_set(item, MENU_INACTIVE, FALSE, 0);
	item = menu_get(mgel1dtool, MENU_NTH_ITEM, 9);	/* Sauver gel	    */
/*	menu_set(item, MENU_INACTIVE, FALSE, 0);
	item = menu_get(mgel1_1, MENU_NTH_ITEM, 1);	/* Fr. preest. calc.*/
/*	menu_set(item, MENU_INACTIVE, FALSE, 0);
	item = menu_get(mgel1_1, MENU_NTH_ITEM, 2);	/* Fr. preest. aff. */
/*	menu_set(item, MENU_INACTIVE, FALSE, 0);
	item = menu_get(mgel1_1, MENU_NTH_ITEM, 3);	/* Fr. preest. cor. */
/*	menu_set(item, MENU_INACTIVE, TRUE, 0);
	item = menu_get(mgel1_2, MENU_NTH_ITEM, 2);	/* Fr. prec. aff.   */
/*	menu_set(item, MENU_INACTIVE, FALSE, 0);
	item = menu_get(mgel1_2, MENU_NTH_ITEM, 3);	/* Fr. preest. cor. */
/*	menu_set(item, MENU_INACTIVE, TRUE, 0);
	item = menu_get(mgel1_3, MENU_NTH_ITEM, 2);	/* Gel Ideal	    */
/*	menu_set(item, MENU_INACTIVE, FALSE, 0);
	item = menu_get(mgel1_3, MENU_NTH_ITEM, 3);	/* Afficher 1 prof. */
/*	menu_set(item, MENU_INACTIVE, FALSE, 0);
	item = menu_get(mgel1_4, MENU_NTH_ITEM, 2);	/* Ajouter pic	    */
/*	menu_set(item, MENU_INACTIVE, TRUE, 0);
	item = menu_get(mgel1_4, MENU_NTH_ITEM, 3);	/* Supprimer pic    */
/*	menu_set(item, MENU_INACTIVE, TRUE, 0);
	item = menu_get(mgel1_4, MENU_NTH_ITEM, 4);	/* Supprimer N pics  */
/*	menu_set(item, MENU_INACTIVE, TRUE, 0);
	return;
    }
    if (Prplan == -1)
    {
	item = menu_get(mgel1dtool, MENU_NTH_ITEM, 2);	/* Afficher gel	    */
/*	menu_set(item, MENU_INACTIVE, TRUE, 0);
	item = menu_get(mgel1dtool, MENU_NTH_ITEM, 3);	/* Front. preest.   */
/*	menu_set(item, MENU_INACTIVE, TRUE, 0);
	item = menu_get(mgel1dtool, MENU_NTH_ITEM, 4);	/* Front. precises  */
/*	menu_set(item, MENU_INACTIVE, TRUE, 0);
	item = menu_get(mgel1dtool, MENU_NTH_ITEM, 5);	/* Profils	    */
/*	menu_set(item, MENU_INACTIVE, TRUE, 0);
	item = menu_get(mgel1dtool, MENU_NTH_ITEM, 6);	/* Lisser	    */
/*	menu_set(item, MENU_INACTIVE, TRUE, 0);
	item = menu_get(mgel1dtool, MENU_NTH_ITEM, 9);	/* Sauver gel	    */
/*	menu_set(item, MENU_INACTIVE, TRUE, 0);
	bbool = TRUE;
    }
    else
    {
	item = menu_get(mgel1dtool, MENU_NTH_ITEM, 2);	/* Afficher gel	    */
/*	menu_set(item, MENU_INACTIVE, FALSE, 0);
	item = menu_get(mgel1dtool, MENU_NTH_ITEM, 3);	/* Front. preest.   */
/*	menu_set(item, MENU_INACTIVE, FALSE, 0);
	item = menu_get(mgel1_1, MENU_NTH_ITEM, 1);	/* Fr. preest. calc.*/
/*	menu_set(item, MENU_INACTIVE, FALSE, 0);
    }
    if (Frontieres_Preest == NULL)
    {
	item = menu_get(mgel1dtool, MENU_NTH_ITEM, 4);	/* Front. precises  */
/*	menu_set(item, MENU_INACTIVE, TRUE, 0);
	item = menu_get(mgel1_1, MENU_NTH_ITEM, 2);	/* Fr. preest. aff. */
/*	menu_set(item, MENU_INACTIVE, TRUE, 0);
	item = menu_get(mgel1_1, MENU_NTH_ITEM, 3);	/* Fr. preest. cor. */
/*	menu_set(item, MENU_INACTIVE, TRUE, 0);
    }
    else
    {
	item = menu_get(mgel1_1, MENU_NTH_ITEM, 2);	/* Fr. preest. aff. */
/*	menu_set(item, MENU_INACTIVE, FALSE, 0);
	item = menu_get(mgel1_1, MENU_NTH_ITEM, 3);	/* Fr. preest. cor. */
/*	menu_set(item, MENU_INACTIVE, FALSE, 0);
	item = menu_get(mgel1dtool, MENU_NTH_ITEM, 4);	/* Front. precises  */
/*	menu_set(item, MENU_INACTIVE, FALSE, 0);
	if (Gel_Global.N_Bandes)
	{
	    item = menu_get(mgel1_cor1, MENU_NTH_ITEM, 2);
	    menu_set(item, MENU_INACTIVE, FALSE, 0);	/* Supprimer bande  */
/*	    item = menu_get(mgel1_cor1, MENU_NTH_ITEM, 3);
	    menu_set(item, MENU_INACTIVE, FALSE, 0);	/* Deplacer front.  */
/*	}
	else
	{
	    item = menu_get(mgel1_cor1, MENU_NTH_ITEM, 2);
	    menu_set(item, MENU_INACTIVE, TRUE, 0);	/* Supprimer bande  */
/*	    item = menu_get(mgel1_cor1, MENU_NTH_ITEM, 3);
	    menu_set(item, MENU_INACTIVE, TRUE, 0);	/* Deplacer front.  */
/*	}
    }
    if (Coefficients == NULL)
    {
	item = menu_get(mgel1_2, MENU_NTH_ITEM, 2);	/* Fr. prec. aff.   */
/*	menu_set(item, MENU_INACTIVE, TRUE, 0);
	item = menu_get(mgel1_2, MENU_NTH_ITEM, 3);	/* Fr. preest. cor. */
/*	menu_set(item, MENU_INACTIVE, TRUE, 0);
	item = menu_get(mgel1dtool, MENU_NTH_ITEM, 5);	/* Profils	    */
/*	menu_set(item, MENU_INACTIVE, TRUE, 0);
    }
    else
    {
	item = menu_get(mgel1_2, MENU_NTH_ITEM, 2);	/* Fr. prec. aff.   */
/*	menu_set(item, MENU_INACTIVE, FALSE, 0);
	item = menu_get(mgel1_2, MENU_NTH_ITEM, 3);	/* Fr. preest. cor. */
/*	menu_set(item, MENU_INACTIVE, FALSE, 0);
	item = menu_get(mgel1dtool, MENU_NTH_ITEM, 5);	/* Profils	    */
/*	menu_set(item, MENU_INACTIVE, FALSE, 0);
    }
    if (PrHist_Aff == NULL)
    {
	item = menu_get(mgel1dtool, MENU_NTH_ITEM, 6);	/* Lisser	    */
/*	menu_set(item, MENU_INACTIVE, TRUE, 0);
	item = menu_get(mgel1dtool, MENU_NTH_ITEM, 9);	/* Sauver gel	    */
/*	menu_set(item, MENU_INACTIVE, TRUE, 0);
	item = menu_get(mgel1_3, MENU_NTH_ITEM, 2);	/* Gel Ideal	    */
/*	menu_set(item, MENU_INACTIVE, TRUE, 0);
	item = menu_get(mgel1_3, MENU_NTH_ITEM, 3);	/* Afficher 1 prof. */
/*	menu_set(item, MENU_INACTIVE, TRUE, 0);
	bbool = TRUE;
    }
    else
    {
	item = menu_get(mgel1dtool, MENU_NTH_ITEM, 6);	/* Lisser	    */
/*	menu_set(item, MENU_INACTIVE, FALSE, 0);
	item = menu_get(mgel1dtool, MENU_NTH_ITEM, 9);	/* Sauver gel	    */
/*	menu_set(item, MENU_INACTIVE, FALSE, 0);
	item = menu_get(mgel1_3, MENU_NTH_ITEM, 2);	/* Gel Ideal	    */
/*	menu_set(item, MENU_INACTIVE, FALSE, 0);
	item = menu_get(mgel1_3, MENU_NTH_ITEM, 3);	/* Afficher 1 prof. */
/*	menu_set(item, MENU_INACTIVE, FALSE, 0);
	bbool = FALSE;
    }
    if (Profil_Aff_1 == -1)
    {
	item = menu_get(mgel1dtool, MENU_NTH_ITEM, 7);	/* Traiter pics	    */
/*	menu_set(item, MENU_INACTIVE, TRUE, 0);
	item = menu_get(mgel1dtool, MENU_NTH_ITEM, 7);	/* Traiter pics	    */
/*	menu_set(item, MENU_INACTIVE, bbool, 0);
	item = menu_get(mgel1_4, MENU_NTH_ITEM, 2);	/* Ajouter pic	    */
/*	menu_set(item, MENU_INACTIVE, TRUE, 0);
	item = menu_get(mgel1_4, MENU_NTH_ITEM, 3);	/* Supprimer pic    */
/*	menu_set(item, MENU_INACTIVE, TRUE, 0);
	item = menu_get(mgel1_4, MENU_NTH_ITEM, 4);	/* Supprimer N pics  */
/*	menu_set(item, MENU_INACTIVE, TRUE, 0);
    }
    else
    {
	item = menu_get(mgel1dtool, MENU_NTH_ITEM, 7);	/* Traiter pics	    */
/*	menu_set(item, MENU_INACTIVE, bbool, 0);
	item = menu_get(mgel1_4, MENU_NTH_ITEM, 2);	/* Ajouter pic	    */
/*	menu_set(item, MENU_INACTIVE, FALSE, 0);
	if ((Gel_Pics_List != NULL) && (*(Dir_Pics+Profil_Aff_1) != NULL))
	{
	    item = menu_get(mgel1_4, MENU_NTH_ITEM, 3);	/* Supprimer pic    */
/*	    menu_set(item, MENU_INACTIVE, FALSE, 0);
	    item = menu_get(mgel1_4, MENU_NTH_ITEM, 4);	/* Supprimer N pics  */
/*	    menu_set(item, MENU_INACTIVE, FALSE, 0);
	}
	else
	{
	    item = menu_get(mgel1_4, MENU_NTH_ITEM, 3);	/* Supprimer pic    */
/*	    menu_set(item, MENU_INACTIVE, TRUE, 0);
	    item = menu_get(mgel1_4, MENU_NTH_ITEM, 4);	/* Supprimer N pics  */
/*	    menu_set(item, MENU_INACTIVE, TRUE, 0);
	}
    }*/
}


/*****************************************************************************/

static void
Delete_N_Pics(Y1, Y2)
int Y1, Y2;
{
    int Deleted = 0;
    Gel_Pic_type *pic_p, *pic_c, *pic_s;
    pic_p = NULL;
    pic_c = Gel_Pics_List;
    for ( ; ; )
    {
	if ((pic_c == NULL) || (pic_c->V.Bande > Profil_Aff_1))
	{
	    write_erreur(959);
	    return;
	}
	if ((pic_c->V.Bande == Profil_Aff_1) && (pic_c->V.Max >= Y1))
	    break;
	pic_p = pic_c;
	pic_c = (Gel_Pic_type *)(pic_c->Next);
    }
    for ( ; ; )
    {
	if ((pic_c == NULL) || (pic_c->V.Bande != Profil_Aff_1) ||
	    (pic_c->V.Min > Y2))
	    break;
	pic_s = (Gel_Pic_type *)(pic_c->Next);
	sprintf(Str_x,mastertabs[74],
	    	Profil_Aff_1+1,pic_c->V.Pic);
	write_master(Str_x);
	free(pic_c);
	Gel_Global.Total_Pics--;
	Deleted = 1;
	pic_c = pic_s;
    }
    if (!Deleted)
    {
	write_erreur(959);
	return;
    }
    if (pic_p == NULL)
    {
	Gel_Pics_List = pic_c;
	if ((pic_c == NULL) || (pic_c->V.Bande != Profil_Aff_1))
	    *(Dir_Pics+Profil_Aff_1) = NULL;
	else
	    *(Dir_Pics+Profil_Aff_1) = pic_c;
    }
    else
    {
	if (*(Dir_Pics+Profil_Aff_1) == (Gel_Pic_type *)pic_p->Next)
	    if ((pic_c == NULL) || (pic_c->V.Bande != Profil_Aff_1))
		*(Dir_Pics+Profil_Aff_1) = NULL;
	    else
		*(Dir_Pics+Profil_Aff_1) = pic_c;
	pic_p->Next = (struct Gel_Pic_type *)pic_c;
    }
}

/*****************************************************************************/

static void
Delete_1_Pic(Y)
int Y;
{
    Gel_Pic_type *pic_p, *pic_c, *pic_s;
    pic_p = NULL;
    pic_c = Gel_Pics_List;
    for ( ; ; )
    {
	Test_Error(pic_c == NULL);
	if ((pic_c->V.Bande == Profil_Aff_1) &&
	    (pic_c->V.Min <= Y) && (pic_c->V.Max >= Y))
	    break;
	pic_p = pic_c;
	pic_c = (Gel_Pic_type *)(pic_c->Next);
    }
    sprintf(Str_x,mastertabs[74],
		Profil_Aff_1+1,pic_c->V.Pic);
    write_master(Str_x);
    pic_s = (Gel_Pic_type *)(pic_c->Next);
    if (*(Dir_Pics+Profil_Aff_1) == pic_c)
	if ((pic_s == NULL) || (pic_s->V.Bande != Profil_Aff_1))
	    *(Dir_Pics+Profil_Aff_1) = NULL;
	else
	    *(Dir_Pics+Profil_Aff_1) = pic_s;
    free(pic_c);
    if (pic_p == NULL)
	Gel_Pics_List = pic_s;
    else
	pic_p->Next = (struct Gel_Pic_type *)pic_s;
    Gel_Global.Total_Pics--;
}

/*****************************************************************************/

static void
Insert_1_Pic(Y1, Y2)
int Y1, Y2;
{
    Gel_Pic_type *Pic;
    int Y;
    float FF, S;
    Pic = (Gel_Pic_type *)malloc(sizeof(Gel_Pic_type));
    if (Pic == NULL)
    {
	write_erreur(900);
	return;
    }
    if (Dir_Pics == NULL)
    {
	Dir_Pics = (Gel_Pic_type **)malloc(Gel_Global.N_Bandes*sizeof(char *));
	if (Dir_Pics == NULL)
	{
	    write_erreur(900);
	    return;
	}
	memset(Dir_Pics,0,Gel_Global.N_Bandes*sizeof(char *));
    }
    Pic->V.Min = Y1;
    Pic->V.Max = Y2;
    Pic->V.Bande = Profil_Aff_1;
    Pic->V.Pic = Y1;
    Pic->V.PicValue = *(PrHistogr+PrYMax*Profil_Aff_1+Y1);
    Pic->V.S = *(Largeurs+PrYMax*Profil_Aff_1+Y1);
    for (Y = Y1+1 ; Y <= Y2 ; Y++)
    {
	FF = *(PrHistogr+PrYMax*Profil_Aff_1+Y);
	if (Pic->V.PicValue < FF)
	{
	    Pic->V.PicValue = FF;
	    Pic->V.Pic = Y;
	}
	Pic->V.S += *(Largeurs+PrYMax*Profil_Aff_1+Y);
    }
    Gel_Global.Total_Pics++;
    sprintf(Str_x,mastertabs[75],
	    	Profil_Aff_1+1,Y1, Y2);
    write_master(Str_x);
    if (PPic_p == NULL)
    {
	Gel_Pics_List = Pic;
	Pic->Next = (struct Gel_Pic_type *)PPic_c;
	*(Dir_Pics+Profil_Aff_1) = Pic;
	return;
    }
    PPic_p->Next = (struct Gel_Pic_type *)Pic;
    Pic->Next = (struct Gel_Pic_type *)PPic_c;
    if (PPic_p->V.Bande < Profil_Aff_1)
	*(Dir_Pics+Profil_Aff_1) = Pic;
}

/*****************************************************************************/

static void
Trouver_Etendue(Y)
int Y;
{
    PPic_p = NULL;
    PPic_c = Gel_Pics_List;
    for ( ; ; )
    {
	if ((PPic_c == NULL) || 
	    (PPic_c->V.Bande > Profil_Aff_1) || 
	    (PPic_c->V.Bande == Profil_Aff_1) && (PPic_c->V.Min > Y))
	    break;
	PPic_p = PPic_c;
	PPic_c = (Gel_Pic_type *)PPic_c->Next;
    }
    if ((PPic_p == NULL) && (PPic_c == NULL))
    {
	YY1 = 0;
	YY2 = PrYMax-1;
	return;
    }
    if ((PPic_p == NULL) || (PPic_p->V.Bande < Profil_Aff_1))
    {
	if (PPic_c == NULL)
	{
	    YY1 = 0;
	    YY2 = PrYMax-1;
	    return;
	}
	else if (PPic_c->V.Bande == Profil_Aff_1)
	{
	    YY1 = 0;
	    YY2 = PPic_c->V.Min - 2;
	    return;
	}
	else
	{
	    YY1 = 0;
	    YY2 = PrYMax-1;
	    return;
	}
    }
    YY1 = PPic_p->V.Max+2;
    if ((PPic_c == NULL) || (PPic_c->V.Bande > Profil_Aff_1))
	YY2 = PrYMax-1;
    else
	YY2 = YY2 = PPic_c->V.Min - 2;
}

/*****************************************************************************/

/*void
profil_Notify_Proc(win, event, arg)
    Window          win;
    Event          *event;
    caddr_t         arg;
{
    int event_code, X, Y, NP;
    float P1, P2;
    Gel_Pic_type  *pic;
    if (Profil_Aff_1 == -1)
	 return;
    Y = event_y(event)-Pro_Offset;
    if (Y < 0)
	return;
    X = event_x(event);
    event_code = event_id(event);
    switch (event_code) {
	case MS_RIGHT :
	    switch (regime_corr) {
		case 52: case 53: case 54:
		    interruption();
	    }
	    Nearest = -1;
	    regime_corr = 0;
	    break;
	case LOC_DRAG:
	    if ((regime_corr == 54) && (Nearest != -1) && (YYOld != Y))
	    {
		pw_batch_on(pro_pixwin);
		if ((!DDY) || ((DDY > 0) && (Y - YYOld > 0)) ||
		    ((DDY < 0) && (Y - YYOld < 0)))
		    pw_writebackground(pro_pixwin,0,YYOld+Pro_Offset,
			260,1,PIX_NOT(PIX_SRC^PIX_DST));
		DDY = Y - YYOld;
		pw_writebackground(pro_pixwin,0,min(YYOld,Y)+Pro_Offset,
			260,abs(YYOld-Y)+1,PIX_NOT(PIX_SRC^PIX_DST));
		YYOld = Y;
		pw_batch_off(pro_pixwin);
		break;
	    }
	    if ((regime_corr == 52) && (Nearest != -1) && (YYOld != Y))
	    {
		pw_batch_on(pro_pixwin);
		pw_writebackground(pro_pixwin,0,min(YYOld,Nearest)+Pro_Offset,
			259,abs(YYOld-Nearest),PIX_NOT(PIX_SRC^PIX_DST));
		YYOld = max(YY1,min(YY2,Y));
		pw_writebackground(pro_pixwin,0,min(YYOld,Nearest)+Pro_Offset,
			259,abs(YYOld-Nearest),PIX_NOT(PIX_SRC^PIX_DST));
		pw_batch_off(pro_pixwin);
		break;
	    }
	    break;
	case MS_LEFT :
	    switch (regime_corr) {
		case 53:
		    if (pw_get(pro_pixwin,X,Y+Pro_Offset) != 131)
			break;
		    Delete_1_Pic(Y);
		    X = Profil_Aff_1;
		    Profil_Aff_1 = 9999;
		    Affiche_Profil_1(X);
		    Update_Menu_Active();
		    regime_corr = 0;
		    break;
		case 52:
		    if ((Nearest == -1) && event_is_down(event))
		    {
			if (pw_get(pro_pixwin,0,Y+Pro_Offset) == 131)
			{
			    write_erreur(960);
			    regime_corr = 0;
			    break;
			}
			Nearest = Y;
			pw_vector(pro_pixwin,0,Y+Pro_Offset,259,Y+Pro_Offset,
				    PIX_SRC^PIX_DST,255);
			Trouver_Etendue(Y);
			YYOld = Y;
			break;
		    }
		    else if (!event_is_down(event))
		    {
			Y = max(YY1,min(YY2,Y));
			Insert_1_Pic(min(Nearest,Y),max(Nearest,Y));
			X = Profil_Aff_1;
			Profil_Aff_1 = 9999;
			Affiche_Profil_1(X);
			Update_Menu_Active();
			Nearest = -1;
			regime_corr = 0;
			Update_Menu_Active();
		    }
		    break;
		case 54:
		    if ((Nearest == -1) && event_is_down(event))
		    {
			Nearest = Y;
			pw_vector(pro_pixwin,0,Y+Pro_Offset,259,Y+Pro_Offset,
				    PIX_SRC^PIX_DST,255);
			YYOld = Y;
			DDY = 0;
			break;
		    }
		    else if (!event_is_down(event))
		    {
			Delete_N_Pics(min(Nearest,Y),max(Nearest,Y));
			X = Profil_Aff_1;
			Profil_Aff_1 = 9999;
			Affiche_Profil_1(X);
			Update_Menu_Active();
			Nearest = -1;
			regime_corr = 0;
			Update_Menu_Active();
		    }
		    break;
	    }
	    break;
	case LOC_MOVE:
	    if (pw_get(pro_pixwin,0,Y+Pro_Offset) != 131)
	    {
		sprintf(Str_x,"X = %03d, Y = %04d                    ",X,Y);
		pw_text(pro_pixwin,10,52,PIX_SRC,NULL,Str_x);
		sprintf(Str_x,"                                    ");
	    }
	    else
	    {
		pic = *(Dir_Pics + Profil_Aff_1);
		NP = 1;
		for ( ; ; NP ++)
		{
		    Test_Error(pic == NULL);
		    Test_Error(pic->V.Bande != Profil_Aff_1);
		    if ((pic->V.Min <= Y) && (pic->V.Max >= Y))
			break;
		    pic = (Gel_Pic_type *)pic->Next;
		}
		P1 = pic->V.S / Gel_Global.Somme_NGris[Profil_Aff_1];
		P2 = Gel_Global.Matiere_1[Profil_Aff_1] * P1;
		sprintf(Str_x,mastertabs[76],X,Y, NP);
		pw_text(pro_pixwin,10,52,PIX_SRC,NULL,Str_x);
		sprintf(Str_x,mastertabs[77], 100.0*P1, '%', P2);
	    }
	    pw_text(pro_pixwin,5,67,PIX_SRC,NULL,Str_x);
	    break;
    }
}
*/
/*****************************************************************************/

void
free_Gel_Pics_List()
{
    Gel_Pic_type *Pic_c, *Pic_next;
    free_if(Dir_Pics);
    Pic_c = Gel_Pics_List;
    for( ; ; )
    {
	if (Pic_c == NULL)
	    break;
	Pic_next = (Gel_Pic_type *)(Pic_c->Next);
	free(Pic_c);
	Pic_c = Pic_next;
    }
    Gel_Pics_List = NULL;
    Pic_Courant = NULL;
    Gel_Global.Total_Pics = 0;
}

/*****************************************************************************/

int Find_Pics_Lane_New(NB)
int NB;
{
    int First = 1, Into = 0, Y, MMin, PPic;
    float *Adrf, *Adrf1, Area, PPicVal, Val;
    Gel_Pic_type *Pic_1;
    Adrf1 = Largeurs+PrYMax*NB+1;
    for (Y = 1 , Adrf = PrHist_Aff+PrYMax*NB ; 
	    Y < PrYMax-1 ; Y++ , Adrf++, Adrf1++)
    {
	Val = *Adrf - Gel_Global.fMin;
	if (*Adrf + *Adrf - *(Adrf-1) - *(Adrf+1) >= 0.0)
	{
	    if (Into)
	    {
		Area += *Adrf1;
		if (PPicVal < Val)
		{
		    PPicVal = Val;
		    PPic = Y;
		}
	    }
	    else
	    {
		Into = 1;
		Area = *Adrf1;
		MMin = Y;
		PPic = Y;
		PPicVal = Val;
	    }
	}
	else
	    if (Into)
	    {
		Into = 0;
		if ( (PPicVal >= Gel_Global.Threshold_Height) && 
			(Area >= Gel_Global.Threshold_Area))
		{
		    Pic_1 = (Gel_Pic_type *)malloc(sizeof(Gel_Pic_type));
		    if (Pic_1 == NULL)
		    {
			write_erreur(900);
			return(1);
		    }
		    Pic_1->V.Bande = NB;
		    Pic_1->V.Min = MMin;
		    Pic_1->V.Pic = PPic;
		    Pic_1->V.Max = Y-1;
		    Pic_1->V.PicValue = PPicVal;
		    Pic_1->V.S = Area;
		    Pic_1->Next = NULL;
		    if (First)
		    {
			First = 0;
			*(Dir_Pics+NB) = Pic_1;
		    }
		    if (Pic_Courant == NULL)
			Gel_Pics_List = Pic_1;
		    else
			Pic_Courant->Next = (struct Gel_Pic_type *)Pic_1;
		    Pic_Courant = Pic_1;
		    Gel_Global.Total_Pics ++;
		}
	    }
    }
    if (Into && (Area >= Gel_Global.Threshold_Area))
    {
	Pic_1 = (Gel_Pic_type *)malloc(sizeof(Gel_Pic_type));
	if (Pic_1 == NULL)
	{
	    write_erreur(900);
	    return(1);
	}
	Pic_1->V.Bande = NB;
	Pic_1->V.Min = MMin;
	Pic_1->V.Pic = PPic;
	Pic_1->V.Max = Y-1;
	Pic_1->V.PicValue = PPicVal;
	Pic_1->V.S = Area;
	Pic_1->Next = NULL;
	if (First)
	{
	    First = 0;
	    *(Dir_Pics+NB) = Pic_1;
	}
	if (Pic_Courant == NULL)
	    Gel_Pics_List = Pic_1;
	else
	    Pic_Courant->Next = (struct Gel_Pic_type *)Pic_1;
	Pic_Courant = Pic_1;
	Gel_Global.Total_Pics ++;
    }
    return(0);
}

/*****************************************************************************/

void
Find_All_Pics()
{
    int N;
    if (PrHist_Aff == NULL)
    {
	write_erreur(957);
	return;
    }
    free_Gel_Pics_List();
    Dir_Pics = (Gel_Pic_type **)malloc(Gel_Global.N_Bandes*sizeof(char *));
    memset(Dir_Pics,0,Gel_Global.N_Bandes*sizeof(char *));
    if (Dir_Pics == NULL)
    {
	write_erreur(900);
	return;
    }
    for (N = 0 ; N < Gel_Global.N_Bandes ; N++)
	if (Find_Pics_Lane_New(N))
	    break;
    N = Profil_Aff_1;
    if (N != -1)
    {
	Profil_Aff_1 = 9990;
	Affiche_Profil_1(N);
    }
}

/*****************************************************************************/

void
Cumuler_NGris()
{
    int Y, N;
    float *Adr1 = Largeurs, *Adr2 = PrHistogr;
    for (N = 0 ; N < Gel_Global.N_Bandes ; N++)
    {
	Gel_Global.Somme_NGris[N] = 0.0;
	for (Y = 0 ; Y < PrYMax ; Y++ , Adr1++ , Adr2++)
	{
	    *Adr1 *= *Adr2 - Gel_Global.fMin;
	    Gel_Global.Somme_NGris[N] += *(Adr1);
	}
    }
}

/*****************************************************************************/
/*
float
Calculer_Moyenne_float(N,Y)
int N, Y;
{
    int ZMin, ZMax, NN, Z;
    float S, *Adrf;
    ZMin = max(0,Y-Gel_Global.Lissage);
    ZMax = min(PrYMax,Y+Gel_Global.Lissage+1);
    Adrf = PrHistogr+N*PrYMax+ZMin;
    NN = ZMax - ZMin;
    S = 0.0;
    for (Z = ZMin ; Z < ZMax ; Z++ , Adrf++)
	S = S + *Adrf;
    return((float)(S/(float)NN));
}
*/

/*****************************************************************************/

float
Calculer_Moyenne_float_Opt(N,Y)
int N, Y;
{
    int Y_Max, YY;
    if (!Y)
    {
	float *Adrf;
	Adr_L = PrHistogr + N*PrYMax;
	Adrf = Adr_L;
	Sigma_Moy = 0.0;
	N_Sigma = min(Gel_Global.Lissage+1,PrYMax);
	Adr_R = Adr_L + N_Sigma;
	for (YY = 0 ; YY < N_Sigma ; YY++ , Adrf++)
	    Sigma_Moy += *Adrf;
	return(Sigma_Moy/(float)N_Sigma);
    }
    if (Y <= Gel_Global.Lissage)
	if (Y+Gel_Global.Lissage < PrYMax)
	{
	    N_Sigma++;
	    Sigma_Moy += *Adr_R;
	    Adr_R++;
	    return(Sigma_Moy/(float)N_Sigma);
	}
	else
	    return(Sigma_Moy/(float)N_Sigma);
    if (Y < PrYMax - Gel_Global.Lissage)
    {
	Sigma_Moy += *Adr_R - *Adr_L;
	Adr_L++;
	Adr_R++;
	return(Sigma_Moy/(float)N_Sigma);
    }
    Sigma_Moy -= *Adr_L;
    Adr_L++;
    N_Sigma--;
    return(Sigma_Moy/(float)N_Sigma);
}

/*****************************************************************************/

void
Proc_Lissage_Gel(Lis_New)
int Lis_New;
{
    int P, N, Y;
    if (PrHist_Aff == NULL)
    {
	write_erreur(957);
	return;
    }
    if (Gel_Global.Lissage == Lis_New)
	return;
    Gel_Global.Lissage = Lis_New;
    if (Gel_Global.Lissage)
	for (N = 0 ; N < Gel_Global.N_Bandes ; N++)
	{
/*float F1, F2, Delta; */
	    for (Y = 0 ; Y < PrYMax ; Y++)
	    {
		*(PrHist_Aff + N * PrYMax + Y) =
		    Calculer_Moyenne_float_Opt(N,Y);
/*F1 = *(PrHist_Aff + N * PrYMax + Y);
F2 = Calculer_Moyenne_float(N,Y);
Delta = F1 - F2;
if (Delta<0.0) Delta = -Delta;
if (Delta>0.001) printf("%c**** %3d %f %f %f\n",7,Y,F1,F2,Delta); */
	    }
	}
    else
        memcpy(PrHist_Aff, PrHistogr, Gel_Global.N_Bandes*sizeof(float)*PrYMax);
    if (Profil_Aff_1 != -1)
    {
        P = Profil_Aff_1;
	Profil_Aff_1 = 9999;
	Affiche_Profil_1(P);
    }
}

/*****************************************************************************/


void
proc_find_max_gel(n_menu, fn, mati, Paramf, Param2f)
int n_menu;
struct fname *fn;
struct mati_s *mati;
float *Paramf;
struct cte_cmplx *Param2f;

{
    struct commande *com;
    float Fff;
    int Macro_exist = 0, Pr, N;
    char *Adr_char, bb[40];
    int Height;

    Update_Menu_Active();
    if ((n_menu ==1) || (n_menu >= 5))
	Macro_exist = 1;

    Nearest = -1;
    regime_corr = 0;
    X_Move = -1;
    N_Points = -1;
    switch (n_menu) {
      case 1:
        strcpy(buf,mastertabs[78]);
	break;
      case 2:
	strcpy(buf,mastertabs[79]);
	break;
      case 3:
	strcpy(buf,mastertabs[80]);
	break;
      case 4:
	strcpy(buf,mastertabs[81]);
	break;
      case 5:
	strcpy(buf,mastertabs[82]);
	break;
      case 6:
	strcpy(buf,mastertabs[83]);
	break;
      case 7:
	strcpy(buf,mastertabs[84]);
	break;
      }
    write_master(buf);

    if (Macro_exist)
    {
/*	    switch (n_menu) {
		case 6:
		    Fff = Gel_Global.Threshold_Height;
		    Param2f = get_2_floats(paneltabs[181],
					   paneltabs[182],
					   paneltabs[183],
					    &Fff, &Gel_Global.Threshold_Area);
		    break;
		case 5:
		    if ( !flag_creer &&((Gel_Global.N_Bandes < 1) ||
			(Gel_Global.N_Bandes > MAX_BANDES)))
		    {
			write_erreur(950);
			break;
		    }
		    mati = get_N_floats(paneltabs[184], paneltabs[185]);
		    break;
		case 7:
		    fn = fname_panel(paneltabs[185],paneltabs[187],20);
		    if (fn->fpim != NULL)
			fclose(fn->fpim);
		    if (fn->fpdesc != NULL)
			fclose(fn->fpdesc);
		    break;
	    }
*/
/*  voir a faire passer ces differentes valeurs donnees dans les parametres de la fct.*/

    }

    switch (n_menu) {
      case 6:
        Height = (int)((Gel_Global.Threshold_Height - Gel_Global.fMin)/
		       (Gel_Global.fMax - Gel_Global.fMin) * 256.0);
	sprintf(Str_x,paneltabs[188],
		(int)Param2f->reel,Param2f->im);
	write_master(Str_x);
	Gel_Global.Threshold_Height = (int)Param2f->reel;
	Gel_Global.Threshold_Area = Param2f->im;
	sprintf(Str_x,paneltabs[115],
		(int)Gel_Global.Threshold_Height, Gel_Global.Threshold_Area);

	if (Profil_Aff_1 != -1)
	{
	  Pr = Profil_Aff_1;
	  Profil_Aff_1 = -1;
	  Affiche_Profil_1(Pr);
	}
	else {
	  Height = (int)((Gel_Global.Threshold_Height - Gel_Global.fMin)/
			 (Gel_Global.fMax - Gel_Global.fMin) * 256.0);
	}
	break;
      case 1:
	write_master("\n");
	Find_All_Pics();
	break;
      case 2:
	write_master("\n");
	Print_Help(paneltabs[189],paneltabs[190],
		   paneltabs[143],"",paneltabs[130]);
	regime_corr = 52;
	break;
      case 3:
	if ((Gel_Pics_List == NULL) || !Gel_Global.Total_Pics)
	{
	  write_erreur(957);
	  break;
	}
	if (*(Dir_Pics + Profil_Aff_1) == NULL) break;
	regime_corr = 53;
	write_master("\n");
	break;
      case 4:
	if ((Gel_Pics_List == NULL) || !Gel_Global.Total_Pics)
	{
	  write_erreur(957);
	  break;
	}
	if (*(Dir_Pics + Profil_Aff_1) == NULL) break;
	write_master("\n");
	regime_corr = 54;
	break;
      case 5:
	memcpy(Gel_Global.Matiere_1,mati,MAX_BANDES*sizeof(float));
	for (N = 0 ; N < Gel_Global.N_Bandes ; N++)
	{
	  sprintf(Str_x,"\n%f", Gel_Global.Matiere_1[N]);
	  write_master(Str_x);
	}
	write_master("\n");
	if (Profil_Aff_1 != -1)
	sprintf(Str_x,
		"Matiere totale %f",Gel_Global.Matiere_1[Profil_Aff_1]);
	break;
      case 7:
	sprintf(Str_x,"%s\n",fn->filename);
	write_master(Str_x);
	break;
      }
}


/*****************************************************************************/

#undef NO_RAM

#ifdef MY_DEBUG
#undef MY_DEBUG
#endif

